/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.http;

import gnu.inet.http.Cookie;
import gnu.inet.http.CookieManager;
import gnu.inet.http.Request;
import gnu.inet.http.event.ConnectionEvent;
import gnu.inet.http.event.ConnectionListener;
import gnu.inet.http.event.RequestEvent;
import gnu.inet.http.event.RequestListener;
import gnu.inet.util.EmptyX509TrustManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class HTTPConnection {
    public static final int HTTP_PORT = 80;
    public static final int HTTPS_PORT = 443;
    private static final String userAgent = HTTPConnection.initUserAgent();
    protected final String hostname;
    protected final int port;
    protected final boolean secure;
    protected final int connectionTimeout;
    protected final int timeout;
    protected String proxyHostname;
    protected int proxyPort;
    protected int majorVersion;
    protected int minorVersion;
    private final List connectionListeners;
    private final List requestListeners;
    protected Socket socket;
    protected InputStream in;
    protected OutputStream out;
    private Map nonceCounts;
    protected CookieManager cookieManager;

    private static String initUserAgent() {
        try {
            StringBuffer buf = new StringBuffer("inetlib/1.1 (");
            buf.append(System.getProperty("os.name"));
            buf.append("; ");
            buf.append(System.getProperty("os.arch"));
            buf.append("; ");
            buf.append(System.getProperty("user.language"));
            buf.append(")");
            return buf.toString();
        }
        catch (SecurityException e) {
            return "inetlib/1.1";
        }
    }

    public HTTPConnection(String hostname) {
        this(hostname, 80, false, 0, 0);
    }

    public HTTPConnection(String hostname, boolean secure) {
        this(hostname, secure ? 443 : 80, secure, 0, 0);
    }

    public HTTPConnection(String hostname, boolean secure, int connectionTimeout, int timeout) {
        this(hostname, secure ? 443 : 80, secure, connectionTimeout, timeout);
    }

    public HTTPConnection(String hostname, int port) {
        this(hostname, port, false, 0, 0);
    }

    public HTTPConnection(String hostname, int port, boolean secure) {
        this(hostname, port, secure, 0, 0);
    }

    public HTTPConnection(String hostname, int port, boolean secure, int connectionTimeout, int timeout) {
        this.hostname = hostname;
        this.port = port;
        this.secure = secure;
        this.connectionTimeout = connectionTimeout;
        this.timeout = timeout;
        this.minorVersion = 1;
        this.majorVersion = 1;
        this.connectionListeners = Collections.synchronizedList(new ArrayList(4));
        this.requestListeners = Collections.synchronizedList(new ArrayList(4));
    }

    public String getHostName() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String getVersion() {
        return "HTTP/" + this.majorVersion + '.' + this.minorVersion;
    }

    public void setVersion(int majorVersion, int minorVersion) {
        if (majorVersion != 1) {
            throw new IllegalArgumentException("major version not supported: " + majorVersion);
        }
        if (minorVersion < 0 || minorVersion > 1) {
            throw new IllegalArgumentException("minor version not supported: " + minorVersion);
        }
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
    }

    public void setProxy(String hostname, int port) {
        this.proxyHostname = hostname;
        this.proxyPort = port;
    }

    public boolean isUsingProxy() {
        return this.proxyHostname != null && this.proxyPort > 0;
    }

    public void setCookieManager(CookieManager cookieManager) {
        this.cookieManager = cookieManager;
    }

    public CookieManager getCookieManager() {
        return this.cookieManager;
    }

    public Request newRequest(String method, String path) {
        Cookie[] cookies;
        if (method == null || method.length() == 0) {
            throw new IllegalArgumentException("method must have non-zero length");
        }
        if (path == null || path.length() == 0) {
            path = "/";
        }
        Request ret = new Request(this, method, path);
        if (this.secure && this.port != 443 || !this.secure && this.port != 80) {
            ret.setHeader("Host", this.hostname + ":" + this.port);
        } else {
            ret.setHeader("Host", this.hostname);
        }
        ret.setHeader("User-Agent", userAgent);
        ret.setHeader("Connection", "keep-alive");
        ret.setHeader("Accept-Encoding", "chunked;q=1.0, gzip;q=0.9, deflate;q=0.8, identity;q=0.6, *;q=0");
        if (this.cookieManager != null && (cookies = this.cookieManager.getCookies(this.hostname, this.secure, path)) != null && cookies.length > 0) {
            StringBuffer buf = new StringBuffer();
            buf.append("$Version=1");
            for (int i = 0; i < cookies.length; ++i) {
                buf.append(',');
                buf.append(' ');
                buf.append(cookies[i].toString());
            }
            ret.setHeader("Cookie", buf.toString());
        }
        this.fireRequestEvent(0, ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.closeConnection();
        }
        finally {
            this.fireConnectionEvent(0);
        }
    }

    protected Socket getSocket() throws IOException {
        if (this.socket == null) {
            String connectHostname = this.hostname;
            int connectPort = this.port;
            if (this.isUsingProxy()) {
                connectHostname = this.proxyHostname;
                connectPort = this.proxyPort;
            }
            this.socket = new Socket();
            InetAddress address = InetAddress.getByName(connectHostname);
            InetSocketAddress socketAddress = new InetSocketAddress(address, connectPort);
            if (this.connectionTimeout > 0) {
                this.socket.connect(socketAddress, this.connectionTimeout);
            } else {
                this.socket.connect(socketAddress);
            }
            if (this.timeout > 0) {
                this.socket.setSoTimeout(this.timeout);
            }
            if (this.secure) {
                try {
                    EmptyX509TrustManager tm = new EmptyX509TrustManager();
                    SSLContext context = SSLContext.getInstance("SSL");
                    TrustManager[] trust = new TrustManager[]{tm};
                    context.init(null, trust, null);
                    SSLSocketFactory factory = context.getSocketFactory();
                    SSLSocket ss = (SSLSocket)factory.createSocket(this.socket, connectHostname, connectPort, true);
                    String[] protocols = new String[]{"TLSv1", "SSLv3"};
                    ss.setEnabledProtocols(protocols);
                    ss.setUseClientMode(true);
                    ss.startHandshake();
                    this.socket = ss;
                }
                catch (GeneralSecurityException e) {
                    throw new IOException(e.getMessage());
                }
            }
            this.in = this.socket.getInputStream();
            this.in = new BufferedInputStream(this.in);
            this.out = this.socket.getOutputStream();
            this.out = new BufferedOutputStream(this.out);
        }
        return this.socket;
    }

    protected InputStream getInputStream() throws IOException {
        if (this.socket == null) {
            this.getSocket();
        }
        return this.in;
    }

    protected OutputStream getOutputStream() throws IOException {
        if (this.socket == null) {
            this.getSocket();
        }
        return this.out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeConnection() throws IOException {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            finally {
                this.socket = null;
            }
        }
    }

    protected String getURI() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.secure ? "https://" : "http://");
        buf.append(this.hostname);
        if (this.secure) {
            if (this.port != 443) {
                buf.append(':');
                buf.append(this.port);
            }
        } else if (this.port != 80) {
            buf.append(':');
            buf.append(this.port);
        }
        return buf.toString();
    }

    int getNonceCount(String nonce) {
        if (this.nonceCounts == null) {
            return 0;
        }
        return (Integer)this.nonceCounts.get(nonce);
    }

    void incrementNonce(String nonce) {
        int current = this.getNonceCount(nonce);
        if (this.nonceCounts == null) {
            this.nonceCounts = new HashMap();
        }
        this.nonceCounts.put(nonce, new Integer(current + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(ConnectionListener l) {
        List list = this.connectionListeners;
        synchronized (list) {
            this.connectionListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionListener(ConnectionListener l) {
        List list = this.connectionListeners;
        synchronized (list) {
            this.connectionListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireConnectionEvent(int type) {
        ConnectionEvent event = new ConnectionEvent(this, type);
        ConnectionListener[] l = null;
        List list = this.connectionListeners;
        synchronized (list) {
            l = new ConnectionListener[this.connectionListeners.size()];
            this.connectionListeners.toArray(l);
        }
        for (int i = 0; i < l.length; ++i) {
            switch (type) {
                case 0: {
                    l[i].connectionClosed(event);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequestListener(RequestListener l) {
        List list = this.requestListeners;
        synchronized (list) {
            this.requestListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRequestListener(RequestListener l) {
        List list = this.requestListeners;
        synchronized (list) {
            this.requestListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireRequestEvent(int type, Request request) {
        RequestEvent event = new RequestEvent(this, type, request);
        RequestListener[] l = null;
        List list = this.requestListeners;
        synchronized (list) {
            l = new RequestListener[this.requestListeners.size()];
            this.requestListeners.toArray(l);
        }
        block8: for (int i = 0; i < l.length; ++i) {
            switch (type) {
                case 0: {
                    l[i].requestCreated(event);
                    continue block8;
                }
                case 1: {
                    l[i].requestSent(event);
                    continue block8;
                }
                case 2: {
                    l[i].requestSent(event);
                }
            }
        }
    }
}

