/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.web.util;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.HtmlFont;
import net.sf.jasperreports.engine.export.HtmlFontUtil;
import net.sf.jasperreports.web.util.FontHtmlResourceHandler;
import net.sf.jasperreports.web.util.WebResourceHandler;
import net.sf.jasperreports.web.util.WebUtil;

public class FontWebResourceHandler
implements WebResourceHandler {
    public static final String REQUEST_PARAMETER_FONT_NAME = "font";

    @Override
    public boolean handleResource(JasperReportsContext jasperReportsContext, HttpServletRequest request, HttpServletResponse response) {
        HtmlFont htmlFont;
        String fontName = request.getParameter(REQUEST_PARAMETER_FONT_NAME);
        if (fontName != null && (htmlFont = HtmlFont.getInstance(jasperReportsContext, fontName)) != null) {
            response.setContentType("text/css");
            try {
                String basePath = this.getResourceBasePath(jasperReportsContext, request);
                byte[] resourceData = this.processFont(basePath, htmlFont);
                response.getOutputStream().write(resourceData);
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
            return true;
        }
        return false;
    }

    protected byte[] processFont(String basePath, HtmlFont htmlFont) {
        FontHtmlResourceHandler resourceHandler = new FontHtmlResourceHandler(basePath, htmlFont);
        HtmlFontUtil.handleFont(resourceHandler, htmlFont);
        return resourceHandler.getFontCss();
    }

    public String getResourceBasePath(JasperReportsContext jasperReportsContext, HttpServletRequest request) {
        return request.getContextPath() + WebUtil.getInstance(jasperReportsContext).getResourcesPath() + "/";
    }
}

