/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.iconlabel;

import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.base.JRBasePrintFrame;
import net.sf.jasperreports.engine.export.GenericElementRtfHandler;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.engine.export.JRRtfExporterContext;

public class IconLabelElementRtfHandler
implements GenericElementRtfHandler {
    private static final IconLabelElementRtfHandler INSTANCE = new IconLabelElementRtfHandler();

    public static IconLabelElementRtfHandler getInstance() {
        return INSTANCE;
    }

    @Override
    public void exportElement(JRRtfExporterContext exporterContext, JRGenericPrintElement element) {
        JRPrintText labelPrintText = (JRPrintText)element.getParameterValue("labelTextElement");
        if (labelPrintText == null) {
            return;
        }
        JRBasePrintFrame frame = new JRBasePrintFrame(element.getDefaultStyleProvider());
        frame.setX(element.getX());
        frame.setY(element.getY());
        frame.setWidth(element.getWidth());
        frame.setHeight(element.getHeight());
        frame.setStyle(element.getStyle());
        frame.setBackcolor(element.getBackcolor());
        frame.setForecolor(element.getForecolor());
        frame.setMode(element.getModeValue());
        JRLineBox lineBox = (JRLineBox)element.getParameterValue("lineBox");
        if (lineBox != null) {
            frame.copyBox(lineBox);
        }
        frame.addElement(labelPrintText);
        try {
            JRRtfExporter exporter = (JRRtfExporter)exporterContext.getExporter();
            exporter.exportFrame(frame);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean toExport(JRGenericPrintElement element) {
        return true;
    }
}

