/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package jp.mosp.time.dto.settings;

import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.platform.dto.base.EmployeeCodeDtoInterface;
import jp.mosp.platform.dto.base.EmployeeNameDtoInterface;
import jp.mosp.platform.dto.base.PersonalIdDtoInterface;
import jp.mosp.platform.dto.base.SectionCodeDtoInterface;

/**
 * 統計情報一覧DTOインターフェース
 */
public interface SubordinateFiscalListDtoInterface extends PersonalIdDtoInterface, EmployeeCodeDtoInterface,
		EmployeeNameDtoInterface, SectionCodeDtoInterface, BaseDtoInterface {
	
	/**
	 * @return 表示年度
	 */
	int getFiscalYear();
	
	/**
	 * @return 対象年
	 */
	int getTargetYear();
	
	/**
	 * @return 対象月
	 */
	int getTargetMonth();
	
	/**
	 * @return 残業時間。
	 */
	Integer getOverTime();
	
	/**
	 * @return 普休始(日)。
	 */
	Double getPaidHolidayDays();
	
	/**
	 * @return 普休始(時間)。
	 */
	Integer getPaidHolidayTime();
	
	/**
	 * @return 普休残(日)。
	 */
	Double getPaidHolidayRestDays();
	
	/**
	 * @return 普休残(時間)。
	 */
	Integer getPaidHolidayRestTime();
	
	/**
	 * @return 保休始。
	 */
	Double getStockHolidayDays();
	
	/**
	 * @return 保休残。
	 */
	Double getStockHolidayRestDays();
	
	/**
	 * @return 季休始。
	 */
	Double getSeasonHolidayDays();
	
	/**
	 * @return 季休残。
	 */
	Double getSeasonHolidayRestDays();
	
	/**
	 * @param fiscalYear 表示年度
	 */
	void setFiscalYear(int fiscalYear);
	
	/**
	 * @param targetYear 対象年
	 */
	void setTargetYear(int targetYear);
	
	/**
	 * @param targetMonth 対象月
	 */
	void setTargetMonth(int targetMonth);
	
	/**
	 * @param overTime 残業時間
	 */
	void setOverTime(Integer overTime);
	
	/**
	 * @param paidHolidayDays 普休始(日)。
	 */
	void setPaidHolidayDays(Double paidHolidayDays);
	
	/**
	 * @param paidHolidayTime 普休始(時間)。
	 */
	void setPaidHolidayTime(Integer paidHolidayTime);
	
	/**
	 * @param paidHolidayRestDays 普休残(日)。
	 */
	void setPaidHolidayRestDays(Double paidHolidayRestDays);
	
	/**
	 * @param paidHolidayRestTime 普休残(時間)。
	 */
	void setPaidHolidayRestTime(Integer paidHolidayRestTime);
	
	/**
	 * @param stockHolidayDays 保休始。
	 */
	void setStockHolidayDays(Double stockHolidayDays);
	
	/**
	 * @param stockHolidayRestDays 保休残。
	 */
	void setStockHolidayRestDays(Double stockHolidayRestDays);
	
	/**
	 * @param seasonHolidayDays 季休始。
	 */
	void setSeasonHolidayDays(Double seasonHolidayDays);
	
	/**
	 * @param seasonHolidayRestDays 季休残。
	 */
	void setSeasonHolidayRestDays(Double seasonHolidayRestDays);
}
