/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.nntp;

import gnu.inet.nntp.ActiveTimesIterator;
import gnu.inet.nntp.ArticleNumberIterator;
import gnu.inet.nntp.ArticleResponse;
import gnu.inet.nntp.ArticleStream;
import gnu.inet.nntp.GroupIterator;
import gnu.inet.nntp.GroupResponse;
import gnu.inet.nntp.HeaderIterator;
import gnu.inet.nntp.LineIterator;
import gnu.inet.nntp.NNTPConstants;
import gnu.inet.nntp.NNTPException;
import gnu.inet.nntp.OverviewIterator;
import gnu.inet.nntp.PairIterator;
import gnu.inet.nntp.PendingData;
import gnu.inet.nntp.PostStream;
import gnu.inet.nntp.Range;
import gnu.inet.nntp.StatusResponse;
import gnu.inet.util.CRLFInputStream;
import gnu.inet.util.CRLFOutputStream;
import gnu.inet.util.LineInputStream;
import gnu.inet.util.MessageInputStream;
import gnu.inet.util.SaslCallbackHandler;
import gnu.inet.util.SaslInputStream;
import gnu.inet.util.SaslOutputStream;
import gnu.inet.util.TraceLevel;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Socket;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;

public class NNTPConnection
implements NNTPConstants {
    public static final Logger logger = Logger.getLogger("gnu.inet.nntp");
    public static final Level NNTP_TRACE = new TraceLevel("nntp");
    public static final int DEFAULT_PORT = 119;
    protected String hostname;
    protected int port;
    protected Socket socket;
    protected LineInputStream in;
    protected CRLFOutputStream out;
    protected boolean canPost;
    protected String welcome;
    protected PendingData pendingData;
    private static final String DOT = ".";
    private static final String US_ASCII = "US-ASCII";

    public NNTPConnection(String hostname) throws IOException {
        this(hostname, 119, 0, 0);
    }

    public NNTPConnection(String hostname, int port) throws IOException {
        this(hostname, port, 0, 0);
    }

    public NNTPConnection(String hostname, int port, int connectionTimeout, int timeout) throws IOException {
        if (port < 0) {
            port = 119;
        }
        this.hostname = hostname;
        this.port = port;
        this.socket = new Socket();
        InetSocketAddress address = new InetSocketAddress(hostname, port);
        if (connectionTimeout > 0) {
            this.socket.connect(address, connectionTimeout);
        } else {
            this.socket.connect(address);
        }
        if (timeout > 0) {
            this.socket.setSoTimeout(timeout);
        }
        InputStream in = this.socket.getInputStream();
        in = new CRLFInputStream(in);
        this.in = new LineInputStream(in);
        OutputStream out = this.socket.getOutputStream();
        out = new BufferedOutputStream(out);
        this.out = new CRLFOutputStream(out);
        StatusResponse response = this.parseResponse(this.read());
        switch (response.status) {
            case 200: {
                this.canPost = true;
            }
            case 201: {
                this.welcome = response.getMessage();
                break;
            }
            default: {
                throw new NNTPException(response);
            }
        }
    }

    public String getWelcome() {
        return this.welcome;
    }

    String formatDate(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyMMdd HHmmss 'GMT'");
        GregorianCalendar cal = new GregorianCalendar();
        TimeZone gmt = TimeZone.getTimeZone("GMT");
        ((Calendar)cal).setTimeZone(gmt);
        df.setCalendar(cal);
        cal.setTime(date);
        return df.format(date);
    }

    Date parseDate(String text) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat("yyMMdd HHmmss 'GMT'");
        return df.parse(text);
    }

    public ArticleResponse article(int articleNumber) throws IOException {
        return this.articleImpl("ARTICLE", Integer.toString(articleNumber));
    }

    public ArticleResponse article(String messageId) throws IOException {
        return this.articleImpl("ARTICLE", messageId);
    }

    public ArticleResponse head(int articleNumber) throws IOException {
        return this.articleImpl("HEAD", Integer.toString(articleNumber));
    }

    public ArticleResponse head(String messageId) throws IOException {
        return this.articleImpl("HEAD", messageId);
    }

    public ArticleResponse body(int articleNumber) throws IOException {
        return this.articleImpl("BODY", Integer.toString(articleNumber));
    }

    public ArticleResponse body(String messageId) throws IOException {
        return this.articleImpl("BODY", messageId);
    }

    public ArticleResponse stat(int articleNumber) throws IOException {
        return this.articleImpl("STAT", Integer.toString(articleNumber));
    }

    public ArticleResponse stat(String messageId) throws IOException {
        return this.articleImpl("STAT", messageId);
    }

    protected ArticleResponse articleImpl(String command, String messageId) throws IOException {
        if (messageId != null) {
            StringBuffer line = new StringBuffer(command);
            line.append(' ');
            line.append(messageId);
            this.send(line.toString());
        } else {
            this.send(command);
        }
        StatusResponse response = this.parseResponse(this.read());
        switch (response.status) {
            case 220: 
            case 221: 
            case 222: {
                ArticleResponse aresponse = (ArticleResponse)response;
                ArticleStream astream = new ArticleStream(new MessageInputStream(this.in));
                this.pendingData = astream;
                aresponse.in = astream;
                return aresponse;
            }
            case 223: {
                return (ArticleResponse)response;
            }
        }
        throw new NNTPException(response);
    }

    public GroupResponse group(String name) throws IOException {
        this.send("GROUP " + name);
        StatusResponse response = this.parseResponse(this.read());
        switch (response.status) {
            case 211: {
                return (GroupResponse)response;
            }
        }
        throw new NNTPException(response);
    }

    public LineIterator help() throws IOException {
        this.send("HELP");
        StatusResponse response = this.parseResponse(this.read());
        switch (response.status) {
            case 100: {
                LineIterator li = new LineIterator(this);
                this.pendingData = li;
                return li;
            }
        }
        throw new NNTPException(response);
    }

    public PostStream ihave(String messageId) throws IOException {
        this.send("IHAVE " + messageId);
        StatusResponse response = this.parseResponse(this.read());
        switch (response.status) {
            case 335: {
                return new PostStream(this, false);
            }
            case 435: {
                return null;
            }
        }
        throw new NNTPException(response);
    }

    public ArticleResponse last() throws IOException {
        return this.articleImpl("LAST", null);
    }

    public GroupIterator list() throws IOException {
        return this.listImpl("LIST");
    }

    GroupIterator listImpl(String command) throws IOException {
        this.send(command);
        StatusResponse response = this.parseResponse(this.read());
        switch (response.status) {
            case 215: {
                GroupIterator gi = new GroupIterator(this);
                this.pendingData = gi;
                return gi;
            }
        }
        throw new NNTPException(response);
    }

    public LineIterator newGroups(Date since, String[] distributions) throws IOException {
        StringBuffer buffer = new StringBuffer("NEWGROUPS");
        buffer.append(' ');
        buffer.append(this.formatDate(since));
        if (distributions != null) {
            buffer.append(' ');
            for (int i = 0; i < distributions.length; ++i) {
                if (i > 0) {
                    buffer.append(',');
                }
                buffer.append(distributions[i]);
            }
        }
        this.send(buffer.toString());
        StatusResponse response = this.parseResponse(this.read());
        switch (response.status) {
            case 231: {
                LineIterator li = new LineIterator(this);
                this.pendingData = li;
                return li;
            }
        }
        throw new NNTPException(response);
    }

    public LineIterator newNews(String newsgroup, Date since, String[] distributions) throws IOException {
        StringBuffer buffer = new StringBuffer("NEWNEWS");
        buffer.append(' ');
        buffer.append(newsgroup);
        buffer.append(' ');
        buffer.append(this.formatDate(since));
        if (distributions != null) {
            buffer.append(' ');
            for (int i = 0; i < distributions.length; ++i) {
                if (i > 0) {
                    buffer.append(',');
                }
                buffer.append(distributions[i]);
            }
        }
        this.send(buffer.toString());
        StatusResponse response = this.parseResponse(this.read());
        switch (response.status) {
            case 230: {
                LineIterator li = new LineIterator(this);
                this.pendingData = li;
                return li;
            }
        }
        throw new NNTPException(response);
    }

    public ArticleResponse next() throws IOException {
        return this.articleImpl("NEXT", null);
    }

    public OutputStream post() throws IOException {
        this.send("POST");
        StatusResponse response = this.parseResponse(this.read());
        switch (response.status) {
            case 340: {
                return new PostStream(this, false);
            }
        }
        throw new NNTPException(response);
    }

    void postComplete() throws IOException {
        this.send(DOT);
        StatusResponse response = this.parseResponse(this.read());
        switch (response.status) {
            case 235: 
            case 240: {
                return;
            }
        }
        throw new NNTPException(response);
    }

    public void quit() throws IOException {
        this.send("QUIT");
        StatusResponse response = this.parseResponse(this.read());
        switch (response.status) {
            case 205: {
                this.socket.close();
                return;
            }
        }
        throw new NNTPException(response);
    }

    public void slave() throws IOException {
        this.send("SLAVE");
        StatusResponse response = this.parseResponse(this.read());
        switch (response.status) {
            case 202: {
                break;
            }
            default: {
                throw new NNTPException(response);
            }
        }
    }

    public boolean check(String messageId) throws IOException {
        StringBuffer buffer = new StringBuffer("CHECK");
        buffer.append(' ');
        buffer.append(messageId);
        this.send(buffer.toString());
        StatusResponse response = this.parseResponse(this.read());
        switch (response.status) {
            case 238: {
                return true;
            }
            case 438: {
                return false;
            }
        }
        throw new NNTPException(response);
    }

    public boolean modeStream() throws IOException {
        this.send("MODE STREAM");
        StatusResponse response = this.parseResponse(this.read());
        switch (response.status) {
            case 203: {
                return true;
            }
        }
        return false;
    }

    public OutputStream takethis(String messageId) throws IOException {
        this.send("TAKETHIS " + messageId);
        return new PostStream(this, true);
    }

    void takethisComplete() throws IOException {
        this.send(DOT);
        StatusResponse response = this.parseResponse(this.read());
        switch (response.status) {
            case 239: {
                return;
            }
        }
        throw new NNTPException(response);
    }

    public GroupIterator listActive(String wildmat) throws IOException {
        StringBuffer buffer = new StringBuffer("LIST ACTIVE");
        if (wildmat != null) {
            buffer.append(' ');
            buffer.append(wildmat);
        }
        return this.listImpl(buffer.toString());
    }

    public ActiveTimesIterator listActiveTimes() throws IOException {
        this.send("LIST ACTIVE.TIMES");
        StatusResponse response = this.parseResponse(this.read());
        switch (response.status) {
            case 215: {
                return new ActiveTimesIterator(this);
            }
        }
        throw new NNTPException(response);
    }

    public PairIterator listNewsgroups(String wildmat) throws IOException {
        StringBuffer buffer = new StringBuffer("LIST NEWSGROUPS");
        if (wildmat != null) {
            buffer.append(' ');
            buffer.append(wildmat);
        }
        this.send(buffer.toString());
        StatusResponse response = this.parseResponse(this.read());
        switch (response.status) {
            case 215: {
                PairIterator pi = new PairIterator(this);
                this.pendingData = pi;
                return pi;
            }
        }
        throw new NNTPException(response);
    }

    public LineIterator listOverviewFmt() throws IOException {
        this.send("LIST OVERVIEW.FMT");
        StatusResponse response = this.parseResponse(this.read());
        switch (response.status) {
            case 215: {
                LineIterator li = new LineIterator(this);
                this.pendingData = li;
                return li;
            }
        }
        throw new NNTPException(response);
    }

    public GroupIterator listSubscriptions() throws IOException {
        return this.listImpl("LIST SUBSCRIPTIONS");
    }

    public ArticleNumberIterator listGroup(String group) throws IOException {
        StringBuffer buffer = new StringBuffer("LISTGROUP");
        if (group != null) {
            buffer.append(' ');
            buffer.append(group);
        }
        this.send(buffer.toString());
        StatusResponse response = this.parseResponse(this.read(), true);
        switch (response.status) {
            case 211: {
                ArticleNumberIterator ani = new ArticleNumberIterator(this);
                this.pendingData = ani;
                return ani;
            }
        }
        throw new NNTPException(response);
    }

    public boolean modeReader() throws IOException {
        this.send("MODE READER");
        StatusResponse response = this.parseResponse(this.read());
        switch (response.status) {
            case 200: {
                this.canPost = true;
                return this.canPost;
            }
            case 440: {
                this.canPost = false;
                return this.canPost;
            }
        }
        throw new NNTPException(response);
    }

    public PairIterator xgtitle(String wildmat) throws IOException {
        StringBuffer buffer = new StringBuffer("XGTITLE");
        if (wildmat != null) {
            buffer.append(' ');
            buffer.append(wildmat);
        }
        this.send(buffer.toString());
        StatusResponse response = this.parseResponse(this.read());
        switch (response.status) {
            case 481: {
                PairIterator pi = new PairIterator(this);
                this.pendingData = pi;
                return pi;
            }
        }
        throw new NNTPException(response);
    }

    public HeaderIterator xhdr(String header, String range) throws IOException {
        StringBuffer buffer = new StringBuffer("XHDR");
        buffer.append(' ');
        buffer.append(header);
        if (range != null) {
            buffer.append(' ');
            buffer.append(range);
        }
        this.send(buffer.toString());
        StatusResponse response = this.parseResponse(this.read());
        switch (response.status) {
            case 221: {
                HeaderIterator hi = new HeaderIterator(this);
                this.pendingData = hi;
                return hi;
            }
        }
        throw new NNTPException(response);
    }

    public OverviewIterator xover(Range range) throws IOException {
        StringBuffer buffer = new StringBuffer("XOVER");
        if (range != null) {
            buffer.append(' ');
            buffer.append(range.toString());
        }
        this.send(buffer.toString());
        StatusResponse response = this.parseResponse(this.read());
        switch (response.status) {
            case 224: {
                OverviewIterator oi = new OverviewIterator(this);
                this.pendingData = oi;
                return oi;
            }
        }
        throw new NNTPException(response);
    }

    public boolean authinfo(String username, String password) throws IOException {
        StringBuffer buffer = new StringBuffer("AUTHINFO USER");
        buffer.append(' ');
        buffer.append(username);
        this.send(buffer.toString());
        StatusResponse response = this.parseResponse(this.read());
        switch (response.status) {
            case 281: {
                return true;
            }
            case 381: {
                buffer.setLength(0);
                buffer.append("AUTHINFO PASS");
                buffer.append(' ');
                buffer.append(password);
                this.send(buffer.toString());
                response = this.parseResponse(this.read());
                switch (response.status) {
                    case 281: {
                        return true;
                    }
                    case 502: {
                        return false;
                    }
                }
                throw new NNTPException(response);
            }
        }
        throw new NNTPException(response);
    }

    public boolean authinfoSimple(String username, String password) throws IOException {
        this.send("AUTHINFO SIMPLE");
        StatusResponse response = this.parseResponse(this.read());
        switch (response.status) {
            case 350: {
                StringBuffer buffer = new StringBuffer(username);
                buffer.append(' ');
                buffer.append(password);
                this.send(buffer.toString());
                response = this.parseResponse(this.read());
                switch (response.status) {
                    case 350: {
                        return true;
                    }
                    case 452: {
                        return false;
                    }
                }
                throw new NNTPException(response);
            }
        }
        throw new NNTPException(response);
    }

    public boolean authinfoGeneric(String mechanism, String username, String password) throws IOException {
        String[] m = new String[]{mechanism};
        SaslCallbackHandler ch = new SaslCallbackHandler(username, password);
        HashMap<String, String> p = new HashMap<String, String>();
        p.put("gnu.crypto.sasl.username", username);
        p.put("gnu.crypto.sasl.password", password);
        SaslClient sasl = Sasl.createSaslClient(m, null, "smtp", this.socket.getInetAddress().getHostName(), p, ch);
        if (sasl == null) {
            return false;
        }
        StringBuffer cmd = new StringBuffer("AUTHINFO GENERIC");
        cmd.append(' ');
        cmd.append(mechanism);
        if (sasl.hasInitialResponse()) {
            cmd.append(' ');
            byte[] init = sasl.evaluateChallenge(new byte[0]);
            cmd.append(new String(init, US_ASCII));
        }
        this.send(cmd.toString());
        StatusResponse response = this.parseResponse(this.read());
        switch (response.status) {
            case 281: {
                String qop = (String)sasl.getNegotiatedProperty("javax.security.sasl.qop");
                if ("auth-int".equalsIgnoreCase(qop) || "auth-conf".equalsIgnoreCase(qop)) {
                    InputStream in = this.socket.getInputStream();
                    in = new BufferedInputStream(in);
                    in = new SaslInputStream(sasl, in);
                    in = new CRLFInputStream(in);
                    this.in = new LineInputStream(in);
                    OutputStream out = this.socket.getOutputStream();
                    out = new BufferedOutputStream(out);
                    out = new SaslOutputStream(sasl, out);
                    this.out = new CRLFOutputStream(out);
                }
                return true;
            }
            case 502: {
                return false;
            }
        }
        throw new NNTPException(response);
    }

    public Date date() throws IOException {
        this.send("DATE");
        StatusResponse response = this.parseResponse(this.read());
        switch (response.status) {
            case 111: {
                String message = response.getMessage();
                try {
                    SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
                    return df.parse(message);
                }
                catch (ParseException e) {
                    throw new IOException("Invalid date: " + message);
                }
            }
        }
        throw new NNTPException(response);
    }

    protected StatusResponse parseResponse(String line) throws ProtocolException {
        return this.parseResponse(line, false);
    }

    protected StatusResponse parseResponse(String line, boolean isListGroup) throws ProtocolException {
        StatusResponse response;
        if (line == null) {
            throw new ProtocolException(this.hostname + " closed connection");
        }
        int start = 0;
        short status = -1;
        String statusText = line;
        String message = null;
        int end = line.indexOf(32, start);
        if (end > start) {
            statusText = line.substring(start, end);
            message = line.substring(end + 1);
        }
        try {
            status = Short.parseShort(statusText);
        }
        catch (NumberFormatException e) {
            throw new ProtocolException(line);
        }
        switch (status) {
            case 211: 
            case 220: 
            case 221: 
            case 222: 
            case 223: {
                if (status != 211 || isListGroup) {
                    try {
                        ArticleResponse aresponse = new ArticleResponse(status, message);
                        start = end + 1;
                        end = line.indexOf(32, start);
                        if (end > start) {
                            aresponse.articleNumber = Integer.parseInt(line.substring(start, end));
                        }
                        aresponse.messageId = (end = line.indexOf(32, start = end + 1)) > start ? line.substring(start, end) : line.substring(start);
                        response = aresponse;
                    }
                    catch (NumberFormatException e) {
                        response = new StatusResponse(status, message);
                    }
                    break;
                }
                GroupResponse gresponse = new GroupResponse(status, message);
                try {
                    start = end + 1;
                    end = line.indexOf(32, start);
                    if (end > start) {
                        gresponse.count = Integer.parseInt(line.substring(start, end));
                    }
                    if ((end = line.indexOf(32, start = end + 1)) > start) {
                        gresponse.first = Integer.parseInt(line.substring(start, end));
                    }
                    if ((end = line.indexOf(32, start = end + 1)) > start) {
                        gresponse.last = Integer.parseInt(line.substring(start, end));
                    }
                    gresponse.group = (end = line.indexOf(32, start = end + 1)) > start ? line.substring(start, end) : line.substring(start);
                }
                catch (NumberFormatException e) {
                    throw new ProtocolException(line);
                }
                response = gresponse;
                break;
            }
            default: {
                response = new StatusResponse(status, message);
            }
        }
        return response;
    }

    protected void send(String line) throws IOException {
        if (this.pendingData != null) {
            this.pendingData.readToEOF();
            this.pendingData = null;
        }
        logger.log(NNTP_TRACE, ">" + line);
        byte[] data = line.getBytes(US_ASCII);
        this.out.write(data);
        this.out.writeln();
        this.out.flush();
    }

    protected String read() throws IOException {
        String line = this.in.readLine();
        if (line == null) {
            logger.log(NNTP_TRACE, "<EOF");
        } else {
            logger.log(NNTP_TRACE, "<" + line);
        }
        return line;
    }
}

