/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.ldap;

import gnu.inet.ldap.AttributeValues;
import gnu.inet.ldap.BERDecoder;
import gnu.inet.ldap.BEREncoder;
import gnu.inet.ldap.BERException;
import gnu.inet.ldap.LDAPResult;
import gnu.inet.ldap.Modification;
import gnu.inet.ldap.ResultHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.naming.ldap.Control;

public class LDAPConnection {
    public static final int DEFAULT_PORT = 389;
    public static final int SCOPE_BASE_OBJECT = 0;
    public static final int SCOPE_SINGLE_LEVEL = 1;
    public static final int SCOPE_WHOLE_SUBTREE = 2;
    public static final int DEREF_NEVER = 0;
    public static final int DEREF_IN_SEARCHING = 1;
    public static final int DEREF_FINDING_BASE_OBJ = 2;
    public static final int DEREF_ALWAYS = 3;
    private static final int SUCCESS = 0;
    private static final int SASL_BIND_IN_PROGRESS = 14;
    private static final int MESSAGE = 48;
    private static final int BIND_REQUEST = 96;
    private static final int BIND_RESPONSE = 97;
    private static final int UNBIND_REQUEST = 98;
    private static final int SEARCH_REQUEST = 99;
    private static final int SEARCH_RESULT = 100;
    private static final int SEARCH_RESULT_DONE = 101;
    private static final int MODIFY_REQUEST = 102;
    private static final int MODIFY_RESPONSE = 103;
    private static final int ADD_REQUEST = 104;
    private static final int ADD_RESPONSE = 105;
    private static final int DELETE_REQUEST = 106;
    private static final int DELETE_RESPONSE = 107;
    private static final int MODIFY_DN_REQUEST = 108;
    private static final int MODIFY_DN_RESPONSE = 109;
    private static final int SEARCH_REFERENCE = 115;
    protected String host;
    protected int port;
    protected int version;
    private Socket socket;
    private InputStream in;
    private OutputStream out;
    private int messageId;
    private Map asyncResponses;

    public LDAPConnection(String host) throws IOException {
        this(host, 389, 0, 0);
    }

    public LDAPConnection(String host, int port) throws IOException {
        this(host, port, 0, 0);
    }

    public LDAPConnection(String host, int port, int connectionTimeout, int timeout) throws IOException {
        this.host = host;
        if (port < 0) {
            port = 389;
        }
        this.port = port;
        this.messageId = 0;
        this.asyncResponses = new HashMap();
        this.version = 3;
        this.socket = new Socket();
        InetSocketAddress address = new InetSocketAddress(host, port);
        if (connectionTimeout > 0) {
            this.socket.connect(address, connectionTimeout);
        } else {
            this.socket.connect(address);
        }
        this.in = new BufferedInputStream(this.socket.getInputStream());
        this.out = new BufferedOutputStream(this.socket.getOutputStream());
    }

    public void setVersion(int version) {
        if (version < 2 || version > 3) {
            throw new IllegalArgumentException(Integer.toString(version));
        }
        this.version = version;
    }

    public LDAPResult bind(String name, String mechanism, byte[] credentials, Control[] controls) throws IOException {
        int id = this.messageId++;
        boolean utf8 = this.version == 3;
        BEREncoder bind = new BEREncoder(utf8);
        if (mechanism == null) {
            bind.append(this.version);
            bind.append(name);
            if (credentials != null) {
                bind.append(credentials);
            }
        } else {
            bind.append(this.version);
            bind.append(name);
            BEREncoder saslCredentials = new BEREncoder(utf8);
            saslCredentials.append(mechanism);
            if (credentials != null) {
                saslCredentials.append(credentials);
            }
            bind.append(saslCredentials.toByteArray(), 16);
        }
        BEREncoder ctls = new BEREncoder(utf8);
        if (controls != null) {
            for (int i = 0; i < controls.length; ++i) {
                ctls.append(this.controlSequence(controls[i], utf8), 16);
            }
        }
        bind.append(ctls.toByteArray(), 128);
        this.write(id, 96, bind.toByteArray());
        BERDecoder response = this.read(id);
        BERDecoder resultSequence = response.parseSequence(97);
        LDAPResult result = this.parseResult(resultSequence);
        if (resultSequence.available()) {
            byte[] serverCreds = resultSequence.parseOctetString();
        }
        return result;
    }

    public void unbind() throws IOException {
        int id = this.messageId++;
        boolean utf8 = this.version == 3;
        BEREncoder unbind = new BEREncoder(utf8);
        unbind.appendNull();
        this.write(id, 98, unbind.toByteArray());
        this.socket.close();
    }

    public LDAPResult search(String name, int scope, int derefAliases, int sizeLimit, int timeLimit, boolean typesOnly, String filter, String[] attributes, Control[] controls, ResultHandler handler) throws IOException {
        int code;
        if (filter == null || filter.length() == 0) {
            filter = "(objectClass=*)";
        }
        int id = this.messageId++;
        boolean utf8 = this.version == 3;
        BEREncoder search = new BEREncoder(utf8);
        search.append(name);
        search.append(scope, 10);
        search.append(derefAliases, 10);
        search.append(sizeLimit);
        search.append(timeLimit);
        search.append(typesOnly);
        search.appendFilter(filter);
        BEREncoder attributeSequence = new BEREncoder(utf8);
        if (attributes != null) {
            for (int i = 0; i < attributes.length; ++i) {
                attributeSequence.append(attributes[i]);
            }
        }
        search.append(attributeSequence.toByteArray(), 16);
        BEREncoder ctls = new BEREncoder(utf8);
        if (controls != null) {
            for (int i = 0; i < controls.length; ++i) {
                ctls.append(this.controlSequence(controls[i], utf8), 16);
            }
        }
        search.append(ctls.toByteArray(), 16);
        this.write(id, 99, search.toByteArray());
        block13: while (true) {
            BERDecoder response = this.read(id);
            code = response.parseType();
            switch (code) {
                case 100: {
                    BERDecoder entry = response.parseSequence(code);
                    String objectName = entry.parseString();
                    BERDecoder attributeSeq = entry.parseSequence(48);
                    TreeMap attrs = new TreeMap();
                    while (attributeSeq.available()) {
                        BERDecoder attribute = attributeSeq.parseSequence(48);
                        String type = attribute.parseString();
                        BERDecoder values = attribute.parseSet(49);
                        ArrayList<Object> acc = new ArrayList<Object>();
                        while (values.available()) {
                            int valueType = values.parseType();
                            switch (valueType) {
                                case 1: {
                                    acc.add(values.parseBoolean());
                                    break;
                                }
                                case 2: 
                                case 10: {
                                    acc.add(new Integer(values.parseInt()));
                                    break;
                                }
                                case 12: {
                                    acc.add(values.parseString());
                                    break;
                                }
                                case 4: {
                                    acc.add(values.parseOctetString());
                                }
                            }
                        }
                        attrs.put(type, acc);
                    }
                    handler.searchResultEntry(objectName, attrs);
                    continue block13;
                }
                case 115: {
                    ArrayList<String> acc = new ArrayList<String>();
                    BERDecoder urls = response.parseSequence(code);
                    while (urls.available()) {
                        acc.add(urls.parseString());
                    }
                    handler.searchResultReference(acc);
                    continue block13;
                }
                case 101: {
                    return this.parseResult(response.parseSequence(code));
                }
            }
            break;
        }
        throw new ProtocolException("Unexpected response: " + code);
    }

    public LDAPResult modify(String name, Modification[] modifications) throws IOException {
        int id = this.messageId++;
        boolean utf8 = this.version == 3;
        BEREncoder modify = new BEREncoder(utf8);
        modify.append(name);
        BEREncoder modSeq = new BEREncoder(utf8);
        for (int i = 0; i < modifications.length; ++i) {
            BEREncoder mod = new BEREncoder(utf8);
            mod.append(modifications[i].operation);
            BEREncoder typeAndValues = new BEREncoder(utf8);
            typeAndValues.append(modifications[i].type);
            BEREncoder values = new BEREncoder(utf8);
            this.appendValues(values, modifications[i].values);
            typeAndValues.append(values.toByteArray(), 17);
            mod.append(typeAndValues.toByteArray(), 16);
            modSeq.append(mod.toByteArray(), 16);
        }
        modify.append(modSeq.toByteArray(), 16);
        this.write(id, 102, modify.toByteArray());
        BERDecoder response = this.read(id);
        BERDecoder resultSequence = response.parseSequence(103);
        LDAPResult result = this.parseResult(resultSequence);
        return result;
    }

    public LDAPResult add(String name, AttributeValues[] attributes) throws IOException {
        int id = this.messageId++;
        boolean utf8 = this.version == 3;
        BEREncoder add = new BEREncoder(utf8);
        add.append(name);
        BEREncoder attrSeq = new BEREncoder(utf8);
        for (int i = 0; i < attributes.length; ++i) {
            BEREncoder attr = new BEREncoder(utf8);
            attr.append(attributes[i].type);
            BEREncoder values = new BEREncoder(utf8);
            this.appendValues(values, attributes[i].values);
            attr.append(values.toByteArray(), 17);
            attrSeq.append(attr.toByteArray(), 16);
        }
        add.append(attrSeq.toByteArray(), 16);
        this.write(id, 104, add.toByteArray());
        BERDecoder response = this.read(id);
        BERDecoder resultSequence = response.parseSequence(105);
        LDAPResult result = this.parseResult(resultSequence);
        return result;
    }

    public LDAPResult delete(String name) throws IOException {
        int id = this.messageId++;
        boolean utf8 = this.version == 3;
        BEREncoder del = new BEREncoder(utf8);
        del.append(name);
        this.write(id, 106, del.toByteArray());
        BERDecoder response = this.read(id);
        int code = response.parseType();
        if (code != 107) {
            throw new ProtocolException("Unexpected response type: " + code);
        }
        BERDecoder resultSequence = response.parseSequence();
        LDAPResult result = this.parseResult(resultSequence);
        return result;
    }

    public LDAPResult modifyDN(String name, String newRDN, boolean deleteOldRDN, String newSuperior) throws IOException {
        int id = this.messageId++;
        boolean utf8 = this.version == 3;
        BEREncoder modifyDN = new BEREncoder(utf8);
        modifyDN.append(name);
        modifyDN.append(newRDN);
        modifyDN.append(deleteOldRDN);
        if (newSuperior != null) {
            modifyDN.append(newSuperior);
        }
        this.write(id, 108, modifyDN.toByteArray());
        BERDecoder response = this.read(id);
        BERDecoder resultSequence = response.parseSequence(109);
        LDAPResult result = this.parseResult(resultSequence);
        return result;
    }

    void appendValues(BEREncoder encoder, Set values) throws BERException {
        if (values != null) {
            for (Object value : values) {
                if (value == null) {
                    encoder.appendNull();
                    continue;
                }
                if (value instanceof String) {
                    encoder.append((String)value);
                    continue;
                }
                if (value instanceof Integer) {
                    encoder.append((Integer)value);
                    continue;
                }
                if (value instanceof Boolean) {
                    encoder.append((Boolean)value);
                    continue;
                }
                if (value instanceof byte[]) {
                    encoder.append((byte[])value);
                    continue;
                }
                throw new ClassCastException(value.getClass().getName());
            }
        }
    }

    byte[] controlSequence(Control control, boolean utf8) throws IOException {
        BEREncoder encoder = new BEREncoder(utf8);
        encoder.append(control.getID());
        if (control.isCritical()) {
            encoder.append(true);
        }
        return encoder.toByteArray();
    }

    LDAPResult parseResult(BERDecoder response) throws IOException {
        int type;
        int status = response.parseInt();
        String matchingDN = response.parseString();
        String errorMessage = response.parseString();
        String[] referrals = null;
        if (response.available() && (type = response.parseType()) == 16) {
            ArrayList<String> list = new ArrayList<String>();
            BERDecoder sequence = response.parseSequence();
            type = sequence.parseType();
            while (type != -1) {
                list.add(sequence.parseString());
            }
            referrals = new String[list.size()];
            list.toArray(referrals);
        }
        return new LDAPResult(status, matchingDN, errorMessage, referrals);
    }

    void write(int id, int code, byte[] request) throws IOException {
        boolean utf8 = this.version == 3;
        BEREncoder envelope = new BEREncoder(utf8);
        envelope.append(id);
        envelope.append(request, code);
        BEREncoder message = new BEREncoder(utf8);
        message.append(envelope.toByteArray(), 48);
        byte[] toSend = message.toByteArray();
        this.out.write(toSend);
        this.out.flush();
    }

    BERDecoder read(int id) throws IOException {
        Integer key = new Integer(id);
        List<BERDecoder> responses = (ArrayList<BERDecoder>)this.asyncResponses.get(key);
        if (responses != null) {
            BERDecoder response = (BERDecoder)responses.remove(0);
            if (responses.size() == 0) {
                this.asyncResponses.remove(key);
            }
            return response;
        }
        while (true) {
            byte[] bytes = this.readMessage();
            boolean utf8 = this.version == 3;
            BERDecoder message = new BERDecoder(bytes, utf8);
            int msgId = (message = message.parseSequence(48)).parseInt();
            if (msgId == id) {
                return message;
            }
            key = new Integer(msgId);
            responses = (List)this.asyncResponses.get(key);
            if (responses == null) {
                responses = new ArrayList<BERDecoder>();
                this.asyncResponses.put(key, responses);
            }
            responses.add(message);
        }
    }

    byte[] readMessage() throws IOException {
        int l;
        byte[] header = new byte[6];
        int offset = 0;
        header[offset++] = (byte)this.readByte();
        int len = this.readByte();
        header[offset++] = (byte)len;
        if ((len & 0x80) != 0) {
            int lsize = len - 128;
            if (lsize > 4) {
                throw new BERException("Data too long: " + lsize);
            }
            len = 0;
            for (int i = 0; i < lsize; ++i) {
                int c = this.readByte();
                header[offset++] = (byte)c;
                len = (len << 8) + c;
            }
        }
        byte[] message = new byte[offset + len];
        System.arraycopy(header, 0, message, 0, offset);
        if (len == 0) {
            return message;
        }
        header = null;
        do {
            if ((l = this.in.read(message, offset, len)) == -1) {
                throw new IOException("EOF");
            }
            offset += l;
        } while ((len -= l) > 0);
        return message;
    }

    int readByte() throws IOException {
        int ret = this.in.read();
        if (ret == -1) {
            throw new IOException("EOF");
        }
        return ret & 0xFF;
    }
}

