/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.net.URL;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.ClassUtils;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.xml.JRSaxParserFactory;
import org.apache.commons.collections.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public abstract class BaseSaxParserFactory
implements JRSaxParserFactory {
    private static final Log log = LogFactory.getLog(BaseSaxParserFactory.class);
    public static final String PROPERTY_CACHE_SCHEMAS = "net.sf.jasperreports.compiler.xml.parser.cache.schemas";
    protected static final String PACKAGE_PREFIX_XERCES = "org.apache.xerces";
    protected static final String POOL_CLASS_XERCES = "org.apache.xerces.util.XMLGrammarPoolImpl";
    protected static final String PACKAGE_PREFIX_SUN_XERCES = "com.sun.org.apache.xerces";
    protected static final String POOL_CLASS_SUN_XERCES = "com.sun.org.apache.xerces.internal.util.XMLGrammarPoolImpl";
    protected static final String XERCES_PARSER_PROPERTY_GRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";
    private static final Object GRAMMAR_POOL_CACHE_NULL_KEY = "Null context classloader";
    private static final ThreadLocal<ReferenceMap> GRAMMAR_POOL_CACHE = new ThreadLocal();

    @Override
    public SAXParser createParser() {
        try {
            SAXParserFactory parserFactory = this.createSAXParserFactory();
            SAXParser parser = parserFactory.newSAXParser();
            this.configureParser(parser);
            return parser;
        }
        catch (SAXException e) {
            throw new JRRuntimeException("Error creating SAX parser", e);
        }
        catch (ParserConfigurationException e) {
            throw new JRRuntimeException("Error creating SAX parser", e);
        }
    }

    protected SAXParserFactory createSAXParserFactory() throws ParserConfigurationException, SAXException {
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Instantiated SAX parser factory of type " + parserFactory.getClass().getName()));
        }
        parserFactory.setNamespaceAware(true);
        boolean validating = this.isValidating();
        parserFactory.setValidating(validating);
        parserFactory.setFeature("http://xml.org/sax/features/validation", validating);
        return parserFactory;
    }

    protected abstract boolean isValidating();

    protected void configureParser(SAXParser parser) throws SAXException {
        List<String> schemaLocations = this.getSchemaLocations();
        parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", schemaLocations.toArray(new String[schemaLocations.size()]));
        boolean cache = JRProperties.getBooleanProperty(PROPERTY_CACHE_SCHEMAS);
        if (cache) {
            this.enableSchemaCaching(parser);
        }
    }

    protected abstract List<String> getSchemaLocations();

    protected String getResourceURI(String resource) {
        URL location = JRLoader.getResource(resource);
        if (location == null) {
            throw new JRRuntimeException("Could not find resource " + resource);
        }
        return location.toExternalForm();
    }

    protected void enableSchemaCaching(SAXParser parser) {
        String parserType = parser.getClass().getName();
        if (parserType.startsWith(PACKAGE_PREFIX_XERCES)) {
            this.setGrammarPoolProperty(parser, POOL_CLASS_XERCES);
        } else if (parserType.startsWith(PACKAGE_PREFIX_SUN_XERCES)) {
            this.setGrammarPoolProperty(parser, POOL_CLASS_SUN_XERCES);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Schema caching only works with Xerces parsers");
        }
    }

    protected void setGrammarPoolProperty(SAXParser parser, String poolClassName) {
        block5: {
            try {
                Object grammarPool;
                Object cacheKey = this.getGrammarPoolCacheKey();
                ReferenceMap cacheMap = GRAMMAR_POOL_CACHE.get();
                if (cacheMap == null) {
                    cacheMap = new ReferenceMap(2, 1);
                    GRAMMAR_POOL_CACHE.set(cacheMap);
                }
                if ((grammarPool = cacheMap.get(cacheKey)) == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Instantiating grammar pool of type " + poolClassName + " for cache key " + cacheKey));
                    }
                    grammarPool = ClassUtils.instantiateClass(poolClassName, Object.class);
                    cacheMap.put(cacheKey, grammarPool);
                }
                parser.setProperty(XERCES_PARSER_PROPERTY_GRAMMAR_POOL, grammarPool);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block5;
                log.debug((Object)("Error setting Xerces grammar pool of type " + poolClassName), (Throwable)e);
            }
        }
    }

    protected Object getGrammarPoolCacheKey() {
        Object key = Thread.currentThread().getContextClassLoader();
        if (key == null) {
            key = GRAMMAR_POOL_CACHE_NULL_KEY;
        }
        return key;
    }
}

