/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.imap;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Namespaces {
    List personal;
    List other;
    List shared;

    Namespaces(String text) {
        ArrayList acc = new ArrayList();
        int len = text.length();
        Namespaces.parse(text, 0, len, acc);
        len = acc.size();
        if (len > 0) {
            this.personal = this.parseNamespaceList(acc.get(0));
            if (len > 1) {
                this.other = this.parseNamespaceList(acc.get(1));
                if (len > 2) {
                    this.shared = this.parseNamespaceList(acc.get(2));
                }
            }
        }
    }

    public Namespace[] getPersonal() {
        return this.toArray(this.personal);
    }

    public Namespace[] getOther() {
        return this.toArray(this.other);
    }

    public Namespace[] getShared() {
        return this.toArray(this.shared);
    }

    private Namespace[] toArray(List namespaceList) {
        if (namespaceList == null) {
            return null;
        }
        Namespace[] ret = new Namespace[namespaceList.size()];
        namespaceList.toArray(ret);
        return ret;
    }

    static int parse(String text, int start, int len, List acc) {
        StringBuffer buf = new StringBuffer();
        boolean inLiteral = false;
        block6: for (int i = start; i < len; ++i) {
            char c = text.charAt(i);
            if (inLiteral) {
                if (c == '\"') {
                    String literal = buf.toString();
                    buf.setLength(0);
                    inLiteral = false;
                    acc.add(literal);
                    continue;
                }
                buf.append(c);
                continue;
            }
            switch (c) {
                case ' ': {
                    String token = buf.toString();
                    if ("NIL".equals(token)) {
                        acc.add(null);
                    }
                    buf.setLength(0);
                    continue block6;
                }
                case '\"': {
                    inLiteral = true;
                    buf.setLength(0);
                    continue block6;
                }
                case '(': {
                    ArrayList sub = new ArrayList();
                    i = Namespaces.parse(text, i + 1, len, sub);
                    acc.add(sub);
                    continue block6;
                }
                case ')': {
                    return i;
                }
            }
        }
        return len;
    }

    private List parseNamespaceList(Object ns) {
        if (ns == null) {
            return null;
        }
        List list = (List)ns;
        int len = list.size();
        ArrayList<Namespace> ret = new ArrayList<Namespace>(len);
        for (int i = 0; i < len; ++i) {
            ret.add(this.parseNamespace((List)list.get(i)));
        }
        return ret;
    }

    private Namespace parseNamespace(List comps) {
        int len = comps.size();
        Namespace ns = new Namespace();
        ns.prefix = (String)comps.get(0);
        ns.delimiter = ((String)comps.get(1)).charAt(0);
        if (len > 2) {
            ns.extensions = new TreeMap();
            for (int i = 2; i < len; i += 2) {
                String key = (String)comps.get(i);
                Object val = i == len - 1 ? null : (Object)comps.get(i + 1);
                ns.extensions.put(key, val);
            }
        }
        return ns;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        this.appendNamespaceList(buf, this.personal);
        buf.append(' ');
        this.appendNamespaceList(buf, this.other);
        buf.append(' ');
        this.appendNamespaceList(buf, this.shared);
        return buf.toString();
    }

    private void appendNamespaceList(StringBuffer buf, List list) {
        if (list == null) {
            buf.append("NIL");
        } else {
            int len = list.size();
            buf.append('(');
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    buf.append(' ');
                }
                buf.append(list.get(i));
            }
            buf.append(')');
        }
    }

    public static class Namespace {
        String prefix;
        char delimiter;
        Map extensions;

        public String getPrefix() {
            return this.prefix;
        }

        public char getDelimiter() {
            return this.delimiter;
        }

        public Map getExtensions() {
            return this.extensions;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append('(');
            buf.append(Namespace.quote(this.prefix));
            buf.append(' ');
            buf.append(Namespace.quote(this.delimiter));
            if (this.extensions != null) {
                buf.append(' ');
                for (Map.Entry entry : this.extensions.entrySet()) {
                    String key = (String)entry.getKey();
                    buf.append(Namespace.quote(key));
                    buf.append(' ');
                    buf.append(this.format(entry.getValue()));
                }
            }
            buf.append(')');
            return buf.toString();
        }

        static String quote(String text) {
            return '\"' + text + '\"';
        }

        static String quote(char c) {
            char[] chars = new char[]{'\"', c, '\"'};
            return new String(chars);
        }

        private String format(Object value) {
            if (value == null) {
                return "NIL";
            }
            if (value instanceof String) {
                return Namespace.quote((String)value);
            }
            List list = (List)value;
            int len = list.size();
            StringBuffer buf = new StringBuffer();
            buf.append('(');
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    buf.append(' ');
                }
                buf.append(this.format(list.get(i)));
            }
            buf.append(')');
            return buf.toString();
        }
    }
}

