/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.imap;

import gnu.inet.imap.IMAPConstants;
import gnu.inet.imap.IMAPResponse;
import gnu.inet.imap.Pair;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class IMAPResponseTokenizer
implements IMAPConstants {
    protected InputStream in;
    private byte[] buffer = null;
    private static final int BUFFER_SIZE = 4096;
    private static final String DEFAULT_ENCODING = "US-ASCII";
    private static final int STATE_TAG = 0;
    private static final int STATE_COUNT = 1;
    private static final int STATE_ID = 2;
    private static final int STATE_MAYBE_CODE = 3;
    private static final int STATE_CODE = 4;
    private static final int STATE_LITERAL_LENGTH = 5;
    private static final int STATE_LITERAL = 6;
    private static final int STATE_TEXT = 7;
    private static final int STATE_STATUS = 8;

    public IMAPResponseTokenizer(InputStream in) {
        this.in = in;
    }

    byte[] read(boolean moreNeeded) throws IOException {
        if (this.buffer != null && !moreNeeded && this.buffer.length > 0) {
            return this.buffer;
        }
        int max = this.in.available();
        if (max < 1) {
            max = 4096;
        }
        byte[] tmp = new byte[max];
        int len = 0;
        while (len == 0) {
            len = this.in.read(tmp, 0, max);
        }
        if (len == -1) {
            return null;
        }
        int blen = this.buffer == null ? 0 : this.buffer.length;
        byte[] uni = new byte[blen + len];
        if (blen != 0) {
            System.arraycopy(this.buffer, 0, uni, 0, blen);
        }
        System.arraycopy(tmp, 0, uni, blen, len);
        this.buffer = uni;
        return this.buffer;
    }

    void mark(int index) {
        int start = index + 1;
        int len = this.buffer.length;
        if (start < len) {
            int n = len - start;
            byte[] tmp = new byte[n];
            System.arraycopy(this.buffer, start, tmp, 0, n);
            this.buffer = tmp;
        } else {
            this.buffer = null;
        }
    }

    public IMAPResponse next() throws IOException {
        byte[] buf = this.read(false);
        if (buf == null) {
            return null;
        }
        int len = buf.length;
        IMAPResponse response = new IMAPResponse();
        ByteArrayOutputStream genericSink = new ByteArrayOutputStream();
        ByteArrayOutputStream literalSink = null;
        int literalCount = 0;
        int literalLength = -1;
        Stack<List<String>> context = new Stack<List<String>>();
        int state = 0;
        boolean inQuote = false;
        boolean inContent = false;
        block15: for (int i = 0; i < len; ++i) {
            byte b = buf[i];
            switch (state) {
                case 0: {
                    byte[] tb;
                    if (i == 0 && b == 42) {
                        response.tag = "*";
                        continue block15;
                    }
                    if (i == 0 && b == 43) {
                        response.tag = "+";
                        continue block15;
                    }
                    if (b == 32) {
                        if (response.tag == null) {
                            tb = genericSink.toByteArray();
                            response.tag = new String(tb, DEFAULT_ENCODING);
                        }
                        genericSink.reset();
                        if (response.isContinuation()) {
                            state = 7;
                            continue block15;
                        }
                        state = 1;
                        continue block15;
                    }
                    genericSink.write(b);
                    continue block15;
                }
                case 1: {
                    String cs;
                    byte[] cb;
                    if (b < 48 || b > 57) {
                        state = 2;
                    }
                    if (b == 32) {
                        cb = genericSink.toByteArray();
                        genericSink.reset();
                        cs = new String(cb, DEFAULT_ENCODING);
                        try {
                            response.count = Integer.parseInt(cs);
                        }
                        catch (NumberFormatException e) {
                            throw new ProtocolException("Expecting number: " + cs);
                        }
                        state = 2;
                        continue block15;
                    }
                    genericSink.write(b);
                    continue block15;
                }
                case 2: {
                    byte[] ib;
                    if (b == 32) {
                        ib = genericSink.toByteArray();
                        genericSink.reset();
                        response.id = new String(ib, DEFAULT_ENCODING).intern();
                        state = 3;
                        continue block15;
                    }
                    if (b == 10) {
                        ib = genericSink.toByteArray();
                        genericSink.reset();
                        response.id = new String(ib, DEFAULT_ENCODING).intern();
                        state = 0;
                        this.mark(i);
                        return response;
                    }
                    if (b == 13) continue block15;
                    genericSink.write(b);
                    continue block15;
                }
                case 3: {
                    List<String> top;
                    if (b == 40 || b == 91) {
                        response.code = top = new ArrayList();
                        context.push(top);
                        state = 4;
                        continue block15;
                    }
                    if (response.id == "FETCH") {
                        genericSink.reset();
                        byte[] fetchBytes = new byte[]{70, 69, 84, 67, 72, 32};
                        genericSink.write(fetchBytes);
                        genericSink.write(b);
                        state = 2;
                        continue block15;
                    }
                    if (response.id == "STATUS") {
                        genericSink.write(b);
                        state = 8;
                        continue block15;
                    }
                    genericSink.write(b);
                    state = 7;
                    continue block15;
                }
                case 8: {
                    if (b == 32) {
                        response.mailbox = genericSink.toString();
                        genericSink.reset();
                        state = 3;
                        continue block15;
                    }
                    genericSink.write(b);
                    continue block15;
                }
                case 4: {
                    String token;
                    byte[] tb;
                    List<String> top;
                    if (b == 34) {
                        inQuote = !inQuote;
                        continue block15;
                    }
                    if (inQuote) {
                        genericSink.write(b);
                        continue block15;
                    }
                    if (b == 40 || b == 91) {
                        List parent = (List)context.peek();
                        ArrayList top2 = new ArrayList();
                        if (genericSink.size() > 0) {
                            byte[] tb2 = genericSink.toByteArray();
                            String token2 = new String(tb2, DEFAULT_ENCODING).intern();
                            Pair pair = new Pair(token2, top2);
                            parent.add(pair);
                            genericSink.reset();
                        } else {
                            parent.add(top2);
                        }
                        context.push(top2);
                        continue block15;
                    }
                    if (b == 41 || b == 93) {
                        top = (List)context.pop();
                        if (genericSink.size() <= 0) continue block15;
                        tb = genericSink.toByteArray();
                        token = new String(tb, DEFAULT_ENCODING).intern();
                        top.add(token);
                        genericSink.reset();
                        continue block15;
                    }
                    if (b == 123) {
                        genericSink.reset();
                        state = 5;
                        continue block15;
                    }
                    if (b == 32) {
                        if (context.size() == 0) {
                            state = 7;
                            continue block15;
                        }
                        top = (List)context.peek();
                        if (genericSink.size() <= 0) continue block15;
                        tb = genericSink.toByteArray();
                        token = new String(tb, DEFAULT_ENCODING).intern();
                        top.add(token);
                        genericSink.reset();
                        continue block15;
                    }
                    if (b == 10) {
                        state = 0;
                        this.mark(i);
                        return response;
                    }
                    if (b == 13) continue block15;
                    genericSink.write(b);
                    continue block15;
                }
                case 5: {
                    String cs;
                    byte[] cb;
                    if (b == 125) {
                        cb = genericSink.toByteArray();
                        genericSink.reset();
                        cs = new String(cb, DEFAULT_ENCODING);
                        try {
                            literalLength = Integer.parseInt(cs);
                            continue block15;
                        }
                        catch (NumberFormatException e) {
                            throw new ProtocolException("Expecting number: " + cs);
                        }
                    }
                    if (b == 10) {
                        state = 6;
                        literalSink = new ByteArrayOutputStream();
                        literalCount = 0;
                        continue block15;
                    }
                    if (b == 13) continue block15;
                    genericSink.write(b);
                    continue block15;
                }
                case 6: {
                    List<String> top;
                    if (literalCount >= literalLength) {
                        top = (List)context.peek();
                        byte[] literal = literalSink.toByteArray();
                        top.add((String)literal);
                        literalSink = null;
                        inContent = false;
                        state = 4;
                        continue block15;
                    }
                    literalSink.write(b);
                    ++literalCount;
                    continue block15;
                }
                case 7: {
                    byte[] tb;
                    if (b == 10) {
                        tb = genericSink.toByteArray();
                        genericSink.reset();
                        response.text = new String(tb, DEFAULT_ENCODING);
                        state = 0;
                        this.mark(i);
                        return response;
                    }
                    if (b == 13) continue block15;
                    genericSink.write(b);
                }
            }
        }
        buf = this.read(true);
        return this.next();
    }
}

