/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.http;

import gnu.inet.http.Cookie;
import gnu.inet.http.CookieManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SimpleCookieManager
implements CookieManager {
    protected Map cookies = new HashMap();

    @Override
    public void setCookie(Cookie cookie) {
        String domain = cookie.getDomain();
        HashMap<String, Cookie> map = (HashMap<String, Cookie>)this.cookies.get(domain);
        if (map == null) {
            map = new HashMap<String, Cookie>();
            this.cookies.put(domain, map);
        }
        String name = cookie.getName();
        map.put(name, cookie);
    }

    @Override
    public Cookie[] getCookies(String host, boolean secure, String path) {
        ArrayList matches = new ArrayList();
        Date now = new Date();
        if (Character.isLetter(host.charAt(0))) {
            int di = host.indexOf(46);
            while (di != -1) {
                this.addCookies(matches, host, secure, path, now);
                host = host.substring(di);
                di = host.indexOf(46, 1);
            }
        }
        this.addCookies(matches, host, secure, path, now);
        Cookie[] ret = new Cookie[matches.size()];
        matches.toArray(ret);
        return ret;
    }

    private void addCookies(List matches, String domain, boolean secure, String path, Date now) {
        Map map = (Map)this.cookies.get(domain);
        if (map != null) {
            ArrayList expired = new ArrayList();
            for (Map.Entry entry : map.entrySet()) {
                Cookie cookie = (Cookie)entry.getValue();
                Date expires = cookie.getExpiryDate();
                if (expires != null && expires.before(now)) {
                    expired.add(entry.getKey());
                    continue;
                }
                if (secure && !cookie.isSecure() || !path.startsWith(cookie.getPath())) continue;
                matches.add(cookie);
            }
            Iterator i = expired.iterator();
            while (i.hasNext()) {
                map.remove(i.next());
            }
        }
    }
}

