/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package jp.mosp.platform.human.vo;

import jp.mosp.platform.human.base.PlatformHumanVo;

/**
 * 個人基本情報履歴一覧画面の情報を格納する。
 */
public class BasicListVo extends PlatformHumanVo {
	
	private static final long	serialVersionUID	= 7861386028350822347L;
	
	private String[]			aryPfmHumanId;
	private String[]			aryActiveteDate;
	private String[]			aryEmployeeName;
	private String[]			aryEmployeeKana;
	private String[]			aryWorkPlaceCode;
	private String[]			aryWorkPlace;
	private String[]			aryEmploymentCode;
	private String[]			aryEmployment;
	private String[]			arySectionCode;
	private String[]			arySection;
	private String[]			aryPositionCode;
	private String[]			aryPosition;
	
	private String				personalId;
	private String				transferredTargetDate;
	private boolean				needDeleteBasciHistory;
	private Boolean				jsIsLastHistoryBasic;
	

	/**
	 * @param personalId セットする personalId
	 */
	@Override
	public void setPersonalId(String personalId) {
		this.personalId = personalId;
	}
	
	/**
	 * @return personalId
	 */
	@Override
	public String getPersonalId() {
		return personalId;
	}
	
	/**
	 * @param transferredTargetDate セットする transferredTargetDate
	 */
	public void setTransferredTargetDate(String transferredTargetDate) {
		this.transferredTargetDate = transferredTargetDate;
	}
	
	/**
	 * @return transferredTargetDate
	 */
	public String getTransferredTargetDate() {
		return transferredTargetDate;
	}
	
	/**
	 * @param needDeleteBasciHistory セットする needDeleteBasciHistory
	 */
	public void setNeedDeleteBasciHistory(boolean needDeleteBasciHistory) {
		this.needDeleteBasciHistory = needDeleteBasciHistory;
	}
	
	/**
	 * @return needDeleteBasciHistory
	 */
	public boolean getNeedDeleteBasciHistory() {
		return needDeleteBasciHistory;
	}
	
	/**
	 * @param aryPfmHumanId セットする aryPfmHumanId
	 */
	public void setAryPfmHumanId(String[] aryPfmHumanId) {
		this.aryPfmHumanId = getStringArrayClone(aryPfmHumanId);
	}
	
	/**
	 * @return aryPfmHumanId
	 */
	public String[] getAryPfmHumanId() {
		return getStringArrayClone(aryPfmHumanId);
	}
	
	/**
	 * @param aryActiveteDate セットする aryActiveteDate
	 */
	public void setAryActiveteDate(String[] aryActiveteDate) {
		this.aryActiveteDate = getStringArrayClone(aryActiveteDate);
	}
	
	/**
	 * @return aryActiveteDate
	 */
	public String[] getAryActiveteDate() {
		return getStringArrayClone(aryActiveteDate);
	}
	
	/**
	 * @return aryEmployeeName
	 */
	public String[] getAryEmployeeName() {
		return getStringArrayClone(aryEmployeeName);
	}
	
	/**
	 * @param aryEmployeeName セットする aryEmployeeName
	 */
	public void setAryEmployeeName(String[] aryEmployeeName) {
		this.aryEmployeeName = getStringArrayClone(aryEmployeeName);
	}
	
	/**
	 * @return aryEmployeeKana
	 */
	public String[] getAryEmployeeKana() {
		return getStringArrayClone(aryEmployeeKana);
	}
	
	/**
	 * @param aryEmployeeKana セットする aryEmployeeKana
	 */
	public void setAryEmployeeKana(String[] aryEmployeeKana) {
		this.aryEmployeeKana = getStringArrayClone(aryEmployeeKana);
	}
	
	/**
	 * @return aryWorkPlaceCode
	 */
	public String[] getAryWorkPlaceCode() {
		return getStringArrayClone(aryWorkPlaceCode);
	}
	
	/**
	 * @param aryWorkPlaceCode セットする aryWorkPlaceCode
	 */
	public void setAryWorkPlaceCode(String[] aryWorkPlaceCode) {
		this.aryWorkPlaceCode = getStringArrayClone(aryWorkPlaceCode);
	}
	
	/**
	 * @return aryWorkPlace
	 */
	public String[] getAryWorkPlace() {
		return getStringArrayClone(aryWorkPlace);
	}
	
	/**
	 * @param aryWorkPlace セットする aryWorkPlace
	 */
	public void setAryWorkPlace(String[] aryWorkPlace) {
		this.aryWorkPlace = getStringArrayClone(aryWorkPlace);
	}
	
	/**
	 * @param aryEmploymentCode セットする aryEmploymentCode
	 */
	public void setAryEmploymentCode(String[] aryEmploymentCode) {
		this.aryEmploymentCode = getStringArrayClone(aryEmploymentCode);
	}
	
	/**
	 * @return aryEmploymentCode
	 */
	public String[] getAryEmploymentCode() {
		return getStringArrayClone(aryEmploymentCode);
	}
	
	/**
	 * @param aryEmployment セットする aryEmployment
	 */
	public void setAryEmployment(String[] aryEmployment) {
		this.aryEmployment = getStringArrayClone(aryEmployment);
	}
	
	/**
	 * @return aryEmployment
	 */
	public String[] getAryEmployment() {
		return getStringArrayClone(aryEmployment);
	}
	
	/**
	 * @param arySectionCode セットする arySectionCode
	 */
	public void setArySectionCode(String[] arySectionCode) {
		this.arySectionCode = getStringArrayClone(arySectionCode);
	}
	
	/**
	 * @return arySection
	 */
	public String[] getArySectionCode() {
		return getStringArrayClone(arySectionCode);
	}
	
	/**
	 * @param arySection セットする arySection
	 */
	public void setArySection(String[] arySection) {
		this.arySection = getStringArrayClone(arySection);
	}
	
	/**
	 * @return arySection
	 */
	public String[] getArySection() {
		return getStringArrayClone(arySection);
	}
	
	/**
	 * @param aryPositionCode セットする aryPositionCode
	 */
	public void setAryPositionCode(String[] aryPositionCode) {
		this.aryPositionCode = getStringArrayClone(aryPositionCode);
	}
	
	/**
	 * @return aryPosition
	 */
	public String[] getAryPositionCode() {
		return getStringArrayClone(aryPositionCode);
	}
	
	/**
	 * @param aryPosition セットする aryPosition
	 */
	public void setAryPosition(String[] aryPosition) {
		this.aryPosition = getStringArrayClone(aryPosition);
	}
	
	/**
	 * @return aryPosition
	 */
	public String[] getAryPosition() {
		return getStringArrayClone(aryPosition);
	}
	
	/**
	 * @param jsIsLastHistoryBasic セットする jsIsLastHistoryBasic
	 */
	public void setJsIsLastHistoryBasic(Boolean jsIsLastHistoryBasic) {
		this.jsIsLastHistoryBasic = jsIsLastHistoryBasic;
	}
	
	/**
	 * @return jsIsLastHistoryBasic
	 */
	public Boolean getJsIsLastHistoryBasic() {
		return jsIsLastHistoryBasic;
	}
	
}
