/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package jp.mosp.platform.bean.human.impl;

import java.sql.Connection;
import java.util.List;

import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.constant.MospConst;
import jp.mosp.platform.bean.human.ConcurrentReferenceBeanInterface;
import jp.mosp.platform.bean.human.ConcurrentRegistBeanInterface;
import jp.mosp.platform.bean.human.EntranceReferenceBeanInterface;
import jp.mosp.platform.bean.human.EntranceRegistBeanInterface;
import jp.mosp.platform.bean.human.HistoryBasicDeleteBeanInterface;
import jp.mosp.platform.bean.human.HumanReferenceBeanInterface;
import jp.mosp.platform.bean.human.HumanRegistBeanInterface;
import jp.mosp.platform.bean.human.HumanSearchBeanInterface;
import jp.mosp.platform.bean.human.RetirementReferenceBeanInterface;
import jp.mosp.platform.bean.human.RetirementRegistBeanInterface;
import jp.mosp.platform.bean.human.SuspensionReferenceBeanInterface;
import jp.mosp.platform.bean.human.SuspensionRegistBeanInterface;
import jp.mosp.platform.bean.human.base.PlatformHumanBean;
import jp.mosp.platform.bean.portal.UserCheckBeanInterface;
import jp.mosp.platform.bean.system.EmploymentContractReferenceBeanInterface;
import jp.mosp.platform.bean.system.EmploymentContractRegistBeanInterface;
import jp.mosp.platform.bean.system.EmploymentContractSearchBeanInterface;
import jp.mosp.platform.bean.system.PositionReferenceBeanInterface;
import jp.mosp.platform.bean.system.PositionRegistBeanInterface;
import jp.mosp.platform.bean.system.PositionSearchBeanInterface;
import jp.mosp.platform.bean.system.RoleReferenceBeanInterface;
import jp.mosp.platform.bean.system.SectionReferenceBeanInterface;
import jp.mosp.platform.bean.system.SectionRegistBeanInterface;
import jp.mosp.platform.bean.system.SectionSearchBeanInterface;
import jp.mosp.platform.bean.system.UserMasterReferenceBeanInterface;
import jp.mosp.platform.bean.system.UserMasterRegistBeanInterface;
import jp.mosp.platform.bean.system.UserMasterSearchBeanInterface;
import jp.mosp.platform.bean.system.UserPasswordRegistBeanInterface;
import jp.mosp.platform.bean.system.WorkPlaceReferenceBeanInterface;
import jp.mosp.platform.bean.system.WorkPlaceRegistBeanInterface;
import jp.mosp.platform.bean.system.WorkPlaceSearchBeanInterface;
import jp.mosp.platform.bean.workflow.ApprovalRouteReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.ApprovalRouteRegistBeanInterface;
import jp.mosp.platform.bean.workflow.ApprovalRouteSearchBeanInterface;
import jp.mosp.platform.bean.workflow.ApprovalRouteUnitReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.ApprovalRouteUnitRegistBeanInterface;
import jp.mosp.platform.bean.workflow.ApprovalUnitReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.ApprovalUnitRegistBeanInterface;
import jp.mosp.platform.bean.workflow.ApprovalUnitSearchBeanInterface;
import jp.mosp.platform.bean.workflow.RouteApplicationReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.RouteApplicationReferenceSearchBeanInterface;
import jp.mosp.platform.bean.workflow.RouteApplicationRegistBeanInterface;
import jp.mosp.platform.bean.workflow.RouteApplicationSearchBeanInterface;
import jp.mosp.platform.bean.workflow.SubApproverReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.SubApproverRegistBeanInterface;
import jp.mosp.platform.bean.workflow.SubApproverSearchBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowCommentReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowCommentRegistBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowRegistBeanInterface;
import jp.mosp.platform.constant.PlatformMessageConst;
import jp.mosp.platform.dto.human.ConcurrentDtoInterface;
import jp.mosp.platform.dto.human.EntranceDtoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.human.RetirementDtoInterface;
import jp.mosp.platform.dto.human.SuspensionDtoInterface;
import jp.mosp.platform.dto.system.UserMasterDtoInterface;

/**
 * 人事マスタ登録クラス。
 */
public class HistoryBasicDeleteBean extends HumanRegistBean implements HistoryBasicDeleteBeanInterface {
	
	UserCheckBeanInterface							userCheck;
	UserPasswordRegistBeanInterface					userPasswordRegist;
	UserMasterRegistBeanInterface					userMasterRegist;
	EmploymentContractRegistBeanInterface			employmentContractRegist;
	SectionRegistBeanInterface						sectionRegist;
	WorkPlaceRegistBeanInterface					workPlaceRegist;
	PositionRegistBeanInterface						positionRegist;
	HumanRegistBeanInterface						humanRegist;
	EntranceRegistBeanInterface						entranceRegist;
	RetirementRegistBeanInterface					retirementRegist;
	SuspensionRegistBeanInterface					suspensionRegist;
	ConcurrentRegistBeanInterface					concurrentRegist;
	WorkflowRegistBeanInterface						workflowRegist;
	WorkflowCommentRegistBeanInterface				workflowCommentRegist;
	ApprovalUnitRegistBeanInterface					approvalunitRegist;
	ApprovalRouteRegistBeanInterface				approvalRouteRegist;
	ApprovalRouteUnitRegistBeanInterface			approvalRouteunitRegist;
	RouteApplicationRegistBeanInterface				routeApplicationRegist;
	SubApproverRegistBeanInterface					subApproverRegist;
	
	UserMasterReferenceBeanInterface				userMasterReference;
	SectionReferenceBeanInterface					sectionReference;
	PositionReferenceBeanInterface					positionReference;
	EmploymentContractReferenceBeanInterface		employmentContractReference;
	HumanSearchBeanInterface						humanSearch;
	HumanReferenceBeanInterface						humanReference;
	EntranceReferenceBeanInterface					entranceReference;
	SuspensionReferenceBeanInterface				suspensionReference;
	RetirementReferenceBeanInterface				retirementReference;
	ConcurrentReferenceBeanInterface				concurrentReference;
	WorkPlaceReferenceBeanInterface					workPlaceReference;
	WorkPlaceSearchBeanInterface					workPlaceSearch;
	RoleReferenceBeanInterface						roleReference;
	EmploymentContractSearchBeanInterface			employmentContractSearch;
	SectionSearchBeanInterface						sectionSearch;
	PositionSearchBeanInterface						positionSearch;
	UserMasterSearchBeanInterface					userMasterSearch;
	WorkflowIntegrateBeanInterface					workflowIntegrate;
	WorkflowReferenceBeanInterface					workflowReference;
	WorkflowCommentReferenceBeanInterface			workflowCommentReference;
	ApprovalUnitReferenceBeanInterface				approvalUnitReference;
	ApprovalUnitSearchBeanInterface					approvalUnitSearch;
	ApprovalRouteReferenceBeanInterface				approvalRouteReference;
	ApprovalRouteSearchBeanInterface				approvalRouteSearch;
	ApprovalRouteUnitReferenceBeanInterface			approvalRouteUnitReference;
	RouteApplicationReferenceBeanInterface			routeApplicationReference;
	RouteApplicationSearchBeanInterface				routeApplicationSearch;
	RouteApplicationReferenceSearchBeanInterface	routeApplicationReferenceSearch;
	SubApproverReferenceBeanInterface				subApproverReference;
	SubApproverSearchBeanInterface					subApproverSearch;
	

	/**
	 * {@link PlatformHumanBean#PlatformHumanBean()}を実行する。<br>
	 */
	public HistoryBasicDeleteBean() {
		super();
	}
	
	/**
	 * {@link PlatformHumanBean#PlatformHumanBean(MospParams, Connection)}を実行する。<br>
	 * @param mospParams MosPパラメータクラス
	 * @param connection DBコネクション
	 */
	public HistoryBasicDeleteBean(MospParams mospParams, Connection connection) {
		super(mospParams, connection);
	}
	
	@Override
	public void initBean() throws MospException {
		super.initBean();
		// MosPプラットフォーム用BeanHandler取得
		userCheck = (UserCheckBeanInterface)createBean(UserCheckBeanInterface.class);
		userPasswordRegist = (UserPasswordRegistBeanInterface)createBean(UserPasswordRegistBeanInterface.class);
		userMasterRegist = (UserMasterRegistBeanInterface)createBean(UserMasterRegistBeanInterface.class);
		employmentContractRegist = (EmploymentContractRegistBeanInterface)createBean(EmploymentContractRegistBeanInterface.class);
		sectionRegist = (SectionRegistBeanInterface)createBean(SectionRegistBeanInterface.class);
		workPlaceRegist = (WorkPlaceRegistBeanInterface)createBean(WorkPlaceRegistBeanInterface.class);
		positionRegist = (PositionRegistBeanInterface)createBean(PositionRegistBeanInterface.class);
		humanRegist = (HumanRegistBeanInterface)createBean(HumanRegistBeanInterface.class);
		entranceRegist = (EntranceRegistBeanInterface)createBean(EntranceRegistBeanInterface.class);
		retirementRegist = (RetirementRegistBeanInterface)createBean(RetirementRegistBeanInterface.class);
		suspensionRegist = (SuspensionRegistBeanInterface)createBean(SuspensionRegistBeanInterface.class);
		concurrentRegist = (ConcurrentRegistBeanInterface)createBean(ConcurrentRegistBeanInterface.class);
		workflowRegist = (WorkflowRegistBeanInterface)createBean(WorkflowRegistBeanInterface.class);
		workflowCommentRegist = (WorkflowCommentRegistBeanInterface)createBean(WorkflowCommentRegistBeanInterface.class);
		approvalunitRegist = (ApprovalUnitRegistBeanInterface)createBean(ApprovalUnitRegistBeanInterface.class);
		approvalRouteRegist = (ApprovalRouteRegistBeanInterface)createBean(ApprovalRouteRegistBeanInterface.class);
		approvalRouteunitRegist = (ApprovalRouteUnitRegistBeanInterface)createBean(ApprovalRouteUnitRegistBeanInterface.class);
		routeApplicationRegist = (RouteApplicationRegistBeanInterface)createBean(RouteApplicationRegistBeanInterface.class);
		subApproverRegist = (SubApproverRegistBeanInterface)createBean(SubApproverRegistBeanInterface.class);
		
		userMasterReference = (UserMasterReferenceBeanInterface)createBean(UserMasterReferenceBeanInterface.class);
		sectionReference = (SectionReferenceBeanInterface)createBean(SectionReferenceBeanInterface.class);
		positionReference = (PositionReferenceBeanInterface)createBean(PositionReferenceBeanInterface.class);
		employmentContractReference = (EmploymentContractReferenceBeanInterface)createBean(EmploymentContractReferenceBeanInterface.class);
		humanSearch = (HumanSearchBeanInterface)createBean(HumanSearchBeanInterface.class);
		humanReference = (HumanReferenceBeanInterface)createBean(HumanReferenceBeanInterface.class);
		entranceReference = (EntranceReferenceBeanInterface)createBean(EntranceReferenceBeanInterface.class);
		suspensionReference = (SuspensionReferenceBeanInterface)createBean(SuspensionReferenceBeanInterface.class);
		retirementReference = (RetirementReferenceBeanInterface)createBean(RetirementReferenceBeanInterface.class);
		concurrentReference = (ConcurrentReferenceBeanInterface)createBean(ConcurrentReferenceBeanInterface.class);
		workPlaceReference = (WorkPlaceReferenceBeanInterface)createBean(WorkPlaceReferenceBeanInterface.class);
		workPlaceSearch = (WorkPlaceSearchBeanInterface)createBean(WorkPlaceSearchBeanInterface.class);
		roleReference = (RoleReferenceBeanInterface)createBean(RoleReferenceBeanInterface.class);
		employmentContractSearch = (EmploymentContractSearchBeanInterface)createBean(EmploymentContractSearchBeanInterface.class);
		sectionSearch = (SectionSearchBeanInterface)createBean(SectionSearchBeanInterface.class);
		positionSearch = (PositionSearchBeanInterface)createBean(PositionSearchBeanInterface.class);
		userMasterSearch = (UserMasterSearchBeanInterface)createBean(UserMasterSearchBeanInterface.class);
		workflowIntegrate = (WorkflowIntegrateBeanInterface)createBean(WorkflowIntegrateBeanInterface.class);
		workflowReference = (WorkflowReferenceBeanInterface)createBean(WorkflowReferenceBeanInterface.class);
		workflowCommentReference = (WorkflowCommentReferenceBeanInterface)createBean(WorkflowCommentReferenceBeanInterface.class);
		approvalUnitReference = (ApprovalUnitReferenceBeanInterface)createBean(ApprovalUnitReferenceBeanInterface.class);
		approvalUnitSearch = (ApprovalUnitSearchBeanInterface)createBean(ApprovalUnitSearchBeanInterface.class);
		approvalRouteReference = (ApprovalRouteReferenceBeanInterface)createBean(ApprovalRouteReferenceBeanInterface.class);
		approvalRouteSearch = (ApprovalRouteSearchBeanInterface)createBean(ApprovalRouteSearchBeanInterface.class);
		approvalRouteUnitReference = (ApprovalRouteUnitReferenceBeanInterface)createBean(ApprovalRouteUnitReferenceBeanInterface.class);
		routeApplicationReference = (RouteApplicationReferenceBeanInterface)createBean(RouteApplicationReferenceBeanInterface.class);
		routeApplicationSearch = (RouteApplicationSearchBeanInterface)createBean(RouteApplicationSearchBeanInterface.class);
		routeApplicationReferenceSearch = (RouteApplicationReferenceSearchBeanInterface)createBean(RouteApplicationReferenceSearchBeanInterface.class);
		subApproverReference = (SubApproverReferenceBeanInterface)createBean(SubApproverReferenceBeanInterface.class);
		subApproverSearch = (SubApproverSearchBeanInterface)createBean(SubApproverSearchBeanInterface.class);
		
	}
	
	@Override
	public void checkIsDelete(List<HumanDtoInterface> list, int isAllDelete) throws MospException {
		// TODO 履歴削除処理前チェックを行なう。各種マスタの存在チェック・承認状況を確認して
		// 削除することにより、整合性が保てなくなる場合、エラーメッセージを設定する。
		// 勤務地マスタの存在確認
		// 雇用契約マスタの存在確認
		// 所属マスタの存在確認
		// 職位マスタの存在確認
		// アカウントマスタの存在確認
		// ルート適用存在確認
		// ユニットの存在確認
		
	}
	
	@Override
	public void delete(HumanDtoInterface dto, int isAllDelete) throws MospException {
		// 人事マスタ削除
		humanRegist.delete(dto);
		// 全削除フラグがOFFの場合は正常終了
		if (isAllDelete == MospConst.DELETE_FLAG_OFF) {
			return;
		}
		// 全削除フラグがONの場合
		// 人事退社情報削除
		deleteRetirement(dto);
		if (mospParams.hasErrorMessage()) {
			// 履歴削除メッセージ設定
			addDeleteHistoryFailedMessage();
			return;
		}
		// 人事入社情報削除
		deleteEntrance(dto);
		if (mospParams.hasErrorMessage()) {
			// 履歴削除メッセージ設定
			addDeleteHistoryFailedMessage();
			return;
		}
		// ユーザマスタ削除
		deleteUser(dto);
		if (mospParams.hasErrorMessage()) {
			// 履歴削除メッセージ設定
			addDeleteHistoryFailedMessage();
			return;
		}
		// 人事休職情報削除削除
		deleteSuspension(dto);
		if (mospParams.hasErrorMessage()) {
			// 履歴削除メッセージ設定
			addDeleteHistoryFailedMessage();
			return;
		}
		// 人事兼務情報削除
		deleteConcurrent(dto);
		if (mospParams.hasErrorMessage()) {
			// 履歴削除メッセージ設定
			addDeleteHistoryFailedMessage();
			return;
		}
	}
	
	/**
	 * 人事入社情報を削除する。
	 * @param humanDto 人事マスタDTO
	 * @throws MospException インスタンスの取得、或いはSQL実行に失敗した場合
	 */
	protected void deleteEntrance(HumanDtoInterface humanDto) throws MospException {
		// 入社情報DTOの準備
		EntranceDtoInterface dto = entranceRegist.getInitDto();
		// 入社情報DTOに値を設定
		if (!setDtoFields(dto, humanDto)) {
			return;
		}
		// 入社情報登録処理
		entranceRegist.delete(dto);
	}
	
	/**
	 * VO(編集項目)の値をDTO(人事入社情報)に設定する。<br>
	 * @param dto 対象DTO
	 * @param humanDto 人事マスタDTO
	 * @return boolean 削除可否(true:削除可能、false:削除不可)
	 * @throws MospException インスタンスの取得、或いはSQL実行に失敗した場合
	 */
	protected boolean setDtoFields(EntranceDtoInterface dto, HumanDtoInterface humanDto) throws MospException {
		EntranceDtoInterface entranceDto = entranceReference.getEntranceInfo(humanDto.getPersonalId());
		if (entranceDto == null) {
			return false;
		}
		// 社員コードから個人IDを取得して設定
		dto.setPfaHumanEntranceId(entranceDto.getPfaHumanEntranceId());
		dto.setPersonalId(entranceDto.getPersonalId());
		dto.setEntranceDate(entranceDto.getEntranceDate());
		return true;
	}
	
	/**
	 * ユーザーマスタ情報を削除する。
	 * @param humanDto 人事マスタDTO
	 * @throws MospException インスタンスの取得、或いはSQL実行に失敗した場合
	 */
	protected void deleteUser(HumanDtoInterface humanDto) throws MospException {
		// ユーザーマスタ情報DTOの準備
		long[] list = setDtoFieldsForUser(humanDto);
		// ユーザーマスタ情報DTOに値を設定
		if (list == null) {
			return;
		}
		// ユーザーマスタ情報登録処理
		userMasterRegist.delete(list);
	}
	
	/**
	 * VO(編集項目)の値をDTO(ユーザー情報)に設定する。<br>
	 * @param humanDto 人事マスタDTO
	 * @return long[] 対象識別ID
	 * @throws MospException インスタンスの取得、或いはSQL実行に失敗した場合
	 */
	protected long[] setDtoFieldsForUser(HumanDtoInterface humanDto) throws MospException {
		// 選択されたユーザーの履歴を取得する
		List<UserMasterDtoInterface> listUser = userMasterReference.getUserHistoryForPersonalId(humanDto
			.getPersonalId());
		// 情報が存在しない場合
		if (listUser.size() == 0) {
			return null;
		}
		// 識別ID配列を作成
		int idx = 0;
		long[] aryUser = new long[listUser.size()];
		for (UserMasterDtoInterface dto : listUser) {
			aryUser[idx++] = dto.getPfmUserId();
		}
		return aryUser;
	}
	
	/**
	 * 休職情報を削除する。
	 * @param humanDto 人事マスタDTO
	 * @throws MospException インスタンスの取得、或いはSQL実行に失敗した場合
	 */
	protected void deleteSuspension(HumanDtoInterface humanDto) throws MospException {
		// 休職情報DTOの準備
		long[] list = setDtoFieldsForSuspension(humanDto);
		// 休職情報DTOに値を設定
		if (list == null) {
			return;
		}
		// 休職情報登録処理
		suspensionRegist.delete(list);
	}
	
	/**
	 * VO(編集項目)の値をDTO(休職情報)に設定する。<br>
	 * @param humanDto 人事マスタDTO
	 * @return long[] 対象識別ID
	 * @throws MospException インスタンスの取得、或いはSQL実行に失敗した場合
	 */
	protected long[] setDtoFieldsForSuspension(HumanDtoInterface humanDto) throws MospException {
		// 選択されたユーザーの履歴を取得する
		List<SuspensionDtoInterface> list = suspensionReference.getSuspentionList(humanDto.getPersonalId());
		// 情報が存在しない場合
		if (list.size() == 0) {
			return null;
		}
		// 識別ID配列を作成
		int idx = 0;
		long[] arySuspension = new long[list.size()];
		for (SuspensionDtoInterface dto : list) {
			arySuspension[idx++] = dto.getPfaHumanSuspensionId();
		}
		return arySuspension;
	}
	
	/**
	 * 人事退社情報を削除する。
	 * @param humanDto 人事マスタDTO
	 * @throws MospException インスタンスの取得、或いはSQL実行に失敗した場合
	 */
	protected void deleteRetirement(HumanDtoInterface humanDto) throws MospException {
		// 退社情報DTOの準備
		RetirementDtoInterface dto = retirementRegist.getInitDto();
		// 退社情報DTOに値を設定
		if (!setDtoFields(dto, humanDto)) {
			return;
		}
		// 退社情報登録処理
		retirementRegist.delete(dto);
	}
	
	/**
	 * VO(編集項目)の値をDTO(退社情報)に設定する。<br>
	 * @param dto 対象DTO
	 * @param humanDto 人事マスタDTO
	 * @return boolean 削除可否(true:削除可能、false:削除不可)
	 * @throws MospException インスタンスの取得、或いはSQL実行に失敗した場合
	 */
	protected boolean setDtoFields(RetirementDtoInterface dto, HumanDtoInterface humanDto) throws MospException {
		RetirementDtoInterface retirementDto = retirementReference.getRetireInfo(humanDto.getPersonalId());
		if (retirementDto == null) {
			return false;
		}
		// 社員コードから個人IDを取得して設定
		dto.setPfaHumanRetirementId(retirementDto.getPfaHumanRetirementId());
		dto.setPersonalId(retirementDto.getPersonalId());
		dto.setRetirementDate(retirementDto.getRetirementDate());
		return true;
	}
	
	/**
	 * 人事兼務情報を削除する。
	 * @param humanDto 人事マスタDTO
	 * @throws MospException インスタンスの取得、或いはSQL実行に失敗した場合
	 */
	protected void deleteConcurrent(HumanDtoInterface humanDto) throws MospException {
		// 人事兼務情報DTOの準備
		long[] list = setDtoFieldsForConcurrent(humanDto);
		// 人事兼務情報DTOに値を設定
		if (list == null) {
			return;
		}
		// 人事兼務情報登録処理
		concurrentRegist.delete(list);
	}
	
	/**
	 * VO(編集項目)の値をDTO(人事兼務情報)に設定する。<br>
	 * @param humanDto 対象DTO
	 * @return long[] 対象識別ID
	 * @throws MospException インスタンスの取得、或いはSQL実行に失敗した場合
	 */
	protected long[] setDtoFieldsForConcurrent(HumanDtoInterface humanDto) throws MospException {
		// 選択されたユーザーの履歴を取得する
		List<ConcurrentDtoInterface> list = concurrentReference.getConcurrentHistory(humanDto.getPersonalId());
		// 情報が存在しない場合
		if (list.size() == 0) {
			return null;
		}
		// 識別ID配列を作成
		int idx = 0;
		long[] aryConcurrent = new long[list.size()];
		for (ConcurrentDtoInterface dto : list) {
			aryConcurrent[idx++] = dto.getPfaHumanConcurrentId();
		}
		return aryConcurrent;
	}
	
	/**
	 * 履歴削除失敗メッセージの設定。
	 */
	protected void addDeleteHistoryFailedMessage() {
		String[] aryMeassage = { mospParams.getName("History") + mospParams.getName("Delete") };
		mospParams.addMessage(PlatformMessageConst.MSG_PROCESS_FAILED, aryMeassage);
	}
	
}
