/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package jp.mosp.platform.bean.human;

import java.util.List;

import jp.mosp.framework.base.MospException;
import jp.mosp.platform.dto.human.HumanDtoInterface;

/**
 * 人事マスタ登録インターフェース。<br>
 */
public interface HistoryBasicDeleteBeanInterface extends HumanRegistBeanInterface {
	
	/**
	 * 人事マスタの履歴削除時の整合性チェックを行う。<br>
	 * @param list 削除対象リスト(1行目：削除対象DTO、2行目：削除対象よりも一つ前のDTO)
	 * @param isAllDelete 対象社員情報全削除フラグ
	 * @throws MospException インスタンスの取得、或いはSQL実行に失敗した場合
	 */
	void checkIsDelete(List<HumanDtoInterface> list, int isAllDelete) throws MospException;
	
	/**
	 * 人事マスタの履歴削除を行う。<br>
	 * @param dto 対象DTO
	 * @param isAllDelete 対象社員情報全削除フラグ
	 * @throws MospException インスタンスの取得、或いはSQL実行に失敗した場合
	 */
	void delete(HumanDtoInterface dto, int isAllDelete) throws MospException;
	
}
