/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package jp.mosp.platform.base;

import jp.mosp.framework.base.BaseBeanHandlerInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.bean.file.ExportFieldReferenceBeanInterface;
import jp.mosp.platform.bean.file.ExportReferenceBeanInterface;
import jp.mosp.platform.bean.file.ExportSearchBeanInterface;
import jp.mosp.platform.bean.file.HumanExportBeanInterface;
import jp.mosp.platform.bean.file.ImportFieldReferenceBeanInterface;
import jp.mosp.platform.bean.file.ImportReferenceBeanInterface;
import jp.mosp.platform.bean.file.ImportSearchBeanInterface;
import jp.mosp.platform.bean.file.UserExportBeanInterface;
import jp.mosp.platform.bean.human.ConcurrentReferenceBeanInterface;
import jp.mosp.platform.bean.human.EntranceReferenceBeanInterface;
import jp.mosp.platform.bean.human.HumanReferenceBeanInterface;
import jp.mosp.platform.bean.human.HumanSearchBeanInterface;
import jp.mosp.platform.bean.human.RetirementReferenceBeanInterface;
import jp.mosp.platform.bean.human.SuspensionReferenceBeanInterface;
import jp.mosp.platform.bean.message.MessageReferenceBeanInterface;
import jp.mosp.platform.bean.message.MessageSearchBeanInterface;
import jp.mosp.platform.bean.portal.HolidayBeanInterface;
import jp.mosp.platform.bean.system.EmploymentContractReferenceBeanInterface;
import jp.mosp.platform.bean.system.EmploymentContractSearchBeanInterface;
import jp.mosp.platform.bean.system.PositionReferenceBeanInterface;
import jp.mosp.platform.bean.system.PositionSearchBeanInterface;
import jp.mosp.platform.bean.system.RoleReferenceBeanInterface;
import jp.mosp.platform.bean.system.SectionReferenceBeanInterface;
import jp.mosp.platform.bean.system.SectionSearchBeanInterface;
import jp.mosp.platform.bean.system.UserMasterReferenceBeanInterface;
import jp.mosp.platform.bean.system.UserMasterSearchBeanInterface;
import jp.mosp.platform.bean.system.WorkPlaceReferenceBeanInterface;
import jp.mosp.platform.bean.system.WorkPlaceSearchBeanInterface;
import jp.mosp.platform.bean.workflow.ApprovalRouteReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.ApprovalRouteSearchBeanInterface;
import jp.mosp.platform.bean.workflow.ApprovalRouteUnitReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.ApprovalUnitReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.ApprovalUnitSearchBeanInterface;
import jp.mosp.platform.bean.workflow.RouteApplicationReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.RouteApplicationReferenceSearchBeanInterface;
import jp.mosp.platform.bean.workflow.RouteApplicationSearchBeanInterface;
import jp.mosp.platform.bean.workflow.SubApproverReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.SubApproverSearchBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowCommentReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowReferenceBeanInterface;

/**
 * 参照用BeanHandlerインターフェース。
 */
public interface ReferenceBeanHandlerInterface extends BaseBeanHandlerInterface {
	
	/**
	 * @return ユーザマスタ参照
	 * @throws MospException Beanインスタンスの生成及び初期化に失敗した場合
	 */
	UserMasterReferenceBeanInterface user() throws MospException;
	
	/**
	 * @return 所属マスタ参照
	 * @throws MospException Beanインスタンスの生成及び初期化に失敗した場合
	 */
	SectionReferenceBeanInterface section() throws MospException;
	
	/**
	 * @return 職位マスタ参照
	 * @throws MospException Beanインスタンスの生成及び初期化に失敗した場合
	 */
	PositionReferenceBeanInterface position() throws MospException;
	
	/**
	 * @return 職位マスタ参照
	 * @throws MospException Beanインスタンスの生成及び初期化に失敗した場合
	 */
	PositionSearchBeanInterface positionSearch() throws MospException;
	
	/**
	 * @return 雇用契約マスタ参照
	 * @throws MospException Beanインスタンスの生成及び初期化に失敗した場合
	 */
	EmploymentContractReferenceBeanInterface employmentContract() throws MospException;
	
	/**
	 * 人事マスタ検索インスタンスを取得する。
	 * @return 人事マスタ検索インスタンス
	 * @throws MospException Beanインスタンスの生成及び初期化に失敗した場合
	 */
	HumanSearchBeanInterface humanSearch() throws MospException;
	
	/**
	 * @return 人事マスタ参照
	 * @throws MospException Beanインスタンスの生成及び初期化に失敗した場合
	 */
	HumanReferenceBeanInterface human() throws MospException;
	
	/**
	 * @return 人事入社情報参照
	 * @throws MospException Beanインスタンスの生成及び初期化に失敗した場合
	 */
	EntranceReferenceBeanInterface entrance() throws MospException;
	
	/**
	 * @return 人事休職情報参照
	 * @throws MospException Beanインスタンスの生成及び初期化に失敗した場合
	 */
	SuspensionReferenceBeanInterface suspension() throws MospException;
	
	/**
	 * @return 人事退職情報参照
	 * @throws MospException Beanインスタンスの生成及び初期化に失敗した場合
	 */
	RetirementReferenceBeanInterface retirement() throws MospException;
	
	/**
	 * @return 人事兼務情報参照
	 * @throws MospException Beanインスタンスの生成及び初期化に失敗した場合
	 */
	ConcurrentReferenceBeanInterface concurrent() throws MospException;
	
	/**
	 * @return 勤務地マスタ参照
	 * @throws MospException Beanインスタンスの生成及び初期化に失敗した場合
	 */
	WorkPlaceReferenceBeanInterface workPlace() throws MospException;
	
	/**
	 * @return 勤務地マスタ参照
	 * @throws MospException Beanインスタンスの生成及び初期化に失敗した場合
	 */
	WorkPlaceSearchBeanInterface workPlaceSearch() throws MospException;
	
	/**
	 * ロール参照インスタンスを取得する。
	 * @return ロール参照インスタンス
	 * @throws MospException Beanインスタンスの生成及び初期化に失敗した場合
	 */
	RoleReferenceBeanInterface role() throws MospException;
	
	/**
	 * 雇用契約検索インスタンスを取得する。
	 * @return 雇用契約検索インスタンス
	 * @throws MospException Beanインスタンスの生成及び初期化に失敗した場合
	 */
	EmploymentContractSearchBeanInterface employmentContractSearch() throws MospException;
	
	/**
	 * 所属検索インスタンスを取得する。
	 * @return 所属契約検索インスタンス
	 * @throws MospException Beanインスタンスの生成及び初期化に失敗した場合
	 */
	SectionSearchBeanInterface sectionSearch() throws MospException;
	
	/**
	 * ユーザーマスタ検索インスタンスを取得する。
	 * @return ユーザーマスタ検索インスタンス
	 * @throws MospException Beanインスタンスの生成及び初期化に失敗した場合
	 */
	UserMasterSearchBeanInterface userMasterSearch() throws MospException;
	
	/**
	 * @return ワークフロー統括
	 * @throws MospException Beanインスタンスの生成及び初期化に失敗した場合
	 */
	WorkflowIntegrateBeanInterface workflowIntegrate() throws MospException;
	
	/**
	 * @return ワークフロー参照
	 * @throws MospException Beanインスタンスの生成及び初期化に失敗した場合
	 */
	WorkflowReferenceBeanInterface workflow() throws MospException;
	
	/**
	 * @return ワークフローコメント参照
	 * @throws MospException Beanインスタンスの生成及び初期化に失敗した場合
	 */
	WorkflowCommentReferenceBeanInterface workflowComment() throws MospException;
	
	/**
	 * @return 承認ユニットマスタ参照インスタンス
	 * @throws MospException Beanインスタンスの生成及び初期化に失敗した場合
	 */
	ApprovalUnitReferenceBeanInterface approvalUnit() throws MospException;
	
	/**
	 * @return 承認ユニットマスタ検索インスタンス
	 * @throws MospException Beanインスタンスの生成及び初期化に失敗した場合
	 */
	ApprovalUnitSearchBeanInterface approvalUnitSearch() throws MospException;
	
	/**
	 * @return 承認ルートマスタ参照インスタンス
	 * @throws MospException Beanインスタンスの生成及び初期化に失敗した場合
	 */
	ApprovalRouteReferenceBeanInterface approvalRoute() throws MospException;
	
	/**
	 * @return 承認ルートマスタ検索インスタンス
	 * @throws MospException Beanインスタンスの生成及び初期化に失敗した場合
	 */
	ApprovalRouteSearchBeanInterface approvalRouteSearch() throws MospException;
	
	/**
	 * @return 承認ルートユニットマスタ参照インスタンス
	 * @throws MospException Beanインスタンスの生成及び初期化に失敗した場合
	 */
	ApprovalRouteUnitReferenceBeanInterface approvalRouteUnit() throws MospException;
	
	/**
	 * @return 承認ルートマスタ参照インスタンス
	 * @throws MospException Beanインスタンスの生成及び初期化に失敗した場合
	 */
	RouteApplicationReferenceBeanInterface routeApplication() throws MospException;
	
	/**
	 * @return 承認ルートマスタ検索インスタンス
	 * @throws MospException Beanインスタンスの生成及び初期化に失敗した場合
	 */
	RouteApplicationSearchBeanInterface routeApplicationSearch() throws MospException;
	
	/**
	 * @return 承認ルート参照検索インスタンス
	 * @throws MospException Beanインスタンスの生成及び初期化に失敗した場合
	 */
	RouteApplicationReferenceSearchBeanInterface routeApplicationReferenceSearch() throws MospException;
	
	/**
	 * @return 代理承認者参照クラスインスタンス
	 * @throws MospException Beanインスタンスの生成及び初期化に失敗した場合
	 */
	SubApproverReferenceBeanInterface subApprover() throws MospException;
	
	/**
	 * @return 代理承認者検索クラスインスタンス
	 * @throws MospException Beanインスタンスの生成及び初期化に失敗した場合
	 */
	SubApproverSearchBeanInterface subApproverSearch() throws MospException;
	
	/**
	 * @return メッセージ参照インスタンス
	 * @throws MospException Beanインスタンスの生成及び初期化に失敗した場合
	 */
	MessageReferenceBeanInterface message() throws MospException;
	
	/**
	 * @return メッセージ検索インスタンス
	 * @throws MospException Beanインスタンスの生成及び初期化に失敗した場合
	 */
	MessageSearchBeanInterface messageSearch() throws MospException;
	
	/**
	 * @return エクスポートマスタ検索インスタンス
	 * @throws MospException Beanインスタンスの生成及び初期化に失敗した場合
	 */
	ExportSearchBeanInterface exportSearch() throws MospException;
	
	/**
	 * @return エクスポートマスタ参照インスタンス
	 * @throws MospException Beanインスタンスの生成及び初期化に失敗した場合
	 */
	ExportReferenceBeanInterface export() throws MospException;
	
	/**
	 * @return エクスポートフィールド参照インスタンス
	 * @throws MospException Beanインスタンスの生成及び初期化に失敗した場合
	 */
	ExportFieldReferenceBeanInterface exportField() throws MospException;
	
	/**
	 * @return インポートマスタ検索インスタンス
	 * @throws MospException Beanインスタンスの生成及び初期化に失敗した場合
	 */
	ImportSearchBeanInterface importSearch() throws MospException;
	
	/**
	 * @return インポートマスタ参照インスタンス
	 * @throws MospException Beanインスタンスの生成及び初期化に失敗した場合
	 */
	ImportReferenceBeanInterface importRefer() throws MospException;
	
	/**
	 * @return インポートフィールド参照インスタンス
	 * @throws MospException Beanインスタンスの生成及び初期化に失敗した場合
	 */
	ImportFieldReferenceBeanInterface importField() throws MospException;
	
	/**
	 * 人事マスタエクスポートクラスを取得する。
	 * @return 人事マスタエクスポートクラス
	 * @throws MospException Beanインスタンスの生成及び初期化に失敗した場合
	 */
	HumanExportBeanInterface humanExport() throws MospException;
	
	/**
	 * ユーザマスタエクスポートクラスを取得する。
	 * @return ユーザマスタエクスポートクラス
	 * @throws MospException Beanインスタンスの生成及び初期化に失敗した場合
	 */
	UserExportBeanInterface userExport() throws MospException;
	
	/**
	 * 祝日インターフェースを取得する。
	 * @return 祝日インターフェース
	 * @throws MospException Beanインスタンスの生成及び初期化に失敗した場合
	 */
	HolidayBeanInterface holiday() throws MospException;
	
}
