<%--
MosP - Mind Open Source Project    http://www.mosp.jp/
Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/

This program is free software: you can redistribute it and/or
modify it under the terms of the GNU Affero General Public License
as published by the Free Software Foundation, either version 3
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
--%>
<%@ page
language="java"
pageEncoding="UTF-8"
buffer="64kb"
autoFlush="false"
errorPage="/jsp/common/error.jsp"
%><%@ page
import="jp.mosp.framework.constant.MospConst"
import="jp.mosp.framework.base.MospParams"
import="jp.mosp.framework.utils.HtmlUtility"
import="jp.mosp.platform.human.vo.HumanInfoVo"
import="jp.mosp.platform.human.action.HumanInfoAction"
import="jp.mosp.platform.human.action.BasicCardAction"
import="jp.mosp.platform.human.action.BasicListAction"
import="jp.mosp.platform.human.action.EntranceCardAction"
import="jp.mosp.platform.human.action.RetirementCardAction"
import="jp.mosp.platform.human.action.SuspensionCardAction"
import="jp.mosp.platform.human.action.ConcurrentCardAction"
import="jp.mosp.platform.human.constant.PlatformHumanConst"
%><%
MospParams params = (MospParams)request.getAttribute(MospConst.ATT_MOSP_PARAMS);
HumanInfoVo vo = (HumanInfoVo)params.getVo();
%>
<jsp:include page="<%= PlatformHumanConst.PATH_HUMAN_COMMON_INFO_JSP %>" flush="false" />
<div class="List">
	<table class="OverTable" id="tblBasicInfomation">
		<tr>
			<th colspan="4" class="ListTableTh" id="">
			<span class="TitleTh"><%= params.getName("Personal") %><%= params.getName("Basis") %><%= params.getName("Information") %></span>
			<span class="TableButtonSpan">
			<button type="button" class="Name4Button" onclick="submitTransfer(event, null, null, new Array('<%= PlatformHumanConst.PRM_TRANSFERRED_EMPLOYEE_CODE %>', '<%= HtmlUtility.escapeHTML(vo.getEmployeeCode()) %>', '<%= PlatformHumanConst.PRM_TRANSFERRED_ACTIVATE_DATE %>', '<%= HtmlUtility.escapeHTML(vo.getActivateDate()) %>'), '<%= BasicCardAction.CMD_ADD_SELECT %>');">
					<%= params.getName("History") %><%= params.getName("Add") %></button>&nbsp;
			<button type="button" class="Name4Button" onclick="submitTransfer(event, null, null, new Array('<%= PlatformHumanConst.PRM_TRANSFERRED_EMPLOYEE_CODE %>', '<%= HtmlUtility.escapeHTML(vo.getEmployeeCode()) %>', '<%= PlatformHumanConst.PRM_TRANSFERRED_ACTIVATE_DATE %>', '<%= HtmlUtility.escapeHTML(vo.getActivateDate()) %>'), '<%= BasicListAction.CMD_SELECT %>');">
					<%= params.getName("History") %><%= params.getName("List") %></button>
			</span>
			</th>
		</tr>
	</table>
	<table class="UnderTable" id="tblBasicInfomation">
		<tr>
			<td rowspan="2" class="TitleTd" id="titleEmployeeName">
			<div><%= params.getName("FrontParentheses") %><%= params.getName("Kana") %><%= params.getName("BackParentheses") %></div><div><%= params.getName("FullName") %></div></td>
			<td rowspan="2" class="InputTd" id="lblEmployeeName">
			<div><%= HtmlUtility.escapeHTML(vo.getLblEmployeeKana()) %></div><div><%= HtmlUtility.escapeHTML(vo.getLblEmployeeName()) %></div></td>
			<td class="TitleTd" id="tdTitleWorkPlace"><%= params.getName("WorkPlace") %></td>
			<td class="InputTd" id="lblWorkPlaceName"><%= HtmlUtility.escapeHTML(vo.getLblWorkPlace()) %></td>
		</tr>
		<tr>
			<td class="TitleTd" id="tdTitleListBasic"><%= params.getName("EmploymentContract") %></td>
			<td class="InputTd" id="tdEmploymentName"><%= HtmlUtility.escapeHTML(vo.getLblEmployment()) %></td>
		</tr>
		<tr>
			<td class="TitleTd" id="titleSectionName"><%= params.getName("Section") %></td>
			<td class="InputTd" id="lblSectionName"><%= HtmlUtility.escapeHTML(vo.getLblSection()) %></td>
			<td class="TitleTd" id="titlePositionName"><%= params.getName("Position") %></td>
			<td class="InputTd" id="lblPositionName"><%= HtmlUtility.escapeHTML(vo.getLblPosition()) %></td>
		</tr>
	</table>
</div>
<div class="List">
	<table class="OverTable">
		<tr>
			<th colspan="2" class="ListTableTh" id=""><span class="TitleTh"><%= params.getName("Joined") %><%= params.getName("Information") %></span>
			<span class="TableButtonSpan">
				<button type="button" class="Name2Button"
				onclick="submitTransfer(event, null, null, new Array('<%= PlatformHumanConst.PRM_TRANSFERRED_EMPLOYEE_CODE %>', '<%= HtmlUtility.escapeHTML(vo.getEmployeeCode()) %>', '<%= PlatformHumanConst.PRM_TRANSFERRED_ACTIVATE_DATE %>', '<%= HtmlUtility.escapeHTML(vo.getActivateDate()) %>'), '<%= EntranceCardAction.CMD_SELECT %>');"
				><%= params.getName("Edit") %></button>
			</span></th>
		</tr>
	</table>
<%
if (vo.getLblEntranceDate().isEmpty() == false) {
%>
	<table class="UnderTable" id="tblEntrance">
		<tr>
			<td class="TitleTd"><%= params.getName("Joined") %><%= params.getName("Day") %></td>
			<td class="InputTd" id="tdEntranceDate"><%= HtmlUtility.escapeHTML(vo.getLblEntranceDate()) %></td>
		</tr>
<%
}
%>
</table>
</div>
<div class="List">
<table class="OverTable">
	<tr>
		<th colspan="6" class="ListTableTh" id=""><span class="TitleTh"><%= params.getName("Concurrent") %><%= params.getName("Information") %></span>
		<span class="TableButtonSpan">
			<button type="button" class="Name2Button"
			onclick="submitTransfer(event, null, null, new Array('<%= PlatformHumanConst.PRM_TRANSFERRED_EMPLOYEE_CODE %>', '<%= HtmlUtility.escapeHTML(vo.getEmployeeCode()) %>', '<%= PlatformHumanConst.PRM_TRANSFERRED_ACTIVATE_DATE %>', '<%= HtmlUtility.escapeHTML(vo.getActivateDate()) %>'), '<%= ConcurrentCardAction.CMD_SELECT %>');"
			><%= params.getName("History") %></button>
		</span></th>
	</tr>
</table>
<%
if (vo.getAryConcurrentStartDate().length > 0) {
%>
<table class="UnderTable">
	<tr>
		<td class="TitleTd" id="thListNumber"></td>
		<td class="TitleTd" id="thListDate"><%= params.getName("Start") %><%= params.getName("Day") %></td>
		<td class="TitleTd" id="thListDate"><%= params.getName("End") %><%= params.getName("Day") %></td>
		<td class="TitleTd" id="thSectionAbbr"><%= params.getName("Section") %><%= params.getName("Abbreviation") %></td>
		<td class="TitleTd" id="thPositionAbbr"><%= params.getName("Position") %><%= params.getName("Abbreviation") %></td>
		<td class="TitleTd" id="thRemark"><%= params.getName("Remarks") %></td>
	</tr>
<%
}
for (int i = 0; i < vo.getAryConcurrentStartDate().length; i++) {
%>
	<tr id="addLeaveTr1">
		<td class="NumberTd" id=""><%= HtmlUtility.escapeHTML(String.valueOf(i + 1)) %></td>
		<td class="InputTd" id=""><%= HtmlUtility.escapeHTML(vo.getAryConcurrentStartDate()[i]) %></td>
		<td class="InputTd" id=""><%= HtmlUtility.escapeHTML(vo.getAryConcurrentEndDate()[i]) %></td>
		<td class="InputTd" id=""><%= HtmlUtility.escapeHTML(vo.getAryConcurrentSectionAbbr()[i]) %></td>
		<td class="InputTd" id=""><%= HtmlUtility.escapeHTML(vo.getAryConcurrentPositionAbbr()[i]) %></td>
		<td class="InputTd" id="tdConcurrentRemark"><%= HtmlUtility.escapeHTML(vo.getAryConcurrentRemark()[i]) %></td>
	</tr>
<%
}
%>
</table>
</div>
<div class="List">
<table class="OverTable">
	<tr>
		<th colspan="5" class="ListTableTh" id=""><span class="TitleTh"><%= params.getName("RetirementLeave") %><%= params.getName("Information") %></span>
		<span class="TableButtonSpan">
		<button type="button" class="Name2Button"
		onclick="submitTransfer(event, null, null, new Array('<%= PlatformHumanConst.PRM_TRANSFERRED_EMPLOYEE_CODE %>', '<%= HtmlUtility.escapeHTML(vo.getEmployeeCode()) %>', '<%= PlatformHumanConst.PRM_TRANSFERRED_ACTIVATE_DATE %>', '<%= HtmlUtility.escapeHTML(vo.getActivateDate()) %>'), '<%= SuspensionCardAction.CMD_SELECT %>');"
		><%= params.getName("History") %></button>
		</span></th>
	</tr>
</table>
<%
if (vo.getArySuspensionStartDate().length > 0) {
%>
<table class="UnderTable">
	<tr>
		<td class="TitleTd" id="thListNumber"></td>
		<td class="TitleTd" id="thListDate"><%= params.getName("RetirementLeave") %><%= params.getName("Start") %><%= params.getName("Day") %></td>
		<td class="TitleTd" id="thListDate"><%= params.getName("RetirementLeave") %><%= params.getName("End") %><%= params.getName("Day") %></td>
		<td class="TitleTd" id="thListDate"><%= params.getName("RetirementLeave") %><%= params.getName("End") %><%= params.getName("Schedule") %><%= params.getName("Day") %></td>
		<td class="TitleTd" id="thSuspensionReason"><%= params.getName("RetirementLeave") %><%= params.getName("Reason") %></td>
	</tr>
<%
}
for (int i = 0; i < vo.getArySuspensionStartDate().length; i++) {
%>
	<tr>
		<td class="NumberTd"><%= HtmlUtility.escapeHTML(String.valueOf(i + 1)) %></td>
		<td class="InputTd"><%= HtmlUtility.escapeHTML(vo.getArySuspensionStartDate()[i]) %></td>
		<td class="InputTd"><%= HtmlUtility.escapeHTML(vo.getArySuspensionEndDate()[i]) %></td>
		<td class="InputTd"><%= HtmlUtility.escapeHTML(vo.getArySuspensionsScheduleEndDate()[i]) %></td>
		<td class="InputTd" id="tdSuspensionReason"><%= HtmlUtility.escapeHTML(vo.getArySuspensionReason()[i]) %></td>
	</tr>
<%
}
%>
</table>
</div>
<div class="List">
<table class="OverTable">
	<tr>
		<th colspan="3" class="ListTableTh" id="hRetire"><span class="TitleTh"><%= params.getName("RetirementOn") %><%= params.getName("Information") %></span>
		<span class="TableButtonSpan">
			<button type="button" class="Name2Button"
			onclick="submitTransfer(event, null, null, new Array('<%= PlatformHumanConst.PRM_TRANSFERRED_EMPLOYEE_CODE %>', '<%= HtmlUtility.escapeHTML(vo.getEmployeeCode()) %>', '<%= PlatformHumanConst.PRM_TRANSFERRED_ACTIVATE_DATE %>', '<%= HtmlUtility.escapeHTML(vo.getActivateDate()) %>'), '<%= RetirementCardAction.CMD_SELECT %>');"
			><%= params.getName("Edit") %></button>
		</span></th>
	</tr>
</table>
<%
if (vo.getLblRetirementDate().isEmpty() == false) {
%>
<table class="UnderTable">
	<tr>
		<td class="TitleTd" id="thListDate"><%= params.getName("RetirementOn") %><%= params.getName("Day") %></td>
		<td class="TitleTd" id="thRetirementReason"><%= params.getName("RetirementOn") %><%= params.getName("Reason") %></td>
		<td class="TitleTd" id="thRetirementDetail"><%= params.getName("Reason") %><%= params.getName("Detail") %></td>
	</tr>
	<tr>
		<td class="InputTd" id="lblRetirementDate"><%= HtmlUtility.escapeHTML(vo.getLblRetirementDate()) %></td>
		<td class="InputTd" id="tdRetirementReason"><%= HtmlUtility.escapeHTML(vo.getLblRetirementReason()) %></td>
		<td class="InputTd" id="lblRetirementDetail"><%= HtmlUtility.escapeHTML(vo.getLblRetirementDetail()) %></td>
	</tr>
<%
}
%>
</table>
</div>
<div class="MoveUpLink">
	<a onclick="pageToTop();"><%= params.getName("UpperTriangular") %><%= params.getName("TopOfPage") %></a>
</div>
