/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.report.action;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.bean.OdsBean;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.common.PoiUtility;
import jp.mosp.common.dto.MosPConfDto;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.legal.LegalConst;
import jp.mosp.payroll.base.AdjustmentAction;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.bonus.dto.PhBounsDto;
import jp.mosp.payroll.common.vo.AdjustmentCalcVo;
import jp.mosp.payroll.common.vo.AdjustmentListVo;
import jp.mosp.payroll.common.vo.AdjustmentReferVo;
import jp.mosp.payroll.dao.CdAdjustmentDao;
import jp.mosp.payroll.dao.CmCompanyDao;
import jp.mosp.payroll.dto.CdAdjustmentDto;
import jp.mosp.payroll.report.dto.PaymentLedgerDto;

public class PaymentLedgerAction extends AdjustmentAction {
	
	// R}h
	private static final String	CMD_PAYMENT_LEDGER_ALL	= "P3070";
	private static final String	CMD_PAYMENT_LEDGER_ONE	= "P3071";
	private static final String	CMD_PAYMENT_LEDGER_ALL2	= "P3072";
	
	public String[][]			aryGender;
	// ݒe[u
	public List<MosPConfDto>	listConf;
	public String[][]			aryEra;
	public String[][]			aryStation;
	public String[][]			aryPltIncomeTaxType;
	public String[][]			aryPltAdjustmentType;
	public String[][]			aryPltHandicapType;
	public String[][]			aryPltWidowType;
	public String[][]			aryPltStudentType;
	public String[][]			aryPltSpouseIntendType;
	public String[][]			aryPltLiveWithType;
	public String[][]			aryPltSpouseType;
	public String[][]			aryPltDependentType;
	

	/**
	 * RXgN^
	 */
	public PaymentLedgerAction() {
		super();
		setNeedProcSeq(false);
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// DAO
		prepareDao();
		// 擾ϊmF
		if (aryStation != null) {
			return;
		}
		// z擾
		aryStation = getStationArrayAll();
		aryPosition = getPositionArrayAll();
		aryEra = getCodeArray(PayrollConst.TID_JAPANESE);
		aryPltIncomeTaxType = LegalConst.INCOME_TAX_ARRAY;
		aryPltAdjustmentType = LegalConst.ADJUSTMENT_ARRAY;
		aryPltHandicapType = LegalConst.HANDICAP_ARRAY;
		aryPltWidowType = LegalConst.WIDOW_ARRAY;
		aryPltStudentType = LegalConst.STUDENT_ARRAY;
		aryPltSpouseIntendType = LegalConst.SPOUSE_INTEND_ARRAY;
		aryPltLiveWithType = LegalConst.LIVE_WITH_ARRAY;
		aryPltSpouseType = LegalConst.SPOUSE_ARRAY;
		aryPltDependentType = LegalConst.DEPENDENT_ARRAY;
		
		// aݒ擾
		listConf = getConfList(PayrollConst.CONF_ID_JP_IMP_CAL);
		// Ǖw(v) Up
		aryGender = getCodeArray(PayrollConst.TID_GENDER);
		if (cmd.equals(CMD_PAYMENT_LEDGER_ALL)) {
			// VO̎擾
			AdjustmentListVo vo = (AdjustmentListVo)session.getAttribute(MospConst.ATT_FORMER_VO);
			vo.clearMessage();
			vo.clearErrField();
			vo.initVo(cfg, msg, cmd, aspUser, user);
			// p[^擾
			vo.setParams(request);
			adjustYear = vo.getPltAdjustYear();
			startAdjDate = getStartDateOfYear(adjustYear);
			lastDate = getLastDateOfYear(adjustYear);
			// Ώ۔NAΏۃf[^ݒ
			setTargetData();
			Date date = vo.getDate(String.valueOf(vo.getPltAdjustYear()), String
				.valueOf(PayrollConst.TIME_ADJ_PAY_MONTH), String.valueOf(PayrollConst.TIME_DEFAULT_DAY));
			// ^׃f[^쐬
			List<PaymentLedgerDto> list = getPaymentLedger(date, null, vo);
			// [쐬
//			String fileName = vo.getPltAdjustYear ()
//							+ PayrollConst.FILE_PAYMENT_LEDGER;
//			request.setAttribute(MospConst.ATT_FILE_NAME, fileName);
//			// [쐬yѐݒ
//			request.setAttribute(MospConst.ATT_FILE_OBJECT, print(
//					cfg.getProperty(MospConst.PPT_APP_DOCBASE) + template, list));
		} else if (cmd.equals(CMD_PAYMENT_LEDGER_ONE)) {
			// VO̎擾
			AdjustmentReferVo vo = (AdjustmentReferVo)session.getAttribute(MospConst.ATT_FORMER_VO);
			vo.clearMessage();
			vo.clearErrField();
			vo.initVo(cfg, msg, cmd, aspUser, user);
			// p[^擾
			vo.setParams(request);
			adjustYear = vo.getHidAdjustYear();
			startAdjDate = getStartDateOfYear(adjustYear);
			lastDate = getLastDateOfYear(adjustYear);
			// ЈR[hNULL
			vo.setLblChangeKCode(vo.getHidKCode());
			// Ώ۔NAΏۃf[^ݒ
			setTargetData();
			// Ώ۔N擾
			Date date = vo.getDate(String.valueOf(vo.getHidAdjustYear()), String
				.valueOf(PayrollConst.TIME_ADJ_PAY_MONTH), String.valueOf(PayrollConst.TIME_DEFAULT_DAY));
			// ^׃f[^쐬
			List<PaymentLedgerDto> list = getPaymentLedgerOne(date, vo.getHidKCode(), vo);
			for (int i = 0; i < list.size(); i++) {
				PaymentLedgerDto dtoTmp = list.get(i);
				// ^׏o
				if (StringUtil.isNotNull(cfg.getProperty(CommonConst.PPT_KINTAI_USE_ODF))) {
					report(vo, dtoTmp);
				} else {
					reportXls(vo, dtoTmp);
				}
			}
		} else if (cmd.equals(CMD_PAYMENT_LEDGER_ALL2)) {
			// VO̎擾
			AdjustmentCalcVo vo = (AdjustmentCalcVo)session.getAttribute(MospConst.ATT_FORMER_VO);
			vo.clearMessage();
			vo.clearErrField();
			vo.initVo(cfg, msg, cmd, aspUser, user);
			// p[^擾
			vo.setParams(request);
			adjustYear = vo.getHidAdjustYear();
			startAdjDate = getStartDateOfYear(adjustYear);
			lastDate = getLastDateOfYear(adjustYear);
			// Ώ۔NAΏۃf[^ݒ
			setTargetData();
			// Ώ۔N擾(Ώ۔N12/1)
//			Date date = vo.getDate(String.valueOf(vo.getHidAdjustYear()), String.valueOf(PayrollConst.TIME_ADJ_PAY_MONTH),  String.valueOf(PayrollConst.TIME_DEFAULT_DAY));
			// ^׃f[^쐬
//			List<PaymentLedgerDto> list = getPaymentLedger(date, null, vo);
//			// [쐬
//			String fileName = vo.getHidAdjustYear ()
//							+ PayrollConst.FILE_PAYMENT_LEDGER;
//			request.setAttribute(MospConst.ATT_FILE_NAME, fileName);
//			// [쐬yѐݒ
//			request.setAttribute(MospConst.ATT_FILE_OBJECT, print(
//					cfg.getProperty(MospConst.PPT_APP_DOCBASE) + template, list));
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	/**
	 * 򒥎[f[^쐬B<br>
	 * @param targetMonth 쐬Ώ۔N
	 * @param kCode       쐬ΏێЈR[h(nullȂS)
	 * @param vo          VO
	 * @return ^׃f[^Xg
	 * @throws Exception
	 */
	private List<PaymentLedgerDto> getPaymentLedger(Date targetMonth, String kCode, AdjustmentListVo vo)
			throws Exception {
		// 򒥎[f[^擾
		CdAdjustmentDao dao = new CdAdjustmentDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ^ǗҌmF
		confirmPayrollAuth();
		// Nf[^쐬
		List<CdAdjustmentDto> listAdjustment = dao.findForWithholdVote(MospUtility.getYear(targetMonth), kCode);
		// 򒥎[f[^쐬
		List<PaymentLedgerDto> list = new ArrayList<PaymentLedgerDto>();
		// Ѓf[^ݒ
		setCompanyDataInfo();
		for (Iterator<CdAdjustmentDto> it = listAdjustment.iterator(); it.hasNext();) {
			cdAdjustmentDto = it.next();
			// lݒ
			setHumanInfo(cdAdjustmentDto);
			// ^Aܗ^擾
			setPaymentBonusInfo();
			PaymentLedgerDto dto = new PaymentLedgerDto();
			if (phPaymentDto != null && mKihonDto != null) {
				phBonusDto.setKCode(kCode);
//				phBonusDto.setEmploymentType(phPaymentDto.getEmploymentType());
//				phBonusDto.setPositionCode(phPaymentDto.getPositionCode());
				// Nf[^ݒ
				dto = new PaymentLedgerDto(getMapDetailPa(), getMapDetailPd(), getMapDetailPs(), getMapDetailPt(),
						getMapDetailBa(), getMapDetailBd(), getMapDetailBs(), cmIncomeTaxDto, mKojinDto, mKihonDto,
						cmSocInsuranceDto, cmCompanyDto, cdAdjustmentDto, listPaymentData, listBonusData,
						pdPayAllowanceDao, // ^T׃f[^
						pdPayDeductionDao, // ^x׃f[^
						pdPaySumDao, // ^׍v
						pdPayTimeDao, pdBonAllowanceDao, // ܗ^T׃f[^
						pdBonDeductionDao, // ܗ^x׃f[^
						pdBonSumDao // ܗ^׍v
				);
				// Nژaݒ
				setJapanDate(dto);
				// R[h̐ݒ
				setDtoCodeName(dto);
				
			}
			// Xgɐݒ
			list.add(dto);
		}
		// ^f[^mF
		if (list.size() == 0) {
			setVo(vo);
			setUrl(vo.getRetUrl());
			String errMessage = MospUtility.getMessage(msg, PayrollConst.MSG_NO_ADJUST_REPORT, "");
			addErrMessage(errMessage);
			throw new MospException(PayrollConst.EX_NO_PAYMENT_DETAIL, errMessage);
		}
		
		return list;
	}
	
	/**
	 * 򒥎[f[^쐬B<br>
	 * @param targetMonth 쐬Ώ۔N
	 * @param kCode       쐬ΏێЈR[h(nullȂS)
	 * @param vo          VO
	 * @return ^׃f[^Xg
	 * @throws Exception
	 */
	private List<PaymentLedgerDto> getPaymentLedgerOne(Date targetMonth, String kCode, MosPVo vo) throws Exception {
		// 򒥎[f[^擾
		CdAdjustmentDao dao = new CdAdjustmentDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ^ǗҌmF
		confirmPayrollAuth();
		// Nf[^쐬
		List<CdAdjustmentDto> listAdjustment = dao.findForWithholdVote(MospUtility.getYear(targetMonth), kCode);
		// 򒥎[f[^쐬
		List<PaymentLedgerDto> list = new ArrayList<PaymentLedgerDto>();
		// Ѓf[^ݒ
		setCompanyDataInfo();
		for (Iterator<CdAdjustmentDto> it = listAdjustment.iterator(); it.hasNext();) {
			cdAdjustmentDto = it.next();
		}
		if (listAdjustment.size() == 0) {
			// 
			cdAdjustmentDto = new CdAdjustmentDto();
			// ЈR[hݒ
			cdAdjustmentDto.setKCode(kCode);
		}
		setVo(vo);
		setUrl(vo.getRetUrl());
		
		// lݒ
		setHumanInfo(cdAdjustmentDto);
		// ^Aܗ^擾
		setPaymentBonusInfo();
		PaymentLedgerDto dto = new PaymentLedgerDto();
		if (phPaymentDto != null && mKihonDto != null) {
			phBonusDto.setKCode(kCode);
//			phBonusDto.setEmploymentType(phPaymentDto.getEmploymentType());
//			phBonusDto.setPositionCode(phPaymentDto.getPositionCode());
			
			// Nf[^ݒ
			dto = new PaymentLedgerDto(getMapDetailPa(), getMapDetailPd(), getMapDetailPs(), getMapDetailPt(),
					getMapDetailBa(), getMapDetailBd(), getMapDetailBs(), cmIncomeTaxDto, mKojinDto, mKihonDto,
					cmSocInsuranceDto, cmCompanyDto, cdAdjustmentDto, listPaymentData, listBonusData,
					pdPayAllowanceDao, // ^T׃f[^
					pdPayDeductionDao, // ^x׃f[^
					pdPaySumDao, // ^׍v
					pdPayTimeDao, pdBonAllowanceDao, // ܗ^T׃f[^
					pdBonDeductionDao, // ܗ^x׃f[^
					pdBonSumDao // ܗ^׍v
			);
			// Nژaݒ
			setJapanDate(dto);
			// R[h̐ݒ
			setDtoCodeName(dto);
			
		}
		// Xgɐݒ
		list.add(dto);
		return list;
	}
	
	/**
	 * ^Aܗ^擾
	 * @param vo
	 * @throws Exception 
	 */
	private void setPaymentBonusInfo() throws Exception {
		// vZΏۋ^f[^擾
		listPaymentData = phPaymentDao.findForConditionDate(kCode, targetBefDate, targetAffDate);
		// vZΏۏܗ^f[^擾
		listBonusData = phBonusDao.findForConditionDate(kCode, startAdjDate, lastDate);
		
		// ^f[^mF
		setTargetPaymentData();
		phBonusDto = new PhBounsDto();
		if (phPaymentDto == null) {
			if (listPaymentData.size() != 0) {
				phPaymentDto = listPaymentData.get(listPaymentData.size() - 1);
			}
		}
		
		// Ώۃf[^ŌvZ(o^Ȃ)
		calcTargetIncomeTax(false);
	}
	
	/**
	 * lݒ
	 * @param vo ݒΏVO
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 * @throws MospException 
	 */
	private void setHumanInfo(CdAdjustmentDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		if (dto != null) {
			// ЈR[hݒ
			kCode = dto.getKCode();
			// NŏI𗚗擾ΏیƂĎgp
			Date targetDate = getLastDateOfYear(adjustYear);
			// l{擾
			mKihonDto = mKihonPayrollDao.findForKey(kCode);
			if (mKihonDto == null) {
				// l{񂪖ꍇ
				String errMessage = MospUtility.getMessage(msg, PayrollConst.MSG_NO_HUMAN_DATA, "");
				addErrMessage(errMessage);
			}
			// l{ݒ
			// lǗ擾
			mKojinDto = mKojinDao.findForKey(kCode);
			
			// l^擾
			cmIncomeTaxDto = cmIncomeTaxDao.findForEmployeeDate(kCode, targetDate);
			cmMidwayEnterDto = cmMidwayEnterDao.findForKey(kCode);
			cmSocInsuranceDto = cmSocInsuranceDao.findForHumanDataOnly(kCode, targetDate);
			// Ƒ擾
//			listFamily = cmFamilyDao.findForAdjustment(kCode);
			
		}
	}
	
	/**
	 * Џݒ
	 * @param dto
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 */
	private void setCompanyDataInfo() throws SQLException, IllegalAccessException, NoSuchFieldException {
		CmCompanyDao dao = new CmCompanyDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		cmCompanyDto = dao.findAll();
	}
	
	/**
	 * at擾
	 * @param dto
	 * @throws MospException
	 */
	private void setJapanDate(PaymentLedgerDto dto) throws MospException {
		String[] strDate;
		// \pN擾(Ώ۔N)
		if (targetAffDate != null) {
			strDate = getJpImperialCal(listConf, targetAffDate);
			strDate[0] = getCodeName(strDate[0], aryEra);
			dto.setOutputYear(strDate[0] + " " + strDate[1]);
			
		}
		// o͓
		strDate = getJpImperialCal(listConf, getSystemDate());
		strDate[0] = getCodeName(strDate[0], aryEra);
		dto.setOutputDate(strDate[0] + strDate[1] + PayrollConst.NAM_YEAR + strDate[2] + PayrollConst.NAM_MONTH
				+ strDate[3] + PayrollConst.NAM_DAY);
		if (mKojinDto != null) {
			if (mKojinDto.getSeinenbi() != 0) {
				// N
				strDate = getJpImperialCal(listConf, DateUtil.convIntegerDateToDate(mKojinDto.getSeinenbi()));
				strDate[0] = getCodeName(strDate[0], aryEra);
				dto.setBirthDate(strDate[0] + " " + strDate[1] + PayrollConst.NAM_YEAR + " " + strDate[2] + " "
						+ PayrollConst.NAM_MONTH + " " + strDate[3] + PayrollConst.NAM_DAY);
			} else {
				dto.setBirthDate(" " + " " + " " + PayrollConst.NAM_YEAR + " " + " " + " " + PayrollConst.NAM_MONTH
						+ " " + " " + PayrollConst.NAM_DAY);
				
			}
		}
		if (mKihonDto.getNyDate() != 0) {
			// Г
			strDate = getJpImperialCal(listConf, DateUtil.convIntegerDateToDate(mKihonDto.getNyDate()));
			strDate[0] = getCodeName(strDate[0], aryEra);
			dto.setEntranceDate(strDate[0] + " " + strDate[1] + PayrollConst.NAM_YEAR + " " + strDate[2] + " "
					+ PayrollConst.NAM_MONTH + " " + strDate[3] + PayrollConst.NAM_DAY);
		} else {
			dto.setEntranceDate(" " + " " + " " + PayrollConst.NAM_YEAR + " " + " " + " " + PayrollConst.NAM_MONTH
					+ " " + " " + PayrollConst.NAM_DAY);
		}
		if (mKihonDto.getTsDate() != 0) {
			// ގГ
			strDate = getJpImperialCal(listConf, DateUtil.convIntegerDateToDate(mKihonDto.getTsDate()));
			strDate[0] = getCodeName(strDate[0], aryEra);
			dto.setRetirementDate(strDate[0] + " " + strDate[1] + PayrollConst.NAM_YEAR + " " + strDate[2] + " "
					+ PayrollConst.NAM_MONTH + " " + strDate[3] + PayrollConst.NAM_DAY);
		} else {
			dto.setRetirementDate(" " + " " + " " + PayrollConst.NAM_YEAR + " " + " " + " " + PayrollConst.NAM_MONTH
					+ " " + " " + PayrollConst.NAM_DAY);
			
		}
	}
	
	private void setDtoCodeName(PaymentLedgerDto dto) {
		if (cmIncomeTaxDto != null) {
			// ېŋ敪
			dto.setIncomeTaxType(getCodeName(dto.getIncomeTaxType(), aryPltIncomeTaxType));
			// N敪
			dto.setAdjustmentType(getCodeName(dto.getAdjustmentType(), aryPltAdjustmentType));
			// {l敪1
			dto.setSelfWidowType(getCodeName(dto.getSelfWidowType(), aryPltWidowType));
			// {l敪2
			dto.setSelfHandicapType(getCodeName(dto.getSelfHandicapType(), aryPltHandicapType));
			// {l敪3
			dto.setSelfStudentType(getCodeName(dto.getSelfStudentType(), aryPltStudentType));
			// zҋ敪
			dto.setSpouseIntendType(getCodeName(dto.getSpouseIntendType(), aryPltSpouseIntendType));
		}
		if (mKojinDto != null) {
			// 
			dto.setGender(getCodeName(dto.getGender(), aryGender));
		}
		if (mKihonDto != null) {
			// R[h
			String stationCode = dto.getPositionCode() + " - " + dto.getStationCode();
			// 
			String stationName = getCodeName(dto.getPositionCode(), aryPosition)
					+ getCodeName(dto.getStationCode(), aryStation);
			// 
			dto.setStationCode(stationCode + "  " + stationName);
		}
		// EsȂ̂ŋ
		dto.setPositionCode("");
		
	}
	
	/**
	 * [o͏sB(Excel)<br><br>
	 * @throws Exception 
	 */
	private void reportXls(AdjustmentReferVo vo, PaymentLedgerDto dto) throws Exception {
		int line;
		int column;
		
		// RlNV擾
		getConnection();
		// [쐬
		PoiUtility poi = new PoiUtility();
		poi.crtNewDocR(0, cfg.getProperty(MospConst.PPT_APP_DOCBASE) + PayrollConst.TEMPLATE_PAYMENTLEDGER_XLS);
		
		// wb_[
		line = 0;
		column = 13;
		poi.prtItem(line + 0, column + 0, dto.getOutputYear()); // ΏۘaNx(^Cg)
		poi.prtItem(line + 73, column + 0, dto.getOutputYear()); // ΏۘaNx(^Cg)
		
		line = 2;
		column = 0;
		poi.prtItem(line + 0, column + 0, dto.getCompanyName()); // Ж
		poi.prtItem(line + 73, column + 0, dto.getCompanyName()); // Ж
		
		line = 2;
		column = 38;
		poi.prtItem(line + 0, column + 0, dto.getOutputDate()); // o͓t
		poi.prtItem(line + 73, column + 0, dto.getOutputDate()); // o͓t
		
		line = 4;
		column = 2;
		poi.prtItem(line + 0, column + 0, vo.getEscLblStationName()); // 
		prtItemChk(poi, line + 73, column + 0, vo.getEscLblStationName()); // 
		prtItemChk(poi, line + 130, column + 0, vo.getEscLblStationName()); // 
		
		line = 4;
		column = 10;
		prtItemChk(poi, line + 0, column + 0, vo.getEscLblPositionName()); // Eʖ		
		prtItemChk(poi, line + 73, column + 0, vo.getEscLblPositionName()); // Eʖ
		prtItemChk(poi, line + 131, 2, vo.getEscLblPositionName()); // Eʖ
		
		line = 4;
		column = 19;
		prtItemChk(poi, line + 0, column + 0, dto.getKCode()); // ЈR[h
		prtItemChk(poi, line + 73, column + 0, dto.getKCode()); // ЈR[h
		prtItemChk(poi, line + 132, 2, dto.getKCode()); // ЈR[h
		
		line = 4;
		column = 24;
		prtItemChk(poi, line + 0, column + 0, dto.getKName()); // 
		prtItemChk(poi, line + 73, column + 0, dto.getKName()); // 
		prtItemChk(poi, line + 133, 2, dto.getKName()); // 
		
		/** ^ڏo **/
		// ږo
		line = 8;
		column = 0;
		prtItemChk(poi, line + 0, column + 0, dto.getTitleAllowanceItem()); // xږ^Cg
		prtItemChk(poi, line + 1, column + 0, dto.getTitlePayAllowance01()); // ^x01^Cg
		prtItemChk(poi, line + 2, column + 0, dto.getTitlePayAllowance02()); // ^x02^Cg
		prtItemChk(poi, line + 3, column + 0, dto.getTitlePayAllowance03()); // ^x03^Cg
		prtItemChk(poi, line + 4, column + 0, dto.getTitlePayAllowance04()); // ^x04^Cg
		prtItemChk(poi, line + 5, column + 0, dto.getTitlePayAllowance05()); // ^x05^Cg
		prtItemChk(poi, line + 6, column + 0, dto.getTitlePayAllowance06()); // ^x06^Cg
		prtItemChk(poi, line + 7, column + 0, dto.getTitlePayAllowance07()); // ^x07^Cg
		prtItemChk(poi, line + 8, column + 0, dto.getTitlePayAllowance08()); // ^x08^Cg
		prtItemChk(poi, line + 9, column + 0, dto.getTitlePayAllowance09()); // ^x09^Cg
		prtItemChk(poi, line + 10, column + 0, dto.getTitlePayAllowance10()); // ^x10^Cg
		prtItemChk(poi, line + 11, column + 0, dto.getTitlePayAllowance11()); // ^x11^Cg
		prtItemChk(poi, line + 12, column + 0, dto.getTitlePayAllowance12()); // ^x12^Cg
		prtItemChk(poi, line + 13, column + 0, dto.getTitlePayAllowance13()); // ^x13^Cg
		prtItemChk(poi, line + 14, column + 0, dto.getTitlePayAllowance14()); // ^x14^Cg
		prtItemChk(poi, line + 15, column + 0, dto.getTitlePayAllowance15()); // ^x15^Cg
		prtItemChk(poi, line + 16, column + 0, dto.getTitlePayAllowance16()); // ^x16^Cg
		prtItemChk(poi, line + 17, column + 0, dto.getTitlePayAllowance17()); // ^x17^Cg
		prtItemChk(poi, line + 18, column + 0, dto.getTitlePayAllowance18()); // ^x18^Cg
		prtItemChk(poi, line + 19, column + 0, dto.getTitlePayAllowance19()); // ^x19^Cg
		prtItemChk(poi, line + 20, column + 0, dto.getTitlePayAllowance20()); // ^x20^Cg
		prtItemChk(poi, line + 21, column + 0, dto.getTitlePayAllowance21()); // ^x21^Cg
		prtItemChk(poi, line + 22, column + 0, dto.getTitlePayAllowance22()); // ^x22^Cg
		prtItemChk(poi, line + 23, column + 0, dto.getTitlePayAllowance23()); // ^x23^Cg
		prtItemChk(poi, line + 24, column + 0, dto.getTitlePayAllowance24()); // ^x24^Cg
		prtItemChk(poi, line + 25, column + 0, dto.getTitlePayAllowance25()); // ^x25^Cg
		prtItemChk(poi, line + 26, column + 0, dto.getTitlePayAllowance26()); // ^x26^Cg
		prtItemChk(poi, line + 27, column + 0, dto.getTitlePayAllowance27()); // ^x27^Cg
		prtItemChk(poi, line + 28, column + 0, dto.getTitlePayAllowance28()); // ^x28^Cg
		prtItemChk(poi, line + 29, column + 0, dto.getTitlePayAllowance29()); // ^x29^Cg
		prtItemChk(poi, line + 30, column + 0, dto.getTitlePayAllowance30()); // ^x30^Cg
		prtItemChk(poi, line + 31, column + 0, dto.getTitleAllowanceTotal()); // xz^Cg		
		
		line = 40;
		prtItemChk(poi, line + 0, column + 0, "" + dto.getTitleDeductionItem() + ""); // Tڃ^Cg  
		prtItemChk(poi, line + 1, column + 0, dto.getTitlePayDeduction01()); // ^T01^Cg
		prtItemChk(poi, line + 2, column + 0, dto.getTitlePayDeduction02()); // ^T02^Cg
		prtItemChk(poi, line + 3, column + 0, dto.getTitlePayDeduction03()); // ^T03^Cg
		prtItemChk(poi, line + 4, column + 0, dto.getTitlePayDeduction04()); // ^T04^Cg
		prtItemChk(poi, line + 5, column + 0, dto.getTitlePayDeduction05()); // ^T05^Cg
		prtItemChk(poi, line + 6, column + 0, dto.getTitlePayDeduction06()); // ^T06^Cg
		prtItemChk(poi, line + 7, column + 0, dto.getTitlePayDeduction07()); // ^T07^Cg
		prtItemChk(poi, line + 8, column + 0, dto.getTitlePayDeduction08()); // ^T08^Cg
		prtItemChk(poi, line + 9, column + 0, dto.getTitlePayDeduction09()); // ^T09^Cg
		prtItemChk(poi, line + 10, column + 0, dto.getTitlePayDeduction10()); // ^T10^Cg
		prtItemChk(poi, line + 11, column + 0, dto.getTitlePayDeduction11()); // ^T11^Cg
		prtItemChk(poi, line + 12, column + 0, dto.getTitlePayDeduction12()); // ^T12^Cg
		prtItemChk(poi, line + 13, column + 0, dto.getTitlePayDeduction14()); // ^T14^Cg
		prtItemChk(poi, line + 14, column + 0, dto.getTitlePayDeduction15()); // ^T15^Cg
		prtItemChk(poi, line + 15, column + 0, dto.getTitlePayDeduction16()); // ^T16^Cg
		prtItemChk(poi, line + 16, column + 0, dto.getTitlePayDeduction17()); // ^T17^Cg
		prtItemChk(poi, line + 17, column + 0, dto.getTitlePayDeduction18()); // ^T18^Cg
		prtItemChk(poi, line + 18, column + 0, dto.getTitlePayDeduction19()); // ^T19^Cg
		prtItemChk(poi, line + 19, column + 0, dto.getTitlePayDeduction20()); // ^T20^Cg
		prtItemChk(poi, line + 20, column + 0, dto.getTitlePayDeduction21()); // ^T21^Cg
		prtItemChk(poi, line + 21, column + 0, dto.getTitlePayDeduction22()); // ^T22^Cg
		prtItemChk(poi, line + 22, column + 0, dto.getTitlePayDeduction23()); // ^T23^Cg
		prtItemChk(poi, line + 23, column + 0, dto.getTitlePayDeduction24()); // ^T24^Cg
		prtItemChk(poi, line + 24, column + 0, dto.getTitlePayDeduction25()); // ^T25^Cg
		prtItemChk(poi, line + 25, column + 0, dto.getTitleDeductionTotal()); // Tz^Cg
		prtItemChk(poi, line + 26, column + 0, dto.getTitlePayDeduction26()); // ^T26^Cg
		prtItemChk(poi, line + 27, column + 0, dto.getTitlePaymentTotal()); // xz^Cg
		prtItemChk(poi, line + 28, column + 0, dto.getTitleBank1PayAmount()); // s1Uz
		prtItemChk(poi, line + 29, column + 0, dto.getTitleBank2PayAmount()); // s2Uz
		prtItemChk(poi, line + 30, column + 0, dto.getTitleCashPayAmount()); // xz
		prtItemChk(poi, line + 31, column + 0, dto.getTitlePayDeduction27()); // ^T27^Cg
		
		// ^׏o
		line = 8;
		column = 3; // 1
		if (null != dto.getPayPayday01()) {
			prtItemChk(poi, line - 1, column, dto.getPayPayday01()); // ^xNo01
		}
		if (null != dto.getPayAllowance01No01()) {
			prtItemChk(poi, line + 1, column, dto.getPayAllowance01No01()); // ^x01No01
		}
		if (null != dto.getPayAllowance02No01()) {
			prtItemChk(poi, line + 2, column, dto.getPayAllowance02No01()); // ^x02No01
		}
		if (null != dto.getPayAllowance03No01()) {
			prtItemChk(poi, line + 3, column, dto.getPayAllowance03No01()); // ^x03No01
		}
		if (null != dto.getPayAllowance04No01()) {
			prtItemChk(poi, line + 4, column, dto.getPayAllowance04No01()); // ^x04No01
		}
		if (null != dto.getPayAllowance05No01()) {
			prtItemChk(poi, line + 5, column, dto.getPayAllowance05No01()); // ^x05No01
		}
		if (null != dto.getPayAllowance06No01()) {
			prtItemChk(poi, line + 6, column, dto.getPayAllowance06No01()); // ^x06No01
		}
		if (null != dto.getPayAllowance07No01()) {
			prtItemChk(poi, line + 7, column, dto.getPayAllowance07No01()); // ^x07No01
		}
		if (null != dto.getPayAllowance08No01()) {
			prtItemChk(poi, line + 8, column, dto.getPayAllowance08No01()); // ^x08No01
		}
		if (null != dto.getPayAllowance09No01()) {
			prtItemChk(poi, line + 9, column, dto.getPayAllowance09No01()); // ^x09No01
		}
		if (null != dto.getPayAllowance10No01()) {
			prtItemChk(poi, line + 10, column, dto.getPayAllowance10No01()); // ^x10No01
		}
		if (null != dto.getPayAllowance11No01()) {
			prtItemChk(poi, line + 11, column, dto.getPayAllowance11No01()); // ^x11No01
		}
		if (null != dto.getPayAllowance12No01()) {
			prtItemChk(poi, line + 12, column, dto.getPayAllowance12No01()); // ^x12No01
		}
		if (null != dto.getPayAllowance13No01()) {
			prtItemChk(poi, line + 13, column, dto.getPayAllowance13No01()); // ^x13No01
		}
		if (null != dto.getPayAllowance14No01()) {
			prtItemChk(poi, line + 14, column, dto.getPayAllowance14No01()); // ^x14No01
		}
		if (null != dto.getPayAllowance15No01()) {
			prtItemChk(poi, line + 15, column, dto.getPayAllowance15No01()); // ^x15No01
		}
		if (null != dto.getPayAllowance16No01()) {
			prtItemChk(poi, line + 16, column, dto.getPayAllowance16No01()); // ^x16No01
		}
		if (null != dto.getPayAllowance17No01()) {
			prtItemChk(poi, line + 17, column, dto.getPayAllowance17No01()); // ^x17No01
		}
		if (null != dto.getPayAllowance18No01()) {
			prtItemChk(poi, line + 18, column, dto.getPayAllowance18No01()); // ^x18No01
		}
		if (null != dto.getPayAllowance19No01()) {
			prtItemChk(poi, line + 19, column, dto.getPayAllowance19No01()); // ^x19No01
		}
		if (null != dto.getPayAllowance20No01()) {
			prtItemChk(poi, line + 20, column, dto.getPayAllowance20No01()); // ^x20No01
		}
		if (null != dto.getPayAllowance21No01()) {
			prtItemChk(poi, line + 21, column, dto.getPayAllowance21No01()); // ^x21No01
		}
		if (null != dto.getPayAllowance22No01()) {
			prtItemChk(poi, line + 22, column, dto.getPayAllowance22No01()); // ^x22No01
		}
		if (null != dto.getPayAllowance23No01()) {
			prtItemChk(poi, line + 23, column, dto.getPayAllowance23No01()); // ^x23No01
		}
		if (null != dto.getPayAllowance24No01()) {
			prtItemChk(poi, line + 24, column, dto.getPayAllowance24No01()); // ^x24No01
		}
		if (null != dto.getPayAllowance25No01()) {
			prtItemChk(poi, line + 25, column, dto.getPayAllowance25No01()); // ^x25No01
		}
		if (null != dto.getPayAllowance26No01()) {
			prtItemChk(poi, line + 26, column, dto.getPayAllowance26No01()); // ^x26No01
		}
		if (null != dto.getPayAllowance27No01()) {
			prtItemChk(poi, line + 27, column, dto.getPayAllowance27No01()); // ^x27No01
		}
		if (null != dto.getPayAllowance28No01()) {
			prtItemChk(poi, line + 28, column, dto.getPayAllowance28No01()); // ^x28No01
		}
		if (null != dto.getPayAllowance29No01()) {
			prtItemChk(poi, line + 29, column, dto.getPayAllowance29No01()); // ^x29No01
		}
		if (null != dto.getPayAllowance30No01()) {
			prtItemChk(poi, line + 30, column, dto.getPayAllowance30No01()); // ^x30No01
		}
		if (null != dto.getPayAllowanceTotal01()) {
			prtItemChk(poi, line + 31, column, dto.getPayAllowanceTotal01()); // ^xzNo01
		}
		line = 40;
		if (null != dto.getPayDeduction01No01()) {
			prtItemChk(poi, line + 1, column, dto.getPayDeduction01No01()); // ^T01No01
		}
		if (null != dto.getPayDeduction02No01()) {
			prtItemChk(poi, line + 2, column, dto.getPayDeduction02No01()); // ^T02No01
		}
		if (null != dto.getPayDeduction03No01()) {
			prtItemChk(poi, line + 3, column, dto.getPayDeduction03No01()); // ^T03No01
		}
		if (null != dto.getPayDeduction04No01()) {
			prtItemChk(poi, line + 4, column, dto.getPayDeduction04No01()); // ^T04No01
		}
		if (null != dto.getPayDeduction05No01()) {
			prtItemChk(poi, line + 5, column, dto.getPayDeduction05No01()); // ^T05No01
		}
		if (null != dto.getPayDeduction06No01()) {
			prtItemChk(poi, line + 6, column, dto.getPayDeduction06No01()); // ^T06No01
		}
		if (null != dto.getPayDeduction07No01()) {
			prtItemChk(poi, line + 7, column, dto.getPayDeduction07No01()); // ^T07No01
		}
		if (null != dto.getPayDeduction08No01()) {
			prtItemChk(poi, line + 8, column, dto.getPayDeduction08No01()); // ^T08No01
		}
		if (null != dto.getPayDeduction09No01()) {
			prtItemChk(poi, line + 9, column, dto.getPayDeduction09No01()); // ^T09No01
		}
		if (null != dto.getPayDeduction10No01()) {
			prtItemChk(poi, line + 10, column, dto.getPayDeduction10No01()); // ^T10No01
		}
		if (null != dto.getPayDeduction11No01()) {
			prtItemChk(poi, line + 11, column, dto.getPayDeduction11No01()); // ^T11No01
		}
		if (null != dto.getPayDeduction12No01()) {
			prtItemChk(poi, line + 12, column, dto.getPayDeduction12No01()); // ^T12No01
		}
		if (null != dto.getPayDeduction14No01()) {
			prtItemChk(poi, line + 13, column, dto.getPayDeduction14No01()); // ^T14No01
		}
		if (null != dto.getPayDeduction15No01()) {
			prtItemChk(poi, line + 14, column, dto.getPayDeduction15No01()); // ^T15No01
		}
		if (null != dto.getPayDeduction16No01()) {
			prtItemChk(poi, line + 15, column, dto.getPayDeduction16No01()); // ^T16No01
		}
		if (null != dto.getPayDeduction17No01()) {
			prtItemChk(poi, line + 16, column, dto.getPayDeduction17No01()); // ^T17No01
		}
		if (null != dto.getPayDeduction18No01()) {
			prtItemChk(poi, line + 17, column, dto.getPayDeduction18No01()); // ^T18No01
		}
		if (null != dto.getPayDeduction19No01()) {
			prtItemChk(poi, line + 18, column, dto.getPayDeduction19No01()); // ^T19No01
		}
		if (null != dto.getPayDeduction20No01()) {
			prtItemChk(poi, line + 19, column, dto.getPayDeduction20No01()); // ^T20No01
		}
		if (null != dto.getPayDeduction21No01()) {
			prtItemChk(poi, line + 20, column, dto.getPayDeduction21No01()); // ^T21No01
		}
		if (null != dto.getPayDeduction22No01()) {
			prtItemChk(poi, line + 21, column, dto.getPayDeduction22No01()); // ^T22No01
		}
		if (null != dto.getPayDeduction23No01()) {
			prtItemChk(poi, line + 22, column, dto.getPayDeduction23No01()); // ^T23No01
		}
		if (null != dto.getPayDeduction24No01()) {
			prtItemChk(poi, line + 23, column, dto.getPayDeduction24No01()); // ^T24No01
		}
		if (null != dto.getPayDeduction25No01()) {
			prtItemChk(poi, line + 24, column, dto.getPayDeduction25No01()); // ^T25No01
		}
		if (null != dto.getPayDeductionTotal01()) {
			prtItemChk(poi, line + 25, column, dto.getPayDeductionTotal01()); // ^TzNo01
		}
		if (null != dto.getPayDeduction26No01()) {
			prtItemChk(poi, line + 26, column, dto.getPayDeduction26No01()); // ^T26No01
		}
		if (null != dto.getPayPaymentTotal01()) {
			prtItemChk(poi, line + 27, column, dto.getPayPaymentTotal01()); // ^xzNo01
		}
		if (null != dto.getPayBank1PayAmount01()) {
			prtItemChk(poi, line + 28, column, dto.getPayBank1PayAmount01()); // ^s1UzNo01
		}
		if (null != dto.getPayBank2PayAmount01()) {
			prtItemChk(poi, line + 29, column, dto.getPayBank2PayAmount01()); // ^s2UzNo01
		}
		if (null != dto.getPayCashPayAmount01()) {
			prtItemChk(poi, line + 30, column, dto.getPayCashPayAmount01()); // xzNo01
		}
		if (null != dto.getPayDeduction27No01()) {
			prtItemChk(poi, line + 31, column, dto.getPayDeduction27No01()); // ^T27No01
		}
		
		line = 8;
		column = 6; // 2
		if (null != dto.getPayPayday02()) {
			prtItemChk(poi, line - 1, column, dto.getPayPayday02()); // ^xNo02
		}
		if (null != dto.getPayAllowance01No02()) {
			prtItemChk(poi, line + 1, column, dto.getPayAllowance01No02()); // ^x01No02
		}
		if (null != dto.getPayAllowance02No02()) {
			prtItemChk(poi, line + 2, column, dto.getPayAllowance02No02()); // ^x02No02
		}
		if (null != dto.getPayAllowance03No02()) {
			prtItemChk(poi, line + 3, column, dto.getPayAllowance03No02()); // ^x03No02
		}
		if (null != dto.getPayAllowance04No02()) {
			prtItemChk(poi, line + 4, column, dto.getPayAllowance04No02()); // ^x04No02
		}
		if (null != dto.getPayAllowance05No02()) {
			prtItemChk(poi, line + 5, column, dto.getPayAllowance05No02()); // ^x05No02
		}
		if (null != dto.getPayAllowance06No02()) {
			prtItemChk(poi, line + 6, column, dto.getPayAllowance06No02()); // ^x06No02
		}
		if (null != dto.getPayAllowance07No02()) {
			prtItemChk(poi, line + 7, column, dto.getPayAllowance07No02()); // ^x07No02
		}
		if (null != dto.getPayAllowance08No02()) {
			prtItemChk(poi, line + 8, column, dto.getPayAllowance08No02()); // ^x08No02
		}
		if (null != dto.getPayAllowance09No02()) {
			prtItemChk(poi, line + 9, column, dto.getPayAllowance09No02()); // ^x09No02
		}
		if (null != dto.getPayAllowance10No02()) {
			prtItemChk(poi, line + 10, column, dto.getPayAllowance10No02()); // ^x10No02
		}
		if (null != dto.getPayAllowance11No02()) {
			prtItemChk(poi, line + 11, column, dto.getPayAllowance11No02()); // ^x11No02
		}
		if (null != dto.getPayAllowance12No02()) {
			prtItemChk(poi, line + 12, column, dto.getPayAllowance12No02()); // ^x12No02
		}
		if (null != dto.getPayAllowance13No02()) {
			prtItemChk(poi, line + 13, column, dto.getPayAllowance13No02()); // ^x13No02
		}
		if (null != dto.getPayAllowance14No02()) {
			prtItemChk(poi, line + 14, column, dto.getPayAllowance14No02()); // ^x14No02
		}
		if (null != dto.getPayAllowance15No02()) {
			prtItemChk(poi, line + 15, column, dto.getPayAllowance15No02()); // ^x15No02
		}
		if (null != dto.getPayAllowance16No02()) {
			prtItemChk(poi, line + 16, column, dto.getPayAllowance16No02()); // ^x16No02
		}
		if (null != dto.getPayAllowance17No02()) {
			prtItemChk(poi, line + 17, column, dto.getPayAllowance17No02()); // ^x17No02
		}
		if (null != dto.getPayAllowance18No02()) {
			prtItemChk(poi, line + 18, column, dto.getPayAllowance18No02()); // ^x18No02
		}
		if (null != dto.getPayAllowance19No02()) {
			prtItemChk(poi, line + 19, column, dto.getPayAllowance19No02()); // ^x19No02
		}
		if (null != dto.getPayAllowance20No02()) {
			prtItemChk(poi, line + 20, column, dto.getPayAllowance20No02()); // ^x20No02
		}
		if (null != dto.getPayAllowance21No02()) {
			prtItemChk(poi, line + 21, column, dto.getPayAllowance21No02()); // ^x21No02
		}
		if (null != dto.getPayAllowance22No02()) {
			prtItemChk(poi, line + 22, column, dto.getPayAllowance22No02()); // ^x22No02
		}
		if (null != dto.getPayAllowance23No02()) {
			prtItemChk(poi, line + 23, column, dto.getPayAllowance23No02()); // ^x23No02
		}
		if (null != dto.getPayAllowance24No02()) {
			prtItemChk(poi, line + 24, column, dto.getPayAllowance24No02()); // ^x24No02
		}
		if (null != dto.getPayAllowance25No02()) {
			prtItemChk(poi, line + 25, column, dto.getPayAllowance25No02()); // ^x25No02
		}
		if (null != dto.getPayAllowance26No02()) {
			prtItemChk(poi, line + 26, column, dto.getPayAllowance26No02()); // ^x26No02
		}
		if (null != dto.getPayAllowance27No02()) {
			prtItemChk(poi, line + 27, column, dto.getPayAllowance27No02()); // ^x27No02
		}
		if (null != dto.getPayAllowance28No02()) {
			prtItemChk(poi, line + 28, column, dto.getPayAllowance28No02()); // ^x28No02
		}
		if (null != dto.getPayAllowance29No02()) {
			prtItemChk(poi, line + 29, column, dto.getPayAllowance29No02()); // ^x29No02
		}
		if (null != dto.getPayAllowance30No02()) {
			prtItemChk(poi, line + 30, column, dto.getPayAllowance30No02()); // ^x30No02
		}
		if (null != dto.getPayAllowanceTotal02()) {
			prtItemChk(poi, line + 31, column, dto.getPayAllowanceTotal02()); // ^xzNo02
		}
		line = 40;
		if (null != dto.getPayDeduction01No02()) {
			prtItemChk(poi, line + 1, column, dto.getPayDeduction01No02()); // ^T01No02
		}
		if (null != dto.getPayDeduction02No02()) {
			prtItemChk(poi, line + 2, column, dto.getPayDeduction02No02()); // ^T02No02
		}
		if (null != dto.getPayDeduction03No02()) {
			prtItemChk(poi, line + 3, column, dto.getPayDeduction03No02()); // ^T03No02
		}
		if (null != dto.getPayDeduction04No02()) {
			prtItemChk(poi, line + 4, column, dto.getPayDeduction04No02()); // ^T04No02
		}
		if (null != dto.getPayDeduction05No02()) {
			prtItemChk(poi, line + 5, column, dto.getPayDeduction05No02()); // ^T05No02
		}
		if (null != dto.getPayDeduction06No02()) {
			prtItemChk(poi, line + 6, column, dto.getPayDeduction06No02()); // ^T06No02
		}
		if (null != dto.getPayDeduction07No02()) {
			prtItemChk(poi, line + 7, column, dto.getPayDeduction07No02()); // ^T07No02
		}
		if (null != dto.getPayDeduction08No02()) {
			prtItemChk(poi, line + 8, column, dto.getPayDeduction08No02()); // ^T08No02
		}
		if (null != dto.getPayDeduction09No02()) {
			prtItemChk(poi, line + 9, column, dto.getPayDeduction09No02()); // ^T09No02
		}
		if (null != dto.getPayDeduction10No02()) {
			prtItemChk(poi, line + 10, column, dto.getPayDeduction10No02()); // ^T10No02
		}
		if (null != dto.getPayDeduction11No02()) {
			prtItemChk(poi, line + 11, column, dto.getPayDeduction11No02()); // ^T11No02
		}
		if (null != dto.getPayDeduction12No02()) {
			prtItemChk(poi, line + 12, column, dto.getPayDeduction12No02()); // ^T12No02
		}
		if (null != dto.getPayDeduction14No02()) {
			prtItemChk(poi, line + 13, column, dto.getPayDeduction14No02()); // ^T14No02
		}
		if (null != dto.getPayDeduction15No02()) {
			prtItemChk(poi, line + 14, column, dto.getPayDeduction15No02()); // ^T15No02
		}
		if (null != dto.getPayDeduction16No02()) {
			prtItemChk(poi, line + 15, column, dto.getPayDeduction16No02()); // ^T16No02
		}
		if (null != dto.getPayDeduction17No02()) {
			prtItemChk(poi, line + 16, column, dto.getPayDeduction17No02()); // ^T17No02
		}
		if (null != dto.getPayDeduction18No02()) {
			prtItemChk(poi, line + 17, column, dto.getPayDeduction18No02()); // ^T18No02
		}
		if (null != dto.getPayDeduction19No02()) {
			prtItemChk(poi, line + 18, column, dto.getPayDeduction19No02()); // ^T19No02
		}
		if (null != dto.getPayDeduction20No02()) {
			prtItemChk(poi, line + 19, column, dto.getPayDeduction20No02()); // ^T20No02
		}
		if (null != dto.getPayDeduction21No02()) {
			prtItemChk(poi, line + 20, column, dto.getPayDeduction21No02()); // ^T21No02
		}
		if (null != dto.getPayDeduction22No02()) {
			prtItemChk(poi, line + 21, column, dto.getPayDeduction22No02()); // ^T22No02
		}
		if (null != dto.getPayDeduction23No02()) {
			prtItemChk(poi, line + 22, column, dto.getPayDeduction23No02()); // ^T23No02
		}
		if (null != dto.getPayDeduction24No02()) {
			prtItemChk(poi, line + 23, column, dto.getPayDeduction24No02()); // ^T24No02
		}
		if (null != dto.getPayDeduction25No02()) {
			prtItemChk(poi, line + 24, column, dto.getPayDeduction25No02()); // ^T25No02
		}
		if (null != dto.getPayDeductionTotal02()) {
			prtItemChk(poi, line + 25, column, dto.getPayDeductionTotal02()); // ^TzNo02
		}
		if (null != dto.getPayDeduction26No02()) {
			prtItemChk(poi, line + 26, column, dto.getPayDeduction26No02()); // ^T26No02
		}
		if (null != dto.getPayPaymentTotal02()) {
			prtItemChk(poi, line + 27, column, dto.getPayPaymentTotal02()); // ^xzNo02
		}
		if (null != dto.getPayBank1PayAmount02()) {
			prtItemChk(poi, line + 28, column, dto.getPayBank1PayAmount02()); // ^s1UzNo02
		}
		if (null != dto.getPayBank2PayAmount02()) {
			prtItemChk(poi, line + 29, column, dto.getPayBank2PayAmount02()); // ^s2UzNo02
		}
		if (null != dto.getPayCashPayAmount02()) {
			prtItemChk(poi, line + 30, column, dto.getPayCashPayAmount02()); // xzNo02
		}
		if (null != dto.getPayDeduction27No02()) {
			prtItemChk(poi, line + 31, column, dto.getPayDeduction27No02()); // ^T27No02
		}
		
		line = 8;
		column = 9; // 3
		if (null != dto.getPayPayday03()) {
			prtItemChk(poi, line - 1, column, dto.getPayPayday03()); // ^xNo03
		}
		if (null != dto.getPayAllowance01No03()) {
			prtItemChk(poi, line + 1, column, dto.getPayAllowance01No03()); // ^x01No03
		}
		if (null != dto.getPayAllowance02No03()) {
			prtItemChk(poi, line + 2, column, dto.getPayAllowance02No03()); // ^x02No03
		}
		if (null != dto.getPayAllowance03No03()) {
			prtItemChk(poi, line + 3, column, dto.getPayAllowance03No03()); // ^x03No03
		}
		if (null != dto.getPayAllowance04No03()) {
			prtItemChk(poi, line + 4, column, dto.getPayAllowance04No03()); // ^x04No03
		}
		if (null != dto.getPayAllowance05No03()) {
			prtItemChk(poi, line + 5, column, dto.getPayAllowance05No03()); // ^x05No03
		}
		if (null != dto.getPayAllowance06No03()) {
			prtItemChk(poi, line + 6, column, dto.getPayAllowance06No03()); // ^x06No03
		}
		if (null != dto.getPayAllowance07No03()) {
			prtItemChk(poi, line + 7, column, dto.getPayAllowance07No03()); // ^x07No03
		}
		if (null != dto.getPayAllowance08No03()) {
			prtItemChk(poi, line + 8, column, dto.getPayAllowance08No03()); // ^x08No03
		}
		if (null != dto.getPayAllowance09No03()) {
			prtItemChk(poi, line + 9, column, dto.getPayAllowance09No03()); // ^x09No03
		}
		if (null != dto.getPayAllowance10No03()) {
			prtItemChk(poi, line + 10, column, dto.getPayAllowance10No03()); // ^x10No03
		}
		if (null != dto.getPayAllowance11No03()) {
			prtItemChk(poi, line + 11, column, dto.getPayAllowance11No03()); // ^x11No03
		}
		if (null != dto.getPayAllowance12No03()) {
			prtItemChk(poi, line + 12, column, dto.getPayAllowance12No03()); // ^x12No03
		}
		if (null != dto.getPayAllowance13No03()) {
			prtItemChk(poi, line + 13, column, dto.getPayAllowance13No03()); // ^x13No03
		}
		if (null != dto.getPayAllowance14No03()) {
			prtItemChk(poi, line + 14, column, dto.getPayAllowance14No03()); // ^x14No03
		}
		if (null != dto.getPayAllowance15No03()) {
			prtItemChk(poi, line + 15, column, dto.getPayAllowance15No03()); // ^x15No03
		}
		if (null != dto.getPayAllowance16No03()) {
			prtItemChk(poi, line + 16, column, dto.getPayAllowance16No03()); // ^x16No03
		}
		if (null != dto.getPayAllowance17No03()) {
			prtItemChk(poi, line + 17, column, dto.getPayAllowance17No03()); // ^x17No03
		}
		if (null != dto.getPayAllowance18No03()) {
			prtItemChk(poi, line + 18, column, dto.getPayAllowance18No03()); // ^x18No03
		}
		if (null != dto.getPayAllowance19No03()) {
			prtItemChk(poi, line + 19, column, dto.getPayAllowance19No03()); // ^x19No03
		}
		if (null != dto.getPayAllowance20No03()) {
			prtItemChk(poi, line + 20, column, dto.getPayAllowance20No03()); // ^x20No03
		}
		if (null != dto.getPayAllowance21No03()) {
			prtItemChk(poi, line + 21, column, dto.getPayAllowance21No03()); // ^x21No03
		}
		if (null != dto.getPayAllowance22No03()) {
			prtItemChk(poi, line + 22, column, dto.getPayAllowance22No03()); // ^x22No03
		}
		if (null != dto.getPayAllowance23No03()) {
			prtItemChk(poi, line + 23, column, dto.getPayAllowance23No03()); // ^x23No03
		}
		if (null != dto.getPayAllowance24No03()) {
			prtItemChk(poi, line + 24, column, dto.getPayAllowance24No03()); // ^x24No03
		}
		if (null != dto.getPayAllowance25No03()) {
			prtItemChk(poi, line + 25, column, dto.getPayAllowance25No03()); // ^x25No03
		}
		if (null != dto.getPayAllowance26No03()) {
			prtItemChk(poi, line + 26, column, dto.getPayAllowance26No03()); // ^x26No03
		}
		if (null != dto.getPayAllowance27No03()) {
			prtItemChk(poi, line + 27, column, dto.getPayAllowance27No03()); // ^x27No03
		}
		if (null != dto.getPayAllowance28No03()) {
			prtItemChk(poi, line + 28, column, dto.getPayAllowance28No03()); // ^x28No03
		}
		if (null != dto.getPayAllowance29No03()) {
			prtItemChk(poi, line + 29, column, dto.getPayAllowance29No03()); // ^x29No03
		}
		if (null != dto.getPayAllowance30No03()) {
			prtItemChk(poi, line + 30, column, dto.getPayAllowance30No03()); // ^x30No03
		}
		if (null != dto.getPayAllowanceTotal03()) {
			prtItemChk(poi, line + 31, column, dto.getPayAllowanceTotal03()); // ^xzNo03
		}
		line = 40;
		if (null != dto.getPayDeduction01No03()) {
			prtItemChk(poi, line + 1, column, dto.getPayDeduction01No03()); // ^T01No03
		}
		if (null != dto.getPayDeduction02No03()) {
			prtItemChk(poi, line + 2, column, dto.getPayDeduction02No03()); // ^T02No03
		}
		if (null != dto.getPayDeduction03No03()) {
			prtItemChk(poi, line + 3, column, dto.getPayDeduction03No03()); // ^T03No03
		}
		if (null != dto.getPayDeduction04No03()) {
			prtItemChk(poi, line + 4, column, dto.getPayDeduction04No03()); // ^T04No03
		}
		if (null != dto.getPayDeduction05No03()) {
			prtItemChk(poi, line + 5, column, dto.getPayDeduction05No03()); // ^T05No03
		}
		if (null != dto.getPayDeduction06No03()) {
			prtItemChk(poi, line + 6, column, dto.getPayDeduction06No03()); // ^T06No03
		}
		if (null != dto.getPayDeduction07No03()) {
			prtItemChk(poi, line + 7, column, dto.getPayDeduction07No03()); // ^T07No03
		}
		if (null != dto.getPayDeduction08No03()) {
			prtItemChk(poi, line + 8, column, dto.getPayDeduction08No03()); // ^T08No03
		}
		if (null != dto.getPayDeduction09No03()) {
			prtItemChk(poi, line + 9, column, dto.getPayDeduction09No03()); // ^T09No03
		}
		if (null != dto.getPayDeduction10No03()) {
			prtItemChk(poi, line + 10, column, dto.getPayDeduction10No03()); // ^T10No03
		}
		if (null != dto.getPayDeduction11No03()) {
			prtItemChk(poi, line + 11, column, dto.getPayDeduction11No03()); // ^T11No03
		}
		if (null != dto.getPayDeduction12No03()) {
			prtItemChk(poi, line + 12, column, dto.getPayDeduction12No03()); // ^T12No03
		}
		if (null != dto.getPayDeduction14No03()) {
			prtItemChk(poi, line + 13, column, dto.getPayDeduction14No03()); // ^T14No03
		}
		if (null != dto.getPayDeduction15No03()) {
			prtItemChk(poi, line + 14, column, dto.getPayDeduction15No03()); // ^T15No03
		}
		if (null != dto.getPayDeduction16No03()) {
			prtItemChk(poi, line + 15, column, dto.getPayDeduction16No03()); // ^T16No03
		}
		if (null != dto.getPayDeduction17No03()) {
			prtItemChk(poi, line + 16, column, dto.getPayDeduction17No03()); // ^T17No03
		}
		if (null != dto.getPayDeduction18No03()) {
			prtItemChk(poi, line + 17, column, dto.getPayDeduction18No03()); // ^T18No03
		}
		if (null != dto.getPayDeduction19No03()) {
			prtItemChk(poi, line + 18, column, dto.getPayDeduction19No03()); // ^T19No03
		}
		if (null != dto.getPayDeduction20No03()) {
			prtItemChk(poi, line + 19, column, dto.getPayDeduction20No03()); // ^T20No03
		}
		if (null != dto.getPayDeduction21No03()) {
			prtItemChk(poi, line + 20, column, dto.getPayDeduction21No03()); // ^T21No03
		}
		if (null != dto.getPayDeduction22No03()) {
			prtItemChk(poi, line + 21, column, dto.getPayDeduction22No03()); // ^T22No03
		}
		if (null != dto.getPayDeduction23No03()) {
			prtItemChk(poi, line + 22, column, dto.getPayDeduction23No03()); // ^T23No03
		}
		if (null != dto.getPayDeduction24No03()) {
			prtItemChk(poi, line + 23, column, dto.getPayDeduction24No03()); // ^T24No03
		}
		if (null != dto.getPayDeduction25No03()) {
			prtItemChk(poi, line + 24, column, dto.getPayDeduction25No03()); // ^T25No03
		}
		if (null != dto.getPayDeductionTotal03()) {
			prtItemChk(poi, line + 25, column, dto.getPayDeductionTotal03()); // ^TzNo03
		}
		if (null != dto.getPayDeduction26No03()) {
			prtItemChk(poi, line + 26, column, dto.getPayDeduction26No03()); // ^T26No03
		}
		if (null != dto.getPayPaymentTotal03()) {
			prtItemChk(poi, line + 27, column, dto.getPayPaymentTotal03()); // ^xzNo03
		}
		if (null != dto.getPayBank1PayAmount03()) {
			prtItemChk(poi, line + 28, column, dto.getPayBank1PayAmount03()); // ^s1UzNo03
		}
		if (null != dto.getPayBank2PayAmount03()) {
			prtItemChk(poi, line + 29, column, dto.getPayBank2PayAmount03()); // ^s2UzNo03
		}
		if (null != dto.getPayCashPayAmount03()) {
			prtItemChk(poi, line + 30, column, dto.getPayCashPayAmount03()); // xzNo03
		}
		if (null != dto.getPayDeduction27No03()) {
			prtItemChk(poi, line + 31, column, dto.getPayDeduction27No03()); // ^T27No03
		}
		
		line = 8;
		column = 12; // 4
		if (null != dto.getPayPayday04()) {
			prtItemChk(poi, line - 1, column, dto.getPayPayday04()); // ^xNo04
		}
		if (null != dto.getPayAllowance01No04()) {
			prtItemChk(poi, line + 1, column, dto.getPayAllowance01No04()); // ^x01No04
		}
		if (null != dto.getPayAllowance02No04()) {
			prtItemChk(poi, line + 2, column, dto.getPayAllowance02No04()); // ^x02No04
		}
		if (null != dto.getPayAllowance03No04()) {
			prtItemChk(poi, line + 3, column, dto.getPayAllowance03No04()); // ^x03No04
		}
		if (null != dto.getPayAllowance04No04()) {
			prtItemChk(poi, line + 4, column, dto.getPayAllowance04No04()); // ^x04No04
		}
		if (null != dto.getPayAllowance05No04()) {
			prtItemChk(poi, line + 5, column, dto.getPayAllowance05No04()); // ^x05No04
		}
		if (null != dto.getPayAllowance06No04()) {
			prtItemChk(poi, line + 6, column, dto.getPayAllowance06No04()); // ^x06No04
		}
		if (null != dto.getPayAllowance07No04()) {
			prtItemChk(poi, line + 7, column, dto.getPayAllowance07No04()); // ^x07No04
		}
		if (null != dto.getPayAllowance08No04()) {
			prtItemChk(poi, line + 8, column, dto.getPayAllowance08No04()); // ^x08No04
		}
		if (null != dto.getPayAllowance09No04()) {
			prtItemChk(poi, line + 9, column, dto.getPayAllowance09No04()); // ^x09No04
		}
		if (null != dto.getPayAllowance10No04()) {
			prtItemChk(poi, line + 10, column, dto.getPayAllowance10No04()); // ^x10No04
		}
		if (null != dto.getPayAllowance11No04()) {
			prtItemChk(poi, line + 11, column, dto.getPayAllowance11No04()); // ^x11No04
		}
		if (null != dto.getPayAllowance12No04()) {
			prtItemChk(poi, line + 12, column, dto.getPayAllowance12No04()); // ^x12No04
		}
		if (null != dto.getPayAllowance13No04()) {
			prtItemChk(poi, line + 13, column, dto.getPayAllowance13No04()); // ^x13No04
		}
		if (null != dto.getPayAllowance14No04()) {
			prtItemChk(poi, line + 14, column, dto.getPayAllowance14No04()); // ^x14No04
		}
		if (null != dto.getPayAllowance15No04()) {
			prtItemChk(poi, line + 15, column, dto.getPayAllowance15No04()); // ^x15No04
		}
		if (null != dto.getPayAllowance16No04()) {
			prtItemChk(poi, line + 16, column, dto.getPayAllowance16No04()); // ^x16No04
		}
		if (null != dto.getPayAllowance17No04()) {
			prtItemChk(poi, line + 17, column, dto.getPayAllowance17No04()); // ^x17No04
		}
		if (null != dto.getPayAllowance18No04()) {
			prtItemChk(poi, line + 18, column, dto.getPayAllowance18No04()); // ^x18No04
		}
		if (null != dto.getPayAllowance19No04()) {
			prtItemChk(poi, line + 19, column, dto.getPayAllowance19No04()); // ^x19No04
		}
		if (null != dto.getPayAllowance20No04()) {
			prtItemChk(poi, line + 20, column, dto.getPayAllowance20No04()); // ^x20No04
		}
		if (null != dto.getPayAllowance21No04()) {
			prtItemChk(poi, line + 21, column, dto.getPayAllowance21No04()); // ^x21No04
		}
		if (null != dto.getPayAllowance22No04()) {
			prtItemChk(poi, line + 22, column, dto.getPayAllowance22No04()); // ^x22No04
		}
		if (null != dto.getPayAllowance23No04()) {
			prtItemChk(poi, line + 23, column, dto.getPayAllowance23No04()); // ^x23No04
		}
		if (null != dto.getPayAllowance24No04()) {
			prtItemChk(poi, line + 24, column, dto.getPayAllowance24No04()); // ^x24No04
		}
		if (null != dto.getPayAllowance25No04()) {
			prtItemChk(poi, line + 25, column, dto.getPayAllowance25No04()); // ^x25No04
		}
		if (null != dto.getPayAllowance26No04()) {
			prtItemChk(poi, line + 26, column, dto.getPayAllowance26No04()); // ^x26No04
		}
		if (null != dto.getPayAllowance27No04()) {
			prtItemChk(poi, line + 27, column, dto.getPayAllowance27No04()); // ^x27No04
		}
		if (null != dto.getPayAllowance28No04()) {
			prtItemChk(poi, line + 28, column, dto.getPayAllowance28No04()); // ^x28No04
		}
		if (null != dto.getPayAllowance29No04()) {
			prtItemChk(poi, line + 29, column, dto.getPayAllowance29No04()); // ^x29No04
		}
		if (null != dto.getPayAllowance30No04()) {
			prtItemChk(poi, line + 30, column, dto.getPayAllowance30No04()); // ^x30No04
		}
		if (null != dto.getPayAllowanceTotal04()) {
			prtItemChk(poi, line + 31, column, dto.getPayAllowanceTotal04()); // ^xzNo04
		}
		line = 40;
		if (null != dto.getPayDeduction01No04()) {
			prtItemChk(poi, line + 1, column, dto.getPayDeduction01No04()); // ^T01No04
		}
		if (null != dto.getPayDeduction02No04()) {
			prtItemChk(poi, line + 2, column, dto.getPayDeduction02No04()); // ^T02No04
		}
		if (null != dto.getPayDeduction03No04()) {
			prtItemChk(poi, line + 3, column, dto.getPayDeduction03No04()); // ^T03No04
		}
		if (null != dto.getPayDeduction04No04()) {
			prtItemChk(poi, line + 4, column, dto.getPayDeduction04No04()); // ^T04No04
		}
		if (null != dto.getPayDeduction05No04()) {
			prtItemChk(poi, line + 5, column, dto.getPayDeduction05No04()); // ^T05No04
		}
		if (null != dto.getPayDeduction06No04()) {
			prtItemChk(poi, line + 6, column, dto.getPayDeduction06No04()); // ^T06No04
		}
		if (null != dto.getPayDeduction07No04()) {
			prtItemChk(poi, line + 7, column, dto.getPayDeduction07No04()); // ^T07No04
		}
		if (null != dto.getPayDeduction08No04()) {
			prtItemChk(poi, line + 8, column, dto.getPayDeduction08No04()); // ^T08No04
		}
		if (null != dto.getPayDeduction09No04()) {
			prtItemChk(poi, line + 9, column, dto.getPayDeduction09No04()); // ^T09No04
		}
		if (null != dto.getPayDeduction10No04()) {
			prtItemChk(poi, line + 10, column, dto.getPayDeduction10No04()); // ^T10No04
		}
		if (null != dto.getPayDeduction11No04()) {
			prtItemChk(poi, line + 11, column, dto.getPayDeduction11No04()); // ^T11No04
		}
		if (null != dto.getPayDeduction12No04()) {
			prtItemChk(poi, line + 12, column, dto.getPayDeduction12No04()); // ^T12No04
		}
		if (null != dto.getPayDeduction14No04()) {
			prtItemChk(poi, line + 13, column, dto.getPayDeduction14No04()); // ^T14No04
		}
		if (null != dto.getPayDeduction15No04()) {
			prtItemChk(poi, line + 14, column, dto.getPayDeduction15No04()); // ^T15No04
		}
		if (null != dto.getPayDeduction16No04()) {
			prtItemChk(poi, line + 15, column, dto.getPayDeduction16No04()); // ^T16No04
		}
		if (null != dto.getPayDeduction17No04()) {
			prtItemChk(poi, line + 16, column, dto.getPayDeduction17No04()); // ^T17No04
		}
		if (null != dto.getPayDeduction18No04()) {
			prtItemChk(poi, line + 17, column, dto.getPayDeduction18No04()); // ^T18No04
		}
		if (null != dto.getPayDeduction19No04()) {
			prtItemChk(poi, line + 18, column, dto.getPayDeduction19No04()); // ^T19No04
		}
		if (null != dto.getPayDeduction20No04()) {
			prtItemChk(poi, line + 19, column, dto.getPayDeduction20No04()); // ^T20No04
		}
		if (null != dto.getPayDeduction21No04()) {
			prtItemChk(poi, line + 20, column, dto.getPayDeduction21No04()); // ^T21No04
		}
		if (null != dto.getPayDeduction22No04()) {
			prtItemChk(poi, line + 21, column, dto.getPayDeduction22No04()); // ^T22No04
		}
		if (null != dto.getPayDeduction23No04()) {
			prtItemChk(poi, line + 22, column, dto.getPayDeduction23No04()); // ^T23No04
		}
		if (null != dto.getPayDeduction24No04()) {
			prtItemChk(poi, line + 23, column, dto.getPayDeduction24No04()); // ^T24No04
		}
		if (null != dto.getPayDeduction25No04()) {
			prtItemChk(poi, line + 24, column, dto.getPayDeduction25No04()); // ^T25No04
		}
		if (null != dto.getPayDeductionTotal04()) {
			prtItemChk(poi, line + 25, column, dto.getPayDeductionTotal04()); // ^TzNo04
		}
		if (null != dto.getPayDeduction26No04()) {
			prtItemChk(poi, line + 26, column, dto.getPayDeduction26No04()); // ^T26No04
		}
		if (null != dto.getPayPaymentTotal04()) {
			prtItemChk(poi, line + 27, column, dto.getPayPaymentTotal04()); // ^xzNo04
		}
		if (null != dto.getPayBank1PayAmount04()) {
			prtItemChk(poi, line + 28, column, dto.getPayBank1PayAmount04()); // ^s1UzNo04
		}
		if (null != dto.getPayBank2PayAmount04()) {
			prtItemChk(poi, line + 29, column, dto.getPayBank2PayAmount04()); // ^s2UzNo04
		}
		if (null != dto.getPayCashPayAmount04()) {
			prtItemChk(poi, line + 30, column, dto.getPayCashPayAmount04()); // xzNo04
		}
		if (null != dto.getPayDeduction27No04()) {
			prtItemChk(poi, line + 31, column, dto.getPayDeduction27No04()); // ^T27No04
		}
		
		line = 8;
		column = 15; // 5
		if (null != dto.getPayPayday05()) {
			prtItemChk(poi, line - 1, column, dto.getPayPayday05()); // ^xNo05
		}
		if (null != dto.getPayAllowance01No05()) {
			prtItemChk(poi, line + 1, column, dto.getPayAllowance01No05()); // ^x01No05
		}
		if (null != dto.getPayAllowance02No05()) {
			prtItemChk(poi, line + 2, column, dto.getPayAllowance02No05()); // ^x02No05
		}
		if (null != dto.getPayAllowance03No05()) {
			prtItemChk(poi, line + 3, column, dto.getPayAllowance03No05()); // ^x03No05
		}
		if (null != dto.getPayAllowance04No05()) {
			prtItemChk(poi, line + 4, column, dto.getPayAllowance04No05()); // ^x04No05
		}
		if (null != dto.getPayAllowance05No05()) {
			prtItemChk(poi, line + 5, column, dto.getPayAllowance05No05()); // ^x05No05
		}
		if (null != dto.getPayAllowance06No05()) {
			prtItemChk(poi, line + 6, column, dto.getPayAllowance06No05()); // ^x06No05
		}
		if (null != dto.getPayAllowance07No05()) {
			prtItemChk(poi, line + 7, column, dto.getPayAllowance07No05()); // ^x07No05
		}
		if (null != dto.getPayAllowance08No05()) {
			prtItemChk(poi, line + 8, column, dto.getPayAllowance08No05()); // ^x08No05
		}
		if (null != dto.getPayAllowance09No05()) {
			prtItemChk(poi, line + 9, column, dto.getPayAllowance09No05()); // ^x09No05
		}
		if (null != dto.getPayAllowance10No05()) {
			prtItemChk(poi, line + 10, column, dto.getPayAllowance10No05()); // ^x10No05
		}
		if (null != dto.getPayAllowance11No05()) {
			prtItemChk(poi, line + 11, column, dto.getPayAllowance11No05()); // ^x11No05
		}
		if (null != dto.getPayAllowance12No05()) {
			prtItemChk(poi, line + 12, column, dto.getPayAllowance12No05()); // ^x12No05
		}
		if (null != dto.getPayAllowance13No05()) {
			prtItemChk(poi, line + 13, column, dto.getPayAllowance13No05()); // ^x13No05
		}
		if (null != dto.getPayAllowance14No05()) {
			prtItemChk(poi, line + 14, column, dto.getPayAllowance14No05()); // ^x14No05
		}
		if (null != dto.getPayAllowance15No05()) {
			prtItemChk(poi, line + 15, column, dto.getPayAllowance15No05()); // ^x15No05
		}
		if (null != dto.getPayAllowance16No05()) {
			prtItemChk(poi, line + 16, column, dto.getPayAllowance16No05()); // ^x16No05
		}
		if (null != dto.getPayAllowance17No05()) {
			prtItemChk(poi, line + 17, column, dto.getPayAllowance17No05()); // ^x17No05
		}
		if (null != dto.getPayAllowance18No05()) {
			prtItemChk(poi, line + 18, column, dto.getPayAllowance18No05()); // ^x18No05
		}
		if (null != dto.getPayAllowance19No05()) {
			prtItemChk(poi, line + 19, column, dto.getPayAllowance19No05()); // ^x19No05
		}
		if (null != dto.getPayAllowance20No05()) {
			prtItemChk(poi, line + 20, column, dto.getPayAllowance20No05()); // ^x20No05
		}
		if (null != dto.getPayAllowance21No05()) {
			prtItemChk(poi, line + 21, column, dto.getPayAllowance21No05()); // ^x21No05
		}
		if (null != dto.getPayAllowance22No05()) {
			prtItemChk(poi, line + 22, column, dto.getPayAllowance22No05()); // ^x22No05
		}
		if (null != dto.getPayAllowance23No05()) {
			prtItemChk(poi, line + 23, column, dto.getPayAllowance23No05()); // ^x23No05
		}
		if (null != dto.getPayAllowance24No05()) {
			prtItemChk(poi, line + 24, column, dto.getPayAllowance24No05()); // ^x24No05
		}
		if (null != dto.getPayAllowance25No05()) {
			prtItemChk(poi, line + 25, column, dto.getPayAllowance25No05()); // ^x25No05
		}
		if (null != dto.getPayAllowance26No05()) {
			prtItemChk(poi, line + 26, column, dto.getPayAllowance26No05()); // ^x26No05
		}
		if (null != dto.getPayAllowance27No05()) {
			prtItemChk(poi, line + 27, column, dto.getPayAllowance27No05()); // ^x27No05
		}
		if (null != dto.getPayAllowance28No05()) {
			prtItemChk(poi, line + 28, column, dto.getPayAllowance28No05()); // ^x28No05
		}
		if (null != dto.getPayAllowance29No05()) {
			prtItemChk(poi, line + 29, column, dto.getPayAllowance29No05()); // ^x29No05
		}
		if (null != dto.getPayAllowance30No05()) {
			prtItemChk(poi, line + 30, column, dto.getPayAllowance30No05()); // ^x30No05
		}
		if (null != dto.getPayAllowanceTotal05()) {
			prtItemChk(poi, line + 31, column, dto.getPayAllowanceTotal05()); // ^xzNo05
		}
		line = 40;
		if (null != dto.getPayDeduction01No05()) {
			prtItemChk(poi, line + 1, column, dto.getPayDeduction01No05()); // ^T01No05
		}
		if (null != dto.getPayDeduction02No05()) {
			prtItemChk(poi, line + 2, column, dto.getPayDeduction02No05()); // ^T02No05
		}
		if (null != dto.getPayDeduction03No05()) {
			prtItemChk(poi, line + 3, column, dto.getPayDeduction03No05()); // ^T03No05
		}
		if (null != dto.getPayDeduction04No05()) {
			prtItemChk(poi, line + 4, column, dto.getPayDeduction04No05()); // ^T04No05
		}
		if (null != dto.getPayDeduction05No05()) {
			prtItemChk(poi, line + 5, column, dto.getPayDeduction05No05()); // ^T05No05
		}
		if (null != dto.getPayDeduction06No05()) {
			prtItemChk(poi, line + 6, column, dto.getPayDeduction06No05()); // ^T06No05
		}
		if (null != dto.getPayDeduction07No05()) {
			prtItemChk(poi, line + 7, column, dto.getPayDeduction07No05()); // ^T07No05
		}
		if (null != dto.getPayDeduction08No05()) {
			prtItemChk(poi, line + 8, column, dto.getPayDeduction08No05()); // ^T08No05
		}
		if (null != dto.getPayDeduction09No05()) {
			prtItemChk(poi, line + 9, column, dto.getPayDeduction09No05()); // ^T09No05
		}
		if (null != dto.getPayDeduction10No05()) {
			prtItemChk(poi, line + 10, column, dto.getPayDeduction10No05()); // ^T10No05
		}
		if (null != dto.getPayDeduction11No05()) {
			prtItemChk(poi, line + 11, column, dto.getPayDeduction11No05()); // ^T11No05
		}
		if (null != dto.getPayDeduction12No05()) {
			prtItemChk(poi, line + 12, column, dto.getPayDeduction12No05()); // ^T12No05
		}
		if (null != dto.getPayDeduction14No05()) {
			prtItemChk(poi, line + 13, column, dto.getPayDeduction14No05()); // ^T14No05
		}
		if (null != dto.getPayDeduction15No05()) {
			prtItemChk(poi, line + 14, column, dto.getPayDeduction15No05()); // ^T15No05
		}
		if (null != dto.getPayDeduction16No05()) {
			prtItemChk(poi, line + 15, column, dto.getPayDeduction16No05()); // ^T16No05
		}
		if (null != dto.getPayDeduction17No05()) {
			prtItemChk(poi, line + 16, column, dto.getPayDeduction17No05()); // ^T17No05
		}
		if (null != dto.getPayDeduction18No05()) {
			prtItemChk(poi, line + 17, column, dto.getPayDeduction18No05()); // ^T18No05
		}
		if (null != dto.getPayDeduction19No05()) {
			prtItemChk(poi, line + 18, column, dto.getPayDeduction19No05()); // ^T19No05
		}
		if (null != dto.getPayDeduction20No05()) {
			prtItemChk(poi, line + 19, column, dto.getPayDeduction20No05()); // ^T20No05
		}
		if (null != dto.getPayDeduction21No05()) {
			prtItemChk(poi, line + 20, column, dto.getPayDeduction21No05()); // ^T21No05
		}
		if (null != dto.getPayDeduction22No05()) {
			prtItemChk(poi, line + 21, column, dto.getPayDeduction22No05()); // ^T22No05
		}
		if (null != dto.getPayDeduction23No05()) {
			prtItemChk(poi, line + 22, column, dto.getPayDeduction23No05()); // ^T23No05
		}
		if (null != dto.getPayDeduction24No05()) {
			prtItemChk(poi, line + 23, column, dto.getPayDeduction24No05()); // ^T24No05
		}
		if (null != dto.getPayDeduction25No05()) {
			prtItemChk(poi, line + 24, column, dto.getPayDeduction25No05()); // ^T25No05
		}
		if (null != dto.getPayDeductionTotal05()) {
			prtItemChk(poi, line + 25, column, dto.getPayDeductionTotal05()); // ^TzNo05
		}
		if (null != dto.getPayDeduction26No05()) {
			prtItemChk(poi, line + 26, column, dto.getPayDeduction26No05()); // ^T26No05
		}
		if (null != dto.getPayPaymentTotal05()) {
			prtItemChk(poi, line + 27, column, dto.getPayPaymentTotal05()); // ^xzNo05
		}
		if (null != dto.getPayBank1PayAmount05()) {
			prtItemChk(poi, line + 28, column, dto.getPayBank1PayAmount05()); // ^s1UzNo05
		}
		if (null != dto.getPayBank2PayAmount05()) {
			prtItemChk(poi, line + 29, column, dto.getPayBank2PayAmount05()); // ^s2UzNo05
		}
		if (null != dto.getPayCashPayAmount05()) {
			prtItemChk(poi, line + 30, column, dto.getPayCashPayAmount05()); // xzNo05
		}
		if (null != dto.getPayDeduction27No05()) {
			prtItemChk(poi, line + 31, column, dto.getPayDeduction27No05()); // ^T27No05
		}
		
		line = 8;
		column = 18; // 6
		if (null != dto.getPayPayday06()) {
			prtItemChk(poi, line - 1, column, dto.getPayPayday06()); // ^xNo06
		}
		if (null != dto.getPayAllowance01No06()) {
			prtItemChk(poi, line + 1, column, dto.getPayAllowance01No06()); // ^x01No06
		}
		if (null != dto.getPayAllowance02No06()) {
			prtItemChk(poi, line + 2, column, dto.getPayAllowance02No06()); // ^x02No06
		}
		if (null != dto.getPayAllowance03No06()) {
			prtItemChk(poi, line + 3, column, dto.getPayAllowance03No06()); // ^x03No06
		}
		if (null != dto.getPayAllowance04No06()) {
			prtItemChk(poi, line + 4, column, dto.getPayAllowance04No06()); // ^x04No06
		}
		if (null != dto.getPayAllowance05No06()) {
			prtItemChk(poi, line + 5, column, dto.getPayAllowance05No06()); // ^x05No06
		}
		if (null != dto.getPayAllowance06No06()) {
			prtItemChk(poi, line + 6, column, dto.getPayAllowance06No06()); // ^x06No06
		}
		if (null != dto.getPayAllowance07No06()) {
			prtItemChk(poi, line + 7, column, dto.getPayAllowance07No06()); // ^x07No06
		}
		if (null != dto.getPayAllowance08No06()) {
			prtItemChk(poi, line + 8, column, dto.getPayAllowance08No06()); // ^x08No06
		}
		if (null != dto.getPayAllowance09No06()) {
			prtItemChk(poi, line + 9, column, dto.getPayAllowance09No06()); // ^x09No06
		}
		if (null != dto.getPayAllowance10No06()) {
			prtItemChk(poi, line + 10, column, dto.getPayAllowance10No06()); // ^x10No06
		}
		if (null != dto.getPayAllowance11No06()) {
			prtItemChk(poi, line + 11, column, dto.getPayAllowance11No06()); // ^x11No06
		}
		if (null != dto.getPayAllowance12No06()) {
			prtItemChk(poi, line + 12, column, dto.getPayAllowance12No06()); // ^x12No06
		}
		if (null != dto.getPayAllowance13No06()) {
			prtItemChk(poi, line + 13, column, dto.getPayAllowance13No06()); // ^x13No06
		}
		if (null != dto.getPayAllowance14No06()) {
			prtItemChk(poi, line + 14, column, dto.getPayAllowance14No06()); // ^x14No06
		}
		if (null != dto.getPayAllowance15No06()) {
			prtItemChk(poi, line + 15, column, dto.getPayAllowance15No06()); // ^x15No06
		}
		if (null != dto.getPayAllowance16No06()) {
			prtItemChk(poi, line + 16, column, dto.getPayAllowance16No06()); // ^x16No06
		}
		if (null != dto.getPayAllowance17No06()) {
			prtItemChk(poi, line + 17, column, dto.getPayAllowance17No06()); // ^x17No06
		}
		if (null != dto.getPayAllowance18No06()) {
			prtItemChk(poi, line + 18, column, dto.getPayAllowance18No06()); // ^x18No06
		}
		if (null != dto.getPayAllowance19No06()) {
			prtItemChk(poi, line + 19, column, dto.getPayAllowance19No06()); // ^x19No06
		}
		if (null != dto.getPayAllowance20No06()) {
			prtItemChk(poi, line + 20, column, dto.getPayAllowance20No06()); // ^x20No06
		}
		if (null != dto.getPayAllowance21No06()) {
			prtItemChk(poi, line + 21, column, dto.getPayAllowance21No06()); // ^x21No06
		}
		if (null != dto.getPayAllowance22No06()) {
			prtItemChk(poi, line + 22, column, dto.getPayAllowance22No06()); // ^x22No06
		}
		if (null != dto.getPayAllowance23No06()) {
			prtItemChk(poi, line + 23, column, dto.getPayAllowance23No06()); // ^x23No06
		}
		if (null != dto.getPayAllowance24No06()) {
			prtItemChk(poi, line + 24, column, dto.getPayAllowance24No06()); // ^x24No06
		}
		if (null != dto.getPayAllowance25No06()) {
			prtItemChk(poi, line + 25, column, dto.getPayAllowance25No06()); // ^x25No06
		}
		if (null != dto.getPayAllowance26No06()) {
			prtItemChk(poi, line + 26, column, dto.getPayAllowance26No06()); // ^x26No06
		}
		if (null != dto.getPayAllowance27No06()) {
			prtItemChk(poi, line + 27, column, dto.getPayAllowance27No06()); // ^x27No06
		}
		if (null != dto.getPayAllowance28No06()) {
			prtItemChk(poi, line + 28, column, dto.getPayAllowance28No06()); // ^x28No06
		}
		if (null != dto.getPayAllowance29No06()) {
			prtItemChk(poi, line + 29, column, dto.getPayAllowance29No06()); // ^x29No06
		}
		if (null != dto.getPayAllowance30No06()) {
			prtItemChk(poi, line + 30, column, dto.getPayAllowance30No06()); // ^x30No06
		}
		if (null != dto.getPayAllowanceTotal06()) {
			prtItemChk(poi, line + 31, column, dto.getPayAllowanceTotal06()); // ^xzNo06
		}
		line = 40;
		if (null != dto.getPayDeduction01No06()) {
			prtItemChk(poi, line + 1, column, dto.getPayDeduction01No06()); // ^T01No06
		}
		if (null != dto.getPayDeduction02No06()) {
			prtItemChk(poi, line + 2, column, dto.getPayDeduction02No06()); // ^T02No06
		}
		if (null != dto.getPayDeduction03No06()) {
			prtItemChk(poi, line + 3, column, dto.getPayDeduction03No06()); // ^T03No06
		}
		if (null != dto.getPayDeduction04No06()) {
			prtItemChk(poi, line + 4, column, dto.getPayDeduction04No06()); // ^T04No06
		}
		if (null != dto.getPayDeduction05No06()) {
			prtItemChk(poi, line + 5, column, dto.getPayDeduction05No06()); // ^T05No06
		}
		if (null != dto.getPayDeduction06No06()) {
			prtItemChk(poi, line + 6, column, dto.getPayDeduction06No06()); // ^T06No06
		}
		if (null != dto.getPayDeduction07No06()) {
			prtItemChk(poi, line + 7, column, dto.getPayDeduction07No06()); // ^T07No06
		}
		if (null != dto.getPayDeduction08No06()) {
			prtItemChk(poi, line + 8, column, dto.getPayDeduction08No06()); // ^T08No06
		}
		if (null != dto.getPayDeduction09No06()) {
			prtItemChk(poi, line + 9, column, dto.getPayDeduction09No06()); // ^T09No06
		}
		if (null != dto.getPayDeduction10No06()) {
			prtItemChk(poi, line + 10, column, dto.getPayDeduction10No06()); // ^T10No06
		}
		if (null != dto.getPayDeduction11No06()) {
			prtItemChk(poi, line + 11, column, dto.getPayDeduction11No06()); // ^T11No06
		}
		if (null != dto.getPayDeduction12No06()) {
			prtItemChk(poi, line + 12, column, dto.getPayDeduction12No06()); // ^T12No06
		}
		if (null != dto.getPayDeduction14No06()) {
			prtItemChk(poi, line + 13, column, dto.getPayDeduction14No06()); // ^T14No06
		}
		if (null != dto.getPayDeduction15No06()) {
			prtItemChk(poi, line + 14, column, dto.getPayDeduction15No06()); // ^T15No06
		}
		if (null != dto.getPayDeduction16No06()) {
			prtItemChk(poi, line + 15, column, dto.getPayDeduction16No06()); // ^T16No06
		}
		if (null != dto.getPayDeduction17No06()) {
			prtItemChk(poi, line + 16, column, dto.getPayDeduction17No06()); // ^T17No06
		}
		if (null != dto.getPayDeduction18No06()) {
			prtItemChk(poi, line + 17, column, dto.getPayDeduction18No06()); // ^T18No06
		}
		if (null != dto.getPayDeduction19No06()) {
			prtItemChk(poi, line + 18, column, dto.getPayDeduction19No06()); // ^T19No06
		}
		if (null != dto.getPayDeduction20No06()) {
			prtItemChk(poi, line + 19, column, dto.getPayDeduction20No06()); // ^T20No06
		}
		if (null != dto.getPayDeduction21No06()) {
			prtItemChk(poi, line + 20, column, dto.getPayDeduction21No06()); // ^T21No06
		}
		if (null != dto.getPayDeduction22No06()) {
			prtItemChk(poi, line + 21, column, dto.getPayDeduction22No06()); // ^T22No06
		}
		if (null != dto.getPayDeduction23No06()) {
			prtItemChk(poi, line + 22, column, dto.getPayDeduction23No06()); // ^T23No06
		}
		if (null != dto.getPayDeduction24No06()) {
			prtItemChk(poi, line + 23, column, dto.getPayDeduction24No06()); // ^T24No06
		}
		if (null != dto.getPayDeduction25No06()) {
			prtItemChk(poi, line + 24, column, dto.getPayDeduction25No06()); // ^T25No06
		}
		if (null != dto.getPayDeductionTotal06()) {
			prtItemChk(poi, line + 25, column, dto.getPayDeductionTotal06()); // ^TzNo06
		}
		if (null != dto.getPayDeduction26No06()) {
			prtItemChk(poi, line + 26, column, dto.getPayDeduction26No06()); // ^T26No06
		}
		if (null != dto.getPayPaymentTotal06()) {
			prtItemChk(poi, line + 27, column, dto.getPayPaymentTotal06()); // ^xzNo06
		}
		if (null != dto.getPayBank1PayAmount06()) {
			prtItemChk(poi, line + 28, column, dto.getPayBank1PayAmount06()); // ^s1UzNo06
		}
		if (null != dto.getPayBank2PayAmount06()) {
			prtItemChk(poi, line + 29, column, dto.getPayBank2PayAmount06()); // ^s2UzNo06
		}
		if (null != dto.getPayCashPayAmount06()) {
			prtItemChk(poi, line + 30, column, dto.getPayCashPayAmount06()); // xzNo06
		}
		if (null != dto.getPayDeduction27No06()) {
			prtItemChk(poi, line + 31, column, dto.getPayDeduction27No06()); // ^T27No06
		}
		
		line = 8;
		column = 21; // 7
		if (null != dto.getPayPayday07()) {
			prtItemChk(poi, line - 1, column, dto.getPayPayday07()); // ^xNo07
		}
		if (null != dto.getPayAllowance01No07()) {
			prtItemChk(poi, line + 1, column, dto.getPayAllowance01No07()); // ^x01No07
		}
		if (null != dto.getPayAllowance02No07()) {
			prtItemChk(poi, line + 2, column, dto.getPayAllowance02No07()); // ^x02No07
		}
		if (null != dto.getPayAllowance03No07()) {
			prtItemChk(poi, line + 3, column, dto.getPayAllowance03No07()); // ^x03No07
		}
		if (null != dto.getPayAllowance04No07()) {
			prtItemChk(poi, line + 4, column, dto.getPayAllowance04No07()); // ^x04No07
		}
		if (null != dto.getPayAllowance05No07()) {
			prtItemChk(poi, line + 5, column, dto.getPayAllowance05No07()); // ^x05No07
		}
		if (null != dto.getPayAllowance06No07()) {
			prtItemChk(poi, line + 6, column, dto.getPayAllowance06No07()); // ^x06No07
		}
		if (null != dto.getPayAllowance07No07()) {
			prtItemChk(poi, line + 7, column, dto.getPayAllowance07No07()); // ^x07No07
		}
		if (null != dto.getPayAllowance08No07()) {
			prtItemChk(poi, line + 8, column, dto.getPayAllowance08No07()); // ^x08No07
		}
		if (null != dto.getPayAllowance09No07()) {
			prtItemChk(poi, line + 9, column, dto.getPayAllowance09No07()); // ^x09No07
		}
		if (null != dto.getPayAllowance10No07()) {
			prtItemChk(poi, line + 10, column, dto.getPayAllowance10No07()); // ^x10No07
		}
		if (null != dto.getPayAllowance11No07()) {
			prtItemChk(poi, line + 11, column, dto.getPayAllowance11No07()); // ^x11No07
		}
		if (null != dto.getPayAllowance12No07()) {
			prtItemChk(poi, line + 12, column, dto.getPayAllowance12No07()); // ^x12No07
		}
		if (null != dto.getPayAllowance13No07()) {
			prtItemChk(poi, line + 13, column, dto.getPayAllowance13No07()); // ^x13No07
		}
		if (null != dto.getPayAllowance14No07()) {
			prtItemChk(poi, line + 14, column, dto.getPayAllowance14No07()); // ^x14No07
		}
		if (null != dto.getPayAllowance15No07()) {
			prtItemChk(poi, line + 15, column, dto.getPayAllowance15No07()); // ^x15No07
		}
		if (null != dto.getPayAllowance16No07()) {
			prtItemChk(poi, line + 16, column, dto.getPayAllowance16No07()); // ^x16No07
		}
		if (null != dto.getPayAllowance17No07()) {
			prtItemChk(poi, line + 17, column, dto.getPayAllowance17No07()); // ^x17No07
		}
		if (null != dto.getPayAllowance18No07()) {
			prtItemChk(poi, line + 18, column, dto.getPayAllowance18No07()); // ^x18No07
		}
		if (null != dto.getPayAllowance19No07()) {
			prtItemChk(poi, line + 19, column, dto.getPayAllowance19No07()); // ^x19No07
		}
		if (null != dto.getPayAllowance20No07()) {
			prtItemChk(poi, line + 20, column, dto.getPayAllowance20No07()); // ^x20No07
		}
		if (null != dto.getPayAllowance21No07()) {
			prtItemChk(poi, line + 21, column, dto.getPayAllowance21No07()); // ^x21No07
		}
		if (null != dto.getPayAllowance22No07()) {
			prtItemChk(poi, line + 22, column, dto.getPayAllowance22No07()); // ^x22No07
		}
		if (null != dto.getPayAllowance23No07()) {
			prtItemChk(poi, line + 23, column, dto.getPayAllowance23No07()); // ^x23No07
		}
		if (null != dto.getPayAllowance24No07()) {
			prtItemChk(poi, line + 24, column, dto.getPayAllowance24No07()); // ^x24No07
		}
		if (null != dto.getPayAllowance25No07()) {
			prtItemChk(poi, line + 25, column, dto.getPayAllowance25No07()); // ^x25No07
		}
		if (null != dto.getPayAllowance26No07()) {
			prtItemChk(poi, line + 26, column, dto.getPayAllowance26No07()); // ^x26No07
		}
		if (null != dto.getPayAllowance27No07()) {
			prtItemChk(poi, line + 27, column, dto.getPayAllowance27No07()); // ^x27No07
		}
		if (null != dto.getPayAllowance28No07()) {
			prtItemChk(poi, line + 28, column, dto.getPayAllowance28No07()); // ^x28No07
		}
		if (null != dto.getPayAllowance29No07()) {
			prtItemChk(poi, line + 29, column, dto.getPayAllowance29No07()); // ^x29No07
		}
		if (null != dto.getPayAllowance30No07()) {
			prtItemChk(poi, line + 30, column, dto.getPayAllowance30No07()); // ^x30No07
		}
		if (null != dto.getPayAllowanceTotal07()) {
			prtItemChk(poi, line + 31, column, dto.getPayAllowanceTotal07()); // ^xzNo07
		}
		line = 40;
		if (null != dto.getPayDeduction01No07()) {
			prtItemChk(poi, line + 1, column, dto.getPayDeduction01No07()); // ^T01No07
		}
		if (null != dto.getPayDeduction02No07()) {
			prtItemChk(poi, line + 2, column, dto.getPayDeduction02No07()); // ^T02No07
		}
		if (null != dto.getPayDeduction03No07()) {
			prtItemChk(poi, line + 3, column, dto.getPayDeduction03No07()); // ^T03No07
		}
		if (null != dto.getPayDeduction04No07()) {
			prtItemChk(poi, line + 4, column, dto.getPayDeduction04No07()); // ^T04No07
		}
		if (null != dto.getPayDeduction05No07()) {
			prtItemChk(poi, line + 5, column, dto.getPayDeduction05No07()); // ^T05No07
		}
		if (null != dto.getPayDeduction06No07()) {
			prtItemChk(poi, line + 6, column, dto.getPayDeduction06No07()); // ^T06No07
		}
		if (null != dto.getPayDeduction07No07()) {
			prtItemChk(poi, line + 7, column, dto.getPayDeduction07No07()); // ^T07No07
		}
		if (null != dto.getPayDeduction08No07()) {
			prtItemChk(poi, line + 8, column, dto.getPayDeduction08No07()); // ^T08No07
		}
		if (null != dto.getPayDeduction09No07()) {
			prtItemChk(poi, line + 9, column, dto.getPayDeduction09No07()); // ^T09No07
		}
		if (null != dto.getPayDeduction10No07()) {
			prtItemChk(poi, line + 10, column, dto.getPayDeduction10No07()); // ^T10No07
		}
		if (null != dto.getPayDeduction11No07()) {
			prtItemChk(poi, line + 11, column, dto.getPayDeduction11No07()); // ^T11No07
		}
		if (null != dto.getPayDeduction12No07()) {
			prtItemChk(poi, line + 12, column, dto.getPayDeduction12No07()); // ^T12No07
		}
		if (null != dto.getPayDeduction14No07()) {
			prtItemChk(poi, line + 13, column, dto.getPayDeduction14No07()); // ^T14No07
		}
		if (null != dto.getPayDeduction15No07()) {
			prtItemChk(poi, line + 14, column, dto.getPayDeduction15No07()); // ^T15No07
		}
		if (null != dto.getPayDeduction16No07()) {
			prtItemChk(poi, line + 15, column, dto.getPayDeduction16No07()); // ^T16No07
		}
		if (null != dto.getPayDeduction17No07()) {
			prtItemChk(poi, line + 16, column, dto.getPayDeduction17No07()); // ^T17No07
		}
		if (null != dto.getPayDeduction18No07()) {
			prtItemChk(poi, line + 17, column, dto.getPayDeduction18No07()); // ^T18No07
		}
		if (null != dto.getPayDeduction19No07()) {
			prtItemChk(poi, line + 18, column, dto.getPayDeduction19No07()); // ^T19No07
		}
		if (null != dto.getPayDeduction20No07()) {
			prtItemChk(poi, line + 19, column, dto.getPayDeduction20No07()); // ^T20No07
		}
		if (null != dto.getPayDeduction21No07()) {
			prtItemChk(poi, line + 20, column, dto.getPayDeduction21No07()); // ^T21No07
		}
		if (null != dto.getPayDeduction22No07()) {
			prtItemChk(poi, line + 21, column, dto.getPayDeduction22No07()); // ^T22No07
		}
		if (null != dto.getPayDeduction23No07()) {
			prtItemChk(poi, line + 22, column, dto.getPayDeduction23No07()); // ^T23No07
		}
		if (null != dto.getPayDeduction24No07()) {
			prtItemChk(poi, line + 23, column, dto.getPayDeduction24No07()); // ^T24No07
		}
		if (null != dto.getPayDeduction25No07()) {
			prtItemChk(poi, line + 24, column, dto.getPayDeduction25No07()); // ^T25No07
		}
		if (null != dto.getPayDeductionTotal07()) {
			prtItemChk(poi, line + 25, column, dto.getPayDeductionTotal07()); // ^TzNo07
		}
		if (null != dto.getPayDeduction26No07()) {
			prtItemChk(poi, line + 26, column, dto.getPayDeduction26No07()); // ^T26No07
		}
		if (null != dto.getPayPaymentTotal07()) {
			prtItemChk(poi, line + 27, column, dto.getPayPaymentTotal07()); // ^xzNo07
		}
		if (null != dto.getPayBank1PayAmount07()) {
			prtItemChk(poi, line + 28, column, dto.getPayBank1PayAmount07()); // ^s1UzNo07
		}
		if (null != dto.getPayBank2PayAmount07()) {
			prtItemChk(poi, line + 29, column, dto.getPayBank2PayAmount07()); // ^s2UzNo07
		}
		if (null != dto.getPayCashPayAmount07()) {
			prtItemChk(poi, line + 30, column, dto.getPayCashPayAmount07()); // xzNo07
		}
		if (null != dto.getPayDeduction27No07()) {
			prtItemChk(poi, line + 31, column, dto.getPayDeduction27No07()); // ^T27No07
		}
		
		line = 8;
		column = 24; // 8
		if (null != dto.getPayPayday08()) {
			prtItemChk(poi, line - 1, column, dto.getPayPayday08()); // ^xNo08
		}
		if (null != dto.getPayAllowance01No08()) {
			prtItemChk(poi, line + 1, column, dto.getPayAllowance01No08()); // ^x01No08
		}
		if (null != dto.getPayAllowance02No08()) {
			prtItemChk(poi, line + 2, column, dto.getPayAllowance02No08()); // ^x02No08
		}
		if (null != dto.getPayAllowance03No08()) {
			prtItemChk(poi, line + 3, column, dto.getPayAllowance03No08()); // ^x03No08
		}
		if (null != dto.getPayAllowance04No08()) {
			prtItemChk(poi, line + 4, column, dto.getPayAllowance04No08()); // ^x04No08
		}
		if (null != dto.getPayAllowance05No08()) {
			prtItemChk(poi, line + 5, column, dto.getPayAllowance05No08()); // ^x05No08
		}
		if (null != dto.getPayAllowance06No08()) {
			prtItemChk(poi, line + 6, column, dto.getPayAllowance06No08()); // ^x06No08
		}
		if (null != dto.getPayAllowance07No08()) {
			prtItemChk(poi, line + 7, column, dto.getPayAllowance07No08()); // ^x07No08
		}
		if (null != dto.getPayAllowance08No08()) {
			prtItemChk(poi, line + 8, column, dto.getPayAllowance08No08()); // ^x08No08
		}
		if (null != dto.getPayAllowance09No08()) {
			prtItemChk(poi, line + 9, column, dto.getPayAllowance09No08()); // ^x09No08
		}
		if (null != dto.getPayAllowance10No08()) {
			prtItemChk(poi, line + 10, column, dto.getPayAllowance10No08()); // ^x10No08
		}
		if (null != dto.getPayAllowance11No08()) {
			prtItemChk(poi, line + 11, column, dto.getPayAllowance11No08()); // ^x11No08
		}
		if (null != dto.getPayAllowance12No08()) {
			prtItemChk(poi, line + 12, column, dto.getPayAllowance12No08()); // ^x12No08
		}
		if (null != dto.getPayAllowance13No08()) {
			prtItemChk(poi, line + 13, column, dto.getPayAllowance13No08()); // ^x13No08
		}
		if (null != dto.getPayAllowance14No08()) {
			prtItemChk(poi, line + 14, column, dto.getPayAllowance14No08()); // ^x14No08
		}
		if (null != dto.getPayAllowance15No08()) {
			prtItemChk(poi, line + 15, column, dto.getPayAllowance15No08()); // ^x15No08
		}
		if (null != dto.getPayAllowance16No08()) {
			prtItemChk(poi, line + 16, column, dto.getPayAllowance16No08()); // ^x16No08
		}
		if (null != dto.getPayAllowance17No08()) {
			prtItemChk(poi, line + 17, column, dto.getPayAllowance17No08()); // ^x17No08
		}
		if (null != dto.getPayAllowance18No08()) {
			prtItemChk(poi, line + 18, column, dto.getPayAllowance18No08()); // ^x18No08
		}
		if (null != dto.getPayAllowance19No08()) {
			prtItemChk(poi, line + 19, column, dto.getPayAllowance19No08()); // ^x19No08
		}
		if (null != dto.getPayAllowance20No08()) {
			prtItemChk(poi, line + 20, column, dto.getPayAllowance20No08()); // ^x20No08
		}
		if (null != dto.getPayAllowance21No08()) {
			prtItemChk(poi, line + 21, column, dto.getPayAllowance21No08()); // ^x21No08
		}
		if (null != dto.getPayAllowance22No08()) {
			prtItemChk(poi, line + 22, column, dto.getPayAllowance22No08()); // ^x22No08
		}
		if (null != dto.getPayAllowance23No08()) {
			prtItemChk(poi, line + 23, column, dto.getPayAllowance23No08()); // ^x23No08
		}
		if (null != dto.getPayAllowance24No08()) {
			prtItemChk(poi, line + 24, column, dto.getPayAllowance24No08()); // ^x24No08
		}
		if (null != dto.getPayAllowance25No08()) {
			prtItemChk(poi, line + 25, column, dto.getPayAllowance25No08()); // ^x25No08
		}
		if (null != dto.getPayAllowance26No08()) {
			prtItemChk(poi, line + 26, column, dto.getPayAllowance26No08()); // ^x26No08
		}
		if (null != dto.getPayAllowance27No08()) {
			prtItemChk(poi, line + 27, column, dto.getPayAllowance27No08()); // ^x27No08
		}
		if (null != dto.getPayAllowance28No08()) {
			prtItemChk(poi, line + 28, column, dto.getPayAllowance28No08()); // ^x28No08
		}
		if (null != dto.getPayAllowance29No08()) {
			prtItemChk(poi, line + 29, column, dto.getPayAllowance29No08()); // ^x29No08
		}
		if (null != dto.getPayAllowance30No08()) {
			prtItemChk(poi, line + 30, column, dto.getPayAllowance30No08()); // ^x30No08
		}
		if (null != dto.getPayAllowanceTotal08()) {
			prtItemChk(poi, line + 31, column, dto.getPayAllowanceTotal08()); // ^xzNo08
		}
		line = 40;
		if (null != dto.getPayDeduction01No08()) {
			prtItemChk(poi, line + 1, column, dto.getPayDeduction01No08()); // ^T01No08
		}
		if (null != dto.getPayDeduction02No08()) {
			prtItemChk(poi, line + 2, column, dto.getPayDeduction02No08()); // ^T02No08
		}
		if (null != dto.getPayDeduction03No08()) {
			prtItemChk(poi, line + 3, column, dto.getPayDeduction03No08()); // ^T03No08
		}
		if (null != dto.getPayDeduction04No08()) {
			prtItemChk(poi, line + 4, column, dto.getPayDeduction04No08()); // ^T04No08
		}
		if (null != dto.getPayDeduction05No08()) {
			prtItemChk(poi, line + 5, column, dto.getPayDeduction05No08()); // ^T05No08
		}
		if (null != dto.getPayDeduction06No08()) {
			prtItemChk(poi, line + 6, column, dto.getPayDeduction06No08()); // ^T06No08
		}
		if (null != dto.getPayDeduction07No08()) {
			prtItemChk(poi, line + 7, column, dto.getPayDeduction07No08()); // ^T07No08
		}
		if (null != dto.getPayDeduction08No08()) {
			prtItemChk(poi, line + 8, column, dto.getPayDeduction08No08()); // ^T08No08
		}
		if (null != dto.getPayDeduction09No08()) {
			prtItemChk(poi, line + 9, column, dto.getPayDeduction09No08()); // ^T09No08
		}
		if (null != dto.getPayDeduction10No08()) {
			prtItemChk(poi, line + 10, column, dto.getPayDeduction10No08()); // ^T10No08
		}
		if (null != dto.getPayDeduction11No08()) {
			prtItemChk(poi, line + 11, column, dto.getPayDeduction11No08()); // ^T11No08
		}
		if (null != dto.getPayDeduction12No08()) {
			prtItemChk(poi, line + 12, column, dto.getPayDeduction12No08()); // ^T12No08
		}
		if (null != dto.getPayDeduction14No08()) {
			prtItemChk(poi, line + 13, column, dto.getPayDeduction14No08()); // ^T14No08
		}
		if (null != dto.getPayDeduction15No08()) {
			prtItemChk(poi, line + 14, column, dto.getPayDeduction15No08()); // ^T15No08
		}
		if (null != dto.getPayDeduction16No08()) {
			prtItemChk(poi, line + 15, column, dto.getPayDeduction16No08()); // ^T16No08
		}
		if (null != dto.getPayDeduction17No08()) {
			prtItemChk(poi, line + 16, column, dto.getPayDeduction17No08()); // ^T17No08
		}
		if (null != dto.getPayDeduction18No08()) {
			prtItemChk(poi, line + 17, column, dto.getPayDeduction18No08()); // ^T18No08
		}
		if (null != dto.getPayDeduction19No08()) {
			prtItemChk(poi, line + 18, column, dto.getPayDeduction19No08()); // ^T19No08
		}
		if (null != dto.getPayDeduction20No08()) {
			prtItemChk(poi, line + 19, column, dto.getPayDeduction20No08()); // ^T20No08
		}
		if (null != dto.getPayDeduction21No08()) {
			prtItemChk(poi, line + 20, column, dto.getPayDeduction21No08()); // ^T21No08
		}
		if (null != dto.getPayDeduction22No08()) {
			prtItemChk(poi, line + 21, column, dto.getPayDeduction22No08()); // ^T22No08
		}
		if (null != dto.getPayDeduction23No08()) {
			prtItemChk(poi, line + 22, column, dto.getPayDeduction23No08()); // ^T23No08
		}
		if (null != dto.getPayDeduction24No08()) {
			prtItemChk(poi, line + 23, column, dto.getPayDeduction24No08()); // ^T24No08
		}
		if (null != dto.getPayDeduction25No08()) {
			prtItemChk(poi, line + 24, column, dto.getPayDeduction25No08()); // ^T25No08
		}
		if (null != dto.getPayDeductionTotal08()) {
			prtItemChk(poi, line + 25, column, dto.getPayDeductionTotal08()); // ^TzNo08
		}
		if (null != dto.getPayDeduction26No08()) {
			prtItemChk(poi, line + 26, column, dto.getPayDeduction26No08()); // ^T26No08
		}
		if (null != dto.getPayPaymentTotal08()) {
			prtItemChk(poi, line + 27, column, dto.getPayPaymentTotal08()); // ^xzNo08
		}
		if (null != dto.getPayBank1PayAmount08()) {
			prtItemChk(poi, line + 28, column, dto.getPayBank1PayAmount08()); // ^s1UzNo08
		}
		if (null != dto.getPayBank2PayAmount08()) {
			prtItemChk(poi, line + 29, column, dto.getPayBank2PayAmount08()); // ^s2UzNo08
		}
		if (null != dto.getPayCashPayAmount08()) {
			prtItemChk(poi, line + 30, column, dto.getPayCashPayAmount08()); // xzNo08
		}
		if (null != dto.getPayDeduction27No08()) {
			prtItemChk(poi, line + 31, column, dto.getPayDeduction27No08()); // ^T27No08
		}
		
		line = 8;
		column = 27; // 9
		if (null != dto.getPayPayday09()) {
			prtItemChk(poi, line - 1, column, dto.getPayPayday09()); // ^xNo09
		}
		if (null != dto.getPayAllowance01No09()) {
			prtItemChk(poi, line + 1, column, dto.getPayAllowance01No09()); // ^x01No09
		}
		if (null != dto.getPayAllowance02No09()) {
			prtItemChk(poi, line + 2, column, dto.getPayAllowance02No09()); // ^x02No09
		}
		if (null != dto.getPayAllowance03No09()) {
			prtItemChk(poi, line + 3, column, dto.getPayAllowance03No09()); // ^x03No09
		}
		if (null != dto.getPayAllowance04No09()) {
			prtItemChk(poi, line + 4, column, dto.getPayAllowance04No09()); // ^x04No09
		}
		if (null != dto.getPayAllowance05No09()) {
			prtItemChk(poi, line + 5, column, dto.getPayAllowance05No09()); // ^x05No09
		}
		if (null != dto.getPayAllowance06No09()) {
			prtItemChk(poi, line + 6, column, dto.getPayAllowance06No09()); // ^x06No09
		}
		if (null != dto.getPayAllowance07No09()) {
			prtItemChk(poi, line + 7, column, dto.getPayAllowance07No09()); // ^x07No09
		}
		if (null != dto.getPayAllowance08No09()) {
			prtItemChk(poi, line + 8, column, dto.getPayAllowance08No09()); // ^x08No09
		}
		if (null != dto.getPayAllowance09No09()) {
			prtItemChk(poi, line + 9, column, dto.getPayAllowance09No09()); // ^x09No09
		}
		if (null != dto.getPayAllowance10No09()) {
			prtItemChk(poi, line + 10, column, dto.getPayAllowance10No09()); // ^x10No09
		}
		if (null != dto.getPayAllowance11No09()) {
			prtItemChk(poi, line + 11, column, dto.getPayAllowance11No09()); // ^x11No09
		}
		if (null != dto.getPayAllowance12No09()) {
			prtItemChk(poi, line + 12, column, dto.getPayAllowance12No09()); // ^x12No09
		}
		if (null != dto.getPayAllowance13No09()) {
			prtItemChk(poi, line + 13, column, dto.getPayAllowance13No09()); // ^x13No09
		}
		if (null != dto.getPayAllowance14No09()) {
			prtItemChk(poi, line + 14, column, dto.getPayAllowance14No09()); // ^x14No09
		}
		if (null != dto.getPayAllowance15No09()) {
			prtItemChk(poi, line + 15, column, dto.getPayAllowance15No09()); // ^x15No09
		}
		if (null != dto.getPayAllowance16No09()) {
			prtItemChk(poi, line + 16, column, dto.getPayAllowance16No09()); // ^x16No09
		}
		if (null != dto.getPayAllowance17No09()) {
			prtItemChk(poi, line + 17, column, dto.getPayAllowance17No09()); // ^x17No09
		}
		if (null != dto.getPayAllowance18No09()) {
			prtItemChk(poi, line + 18, column, dto.getPayAllowance18No09()); // ^x18No09
		}
		if (null != dto.getPayAllowance19No09()) {
			prtItemChk(poi, line + 19, column, dto.getPayAllowance19No09()); // ^x19No09
		}
		if (null != dto.getPayAllowance20No09()) {
			prtItemChk(poi, line + 20, column, dto.getPayAllowance20No09()); // ^x20No09
		}
		if (null != dto.getPayAllowance21No09()) {
			prtItemChk(poi, line + 21, column, dto.getPayAllowance21No09()); // ^x21No09
		}
		if (null != dto.getPayAllowance22No09()) {
			prtItemChk(poi, line + 22, column, dto.getPayAllowance22No09()); // ^x22No09
		}
		if (null != dto.getPayAllowance23No09()) {
			prtItemChk(poi, line + 23, column, dto.getPayAllowance23No09()); // ^x23No09
		}
		if (null != dto.getPayAllowance24No09()) {
			prtItemChk(poi, line + 24, column, dto.getPayAllowance24No09()); // ^x24No09
		}
		if (null != dto.getPayAllowance25No09()) {
			prtItemChk(poi, line + 25, column, dto.getPayAllowance25No09()); // ^x25No09
		}
		if (null != dto.getPayAllowance26No09()) {
			prtItemChk(poi, line + 26, column, dto.getPayAllowance26No09()); // ^x26No09
		}
		if (null != dto.getPayAllowance27No09()) {
			prtItemChk(poi, line + 27, column, dto.getPayAllowance27No09()); // ^x27No09
		}
		if (null != dto.getPayAllowance28No09()) {
			prtItemChk(poi, line + 28, column, dto.getPayAllowance28No09()); // ^x28No09
		}
		if (null != dto.getPayAllowance29No09()) {
			prtItemChk(poi, line + 29, column, dto.getPayAllowance29No09()); // ^x29No09
		}
		if (null != dto.getPayAllowance30No09()) {
			prtItemChk(poi, line + 30, column, dto.getPayAllowance30No09()); // ^x30No09
		}
		if (null != dto.getPayAllowanceTotal09()) {
			prtItemChk(poi, line + 31, column, dto.getPayAllowanceTotal09()); // ^xzNo09
		}
		line = 40;
		if (null != dto.getPayDeduction01No09()) {
			prtItemChk(poi, line + 1, column, dto.getPayDeduction01No09()); // ^T01No09
		}
		if (null != dto.getPayDeduction02No09()) {
			prtItemChk(poi, line + 2, column, dto.getPayDeduction02No09()); // ^T02No09
		}
		if (null != dto.getPayDeduction03No09()) {
			prtItemChk(poi, line + 3, column, dto.getPayDeduction03No09()); // ^T03No09
		}
		if (null != dto.getPayDeduction04No09()) {
			prtItemChk(poi, line + 4, column, dto.getPayDeduction04No09()); // ^T04No09
		}
		if (null != dto.getPayDeduction05No09()) {
			prtItemChk(poi, line + 5, column, dto.getPayDeduction05No09()); // ^T05No09
		}
		if (null != dto.getPayDeduction06No09()) {
			prtItemChk(poi, line + 6, column, dto.getPayDeduction06No09()); // ^T06No09
		}
		if (null != dto.getPayDeduction07No09()) {
			prtItemChk(poi, line + 7, column, dto.getPayDeduction07No09()); // ^T07No09
		}
		if (null != dto.getPayDeduction08No09()) {
			prtItemChk(poi, line + 8, column, dto.getPayDeduction08No09()); // ^T08No09
		}
		if (null != dto.getPayDeduction09No09()) {
			prtItemChk(poi, line + 9, column, dto.getPayDeduction09No09()); // ^T09No09
		}
		if (null != dto.getPayDeduction10No09()) {
			prtItemChk(poi, line + 10, column, dto.getPayDeduction10No09()); // ^T10No09
		}
		if (null != dto.getPayDeduction11No09()) {
			prtItemChk(poi, line + 11, column, dto.getPayDeduction11No09()); // ^T11No09
		}
		if (null != dto.getPayDeduction12No09()) {
			prtItemChk(poi, line + 12, column, dto.getPayDeduction12No09()); // ^T12No09
		}
		if (null != dto.getPayDeduction14No09()) {
			prtItemChk(poi, line + 13, column, dto.getPayDeduction14No09()); // ^T14No09
		}
		if (null != dto.getPayDeduction15No09()) {
			prtItemChk(poi, line + 14, column, dto.getPayDeduction15No09()); // ^T15No09
		}
		if (null != dto.getPayDeduction16No09()) {
			prtItemChk(poi, line + 15, column, dto.getPayDeduction16No09()); // ^T16No09
		}
		if (null != dto.getPayDeduction17No09()) {
			prtItemChk(poi, line + 16, column, dto.getPayDeduction17No09()); // ^T17No09
		}
		if (null != dto.getPayDeduction18No09()) {
			prtItemChk(poi, line + 17, column, dto.getPayDeduction18No09()); // ^T18No09
		}
		if (null != dto.getPayDeduction19No09()) {
			prtItemChk(poi, line + 18, column, dto.getPayDeduction19No09()); // ^T19No09
		}
		if (null != dto.getPayDeduction20No09()) {
			prtItemChk(poi, line + 19, column, dto.getPayDeduction20No09()); // ^T20No09
		}
		if (null != dto.getPayDeduction21No09()) {
			prtItemChk(poi, line + 20, column, dto.getPayDeduction21No09()); // ^T21No09
		}
		if (null != dto.getPayDeduction22No09()) {
			prtItemChk(poi, line + 21, column, dto.getPayDeduction22No09()); // ^T22No09
		}
		if (null != dto.getPayDeduction23No09()) {
			prtItemChk(poi, line + 22, column, dto.getPayDeduction23No09()); // ^T23No09
		}
		if (null != dto.getPayDeduction24No09()) {
			prtItemChk(poi, line + 23, column, dto.getPayDeduction24No09()); // ^T24No09
		}
		if (null != dto.getPayDeduction25No09()) {
			prtItemChk(poi, line + 24, column, dto.getPayDeduction25No09()); // ^T25No09
		}
		if (null != dto.getPayDeductionTotal09()) {
			prtItemChk(poi, line + 25, column, dto.getPayDeductionTotal09()); // ^TzNo09
		}
		if (null != dto.getPayDeduction26No09()) {
			prtItemChk(poi, line + 26, column, dto.getPayDeduction26No09()); // ^T26No09
		}
		if (null != dto.getPayPaymentTotal09()) {
			prtItemChk(poi, line + 27, column, dto.getPayPaymentTotal09()); // ^xzNo09
		}
		if (null != dto.getPayBank1PayAmount09()) {
			prtItemChk(poi, line + 28, column, dto.getPayBank1PayAmount09()); // ^s1UzNo09
		}
		if (null != dto.getPayBank2PayAmount09()) {
			prtItemChk(poi, line + 29, column, dto.getPayBank2PayAmount09()); // ^s2UzNo09
		}
		if (null != dto.getPayCashPayAmount09()) {
			prtItemChk(poi, line + 30, column, dto.getPayCashPayAmount09()); // xzNo09
		}
		if (null != dto.getPayDeduction27No09()) {
			prtItemChk(poi, line + 31, column, dto.getPayDeduction27No09()); // ^T27No09
		}
		
		line = 8;
		column = 30; // 10
		if (null != dto.getPayPayday10()) {
			prtItemChk(poi, line - 1, column, dto.getPayPayday10()); // ^xNo10
		}
		if (null != dto.getPayAllowance01No10()) {
			prtItemChk(poi, line + 1, column, dto.getPayAllowance01No10()); // ^x01No10
		}
		if (null != dto.getPayAllowance02No10()) {
			prtItemChk(poi, line + 2, column, dto.getPayAllowance02No10()); // ^x02No10
		}
		if (null != dto.getPayAllowance03No10()) {
			prtItemChk(poi, line + 3, column, dto.getPayAllowance03No10()); // ^x03No10
		}
		if (null != dto.getPayAllowance04No10()) {
			prtItemChk(poi, line + 4, column, dto.getPayAllowance04No10()); // ^x04No10
		}
		if (null != dto.getPayAllowance05No10()) {
			prtItemChk(poi, line + 5, column, dto.getPayAllowance05No10()); // ^x05No10
		}
		if (null != dto.getPayAllowance06No10()) {
			prtItemChk(poi, line + 6, column, dto.getPayAllowance06No10()); // ^x06No10
		}
		if (null != dto.getPayAllowance07No10()) {
			prtItemChk(poi, line + 7, column, dto.getPayAllowance07No10()); // ^x07No10
		}
		if (null != dto.getPayAllowance08No10()) {
			prtItemChk(poi, line + 8, column, dto.getPayAllowance08No10()); // ^x08No10
		}
		if (null != dto.getPayAllowance09No10()) {
			prtItemChk(poi, line + 9, column, dto.getPayAllowance09No10()); // ^x09No10
		}
		if (null != dto.getPayAllowance10No10()) {
			prtItemChk(poi, line + 10, column, dto.getPayAllowance10No10()); // ^x10No10
		}
		if (null != dto.getPayAllowance11No10()) {
			prtItemChk(poi, line + 11, column, dto.getPayAllowance11No10()); // ^x11No10
		}
		if (null != dto.getPayAllowance12No10()) {
			prtItemChk(poi, line + 12, column, dto.getPayAllowance12No10()); // ^x12No10
		}
		if (null != dto.getPayAllowance13No10()) {
			prtItemChk(poi, line + 13, column, dto.getPayAllowance13No10()); // ^x13No10
		}
		if (null != dto.getPayAllowance14No10()) {
			prtItemChk(poi, line + 14, column, dto.getPayAllowance14No10()); // ^x14No10
		}
		if (null != dto.getPayAllowance15No10()) {
			prtItemChk(poi, line + 15, column, dto.getPayAllowance15No10()); // ^x15No10
		}
		if (null != dto.getPayAllowance16No10()) {
			prtItemChk(poi, line + 16, column, dto.getPayAllowance16No10()); // ^x16No10
		}
		if (null != dto.getPayAllowance17No10()) {
			prtItemChk(poi, line + 17, column, dto.getPayAllowance17No10()); // ^x17No10
		}
		if (null != dto.getPayAllowance18No10()) {
			prtItemChk(poi, line + 18, column, dto.getPayAllowance18No10()); // ^x18No10
		}
		if (null != dto.getPayAllowance19No10()) {
			prtItemChk(poi, line + 19, column, dto.getPayAllowance19No10()); // ^x19No10
		}
		if (null != dto.getPayAllowance20No10()) {
			prtItemChk(poi, line + 20, column, dto.getPayAllowance20No10()); // ^x20No10
		}
		if (null != dto.getPayAllowance21No10()) {
			prtItemChk(poi, line + 21, column, dto.getPayAllowance21No10()); // ^x21No10
		}
		if (null != dto.getPayAllowance22No10()) {
			prtItemChk(poi, line + 22, column, dto.getPayAllowance22No10()); // ^x22No10
		}
		if (null != dto.getPayAllowance23No10()) {
			prtItemChk(poi, line + 23, column, dto.getPayAllowance23No10()); // ^x23No10
		}
		if (null != dto.getPayAllowance24No10()) {
			prtItemChk(poi, line + 24, column, dto.getPayAllowance24No10()); // ^x24No10
		}
		if (null != dto.getPayAllowance25No10()) {
			prtItemChk(poi, line + 25, column, dto.getPayAllowance25No10()); // ^x25No10
		}
		if (null != dto.getPayAllowance26No10()) {
			prtItemChk(poi, line + 26, column, dto.getPayAllowance26No10()); // ^x26No10
		}
		if (null != dto.getPayAllowance27No10()) {
			prtItemChk(poi, line + 27, column, dto.getPayAllowance27No10()); // ^x27No10
		}
		if (null != dto.getPayAllowance28No10()) {
			prtItemChk(poi, line + 28, column, dto.getPayAllowance28No10()); // ^x28No10
		}
		if (null != dto.getPayAllowance29No10()) {
			prtItemChk(poi, line + 29, column, dto.getPayAllowance29No10()); // ^x29No10
		}
		if (null != dto.getPayAllowance30No10()) {
			prtItemChk(poi, line + 30, column, dto.getPayAllowance30No10()); // ^x30No10
		}
		if (null != dto.getPayAllowanceTotal10()) {
			prtItemChk(poi, line + 31, column, dto.getPayAllowanceTotal10()); // ^xzNo10
		}
		line = 40;
		if (null != dto.getPayDeduction01No10()) {
			prtItemChk(poi, line + 1, column, dto.getPayDeduction01No10()); // ^T01No10
		}
		if (null != dto.getPayDeduction02No10()) {
			prtItemChk(poi, line + 2, column, dto.getPayDeduction02No10()); // ^T02No10
		}
		if (null != dto.getPayDeduction03No10()) {
			prtItemChk(poi, line + 3, column, dto.getPayDeduction03No10()); // ^T03No10
		}
		if (null != dto.getPayDeduction04No10()) {
			prtItemChk(poi, line + 4, column, dto.getPayDeduction04No10()); // ^T04No10
		}
		if (null != dto.getPayDeduction05No10()) {
			prtItemChk(poi, line + 5, column, dto.getPayDeduction05No10()); // ^T05No10
		}
		if (null != dto.getPayDeduction06No10()) {
			prtItemChk(poi, line + 6, column, dto.getPayDeduction06No10()); // ^T06No10
		}
		if (null != dto.getPayDeduction07No10()) {
			prtItemChk(poi, line + 7, column, dto.getPayDeduction07No10()); // ^T07No10
		}
		if (null != dto.getPayDeduction08No10()) {
			prtItemChk(poi, line + 8, column, dto.getPayDeduction08No10()); // ^T08No10
		}
		if (null != dto.getPayDeduction09No10()) {
			prtItemChk(poi, line + 9, column, dto.getPayDeduction09No10()); // ^T09No10
		}
		if (null != dto.getPayDeduction10No10()) {
			prtItemChk(poi, line + 10, column, dto.getPayDeduction10No10()); // ^T10No10
		}
		if (null != dto.getPayDeduction11No10()) {
			prtItemChk(poi, line + 11, column, dto.getPayDeduction11No10()); // ^T11No10
		}
		if (null != dto.getPayDeduction12No10()) {
			prtItemChk(poi, line + 12, column, dto.getPayDeduction12No10()); // ^T12No10
		}
		if (null != dto.getPayDeduction14No10()) {
			prtItemChk(poi, line + 13, column, dto.getPayDeduction14No10()); // ^T14No10
		}
		if (null != dto.getPayDeduction15No10()) {
			prtItemChk(poi, line + 14, column, dto.getPayDeduction15No10()); // ^T15No10
		}
		if (null != dto.getPayDeduction16No10()) {
			prtItemChk(poi, line + 15, column, dto.getPayDeduction16No10()); // ^T16No10
		}
		if (null != dto.getPayDeduction17No10()) {
			prtItemChk(poi, line + 16, column, dto.getPayDeduction17No10()); // ^T17No10
		}
		if (null != dto.getPayDeduction18No10()) {
			prtItemChk(poi, line + 17, column, dto.getPayDeduction18No10()); // ^T18No10
		}
		if (null != dto.getPayDeduction19No10()) {
			prtItemChk(poi, line + 18, column, dto.getPayDeduction19No10()); // ^T19No10
		}
		if (null != dto.getPayDeduction20No10()) {
			prtItemChk(poi, line + 19, column, dto.getPayDeduction20No10()); // ^T20No10
		}
		if (null != dto.getPayDeduction21No10()) {
			prtItemChk(poi, line + 20, column, dto.getPayDeduction21No10()); // ^T21No10
		}
		if (null != dto.getPayDeduction22No10()) {
			prtItemChk(poi, line + 21, column, dto.getPayDeduction22No10()); // ^T22No10
		}
		if (null != dto.getPayDeduction23No10()) {
			prtItemChk(poi, line + 22, column, dto.getPayDeduction23No10()); // ^T23No10
		}
		if (null != dto.getPayDeduction24No10()) {
			prtItemChk(poi, line + 23, column, dto.getPayDeduction24No10()); // ^T24No10
		}
		if (null != dto.getPayDeduction25No10()) {
			prtItemChk(poi, line + 24, column, dto.getPayDeduction25No10()); // ^T25No10
		}
		if (null != dto.getPayDeductionTotal10()) {
			prtItemChk(poi, line + 25, column, dto.getPayDeductionTotal10()); // ^TzNo10
		}
		if (null != dto.getPayDeduction26No10()) {
			prtItemChk(poi, line + 26, column, dto.getPayDeduction26No10()); // ^T26No10
		}
		if (null != dto.getPayPaymentTotal10()) {
			prtItemChk(poi, line + 27, column, dto.getPayPaymentTotal10()); // ^xzNo10
		}
		if (null != dto.getPayBank1PayAmount10()) {
			prtItemChk(poi, line + 28, column, dto.getPayBank1PayAmount10()); // ^s1UzNo10
		}
		if (null != dto.getPayBank2PayAmount10()) {
			prtItemChk(poi, line + 29, column, dto.getPayBank2PayAmount10()); // ^s2UzNo10
		}
		if (null != dto.getPayCashPayAmount10()) {
			prtItemChk(poi, line + 30, column, dto.getPayCashPayAmount10()); // xzNo10
		}
		if (null != dto.getPayDeduction27No10()) {
			prtItemChk(poi, line + 31, column, dto.getPayDeduction27No10()); // ^T27No10
		}
		
		line = 8;
		column = 33; // 11
		if (null != dto.getPayPayday11()) {
			prtItemChk(poi, line - 1, column, dto.getPayPayday11()); // ^xNo11
		}
		if (null != dto.getPayAllowance01No11()) {
			prtItemChk(poi, line + 1, column, dto.getPayAllowance01No11()); // ^x01No11
		}
		if (null != dto.getPayAllowance02No11()) {
			prtItemChk(poi, line + 2, column, dto.getPayAllowance02No11()); // ^x02No11
		}
		if (null != dto.getPayAllowance03No11()) {
			prtItemChk(poi, line + 3, column, dto.getPayAllowance03No11()); // ^x03No11
		}
		if (null != dto.getPayAllowance04No11()) {
			prtItemChk(poi, line + 4, column, dto.getPayAllowance04No11()); // ^x04No11
		}
		if (null != dto.getPayAllowance05No11()) {
			prtItemChk(poi, line + 5, column, dto.getPayAllowance05No11()); // ^x05No11
		}
		if (null != dto.getPayAllowance06No11()) {
			prtItemChk(poi, line + 6, column, dto.getPayAllowance06No11()); // ^x06No11
		}
		if (null != dto.getPayAllowance07No11()) {
			prtItemChk(poi, line + 7, column, dto.getPayAllowance07No11()); // ^x07No11
		}
		if (null != dto.getPayAllowance08No11()) {
			prtItemChk(poi, line + 8, column, dto.getPayAllowance08No11()); // ^x08No11
		}
		if (null != dto.getPayAllowance09No11()) {
			prtItemChk(poi, line + 9, column, dto.getPayAllowance09No11()); // ^x09No11
		}
		if (null != dto.getPayAllowance10No11()) {
			prtItemChk(poi, line + 10, column, dto.getPayAllowance10No11()); // ^x10No11
		}
		if (null != dto.getPayAllowance11No11()) {
			prtItemChk(poi, line + 11, column, dto.getPayAllowance11No11()); // ^x11No11
		}
		if (null != dto.getPayAllowance12No11()) {
			prtItemChk(poi, line + 12, column, dto.getPayAllowance12No11()); // ^x12No11
		}
		if (null != dto.getPayAllowance13No11()) {
			prtItemChk(poi, line + 13, column, dto.getPayAllowance13No11()); // ^x13No11
		}
		if (null != dto.getPayAllowance14No11()) {
			prtItemChk(poi, line + 14, column, dto.getPayAllowance14No11()); // ^x14No11
		}
		if (null != dto.getPayAllowance15No11()) {
			prtItemChk(poi, line + 15, column, dto.getPayAllowance15No11()); // ^x15No11
		}
		if (null != dto.getPayAllowance16No11()) {
			prtItemChk(poi, line + 16, column, dto.getPayAllowance16No11()); // ^x16No11
		}
		if (null != dto.getPayAllowance17No11()) {
			prtItemChk(poi, line + 17, column, dto.getPayAllowance17No11()); // ^x17No11
		}
		if (null != dto.getPayAllowance18No11()) {
			prtItemChk(poi, line + 18, column, dto.getPayAllowance18No11()); // ^x18No11
		}
		if (null != dto.getPayAllowance19No11()) {
			prtItemChk(poi, line + 19, column, dto.getPayAllowance19No11()); // ^x19No11
		}
		if (null != dto.getPayAllowance20No11()) {
			prtItemChk(poi, line + 20, column, dto.getPayAllowance20No11()); // ^x20No11
		}
		if (null != dto.getPayAllowance21No11()) {
			prtItemChk(poi, line + 21, column, dto.getPayAllowance21No11()); // ^x21No11
		}
		if (null != dto.getPayAllowance22No11()) {
			prtItemChk(poi, line + 22, column, dto.getPayAllowance22No11()); // ^x22No11
		}
		if (null != dto.getPayAllowance23No11()) {
			prtItemChk(poi, line + 23, column, dto.getPayAllowance23No11()); // ^x23No11
		}
		if (null != dto.getPayAllowance24No11()) {
			prtItemChk(poi, line + 24, column, dto.getPayAllowance24No11()); // ^x24No11
		}
		if (null != dto.getPayAllowance25No11()) {
			prtItemChk(poi, line + 25, column, dto.getPayAllowance25No11()); // ^x25No11
		}
		if (null != dto.getPayAllowance26No11()) {
			prtItemChk(poi, line + 26, column, dto.getPayAllowance26No11()); // ^x26No11
		}
		if (null != dto.getPayAllowance27No11()) {
			prtItemChk(poi, line + 27, column, dto.getPayAllowance27No11()); // ^x27No11
		}
		if (null != dto.getPayAllowance28No11()) {
			prtItemChk(poi, line + 28, column, dto.getPayAllowance28No11()); // ^x28No11
		}
		if (null != dto.getPayAllowance29No11()) {
			prtItemChk(poi, line + 29, column, dto.getPayAllowance29No11()); // ^x29No11
		}
		if (null != dto.getPayAllowance30No11()) {
			prtItemChk(poi, line + 30, column, dto.getPayAllowance30No11()); // ^x30No11
		}
		if (null != dto.getPayAllowanceTotal11()) {
			prtItemChk(poi, line + 31, column, dto.getPayAllowanceTotal11()); // ^xzNo11
		}
		line = 40;
		if (null != dto.getPayDeduction01No11()) {
			prtItemChk(poi, line + 1, column, dto.getPayDeduction01No11()); // ^T01No11
		}
		if (null != dto.getPayDeduction02No11()) {
			prtItemChk(poi, line + 2, column, dto.getPayDeduction02No11()); // ^T02No11
		}
		if (null != dto.getPayDeduction03No11()) {
			prtItemChk(poi, line + 3, column, dto.getPayDeduction03No11()); // ^T03No11
		}
		if (null != dto.getPayDeduction04No11()) {
			prtItemChk(poi, line + 4, column, dto.getPayDeduction04No11()); // ^T04No11
		}
		if (null != dto.getPayDeduction05No11()) {
			prtItemChk(poi, line + 5, column, dto.getPayDeduction05No11()); // ^T05No11
		}
		if (null != dto.getPayDeduction06No11()) {
			prtItemChk(poi, line + 6, column, dto.getPayDeduction06No11()); // ^T06No11
		}
		if (null != dto.getPayDeduction07No11()) {
			prtItemChk(poi, line + 7, column, dto.getPayDeduction07No11()); // ^T07No11
		}
		if (null != dto.getPayDeduction08No11()) {
			prtItemChk(poi, line + 8, column, dto.getPayDeduction08No11()); // ^T08No11
		}
		if (null != dto.getPayDeduction09No11()) {
			prtItemChk(poi, line + 9, column, dto.getPayDeduction09No11()); // ^T09No11
		}
		if (null != dto.getPayDeduction10No11()) {
			prtItemChk(poi, line + 10, column, dto.getPayDeduction10No11()); // ^T10No11
		}
		if (null != dto.getPayDeduction11No11()) {
			prtItemChk(poi, line + 11, column, dto.getPayDeduction11No11()); // ^T11No11
		}
		if (null != dto.getPayDeduction12No11()) {
			prtItemChk(poi, line + 12, column, dto.getPayDeduction12No11()); // ^T12No11
		}
		if (null != dto.getPayDeduction14No11()) {
			prtItemChk(poi, line + 13, column, dto.getPayDeduction14No11()); // ^T14No11
		}
		if (null != dto.getPayDeduction15No11()) {
			prtItemChk(poi, line + 14, column, dto.getPayDeduction15No11()); // ^T15No11
		}
		if (null != dto.getPayDeduction16No11()) {
			prtItemChk(poi, line + 15, column, dto.getPayDeduction16No11()); // ^T16No11
		}
		if (null != dto.getPayDeduction17No11()) {
			prtItemChk(poi, line + 16, column, dto.getPayDeduction17No11()); // ^T17No11
		}
		if (null != dto.getPayDeduction18No11()) {
			prtItemChk(poi, line + 17, column, dto.getPayDeduction18No11()); // ^T18No11
		}
		if (null != dto.getPayDeduction19No11()) {
			prtItemChk(poi, line + 18, column, dto.getPayDeduction19No11()); // ^T19No11
		}
		if (null != dto.getPayDeduction20No11()) {
			prtItemChk(poi, line + 19, column, dto.getPayDeduction20No11()); // ^T20No11
		}
		if (null != dto.getPayDeduction21No11()) {
			prtItemChk(poi, line + 20, column, dto.getPayDeduction21No11()); // ^T21No11
		}
		if (null != dto.getPayDeduction22No11()) {
			prtItemChk(poi, line + 21, column, dto.getPayDeduction22No11()); // ^T22No11
		}
		if (null != dto.getPayDeduction23No11()) {
			prtItemChk(poi, line + 22, column, dto.getPayDeduction23No11()); // ^T23No11
		}
		if (null != dto.getPayDeduction24No11()) {
			prtItemChk(poi, line + 23, column, dto.getPayDeduction24No11()); // ^T24No11
		}
		if (null != dto.getPayDeduction25No11()) {
			prtItemChk(poi, line + 24, column, dto.getPayDeduction25No11()); // ^T25No11
		}
		if (null != dto.getPayDeductionTotal11()) {
			prtItemChk(poi, line + 25, column, dto.getPayDeductionTotal11()); // ^TzNo11
		}
		if (null != dto.getPayDeduction26No11()) {
			prtItemChk(poi, line + 26, column, dto.getPayDeduction26No11()); // ^T26No11
		}
		if (null != dto.getPayPaymentTotal11()) {
			prtItemChk(poi, line + 27, column, dto.getPayPaymentTotal11()); // ^xzNo11
		}
		if (null != dto.getPayBank1PayAmount11()) {
			prtItemChk(poi, line + 28, column, dto.getPayBank1PayAmount11()); // ^s1UzNo11
		}
		if (null != dto.getPayBank2PayAmount11()) {
			prtItemChk(poi, line + 29, column, dto.getPayBank2PayAmount11()); // ^s2UzNo11
		}
		if (null != dto.getPayCashPayAmount11()) {
			prtItemChk(poi, line + 30, column, dto.getPayCashPayAmount11()); // xzNo11
		}
		if (null != dto.getPayDeduction27No11()) {
			prtItemChk(poi, line + 31, column, dto.getPayDeduction27No11()); // ^T27No11
		}
		
		line = 8;
		column = 36; // 12
		if (null != dto.getPayPayday12()) {
			prtItemChk(poi, line - 1, column, dto.getPayPayday12()); // ^xNo12
		}
		if (null != dto.getPayAllowance01No12()) {
			prtItemChk(poi, line + 1, column, dto.getPayAllowance01No12()); // ^x01No12
		}
		if (null != dto.getPayAllowance02No12()) {
			prtItemChk(poi, line + 2, column, dto.getPayAllowance02No12()); // ^x02No12
		}
		if (null != dto.getPayAllowance03No12()) {
			prtItemChk(poi, line + 3, column, dto.getPayAllowance03No12()); // ^x03No12
		}
		if (null != dto.getPayAllowance04No12()) {
			prtItemChk(poi, line + 4, column, dto.getPayAllowance04No12()); // ^x04No12
		}
		if (null != dto.getPayAllowance05No12()) {
			prtItemChk(poi, line + 5, column, dto.getPayAllowance05No12()); // ^x05No12
		}
		if (null != dto.getPayAllowance06No12()) {
			prtItemChk(poi, line + 6, column, dto.getPayAllowance06No12()); // ^x06No12
		}
		if (null != dto.getPayAllowance07No12()) {
			prtItemChk(poi, line + 7, column, dto.getPayAllowance07No12()); // ^x07No12
		}
		if (null != dto.getPayAllowance08No12()) {
			prtItemChk(poi, line + 8, column, dto.getPayAllowance08No12()); // ^x08No12
		}
		if (null != dto.getPayAllowance09No12()) {
			prtItemChk(poi, line + 9, column, dto.getPayAllowance09No12()); // ^x09No12
		}
		if (null != dto.getPayAllowance10No12()) {
			prtItemChk(poi, line + 10, column, dto.getPayAllowance10No12()); // ^x10No12
		}
		if (null != dto.getPayAllowance11No12()) {
			prtItemChk(poi, line + 11, column, dto.getPayAllowance11No12()); // ^x11No12
		}
		if (null != dto.getPayAllowance12No12()) {
			prtItemChk(poi, line + 12, column, dto.getPayAllowance12No12()); // ^x12No12
		}
		if (null != dto.getPayAllowance13No12()) {
			prtItemChk(poi, line + 13, column, dto.getPayAllowance13No12()); // ^x13No12
		}
		if (null != dto.getPayAllowance14No12()) {
			prtItemChk(poi, line + 14, column, dto.getPayAllowance14No12()); // ^x14No12
		}
		if (null != dto.getPayAllowance15No12()) {
			prtItemChk(poi, line + 15, column, dto.getPayAllowance15No12()); // ^x15No12
		}
		if (null != dto.getPayAllowance16No12()) {
			prtItemChk(poi, line + 16, column, dto.getPayAllowance16No12()); // ^x16No12
		}
		if (null != dto.getPayAllowance17No12()) {
			prtItemChk(poi, line + 17, column, dto.getPayAllowance17No12()); // ^x17No12
		}
		if (null != dto.getPayAllowance18No12()) {
			prtItemChk(poi, line + 18, column, dto.getPayAllowance18No12()); // ^x18No12
		}
		if (null != dto.getPayAllowance19No12()) {
			prtItemChk(poi, line + 19, column, dto.getPayAllowance19No12()); // ^x19No12
		}
		if (null != dto.getPayAllowance20No12()) {
			prtItemChk(poi, line + 20, column, dto.getPayAllowance20No12()); // ^x20No12
		}
		if (null != dto.getPayAllowance21No12()) {
			prtItemChk(poi, line + 21, column, dto.getPayAllowance21No12()); // ^x21No12
		}
		if (null != dto.getPayAllowance22No12()) {
			prtItemChk(poi, line + 22, column, dto.getPayAllowance22No12()); // ^x22No12
		}
		if (null != dto.getPayAllowance23No12()) {
			prtItemChk(poi, line + 23, column, dto.getPayAllowance23No12()); // ^x23No12
		}
		if (null != dto.getPayAllowance24No12()) {
			prtItemChk(poi, line + 24, column, dto.getPayAllowance24No12()); // ^x24No12
		}
		if (null != dto.getPayAllowance25No12()) {
			prtItemChk(poi, line + 25, column, dto.getPayAllowance25No12()); // ^x25No12
		}
		if (null != dto.getPayAllowance26No12()) {
			prtItemChk(poi, line + 26, column, dto.getPayAllowance26No12()); // ^x26No12
		}
		if (null != dto.getPayAllowance27No12()) {
			prtItemChk(poi, line + 27, column, dto.getPayAllowance27No12()); // ^x27No12
		}
		if (null != dto.getPayAllowance28No12()) {
			prtItemChk(poi, line + 28, column, dto.getPayAllowance28No12()); // ^x28No12
		}
		if (null != dto.getPayAllowance29No12()) {
			prtItemChk(poi, line + 29, column, dto.getPayAllowance29No12()); // ^x29No12
		}
		if (null != dto.getPayAllowance30No12()) {
			prtItemChk(poi, line + 30, column, dto.getPayAllowance30No12()); // ^x30No12
		}
		if (null != dto.getPayAllowanceTotal12()) {
			prtItemChk(poi, line + 31, column, dto.getPayAllowanceTotal12()); // ^xzNo12
		}
		line = 40;
		if (null != dto.getPayDeduction01No12()) {
			prtItemChk(poi, line + 1, column, dto.getPayDeduction01No12()); // ^T01No12
		}
		if (null != dto.getPayDeduction02No12()) {
			prtItemChk(poi, line + 2, column, dto.getPayDeduction02No12()); // ^T02No12
		}
		if (null != dto.getPayDeduction03No12()) {
			prtItemChk(poi, line + 3, column, dto.getPayDeduction03No12()); // ^T03No12
		}
		if (null != dto.getPayDeduction04No12()) {
			prtItemChk(poi, line + 4, column, dto.getPayDeduction04No12()); // ^T04No12
		}
		if (null != dto.getPayDeduction05No12()) {
			prtItemChk(poi, line + 5, column, dto.getPayDeduction05No12()); // ^T05No12
		}
		if (null != dto.getPayDeduction06No12()) {
			prtItemChk(poi, line + 6, column, dto.getPayDeduction06No12()); // ^T06No12
		}
		if (null != dto.getPayDeduction07No12()) {
			prtItemChk(poi, line + 7, column, dto.getPayDeduction07No12()); // ^T07No12
		}
		if (null != dto.getPayDeduction08No12()) {
			prtItemChk(poi, line + 8, column, dto.getPayDeduction08No12()); // ^T08No12
		}
		if (null != dto.getPayDeduction09No12()) {
			prtItemChk(poi, line + 9, column, dto.getPayDeduction09No12()); // ^T09No12
		}
		if (null != dto.getPayDeduction10No12()) {
			prtItemChk(poi, line + 10, column, dto.getPayDeduction10No12()); // ^T10No12
		}
		if (null != dto.getPayDeduction11No12()) {
			prtItemChk(poi, line + 11, column, dto.getPayDeduction11No12()); // ^T11No12
		}
		if (null != dto.getPayDeduction12No12()) {
			prtItemChk(poi, line + 12, column, dto.getPayDeduction12No12()); // ^T12No12
		}
		if (null != dto.getPayDeduction14No12()) {
			prtItemChk(poi, line + 13, column, dto.getPayDeduction14No12()); // ^T14No12
		}
		if (null != dto.getPayDeduction15No12()) {
			prtItemChk(poi, line + 14, column, dto.getPayDeduction15No12()); // ^T15No12
		}
		if (null != dto.getPayDeduction16No12()) {
			prtItemChk(poi, line + 15, column, dto.getPayDeduction16No12()); // ^T16No12
		}
		if (null != dto.getPayDeduction17No12()) {
			prtItemChk(poi, line + 16, column, dto.getPayDeduction17No12()); // ^T17No12
		}
		if (null != dto.getPayDeduction18No12()) {
			prtItemChk(poi, line + 17, column, dto.getPayDeduction18No12()); // ^T18No12
		}
		if (null != dto.getPayDeduction19No12()) {
			prtItemChk(poi, line + 18, column, dto.getPayDeduction19No12()); // ^T19No12
		}
		if (null != dto.getPayDeduction20No12()) {
			prtItemChk(poi, line + 19, column, dto.getPayDeduction20No12()); // ^T20No12
		}
		if (null != dto.getPayDeduction21No12()) {
			prtItemChk(poi, line + 20, column, dto.getPayDeduction21No12()); // ^T21No12
		}
		if (null != dto.getPayDeduction22No12()) {
			prtItemChk(poi, line + 21, column, dto.getPayDeduction22No12()); // ^T22No12
		}
		if (null != dto.getPayDeduction23No12()) {
			prtItemChk(poi, line + 22, column, dto.getPayDeduction23No12()); // ^T23No12
		}
		if (null != dto.getPayDeduction24No12()) {
			prtItemChk(poi, line + 23, column, dto.getPayDeduction24No12()); // ^T24No12
		}
		if (null != dto.getPayDeduction25No12()) {
			prtItemChk(poi, line + 24, column, dto.getPayDeduction25No12()); // ^T25No12
		}
		if (null != dto.getPayDeductionTotal12()) {
			prtItemChk(poi, line + 25, column, dto.getPayDeductionTotal12()); // ^TzNo12
		}
		if (null != dto.getPayDeduction26No12()) {
			prtItemChk(poi, line + 26, column, dto.getPayDeduction26No12()); // ^T26No12
		}
		if (null != dto.getPayPaymentTotal12()) {
			prtItemChk(poi, line + 27, column, dto.getPayPaymentTotal12()); // ^xzNo12
		}
		if (null != dto.getPayBank1PayAmount12()) {
			prtItemChk(poi, line + 28, column, dto.getPayBank1PayAmount12()); // ^s1UzNo12
		}
		if (null != dto.getPayBank2PayAmount12()) {
			prtItemChk(poi, line + 29, column, dto.getPayBank2PayAmount12()); // ^s2UzNo12
		}
		if (null != dto.getPayCashPayAmount12()) {
			prtItemChk(poi, line + 30, column, dto.getPayCashPayAmount12()); // xzNo12
		}
		if (null != dto.getPayDeduction27No12()) {
			prtItemChk(poi, line + 31, column, dto.getPayDeduction27No12()); // ^T27No12
		}
		
		line = 8;
		column = 39; // Nԍv
		if (null != dto.getPayTotalAllowance01()) {
			prtItemChk(poi, line + 1, column, dto.getPayTotalAllowance01()); // ^x01v
		}
		if (null != dto.getPayTotalAllowance02()) {
			prtItemChk(poi, line + 2, column, dto.getPayTotalAllowance02()); // ^x02v
		}
		if (null != dto.getPayTotalAllowance03()) {
			prtItemChk(poi, line + 3, column, dto.getPayTotalAllowance03()); // ^x03v
		}
		if (null != dto.getPayTotalAllowance04()) {
			prtItemChk(poi, line + 4, column, dto.getPayTotalAllowance04()); // ^x04v
		}
		if (null != dto.getPayTotalAllowance05()) {
			prtItemChk(poi, line + 5, column, dto.getPayTotalAllowance05()); // ^x05v
		}
		if (null != dto.getPayTotalAllowance06()) {
			prtItemChk(poi, line + 6, column, dto.getPayTotalAllowance06()); // ^x06v
		}
		if (null != dto.getPayTotalAllowance07()) {
			prtItemChk(poi, line + 7, column, dto.getPayTotalAllowance07()); // ^x07v
		}
		if (null != dto.getPayTotalAllowance08()) {
			prtItemChk(poi, line + 8, column, dto.getPayTotalAllowance08()); // ^x08v
		}
		if (null != dto.getPayTotalAllowance09()) {
			prtItemChk(poi, line + 9, column, dto.getPayTotalAllowance09()); // ^x09v
		}
		if (null != dto.getPayTotalAllowance10()) {
			prtItemChk(poi, line + 10, column, dto.getPayTotalAllowance10()); // ^x10v
		}
		if (null != dto.getPayTotalAllowance11()) {
			prtItemChk(poi, line + 11, column, dto.getPayTotalAllowance11()); // ^x11v
		}
		if (null != dto.getPayTotalAllowance12()) {
			prtItemChk(poi, line + 12, column, dto.getPayTotalAllowance12()); // ^x12v
		}
		if (null != dto.getPayTotalAllowance13()) {
			prtItemChk(poi, line + 13, column, dto.getPayTotalAllowance13()); // ^x13v
		}
		if (null != dto.getPayTotalAllowance14()) {
			prtItemChk(poi, line + 14, column, dto.getPayTotalAllowance14()); // ^x14v
		}
		if (null != dto.getPayTotalAllowance15()) {
			prtItemChk(poi, line + 15, column, dto.getPayTotalAllowance15()); // ^x15v
		}
		if (null != dto.getPayTotalAllowance16()) {
			prtItemChk(poi, line + 16, column, dto.getPayTotalAllowance16()); // ^x16v
		}
		if (null != dto.getPayTotalAllowance17()) {
			prtItemChk(poi, line + 17, column, dto.getPayTotalAllowance17()); // ^x17v
		}
		if (null != dto.getPayTotalAllowance18()) {
			prtItemChk(poi, line + 18, column, dto.getPayTotalAllowance18()); // ^x18v
		}
		if (null != dto.getPayTotalAllowance19()) {
			prtItemChk(poi, line + 19, column, dto.getPayTotalAllowance19()); // ^x19v
		}
		if (null != dto.getPayTotalAllowance20()) {
			prtItemChk(poi, line + 20, column, dto.getPayTotalAllowance20()); // ^x20v
		}
		if (null != dto.getPayTotalAllowance21()) {
			prtItemChk(poi, line + 21, column, dto.getPayTotalAllowance21()); // ^x21v
		}
		if (null != dto.getPayTotalAllowance22()) {
			prtItemChk(poi, line + 22, column, dto.getPayTotalAllowance22()); // ^x22v
		}
		if (null != dto.getPayTotalAllowance23()) {
			prtItemChk(poi, line + 23, column, dto.getPayTotalAllowance23()); // ^x23v
		}
		if (null != dto.getPayTotalAllowance24()) {
			prtItemChk(poi, line + 24, column, dto.getPayTotalAllowance24()); // ^x24v
		}
		if (null != dto.getPayTotalAllowance25()) {
			prtItemChk(poi, line + 25, column, dto.getPayTotalAllowance25()); // ^x25v
		}
		if (null != dto.getPayTotalAllowance26()) {
			prtItemChk(poi, line + 26, column, dto.getPayTotalAllowance26()); // ^x26v
		}
		if (null != dto.getPayTotalAllowance27()) {
			prtItemChk(poi, line + 27, column, dto.getPayTotalAllowance27()); // ^x27v
		}
		if (null != dto.getPayTotalAllowance28()) {
			prtItemChk(poi, line + 28, column, dto.getPayTotalAllowance28()); // ^x28v
		}
		if (null != dto.getPayTotalAllowance29()) {
			prtItemChk(poi, line + 29, column, dto.getPayTotalAllowance29()); // ^x29v
		}
		if (null != dto.getPayTotalAllowance30()) {
			prtItemChk(poi, line + 30, column, dto.getPayTotalAllowance30()); // ^x30v
		}
		if (null != dto.getPayTotalAllowanceTotal()) {
			prtItemChk(poi, line + 31, column, dto.getPayTotalAllowanceTotal()); // ^xzv
		}
		line = 40;
		if (null != dto.getPayTotalDeduction01()) {
			prtItemChk(poi, line + 1, column, dto.getPayTotalDeduction01()); // ^T01v
		}
		if (null != dto.getPayTotalDeduction02()) {
			prtItemChk(poi, line + 2, column, dto.getPayTotalDeduction02()); // ^T02v
		}
		if (null != dto.getPayTotalDeduction03()) {
			prtItemChk(poi, line + 3, column, dto.getPayTotalDeduction03()); // ^T03v
		}
		if (null != dto.getPayTotalDeduction04()) {
			prtItemChk(poi, line + 4, column, dto.getPayTotalDeduction04()); // ^T04v
		}
		if (null != dto.getPayTotalDeduction05()) {
			prtItemChk(poi, line + 5, column, dto.getPayTotalDeduction05()); // ^T05v
		}
		if (null != dto.getPayTotalDeduction06()) {
			prtItemChk(poi, line + 6, column, dto.getPayTotalDeduction06()); // ^T06v
		}
		if (null != dto.getPayTotalDeduction07()) {
			prtItemChk(poi, line + 7, column, dto.getPayTotalDeduction07()); // ^T07v
		}
		if (null != dto.getPayTotalDeduction08()) {
			prtItemChk(poi, line + 8, column, dto.getPayTotalDeduction08()); // ^T08v
		}
		if (null != dto.getPayTotalDeduction09()) {
			prtItemChk(poi, line + 9, column, dto.getPayTotalDeduction09()); // ^T09v
		}
		if (null != dto.getPayTotalDeduction10()) {
			prtItemChk(poi, line + 10, column, dto.getPayTotalDeduction10()); // ^T10v
		}
		if (null != dto.getPayTotalDeduction11()) {
			prtItemChk(poi, line + 11, column, dto.getPayTotalDeduction11()); // ^T11v
		}
		if (null != dto.getPayTotalDeduction12()) {
			prtItemChk(poi, line + 12, column, dto.getPayTotalDeduction12()); // ^T12v
		}
		if (null != dto.getPayTotalDeduction14()) {
			prtItemChk(poi, line + 13, column, dto.getPayTotalDeduction14()); // ^T14v
		}
		if (null != dto.getPayTotalDeduction15()) {
			prtItemChk(poi, line + 14, column, dto.getPayTotalDeduction15()); // ^T15v
		}
		if (null != dto.getPayTotalDeduction16()) {
			prtItemChk(poi, line + 15, column, dto.getPayTotalDeduction16()); // ^T16v
		}
		if (null != dto.getPayTotalDeduction17()) {
			prtItemChk(poi, line + 16, column, dto.getPayTotalDeduction17()); // ^T17v
		}
		if (null != dto.getPayTotalDeduction18()) {
			prtItemChk(poi, line + 17, column, dto.getPayTotalDeduction18()); // ^T18v
		}
		if (null != dto.getPayTotalDeduction19()) {
			prtItemChk(poi, line + 18, column, dto.getPayTotalDeduction19()); // ^T19v
		}
		if (null != dto.getPayTotalDeduction20()) {
			prtItemChk(poi, line + 19, column, dto.getPayTotalDeduction20()); // ^T20v
		}
		if (null != dto.getPayTotalDeduction21()) {
			prtItemChk(poi, line + 20, column, dto.getPayTotalDeduction21()); // ^T21v
		}
		if (null != dto.getPayTotalDeduction22()) {
			prtItemChk(poi, line + 21, column, dto.getPayTotalDeduction22()); // ^T22v
		}
		if (null != dto.getPayTotalDeduction23()) {
			prtItemChk(poi, line + 22, column, dto.getPayTotalDeduction23()); // ^T23v
		}
		if (null != dto.getPayTotalDeduction24()) {
			prtItemChk(poi, line + 23, column, dto.getPayTotalDeduction24()); // ^T24v
		}
		if (null != dto.getPayTotalDeduction25()) {
			prtItemChk(poi, line + 24, column, dto.getPayTotalDeduction25()); // ^T25v
		}
		if (null != dto.getPayTotalDeductionTotal()) {
			prtItemChk(poi, line + 25, column, dto.getPayTotalDeductionTotal()); // ^Tzv
		}
		if (null != dto.getPayTotalDeduction26()) {
			prtItemChk(poi, line + 26, column, dto.getPayTotalDeduction26()); // ^T26v
		}
		if (null != dto.getPayTotalPaymentTotal()) {
			prtItemChk(poi, line + 27, column, dto.getPayTotalPaymentTotal()); // ^xzv
		}
		if (null != dto.getPayTotalBank1PayAmount()) {
			prtItemChk(poi, line + 28, column, dto.getPayTotalBank1PayAmount()); // ^s1Uzv
		}
		if (null != dto.getPayTotalBank2PayAmount()) {
			prtItemChk(poi, line + 29, column, dto.getPayTotalBank2PayAmount()); // ^s2Uzv
		}
		if (null != dto.getPayTotalCashPayAmount()) {
			prtItemChk(poi, line + 30, column, dto.getPayTotalCashPayAmount()); // xzv
		}
		if (null != dto.getPayTotalDeduction27()) {
			prtItemChk(poi, line + 31, column, dto.getPayTotalDeduction27()); // ^T27v
		}
		
		/** ΑӍڏo **/
		// ږo
		line = 80;
		column = 0;
		prtItemChk(poi, line + 1, column + 0, dto.getTitleAttendance01()); // ΑӍ01^Cg
		prtItemChk(poi, line + 2, column + 0, dto.getTitleAttendance02()); // ΑӍ02^Cg
		prtItemChk(poi, line + 3, column + 0, dto.getTitleAttendance03()); // ΑӍ03^Cg
		prtItemChk(poi, line + 4, column + 0, dto.getTitleAttendance04()); // ΑӍ04^Cg
		prtItemChk(poi, line + 5, column + 0, dto.getTitleAttendance05()); // ΑӍ05^Cg
		prtItemChk(poi, line + 6, column + 0, dto.getTitleAttendance06()); // ΑӍ06^Cg
		prtItemChk(poi, line + 7, column + 0, dto.getTitleAttendance07()); // ΑӍ07^Cg
		prtItemChk(poi, line + 8, column + 0, dto.getTitleAttendance08()); // ΑӍ08^Cg
		prtItemChk(poi, line + 9, column + 0, dto.getTitleAttendance09()); // ΑӍ09^Cg
		prtItemChk(poi, line + 10, column + 0, dto.getTitleAttendance10()); // ΑӍ10^Cg
		
		// ΑӖ׏o
		line = 80;
		column = 3; // 1
		if (null != dto.getPayPayday01()) {
			prtItemChk(poi, line + 0, column, dto.getPayPayday01()); // ^xNo01
		}
		if (null != dto.getAttendance01No01()) {
			prtItemChk(poi, line + 1, column, dto.getAttendance01No01()); // ΑӍ01No01
		}
		if (null != dto.getAttendance02No01()) {
			prtItemChk(poi, line + 2, column, dto.getAttendance02No01()); // ΑӍ02No01
		}
		if (null != dto.getAttendance03No01()) {
			prtItemChk(poi, line + 3, column, dto.getAttendance03No01()); // ΑӍ03No01
		}
		if (null != dto.getAttendance04No01()) {
			prtItemChk(poi, line + 4, column, dto.getAttendance04No01()); // ΑӍ04No01
		}
		if (null != dto.getAttendance05No01()) {
			prtItemChk(poi, line + 5, column, dto.getAttendance05No01()); // ΑӍ05No01
		}
		if (null != dto.getAttendance06No01()) {
			prtItemChk(poi, line + 6, column, dto.getAttendance06No01()); // ΑӍ06No01
		}
		if (null != dto.getAttendance07No01()) {
			prtItemChk(poi, line + 7, column, dto.getAttendance07No01()); // ΑӍ07No01
		}
		if (null != dto.getAttendance08No01()) {
			prtItemChk(poi, line + 8, column, dto.getAttendance08No01()); // ΑӍ08No01
		}
		if (null != dto.getAttendance09No01()) {
			prtItemChk(poi, line + 9, column, dto.getAttendance09No01()); // ΑӍ09No01
		}
		if (null != dto.getAttendance10No01()) {
			prtItemChk(poi, line + 10, column, dto.getAttendance10No01()); // ΑӍ00No01
		}
		if (null != dto.getAttendance11No01()) {
			prtItemChk(poi, line + 11, column, dto.getAttendance11No01()); // ΑӍ01No01
		}
		if (null != dto.getAttendance12No01()) {
			prtItemChk(poi, line + 12, column, dto.getAttendance12No01()); // ΑӍ02No01
		}
		if (null != dto.getAttendance13No01()) {
			prtItemChk(poi, line + 13, column, dto.getAttendance13No01()); // ΑӍ03No01
		}
		if (null != dto.getAttendance14No01()) {
			prtItemChk(poi, line + 14, column, dto.getAttendance14No01()); // ΑӍ04No01
		}
		
		line = 80;
		column = 6; // 2
		if (null != dto.getPayPayday02()) {
			prtItemChk(poi, line + 0, column, dto.getPayPayday02()); // ^xNo02
		}
		if (null != dto.getAttendance01No02()) {
			prtItemChk(poi, line + 1, column, dto.getAttendance01No02()); // ΑӍ01No02
		}
		if (null != dto.getAttendance02No02()) {
			prtItemChk(poi, line + 2, column, dto.getAttendance02No02()); // ΑӍ02No02
		}
		if (null != dto.getAttendance03No02()) {
			prtItemChk(poi, line + 3, column, dto.getAttendance03No02()); // ΑӍ03No02
		}
		if (null != dto.getAttendance04No02()) {
			prtItemChk(poi, line + 4, column, dto.getAttendance04No02()); // ΑӍ04No02
		}
		if (null != dto.getAttendance05No02()) {
			prtItemChk(poi, line + 5, column, dto.getAttendance05No02()); // ΑӍ05No02
		}
		if (null != dto.getAttendance06No02()) {
			prtItemChk(poi, line + 6, column, dto.getAttendance06No02()); // ΑӍ06No02
		}
		if (null != dto.getAttendance07No02()) {
			prtItemChk(poi, line + 7, column, dto.getAttendance07No02()); // ΑӍ07No02
		}
		if (null != dto.getAttendance08No02()) {
			prtItemChk(poi, line + 8, column, dto.getAttendance08No02()); // ΑӍ08No02
		}
		if (null != dto.getAttendance09No02()) {
			prtItemChk(poi, line + 9, column, dto.getAttendance09No02()); // ΑӍ09No02
		}
		if (null != dto.getAttendance10No02()) {
			prtItemChk(poi, line + 10, column, dto.getAttendance10No02()); // ΑӍ00No02
		}
		if (null != dto.getAttendance11No02()) {
			prtItemChk(poi, line + 11, column, dto.getAttendance11No02()); // ΑӍ01No02
		}
		if (null != dto.getAttendance12No02()) {
			prtItemChk(poi, line + 12, column, dto.getAttendance12No02()); // ΑӍ02No02
		}
		if (null != dto.getAttendance13No02()) {
			prtItemChk(poi, line + 13, column, dto.getAttendance13No02()); // ΑӍ03No02
		}
		if (null != dto.getAttendance14No02()) {
			prtItemChk(poi, line + 14, column, dto.getAttendance14No02()); // ΑӍ04No02
		}
		
		line = 80;
		column = 9; // 3
		if (null != dto.getPayPayday03()) {
			prtItemChk(poi, line + 0, column, dto.getPayPayday03()); // ^xNo03
		}
		if (null != dto.getAttendance01No03()) {
			prtItemChk(poi, line + 1, column, dto.getAttendance01No03()); // ΑӍ01No03
		}
		if (null != dto.getAttendance02No03()) {
			prtItemChk(poi, line + 2, column, dto.getAttendance02No03()); // ΑӍ02No03
		}
		if (null != dto.getAttendance03No03()) {
			prtItemChk(poi, line + 3, column, dto.getAttendance03No03()); // ΑӍ03No03
		}
		if (null != dto.getAttendance04No03()) {
			prtItemChk(poi, line + 4, column, dto.getAttendance04No03()); // ΑӍ04No03
		}
		if (null != dto.getAttendance05No03()) {
			prtItemChk(poi, line + 5, column, dto.getAttendance05No03()); // ΑӍ05No03
		}
		if (null != dto.getAttendance06No03()) {
			prtItemChk(poi, line + 6, column, dto.getAttendance06No03()); // ΑӍ06No03
		}
		if (null != dto.getAttendance07No03()) {
			prtItemChk(poi, line + 7, column, dto.getAttendance07No03()); // ΑӍ07No03
		}
		if (null != dto.getAttendance08No03()) {
			prtItemChk(poi, line + 8, column, dto.getAttendance08No03()); // ΑӍ08No03
		}
		if (null != dto.getAttendance09No03()) {
			prtItemChk(poi, line + 9, column, dto.getAttendance09No03()); // ΑӍ09No03
		}
		if (null != dto.getAttendance10No03()) {
			prtItemChk(poi, line + 10, column, dto.getAttendance10No03()); // ΑӍ00No03
		}
		if (null != dto.getAttendance11No03()) {
			prtItemChk(poi, line + 11, column, dto.getAttendance11No03()); // ΑӍ01No03
		}
		if (null != dto.getAttendance12No03()) {
			prtItemChk(poi, line + 12, column, dto.getAttendance12No03()); // ΑӍ02No03
		}
		if (null != dto.getAttendance13No03()) {
			prtItemChk(poi, line + 13, column, dto.getAttendance13No03()); // ΑӍ03No03
		}
		if (null != dto.getAttendance14No03()) {
			prtItemChk(poi, line + 14, column, dto.getAttendance14No03()); // ΑӍ04No03
		}
		
		line = 80;
		column = 12; // 4
		if (null != dto.getPayPayday04()) {
			prtItemChk(poi, line + 0, column, dto.getPayPayday04()); // ^xNo04
		}
		if (null != dto.getAttendance01No04()) {
			prtItemChk(poi, line + 1, column, dto.getAttendance01No04()); // ΑӍ01No04
		}
		if (null != dto.getAttendance02No04()) {
			prtItemChk(poi, line + 2, column, dto.getAttendance02No04()); // ΑӍ02No04
		}
		if (null != dto.getAttendance03No04()) {
			prtItemChk(poi, line + 3, column, dto.getAttendance03No04()); // ΑӍ03No04
		}
		if (null != dto.getAttendance04No04()) {
			prtItemChk(poi, line + 4, column, dto.getAttendance04No04()); // ΑӍ04No04
		}
		if (null != dto.getAttendance05No04()) {
			prtItemChk(poi, line + 5, column, dto.getAttendance05No04()); // ΑӍ05No04
		}
		if (null != dto.getAttendance06No04()) {
			prtItemChk(poi, line + 6, column, dto.getAttendance06No04()); // ΑӍ06No04
		}
		if (null != dto.getAttendance07No04()) {
			prtItemChk(poi, line + 7, column, dto.getAttendance07No04()); // ΑӍ07No04
		}
		if (null != dto.getAttendance08No04()) {
			prtItemChk(poi, line + 8, column, dto.getAttendance08No04()); // ΑӍ08No04
		}
		if (null != dto.getAttendance09No04()) {
			prtItemChk(poi, line + 9, column, dto.getAttendance09No04()); // ΑӍ09No04
		}
		if (null != dto.getAttendance10No04()) {
			prtItemChk(poi, line + 10, column, dto.getAttendance10No04()); // ΑӍ00No04
		}
		if (null != dto.getAttendance11No04()) {
			prtItemChk(poi, line + 11, column, dto.getAttendance11No04()); // ΑӍ01No04
		}
		if (null != dto.getAttendance12No04()) {
			prtItemChk(poi, line + 12, column, dto.getAttendance12No04()); // ΑӍ02No04
		}
		if (null != dto.getAttendance13No04()) {
			prtItemChk(poi, line + 13, column, dto.getAttendance13No04()); // ΑӍ03No04
		}
		if (null != dto.getAttendance14No04()) {
			prtItemChk(poi, line + 14, column, dto.getAttendance14No04()); // ΑӍ04No04
		}
		
		line = 80;
		column = 15; // 5
		if (null != dto.getPayPayday05()) {
			prtItemChk(poi, line + 0, column, dto.getPayPayday05()); // ^xNo05
		}
		if (null != dto.getAttendance01No05()) {
			prtItemChk(poi, line + 1, column, dto.getAttendance01No05()); // ΑӍ01No05
		}
		if (null != dto.getAttendance02No05()) {
			prtItemChk(poi, line + 2, column, dto.getAttendance02No05()); // ΑӍ02No05
		}
		if (null != dto.getAttendance03No05()) {
			prtItemChk(poi, line + 3, column, dto.getAttendance03No05()); // ΑӍ03No05
		}
		if (null != dto.getAttendance04No05()) {
			prtItemChk(poi, line + 4, column, dto.getAttendance04No05()); // ΑӍ04No05
		}
		if (null != dto.getAttendance05No05()) {
			prtItemChk(poi, line + 5, column, dto.getAttendance05No05()); // ΑӍ05No05
		}
		if (null != dto.getAttendance06No05()) {
			prtItemChk(poi, line + 6, column, dto.getAttendance06No05()); // ΑӍ06No05
		}
		if (null != dto.getAttendance07No05()) {
			prtItemChk(poi, line + 7, column, dto.getAttendance07No05()); // ΑӍ07No05
		}
		if (null != dto.getAttendance08No05()) {
			prtItemChk(poi, line + 8, column, dto.getAttendance08No05()); // ΑӍ08No05
		}
		if (null != dto.getAttendance09No05()) {
			prtItemChk(poi, line + 9, column, dto.getAttendance09No05()); // ΑӍ09No05
		}
		if (null != dto.getAttendance10No05()) {
			prtItemChk(poi, line + 10, column, dto.getAttendance10No05()); // ΑӍ00No05
		}
		if (null != dto.getAttendance11No05()) {
			prtItemChk(poi, line + 11, column, dto.getAttendance11No05()); // ΑӍ01No05
		}
		if (null != dto.getAttendance12No05()) {
			prtItemChk(poi, line + 12, column, dto.getAttendance12No05()); // ΑӍ02No05
		}
		if (null != dto.getAttendance13No05()) {
			prtItemChk(poi, line + 13, column, dto.getAttendance13No05()); // ΑӍ03No05
		}
		if (null != dto.getAttendance14No05()) {
			prtItemChk(poi, line + 14, column, dto.getAttendance14No05()); // ΑӍ04No05
		}
		
		line = 80;
		column = 18; // 6
		if (null != dto.getPayPayday06()) {
			prtItemChk(poi, line + 0, column, dto.getPayPayday06()); // ^xNo06
		}
		if (null != dto.getAttendance01No06()) {
			prtItemChk(poi, line + 1, column, dto.getAttendance01No06()); // ΑӍ01No06
		}
		if (null != dto.getAttendance02No06()) {
			prtItemChk(poi, line + 2, column, dto.getAttendance02No06()); // ΑӍ02No06
		}
		if (null != dto.getAttendance03No06()) {
			prtItemChk(poi, line + 3, column, dto.getAttendance03No06()); // ΑӍ03No06
		}
		if (null != dto.getAttendance04No06()) {
			prtItemChk(poi, line + 4, column, dto.getAttendance04No06()); // ΑӍ04No06
		}
		if (null != dto.getAttendance05No06()) {
			prtItemChk(poi, line + 5, column, dto.getAttendance05No06()); // ΑӍ05No06
		}
		if (null != dto.getAttendance06No06()) {
			prtItemChk(poi, line + 6, column, dto.getAttendance06No06()); // ΑӍ06No06
		}
		if (null != dto.getAttendance07No06()) {
			prtItemChk(poi, line + 7, column, dto.getAttendance07No06()); // ΑӍ07No06
		}
		if (null != dto.getAttendance08No06()) {
			prtItemChk(poi, line + 8, column, dto.getAttendance08No06()); // ΑӍ08No06
		}
		if (null != dto.getAttendance09No06()) {
			prtItemChk(poi, line + 9, column, dto.getAttendance09No06()); // ΑӍ09No06
		}
		if (null != dto.getAttendance10No06()) {
			prtItemChk(poi, line + 10, column, dto.getAttendance10No06()); // ΑӍ00No06
		}
		if (null != dto.getAttendance11No06()) {
			prtItemChk(poi, line + 11, column, dto.getAttendance11No06()); // ΑӍ01No06
		}
		if (null != dto.getAttendance12No06()) {
			prtItemChk(poi, line + 12, column, dto.getAttendance12No06()); // ΑӍ02No06
		}
		if (null != dto.getAttendance13No06()) {
			prtItemChk(poi, line + 13, column, dto.getAttendance13No06()); // ΑӍ03No06
		}
		if (null != dto.getAttendance14No06()) {
			prtItemChk(poi, line + 14, column, dto.getAttendance14No06()); // ΑӍ04No06
		}
		
		line = 80;
		column = 21; // 7
		if (null != dto.getPayPayday07()) {
			prtItemChk(poi, line + 0, column, dto.getPayPayday07()); // ^xNo07
		}
		if (null != dto.getAttendance01No07()) {
			prtItemChk(poi, line + 1, column, dto.getAttendance01No07()); // ΑӍ01No07
		}
		if (null != dto.getAttendance02No07()) {
			prtItemChk(poi, line + 2, column, dto.getAttendance02No07()); // ΑӍ02No07
		}
		if (null != dto.getAttendance03No07()) {
			prtItemChk(poi, line + 3, column, dto.getAttendance03No07()); // ΑӍ03No07
		}
		if (null != dto.getAttendance04No07()) {
			prtItemChk(poi, line + 4, column, dto.getAttendance04No07()); // ΑӍ04No07
		}
		if (null != dto.getAttendance05No07()) {
			prtItemChk(poi, line + 5, column, dto.getAttendance05No07()); // ΑӍ05No07
		}
		if (null != dto.getAttendance06No07()) {
			prtItemChk(poi, line + 6, column, dto.getAttendance06No07()); // ΑӍ06No07
		}
		if (null != dto.getAttendance07No07()) {
			prtItemChk(poi, line + 7, column, dto.getAttendance07No07()); // ΑӍ07No07
		}
		if (null != dto.getAttendance08No07()) {
			prtItemChk(poi, line + 8, column, dto.getAttendance08No07()); // ΑӍ08No07
		}
		if (null != dto.getAttendance09No07()) {
			prtItemChk(poi, line + 9, column, dto.getAttendance09No07()); // ΑӍ09No07
		}
		if (null != dto.getAttendance10No07()) {
			prtItemChk(poi, line + 10, column, dto.getAttendance10No07()); // ΑӍ00No07
		}
		if (null != dto.getAttendance11No07()) {
			prtItemChk(poi, line + 11, column, dto.getAttendance11No07()); // ΑӍ01No07
		}
		if (null != dto.getAttendance12No07()) {
			prtItemChk(poi, line + 12, column, dto.getAttendance12No07()); // ΑӍ02No07
		}
		if (null != dto.getAttendance13No07()) {
			prtItemChk(poi, line + 13, column, dto.getAttendance13No07()); // ΑӍ03No07
		}
		if (null != dto.getAttendance14No07()) {
			prtItemChk(poi, line + 14, column, dto.getAttendance14No07()); // ΑӍ04No07
		}
		
		line = 80;
		column = 24; // 8
		if (null != dto.getPayPayday08()) {
			prtItemChk(poi, line + 0, column, dto.getPayPayday08()); // ^xNo08
		}
		if (null != dto.getAttendance01No08()) {
			prtItemChk(poi, line + 1, column, dto.getAttendance01No08()); // ΑӍ01No08
		}
		if (null != dto.getAttendance02No08()) {
			prtItemChk(poi, line + 2, column, dto.getAttendance02No08()); // ΑӍ02No08
		}
		if (null != dto.getAttendance03No08()) {
			prtItemChk(poi, line + 3, column, dto.getAttendance03No08()); // ΑӍ03No08
		}
		if (null != dto.getAttendance04No08()) {
			prtItemChk(poi, line + 4, column, dto.getAttendance04No08()); // ΑӍ04No08
		}
		if (null != dto.getAttendance05No08()) {
			prtItemChk(poi, line + 5, column, dto.getAttendance05No08()); // ΑӍ05No08
		}
		if (null != dto.getAttendance06No08()) {
			prtItemChk(poi, line + 6, column, dto.getAttendance06No08()); // ΑӍ06No08
		}
		if (null != dto.getAttendance07No08()) {
			prtItemChk(poi, line + 7, column, dto.getAttendance07No08()); // ΑӍ07No08
		}
		if (null != dto.getAttendance08No08()) {
			prtItemChk(poi, line + 8, column, dto.getAttendance08No08()); // ΑӍ08No08
		}
		if (null != dto.getAttendance09No08()) {
			prtItemChk(poi, line + 9, column, dto.getAttendance09No08()); // ΑӍ09No08
		}
		if (null != dto.getAttendance10No08()) {
			prtItemChk(poi, line + 10, column, dto.getAttendance10No08()); // ΑӍ00No08
		}
		if (null != dto.getAttendance11No08()) {
			prtItemChk(poi, line + 11, column, dto.getAttendance11No08()); // ΑӍ01No08
		}
		if (null != dto.getAttendance12No08()) {
			prtItemChk(poi, line + 12, column, dto.getAttendance12No08()); // ΑӍ02No08
		}
		if (null != dto.getAttendance13No08()) {
			prtItemChk(poi, line + 13, column, dto.getAttendance13No08()); // ΑӍ03No08
		}
		if (null != dto.getAttendance14No08()) {
			prtItemChk(poi, line + 14, column, dto.getAttendance14No08()); // ΑӍ04No08
		}
		
		line = 80;
		column = 27; // 9
		if (null != dto.getPayPayday09()) {
			prtItemChk(poi, line + 0, column, dto.getPayPayday09()); // ^xNo09
		}
		if (null != dto.getAttendance01No09()) {
			prtItemChk(poi, line + 1, column, dto.getAttendance01No09()); // ΑӍ01No09
		}
		if (null != dto.getAttendance02No09()) {
			prtItemChk(poi, line + 2, column, dto.getAttendance02No09()); // ΑӍ02No09
		}
		if (null != dto.getAttendance03No09()) {
			prtItemChk(poi, line + 3, column, dto.getAttendance03No09()); // ΑӍ03No09
		}
		if (null != dto.getAttendance04No09()) {
			prtItemChk(poi, line + 4, column, dto.getAttendance04No09()); // ΑӍ04No09
		}
		if (null != dto.getAttendance05No09()) {
			prtItemChk(poi, line + 5, column, dto.getAttendance05No09()); // ΑӍ05No09
		}
		if (null != dto.getAttendance06No09()) {
			prtItemChk(poi, line + 6, column, dto.getAttendance06No09()); // ΑӍ06No09
		}
		if (null != dto.getAttendance07No09()) {
			prtItemChk(poi, line + 7, column, dto.getAttendance07No09()); // ΑӍ07No09
		}
		if (null != dto.getAttendance08No09()) {
			prtItemChk(poi, line + 8, column, dto.getAttendance08No09()); // ΑӍ08No09
		}
		if (null != dto.getAttendance09No09()) {
			prtItemChk(poi, line + 9, column, dto.getAttendance09No09()); // ΑӍ09No09
		}
		if (null != dto.getAttendance10No09()) {
			prtItemChk(poi, line + 10, column, dto.getAttendance10No09()); // ΑӍ00No09
		}
		if (null != dto.getAttendance11No09()) {
			prtItemChk(poi, line + 11, column, dto.getAttendance11No09()); // ΑӍ01No09
		}
		if (null != dto.getAttendance12No09()) {
			prtItemChk(poi, line + 12, column, dto.getAttendance12No09()); // ΑӍ02No09
		}
		if (null != dto.getAttendance13No09()) {
			prtItemChk(poi, line + 13, column, dto.getAttendance13No09()); // ΑӍ03No09
		}
		if (null != dto.getAttendance14No09()) {
			prtItemChk(poi, line + 14, column, dto.getAttendance14No09()); // ΑӍ04No09
		}
		
		line = 80;
		column = 30; //10
		if (null != dto.getPayPayday10()) {
			prtItemChk(poi, line + 0, column, dto.getPayPayday10()); // ^xNo10
		}
		if (null != dto.getAttendance01No10()) {
			prtItemChk(poi, line + 1, column, dto.getAttendance01No10()); // ΑӍ01No10
		}
		if (null != dto.getAttendance02No10()) {
			prtItemChk(poi, line + 2, column, dto.getAttendance02No10()); // ΑӍ02No10
		}
		if (null != dto.getAttendance03No10()) {
			prtItemChk(poi, line + 3, column, dto.getAttendance03No10()); // ΑӍ03No10
		}
		if (null != dto.getAttendance04No10()) {
			prtItemChk(poi, line + 4, column, dto.getAttendance04No10()); // ΑӍ04No10
		}
		if (null != dto.getAttendance05No10()) {
			prtItemChk(poi, line + 5, column, dto.getAttendance05No10()); // ΑӍ05No10
		}
		if (null != dto.getAttendance06No10()) {
			prtItemChk(poi, line + 6, column, dto.getAttendance06No10()); // ΑӍ06No10
		}
		if (null != dto.getAttendance07No10()) {
			prtItemChk(poi, line + 7, column, dto.getAttendance07No10()); // ΑӍ07No10
		}
		if (null != dto.getAttendance08No10()) {
			prtItemChk(poi, line + 8, column, dto.getAttendance08No10()); // ΑӍ08No10
		}
		if (null != dto.getAttendance09No10()) {
			prtItemChk(poi, line + 9, column, dto.getAttendance09No10()); // ΑӍ09No10
		}
		if (null != dto.getAttendance10No10()) {
			prtItemChk(poi, line + 10, column, dto.getAttendance10No10()); // ΑӍ00No10
		}
		if (null != dto.getAttendance11No10()) {
			prtItemChk(poi, line + 11, column, dto.getAttendance11No10()); // ΑӍ01No10
		}
		if (null != dto.getAttendance12No10()) {
			prtItemChk(poi, line + 12, column, dto.getAttendance12No10()); // ΑӍ02No10
		}
		if (null != dto.getAttendance13No10()) {
			prtItemChk(poi, line + 13, column, dto.getAttendance13No10()); // ΑӍ03No10
		}
		if (null != dto.getAttendance14No10()) {
			prtItemChk(poi, line + 14, column, dto.getAttendance14No10()); // ΑӍ04No10
		}
		
		line = 80;
		column = 33; // 11
		if (null != dto.getPayPayday11()) {
			prtItemChk(poi, line + 0, column, dto.getPayPayday11()); // ^xNo11
		}
		if (null != dto.getAttendance01No11()) {
			prtItemChk(poi, line + 1, column, dto.getAttendance01No11()); // ΑӍ01No11
		}
		if (null != dto.getAttendance02No11()) {
			prtItemChk(poi, line + 2, column, dto.getAttendance02No11()); // ΑӍ02No11
		}
		if (null != dto.getAttendance03No11()) {
			prtItemChk(poi, line + 3, column, dto.getAttendance03No11()); // ΑӍ03No11
		}
		if (null != dto.getAttendance04No11()) {
			prtItemChk(poi, line + 4, column, dto.getAttendance04No11()); // ΑӍ04No11
		}
		if (null != dto.getAttendance05No11()) {
			prtItemChk(poi, line + 5, column, dto.getAttendance05No11()); // ΑӍ05No11
		}
		if (null != dto.getAttendance06No11()) {
			prtItemChk(poi, line + 6, column, dto.getAttendance06No11()); // ΑӍ06No11
		}
		if (null != dto.getAttendance07No11()) {
			prtItemChk(poi, line + 7, column, dto.getAttendance07No11()); // ΑӍ07No11
		}
		if (null != dto.getAttendance08No11()) {
			prtItemChk(poi, line + 8, column, dto.getAttendance08No11()); // ΑӍ08No11
		}
		if (null != dto.getAttendance09No11()) {
			prtItemChk(poi, line + 9, column, dto.getAttendance09No11()); // ΑӍ09No11
		}
		if (null != dto.getAttendance10No11()) {
			prtItemChk(poi, line + 10, column, dto.getAttendance10No11()); // ΑӍ00No11
		}
		if (null != dto.getAttendance11No11()) {
			prtItemChk(poi, line + 11, column, dto.getAttendance11No11()); // ΑӍ01No11
		}
		if (null != dto.getAttendance12No11()) {
			prtItemChk(poi, line + 12, column, dto.getAttendance12No11()); // ΑӍ02No11
		}
		if (null != dto.getAttendance13No11()) {
			prtItemChk(poi, line + 13, column, dto.getAttendance13No11()); // ΑӍ03No11
		}
		if (null != dto.getAttendance14No11()) {
			prtItemChk(poi, line + 14, column, dto.getAttendance14No11()); // ΑӍ04No11
		}
		
		line = 80;
		column = 36; // 12
		if (null != dto.getPayPayday12()) {
			prtItemChk(poi, line + 0, column, dto.getPayPayday12()); // ^xNo12
		}
		if (null != dto.getAttendance01No12()) {
			prtItemChk(poi, line + 1, column, dto.getAttendance01No12()); // ΑӍ01No12
		}
		if (null != dto.getAttendance02No12()) {
			prtItemChk(poi, line + 2, column, dto.getAttendance02No12()); // ΑӍ02No12
		}
		if (null != dto.getAttendance03No12()) {
			prtItemChk(poi, line + 3, column, dto.getAttendance03No12()); // ΑӍ03No12
		}
		if (null != dto.getAttendance04No12()) {
			prtItemChk(poi, line + 4, column, dto.getAttendance04No12()); // ΑӍ04No12
		}
		if (null != dto.getAttendance05No12()) {
			prtItemChk(poi, line + 5, column, dto.getAttendance05No12()); // ΑӍ05No12
		}
		if (null != dto.getAttendance06No12()) {
			prtItemChk(poi, line + 6, column, dto.getAttendance06No12()); // ΑӍ06No12
		}
		if (null != dto.getAttendance07No12()) {
			prtItemChk(poi, line + 7, column, dto.getAttendance07No12()); // ΑӍ07No12
		}
		if (null != dto.getAttendance08No12()) {
			prtItemChk(poi, line + 8, column, dto.getAttendance08No12()); // ΑӍ08No12
		}
		if (null != dto.getAttendance09No12()) {
			prtItemChk(poi, line + 9, column, dto.getAttendance09No12()); // ΑӍ09No12
		}
		if (null != dto.getAttendance10No12()) {
			prtItemChk(poi, line + 10, column, dto.getAttendance10No12()); // ΑӍ00No12
		}
		if (null != dto.getAttendance11No12()) {
			prtItemChk(poi, line + 11, column, dto.getAttendance11No12()); // ΑӍ01No12
		}
		if (null != dto.getAttendance12No12()) {
			prtItemChk(poi, line + 12, column, dto.getAttendance12No12()); // ΑӍ02No12
		}
		if (null != dto.getAttendance13No12()) {
			prtItemChk(poi, line + 13, column, dto.getAttendance13No12()); // ΑӍ03No12
		}
		if (null != dto.getAttendance14No12()) {
			prtItemChk(poi, line + 14, column, dto.getAttendance14No12()); // ΑӍ04No12
		}
		
		line = 80;
		column = 39; // Nԍv
		if (null != dto.getTotalAttendance01()) {
			prtItemChk(poi, line + 1, column, dto.getTotalAttendance01()); // ΑӍ01v
		}
		if (null != dto.getTotalAttendance02()) {
			prtItemChk(poi, line + 2, column, dto.getTotalAttendance02()); // ΑӍ02v
		}
		if (null != dto.getTotalAttendance03()) {
			prtItemChk(poi, line + 3, column, dto.getTotalAttendance03()); // ΑӍ03v
		}
		if (null != dto.getTotalAttendance04()) {
			prtItemChk(poi, line + 4, column, dto.getTotalAttendance04()); // ΑӍ04v
		}
		if (null != dto.getTotalAttendance05()) {
			prtItemChk(poi, line + 5, column, dto.getTotalAttendance05()); // ΑӍ05v
		}
		if (null != dto.getTotalAttendance06()) {
			prtItemChk(poi, line + 6, column, dto.getTotalAttendance06()); // ΑӍ06v
		}
		if (null != dto.getTotalAttendance07()) {
			prtItemChk(poi, line + 7, column, dto.getTotalAttendance07()); // ΑӍ07v
		}
		if (null != dto.getTotalAttendance08()) {
			prtItemChk(poi, line + 8, column, dto.getTotalAttendance08()); // ΑӍ08v
		}
		if (null != dto.getTotalAttendance09()) {
			prtItemChk(poi, line + 9, column, dto.getTotalAttendance09()); // ΑӍ09v
		}
		if (null != dto.getTotalAttendance10()) {
			prtItemChk(poi, line + 10, column, dto.getTotalAttendance10()); // ΑӍ00v
		}
		if (null != dto.getTotalAttendance11()) {
			prtItemChk(poi, line + 11, column, dto.getTotalAttendance11()); // ΑӍ01v
		}
		if (null != dto.getTotalAttendance12()) {
			prtItemChk(poi, line + 12, column, dto.getTotalAttendance12()); // ΑӍ02v
		}
		if (null != dto.getTotalAttendance13()) {
			prtItemChk(poi, line + 13, column, dto.getTotalAttendance13()); // ΑӍ03v
		}
		if (null != dto.getTotalAttendance14()) {
			prtItemChk(poi, line + 14, column, dto.getTotalAttendance14()); // ΑӍ04v
		}
		
		/** ܗ^ڏo **/
		// ږo
		line = 98;
		column = 0;
		prtItemChk(poi, line + 0, column + 0, dto.getTitleAllowanceItem()); // xږ^Cg
		prtItemChk(poi, line + 1, column + 0, dto.getTitleBonAllowance01()); // ܗ^x01^Cg
		prtItemChk(poi, line + 2, column + 0, dto.getTitleBonAllowance02()); // ܗ^x02^Cg
		prtItemChk(poi, line + 3, column + 0, dto.getTitleBonAllowance03()); // ܗ^x03^Cg
		prtItemChk(poi, line + 4, column + 0, dto.getTitleBonAllowance04()); // ܗ^x04^Cg
		prtItemChk(poi, line + 5, column + 0, dto.getTitleBonAllowance05()); // ܗ^x05^Cg
		prtItemChk(poi, line + 6, column + 0, dto.getTitleBonAllowance06()); // ܗ^x06^Cg
		prtItemChk(poi, line + 7, column + 0, dto.getTitleBonAllowance07()); // ܗ^x07^Cg
		prtItemChk(poi, line + 8, column + 0, dto.getTitleBonAllowance08()); // ܗ^x08^Cg
		prtItemChk(poi, line + 9, column + 0, dto.getTitleBonAllowance09()); // ܗ^x09^Cg
		prtItemChk(poi, line + 10, column + 0, dto.getTitleBonAllowance10()); // ܗ^x10^Cg
		prtItemChk(poi, line + 11, column + 0, dto.getTitleAllowanceTotal()); // xz^Cg		
		prtItemChk(poi, line + 12, column + 0, "" + dto.getTitleDeductionItem() + ""); // Tڃ^Cg  
		prtItemChk(poi, line + 13, column + 0, dto.getTitleBonDeduction01()); // ܗ^T01^Cg
		prtItemChk(poi, line + 14, column + 0, dto.getTitleBonDeduction02()); // ܗ^T02^Cg
		prtItemChk(poi, line + 15, column + 0, dto.getTitleBonDeduction03()); // ܗ^T03^Cg
		prtItemChk(poi, line + 16, column + 0, dto.getTitleBonDeduction04()); // ܗ^T04^Cg
		prtItemChk(poi, line + 17, column + 0, dto.getTitleBonDeduction05()); // ܗ^T05^Cg
		prtItemChk(poi, line + 18, column + 0, dto.getTitleBonDeduction06()); // ܗ^T06^Cg
		prtItemChk(poi, line + 19, column + 0, dto.getTitleBonDeduction07()); // ܗ^T07^Cg
		prtItemChk(poi, line + 20, column + 0, dto.getTitleBonDeduction08()); // ܗ^T08^Cg
		prtItemChk(poi, line + 21, column + 0, dto.getTitleBonDeduction09()); // ܗ^T09^Cg
		prtItemChk(poi, line + 22, column + 0, dto.getTitleBonDeduction10()); // ܗ^T10^Cg
		prtItemChk(poi, line + 23, column + 0, dto.getTitleBonDeduction11()); // ܗ^T11^Cg
		prtItemChk(poi, line + 24, column + 0, dto.getTitleBonDeduction12()); // ܗ^T12^Cg
		prtItemChk(poi, line + 25, column + 0, dto.getTitleBonDeduction14()); // ܗ^T14^Cg
		prtItemChk(poi, line + 26, column + 0, dto.getTitleBonDeduction15()); // ܗ^T15^Cg
		prtItemChk(poi, line + 27, column + 0, dto.getTitleBonDeduction16()); // ܗ^T16^Cg
		prtItemChk(poi, line + 28, column + 0, dto.getTitleDeductionTotal()); // Tz^Cg
		prtItemChk(poi, line + 29, column + 0, dto.getTitlePaymentTotal()); // xz^Cg
		prtItemChk(poi, line + 30, column + 0, dto.getTitleBank1PayAmount()); // s1Uz
		prtItemChk(poi, line + 31, column + 0, dto.getTitleBank2PayAmount()); // s2Uz
		prtItemChk(poi, line + 32, column + 0, dto.getTitleCashPayAmount()); // xz
		prtItemChk(poi, line + 33, column + 0, dto.getTitleBonDeduction17()); // ܗ^T17^Cg
		
		// ܗ^x׏o
		line = 97;
		column = 3; // 1
		if (null != dto.getBonPayday01()) {
			prtItemChk(poi, line + 0, column, dto.getBonPayday01()); // ܗ^xNo01
		}
		if (null != dto.getBonAllowance01No01()) {
			prtItemChk(poi, line + 1, column, dto.getBonAllowance01No01()); // ܗ^x01No01
		}
		if (null != dto.getBonAllowance02No01()) {
			prtItemChk(poi, line + 2, column, dto.getBonAllowance02No01()); // ܗ^x02No01
		}
		if (null != dto.getBonAllowance03No01()) {
			prtItemChk(poi, line + 3, column, dto.getBonAllowance03No01()); // ܗ^x03No01
		}
		if (null != dto.getBonAllowance04No01()) {
			prtItemChk(poi, line + 4, column, dto.getBonAllowance04No01()); // ܗ^x04No01
		}
		if (null != dto.getBonAllowance05No01()) {
			prtItemChk(poi, line + 5, column, dto.getBonAllowance05No01()); // ܗ^x05No01
		}
		if (null != dto.getBonAllowance06No01()) {
			prtItemChk(poi, line + 6, column, dto.getBonAllowance06No01()); // ܗ^x06No01
		}
		if (null != dto.getBonAllowance07No01()) {
			prtItemChk(poi, line + 7, column, dto.getBonAllowance07No01()); // ܗ^x07No01
		}
		if (null != dto.getBonAllowance08No01()) {
			prtItemChk(poi, line + 8, column, dto.getBonAllowance08No01()); // ܗ^x08No01
		}
		if (null != dto.getBonAllowance09No01()) {
			prtItemChk(poi, line + 9, column, dto.getBonAllowance09No01()); // ܗ^x09No01
		}
		if (null != dto.getBonAllowance10No01()) {
			prtItemChk(poi, line + 10, column, dto.getBonAllowance10No01()); // ܗ^x10No01
		}
		if (null != dto.getBonAllowanceTotal01()) {
			prtItemChk(poi, line + 11, column, dto.getBonAllowanceTotal01()); // ܗ^x1ڌv
		}
		
		line = 97;
		column = 6; // 2
		if (null != dto.getBonPayday02()) {
			prtItemChk(poi, line + 0, column, dto.getBonPayday02()); // ܗ^xNo02
		}
		if (null != dto.getBonAllowance01No02()) {
			prtItemChk(poi, line + 1, column, dto.getBonAllowance01No02()); // ܗ^x01No02
		}
		if (null != dto.getBonAllowance02No02()) {
			prtItemChk(poi, line + 2, column, dto.getBonAllowance02No02()); // ܗ^x02No02
		}
		if (null != dto.getBonAllowance03No02()) {
			prtItemChk(poi, line + 3, column, dto.getBonAllowance03No02()); // ܗ^x03No02
		}
		if (null != dto.getBonAllowance04No02()) {
			prtItemChk(poi, line + 4, column, dto.getBonAllowance04No02()); // ܗ^x04No02
		}
		if (null != dto.getBonAllowance05No02()) {
			prtItemChk(poi, line + 5, column, dto.getBonAllowance05No02()); // ܗ^x05No02
		}
		if (null != dto.getBonAllowance06No02()) {
			prtItemChk(poi, line + 6, column, dto.getBonAllowance06No02()); // ܗ^x06No02
		}
		if (null != dto.getBonAllowance07No02()) {
			prtItemChk(poi, line + 7, column, dto.getBonAllowance07No02()); // ܗ^x07No02
		}
		if (null != dto.getBonAllowance08No02()) {
			prtItemChk(poi, line + 8, column, dto.getBonAllowance08No02()); // ܗ^x08No02
		}
		if (null != dto.getBonAllowance09No02()) {
			prtItemChk(poi, line + 9, column, dto.getBonAllowance09No02()); // ܗ^x09No02
		}
		if (null != dto.getBonAllowance10No02()) {
			prtItemChk(poi, line + 10, column, dto.getBonAllowance10No02()); // ܗ^x10No02
		}
		if (null != dto.getBonAllowanceTotal02()) {
			prtItemChk(poi, line + 11, column, dto.getBonAllowanceTotal02()); // ܗ^x2ڌv
		}
		
		line = 97;
		column = 9; // 3
		if (null != dto.getBonPayday03()) {
			prtItemChk(poi, line + 0, column, dto.getBonPayday03()); // ܗ^xNo03
		}
		if (null != dto.getBonAllowance01No03()) {
			prtItemChk(poi, line + 1, column, dto.getBonAllowance01No03()); // ܗ^x01No03
		}
		if (null != dto.getBonAllowance02No03()) {
			prtItemChk(poi, line + 2, column, dto.getBonAllowance02No03()); // ܗ^x02No03
		}
		if (null != dto.getBonAllowance03No03()) {
			prtItemChk(poi, line + 3, column, dto.getBonAllowance03No03()); // ܗ^x03No03
		}
		if (null != dto.getBonAllowance04No03()) {
			prtItemChk(poi, line + 4, column, dto.getBonAllowance04No03()); // ܗ^x04No03
		}
		if (null != dto.getBonAllowance05No03()) {
			prtItemChk(poi, line + 5, column, dto.getBonAllowance05No03()); // ܗ^x05No03
		}
		if (null != dto.getBonAllowance06No03()) {
			prtItemChk(poi, line + 6, column, dto.getBonAllowance06No03()); // ܗ^x06No03
		}
		if (null != dto.getBonAllowance07No03()) {
			prtItemChk(poi, line + 7, column, dto.getBonAllowance07No03()); // ܗ^x07No03
		}
		if (null != dto.getBonAllowance08No03()) {
			prtItemChk(poi, line + 8, column, dto.getBonAllowance08No03()); // ܗ^x08No03
		}
		if (null != dto.getBonAllowance09No03()) {
			prtItemChk(poi, line + 9, column, dto.getBonAllowance09No03()); // ܗ^x09No03
		}
		if (null != dto.getBonAllowance10No03()) {
			prtItemChk(poi, line + 10, column, dto.getBonAllowance10No03()); // ܗ^x10No03
		}
		if (null != dto.getBonAllowanceTotal03()) {
			prtItemChk(poi, line + 11, column, dto.getBonAllowanceTotal03()); // ܗ^x3ڌv
		}
		
		line = 97;
		column = 12; // 4
		if (null != dto.getBonPayday04()) {
			prtItemChk(poi, line + 0, column, dto.getBonPayday04()); // ܗ^xNo04
		}
		if (null != dto.getBonAllowance01No04()) {
			prtItemChk(poi, line + 1, column, dto.getBonAllowance01No04()); // ܗ^x01No04
		}
		if (null != dto.getBonAllowance02No04()) {
			prtItemChk(poi, line + 2, column, dto.getBonAllowance02No04()); // ܗ^x02No04
		}
		if (null != dto.getBonAllowance03No04()) {
			prtItemChk(poi, line + 3, column, dto.getBonAllowance03No04()); // ܗ^x03No04
		}
		if (null != dto.getBonAllowance04No04()) {
			prtItemChk(poi, line + 4, column, dto.getBonAllowance04No04()); // ܗ^x04No04
		}
		if (null != dto.getBonAllowance05No04()) {
			prtItemChk(poi, line + 5, column, dto.getBonAllowance05No04()); // ܗ^x05No04
		}
		if (null != dto.getBonAllowance06No04()) {
			prtItemChk(poi, line + 6, column, dto.getBonAllowance06No04()); // ܗ^x06No04
		}
		if (null != dto.getBonAllowance07No04()) {
			prtItemChk(poi, line + 7, column, dto.getBonAllowance07No04()); // ܗ^x07No04
		}
		if (null != dto.getBonAllowance08No04()) {
			prtItemChk(poi, line + 8, column, dto.getBonAllowance08No04()); // ܗ^x08No04
		}
		if (null != dto.getBonAllowance09No04()) {
			prtItemChk(poi, line + 9, column, dto.getBonAllowance09No04()); // ܗ^x09No04
		}
		if (null != dto.getBonAllowance10No04()) {
			prtItemChk(poi, line + 10, column, dto.getBonAllowance10No04()); // ܗ^x10No04
		}
		if (null != dto.getBonAllowanceTotal04()) {
			prtItemChk(poi, line + 11, column, dto.getBonAllowanceTotal04()); // ܗ^x4ڌv
		}
		
		line = 97;
		column = 15; // 5
		if (null != dto.getBonPayday05()) {
			prtItemChk(poi, line + 0, column, dto.getBonPayday05()); // ܗ^xNo05
		}
		if (null != dto.getBonAllowance01No05()) {
			prtItemChk(poi, line + 1, column, dto.getBonAllowance01No05()); // ܗ^x01No05
		}
		if (null != dto.getBonAllowance02No05()) {
			prtItemChk(poi, line + 2, column, dto.getBonAllowance02No05()); // ܗ^x02No05
		}
		if (null != dto.getBonAllowance03No05()) {
			prtItemChk(poi, line + 3, column, dto.getBonAllowance03No05()); // ܗ^x03No05
		}
		if (null != dto.getBonAllowance04No05()) {
			prtItemChk(poi, line + 4, column, dto.getBonAllowance04No05()); // ܗ^x04No05
		}
		if (null != dto.getBonAllowance05No05()) {
			prtItemChk(poi, line + 5, column, dto.getBonAllowance05No05()); // ܗ^x05No05
		}
		if (null != dto.getBonAllowance06No05()) {
			prtItemChk(poi, line + 6, column, dto.getBonAllowance06No05()); // ܗ^x06No05
		}
		if (null != dto.getBonAllowance07No05()) {
			prtItemChk(poi, line + 7, column, dto.getBonAllowance07No05()); // ܗ^x07No05
		}
		if (null != dto.getBonAllowance08No05()) {
			prtItemChk(poi, line + 8, column, dto.getBonAllowance08No05()); // ܗ^x08No05
		}
		if (null != dto.getBonAllowance09No05()) {
			prtItemChk(poi, line + 9, column, dto.getBonAllowance09No05()); // ܗ^x09No05
		}
		if (null != dto.getBonAllowance10No05()) {
			prtItemChk(poi, line + 10, column, dto.getBonAllowance10No05()); // ܗ^x10No05
		}
		if (null != dto.getBonAllowanceTotal05()) {
			prtItemChk(poi, line + 11, column, dto.getBonAllowanceTotal05()); // ܗ^x5ڌv
		}
		
		line = 97;
		column = 18; // 6
		if (null != dto.getBonPayday06()) {
			prtItemChk(poi, line + 0, column, dto.getBonPayday06()); // ܗ^xNo06
		}
		if (null != dto.getBonAllowance01No06()) {
			prtItemChk(poi, line + 1, column, dto.getBonAllowance01No06()); // ܗ^x01No06
		}
		if (null != dto.getBonAllowance02No06()) {
			prtItemChk(poi, line + 2, column, dto.getBonAllowance02No06()); // ܗ^x02No06
		}
		if (null != dto.getBonAllowance03No06()) {
			prtItemChk(poi, line + 3, column, dto.getBonAllowance03No06()); // ܗ^x03No06
		}
		if (null != dto.getBonAllowance04No06()) {
			prtItemChk(poi, line + 4, column, dto.getBonAllowance04No06()); // ܗ^x04No06
		}
		if (null != dto.getBonAllowance05No06()) {
			prtItemChk(poi, line + 5, column, dto.getBonAllowance05No06()); // ܗ^x05No06
		}
		if (null != dto.getBonAllowance06No06()) {
			prtItemChk(poi, line + 6, column, dto.getBonAllowance06No06()); // ܗ^x06No06
		}
		if (null != dto.getBonAllowance07No06()) {
			prtItemChk(poi, line + 7, column, dto.getBonAllowance07No06()); // ܗ^x07No06
		}
		if (null != dto.getBonAllowance08No06()) {
			prtItemChk(poi, line + 8, column, dto.getBonAllowance08No06()); // ܗ^x08No06
		}
		if (null != dto.getBonAllowance09No06()) {
			prtItemChk(poi, line + 9, column, dto.getBonAllowance09No06()); // ܗ^x09No06
		}
		if (null != dto.getBonAllowance10No06()) {
			prtItemChk(poi, line + 10, column, dto.getBonAllowance10No06()); // ܗ^x10No06
		}
		if (null != dto.getBonAllowanceTotal06()) {
			prtItemChk(poi, line + 11, column, dto.getBonAllowanceTotal06()); // ܗ^x6ڌv
		}
		
		line = 97;
		column = 21; // Nԍv
		if (null != dto.getBonTotalAllowance01()) {
			prtItemChk(poi, line + 1, column, dto.getBonTotalAllowance01()); // ܗ^x01v
		}
		if (null != dto.getBonTotalAllowance02()) {
			prtItemChk(poi, line + 2, column, dto.getBonTotalAllowance02()); // ܗ^x02v
		}
		if (null != dto.getBonTotalAllowance03()) {
			prtItemChk(poi, line + 3, column, dto.getBonTotalAllowance03()); // ܗ^x03v
		}
		if (null != dto.getBonTotalAllowance04()) {
			prtItemChk(poi, line + 4, column, dto.getBonTotalAllowance04()); // ܗ^x04v
		}
		if (null != dto.getBonTotalAllowance05()) {
			prtItemChk(poi, line + 5, column, dto.getBonTotalAllowance05()); // ܗ^x05v
		}
		if (null != dto.getBonTotalAllowance06()) {
			prtItemChk(poi, line + 6, column, dto.getBonTotalAllowance06()); // ܗ^x06v
		}
		if (null != dto.getBonTotalAllowance07()) {
			prtItemChk(poi, line + 7, column, dto.getBonTotalAllowance07()); // ܗ^x07v
		}
		if (null != dto.getBonTotalAllowance08()) {
			prtItemChk(poi, line + 8, column, dto.getBonTotalAllowance08()); // ܗ^x08v
		}
		if (null != dto.getBonTotalAllowance09()) {
			prtItemChk(poi, line + 9, column, dto.getBonTotalAllowance09()); // ܗ^x09v
		}
		if (null != dto.getBonTotalAllowance10()) {
			prtItemChk(poi, line + 10, column, dto.getBonTotalAllowance10()); // ܗ^x10v
		}
		if (null != dto.getBonTotalAllowanceTotal()) {
			prtItemChk(poi, line + 11, column, dto.getBonTotalAllowanceTotal()); // ܗ^xڍv
		}
		
		// ܗ^T׏o
		line = 110;
		column = 3; // 1
		if (null != dto.getBonDeduction01No01()) {
			prtItemChk(poi, line + 1, column, dto.getBonDeduction01No01()); // ܗ^T01No01
		}
		if (null != dto.getBonDeduction02No01()) {
			prtItemChk(poi, line + 2, column, dto.getBonDeduction02No01()); // ܗ^T02No01
		}
		if (null != dto.getBonDeduction03No01()) {
			prtItemChk(poi, line + 3, column, dto.getBonDeduction03No01()); // ܗ^T03No01
		}
		if (null != dto.getBonDeduction04No01()) {
			prtItemChk(poi, line + 4, column, dto.getBonDeduction04No01()); // ܗ^T04No01
		}
		if (null != dto.getBonDeduction05No01()) {
			prtItemChk(poi, line + 5, column, dto.getBonDeduction05No01()); // ܗ^T05No01
		}
		if (null != dto.getBonDeduction06No01()) {
			prtItemChk(poi, line + 6, column, dto.getBonDeduction06No01()); // ܗ^T06No01
		}
		if (null != dto.getBonDeduction07No01()) {
			prtItemChk(poi, line + 7, column, dto.getBonDeduction07No01()); // ܗ^T07No01
		}
		if (null != dto.getBonDeduction08No01()) {
			prtItemChk(poi, line + 8, column, dto.getBonDeduction08No01()); // ܗ^T08No01
		}
		if (null != dto.getBonDeduction09No01()) {
			prtItemChk(poi, line + 9, column, dto.getBonDeduction09No01()); // ܗ^T09No01
		}
		if (null != dto.getBonDeduction10No01()) {
			prtItemChk(poi, line + 10, column, dto.getBonDeduction10No01()); // ܗ^T10No01
		}
		if (null != dto.getBonDeduction11No01()) {
			prtItemChk(poi, line + 11, column, dto.getBonDeduction11No01()); // ܗ^T11No01
		}
		if (null != dto.getBonDeduction12No01()) {
			prtItemChk(poi, line + 12, column, dto.getBonDeduction12No01()); // ܗ^T12No01
		}
		if (null != dto.getBonDeduction14No01()) {
			prtItemChk(poi, line + 13, column, dto.getBonDeduction14No01()); // ܗ^T14No01
		}
		if (null != dto.getBonDeduction15No01()) {
			prtItemChk(poi, line + 14, column, dto.getBonDeduction15No01()); // ܗ^T15No01
		}
		if (null != dto.getBonDeduction16No01()) {
			prtItemChk(poi, line + 15, column, dto.getBonDeduction16No01()); // ܗ^T16No01
		}
		if (null != dto.getBonDeduction17No01()) {
			prtItemChk(poi, line + 16, column, dto.getBonDeduction17No01()); // ܗ^T17No01
		}
		if (null != dto.getBonDeductionTotal01()) {
			prtItemChk(poi, line + 17, column, dto.getBonDeductionTotal01()); // ܗ^1ڍTڌv
		}
		if (null != dto.getBonPaymentTotal01()) {
			prtItemChk(poi, line + 18, column, dto.getBonPaymentTotal01()); // ܗ^1ڍxzv
		}
		if (null != dto.getBonBank1PayAmount01()) {
			prtItemChk(poi, line + 19, column, dto.getBonBank1PayAmount01()); // ܗ^1ڋs1Uzv
		}
		if (null != dto.getBonBank2PayAmount01()) {
			prtItemChk(poi, line + 20, column, dto.getBonBank2PayAmount01()); // ܗ^1ڋs2Uzv
		}
		if (null != dto.getBonCashPayAmount01()) {
			prtItemChk(poi, line + 21, column, dto.getBonCashPayAmount01()); // ܗ^1ڌxzv
		}
		
		line = 110;
		column = 6; // 2
		if (null != dto.getBonDeduction01No02()) {
			prtItemChk(poi, line + 1, column, dto.getBonDeduction01No02()); // ܗ^T01No02
		}
		if (null != dto.getBonDeduction02No02()) {
			prtItemChk(poi, line + 2, column, dto.getBonDeduction02No02()); // ܗ^T02No02
		}
		if (null != dto.getBonDeduction03No02()) {
			prtItemChk(poi, line + 3, column, dto.getBonDeduction03No02()); // ܗ^T03No02
		}
		if (null != dto.getBonDeduction04No02()) {
			prtItemChk(poi, line + 4, column, dto.getBonDeduction04No02()); // ܗ^T04No02
		}
		if (null != dto.getBonDeduction05No02()) {
			prtItemChk(poi, line + 5, column, dto.getBonDeduction05No02()); // ܗ^T05No02
		}
		if (null != dto.getBonDeduction06No02()) {
			prtItemChk(poi, line + 6, column, dto.getBonDeduction06No02()); // ܗ^T06No02
		}
		if (null != dto.getBonDeduction07No02()) {
			prtItemChk(poi, line + 7, column, dto.getBonDeduction07No02()); // ܗ^T07No02
		}
		if (null != dto.getBonDeduction08No02()) {
			prtItemChk(poi, line + 8, column, dto.getBonDeduction08No02()); // ܗ^T08No02
		}
		if (null != dto.getBonDeduction09No02()) {
			prtItemChk(poi, line + 9, column, dto.getBonDeduction09No02()); // ܗ^T09No02
		}
		if (null != dto.getBonDeduction10No02()) {
			prtItemChk(poi, line + 10, column, dto.getBonDeduction10No02()); // ܗ^T10No02
		}
		if (null != dto.getBonDeduction11No02()) {
			prtItemChk(poi, line + 11, column, dto.getBonDeduction11No02()); // ܗ^T11No02
		}
		if (null != dto.getBonDeduction12No02()) {
			prtItemChk(poi, line + 12, column, dto.getBonDeduction12No02()); // ܗ^T12No02
		}
		if (null != dto.getBonDeduction14No02()) {
			prtItemChk(poi, line + 13, column, dto.getBonDeduction14No02()); // ܗ^T14No02
		}
		if (null != dto.getBonDeduction15No02()) {
			prtItemChk(poi, line + 14, column, dto.getBonDeduction15No02()); // ܗ^T15No02
		}
		if (null != dto.getBonDeduction16No02()) {
			prtItemChk(poi, line + 15, column, dto.getBonDeduction16No02()); // ܗ^T16No02
		}
		if (null != dto.getBonDeduction17No02()) {
			prtItemChk(poi, line + 16, column, dto.getBonDeduction17No02()); // ܗ^T17No02
		}
		if (null != dto.getBonDeductionTotal02()) {
			prtItemChk(poi, line + 17, column, dto.getBonDeductionTotal02()); // ܗ^2ڍTڌv
		}
		if (null != dto.getBonPaymentTotal02()) {
			prtItemChk(poi, line + 18, column, dto.getBonPaymentTotal02()); // ܗ^2ڍxzv
		}
		if (null != dto.getBonBank1PayAmount02()) {
			prtItemChk(poi, line + 19, column, dto.getBonBank1PayAmount02()); // ܗ^2ڋs1Uzv
		}
		if (null != dto.getBonBank2PayAmount02()) {
			prtItemChk(poi, line + 20, column, dto.getBonBank2PayAmount02()); // ܗ^2ڋs2Uzv
		}
		if (null != dto.getBonCashPayAmount02()) {
			prtItemChk(poi, line + 21, column, dto.getBonCashPayAmount02()); // ܗ^2ڌxzv
		}
		
		line = 110;
		column = 9; // 3
		if (null != dto.getBonDeduction01No03()) {
			prtItemChk(poi, line + 1, column, dto.getBonDeduction01No03()); // ܗ^T01No03
		}
		if (null != dto.getBonDeduction02No03()) {
			prtItemChk(poi, line + 2, column, dto.getBonDeduction02No03()); // ܗ^T02No03
		}
		if (null != dto.getBonDeduction03No03()) {
			prtItemChk(poi, line + 3, column, dto.getBonDeduction03No03()); // ܗ^T03No03
		}
		if (null != dto.getBonDeduction04No03()) {
			prtItemChk(poi, line + 4, column, dto.getBonDeduction04No03()); // ܗ^T04No03
		}
		if (null != dto.getBonDeduction05No03()) {
			prtItemChk(poi, line + 5, column, dto.getBonDeduction05No03()); // ܗ^T05No03
		}
		if (null != dto.getBonDeduction06No03()) {
			prtItemChk(poi, line + 6, column, dto.getBonDeduction06No03()); // ܗ^T06No03
		}
		if (null != dto.getBonDeduction07No03()) {
			prtItemChk(poi, line + 7, column, dto.getBonDeduction07No03()); // ܗ^T07No03
		}
		if (null != dto.getBonDeduction08No03()) {
			prtItemChk(poi, line + 8, column, dto.getBonDeduction08No03()); // ܗ^T08No03
		}
		if (null != dto.getBonDeduction09No03()) {
			prtItemChk(poi, line + 9, column, dto.getBonDeduction09No03()); // ܗ^T09No03
		}
		if (null != dto.getBonDeduction10No03()) {
			prtItemChk(poi, line + 10, column, dto.getBonDeduction10No03()); // ܗ^T10No03
		}
		if (null != dto.getBonDeduction11No03()) {
			prtItemChk(poi, line + 11, column, dto.getBonDeduction11No03()); // ܗ^T11No03
		}
		if (null != dto.getBonDeduction12No03()) {
			prtItemChk(poi, line + 12, column, dto.getBonDeduction12No03()); // ܗ^T12No03
		}
		if (null != dto.getBonDeduction14No03()) {
			prtItemChk(poi, line + 13, column, dto.getBonDeduction14No03()); // ܗ^T14No03
		}
		if (null != dto.getBonDeduction15No03()) {
			prtItemChk(poi, line + 14, column, dto.getBonDeduction15No03()); // ܗ^T15No03
		}
		if (null != dto.getBonDeduction16No03()) {
			prtItemChk(poi, line + 15, column, dto.getBonDeduction16No03()); // ܗ^T16No03
		}
		if (null != dto.getBonDeduction17No03()) {
			prtItemChk(poi, line + 16, column, dto.getBonDeduction17No03()); // ܗ^T17No03
		}
		if (null != dto.getBonDeductionTotal03()) {
			prtItemChk(poi, line + 17, column, dto.getBonDeductionTotal03()); // ܗ^3ڍTڌv
		}
		if (null != dto.getBonPaymentTotal03()) {
			prtItemChk(poi, line + 18, column, dto.getBonPaymentTotal03()); // ܗ^3ڍxzv
		}
		if (null != dto.getBonBank1PayAmount03()) {
			prtItemChk(poi, line + 19, column, dto.getBonBank1PayAmount03()); // ܗ^3ڋs1Uzv
		}
		if (null != dto.getBonBank2PayAmount03()) {
			prtItemChk(poi, line + 20, column, dto.getBonBank2PayAmount03()); // ܗ^3ڋs2Uzv
		}
		if (null != dto.getBonCashPayAmount03()) {
			prtItemChk(poi, line + 21, column, dto.getBonCashPayAmount03()); // ܗ^3ڌxzv
		}
		
		line = 110;
		column = 12; // 4
		if (null != dto.getBonDeduction01No04()) {
			prtItemChk(poi, line + 1, column, dto.getBonDeduction01No04()); // ܗ^T01No04
		}
		if (null != dto.getBonDeduction02No04()) {
			prtItemChk(poi, line + 2, column, dto.getBonDeduction02No04()); // ܗ^T02No04
		}
		if (null != dto.getBonDeduction03No04()) {
			prtItemChk(poi, line + 3, column, dto.getBonDeduction03No04()); // ܗ^T03No04
		}
		if (null != dto.getBonDeduction04No04()) {
			prtItemChk(poi, line + 4, column, dto.getBonDeduction04No04()); // ܗ^T04No04
		}
		if (null != dto.getBonDeduction05No04()) {
			prtItemChk(poi, line + 5, column, dto.getBonDeduction05No04()); // ܗ^T05No04
		}
		if (null != dto.getBonDeduction06No04()) {
			prtItemChk(poi, line + 6, column, dto.getBonDeduction06No04()); // ܗ^T06No04
		}
		if (null != dto.getBonDeduction07No04()) {
			prtItemChk(poi, line + 7, column, dto.getBonDeduction07No04()); // ܗ^T07No04
		}
		if (null != dto.getBonDeduction08No04()) {
			prtItemChk(poi, line + 8, column, dto.getBonDeduction08No04()); // ܗ^T08No04
		}
		if (null != dto.getBonDeduction09No04()) {
			prtItemChk(poi, line + 9, column, dto.getBonDeduction09No04()); // ܗ^T09No04
		}
		if (null != dto.getBonDeduction10No04()) {
			prtItemChk(poi, line + 10, column, dto.getBonDeduction10No04()); // ܗ^T10No04
		}
		if (null != dto.getBonDeduction11No04()) {
			prtItemChk(poi, line + 11, column, dto.getBonDeduction11No04()); // ܗ^T11No04
		}
		if (null != dto.getBonDeduction12No04()) {
			prtItemChk(poi, line + 12, column, dto.getBonDeduction12No04()); // ܗ^T12No04
		}
		if (null != dto.getBonDeduction14No04()) {
			prtItemChk(poi, line + 13, column, dto.getBonDeduction14No04()); // ܗ^T14No04
		}
		if (null != dto.getBonDeduction15No04()) {
			prtItemChk(poi, line + 14, column, dto.getBonDeduction15No04()); // ܗ^T15No04
		}
		if (null != dto.getBonDeduction16No04()) {
			prtItemChk(poi, line + 15, column, dto.getBonDeduction16No04()); // ܗ^T16No04
		}
		if (null != dto.getBonDeduction17No04()) {
			prtItemChk(poi, line + 16, column, dto.getBonDeduction17No04()); // ܗ^T17No04
		}
		if (null != dto.getBonDeductionTotal04()) {
			prtItemChk(poi, line + 17, column, dto.getBonDeductionTotal04()); // ܗ^4ڍTڌv
		}
		if (null != dto.getBonPaymentTotal04()) {
			prtItemChk(poi, line + 18, column, dto.getBonPaymentTotal04()); // ܗ^4ڍxzv
		}
		if (null != dto.getBonBank1PayAmount04()) {
			prtItemChk(poi, line + 19, column, dto.getBonBank1PayAmount04()); // ܗ^4ڋs1Uzv
		}
		if (null != dto.getBonBank2PayAmount04()) {
			prtItemChk(poi, line + 20, column, dto.getBonBank2PayAmount04()); // ܗ^4ڋs2Uzv
		}
		if (null != dto.getBonCashPayAmount04()) {
			prtItemChk(poi, line + 21, column, dto.getBonCashPayAmount04()); // ܗ^4ڌxzv
		}
		
		line = 110;
		column = 15; // 5
		if (null != dto.getBonDeduction01No05()) {
			prtItemChk(poi, line + 1, column, dto.getBonDeduction01No05()); // ܗ^T01No05
		}
		if (null != dto.getBonDeduction02No05()) {
			prtItemChk(poi, line + 2, column, dto.getBonDeduction02No05()); // ܗ^T02No05
		}
		if (null != dto.getBonDeduction03No05()) {
			prtItemChk(poi, line + 3, column, dto.getBonDeduction03No05()); // ܗ^T03No05
		}
		if (null != dto.getBonDeduction04No05()) {
			prtItemChk(poi, line + 4, column, dto.getBonDeduction04No05()); // ܗ^T04No05
		}
		if (null != dto.getBonDeduction05No05()) {
			prtItemChk(poi, line + 5, column, dto.getBonDeduction05No05()); // ܗ^T05No05
		}
		if (null != dto.getBonDeduction06No05()) {
			prtItemChk(poi, line + 6, column, dto.getBonDeduction06No05()); // ܗ^T06No05
		}
		if (null != dto.getBonDeduction07No05()) {
			prtItemChk(poi, line + 7, column, dto.getBonDeduction07No05()); // ܗ^T07No05
		}
		if (null != dto.getBonDeduction08No05()) {
			prtItemChk(poi, line + 8, column, dto.getBonDeduction08No05()); // ܗ^T08No05
		}
		if (null != dto.getBonDeduction09No05()) {
			prtItemChk(poi, line + 9, column, dto.getBonDeduction09No05()); // ܗ^T09No05
		}
		if (null != dto.getBonDeduction10No05()) {
			prtItemChk(poi, line + 10, column, dto.getBonDeduction10No05()); // ܗ^T10No05
		}
		if (null != dto.getBonDeduction11No05()) {
			prtItemChk(poi, line + 11, column, dto.getBonDeduction11No05()); // ܗ^T11No05
		}
		if (null != dto.getBonDeduction12No05()) {
			prtItemChk(poi, line + 12, column, dto.getBonDeduction12No05()); // ܗ^T12No05
		}
		if (null != dto.getBonDeduction14No05()) {
			prtItemChk(poi, line + 13, column, dto.getBonDeduction14No05()); // ܗ^T14No05
		}
		if (null != dto.getBonDeduction15No05()) {
			prtItemChk(poi, line + 14, column, dto.getBonDeduction15No05()); // ܗ^T15No05
		}
		if (null != dto.getBonDeduction16No05()) {
			prtItemChk(poi, line + 15, column, dto.getBonDeduction16No05()); // ܗ^T16No05
		}
		if (null != dto.getBonDeduction17No05()) {
			prtItemChk(poi, line + 16, column, dto.getBonDeduction17No05()); // ܗ^T17No05
		}
		if (null != dto.getBonDeductionTotal05()) {
			prtItemChk(poi, line + 17, column, dto.getBonDeductionTotal05()); // ܗ^5ڍTڌv
		}
		if (null != dto.getBonPaymentTotal05()) {
			prtItemChk(poi, line + 18, column, dto.getBonPaymentTotal05()); // ܗ^5ڍxzv
		}
		if (null != dto.getBonBank1PayAmount05()) {
			prtItemChk(poi, line + 19, column, dto.getBonBank1PayAmount05()); // ܗ^5ڋs1Uzv
		}
		if (null != dto.getBonBank2PayAmount05()) {
			prtItemChk(poi, line + 20, column, dto.getBonBank2PayAmount05()); // ܗ^5ڋs2Uzv
		}
		if (null != dto.getBonCashPayAmount05()) {
			prtItemChk(poi, line + 21, column, dto.getBonCashPayAmount05()); // ܗ^5ڌxzv
		}
		
		line = 110;
		column = 18; // 6
		if (null != dto.getBonDeduction01No06()) {
			prtItemChk(poi, line + 1, column, dto.getBonDeduction01No06()); // ܗ^T01No06
		}
		if (null != dto.getBonDeduction02No06()) {
			prtItemChk(poi, line + 2, column, dto.getBonDeduction02No06()); // ܗ^T02No06
		}
		if (null != dto.getBonDeduction03No06()) {
			prtItemChk(poi, line + 3, column, dto.getBonDeduction03No06()); // ܗ^T03No06
		}
		if (null != dto.getBonDeduction04No06()) {
			prtItemChk(poi, line + 4, column, dto.getBonDeduction04No06()); // ܗ^T04No06
		}
		if (null != dto.getBonDeduction05No06()) {
			prtItemChk(poi, line + 5, column, dto.getBonDeduction05No06()); // ܗ^T05No06
		}
		if (null != dto.getBonDeduction06No06()) {
			prtItemChk(poi, line + 6, column, dto.getBonDeduction06No06()); // ܗ^T06No06
		}
		if (null != dto.getBonDeduction07No06()) {
			prtItemChk(poi, line + 7, column, dto.getBonDeduction07No06()); // ܗ^T07No06
		}
		if (null != dto.getBonDeduction08No06()) {
			prtItemChk(poi, line + 8, column, dto.getBonDeduction08No06()); // ܗ^T08No06
		}
		if (null != dto.getBonDeduction09No06()) {
			prtItemChk(poi, line + 9, column, dto.getBonDeduction09No06()); // ܗ^T09No06
		}
		if (null != dto.getBonDeduction10No06()) {
			prtItemChk(poi, line + 10, column, dto.getBonDeduction10No06()); // ܗ^T10No06
		}
		if (null != dto.getBonDeduction11No06()) {
			prtItemChk(poi, line + 11, column, dto.getBonDeduction11No06()); // ܗ^T11No06
		}
		if (null != dto.getBonDeduction12No06()) {
			prtItemChk(poi, line + 12, column, dto.getBonDeduction12No06()); // ܗ^T12No06
		}
		if (null != dto.getBonDeduction14No06()) {
			prtItemChk(poi, line + 13, column, dto.getBonDeduction14No06()); // ܗ^T14No06
		}
		if (null != dto.getBonDeduction15No06()) {
			prtItemChk(poi, line + 14, column, dto.getBonDeduction15No06()); // ܗ^T15No06
		}
		if (null != dto.getBonDeduction16No06()) {
			prtItemChk(poi, line + 15, column, dto.getBonDeduction16No06()); // ܗ^T16No06
		}
		if (null != dto.getBonDeduction17No06()) {
			prtItemChk(poi, line + 16, column, dto.getBonDeduction17No06()); // ܗ^T17No06
		}
		if (null != dto.getBonDeductionTotal06()) {
			prtItemChk(poi, line + 17, column, dto.getBonDeductionTotal06()); // ܗ^6ڍTڌv
		}
		if (null != dto.getBonPaymentTotal06()) {
			prtItemChk(poi, line + 18, column, dto.getBonPaymentTotal06()); // ܗ^6ڍxzv
		}
		if (null != dto.getBonBank1PayAmount06()) {
			prtItemChk(poi, line + 19, column, dto.getBonBank1PayAmount06()); // ܗ^6ڋs1Uzv
		}
		if (null != dto.getBonBank2PayAmount06()) {
			prtItemChk(poi, line + 20, column, dto.getBonBank2PayAmount06()); // ܗ^6ڋs2Uzv
		}
		if (null != dto.getBonCashPayAmount06()) {
			prtItemChk(poi, line + 21, column, dto.getBonCashPayAmount06()); // ܗ^6ڌxzv
		}
		
		line = 110;
		column = 21; // Nԍv
		if (null != dto.getBonTotalDeduction01()) {
			prtItemChk(poi, line + 1, column, dto.getBonTotalDeduction01()); // ܗ^T01NԌv
		}
		if (null != dto.getBonTotalDeduction02()) {
			prtItemChk(poi, line + 2, column, dto.getBonTotalDeduction02()); // ܗ^T02NԌv
		}
		if (null != dto.getBonTotalDeduction03()) {
			prtItemChk(poi, line + 3, column, dto.getBonTotalDeduction03()); // ܗ^T03NԌv
		}
		if (null != dto.getBonTotalDeduction04()) {
			prtItemChk(poi, line + 4, column, dto.getBonTotalDeduction04()); // ܗ^T04NԌv
		}
		if (null != dto.getBonTotalDeduction05()) {
			prtItemChk(poi, line + 5, column, dto.getBonTotalDeduction05()); // ܗ^T05NԌv
		}
		if (null != dto.getBonTotalDeduction06()) {
			prtItemChk(poi, line + 6, column, dto.getBonTotalDeduction06()); // ܗ^T06NԌv
		}
		if (null != dto.getBonTotalDeduction07()) {
			prtItemChk(poi, line + 7, column, dto.getBonTotalDeduction07()); // ܗ^T07NԌv
		}
		if (null != dto.getBonTotalDeduction08()) {
			prtItemChk(poi, line + 8, column, dto.getBonTotalDeduction08()); // ܗ^T08NԌv
		}
		if (null != dto.getBonTotalDeduction09()) {
			prtItemChk(poi, line + 9, column, dto.getBonTotalDeduction09()); // ܗ^T09NԌv
		}
		if (null != dto.getBonTotalDeduction10()) {
			prtItemChk(poi, line + 10, column, dto.getBonTotalDeduction10()); // ܗ^T10NԌv
		}
		if (null != dto.getBonTotalDeduction11()) {
			prtItemChk(poi, line + 11, column, dto.getBonTotalDeduction11()); // ܗ^T11NԌv
		}
		if (null != dto.getBonTotalDeduction12()) {
			prtItemChk(poi, line + 12, column, dto.getBonTotalDeduction12()); // ܗ^T12NԌv
		}
		if (null != dto.getBonTotalDeduction14()) {
			prtItemChk(poi, line + 13, column, dto.getBonTotalDeduction14()); // ܗ^T14NԌv
		}
		if (null != dto.getBonTotalDeduction15()) {
			prtItemChk(poi, line + 14, column, dto.getBonTotalDeduction15()); // ܗ^T15NԌv
		}
		if (null != dto.getBonTotalDeduction16()) {
			prtItemChk(poi, line + 15, column, dto.getBonTotalDeduction16()); // ܗ^T16NԌv
		}
		if (null != dto.getBonTotalDeduction17()) {
			prtItemChk(poi, line + 16, column, dto.getBonTotalDeduction17()); // ܗ^T17NԌv
		}
		if (null != dto.getBonTotalDeductionTotal()) {
			prtItemChk(poi, line + 17, column, dto.getBonTotalDeductionTotal()); // ܗ^Tڍv
		}
		if (null != dto.getBonTotalPaymentTotal()) {
			prtItemChk(poi, line + 18, column, dto.getBonTotalPaymentTotal()); // ܗ^xzvv
		}
		if (null != dto.getBonTotalBank1PayAmount()) {
			prtItemChk(poi, line + 19, column, dto.getBonTotalBank1PayAmount()); // ܗ^s1Uzvv
		}
		if (null != dto.getBonTotalBank2PayAmount()) {
			prtItemChk(poi, line + 20, column, dto.getBonTotalBank2PayAmount()); // ܗ^s2Uzvv
		}
		if (null != dto.getBonTotalCashPayAmount()) {
			prtItemChk(poi, line + 21, column, dto.getBonTotalCashPayAmount()); // ܗ^xzvv
		}
		
		// }{T\
		line = 126;
		column = 28;
		if (null != dto.getIncomeTaxType()) {
			prtItemChk(poi, line + 0, column + 0, dto.getIncomeTaxType()); // ېŋ敪
		}
		if (null != dto.getAdjustmentType()) {
			prtItemChk(poi, line + 1, column + 0, dto.getAdjustmentType()); // N敪
		}
		if (null != dto.getSelfWidowType()) {
			prtItemChk(poi, line + 2, column + 0, dto.getSelfWidowType()); // {l敪PF{lǕw敪
		}
		if (null != dto.getSelfHandicapType()) {
			prtItemChk(poi, line + 3, column + 0, dto.getSelfHandicapType()); // {l敪QF{lQ敪
		}
		if (null != dto.getSelfStudentType()) {
			prtItemChk(poi, line + 4, column + 0, dto.getSelfStudentType()); // {l敪RF{lw敪
		}
		if (null != dto.getSpouseIntendType()) {
			prtItemChk(poi, line + 5, column + 0, dto.getSpouseIntendType()); // zҋ敪
		}
		if (null != dto.getGeneralDependent()) {
			prtItemChk(poi, line + 0, column + 6, dto.getGeneralDependent()); // ʕ}{e
		}
		if (null != dto.getSpecificDependent()) {
			prtItemChk(poi, line + 1, column + 6, dto.getSpecificDependent()); // }{e
		}
		if (null != dto.getElderlyDependent()) {
			prtItemChk(poi, line + 2, column + 6, dto.getElderlyDependent()); // Vl}{e
		}
		if (null != dto.getLiveWithEldRel()) {
			prtItemChk(poi, line + 3, column + 6, dto.getLiveWithEldRel()); // Vle
		}
		if (null != dto.getGeneralHandicap()) {
			prtItemChk(poi, line + 5, column + 6, dto.getGeneralHandicap()); // ʏQ
		}
		if (null != dto.getLiveWithHandiGe()) {
			prtItemChk(poi, line + 0, column + 12, dto.getLiveWithHandiGe()); // 
		}
		if (null != dto.getLiveWithHandiSp()) {
			prtItemChk(poi, line + 1, column + 12, dto.getLiveWithHandiSp()); // 
		}
		if (null != dto.getLiveWithHandiEl()) {
			prtItemChk(poi, line + 2, column + 12, dto.getLiveWithHandiEl()); // Vl
		}
		if (null != dto.getLiveWithHandiEr()) {
			prtItemChk(poi, line + 3, column + 12, dto.getLiveWithHandiEr()); // Ve
		}
		if (null != dto.getSpecificHandicap()) {
			prtItemChk(poi, line + 5, column + 12, dto.getSpecificHandicap()); // ʏQ
		}
		
		// l
		if ((null != dto.getGender()) && (dto.getGender().equals("2"))) {
			prtItemChk(poi, 134, 13, ""); // 
		} else {
			prtItemChk(poi, 134, 13, "j"); // 
		}
		line = 135;
		column = 13;
		prtItemChk(poi, line + 0, column + 0, dto.getBirthDate()); // N		
		prtItemChk(poi, line + 1, column + 0, dto.getEntranceDate()); // Г		
		prtItemChk(poi, line + 2, column + 0, dto.getRetirementDate()); // ގГ		
		
		line = 134;
		column = 21;
		prtItemChk(poi, line + 0, column + 0, dto.getPostalCode()); // ZiX֔ԍj
		prtItemChk(poi, line + 1, column + 0, dto.getAddress()); // Z
		prtItemChk(poi, line + 3, column + 0, dto.getPhoneNumber()); // dbԍ		
		
		line = 134;
		column = 32;
		prtItemChk(poi, line + 0, column + 0, dto.getHealthNo()); // Nیԍ
		prtItemChk(poi, line + 0, column + 6, dto.getFundNo()); // ԍ
		prtItemChk(poi, line + 2, column + 0, dto.getPensionNo()); // bNԍ
		prtItemChk(poi, line + 2, column + 6, dto.getUnemployNo()); // ٗpیԍ
		
		// o͓eݒ
		String fileName = String.valueOf(vo.getHidAdjustYear()) + PayrollConst.FILE_NAME_SEPARATOR + dto.getKCode()
				+ PayrollConst.FILE_NAME_SEPARATOR + PayrollConst.FILE_PAYMENTLEDGER_XLS;
		request.setAttribute(MospConst.ATT_FILE_NAME, fileName);
		request.setAttribute(MospConst.ATT_FILE_OBJECT, poi.getWorkbook());
	}
	
	/**
	 * [o͏sB(OpenOffice Calc)<br><br>
	 * @throws Exception 
	 */
	private void report(AdjustmentReferVo vo, PaymentLedgerDto dto) throws Exception {
		int line;
		int column;
		
		// RlNV擾
		getConnection();
		// [쐬
		OdsBean odsBean = new OdsBean(cfg.getProperty(MospConst.PPT_APP_DOCBASE)
				+ PayrollConst.TEMPLATE_PAYMENTLEDGER_ODS);
		
		// wb_[
		line = 0;
		column = 13;
		setValueChk(odsBean, column + 0, line + 0, dto.getOutputYear()); // ΏۘaNx(^Cg)
		setValueChk(odsBean, column + 0, line + 73, dto.getOutputYear()); // ΏۘaNx(^Cg)
		
		line = 2;
		column = 0;
		setValueChk(odsBean, column + 0, line + 0, dto.getCompanyName()); // Ж
		setValueChk(odsBean, column + 0, line + 73, dto.getCompanyName()); // Ж
		
		line = 2;
		column = 38;
		setValueChk(odsBean, column + 0, line + 0, dto.getOutputDate()); // o͓t
		setValueChk(odsBean, column + 0, line + 73, dto.getOutputDate()); // o͓t
		
		line = 4;
		column = 2;
		setValueChk(odsBean, column + 0, line + 0, vo.getEscLblStationName()); // 
		setValueChk(odsBean, column + 0, line + 73, vo.getEscLblStationName()); // 
		setValueChk(odsBean, column + 0, line + 130, vo.getEscLblStationName()); // 
		
		line = 4;
		column = 10;
		setValueChk(odsBean, column + 0, line + 0, vo.getEscLblPositionName()); // Eʖ		
		setValueChk(odsBean, column + 0, line + 73, vo.getEscLblPositionName()); // Eʖ
		setValueChk(odsBean, 2, line + 131, vo.getEscLblPositionName()); // Eʖ
		
		line = 4;
		column = 19;
		setValueChk(odsBean, column + 0, line + 0, dto.getKCode()); // ЈR[h
		setValueChk(odsBean, column + 0, line + 73, dto.getKCode()); // ЈR[h
		setValueChk(odsBean, 2, line + 132, dto.getKCode()); // ЈR[h
		
		line = 4;
		column = 24;
		setValueChk(odsBean, column + 0, line + 0, dto.getKName()); // 
		setValueChk(odsBean, column + 0, line + 73, dto.getKName()); // 
		setValueChk(odsBean, 2, line + 133, dto.getKName()); // 
		
		/** ^ڏo **/
		// ږo
		line = 8;
		column = 0;
		setValueChk(odsBean, column + 0, line + 0, dto.getTitleAllowanceItem()); // xږ^Cg
		setValueChk(odsBean, column + 0, line + 1, dto.getTitlePayAllowance01()); // ^x01^Cg
		setValueChk(odsBean, column + 0, line + 2, dto.getTitlePayAllowance02()); // ^x02^Cg
		setValueChk(odsBean, column + 0, line + 3, dto.getTitlePayAllowance03()); // ^x03^Cg
		setValueChk(odsBean, column + 0, line + 4, dto.getTitlePayAllowance04()); // ^x04^Cg
		setValueChk(odsBean, column + 0, line + 5, dto.getTitlePayAllowance05()); // ^x05^Cg
		setValueChk(odsBean, column + 0, line + 6, dto.getTitlePayAllowance06()); // ^x06^Cg
		setValueChk(odsBean, column + 0, line + 7, dto.getTitlePayAllowance07()); // ^x07^Cg
		setValueChk(odsBean, column + 0, line + 8, dto.getTitlePayAllowance08()); // ^x08^Cg
		setValueChk(odsBean, column + 0, line + 9, dto.getTitlePayAllowance09()); // ^x09^Cg
		setValueChk(odsBean, column + 0, line + 10, dto.getTitlePayAllowance10()); // ^x10^Cg
		setValueChk(odsBean, column + 0, line + 11, dto.getTitlePayAllowance11()); // ^x11^Cg
		setValueChk(odsBean, column + 0, line + 12, dto.getTitlePayAllowance12()); // ^x12^Cg
		setValueChk(odsBean, column + 0, line + 13, dto.getTitlePayAllowance13()); // ^x13^Cg
		setValueChk(odsBean, column + 0, line + 14, dto.getTitlePayAllowance14()); // ^x14^Cg
		setValueChk(odsBean, column + 0, line + 15, dto.getTitlePayAllowance15()); // ^x15^Cg
		setValueChk(odsBean, column + 0, line + 16, dto.getTitlePayAllowance16()); // ^x16^Cg
		setValueChk(odsBean, column + 0, line + 17, dto.getTitlePayAllowance17()); // ^x17^Cg
		setValueChk(odsBean, column + 0, line + 18, dto.getTitlePayAllowance18()); // ^x18^Cg
		setValueChk(odsBean, column + 0, line + 19, dto.getTitlePayAllowance19()); // ^x19^Cg
		setValueChk(odsBean, column + 0, line + 20, dto.getTitlePayAllowance20()); // ^x20^Cg
		setValueChk(odsBean, column + 0, line + 21, dto.getTitlePayAllowance21()); // ^x21^Cg
		setValueChk(odsBean, column + 0, line + 22, dto.getTitlePayAllowance22()); // ^x22^Cg
		setValueChk(odsBean, column + 0, line + 23, dto.getTitlePayAllowance23()); // ^x23^Cg
		setValueChk(odsBean, column + 0, line + 24, dto.getTitlePayAllowance24()); // ^x24^Cg
		setValueChk(odsBean, column + 0, line + 25, dto.getTitlePayAllowance25()); // ^x25^Cg
		setValueChk(odsBean, column + 0, line + 26, dto.getTitlePayAllowance26()); // ^x26^Cg
		setValueChk(odsBean, column + 0, line + 27, dto.getTitlePayAllowance27()); // ^x27^Cg
		setValueChk(odsBean, column + 0, line + 28, dto.getTitlePayAllowance28()); // ^x28^Cg
		setValueChk(odsBean, column + 0, line + 29, dto.getTitlePayAllowance29()); // ^x29^Cg
		setValueChk(odsBean, column + 0, line + 30, dto.getTitlePayAllowance30()); // ^x30^Cg
		setValueChk(odsBean, column + 0, line + 31, dto.getTitleAllowanceTotal()); // xz^Cg		
		
		line = 40;
		setValueChk(odsBean, column + 0, line + 0, "" + dto.getTitleDeductionItem() + ""); // Tڃ^Cg  
		setValueChk(odsBean, column + 0, line + 1, dto.getTitlePayDeduction01()); // ^T01^Cg
		setValueChk(odsBean, column + 0, line + 2, dto.getTitlePayDeduction02()); // ^T02^Cg
		setValueChk(odsBean, column + 0, line + 3, dto.getTitlePayDeduction03()); // ^T03^Cg
		setValueChk(odsBean, column + 0, line + 4, dto.getTitlePayDeduction04()); // ^T04^Cg
		setValueChk(odsBean, column + 0, line + 5, dto.getTitlePayDeduction05()); // ^T05^Cg
		setValueChk(odsBean, column + 0, line + 6, dto.getTitlePayDeduction06()); // ^T06^Cg
		setValueChk(odsBean, column + 0, line + 7, dto.getTitlePayDeduction07()); // ^T07^Cg
		setValueChk(odsBean, column + 0, line + 8, dto.getTitlePayDeduction08()); // ^T08^Cg
		setValueChk(odsBean, column + 0, line + 9, dto.getTitlePayDeduction09()); // ^T09^Cg
		setValueChk(odsBean, column + 0, line + 10, dto.getTitlePayDeduction10()); // ^T10^Cg
		setValueChk(odsBean, column + 0, line + 11, dto.getTitlePayDeduction11()); // ^T11^Cg
		setValueChk(odsBean, column + 0, line + 12, dto.getTitlePayDeduction12()); // ^T12^Cg
		setValueChk(odsBean, column + 0, line + 13, dto.getTitlePayDeduction14()); // ^T14^Cg
		setValueChk(odsBean, column + 0, line + 14, dto.getTitlePayDeduction15()); // ^T15^Cg
		setValueChk(odsBean, column + 0, line + 15, dto.getTitlePayDeduction16()); // ^T16^Cg
		setValueChk(odsBean, column + 0, line + 16, dto.getTitlePayDeduction17()); // ^T17^Cg
		setValueChk(odsBean, column + 0, line + 17, dto.getTitlePayDeduction18()); // ^T18^Cg
		setValueChk(odsBean, column + 0, line + 18, dto.getTitlePayDeduction19()); // ^T19^Cg
		setValueChk(odsBean, column + 0, line + 19, dto.getTitlePayDeduction20()); // ^T20^Cg
		setValueChk(odsBean, column + 0, line + 20, dto.getTitlePayDeduction21()); // ^T21^Cg
		setValueChk(odsBean, column + 0, line + 21, dto.getTitlePayDeduction22()); // ^T22^Cg
		setValueChk(odsBean, column + 0, line + 22, dto.getTitlePayDeduction23()); // ^T23^Cg
		setValueChk(odsBean, column + 0, line + 23, dto.getTitlePayDeduction24()); // ^T24^Cg
		setValueChk(odsBean, column + 0, line + 24, dto.getTitlePayDeduction25()); // ^T25^Cg
		setValueChk(odsBean, column + 0, line + 25, dto.getTitleDeductionTotal()); // Tz^Cg
		setValueChk(odsBean, column + 0, line + 26, dto.getTitlePayDeduction26()); // ^T26^Cg
		setValueChk(odsBean, column + 0, line + 27, dto.getTitlePaymentTotal()); // xz^Cg
		setValueChk(odsBean, column + 0, line + 28, dto.getTitleBank1PayAmount()); // s1Uz
		setValueChk(odsBean, column + 0, line + 29, dto.getTitleBank2PayAmount()); // s2Uz
		setValueChk(odsBean, column + 0, line + 30, dto.getTitleCashPayAmount()); // xz
		setValueChk(odsBean, column + 0, line + 31, dto.getTitlePayDeduction27()); // ^T27^Cg
		
		// ^׏o
		line = 8;
		column = 3; // 1
		if (null != dto.getPayPayday01()) {
			setValueChk(odsBean, column, line - 1, dto.getPayPayday01()); // ^xNo01
		}
		if (null != dto.getPayAllowance01No01()) {
			setValueChk(odsBean, column, line + 1, dto.getPayAllowance01No01()); // ^x01No01
		}
		if (null != dto.getPayAllowance01No02()) {
			setValueChk(odsBean, column, line + 2, dto.getPayAllowance02No01()); // ^x02No01
		}
		if (null != dto.getPayAllowance03No01()) {
			setValueChk(odsBean, column, line + 3, dto.getPayAllowance03No01()); // ^x03No01
		}
		if (null != dto.getPayAllowance04No01()) {
			setValueChk(odsBean, column, line + 4, dto.getPayAllowance04No01()); // ^x04No01
		}
		if (null != dto.getPayAllowance05No01()) {
			setValueChk(odsBean, column, line + 5, dto.getPayAllowance05No01()); // ^x05No01
		}
		if (null != dto.getPayAllowance06No01()) {
			setValueChk(odsBean, column, line + 6, dto.getPayAllowance06No01()); // ^x06No01
		}
		if (null != dto.getPayAllowance07No01()) {
			setValueChk(odsBean, column, line + 7, dto.getPayAllowance07No01()); // ^x07No01
		}
		if (null != dto.getPayAllowance08No01()) {
			setValueChk(odsBean, column, line + 8, dto.getPayAllowance08No01()); // ^x08No01
		}
		if (null != dto.getPayAllowance09No01()) {
			setValueChk(odsBean, column, line + 9, dto.getPayAllowance09No01()); // ^x09No01
		}
		if (null != dto.getPayAllowance10No01()) {
			setValueChk(odsBean, column, line + 10, dto.getPayAllowance10No01()); // ^x10No01
		}
		if (null != dto.getPayAllowance11No01()) {
			setValueChk(odsBean, column, line + 11, dto.getPayAllowance11No01()); // ^x11No01
		}
		if (null != dto.getPayAllowance12No01()) {
			setValueChk(odsBean, column, line + 12, dto.getPayAllowance12No01()); // ^x12No01
		}
		if (null != dto.getPayAllowance13No01()) {
			setValueChk(odsBean, column, line + 13, dto.getPayAllowance13No01()); // ^x13No01
		}
		if (null != dto.getPayAllowance14No01()) {
			setValueChk(odsBean, column, line + 14, dto.getPayAllowance14No01()); // ^x14No01
		}
		if (null != dto.getPayAllowance15No01()) {
			setValueChk(odsBean, column, line + 15, dto.getPayAllowance15No01()); // ^x15No01
		}
		if (null != dto.getPayAllowance16No01()) {
			setValueChk(odsBean, column, line + 16, dto.getPayAllowance16No01()); // ^x16No01
		}
		if (null != dto.getPayAllowance17No01()) {
			setValueChk(odsBean, column, line + 17, dto.getPayAllowance17No01()); // ^x17No01
		}
		if (null != dto.getPayAllowance18No01()) {
			setValueChk(odsBean, column, line + 18, dto.getPayAllowance18No01()); // ^x18No01
		}
		if (null != dto.getPayAllowance19No01()) {
			setValueChk(odsBean, column, line + 19, dto.getPayAllowance19No01()); // ^x19No01
		}
		if (null != dto.getPayAllowance20No01()) {
			setValueChk(odsBean, column, line + 20, dto.getPayAllowance20No01()); // ^x20No01
		}
		if (null != dto.getPayAllowance21No01()) {
			setValueChk(odsBean, column, line + 21, dto.getPayAllowance21No01()); // ^x21No01
		}
		if (null != dto.getPayAllowance22No01()) {
			setValueChk(odsBean, column, line + 22, dto.getPayAllowance22No01()); // ^x22No01
		}
		if (null != dto.getPayAllowance23No01()) {
			setValueChk(odsBean, column, line + 23, dto.getPayAllowance23No01()); // ^x23No01
		}
		if (null != dto.getPayAllowance24No01()) {
			setValueChk(odsBean, column, line + 24, dto.getPayAllowance24No01()); // ^x24No01
		}
		if (null != dto.getPayAllowance25No01()) {
			setValueChk(odsBean, column, line + 25, dto.getPayAllowance25No01()); // ^x25No01
		}
		if (null != dto.getPayAllowance26No01()) {
			setValueChk(odsBean, column, line + 26, dto.getPayAllowance26No01()); // ^x26No01
		}
		if (null != dto.getPayAllowance27No01()) {
			setValueChk(odsBean, column, line + 27, dto.getPayAllowance27No01()); // ^x27No01
		}
		if (null != dto.getPayAllowance28No01()) {
			setValueChk(odsBean, column, line + 28, dto.getPayAllowance28No01()); // ^x28No01
		}
		if (null != dto.getPayAllowance29No01()) {
			setValueChk(odsBean, column, line + 29, dto.getPayAllowance29No01()); // ^x29No01
		}
		if (null != dto.getPayAllowance30No01()) {
			setValueChk(odsBean, column, line + 30, dto.getPayAllowance30No01()); // ^x30No01
		}
		if (null != dto.getPayAllowanceTotal01()) {
			setValueChk(odsBean, column, line + 31, dto.getPayAllowanceTotal01()); // ^xzNo01
		}
		line = 40;
		if (null != dto.getPayDeduction01No01()) {
			setValueChk(odsBean, column, line + 1, dto.getPayDeduction01No01()); // ^T01No01
		}
		if (null != dto.getPayDeduction02No01()) {
			setValueChk(odsBean, column, line + 2, dto.getPayDeduction02No01()); // ^T02No01
		}
		if (null != dto.getPayDeduction03No01()) {
			setValueChk(odsBean, column, line + 3, dto.getPayDeduction03No01()); // ^T03No01
		}
		if (null != dto.getPayDeduction04No01()) {
			setValueChk(odsBean, column, line + 4, dto.getPayDeduction04No01()); // ^T04No01
		}
		if (null != dto.getPayDeduction05No01()) {
			setValueChk(odsBean, column, line + 5, dto.getPayDeduction05No01()); // ^T05No01
		}
		if (null != dto.getPayDeduction06No01()) {
			setValueChk(odsBean, column, line + 6, dto.getPayDeduction06No01()); // ^T06No01
		}
		if (null != dto.getPayDeduction07No01()) {
			setValueChk(odsBean, column, line + 7, dto.getPayDeduction07No01()); // ^T07No01
		}
		if (null != dto.getPayDeduction08No01()) {
			setValueChk(odsBean, column, line + 8, dto.getPayDeduction08No01()); // ^T08No01
		}
		if (null != dto.getPayDeduction09No01()) {
			setValueChk(odsBean, column, line + 9, dto.getPayDeduction09No01()); // ^T09No01
		}
		if (null != dto.getPayDeduction10No01()) {
			setValueChk(odsBean, column, line + 10, dto.getPayDeduction10No01()); // ^T10No01
		}
		if (null != dto.getPayDeduction11No01()) {
			setValueChk(odsBean, column, line + 11, dto.getPayDeduction11No01()); // ^T11No01
		}
		if (null != dto.getPayDeduction12No01()) {
			setValueChk(odsBean, column, line + 12, dto.getPayDeduction12No01()); // ^T12No01
		}
		if (null != dto.getPayDeduction14No01()) {
			setValueChk(odsBean, column, line + 13, dto.getPayDeduction14No01()); // ^T14No01
		}
		if (null != dto.getPayDeduction15No01()) {
			setValueChk(odsBean, column, line + 14, dto.getPayDeduction15No01()); // ^T15No01
		}
		if (null != dto.getPayDeduction16No01()) {
			setValueChk(odsBean, column, line + 15, dto.getPayDeduction16No01()); // ^T16No01
		}
		if (null != dto.getPayDeduction17No01()) {
			setValueChk(odsBean, column, line + 16, dto.getPayDeduction17No01()); // ^T17No01
		}
		if (null != dto.getPayDeduction18No01()) {
			setValueChk(odsBean, column, line + 17, dto.getPayDeduction18No01()); // ^T18No01
		}
		if (null != dto.getPayDeduction19No01()) {
			setValueChk(odsBean, column, line + 18, dto.getPayDeduction19No01()); // ^T19No01
		}
		if (null != dto.getPayDeduction20No01()) {
			setValueChk(odsBean, column, line + 19, dto.getPayDeduction20No01()); // ^T20No01
		}
		if (null != dto.getPayDeduction21No01()) {
			setValueChk(odsBean, column, line + 20, dto.getPayDeduction21No01()); // ^T21No01
		}
		if (null != dto.getPayDeduction22No01()) {
			setValueChk(odsBean, column, line + 21, dto.getPayDeduction22No01()); // ^T22No01
		}
		if (null != dto.getPayDeduction23No01()) {
			setValueChk(odsBean, column, line + 22, dto.getPayDeduction23No01()); // ^T23No01
		}
		if (null != dto.getPayDeduction24No01()) {
			setValueChk(odsBean, column, line + 23, dto.getPayDeduction24No01()); // ^T24No01
		}
		if (null != dto.getPayDeduction25No01()) {
			setValueChk(odsBean, column, line + 24, dto.getPayDeduction25No01()); // ^T25No01
		}
		if (null != dto.getPayDeductionTotal01()) {
			setValueChk(odsBean, column, line + 25, dto.getPayDeductionTotal01()); // ^TzNo01
		}
		if (null != dto.getPayDeduction26No01()) {
			setValueChk(odsBean, column, line + 26, dto.getPayDeduction26No01()); // ^T26No01
		}
		if (null != dto.getPayPaymentTotal01()) {
			setValueChk(odsBean, column, line + 27, dto.getPayPaymentTotal01()); // ^xzNo01
		}
		if (null != dto.getPayBank1PayAmount01()) {
			setValueChk(odsBean, column, line + 28, dto.getPayBank1PayAmount01()); // ^s1UzNo01
		}
		if (null != dto.getPayBank2PayAmount01()) {
			setValueChk(odsBean, column, line + 29, dto.getPayBank2PayAmount01()); // ^s2UzNo01
		}
		if (null != dto.getPayCashPayAmount01()) {
			setValueChk(odsBean, column, line + 30, dto.getPayCashPayAmount01()); // xzNo01
		}
		if (null != dto.getPayDeduction27No01()) {
			setValueChk(odsBean, column, line + 31, dto.getPayDeduction27No01()); // ^T27No01
		}
		
		line = 8;
		column = 6; // 2
		if (null != dto.getPayPayday02()) {
			setValueChk(odsBean, column, line - 1, dto.getPayPayday02()); // ^xNo02
		}
		if (null != dto.getPayAllowance01No02()) {
			setValueChk(odsBean, column, line + 1, dto.getPayAllowance01No02()); // ^x01No02
		}
		if (null != dto.getPayAllowance02No02()) {
			setValueChk(odsBean, column, line + 2, dto.getPayAllowance02No02()); // ^x02No02
		}
		if (null != dto.getPayAllowance03No02()) {
			setValueChk(odsBean, column, line + 3, dto.getPayAllowance03No02()); // ^x03No02
		}
		if (null != dto.getPayAllowance04No02()) {
			setValueChk(odsBean, column, line + 4, dto.getPayAllowance04No02()); // ^x04No02
		}
		if (null != dto.getPayAllowance05No02()) {
			setValueChk(odsBean, column, line + 5, dto.getPayAllowance05No02()); // ^x05No02
		}
		if (null != dto.getPayAllowance06No02()) {
			setValueChk(odsBean, column, line + 6, dto.getPayAllowance06No02()); // ^x06No02
		}
		if (null != dto.getPayAllowance07No02()) {
			setValueChk(odsBean, column, line + 7, dto.getPayAllowance07No02()); // ^x07No02
		}
		if (null != dto.getPayAllowance08No02()) {
			setValueChk(odsBean, column, line + 8, dto.getPayAllowance08No02()); // ^x08No02
		}
		if (null != dto.getPayAllowance09No02()) {
			setValueChk(odsBean, column, line + 9, dto.getPayAllowance09No02()); // ^x09No02
		}
		if (null != dto.getPayAllowance10No02()) {
			setValueChk(odsBean, column, line + 10, dto.getPayAllowance10No02()); // ^x10No02
		}
		if (null != dto.getPayAllowance11No02()) {
			setValueChk(odsBean, column, line + 11, dto.getPayAllowance11No02()); // ^x11No02
		}
		if (null != dto.getPayAllowance12No02()) {
			setValueChk(odsBean, column, line + 12, dto.getPayAllowance12No02()); // ^x12No02
		}
		if (null != dto.getPayAllowance13No02()) {
			setValueChk(odsBean, column, line + 13, dto.getPayAllowance13No02()); // ^x13No02
		}
		if (null != dto.getPayAllowance14No02()) {
			setValueChk(odsBean, column, line + 14, dto.getPayAllowance14No02()); // ^x14No02
		}
		if (null != dto.getPayAllowance15No02()) {
			setValueChk(odsBean, column, line + 15, dto.getPayAllowance15No02()); // ^x15No02
		}
		if (null != dto.getPayAllowance16No02()) {
			setValueChk(odsBean, column, line + 16, dto.getPayAllowance16No02()); // ^x16No02
		}
		if (null != dto.getPayAllowance17No02()) {
			setValueChk(odsBean, column, line + 17, dto.getPayAllowance17No02()); // ^x17No02
		}
		if (null != dto.getPayAllowance18No02()) {
			setValueChk(odsBean, column, line + 18, dto.getPayAllowance18No02()); // ^x18No02
		}
		if (null != dto.getPayAllowance19No02()) {
			setValueChk(odsBean, column, line + 19, dto.getPayAllowance19No02()); // ^x19No02
		}
		if (null != dto.getPayAllowance20No02()) {
			setValueChk(odsBean, column, line + 20, dto.getPayAllowance20No02()); // ^x20No02
		}
		if (null != dto.getPayAllowance21No02()) {
			setValueChk(odsBean, column, line + 21, dto.getPayAllowance21No02()); // ^x21No02
		}
		if (null != dto.getPayAllowance22No02()) {
			setValueChk(odsBean, column, line + 22, dto.getPayAllowance22No02()); // ^x22No02
		}
		if (null != dto.getPayAllowance23No02()) {
			setValueChk(odsBean, column, line + 23, dto.getPayAllowance23No02()); // ^x23No02
		}
		if (null != dto.getPayAllowance24No02()) {
			setValueChk(odsBean, column, line + 24, dto.getPayAllowance24No02()); // ^x24No02
		}
		if (null != dto.getPayAllowance25No02()) {
			setValueChk(odsBean, column, line + 25, dto.getPayAllowance25No02()); // ^x25No02
		}
		if (null != dto.getPayAllowance26No02()) {
			setValueChk(odsBean, column, line + 26, dto.getPayAllowance26No02()); // ^x26No02
		}
		if (null != dto.getPayAllowance27No02()) {
			setValueChk(odsBean, column, line + 27, dto.getPayAllowance27No02()); // ^x27No02
		}
		if (null != dto.getPayAllowance28No02()) {
			setValueChk(odsBean, column, line + 28, dto.getPayAllowance28No02()); // ^x28No02
		}
		if (null != dto.getPayAllowance29No02()) {
			setValueChk(odsBean, column, line + 29, dto.getPayAllowance29No02()); // ^x29No02
		}
		if (null != dto.getPayAllowance30No02()) {
			setValueChk(odsBean, column, line + 30, dto.getPayAllowance30No02()); // ^x30No02
		}
		if (null != dto.getPayAllowanceTotal02()) {
			setValueChk(odsBean, column, line + 31, dto.getPayAllowanceTotal02()); // ^xzNo02
		}
		line = 40;
		if (null != dto.getPayDeduction01No02()) {
			setValueChk(odsBean, column, line + 1, dto.getPayDeduction01No02()); // ^T01No02
		}
		if (null != dto.getPayDeduction02No02()) {
			setValueChk(odsBean, column, line + 2, dto.getPayDeduction02No02()); // ^T02No02
		}
		if (null != dto.getPayDeduction03No02()) {
			setValueChk(odsBean, column, line + 3, dto.getPayDeduction03No02()); // ^T03No02
		}
		if (null != dto.getPayDeduction04No02()) {
			setValueChk(odsBean, column, line + 4, dto.getPayDeduction04No02()); // ^T04No02
		}
		if (null != dto.getPayDeduction05No02()) {
			setValueChk(odsBean, column, line + 5, dto.getPayDeduction05No02()); // ^T05No02
		}
		if (null != dto.getPayDeduction06No02()) {
			setValueChk(odsBean, column, line + 6, dto.getPayDeduction06No02()); // ^T06No02
		}
		if (null != dto.getPayDeduction07No02()) {
			setValueChk(odsBean, column, line + 7, dto.getPayDeduction07No02()); // ^T07No02
		}
		if (null != dto.getPayDeduction08No02()) {
			setValueChk(odsBean, column, line + 8, dto.getPayDeduction08No02()); // ^T08No02
		}
		if (null != dto.getPayDeduction09No02()) {
			setValueChk(odsBean, column, line + 9, dto.getPayDeduction09No02()); // ^T09No02
		}
		if (null != dto.getPayDeduction10No02()) {
			setValueChk(odsBean, column, line + 10, dto.getPayDeduction10No02()); // ^T10No02
		}
		if (null != dto.getPayDeduction11No02()) {
			setValueChk(odsBean, column, line + 11, dto.getPayDeduction11No02()); // ^T11No02
		}
		if (null != dto.getPayDeduction12No02()) {
			setValueChk(odsBean, column, line + 12, dto.getPayDeduction12No02()); // ^T12No02
		}
		if (null != dto.getPayDeduction14No02()) {
			setValueChk(odsBean, column, line + 13, dto.getPayDeduction14No02()); // ^T14No02
		}
		if (null != dto.getPayDeduction15No02()) {
			setValueChk(odsBean, column, line + 14, dto.getPayDeduction15No02()); // ^T15No02
		}
		if (null != dto.getPayDeduction16No02()) {
			setValueChk(odsBean, column, line + 15, dto.getPayDeduction16No02()); // ^T16No02
		}
		if (null != dto.getPayDeduction17No02()) {
			setValueChk(odsBean, column, line + 16, dto.getPayDeduction17No02()); // ^T17No02
		}
		if (null != dto.getPayDeduction18No02()) {
			setValueChk(odsBean, column, line + 17, dto.getPayDeduction18No02()); // ^T18No02
		}
		if (null != dto.getPayDeduction19No02()) {
			setValueChk(odsBean, column, line + 18, dto.getPayDeduction19No02()); // ^T19No02
		}
		if (null != dto.getPayDeduction20No02()) {
			setValueChk(odsBean, column, line + 19, dto.getPayDeduction20No02()); // ^T20No02
		}
		if (null != dto.getPayDeduction21No02()) {
			setValueChk(odsBean, column, line + 20, dto.getPayDeduction21No02()); // ^T21No02
		}
		if (null != dto.getPayDeduction22No02()) {
			setValueChk(odsBean, column, line + 21, dto.getPayDeduction22No02()); // ^T22No02
		}
		if (null != dto.getPayDeduction23No02()) {
			setValueChk(odsBean, column, line + 22, dto.getPayDeduction23No02()); // ^T23No02
		}
		if (null != dto.getPayDeduction24No02()) {
			setValueChk(odsBean, column, line + 23, dto.getPayDeduction24No02()); // ^T24No02
		}
		if (null != dto.getPayDeduction25No02()) {
			setValueChk(odsBean, column, line + 24, dto.getPayDeduction25No02()); // ^T25No02
		}
		if (null != dto.getPayDeductionTotal02()) {
			setValueChk(odsBean, column, line + 25, dto.getPayDeductionTotal02()); // ^TzNo02
		}
		if (null != dto.getPayDeduction26No02()) {
			setValueChk(odsBean, column, line + 26, dto.getPayDeduction26No02()); // ^T26No02
		}
		if (null != dto.getPayPaymentTotal02()) {
			setValueChk(odsBean, column, line + 27, dto.getPayPaymentTotal02()); // ^xzNo02
		}
		if (null != dto.getPayBank1PayAmount02()) {
			setValueChk(odsBean, column, line + 28, dto.getPayBank1PayAmount02()); // ^s1UzNo02
		}
		if (null != dto.getPayBank2PayAmount02()) {
			setValueChk(odsBean, column, line + 29, dto.getPayBank2PayAmount02()); // ^s2UzNo02
		}
		if (null != dto.getPayCashPayAmount02()) {
			setValueChk(odsBean, column, line + 30, dto.getPayCashPayAmount02()); // xzNo02
		}
		if (null != dto.getPayDeduction27No02()) {
			setValueChk(odsBean, column, line + 31, dto.getPayDeduction27No02()); // ^T27No02
		}
		
		line = 8;
		column = 9; // 3
		if (null != dto.getPayPayday03()) {
			setValueChk(odsBean, column, line - 1, dto.getPayPayday03()); // ^xNo03
		}
		if (null != dto.getPayAllowance01No03()) {
			setValueChk(odsBean, column, line + 1, dto.getPayAllowance01No03()); // ^x01No03
		}
		if (null != dto.getPayAllowance02No03()) {
			setValueChk(odsBean, column, line + 2, dto.getPayAllowance02No03()); // ^x02No03
		}
		if (null != dto.getPayAllowance03No03()) {
			setValueChk(odsBean, column, line + 3, dto.getPayAllowance03No03()); // ^x03No03
		}
		if (null != dto.getPayAllowance04No03()) {
			setValueChk(odsBean, column, line + 4, dto.getPayAllowance04No03()); // ^x04No03
		}
		if (null != dto.getPayAllowance05No03()) {
			setValueChk(odsBean, column, line + 5, dto.getPayAllowance05No03()); // ^x05No03
		}
		if (null != dto.getPayAllowance06No03()) {
			setValueChk(odsBean, column, line + 6, dto.getPayAllowance06No03()); // ^x06No03
		}
		if (null != dto.getPayAllowance07No03()) {
			setValueChk(odsBean, column, line + 7, dto.getPayAllowance07No03()); // ^x07No03
		}
		if (null != dto.getPayAllowance08No03()) {
			setValueChk(odsBean, column, line + 8, dto.getPayAllowance08No03()); // ^x08No03
		}
		if (null != dto.getPayAllowance09No03()) {
			setValueChk(odsBean, column, line + 9, dto.getPayAllowance09No03()); // ^x09No03
		}
		if (null != dto.getPayAllowance10No03()) {
			setValueChk(odsBean, column, line + 10, dto.getPayAllowance10No03()); // ^x10No03
		}
		if (null != dto.getPayAllowance11No03()) {
			setValueChk(odsBean, column, line + 11, dto.getPayAllowance11No03()); // ^x11No03
		}
		if (null != dto.getPayAllowance12No03()) {
			setValueChk(odsBean, column, line + 12, dto.getPayAllowance12No03()); // ^x12No03
		}
		if (null != dto.getPayAllowance13No03()) {
			setValueChk(odsBean, column, line + 13, dto.getPayAllowance13No03()); // ^x13No03
		}
		if (null != dto.getPayAllowance14No03()) {
			setValueChk(odsBean, column, line + 14, dto.getPayAllowance14No03()); // ^x14No03
		}
		if (null != dto.getPayAllowance15No03()) {
			setValueChk(odsBean, column, line + 15, dto.getPayAllowance15No03()); // ^x15No03
		}
		if (null != dto.getPayAllowance16No03()) {
			setValueChk(odsBean, column, line + 16, dto.getPayAllowance16No03()); // ^x16No03
		}
		if (null != dto.getPayAllowance17No03()) {
			setValueChk(odsBean, column, line + 17, dto.getPayAllowance17No03()); // ^x17No03
		}
		if (null != dto.getPayAllowance18No03()) {
			setValueChk(odsBean, column, line + 18, dto.getPayAllowance18No03()); // ^x18No03
		}
		if (null != dto.getPayAllowance19No03()) {
			setValueChk(odsBean, column, line + 19, dto.getPayAllowance19No03()); // ^x19No03
		}
		if (null != dto.getPayAllowance20No03()) {
			setValueChk(odsBean, column, line + 20, dto.getPayAllowance20No03()); // ^x20No03
		}
		if (null != dto.getPayAllowance21No03()) {
			setValueChk(odsBean, column, line + 21, dto.getPayAllowance21No03()); // ^x21No03
		}
		if (null != dto.getPayAllowance22No03()) {
			setValueChk(odsBean, column, line + 22, dto.getPayAllowance22No03()); // ^x22No03
		}
		if (null != dto.getPayAllowance23No03()) {
			setValueChk(odsBean, column, line + 23, dto.getPayAllowance23No03()); // ^x23No03
		}
		if (null != dto.getPayAllowance24No03()) {
			setValueChk(odsBean, column, line + 24, dto.getPayAllowance24No03()); // ^x24No03
		}
		if (null != dto.getPayAllowance25No03()) {
			setValueChk(odsBean, column, line + 25, dto.getPayAllowance25No03()); // ^x25No03
		}
		if (null != dto.getPayAllowance26No03()) {
			setValueChk(odsBean, column, line + 26, dto.getPayAllowance26No03()); // ^x26No03
		}
		if (null != dto.getPayAllowance27No03()) {
			setValueChk(odsBean, column, line + 27, dto.getPayAllowance27No03()); // ^x27No03
		}
		if (null != dto.getPayAllowance28No03()) {
			setValueChk(odsBean, column, line + 28, dto.getPayAllowance28No03()); // ^x28No03
		}
		if (null != dto.getPayAllowance29No03()) {
			setValueChk(odsBean, column, line + 29, dto.getPayAllowance29No03()); // ^x29No03
		}
		if (null != dto.getPayAllowance30No03()) {
			setValueChk(odsBean, column, line + 30, dto.getPayAllowance30No03()); // ^x30No03
		}
		if (null != dto.getPayAllowanceTotal03()) {
			setValueChk(odsBean, column, line + 31, dto.getPayAllowanceTotal03()); // ^xzNo03
		}
		line = 40;
		if (null != dto.getPayDeduction01No03()) {
			setValueChk(odsBean, column, line + 1, dto.getPayDeduction01No03()); // ^T01No03
		}
		if (null != dto.getPayDeduction02No03()) {
			setValueChk(odsBean, column, line + 2, dto.getPayDeduction02No03()); // ^T02No03
		}
		if (null != dto.getPayDeduction03No03()) {
			setValueChk(odsBean, column, line + 3, dto.getPayDeduction03No03()); // ^T03No03
		}
		if (null != dto.getPayDeduction04No03()) {
			setValueChk(odsBean, column, line + 4, dto.getPayDeduction04No03()); // ^T04No03
		}
		if (null != dto.getPayDeduction05No03()) {
			setValueChk(odsBean, column, line + 5, dto.getPayDeduction05No03()); // ^T05No03
		}
		if (null != dto.getPayDeduction06No03()) {
			setValueChk(odsBean, column, line + 6, dto.getPayDeduction06No03()); // ^T06No03
		}
		if (null != dto.getPayDeduction07No03()) {
			setValueChk(odsBean, column, line + 7, dto.getPayDeduction07No03()); // ^T07No03
		}
		if (null != dto.getPayDeduction08No03()) {
			setValueChk(odsBean, column, line + 8, dto.getPayDeduction08No03()); // ^T08No03
		}
		if (null != dto.getPayDeduction09No03()) {
			setValueChk(odsBean, column, line + 9, dto.getPayDeduction09No03()); // ^T09No03
		}
		if (null != dto.getPayDeduction10No03()) {
			setValueChk(odsBean, column, line + 10, dto.getPayDeduction10No03()); // ^T10No03
		}
		if (null != dto.getPayDeduction11No03()) {
			setValueChk(odsBean, column, line + 11, dto.getPayDeduction11No03()); // ^T11No03
		}
		if (null != dto.getPayDeduction12No03()) {
			setValueChk(odsBean, column, line + 12, dto.getPayDeduction12No03()); // ^T12No03
		}
		if (null != dto.getPayDeduction14No03()) {
			setValueChk(odsBean, column, line + 13, dto.getPayDeduction14No03()); // ^T14No03
		}
		if (null != dto.getPayDeduction15No03()) {
			setValueChk(odsBean, column, line + 14, dto.getPayDeduction15No03()); // ^T15No03
		}
		if (null != dto.getPayDeduction16No03()) {
			setValueChk(odsBean, column, line + 15, dto.getPayDeduction16No03()); // ^T16No03
		}
		if (null != dto.getPayDeduction17No03()) {
			setValueChk(odsBean, column, line + 16, dto.getPayDeduction17No03()); // ^T17No03
		}
		if (null != dto.getPayDeduction18No03()) {
			setValueChk(odsBean, column, line + 17, dto.getPayDeduction18No03()); // ^T18No03
		}
		if (null != dto.getPayDeduction19No03()) {
			setValueChk(odsBean, column, line + 18, dto.getPayDeduction19No03()); // ^T19No03
		}
		if (null != dto.getPayDeduction20No03()) {
			setValueChk(odsBean, column, line + 19, dto.getPayDeduction20No03()); // ^T20No03
		}
		if (null != dto.getPayDeduction21No03()) {
			setValueChk(odsBean, column, line + 20, dto.getPayDeduction21No03()); // ^T21No03
		}
		if (null != dto.getPayDeduction22No03()) {
			setValueChk(odsBean, column, line + 21, dto.getPayDeduction22No03()); // ^T22No03
		}
		if (null != dto.getPayDeduction23No03()) {
			setValueChk(odsBean, column, line + 22, dto.getPayDeduction23No03()); // ^T23No03
		}
		if (null != dto.getPayDeduction24No03()) {
			setValueChk(odsBean, column, line + 23, dto.getPayDeduction24No03()); // ^T24No03
		}
		if (null != dto.getPayDeduction25No03()) {
			setValueChk(odsBean, column, line + 24, dto.getPayDeduction25No03()); // ^T25No03
		}
		if (null != dto.getPayDeductionTotal03()) {
			setValueChk(odsBean, column, line + 25, dto.getPayDeductionTotal03()); // ^TzNo03
		}
		if (null != dto.getPayDeduction26No03()) {
			setValueChk(odsBean, column, line + 26, dto.getPayDeduction26No03()); // ^T26No03
		}
		if (null != dto.getPayPaymentTotal03()) {
			setValueChk(odsBean, column, line + 27, dto.getPayPaymentTotal03()); // ^xzNo03
		}
		if (null != dto.getPayBank1PayAmount03()) {
			setValueChk(odsBean, column, line + 28, dto.getPayBank1PayAmount03()); // ^s1UzNo03
		}
		if (null != dto.getPayBank2PayAmount03()) {
			setValueChk(odsBean, column, line + 29, dto.getPayBank2PayAmount03()); // ^s2UzNo03
		}
		if (null != dto.getPayCashPayAmount03()) {
			setValueChk(odsBean, column, line + 30, dto.getPayCashPayAmount03()); // xzNo03
		}
		if (null != dto.getPayDeduction27No03()) {
			setValueChk(odsBean, column, line + 31, dto.getPayDeduction27No03()); // ^T27No03
		}
		
		line = 8;
		column = 12; // 4
		if (null != dto.getPayPayday04()) {
			setValueChk(odsBean, column, line - 1, dto.getPayPayday04()); // ^xNo04
		}
		if (null != dto.getPayAllowance01No04()) {
			setValueChk(odsBean, column, line + 1, dto.getPayAllowance01No04()); // ^x01No04
		}
		if (null != dto.getPayAllowance02No04()) {
			setValueChk(odsBean, column, line + 2, dto.getPayAllowance02No04()); // ^x02No04
		}
		if (null != dto.getPayAllowance03No04()) {
			setValueChk(odsBean, column, line + 3, dto.getPayAllowance03No04()); // ^x03No04
		}
		if (null != dto.getPayAllowance04No04()) {
			setValueChk(odsBean, column, line + 4, dto.getPayAllowance04No04()); // ^x04No04
		}
		if (null != dto.getPayAllowance05No04()) {
			setValueChk(odsBean, column, line + 5, dto.getPayAllowance05No04()); // ^x05No04
		}
		if (null != dto.getPayAllowance06No04()) {
			setValueChk(odsBean, column, line + 6, dto.getPayAllowance06No04()); // ^x06No04
		}
		if (null != dto.getPayAllowance07No04()) {
			setValueChk(odsBean, column, line + 7, dto.getPayAllowance07No04()); // ^x07No04
		}
		if (null != dto.getPayAllowance08No04()) {
			setValueChk(odsBean, column, line + 8, dto.getPayAllowance08No04()); // ^x08No04
		}
		if (null != dto.getPayAllowance09No04()) {
			setValueChk(odsBean, column, line + 9, dto.getPayAllowance09No04()); // ^x09No04
		}
		if (null != dto.getPayAllowance10No04()) {
			setValueChk(odsBean, column, line + 10, dto.getPayAllowance10No04()); // ^x10No04
		}
		if (null != dto.getPayAllowance11No04()) {
			setValueChk(odsBean, column, line + 11, dto.getPayAllowance11No04()); // ^x11No04
		}
		if (null != dto.getPayAllowance12No04()) {
			setValueChk(odsBean, column, line + 12, dto.getPayAllowance12No04()); // ^x12No04
		}
		if (null != dto.getPayAllowance13No04()) {
			setValueChk(odsBean, column, line + 13, dto.getPayAllowance13No04()); // ^x13No04
		}
		if (null != dto.getPayAllowance14No04()) {
			setValueChk(odsBean, column, line + 14, dto.getPayAllowance14No04()); // ^x14No04
		}
		if (null != dto.getPayAllowance15No04()) {
			setValueChk(odsBean, column, line + 15, dto.getPayAllowance15No04()); // ^x15No04
		}
		if (null != dto.getPayAllowance16No04()) {
			setValueChk(odsBean, column, line + 16, dto.getPayAllowance16No04()); // ^x16No04
		}
		if (null != dto.getPayAllowance17No04()) {
			setValueChk(odsBean, column, line + 17, dto.getPayAllowance17No04()); // ^x17No04
		}
		if (null != dto.getPayAllowance18No04()) {
			setValueChk(odsBean, column, line + 18, dto.getPayAllowance18No04()); // ^x18No04
		}
		if (null != dto.getPayAllowance19No04()) {
			setValueChk(odsBean, column, line + 19, dto.getPayAllowance19No04()); // ^x19No04
		}
		if (null != dto.getPayAllowance20No04()) {
			setValueChk(odsBean, column, line + 20, dto.getPayAllowance20No04()); // ^x20No04
		}
		if (null != dto.getPayAllowance21No04()) {
			setValueChk(odsBean, column, line + 21, dto.getPayAllowance21No04()); // ^x21No04
		}
		if (null != dto.getPayAllowance22No04()) {
			setValueChk(odsBean, column, line + 22, dto.getPayAllowance22No04()); // ^x22No04
		}
		if (null != dto.getPayAllowance23No04()) {
			setValueChk(odsBean, column, line + 23, dto.getPayAllowance23No04()); // ^x23No04
		}
		if (null != dto.getPayAllowance24No04()) {
			setValueChk(odsBean, column, line + 24, dto.getPayAllowance24No04()); // ^x24No04
		}
		if (null != dto.getPayAllowance25No04()) {
			setValueChk(odsBean, column, line + 25, dto.getPayAllowance25No04()); // ^x25No04
		}
		if (null != dto.getPayAllowance26No04()) {
			setValueChk(odsBean, column, line + 26, dto.getPayAllowance26No04()); // ^x26No04
		}
		if (null != dto.getPayAllowance27No04()) {
			setValueChk(odsBean, column, line + 27, dto.getPayAllowance27No04()); // ^x27No04
		}
		if (null != dto.getPayAllowance28No04()) {
			setValueChk(odsBean, column, line + 28, dto.getPayAllowance28No04()); // ^x28No04
		}
		if (null != dto.getPayAllowance29No04()) {
			setValueChk(odsBean, column, line + 29, dto.getPayAllowance29No04()); // ^x29No04
		}
		if (null != dto.getPayAllowance30No04()) {
			setValueChk(odsBean, column, line + 30, dto.getPayAllowance30No04()); // ^x30No04
		}
		if (null != dto.getPayAllowanceTotal04()) {
			setValueChk(odsBean, column, line + 31, dto.getPayAllowanceTotal04()); // ^xzNo04
		}
		line = 40;
		if (null != dto.getPayDeduction01No04()) {
			setValueChk(odsBean, column, line + 1, dto.getPayDeduction01No04()); // ^T01No04
		}
		if (null != dto.getPayDeduction02No04()) {
			setValueChk(odsBean, column, line + 2, dto.getPayDeduction02No04()); // ^T02No04
		}
		if (null != dto.getPayDeduction03No04()) {
			setValueChk(odsBean, column, line + 3, dto.getPayDeduction03No04()); // ^T03No04
		}
		if (null != dto.getPayDeduction04No04()) {
			setValueChk(odsBean, column, line + 4, dto.getPayDeduction04No04()); // ^T04No04
		}
		if (null != dto.getPayDeduction05No04()) {
			setValueChk(odsBean, column, line + 5, dto.getPayDeduction05No04()); // ^T05No04
		}
		if (null != dto.getPayDeduction06No04()) {
			setValueChk(odsBean, column, line + 6, dto.getPayDeduction06No04()); // ^T06No04
		}
		if (null != dto.getPayDeduction07No04()) {
			setValueChk(odsBean, column, line + 7, dto.getPayDeduction07No04()); // ^T07No04
		}
		if (null != dto.getPayDeduction08No04()) {
			setValueChk(odsBean, column, line + 8, dto.getPayDeduction08No04()); // ^T08No04
		}
		if (null != dto.getPayDeduction09No04()) {
			setValueChk(odsBean, column, line + 9, dto.getPayDeduction09No04()); // ^T09No04
		}
		if (null != dto.getPayDeduction10No04()) {
			setValueChk(odsBean, column, line + 10, dto.getPayDeduction10No04()); // ^T10No04
		}
		if (null != dto.getPayDeduction11No04()) {
			setValueChk(odsBean, column, line + 11, dto.getPayDeduction11No04()); // ^T11No04
		}
		if (null != dto.getPayDeduction12No04()) {
			setValueChk(odsBean, column, line + 12, dto.getPayDeduction12No04()); // ^T12No04
		}
		if (null != dto.getPayDeduction14No04()) {
			setValueChk(odsBean, column, line + 13, dto.getPayDeduction14No04()); // ^T14No04
		}
		if (null != dto.getPayDeduction15No04()) {
			setValueChk(odsBean, column, line + 14, dto.getPayDeduction15No04()); // ^T15No04
		}
		if (null != dto.getPayDeduction16No04()) {
			setValueChk(odsBean, column, line + 15, dto.getPayDeduction16No04()); // ^T16No04
		}
		if (null != dto.getPayDeduction17No04()) {
			setValueChk(odsBean, column, line + 16, dto.getPayDeduction17No04()); // ^T17No04
		}
		if (null != dto.getPayDeduction18No04()) {
			setValueChk(odsBean, column, line + 17, dto.getPayDeduction18No04()); // ^T18No04
		}
		if (null != dto.getPayDeduction19No04()) {
			setValueChk(odsBean, column, line + 18, dto.getPayDeduction19No04()); // ^T19No04
		}
		if (null != dto.getPayDeduction20No04()) {
			setValueChk(odsBean, column, line + 19, dto.getPayDeduction20No04()); // ^T20No04
		}
		if (null != dto.getPayDeduction21No04()) {
			setValueChk(odsBean, column, line + 20, dto.getPayDeduction21No04()); // ^T21No04
		}
		if (null != dto.getPayDeduction22No04()) {
			setValueChk(odsBean, column, line + 21, dto.getPayDeduction22No04()); // ^T22No04
		}
		if (null != dto.getPayDeduction23No04()) {
			setValueChk(odsBean, column, line + 22, dto.getPayDeduction23No04()); // ^T23No04
		}
		if (null != dto.getPayDeduction24No04()) {
			setValueChk(odsBean, column, line + 23, dto.getPayDeduction24No04()); // ^T24No04
		}
		if (null != dto.getPayDeduction25No04()) {
			setValueChk(odsBean, column, line + 24, dto.getPayDeduction25No04()); // ^T25No04
		}
		if (null != dto.getPayDeductionTotal04()) {
			setValueChk(odsBean, column, line + 25, dto.getPayDeductionTotal04()); // ^TzNo04
		}
		if (null != dto.getPayDeduction26No04()) {
			setValueChk(odsBean, column, line + 26, dto.getPayDeduction26No04()); // ^T26No04
		}
		if (null != dto.getPayPaymentTotal04()) {
			setValueChk(odsBean, column, line + 27, dto.getPayPaymentTotal04()); // ^xzNo04
		}
		if (null != dto.getPayBank1PayAmount04()) {
			setValueChk(odsBean, column, line + 28, dto.getPayBank1PayAmount04()); // ^s1UzNo04
		}
		if (null != dto.getPayBank2PayAmount04()) {
			setValueChk(odsBean, column, line + 29, dto.getPayBank2PayAmount04()); // ^s2UzNo04
		}
		if (null != dto.getPayCashPayAmount04()) {
			setValueChk(odsBean, column, line + 30, dto.getPayCashPayAmount04()); // xzNo04
		}
		if (null != dto.getPayDeduction27No04()) {
			setValueChk(odsBean, column, line + 31, dto.getPayDeduction27No04()); // ^T27No04
		}
		
		line = 8;
		column = 15; // 5
		if (null != dto.getPayPayday05()) {
			setValueChk(odsBean, column, line - 1, dto.getPayPayday05()); // ^xNo05
		}
		if (null != dto.getPayAllowance01No05()) {
			setValueChk(odsBean, column, line + 1, dto.getPayAllowance01No05()); // ^x01No05
		}
		if (null != dto.getPayAllowance02No05()) {
			setValueChk(odsBean, column, line + 2, dto.getPayAllowance02No05()); // ^x02No05
		}
		if (null != dto.getPayAllowance03No05()) {
			setValueChk(odsBean, column, line + 3, dto.getPayAllowance03No05()); // ^x03No05
		}
		if (null != dto.getPayAllowance04No05()) {
			setValueChk(odsBean, column, line + 4, dto.getPayAllowance04No05()); // ^x04No05
		}
		if (null != dto.getPayAllowance05No05()) {
			setValueChk(odsBean, column, line + 5, dto.getPayAllowance05No05()); // ^x05No05
		}
		if (null != dto.getPayAllowance06No05()) {
			setValueChk(odsBean, column, line + 6, dto.getPayAllowance06No05()); // ^x06No05
		}
		if (null != dto.getPayAllowance07No05()) {
			setValueChk(odsBean, column, line + 7, dto.getPayAllowance07No05()); // ^x07No05
		}
		if (null != dto.getPayAllowance08No05()) {
			setValueChk(odsBean, column, line + 8, dto.getPayAllowance08No05()); // ^x08No05
		}
		if (null != dto.getPayAllowance09No05()) {
			setValueChk(odsBean, column, line + 9, dto.getPayAllowance09No05()); // ^x09No05
		}
		if (null != dto.getPayAllowance10No05()) {
			setValueChk(odsBean, column, line + 10, dto.getPayAllowance10No05()); // ^x10No05
		}
		if (null != dto.getPayAllowance11No05()) {
			setValueChk(odsBean, column, line + 11, dto.getPayAllowance11No05()); // ^x11No05
		}
		if (null != dto.getPayAllowance12No05()) {
			setValueChk(odsBean, column, line + 12, dto.getPayAllowance12No05()); // ^x12No05
		}
		if (null != dto.getPayAllowance13No05()) {
			setValueChk(odsBean, column, line + 13, dto.getPayAllowance13No05()); // ^x13No05
		}
		if (null != dto.getPayAllowance14No05()) {
			setValueChk(odsBean, column, line + 14, dto.getPayAllowance14No05()); // ^x14No05
		}
		if (null != dto.getPayAllowance15No05()) {
			setValueChk(odsBean, column, line + 15, dto.getPayAllowance15No05()); // ^x15No05
		}
		if (null != dto.getPayAllowance16No05()) {
			setValueChk(odsBean, column, line + 16, dto.getPayAllowance16No05()); // ^x16No05
		}
		if (null != dto.getPayAllowance17No05()) {
			setValueChk(odsBean, column, line + 17, dto.getPayAllowance17No05()); // ^x17No05
		}
		if (null != dto.getPayAllowance18No05()) {
			setValueChk(odsBean, column, line + 18, dto.getPayAllowance18No05()); // ^x18No05
		}
		if (null != dto.getPayAllowance19No05()) {
			setValueChk(odsBean, column, line + 19, dto.getPayAllowance19No05()); // ^x19No05
		}
		if (null != dto.getPayAllowance20No05()) {
			setValueChk(odsBean, column, line + 20, dto.getPayAllowance20No05()); // ^x20No05
		}
		if (null != dto.getPayAllowance21No05()) {
			setValueChk(odsBean, column, line + 21, dto.getPayAllowance21No05()); // ^x21No05
		}
		if (null != dto.getPayAllowance22No05()) {
			setValueChk(odsBean, column, line + 22, dto.getPayAllowance22No05()); // ^x22No05
		}
		if (null != dto.getPayAllowance23No05()) {
			setValueChk(odsBean, column, line + 23, dto.getPayAllowance23No05()); // ^x23No05
		}
		if (null != dto.getPayAllowance24No05()) {
			setValueChk(odsBean, column, line + 24, dto.getPayAllowance24No05()); // ^x24No05
		}
		if (null != dto.getPayAllowance25No05()) {
			setValueChk(odsBean, column, line + 25, dto.getPayAllowance25No05()); // ^x25No05
		}
		if (null != dto.getPayAllowance26No05()) {
			setValueChk(odsBean, column, line + 26, dto.getPayAllowance26No05()); // ^x26No05
		}
		if (null != dto.getPayAllowance27No05()) {
			setValueChk(odsBean, column, line + 27, dto.getPayAllowance27No05()); // ^x27No05
		}
		if (null != dto.getPayAllowance28No05()) {
			setValueChk(odsBean, column, line + 28, dto.getPayAllowance28No05()); // ^x28No05
		}
		if (null != dto.getPayAllowance29No05()) {
			setValueChk(odsBean, column, line + 29, dto.getPayAllowance29No05()); // ^x29No05
		}
		if (null != dto.getPayAllowance30No05()) {
			setValueChk(odsBean, column, line + 30, dto.getPayAllowance30No05()); // ^x30No05
		}
		if (null != dto.getPayAllowanceTotal05()) {
			setValueChk(odsBean, column, line + 31, dto.getPayAllowanceTotal05()); // ^xzNo05
		}
		line = 40;
		if (null != dto.getPayDeduction01No05()) {
			setValueChk(odsBean, column, line + 1, dto.getPayDeduction01No05()); // ^T01No05
		}
		if (null != dto.getPayDeduction02No05()) {
			setValueChk(odsBean, column, line + 2, dto.getPayDeduction02No05()); // ^T02No05
		}
		if (null != dto.getPayDeduction03No05()) {
			setValueChk(odsBean, column, line + 3, dto.getPayDeduction03No05()); // ^T03No05
		}
		if (null != dto.getPayDeduction04No05()) {
			setValueChk(odsBean, column, line + 4, dto.getPayDeduction04No05()); // ^T04No05
		}
		if (null != dto.getPayDeduction05No05()) {
			setValueChk(odsBean, column, line + 5, dto.getPayDeduction05No05()); // ^T05No05
		}
		if (null != dto.getPayDeduction06No05()) {
			setValueChk(odsBean, column, line + 6, dto.getPayDeduction06No05()); // ^T06No05
		}
		if (null != dto.getPayDeduction07No05()) {
			setValueChk(odsBean, column, line + 7, dto.getPayDeduction07No05()); // ^T07No05
		}
		if (null != dto.getPayDeduction08No05()) {
			setValueChk(odsBean, column, line + 8, dto.getPayDeduction08No05()); // ^T08No05
		}
		if (null != dto.getPayDeduction09No05()) {
			setValueChk(odsBean, column, line + 9, dto.getPayDeduction09No05()); // ^T09No05
		}
		if (null != dto.getPayDeduction10No05()) {
			setValueChk(odsBean, column, line + 10, dto.getPayDeduction10No05()); // ^T10No05
		}
		if (null != dto.getPayDeduction11No05()) {
			setValueChk(odsBean, column, line + 11, dto.getPayDeduction11No05()); // ^T11No05
		}
		if (null != dto.getPayDeduction12No05()) {
			setValueChk(odsBean, column, line + 12, dto.getPayDeduction12No05()); // ^T12No05
		}
		if (null != dto.getPayDeduction14No05()) {
			setValueChk(odsBean, column, line + 13, dto.getPayDeduction14No05()); // ^T14No05
		}
		if (null != dto.getPayDeduction15No05()) {
			setValueChk(odsBean, column, line + 14, dto.getPayDeduction15No05()); // ^T15No05
		}
		if (null != dto.getPayDeduction16No05()) {
			setValueChk(odsBean, column, line + 15, dto.getPayDeduction16No05()); // ^T16No05
		}
		if (null != dto.getPayDeduction17No05()) {
			setValueChk(odsBean, column, line + 16, dto.getPayDeduction17No05()); // ^T17No05
		}
		if (null != dto.getPayDeduction18No05()) {
			setValueChk(odsBean, column, line + 17, dto.getPayDeduction18No05()); // ^T18No05
		}
		if (null != dto.getPayDeduction19No05()) {
			setValueChk(odsBean, column, line + 18, dto.getPayDeduction19No05()); // ^T19No05
		}
		if (null != dto.getPayDeduction20No05()) {
			setValueChk(odsBean, column, line + 19, dto.getPayDeduction20No05()); // ^T20No05
		}
		if (null != dto.getPayDeduction21No05()) {
			setValueChk(odsBean, column, line + 20, dto.getPayDeduction21No05()); // ^T21No05
		}
		if (null != dto.getPayDeduction22No05()) {
			setValueChk(odsBean, column, line + 21, dto.getPayDeduction22No05()); // ^T22No05
		}
		if (null != dto.getPayDeduction23No05()) {
			setValueChk(odsBean, column, line + 22, dto.getPayDeduction23No05()); // ^T23No05
		}
		if (null != dto.getPayDeduction24No05()) {
			setValueChk(odsBean, column, line + 23, dto.getPayDeduction24No05()); // ^T24No05
		}
		if (null != dto.getPayDeduction25No05()) {
			setValueChk(odsBean, column, line + 24, dto.getPayDeduction25No05()); // ^T25No05
		}
		if (null != dto.getPayDeductionTotal05()) {
			setValueChk(odsBean, column, line + 25, dto.getPayDeductionTotal05()); // ^TzNo05
		}
		if (null != dto.getPayDeduction26No05()) {
			setValueChk(odsBean, column, line + 26, dto.getPayDeduction26No05()); // ^T26No05
		}
		if (null != dto.getPayPaymentTotal05()) {
			setValueChk(odsBean, column, line + 27, dto.getPayPaymentTotal05()); // ^xzNo05
		}
		if (null != dto.getPayBank1PayAmount05()) {
			setValueChk(odsBean, column, line + 28, dto.getPayBank1PayAmount05()); // ^s1UzNo05
		}
		if (null != dto.getPayBank2PayAmount05()) {
			setValueChk(odsBean, column, line + 29, dto.getPayBank2PayAmount05()); // ^s2UzNo05
		}
		if (null != dto.getPayCashPayAmount05()) {
			setValueChk(odsBean, column, line + 30, dto.getPayCashPayAmount05()); // xzNo05
		}
		if (null != dto.getPayDeduction27No05()) {
			setValueChk(odsBean, column, line + 31, dto.getPayDeduction27No05()); // ^T27No05
		}
		
		line = 8;
		column = 18; // 6
		if (null != dto.getPayPayday06()) {
			setValueChk(odsBean, column, line - 1, dto.getPayPayday06()); // ^xNo06
		}
		if (null != dto.getPayAllowance01No06()) {
			setValueChk(odsBean, column, line + 1, dto.getPayAllowance01No06()); // ^x01No06
		}
		if (null != dto.getPayAllowance02No06()) {
			setValueChk(odsBean, column, line + 2, dto.getPayAllowance02No06()); // ^x02No06
		}
		if (null != dto.getPayAllowance03No06()) {
			setValueChk(odsBean, column, line + 3, dto.getPayAllowance03No06()); // ^x03No06
		}
		if (null != dto.getPayAllowance04No06()) {
			setValueChk(odsBean, column, line + 4, dto.getPayAllowance04No06()); // ^x04No06
		}
		if (null != dto.getPayAllowance05No06()) {
			setValueChk(odsBean, column, line + 5, dto.getPayAllowance05No06()); // ^x05No06
		}
		if (null != dto.getPayAllowance06No06()) {
			setValueChk(odsBean, column, line + 6, dto.getPayAllowance06No06()); // ^x06No06
		}
		if (null != dto.getPayAllowance07No06()) {
			setValueChk(odsBean, column, line + 7, dto.getPayAllowance07No06()); // ^x07No06
		}
		if (null != dto.getPayAllowance08No06()) {
			setValueChk(odsBean, column, line + 8, dto.getPayAllowance08No06()); // ^x08No06
		}
		if (null != dto.getPayAllowance09No06()) {
			setValueChk(odsBean, column, line + 9, dto.getPayAllowance09No06()); // ^x09No06
		}
		if (null != dto.getPayAllowance10No06()) {
			setValueChk(odsBean, column, line + 10, dto.getPayAllowance10No06()); // ^x10No06
		}
		if (null != dto.getPayAllowance11No06()) {
			setValueChk(odsBean, column, line + 11, dto.getPayAllowance11No06()); // ^x11No06
		}
		if (null != dto.getPayAllowance12No06()) {
			setValueChk(odsBean, column, line + 12, dto.getPayAllowance12No06()); // ^x12No06
		}
		if (null != dto.getPayAllowance13No06()) {
			setValueChk(odsBean, column, line + 13, dto.getPayAllowance13No06()); // ^x13No06
		}
		if (null != dto.getPayAllowance14No06()) {
			setValueChk(odsBean, column, line + 14, dto.getPayAllowance14No06()); // ^x14No06
		}
		if (null != dto.getPayAllowance15No06()) {
			setValueChk(odsBean, column, line + 15, dto.getPayAllowance15No06()); // ^x15No06
		}
		if (null != dto.getPayAllowance16No06()) {
			setValueChk(odsBean, column, line + 16, dto.getPayAllowance16No06()); // ^x16No06
		}
		if (null != dto.getPayAllowance17No06()) {
			setValueChk(odsBean, column, line + 17, dto.getPayAllowance17No06()); // ^x17No06
		}
		if (null != dto.getPayAllowance18No06()) {
			setValueChk(odsBean, column, line + 18, dto.getPayAllowance18No06()); // ^x18No06
		}
		if (null != dto.getPayAllowance19No06()) {
			setValueChk(odsBean, column, line + 19, dto.getPayAllowance19No06()); // ^x19No06
		}
		if (null != dto.getPayAllowance20No06()) {
			setValueChk(odsBean, column, line + 20, dto.getPayAllowance20No06()); // ^x20No06
		}
		if (null != dto.getPayAllowance21No06()) {
			setValueChk(odsBean, column, line + 21, dto.getPayAllowance21No06()); // ^x21No06
		}
		if (null != dto.getPayAllowance22No06()) {
			setValueChk(odsBean, column, line + 22, dto.getPayAllowance22No06()); // ^x22No06
		}
		if (null != dto.getPayAllowance23No06()) {
			setValueChk(odsBean, column, line + 23, dto.getPayAllowance23No06()); // ^x23No06
		}
		if (null != dto.getPayAllowance24No06()) {
			setValueChk(odsBean, column, line + 24, dto.getPayAllowance24No06()); // ^x24No06
		}
		if (null != dto.getPayAllowance25No06()) {
			setValueChk(odsBean, column, line + 25, dto.getPayAllowance25No06()); // ^x25No06
		}
		if (null != dto.getPayAllowance26No06()) {
			setValueChk(odsBean, column, line + 26, dto.getPayAllowance26No06()); // ^x26No06
		}
		if (null != dto.getPayAllowance27No06()) {
			setValueChk(odsBean, column, line + 27, dto.getPayAllowance27No06()); // ^x27No06
		}
		if (null != dto.getPayAllowance28No06()) {
			setValueChk(odsBean, column, line + 28, dto.getPayAllowance28No06()); // ^x28No06
		}
		if (null != dto.getPayAllowance29No06()) {
			setValueChk(odsBean, column, line + 29, dto.getPayAllowance29No06()); // ^x29No06
		}
		if (null != dto.getPayAllowance30No06()) {
			setValueChk(odsBean, column, line + 30, dto.getPayAllowance30No06()); // ^x30No06
		}
		if (null != dto.getPayAllowanceTotal06()) {
			setValueChk(odsBean, column, line + 31, dto.getPayAllowanceTotal06()); // ^xzNo06
		}
		line = 40;
		if (null != dto.getPayDeduction01No06()) {
			setValueChk(odsBean, column, line + 1, dto.getPayDeduction01No06()); // ^T01No06
		}
		if (null != dto.getPayDeduction02No06()) {
			setValueChk(odsBean, column, line + 2, dto.getPayDeduction02No06()); // ^T02No06
		}
		if (null != dto.getPayDeduction03No06()) {
			setValueChk(odsBean, column, line + 3, dto.getPayDeduction03No06()); // ^T03No06
		}
		if (null != dto.getPayDeduction04No06()) {
			setValueChk(odsBean, column, line + 4, dto.getPayDeduction04No06()); // ^T04No06
		}
		if (null != dto.getPayDeduction05No06()) {
			setValueChk(odsBean, column, line + 5, dto.getPayDeduction05No06()); // ^T05No06
		}
		if (null != dto.getPayDeduction06No06()) {
			setValueChk(odsBean, column, line + 6, dto.getPayDeduction06No06()); // ^T06No06
		}
		if (null != dto.getPayDeduction07No06()) {
			setValueChk(odsBean, column, line + 7, dto.getPayDeduction07No06()); // ^T07No06
		}
		if (null != dto.getPayDeduction08No06()) {
			setValueChk(odsBean, column, line + 8, dto.getPayDeduction08No06()); // ^T08No06
		}
		if (null != dto.getPayDeduction09No06()) {
			setValueChk(odsBean, column, line + 9, dto.getPayDeduction09No06()); // ^T09No06
		}
		if (null != dto.getPayDeduction10No06()) {
			setValueChk(odsBean, column, line + 10, dto.getPayDeduction10No06()); // ^T10No06
		}
		if (null != dto.getPayDeduction11No06()) {
			setValueChk(odsBean, column, line + 11, dto.getPayDeduction11No06()); // ^T11No06
		}
		if (null != dto.getPayDeduction12No06()) {
			setValueChk(odsBean, column, line + 12, dto.getPayDeduction12No06()); // ^T12No06
		}
		if (null != dto.getPayDeduction14No06()) {
			setValueChk(odsBean, column, line + 13, dto.getPayDeduction14No06()); // ^T14No06
		}
		if (null != dto.getPayDeduction15No06()) {
			setValueChk(odsBean, column, line + 14, dto.getPayDeduction15No06()); // ^T15No06
		}
		if (null != dto.getPayDeduction16No06()) {
			setValueChk(odsBean, column, line + 15, dto.getPayDeduction16No06()); // ^T16No06
		}
		if (null != dto.getPayDeduction17No06()) {
			setValueChk(odsBean, column, line + 16, dto.getPayDeduction17No06()); // ^T17No06
		}
		if (null != dto.getPayDeduction18No06()) {
			setValueChk(odsBean, column, line + 17, dto.getPayDeduction18No06()); // ^T18No06
		}
		if (null != dto.getPayDeduction19No06()) {
			setValueChk(odsBean, column, line + 18, dto.getPayDeduction19No06()); // ^T19No06
		}
		if (null != dto.getPayDeduction20No06()) {
			setValueChk(odsBean, column, line + 19, dto.getPayDeduction20No06()); // ^T20No06
		}
		if (null != dto.getPayDeduction21No06()) {
			setValueChk(odsBean, column, line + 20, dto.getPayDeduction21No06()); // ^T21No06
		}
		if (null != dto.getPayDeduction22No06()) {
			setValueChk(odsBean, column, line + 21, dto.getPayDeduction22No06()); // ^T22No06
		}
		if (null != dto.getPayDeduction23No06()) {
			setValueChk(odsBean, column, line + 22, dto.getPayDeduction23No06()); // ^T23No06
		}
		if (null != dto.getPayDeduction24No06()) {
			setValueChk(odsBean, column, line + 23, dto.getPayDeduction24No06()); // ^T24No06
		}
		if (null != dto.getPayDeduction25No06()) {
			setValueChk(odsBean, column, line + 24, dto.getPayDeduction25No06()); // ^T25No06
		}
		if (null != dto.getPayDeductionTotal06()) {
			setValueChk(odsBean, column, line + 25, dto.getPayDeductionTotal06()); // ^TzNo06
		}
		if (null != dto.getPayDeduction26No06()) {
			setValueChk(odsBean, column, line + 26, dto.getPayDeduction26No06()); // ^T26No06
		}
		if (null != dto.getPayPaymentTotal06()) {
			setValueChk(odsBean, column, line + 27, dto.getPayPaymentTotal06()); // ^xzNo06
		}
		if (null != dto.getPayBank1PayAmount06()) {
			setValueChk(odsBean, column, line + 28, dto.getPayBank1PayAmount06()); // ^s1UzNo06
		}
		if (null != dto.getPayBank2PayAmount06()) {
			setValueChk(odsBean, column, line + 29, dto.getPayBank2PayAmount06()); // ^s2UzNo06
		}
		if (null != dto.getPayCashPayAmount06()) {
			setValueChk(odsBean, column, line + 30, dto.getPayCashPayAmount06()); // xzNo06
		}
		if (null != dto.getPayDeduction27No06()) {
			setValueChk(odsBean, column, line + 31, dto.getPayDeduction27No06()); // ^T27No06
		}
		
		line = 8;
		column = 21; // 7
		if (null != dto.getPayPayday07()) {
			setValueChk(odsBean, column, line - 1, dto.getPayPayday07()); // ^xNo07
		}
		if (null != dto.getPayAllowance01No07()) {
			setValueChk(odsBean, column, line + 1, dto.getPayAllowance01No07()); // ^x01No07
		}
		if (null != dto.getPayAllowance02No07()) {
			setValueChk(odsBean, column, line + 2, dto.getPayAllowance02No07()); // ^x02No07
		}
		if (null != dto.getPayAllowance03No07()) {
			setValueChk(odsBean, column, line + 3, dto.getPayAllowance03No07()); // ^x03No07
		}
		if (null != dto.getPayAllowance04No07()) {
			setValueChk(odsBean, column, line + 4, dto.getPayAllowance04No07()); // ^x04No07
		}
		if (null != dto.getPayAllowance05No07()) {
			setValueChk(odsBean, column, line + 5, dto.getPayAllowance05No07()); // ^x05No07
		}
		if (null != dto.getPayAllowance06No07()) {
			setValueChk(odsBean, column, line + 6, dto.getPayAllowance06No07()); // ^x06No07
		}
		if (null != dto.getPayAllowance07No07()) {
			setValueChk(odsBean, column, line + 7, dto.getPayAllowance07No07()); // ^x07No07
		}
		if (null != dto.getPayAllowance08No07()) {
			setValueChk(odsBean, column, line + 8, dto.getPayAllowance08No07()); // ^x08No07
		}
		if (null != dto.getPayAllowance09No07()) {
			setValueChk(odsBean, column, line + 9, dto.getPayAllowance09No07()); // ^x09No07
		}
		if (null != dto.getPayAllowance10No07()) {
			setValueChk(odsBean, column, line + 10, dto.getPayAllowance10No07()); // ^x10No07
		}
		if (null != dto.getPayAllowance11No07()) {
			setValueChk(odsBean, column, line + 11, dto.getPayAllowance11No07()); // ^x11No07
		}
		if (null != dto.getPayAllowance12No07()) {
			setValueChk(odsBean, column, line + 12, dto.getPayAllowance12No07()); // ^x12No07
		}
		if (null != dto.getPayAllowance13No07()) {
			setValueChk(odsBean, column, line + 13, dto.getPayAllowance13No07()); // ^x13No07
		}
		if (null != dto.getPayAllowance14No07()) {
			setValueChk(odsBean, column, line + 14, dto.getPayAllowance14No07()); // ^x14No07
		}
		if (null != dto.getPayAllowance15No07()) {
			setValueChk(odsBean, column, line + 15, dto.getPayAllowance15No07()); // ^x15No07
		}
		if (null != dto.getPayAllowance16No07()) {
			setValueChk(odsBean, column, line + 16, dto.getPayAllowance16No07()); // ^x16No07
		}
		if (null != dto.getPayAllowance17No07()) {
			setValueChk(odsBean, column, line + 17, dto.getPayAllowance17No07()); // ^x17No07
		}
		if (null != dto.getPayAllowance18No07()) {
			setValueChk(odsBean, column, line + 18, dto.getPayAllowance18No07()); // ^x18No07
		}
		if (null != dto.getPayAllowance19No07()) {
			setValueChk(odsBean, column, line + 19, dto.getPayAllowance19No07()); // ^x19No07
		}
		if (null != dto.getPayAllowance20No07()) {
			setValueChk(odsBean, column, line + 20, dto.getPayAllowance20No07()); // ^x20No07
		}
		if (null != dto.getPayAllowance21No07()) {
			setValueChk(odsBean, column, line + 21, dto.getPayAllowance21No07()); // ^x21No07
		}
		if (null != dto.getPayAllowance22No07()) {
			setValueChk(odsBean, column, line + 22, dto.getPayAllowance22No07()); // ^x22No07
		}
		if (null != dto.getPayAllowance23No07()) {
			setValueChk(odsBean, column, line + 23, dto.getPayAllowance23No07()); // ^x23No07
		}
		if (null != dto.getPayAllowance24No07()) {
			setValueChk(odsBean, column, line + 24, dto.getPayAllowance24No07()); // ^x24No07
		}
		if (null != dto.getPayAllowance25No07()) {
			setValueChk(odsBean, column, line + 25, dto.getPayAllowance25No07()); // ^x25No07
		}
		if (null != dto.getPayAllowance26No07()) {
			setValueChk(odsBean, column, line + 26, dto.getPayAllowance26No07()); // ^x26No07
		}
		if (null != dto.getPayAllowance27No07()) {
			setValueChk(odsBean, column, line + 27, dto.getPayAllowance27No07()); // ^x27No07
		}
		if (null != dto.getPayAllowance28No07()) {
			setValueChk(odsBean, column, line + 28, dto.getPayAllowance28No07()); // ^x28No07
		}
		if (null != dto.getPayAllowance29No07()) {
			setValueChk(odsBean, column, line + 29, dto.getPayAllowance29No07()); // ^x29No07
		}
		if (null != dto.getPayAllowance30No07()) {
			setValueChk(odsBean, column, line + 30, dto.getPayAllowance30No07()); // ^x30No07
		}
		if (null != dto.getPayAllowanceTotal07()) {
			setValueChk(odsBean, column, line + 31, dto.getPayAllowanceTotal07()); // ^xzNo07
		}
		line = 40;
		if (null != dto.getPayDeduction01No07()) {
			setValueChk(odsBean, column, line + 1, dto.getPayDeduction01No07()); // ^T01No07
		}
		if (null != dto.getPayDeduction02No07()) {
			setValueChk(odsBean, column, line + 2, dto.getPayDeduction02No07()); // ^T02No07
		}
		if (null != dto.getPayDeduction03No07()) {
			setValueChk(odsBean, column, line + 3, dto.getPayDeduction03No07()); // ^T03No07
		}
		if (null != dto.getPayDeduction04No07()) {
			setValueChk(odsBean, column, line + 4, dto.getPayDeduction04No07()); // ^T04No07
		}
		if (null != dto.getPayDeduction05No07()) {
			setValueChk(odsBean, column, line + 5, dto.getPayDeduction05No07()); // ^T05No07
		}
		if (null != dto.getPayDeduction06No07()) {
			setValueChk(odsBean, column, line + 6, dto.getPayDeduction06No07()); // ^T06No07
		}
		if (null != dto.getPayDeduction07No07()) {
			setValueChk(odsBean, column, line + 7, dto.getPayDeduction07No07()); // ^T07No07
		}
		if (null != dto.getPayDeduction08No07()) {
			setValueChk(odsBean, column, line + 8, dto.getPayDeduction08No07()); // ^T08No07
		}
		if (null != dto.getPayDeduction09No07()) {
			setValueChk(odsBean, column, line + 9, dto.getPayDeduction09No07()); // ^T09No07
		}
		if (null != dto.getPayDeduction10No07()) {
			setValueChk(odsBean, column, line + 10, dto.getPayDeduction10No07()); // ^T10No07
		}
		if (null != dto.getPayDeduction11No07()) {
			setValueChk(odsBean, column, line + 11, dto.getPayDeduction11No07()); // ^T11No07
		}
		if (null != dto.getPayDeduction12No07()) {
			setValueChk(odsBean, column, line + 12, dto.getPayDeduction12No07()); // ^T12No07
		}
		if (null != dto.getPayDeduction14No07()) {
			setValueChk(odsBean, column, line + 13, dto.getPayDeduction14No07()); // ^T14No07
		}
		if (null != dto.getPayDeduction15No07()) {
			setValueChk(odsBean, column, line + 14, dto.getPayDeduction15No07()); // ^T15No07
		}
		if (null != dto.getPayDeduction16No07()) {
			setValueChk(odsBean, column, line + 15, dto.getPayDeduction16No07()); // ^T16No07
		}
		if (null != dto.getPayDeduction17No07()) {
			setValueChk(odsBean, column, line + 16, dto.getPayDeduction17No07()); // ^T17No07
		}
		if (null != dto.getPayDeduction18No07()) {
			setValueChk(odsBean, column, line + 17, dto.getPayDeduction18No07()); // ^T18No07
		}
		if (null != dto.getPayDeduction19No07()) {
			setValueChk(odsBean, column, line + 18, dto.getPayDeduction19No07()); // ^T19No07
		}
		if (null != dto.getPayDeduction20No07()) {
			setValueChk(odsBean, column, line + 19, dto.getPayDeduction20No07()); // ^T20No07
		}
		if (null != dto.getPayDeduction21No07()) {
			setValueChk(odsBean, column, line + 20, dto.getPayDeduction21No07()); // ^T21No07
		}
		if (null != dto.getPayDeduction22No07()) {
			setValueChk(odsBean, column, line + 21, dto.getPayDeduction22No07()); // ^T22No07
		}
		if (null != dto.getPayDeduction23No07()) {
			setValueChk(odsBean, column, line + 22, dto.getPayDeduction23No07()); // ^T23No07
		}
		if (null != dto.getPayDeduction24No07()) {
			setValueChk(odsBean, column, line + 23, dto.getPayDeduction24No07()); // ^T24No07
		}
		if (null != dto.getPayDeduction25No07()) {
			setValueChk(odsBean, column, line + 24, dto.getPayDeduction25No07()); // ^T25No07
		}
		if (null != dto.getPayDeductionTotal07()) {
			setValueChk(odsBean, column, line + 25, dto.getPayDeductionTotal07()); // ^TzNo07
		}
		if (null != dto.getPayDeduction26No07()) {
			setValueChk(odsBean, column, line + 26, dto.getPayDeduction26No07()); // ^T26No07
		}
		if (null != dto.getPayPaymentTotal07()) {
			setValueChk(odsBean, column, line + 27, dto.getPayPaymentTotal07()); // ^xzNo07
		}
		if (null != dto.getPayBank1PayAmount07()) {
			setValueChk(odsBean, column, line + 28, dto.getPayBank1PayAmount07()); // ^s1UzNo07
		}
		if (null != dto.getPayBank2PayAmount07()) {
			setValueChk(odsBean, column, line + 29, dto.getPayBank2PayAmount07()); // ^s2UzNo07
		}
		if (null != dto.getPayCashPayAmount07()) {
			setValueChk(odsBean, column, line + 30, dto.getPayCashPayAmount07()); // xzNo07
		}
		if (null != dto.getPayDeduction27No07()) {
			setValueChk(odsBean, column, line + 31, dto.getPayDeduction27No07()); // ^T27No07
		}
		
		line = 8;
		column = 24; // 8
		if (null != dto.getPayPayday08()) {
			setValueChk(odsBean, column, line - 1, dto.getPayPayday08()); // ^xNo08
		}
		if (null != dto.getPayAllowance01No08()) {
			setValueChk(odsBean, column, line + 1, dto.getPayAllowance01No08()); // ^x01No08
		}
		if (null != dto.getPayAllowance02No08()) {
			setValueChk(odsBean, column, line + 2, dto.getPayAllowance02No08()); // ^x02No08
		}
		if (null != dto.getPayAllowance03No08()) {
			setValueChk(odsBean, column, line + 3, dto.getPayAllowance03No08()); // ^x03No08
		}
		if (null != dto.getPayAllowance04No08()) {
			setValueChk(odsBean, column, line + 4, dto.getPayAllowance04No08()); // ^x04No08
		}
		if (null != dto.getPayAllowance05No08()) {
			setValueChk(odsBean, column, line + 5, dto.getPayAllowance05No08()); // ^x05No08
		}
		if (null != dto.getPayAllowance06No08()) {
			setValueChk(odsBean, column, line + 6, dto.getPayAllowance06No08()); // ^x06No08
		}
		if (null != dto.getPayAllowance07No08()) {
			setValueChk(odsBean, column, line + 7, dto.getPayAllowance07No08()); // ^x07No08
		}
		if (null != dto.getPayAllowance08No08()) {
			setValueChk(odsBean, column, line + 8, dto.getPayAllowance08No08()); // ^x08No08
		}
		if (null != dto.getPayAllowance09No08()) {
			setValueChk(odsBean, column, line + 9, dto.getPayAllowance09No08()); // ^x09No08
		}
		if (null != dto.getPayAllowance10No08()) {
			setValueChk(odsBean, column, line + 10, dto.getPayAllowance10No08()); // ^x10No08
		}
		if (null != dto.getPayAllowance11No08()) {
			setValueChk(odsBean, column, line + 11, dto.getPayAllowance11No08()); // ^x11No08
		}
		if (null != dto.getPayAllowance12No08()) {
			setValueChk(odsBean, column, line + 12, dto.getPayAllowance12No08()); // ^x12No08
		}
		if (null != dto.getPayAllowance13No08()) {
			setValueChk(odsBean, column, line + 13, dto.getPayAllowance13No08()); // ^x13No08
		}
		if (null != dto.getPayAllowance14No08()) {
			setValueChk(odsBean, column, line + 14, dto.getPayAllowance14No08()); // ^x14No08
		}
		if (null != dto.getPayAllowance15No08()) {
			setValueChk(odsBean, column, line + 15, dto.getPayAllowance15No08()); // ^x15No08
		}
		if (null != dto.getPayAllowance16No08()) {
			setValueChk(odsBean, column, line + 16, dto.getPayAllowance16No08()); // ^x16No08
		}
		if (null != dto.getPayAllowance17No08()) {
			setValueChk(odsBean, column, line + 17, dto.getPayAllowance17No08()); // ^x17No08
		}
		if (null != dto.getPayAllowance18No08()) {
			setValueChk(odsBean, column, line + 18, dto.getPayAllowance18No08()); // ^x18No08
		}
		if (null != dto.getPayAllowance19No08()) {
			setValueChk(odsBean, column, line + 19, dto.getPayAllowance19No08()); // ^x19No08
		}
		if (null != dto.getPayAllowance20No08()) {
			setValueChk(odsBean, column, line + 20, dto.getPayAllowance20No08()); // ^x20No08
		}
		if (null != dto.getPayAllowance21No08()) {
			setValueChk(odsBean, column, line + 21, dto.getPayAllowance21No08()); // ^x21No08
		}
		if (null != dto.getPayAllowance22No08()) {
			setValueChk(odsBean, column, line + 22, dto.getPayAllowance22No08()); // ^x22No08
		}
		if (null != dto.getPayAllowance23No08()) {
			setValueChk(odsBean, column, line + 23, dto.getPayAllowance23No08()); // ^x23No08
		}
		if (null != dto.getPayAllowance24No08()) {
			setValueChk(odsBean, column, line + 24, dto.getPayAllowance24No08()); // ^x24No08
		}
		if (null != dto.getPayAllowance25No08()) {
			setValueChk(odsBean, column, line + 25, dto.getPayAllowance25No08()); // ^x25No08
		}
		if (null != dto.getPayAllowance26No08()) {
			setValueChk(odsBean, column, line + 26, dto.getPayAllowance26No08()); // ^x26No08
		}
		if (null != dto.getPayAllowance27No08()) {
			setValueChk(odsBean, column, line + 27, dto.getPayAllowance27No08()); // ^x27No08
		}
		if (null != dto.getPayAllowance28No08()) {
			setValueChk(odsBean, column, line + 28, dto.getPayAllowance28No08()); // ^x28No08
		}
		if (null != dto.getPayAllowance29No08()) {
			setValueChk(odsBean, column, line + 29, dto.getPayAllowance29No08()); // ^x29No08
		}
		if (null != dto.getPayAllowance30No08()) {
			setValueChk(odsBean, column, line + 30, dto.getPayAllowance30No08()); // ^x30No08
		}
		if (null != dto.getPayAllowanceTotal08()) {
			setValueChk(odsBean, column, line + 31, dto.getPayAllowanceTotal08()); // ^xzNo08
		}
		line = 40;
		if (null != dto.getPayDeduction01No08()) {
			setValueChk(odsBean, column, line + 1, dto.getPayDeduction01No08()); // ^T01No08
		}
		if (null != dto.getPayDeduction02No08()) {
			setValueChk(odsBean, column, line + 2, dto.getPayDeduction02No08()); // ^T02No08
		}
		if (null != dto.getPayDeduction03No08()) {
			setValueChk(odsBean, column, line + 3, dto.getPayDeduction03No08()); // ^T03No08
		}
		if (null != dto.getPayDeduction04No08()) {
			setValueChk(odsBean, column, line + 4, dto.getPayDeduction04No08()); // ^T04No08
		}
		if (null != dto.getPayDeduction05No08()) {
			setValueChk(odsBean, column, line + 5, dto.getPayDeduction05No08()); // ^T05No08
		}
		if (null != dto.getPayDeduction06No08()) {
			setValueChk(odsBean, column, line + 6, dto.getPayDeduction06No08()); // ^T06No08
		}
		if (null != dto.getPayDeduction07No08()) {
			setValueChk(odsBean, column, line + 7, dto.getPayDeduction07No08()); // ^T07No08
		}
		if (null != dto.getPayDeduction08No08()) {
			setValueChk(odsBean, column, line + 8, dto.getPayDeduction08No08()); // ^T08No08
		}
		if (null != dto.getPayDeduction09No08()) {
			setValueChk(odsBean, column, line + 9, dto.getPayDeduction09No08()); // ^T09No08
		}
		if (null != dto.getPayDeduction10No08()) {
			setValueChk(odsBean, column, line + 10, dto.getPayDeduction10No08()); // ^T10No08
		}
		if (null != dto.getPayDeduction11No08()) {
			setValueChk(odsBean, column, line + 11, dto.getPayDeduction11No08()); // ^T11No08
		}
		if (null != dto.getPayDeduction12No08()) {
			setValueChk(odsBean, column, line + 12, dto.getPayDeduction12No08()); // ^T12No08
		}
		if (null != dto.getPayDeduction14No08()) {
			setValueChk(odsBean, column, line + 13, dto.getPayDeduction14No08()); // ^T14No08
		}
		if (null != dto.getPayDeduction15No08()) {
			setValueChk(odsBean, column, line + 14, dto.getPayDeduction15No08()); // ^T15No08
		}
		if (null != dto.getPayDeduction16No08()) {
			setValueChk(odsBean, column, line + 15, dto.getPayDeduction16No08()); // ^T16No08
		}
		if (null != dto.getPayDeduction17No08()) {
			setValueChk(odsBean, column, line + 16, dto.getPayDeduction17No08()); // ^T17No08
		}
		if (null != dto.getPayDeduction18No08()) {
			setValueChk(odsBean, column, line + 17, dto.getPayDeduction18No08()); // ^T18No08
		}
		if (null != dto.getPayDeduction19No08()) {
			setValueChk(odsBean, column, line + 18, dto.getPayDeduction19No08()); // ^T19No08
		}
		if (null != dto.getPayDeduction20No08()) {
			setValueChk(odsBean, column, line + 19, dto.getPayDeduction20No08()); // ^T20No08
		}
		if (null != dto.getPayDeduction21No08()) {
			setValueChk(odsBean, column, line + 20, dto.getPayDeduction21No08()); // ^T21No08
		}
		if (null != dto.getPayDeduction22No08()) {
			setValueChk(odsBean, column, line + 21, dto.getPayDeduction22No08()); // ^T22No08
		}
		if (null != dto.getPayDeduction23No08()) {
			setValueChk(odsBean, column, line + 22, dto.getPayDeduction23No08()); // ^T23No08
		}
		if (null != dto.getPayDeduction24No08()) {
			setValueChk(odsBean, column, line + 23, dto.getPayDeduction24No08()); // ^T24No08
		}
		if (null != dto.getPayDeduction25No08()) {
			setValueChk(odsBean, column, line + 24, dto.getPayDeduction25No08()); // ^T25No08
		}
		if (null != dto.getPayDeductionTotal08()) {
			setValueChk(odsBean, column, line + 25, dto.getPayDeductionTotal08()); // ^TzNo08
		}
		if (null != dto.getPayDeduction26No08()) {
			setValueChk(odsBean, column, line + 26, dto.getPayDeduction26No08()); // ^T26No08
		}
		if (null != dto.getPayPaymentTotal08()) {
			setValueChk(odsBean, column, line + 27, dto.getPayPaymentTotal08()); // ^xzNo08
		}
		if (null != dto.getPayBank1PayAmount08()) {
			setValueChk(odsBean, column, line + 28, dto.getPayBank1PayAmount08()); // ^s1UzNo08
		}
		if (null != dto.getPayBank2PayAmount08()) {
			setValueChk(odsBean, column, line + 29, dto.getPayBank2PayAmount08()); // ^s2UzNo08
		}
		if (null != dto.getPayCashPayAmount08()) {
			setValueChk(odsBean, column, line + 30, dto.getPayCashPayAmount08()); // xzNo08
		}
		if (null != dto.getPayDeduction27No08()) {
			setValueChk(odsBean, column, line + 31, dto.getPayDeduction27No08()); // ^T27No08
		}
		
		line = 8;
		column = 27; // 9
		if (null != dto.getPayPayday09()) {
			setValueChk(odsBean, column, line - 1, dto.getPayPayday09()); // ^xNo09
		}
		if (null != dto.getPayAllowance01No09()) {
			setValueChk(odsBean, column, line + 1, dto.getPayAllowance01No09()); // ^x01No09
		}
		if (null != dto.getPayAllowance02No09()) {
			setValueChk(odsBean, column, line + 2, dto.getPayAllowance02No09()); // ^x02No09
		}
		if (null != dto.getPayAllowance03No09()) {
			setValueChk(odsBean, column, line + 3, dto.getPayAllowance03No09()); // ^x03No09
		}
		if (null != dto.getPayAllowance04No09()) {
			setValueChk(odsBean, column, line + 4, dto.getPayAllowance04No09()); // ^x04No09
		}
		if (null != dto.getPayAllowance05No09()) {
			setValueChk(odsBean, column, line + 5, dto.getPayAllowance05No09()); // ^x05No09
		}
		if (null != dto.getPayAllowance06No09()) {
			setValueChk(odsBean, column, line + 6, dto.getPayAllowance06No09()); // ^x06No09
		}
		if (null != dto.getPayAllowance07No09()) {
			setValueChk(odsBean, column, line + 7, dto.getPayAllowance07No09()); // ^x07No09
		}
		if (null != dto.getPayAllowance08No09()) {
			setValueChk(odsBean, column, line + 8, dto.getPayAllowance08No09()); // ^x08No09
		}
		if (null != dto.getPayAllowance09No09()) {
			setValueChk(odsBean, column, line + 9, dto.getPayAllowance09No09()); // ^x09No09
		}
		if (null != dto.getPayAllowance10No09()) {
			setValueChk(odsBean, column, line + 10, dto.getPayAllowance10No09()); // ^x10No09
		}
		if (null != dto.getPayAllowance11No09()) {
			setValueChk(odsBean, column, line + 11, dto.getPayAllowance11No09()); // ^x11No09
		}
		if (null != dto.getPayAllowance12No09()) {
			setValueChk(odsBean, column, line + 12, dto.getPayAllowance12No09()); // ^x12No09
		}
		if (null != dto.getPayAllowance13No09()) {
			setValueChk(odsBean, column, line + 13, dto.getPayAllowance13No09()); // ^x13No09
		}
		if (null != dto.getPayAllowance14No09()) {
			setValueChk(odsBean, column, line + 14, dto.getPayAllowance14No09()); // ^x14No09
		}
		if (null != dto.getPayAllowance15No09()) {
			setValueChk(odsBean, column, line + 15, dto.getPayAllowance15No09()); // ^x15No09
		}
		if (null != dto.getPayAllowance16No09()) {
			setValueChk(odsBean, column, line + 16, dto.getPayAllowance16No09()); // ^x16No09
		}
		if (null != dto.getPayAllowance17No09()) {
			setValueChk(odsBean, column, line + 17, dto.getPayAllowance17No09()); // ^x17No09
		}
		if (null != dto.getPayAllowance18No09()) {
			setValueChk(odsBean, column, line + 18, dto.getPayAllowance18No09()); // ^x18No09
		}
		if (null != dto.getPayAllowance19No09()) {
			setValueChk(odsBean, column, line + 19, dto.getPayAllowance19No09()); // ^x19No09
		}
		if (null != dto.getPayAllowance20No09()) {
			setValueChk(odsBean, column, line + 20, dto.getPayAllowance20No09()); // ^x20No09
		}
		if (null != dto.getPayAllowance21No09()) {
			setValueChk(odsBean, column, line + 21, dto.getPayAllowance21No09()); // ^x21No09
		}
		if (null != dto.getPayAllowance22No09()) {
			setValueChk(odsBean, column, line + 22, dto.getPayAllowance22No09()); // ^x22No09
		}
		if (null != dto.getPayAllowance23No09()) {
			setValueChk(odsBean, column, line + 23, dto.getPayAllowance23No09()); // ^x23No09
		}
		if (null != dto.getPayAllowance24No09()) {
			setValueChk(odsBean, column, line + 24, dto.getPayAllowance24No09()); // ^x24No09
		}
		if (null != dto.getPayAllowance25No09()) {
			setValueChk(odsBean, column, line + 25, dto.getPayAllowance25No09()); // ^x25No09
		}
		if (null != dto.getPayAllowance26No09()) {
			setValueChk(odsBean, column, line + 26, dto.getPayAllowance26No09()); // ^x26No09
		}
		if (null != dto.getPayAllowance27No09()) {
			setValueChk(odsBean, column, line + 27, dto.getPayAllowance27No09()); // ^x27No09
		}
		if (null != dto.getPayAllowance28No09()) {
			setValueChk(odsBean, column, line + 28, dto.getPayAllowance28No09()); // ^x28No09
		}
		if (null != dto.getPayAllowance29No09()) {
			setValueChk(odsBean, column, line + 29, dto.getPayAllowance29No09()); // ^x29No09
		}
		if (null != dto.getPayAllowance30No09()) {
			setValueChk(odsBean, column, line + 30, dto.getPayAllowance30No09()); // ^x30No09
		}
		if (null != dto.getPayAllowanceTotal09()) {
			setValueChk(odsBean, column, line + 31, dto.getPayAllowanceTotal09()); // ^xzNo09
		}
		line = 40;
		if (null != dto.getPayDeduction01No09()) {
			setValueChk(odsBean, column, line + 1, dto.getPayDeduction01No09()); // ^T01No09
		}
		if (null != dto.getPayDeduction02No09()) {
			setValueChk(odsBean, column, line + 2, dto.getPayDeduction02No09()); // ^T02No09
		}
		if (null != dto.getPayDeduction03No09()) {
			setValueChk(odsBean, column, line + 3, dto.getPayDeduction03No09()); // ^T03No09
		}
		if (null != dto.getPayDeduction04No09()) {
			setValueChk(odsBean, column, line + 4, dto.getPayDeduction04No09()); // ^T04No09
		}
		if (null != dto.getPayDeduction05No09()) {
			setValueChk(odsBean, column, line + 5, dto.getPayDeduction05No09()); // ^T05No09
		}
		if (null != dto.getPayDeduction06No09()) {
			setValueChk(odsBean, column, line + 6, dto.getPayDeduction06No09()); // ^T06No09
		}
		if (null != dto.getPayDeduction07No09()) {
			setValueChk(odsBean, column, line + 7, dto.getPayDeduction07No09()); // ^T07No09
		}
		if (null != dto.getPayDeduction08No09()) {
			setValueChk(odsBean, column, line + 8, dto.getPayDeduction08No09()); // ^T08No09
		}
		if (null != dto.getPayDeduction09No09()) {
			setValueChk(odsBean, column, line + 9, dto.getPayDeduction09No09()); // ^T09No09
		}
		if (null != dto.getPayDeduction10No09()) {
			setValueChk(odsBean, column, line + 10, dto.getPayDeduction10No09()); // ^T10No09
		}
		if (null != dto.getPayDeduction11No09()) {
			setValueChk(odsBean, column, line + 11, dto.getPayDeduction11No09()); // ^T11No09
		}
		if (null != dto.getPayDeduction12No09()) {
			setValueChk(odsBean, column, line + 12, dto.getPayDeduction12No09()); // ^T12No09
		}
		if (null != dto.getPayDeduction14No09()) {
			setValueChk(odsBean, column, line + 13, dto.getPayDeduction14No09()); // ^T14No09
		}
		if (null != dto.getPayDeduction15No09()) {
			setValueChk(odsBean, column, line + 14, dto.getPayDeduction15No09()); // ^T15No09
		}
		if (null != dto.getPayDeduction16No09()) {
			setValueChk(odsBean, column, line + 15, dto.getPayDeduction16No09()); // ^T16No09
		}
		if (null != dto.getPayDeduction17No09()) {
			setValueChk(odsBean, column, line + 16, dto.getPayDeduction17No09()); // ^T17No09
		}
		if (null != dto.getPayDeduction18No09()) {
			setValueChk(odsBean, column, line + 17, dto.getPayDeduction18No09()); // ^T18No09
		}
		if (null != dto.getPayDeduction19No09()) {
			setValueChk(odsBean, column, line + 18, dto.getPayDeduction19No09()); // ^T19No09
		}
		if (null != dto.getPayDeduction20No09()) {
			setValueChk(odsBean, column, line + 19, dto.getPayDeduction20No09()); // ^T20No09
		}
		if (null != dto.getPayDeduction21No09()) {
			setValueChk(odsBean, column, line + 20, dto.getPayDeduction21No09()); // ^T21No09
		}
		if (null != dto.getPayDeduction22No09()) {
			setValueChk(odsBean, column, line + 21, dto.getPayDeduction22No09()); // ^T22No09
		}
		if (null != dto.getPayDeduction23No09()) {
			setValueChk(odsBean, column, line + 22, dto.getPayDeduction23No09()); // ^T23No09
		}
		if (null != dto.getPayDeduction24No09()) {
			setValueChk(odsBean, column, line + 23, dto.getPayDeduction24No09()); // ^T24No09
		}
		if (null != dto.getPayDeduction25No09()) {
			setValueChk(odsBean, column, line + 24, dto.getPayDeduction25No09()); // ^T25No09
		}
		if (null != dto.getPayDeductionTotal09()) {
			setValueChk(odsBean, column, line + 25, dto.getPayDeductionTotal09()); // ^TzNo09
		}
		if (null != dto.getPayDeduction26No09()) {
			setValueChk(odsBean, column, line + 26, dto.getPayDeduction26No09()); // ^T26No09
		}
		if (null != dto.getPayPaymentTotal09()) {
			setValueChk(odsBean, column, line + 27, dto.getPayPaymentTotal09()); // ^xzNo09
		}
		if (null != dto.getPayBank1PayAmount09()) {
			setValueChk(odsBean, column, line + 28, dto.getPayBank1PayAmount09()); // ^s1UzNo09
		}
		if (null != dto.getPayBank2PayAmount09()) {
			setValueChk(odsBean, column, line + 29, dto.getPayBank2PayAmount09()); // ^s2UzNo09
		}
		if (null != dto.getPayCashPayAmount09()) {
			setValueChk(odsBean, column, line + 30, dto.getPayCashPayAmount09()); // xzNo09
		}
		if (null != dto.getPayDeduction27No09()) {
			setValueChk(odsBean, column, line + 31, dto.getPayDeduction27No09()); // ^T27No09
		}
		
		line = 8;
		column = 30; // 10
		if (null != dto.getPayPayday10()) {
			setValueChk(odsBean, column, line - 1, dto.getPayPayday10()); // ^xNo10
		}
		if (null != dto.getPayAllowance01No10()) {
			setValueChk(odsBean, column, line + 1, dto.getPayAllowance01No10()); // ^x01No10
		}
		if (null != dto.getPayAllowance02No10()) {
			setValueChk(odsBean, column, line + 2, dto.getPayAllowance02No10()); // ^x02No10
		}
		if (null != dto.getPayAllowance03No10()) {
			setValueChk(odsBean, column, line + 3, dto.getPayAllowance03No10()); // ^x03No10
		}
		if (null != dto.getPayAllowance04No10()) {
			setValueChk(odsBean, column, line + 4, dto.getPayAllowance04No10()); // ^x04No10
		}
		if (null != dto.getPayAllowance05No10()) {
			setValueChk(odsBean, column, line + 5, dto.getPayAllowance05No10()); // ^x05No10
		}
		if (null != dto.getPayAllowance06No10()) {
			setValueChk(odsBean, column, line + 6, dto.getPayAllowance06No10()); // ^x06No10
		}
		if (null != dto.getPayAllowance07No10()) {
			setValueChk(odsBean, column, line + 7, dto.getPayAllowance07No10()); // ^x07No10
		}
		if (null != dto.getPayAllowance08No10()) {
			setValueChk(odsBean, column, line + 8, dto.getPayAllowance08No10()); // ^x08No10
		}
		if (null != dto.getPayAllowance09No10()) {
			setValueChk(odsBean, column, line + 9, dto.getPayAllowance09No10()); // ^x09No10
		}
		if (null != dto.getPayAllowance10No10()) {
			setValueChk(odsBean, column, line + 10, dto.getPayAllowance10No10()); // ^x10No10
		}
		if (null != dto.getPayAllowance11No10()) {
			setValueChk(odsBean, column, line + 11, dto.getPayAllowance11No10()); // ^x11No10
		}
		if (null != dto.getPayAllowance12No10()) {
			setValueChk(odsBean, column, line + 12, dto.getPayAllowance12No10()); // ^x12No10
		}
		if (null != dto.getPayAllowance13No10()) {
			setValueChk(odsBean, column, line + 13, dto.getPayAllowance13No10()); // ^x13No10
		}
		if (null != dto.getPayAllowance14No10()) {
			setValueChk(odsBean, column, line + 14, dto.getPayAllowance14No10()); // ^x14No10
		}
		if (null != dto.getPayAllowance15No10()) {
			setValueChk(odsBean, column, line + 15, dto.getPayAllowance15No10()); // ^x15No10
		}
		if (null != dto.getPayAllowance16No10()) {
			setValueChk(odsBean, column, line + 16, dto.getPayAllowance16No10()); // ^x16No10
		}
		if (null != dto.getPayAllowance17No10()) {
			setValueChk(odsBean, column, line + 17, dto.getPayAllowance17No10()); // ^x17No10
		}
		if (null != dto.getPayAllowance18No10()) {
			setValueChk(odsBean, column, line + 18, dto.getPayAllowance18No10()); // ^x18No10
		}
		if (null != dto.getPayAllowance19No10()) {
			setValueChk(odsBean, column, line + 19, dto.getPayAllowance19No10()); // ^x19No10
		}
		if (null != dto.getPayAllowance20No10()) {
			setValueChk(odsBean, column, line + 20, dto.getPayAllowance20No10()); // ^x20No10
		}
		if (null != dto.getPayAllowance21No10()) {
			setValueChk(odsBean, column, line + 21, dto.getPayAllowance21No10()); // ^x21No10
		}
		if (null != dto.getPayAllowance22No10()) {
			setValueChk(odsBean, column, line + 22, dto.getPayAllowance22No10()); // ^x22No10
		}
		if (null != dto.getPayAllowance23No10()) {
			setValueChk(odsBean, column, line + 23, dto.getPayAllowance23No10()); // ^x23No10
		}
		if (null != dto.getPayAllowance24No10()) {
			setValueChk(odsBean, column, line + 24, dto.getPayAllowance24No10()); // ^x24No10
		}
		if (null != dto.getPayAllowance25No10()) {
			setValueChk(odsBean, column, line + 25, dto.getPayAllowance25No10()); // ^x25No10
		}
		if (null != dto.getPayAllowance26No10()) {
			setValueChk(odsBean, column, line + 26, dto.getPayAllowance26No10()); // ^x26No10
		}
		if (null != dto.getPayAllowance27No10()) {
			setValueChk(odsBean, column, line + 27, dto.getPayAllowance27No10()); // ^x27No10
		}
		if (null != dto.getPayAllowance28No10()) {
			setValueChk(odsBean, column, line + 28, dto.getPayAllowance28No10()); // ^x28No10
		}
		if (null != dto.getPayAllowance29No10()) {
			setValueChk(odsBean, column, line + 29, dto.getPayAllowance29No10()); // ^x29No10
		}
		if (null != dto.getPayAllowance30No10()) {
			setValueChk(odsBean, column, line + 30, dto.getPayAllowance30No10()); // ^x30No10
		}
		if (null != dto.getPayAllowanceTotal10()) {
			setValueChk(odsBean, column, line + 31, dto.getPayAllowanceTotal10()); // ^xzNo10
		}
		line = 40;
		if (null != dto.getPayDeduction01No10()) {
			setValueChk(odsBean, column, line + 1, dto.getPayDeduction01No10()); // ^T01No10
		}
		if (null != dto.getPayDeduction02No10()) {
			setValueChk(odsBean, column, line + 2, dto.getPayDeduction02No10()); // ^T02No10
		}
		if (null != dto.getPayDeduction03No10()) {
			setValueChk(odsBean, column, line + 3, dto.getPayDeduction03No10()); // ^T03No10
		}
		if (null != dto.getPayDeduction04No10()) {
			setValueChk(odsBean, column, line + 4, dto.getPayDeduction04No10()); // ^T04No10
		}
		if (null != dto.getPayDeduction05No10()) {
			setValueChk(odsBean, column, line + 5, dto.getPayDeduction05No10()); // ^T05No10
		}
		if (null != dto.getPayDeduction06No10()) {
			setValueChk(odsBean, column, line + 6, dto.getPayDeduction06No10()); // ^T06No10
		}
		if (null != dto.getPayDeduction07No10()) {
			setValueChk(odsBean, column, line + 7, dto.getPayDeduction07No10()); // ^T07No10
		}
		if (null != dto.getPayDeduction08No10()) {
			setValueChk(odsBean, column, line + 8, dto.getPayDeduction08No10()); // ^T08No10
		}
		if (null != dto.getPayDeduction09No10()) {
			setValueChk(odsBean, column, line + 9, dto.getPayDeduction09No10()); // ^T09No10
		}
		if (null != dto.getPayDeduction10No10()) {
			setValueChk(odsBean, column, line + 10, dto.getPayDeduction10No10()); // ^T10No10
		}
		if (null != dto.getPayDeduction11No10()) {
			setValueChk(odsBean, column, line + 11, dto.getPayDeduction11No10()); // ^T11No10
		}
		if (null != dto.getPayDeduction12No10()) {
			setValueChk(odsBean, column, line + 12, dto.getPayDeduction12No10()); // ^T12No10
		}
		if (null != dto.getPayDeduction14No10()) {
			setValueChk(odsBean, column, line + 13, dto.getPayDeduction14No10()); // ^T14No10
		}
		if (null != dto.getPayDeduction15No10()) {
			setValueChk(odsBean, column, line + 14, dto.getPayDeduction15No10()); // ^T15No10
		}
		if (null != dto.getPayDeduction16No10()) {
			setValueChk(odsBean, column, line + 15, dto.getPayDeduction16No10()); // ^T16No10
		}
		if (null != dto.getPayDeduction17No10()) {
			setValueChk(odsBean, column, line + 16, dto.getPayDeduction17No10()); // ^T17No10
		}
		if (null != dto.getPayDeduction18No10()) {
			setValueChk(odsBean, column, line + 17, dto.getPayDeduction18No10()); // ^T18No10
		}
		if (null != dto.getPayDeduction19No10()) {
			setValueChk(odsBean, column, line + 18, dto.getPayDeduction19No10()); // ^T19No10
		}
		if (null != dto.getPayDeduction20No10()) {
			setValueChk(odsBean, column, line + 19, dto.getPayDeduction20No10()); // ^T20No10
		}
		if (null != dto.getPayDeduction21No10()) {
			setValueChk(odsBean, column, line + 20, dto.getPayDeduction21No10()); // ^T21No10
		}
		if (null != dto.getPayDeduction22No10()) {
			setValueChk(odsBean, column, line + 21, dto.getPayDeduction22No10()); // ^T22No10
		}
		if (null != dto.getPayDeduction23No10()) {
			setValueChk(odsBean, column, line + 22, dto.getPayDeduction23No10()); // ^T23No10
		}
		if (null != dto.getPayDeduction24No10()) {
			setValueChk(odsBean, column, line + 23, dto.getPayDeduction24No10()); // ^T24No10
		}
		if (null != dto.getPayDeduction25No10()) {
			setValueChk(odsBean, column, line + 24, dto.getPayDeduction25No10()); // ^T25No10
		}
		if (null != dto.getPayDeductionTotal10()) {
			setValueChk(odsBean, column, line + 25, dto.getPayDeductionTotal10()); // ^TzNo10
		}
		if (null != dto.getPayDeduction26No10()) {
			setValueChk(odsBean, column, line + 26, dto.getPayDeduction26No10()); // ^T26No10
		}
		if (null != dto.getPayPaymentTotal10()) {
			setValueChk(odsBean, column, line + 27, dto.getPayPaymentTotal10()); // ^xzNo10
		}
		if (null != dto.getPayBank1PayAmount10()) {
			setValueChk(odsBean, column, line + 28, dto.getPayBank1PayAmount10()); // ^s1UzNo10
		}
		if (null != dto.getPayBank2PayAmount10()) {
			setValueChk(odsBean, column, line + 29, dto.getPayBank2PayAmount10()); // ^s2UzNo10
		}
		if (null != dto.getPayCashPayAmount10()) {
			setValueChk(odsBean, column, line + 30, dto.getPayCashPayAmount10()); // xzNo10
		}
		if (null != dto.getPayDeduction27No10()) {
			setValueChk(odsBean, column, line + 31, dto.getPayDeduction27No10()); // ^T27No10
		}
		
		line = 8;
		column = 33; // 11
		if (null != dto.getPayPayday11()) {
			setValueChk(odsBean, column, line - 1, dto.getPayPayday11()); // ^xNo11
		}
		if (null != dto.getPayAllowance01No11()) {
			setValueChk(odsBean, column, line + 1, dto.getPayAllowance01No11()); // ^x01No11
		}
		if (null != dto.getPayAllowance02No11()) {
			setValueChk(odsBean, column, line + 2, dto.getPayAllowance02No11()); // ^x02No11
		}
		if (null != dto.getPayAllowance03No11()) {
			setValueChk(odsBean, column, line + 3, dto.getPayAllowance03No11()); // ^x03No11
		}
		if (null != dto.getPayAllowance04No11()) {
			setValueChk(odsBean, column, line + 4, dto.getPayAllowance04No11()); // ^x04No11
		}
		if (null != dto.getPayAllowance05No11()) {
			setValueChk(odsBean, column, line + 5, dto.getPayAllowance05No11()); // ^x05No11
		}
		if (null != dto.getPayAllowance06No11()) {
			setValueChk(odsBean, column, line + 6, dto.getPayAllowance06No11()); // ^x06No11
		}
		if (null != dto.getPayAllowance07No11()) {
			setValueChk(odsBean, column, line + 7, dto.getPayAllowance07No11()); // ^x07No11
		}
		if (null != dto.getPayAllowance08No11()) {
			setValueChk(odsBean, column, line + 8, dto.getPayAllowance08No11()); // ^x08No11
		}
		if (null != dto.getPayAllowance09No11()) {
			setValueChk(odsBean, column, line + 9, dto.getPayAllowance09No11()); // ^x09No11
		}
		if (null != dto.getPayAllowance10No11()) {
			setValueChk(odsBean, column, line + 10, dto.getPayAllowance10No11()); // ^x10No11
		}
		if (null != dto.getPayAllowance11No11()) {
			setValueChk(odsBean, column, line + 11, dto.getPayAllowance11No11()); // ^x11No11
		}
		if (null != dto.getPayAllowance12No11()) {
			setValueChk(odsBean, column, line + 12, dto.getPayAllowance12No11()); // ^x12No11
		}
		if (null != dto.getPayAllowance13No11()) {
			setValueChk(odsBean, column, line + 13, dto.getPayAllowance13No11()); // ^x13No11
		}
		if (null != dto.getPayAllowance14No11()) {
			setValueChk(odsBean, column, line + 14, dto.getPayAllowance14No11()); // ^x14No11
		}
		if (null != dto.getPayAllowance15No11()) {
			setValueChk(odsBean, column, line + 15, dto.getPayAllowance15No11()); // ^x15No11
		}
		if (null != dto.getPayAllowance16No11()) {
			setValueChk(odsBean, column, line + 16, dto.getPayAllowance16No11()); // ^x16No11
		}
		if (null != dto.getPayAllowance17No11()) {
			setValueChk(odsBean, column, line + 17, dto.getPayAllowance17No11()); // ^x17No11
		}
		if (null != dto.getPayAllowance18No11()) {
			setValueChk(odsBean, column, line + 18, dto.getPayAllowance18No11()); // ^x18No11
		}
		if (null != dto.getPayAllowance19No11()) {
			setValueChk(odsBean, column, line + 19, dto.getPayAllowance19No11()); // ^x19No11
		}
		if (null != dto.getPayAllowance20No11()) {
			setValueChk(odsBean, column, line + 20, dto.getPayAllowance20No11()); // ^x20No11
		}
		if (null != dto.getPayAllowance21No11()) {
			setValueChk(odsBean, column, line + 21, dto.getPayAllowance21No11()); // ^x21No11
		}
		if (null != dto.getPayAllowance22No11()) {
			setValueChk(odsBean, column, line + 22, dto.getPayAllowance22No11()); // ^x22No11
		}
		if (null != dto.getPayAllowance23No11()) {
			setValueChk(odsBean, column, line + 23, dto.getPayAllowance23No11()); // ^x23No11
		}
		if (null != dto.getPayAllowance24No11()) {
			setValueChk(odsBean, column, line + 24, dto.getPayAllowance24No11()); // ^x24No11
		}
		if (null != dto.getPayAllowance25No11()) {
			setValueChk(odsBean, column, line + 25, dto.getPayAllowance25No11()); // ^x25No11
		}
		if (null != dto.getPayAllowance26No11()) {
			setValueChk(odsBean, column, line + 26, dto.getPayAllowance26No11()); // ^x26No11
		}
		if (null != dto.getPayAllowance27No11()) {
			setValueChk(odsBean, column, line + 27, dto.getPayAllowance27No11()); // ^x27No11
		}
		if (null != dto.getPayAllowance28No11()) {
			setValueChk(odsBean, column, line + 28, dto.getPayAllowance28No11()); // ^x28No11
		}
		if (null != dto.getPayAllowance29No11()) {
			setValueChk(odsBean, column, line + 29, dto.getPayAllowance29No11()); // ^x29No11
		}
		if (null != dto.getPayAllowance30No11()) {
			setValueChk(odsBean, column, line + 30, dto.getPayAllowance30No11()); // ^x30No11
		}
		if (null != dto.getPayAllowanceTotal11()) {
			setValueChk(odsBean, column, line + 31, dto.getPayAllowanceTotal11()); // ^xzNo11
		}
		line = 40;
		if (null != dto.getPayDeduction01No11()) {
			setValueChk(odsBean, column, line + 1, dto.getPayDeduction01No11()); // ^T01No11
		}
		if (null != dto.getPayDeduction02No11()) {
			setValueChk(odsBean, column, line + 2, dto.getPayDeduction02No11()); // ^T02No11
		}
		if (null != dto.getPayDeduction03No11()) {
			setValueChk(odsBean, column, line + 3, dto.getPayDeduction03No11()); // ^T03No11
		}
		if (null != dto.getPayDeduction04No11()) {
			setValueChk(odsBean, column, line + 4, dto.getPayDeduction04No11()); // ^T04No11
		}
		if (null != dto.getPayDeduction05No11()) {
			setValueChk(odsBean, column, line + 5, dto.getPayDeduction05No11()); // ^T05No11
		}
		if (null != dto.getPayDeduction06No11()) {
			setValueChk(odsBean, column, line + 6, dto.getPayDeduction06No11()); // ^T06No11
		}
		if (null != dto.getPayDeduction07No11()) {
			setValueChk(odsBean, column, line + 7, dto.getPayDeduction07No11()); // ^T07No11
		}
		if (null != dto.getPayDeduction08No11()) {
			setValueChk(odsBean, column, line + 8, dto.getPayDeduction08No11()); // ^T08No11
		}
		if (null != dto.getPayDeduction09No11()) {
			setValueChk(odsBean, column, line + 9, dto.getPayDeduction09No11()); // ^T09No11
		}
		if (null != dto.getPayDeduction10No11()) {
			setValueChk(odsBean, column, line + 10, dto.getPayDeduction10No11()); // ^T10No11
		}
		if (null != dto.getPayDeduction11No11()) {
			setValueChk(odsBean, column, line + 11, dto.getPayDeduction11No11()); // ^T11No11
		}
		if (null != dto.getPayDeduction12No11()) {
			setValueChk(odsBean, column, line + 12, dto.getPayDeduction12No11()); // ^T12No11
		}
		if (null != dto.getPayDeduction14No11()) {
			setValueChk(odsBean, column, line + 13, dto.getPayDeduction14No11()); // ^T14No11
		}
		if (null != dto.getPayDeduction15No11()) {
			setValueChk(odsBean, column, line + 14, dto.getPayDeduction15No11()); // ^T15No11
		}
		if (null != dto.getPayDeduction16No11()) {
			setValueChk(odsBean, column, line + 15, dto.getPayDeduction16No11()); // ^T16No11
		}
		if (null != dto.getPayDeduction17No11()) {
			setValueChk(odsBean, column, line + 16, dto.getPayDeduction17No11()); // ^T17No11
		}
		if (null != dto.getPayDeduction18No11()) {
			setValueChk(odsBean, column, line + 17, dto.getPayDeduction18No11()); // ^T18No11
		}
		if (null != dto.getPayDeduction19No11()) {
			setValueChk(odsBean, column, line + 18, dto.getPayDeduction19No11()); // ^T19No11
		}
		if (null != dto.getPayDeduction20No11()) {
			setValueChk(odsBean, column, line + 19, dto.getPayDeduction20No11()); // ^T20No11
		}
		if (null != dto.getPayDeduction21No11()) {
			setValueChk(odsBean, column, line + 20, dto.getPayDeduction21No11()); // ^T21No11
		}
		if (null != dto.getPayDeduction22No11()) {
			setValueChk(odsBean, column, line + 21, dto.getPayDeduction22No11()); // ^T22No11
		}
		if (null != dto.getPayDeduction23No11()) {
			setValueChk(odsBean, column, line + 22, dto.getPayDeduction23No11()); // ^T23No11
		}
		if (null != dto.getPayDeduction24No11()) {
			setValueChk(odsBean, column, line + 23, dto.getPayDeduction24No11()); // ^T24No11
		}
		if (null != dto.getPayDeduction25No11()) {
			setValueChk(odsBean, column, line + 24, dto.getPayDeduction25No11()); // ^T25No11
		}
		if (null != dto.getPayDeductionTotal11()) {
			setValueChk(odsBean, column, line + 25, dto.getPayDeductionTotal11()); // ^TzNo11
		}
		if (null != dto.getPayDeduction26No11()) {
			setValueChk(odsBean, column, line + 26, dto.getPayDeduction26No11()); // ^T26No11
		}
		if (null != dto.getPayPaymentTotal11()) {
			setValueChk(odsBean, column, line + 27, dto.getPayPaymentTotal11()); // ^xzNo11
		}
		if (null != dto.getPayBank1PayAmount11()) {
			setValueChk(odsBean, column, line + 28, dto.getPayBank1PayAmount11()); // ^s1UzNo11
		}
		if (null != dto.getPayBank2PayAmount11()) {
			setValueChk(odsBean, column, line + 29, dto.getPayBank2PayAmount11()); // ^s2UzNo11
		}
		if (null != dto.getPayCashPayAmount11()) {
			setValueChk(odsBean, column, line + 30, dto.getPayCashPayAmount11()); // xzNo11
		}
		if (null != dto.getPayDeduction27No11()) {
			setValueChk(odsBean, column, line + 31, dto.getPayDeduction27No11()); // ^T27No11
		}
		
		line = 8;
		column = 36; // 12
		if (null != dto.getPayPayday12()) {
			setValueChk(odsBean, column, line - 1, dto.getPayPayday12()); // ^xNo12
		}
		if (null != dto.getPayAllowance01No12()) {
			setValueChk(odsBean, column, line + 1, dto.getPayAllowance01No12()); // ^x01No12
		}
		if (null != dto.getPayAllowance02No12()) {
			setValueChk(odsBean, column, line + 2, dto.getPayAllowance02No12()); // ^x02No12
		}
		if (null != dto.getPayAllowance03No12()) {
			setValueChk(odsBean, column, line + 3, dto.getPayAllowance03No12()); // ^x03No12
		}
		if (null != dto.getPayAllowance04No12()) {
			setValueChk(odsBean, column, line + 4, dto.getPayAllowance04No12()); // ^x04No12
		}
		if (null != dto.getPayAllowance05No12()) {
			setValueChk(odsBean, column, line + 5, dto.getPayAllowance05No12()); // ^x05No12
		}
		if (null != dto.getPayAllowance06No12()) {
			setValueChk(odsBean, column, line + 6, dto.getPayAllowance06No12()); // ^x06No12
		}
		if (null != dto.getPayAllowance07No12()) {
			setValueChk(odsBean, column, line + 7, dto.getPayAllowance07No12()); // ^x07No12
		}
		if (null != dto.getPayAllowance08No12()) {
			setValueChk(odsBean, column, line + 8, dto.getPayAllowance08No12()); // ^x08No12
		}
		if (null != dto.getPayAllowance09No12()) {
			setValueChk(odsBean, column, line + 9, dto.getPayAllowance09No12()); // ^x09No12
		}
		if (null != dto.getPayAllowance10No12()) {
			setValueChk(odsBean, column, line + 10, dto.getPayAllowance10No12()); // ^x10No12
		}
		if (null != dto.getPayAllowance11No12()) {
			setValueChk(odsBean, column, line + 11, dto.getPayAllowance11No12()); // ^x11No12
		}
		if (null != dto.getPayAllowance12No12()) {
			setValueChk(odsBean, column, line + 12, dto.getPayAllowance12No12()); // ^x12No12
		}
		if (null != dto.getPayAllowance13No12()) {
			setValueChk(odsBean, column, line + 13, dto.getPayAllowance13No12()); // ^x13No12
		}
		if (null != dto.getPayAllowance14No12()) {
			setValueChk(odsBean, column, line + 14, dto.getPayAllowance14No12()); // ^x14No12
		}
		if (null != dto.getPayAllowance15No12()) {
			setValueChk(odsBean, column, line + 15, dto.getPayAllowance15No12()); // ^x15No12
		}
		if (null != dto.getPayAllowance16No12()) {
			setValueChk(odsBean, column, line + 16, dto.getPayAllowance16No12()); // ^x16No12
		}
		if (null != dto.getPayAllowance17No12()) {
			setValueChk(odsBean, column, line + 17, dto.getPayAllowance17No12()); // ^x17No12
		}
		if (null != dto.getPayAllowance18No12()) {
			setValueChk(odsBean, column, line + 18, dto.getPayAllowance18No12()); // ^x18No12
		}
		if (null != dto.getPayAllowance19No12()) {
			setValueChk(odsBean, column, line + 19, dto.getPayAllowance19No12()); // ^x19No12
		}
		if (null != dto.getPayAllowance20No12()) {
			setValueChk(odsBean, column, line + 20, dto.getPayAllowance20No12()); // ^x20No12
		}
		if (null != dto.getPayAllowance21No12()) {
			setValueChk(odsBean, column, line + 21, dto.getPayAllowance21No12()); // ^x21No12
		}
		if (null != dto.getPayAllowance22No12()) {
			setValueChk(odsBean, column, line + 22, dto.getPayAllowance22No12()); // ^x22No12
		}
		if (null != dto.getPayAllowance23No12()) {
			setValueChk(odsBean, column, line + 23, dto.getPayAllowance23No12()); // ^x23No12
		}
		if (null != dto.getPayAllowance24No12()) {
			setValueChk(odsBean, column, line + 24, dto.getPayAllowance24No12()); // ^x24No12
		}
		if (null != dto.getPayAllowance25No12()) {
			setValueChk(odsBean, column, line + 25, dto.getPayAllowance25No12()); // ^x25No12
		}
		if (null != dto.getPayAllowance26No12()) {
			setValueChk(odsBean, column, line + 26, dto.getPayAllowance26No12()); // ^x26No12
		}
		if (null != dto.getPayAllowance27No12()) {
			setValueChk(odsBean, column, line + 27, dto.getPayAllowance27No12()); // ^x27No12
		}
		if (null != dto.getPayAllowance28No12()) {
			setValueChk(odsBean, column, line + 28, dto.getPayAllowance28No12()); // ^x28No12
		}
		if (null != dto.getPayAllowance29No12()) {
			setValueChk(odsBean, column, line + 29, dto.getPayAllowance29No12()); // ^x29No12
		}
		if (null != dto.getPayAllowance30No12()) {
			setValueChk(odsBean, column, line + 30, dto.getPayAllowance30No12()); // ^x30No12
		}
		if (null != dto.getPayAllowanceTotal12()) {
			setValueChk(odsBean, column, line + 31, dto.getPayAllowanceTotal12()); // ^xzNo12
		}
		line = 40;
		if (null != dto.getPayDeduction01No12()) {
			setValueChk(odsBean, column, line + 1, dto.getPayDeduction01No12()); // ^T01No12
		}
		if (null != dto.getPayDeduction02No12()) {
			setValueChk(odsBean, column, line + 2, dto.getPayDeduction02No12()); // ^T02No12
		}
		if (null != dto.getPayDeduction03No12()) {
			setValueChk(odsBean, column, line + 3, dto.getPayDeduction03No12()); // ^T03No12
		}
		if (null != dto.getPayDeduction04No12()) {
			setValueChk(odsBean, column, line + 4, dto.getPayDeduction04No12()); // ^T04No12
		}
		if (null != dto.getPayDeduction05No12()) {
			setValueChk(odsBean, column, line + 5, dto.getPayDeduction05No12()); // ^T05No12
		}
		if (null != dto.getPayDeduction06No12()) {
			setValueChk(odsBean, column, line + 6, dto.getPayDeduction06No12()); // ^T06No12
		}
		if (null != dto.getPayDeduction07No12()) {
			setValueChk(odsBean, column, line + 7, dto.getPayDeduction07No12()); // ^T07No12
		}
		if (null != dto.getPayDeduction08No12()) {
			setValueChk(odsBean, column, line + 8, dto.getPayDeduction08No12()); // ^T08No12
		}
		if (null != dto.getPayDeduction09No12()) {
			setValueChk(odsBean, column, line + 9, dto.getPayDeduction09No12()); // ^T09No12
		}
		if (null != dto.getPayDeduction10No12()) {
			setValueChk(odsBean, column, line + 10, dto.getPayDeduction10No12()); // ^T10No12
		}
		if (null != dto.getPayDeduction11No12()) {
			setValueChk(odsBean, column, line + 11, dto.getPayDeduction11No12()); // ^T11No12
		}
		if (null != dto.getPayDeduction12No12()) {
			setValueChk(odsBean, column, line + 12, dto.getPayDeduction12No12()); // ^T12No12
		}
		if (null != dto.getPayDeduction14No12()) {
			setValueChk(odsBean, column, line + 13, dto.getPayDeduction14No12()); // ^T14No12
		}
		if (null != dto.getPayDeduction15No12()) {
			setValueChk(odsBean, column, line + 14, dto.getPayDeduction15No12()); // ^T15No12
		}
		if (null != dto.getPayDeduction16No12()) {
			setValueChk(odsBean, column, line + 15, dto.getPayDeduction16No12()); // ^T16No12
		}
		if (null != dto.getPayDeduction17No12()) {
			setValueChk(odsBean, column, line + 16, dto.getPayDeduction17No12()); // ^T17No12
		}
		if (null != dto.getPayDeduction18No12()) {
			setValueChk(odsBean, column, line + 17, dto.getPayDeduction18No12()); // ^T18No12
		}
		if (null != dto.getPayDeduction19No12()) {
			setValueChk(odsBean, column, line + 18, dto.getPayDeduction19No12()); // ^T19No12
		}
		if (null != dto.getPayDeduction20No12()) {
			setValueChk(odsBean, column, line + 19, dto.getPayDeduction20No12()); // ^T20No12
		}
		if (null != dto.getPayDeduction21No12()) {
			setValueChk(odsBean, column, line + 20, dto.getPayDeduction21No12()); // ^T21No12
		}
		if (null != dto.getPayDeduction22No12()) {
			setValueChk(odsBean, column, line + 21, dto.getPayDeduction22No12()); // ^T22No12
		}
		if (null != dto.getPayDeduction23No12()) {
			setValueChk(odsBean, column, line + 22, dto.getPayDeduction23No12()); // ^T23No12
		}
		if (null != dto.getPayDeduction24No12()) {
			setValueChk(odsBean, column, line + 23, dto.getPayDeduction24No12()); // ^T24No12
		}
		if (null != dto.getPayDeduction25No12()) {
			setValueChk(odsBean, column, line + 24, dto.getPayDeduction25No12()); // ^T25No12
		}
		if (null != dto.getPayDeductionTotal12()) {
			setValueChk(odsBean, column, line + 25, dto.getPayDeductionTotal12()); // ^TzNo12
		}
		if (null != dto.getPayDeduction26No12()) {
			setValueChk(odsBean, column, line + 26, dto.getPayDeduction26No12()); // ^T26No12
		}
		if (null != dto.getPayPaymentTotal12()) {
			setValueChk(odsBean, column, line + 27, dto.getPayPaymentTotal12()); // ^xzNo12
		}
		if (null != dto.getPayBank1PayAmount12()) {
			setValueChk(odsBean, column, line + 28, dto.getPayBank1PayAmount12()); // ^s1UzNo12
		}
		if (null != dto.getPayBank2PayAmount12()) {
			setValueChk(odsBean, column, line + 29, dto.getPayBank2PayAmount12()); // ^s2UzNo12
		}
		if (null != dto.getPayCashPayAmount12()) {
			setValueChk(odsBean, column, line + 30, dto.getPayCashPayAmount12()); // xzNo12
		}
		if (null != dto.getPayDeduction27No12()) {
			setValueChk(odsBean, column, line + 31, dto.getPayDeduction27No12()); // ^T27No12
		}
		
		line = 8;
		column = 39; // Nԍv
		if (null != dto.getPayTotalAllowance01()) {
			setValueChk(odsBean, column, line + 1, dto.getPayTotalAllowance01()); // ^x01v
		}
		if (null != dto.getPayTotalAllowance02()) {
			setValueChk(odsBean, column, line + 2, dto.getPayTotalAllowance02()); // ^x02v
		}
		if (null != dto.getPayTotalAllowance03()) {
			setValueChk(odsBean, column, line + 3, dto.getPayTotalAllowance03()); // ^x03v
		}
		if (null != dto.getPayTotalAllowance04()) {
			setValueChk(odsBean, column, line + 4, dto.getPayTotalAllowance04()); // ^x04v
		}
		if (null != dto.getPayTotalAllowance05()) {
			setValueChk(odsBean, column, line + 5, dto.getPayTotalAllowance05()); // ^x05v
		}
		if (null != dto.getPayTotalAllowance06()) {
			setValueChk(odsBean, column, line + 6, dto.getPayTotalAllowance06()); // ^x06v
		}
		if (null != dto.getPayTotalAllowance07()) {
			setValueChk(odsBean, column, line + 7, dto.getPayTotalAllowance07()); // ^x07v
		}
		if (null != dto.getPayTotalAllowance08()) {
			setValueChk(odsBean, column, line + 8, dto.getPayTotalAllowance08()); // ^x08v
		}
		if (null != dto.getPayTotalAllowance09()) {
			setValueChk(odsBean, column, line + 9, dto.getPayTotalAllowance09()); // ^x09v
		}
		if (null != dto.getPayTotalAllowance10()) {
			setValueChk(odsBean, column, line + 10, dto.getPayTotalAllowance10()); // ^x10v
		}
		if (null != dto.getPayTotalAllowance11()) {
			setValueChk(odsBean, column, line + 11, dto.getPayTotalAllowance11()); // ^x11v
		}
		if (null != dto.getPayTotalAllowance12()) {
			setValueChk(odsBean, column, line + 12, dto.getPayTotalAllowance12()); // ^x12v
		}
		if (null != dto.getPayTotalAllowance13()) {
			setValueChk(odsBean, column, line + 13, dto.getPayTotalAllowance13()); // ^x13v
		}
		if (null != dto.getPayTotalAllowance14()) {
			setValueChk(odsBean, column, line + 14, dto.getPayTotalAllowance14()); // ^x14v
		}
		if (null != dto.getPayTotalAllowance15()) {
			setValueChk(odsBean, column, line + 15, dto.getPayTotalAllowance15()); // ^x15v
		}
		if (null != dto.getPayTotalAllowance16()) {
			setValueChk(odsBean, column, line + 16, dto.getPayTotalAllowance16()); // ^x16v
		}
		if (null != dto.getPayTotalAllowance17()) {
			setValueChk(odsBean, column, line + 17, dto.getPayTotalAllowance17()); // ^x17v
		}
		if (null != dto.getPayTotalAllowance18()) {
			setValueChk(odsBean, column, line + 18, dto.getPayTotalAllowance18()); // ^x18v
		}
		if (null != dto.getPayTotalAllowance19()) {
			setValueChk(odsBean, column, line + 19, dto.getPayTotalAllowance19()); // ^x19v
		}
		if (null != dto.getPayTotalAllowance20()) {
			setValueChk(odsBean, column, line + 20, dto.getPayTotalAllowance20()); // ^x20v
		}
		if (null != dto.getPayTotalAllowance21()) {
			setValueChk(odsBean, column, line + 21, dto.getPayTotalAllowance21()); // ^x21v
		}
		if (null != dto.getPayTotalAllowance22()) {
			setValueChk(odsBean, column, line + 22, dto.getPayTotalAllowance22()); // ^x22v
		}
		if (null != dto.getPayTotalAllowance23()) {
			setValueChk(odsBean, column, line + 23, dto.getPayTotalAllowance23()); // ^x23v
		}
		if (null != dto.getPayTotalAllowance24()) {
			setValueChk(odsBean, column, line + 24, dto.getPayTotalAllowance24()); // ^x24v
		}
		if (null != dto.getPayTotalAllowance25()) {
			setValueChk(odsBean, column, line + 25, dto.getPayTotalAllowance25()); // ^x25v
		}
		if (null != dto.getPayTotalAllowance26()) {
			setValueChk(odsBean, column, line + 26, dto.getPayTotalAllowance26()); // ^x26v
		}
		if (null != dto.getPayTotalAllowance27()) {
			setValueChk(odsBean, column, line + 27, dto.getPayTotalAllowance27()); // ^x27v
		}
		if (null != dto.getPayTotalAllowance28()) {
			setValueChk(odsBean, column, line + 28, dto.getPayTotalAllowance28()); // ^x28v
		}
		if (null != dto.getPayTotalAllowance29()) {
			setValueChk(odsBean, column, line + 29, dto.getPayTotalAllowance29()); // ^x29v
		}
		if (null != dto.getPayTotalAllowance30()) {
			setValueChk(odsBean, column, line + 30, dto.getPayTotalAllowance30()); // ^x30v
		}
		if (null != dto.getPayTotalAllowanceTotal()) {
			setValueChk(odsBean, column, line + 31, dto.getPayTotalAllowanceTotal()); // ^xzv
		}
		line = 40;
		if (null != dto.getPayTotalDeduction01()) {
			setValueChk(odsBean, column, line + 1, dto.getPayTotalDeduction01()); // ^T01v
		}
		if (null != dto.getPayTotalDeduction02()) {
			setValueChk(odsBean, column, line + 2, dto.getPayTotalDeduction02()); // ^T02v
		}
		if (null != dto.getPayTotalDeduction03()) {
			setValueChk(odsBean, column, line + 3, dto.getPayTotalDeduction03()); // ^T03v
		}
		if (null != dto.getPayTotalDeduction04()) {
			setValueChk(odsBean, column, line + 4, dto.getPayTotalDeduction04()); // ^T04v
		}
		if (null != dto.getPayTotalDeduction05()) {
			setValueChk(odsBean, column, line + 5, dto.getPayTotalDeduction05()); // ^T05v
		}
		if (null != dto.getPayTotalDeduction06()) {
			setValueChk(odsBean, column, line + 6, dto.getPayTotalDeduction06()); // ^T06v
		}
		if (null != dto.getPayTotalDeduction07()) {
			setValueChk(odsBean, column, line + 7, dto.getPayTotalDeduction07()); // ^T07v
		}
		if (null != dto.getPayTotalDeduction08()) {
			setValueChk(odsBean, column, line + 8, dto.getPayTotalDeduction08()); // ^T08v
		}
		if (null != dto.getPayTotalDeduction09()) {
			setValueChk(odsBean, column, line + 9, dto.getPayTotalDeduction09()); // ^T09v
		}
		if (null != dto.getPayTotalDeduction10()) {
			setValueChk(odsBean, column, line + 10, dto.getPayTotalDeduction10()); // ^T10v
		}
		if (null != dto.getPayTotalDeduction11()) {
			setValueChk(odsBean, column, line + 11, dto.getPayTotalDeduction11()); // ^T11v
		}
		if (null != dto.getPayTotalDeduction12()) {
			setValueChk(odsBean, column, line + 12, dto.getPayTotalDeduction12()); // ^T12v
		}
		if (null != dto.getPayTotalDeduction14()) {
			setValueChk(odsBean, column, line + 13, dto.getPayTotalDeduction14()); // ^T14v
		}
		if (null != dto.getPayTotalDeduction15()) {
			setValueChk(odsBean, column, line + 14, dto.getPayTotalDeduction15()); // ^T15v
		}
		if (null != dto.getPayTotalDeduction16()) {
			setValueChk(odsBean, column, line + 15, dto.getPayTotalDeduction16()); // ^T16v
		}
		if (null != dto.getPayTotalDeduction17()) {
			setValueChk(odsBean, column, line + 16, dto.getPayTotalDeduction17()); // ^T17v
		}
		if (null != dto.getPayTotalDeduction18()) {
			setValueChk(odsBean, column, line + 17, dto.getPayTotalDeduction18()); // ^T18v
		}
		if (null != dto.getPayTotalDeduction19()) {
			setValueChk(odsBean, column, line + 18, dto.getPayTotalDeduction19()); // ^T19v
		}
		if (null != dto.getPayTotalDeduction20()) {
			setValueChk(odsBean, column, line + 19, dto.getPayTotalDeduction20()); // ^T20v
		}
		if (null != dto.getPayTotalDeduction21()) {
			setValueChk(odsBean, column, line + 20, dto.getPayTotalDeduction21()); // ^T21v
		}
		if (null != dto.getPayTotalDeduction22()) {
			setValueChk(odsBean, column, line + 21, dto.getPayTotalDeduction22()); // ^T22v
		}
		if (null != dto.getPayTotalDeduction23()) {
			setValueChk(odsBean, column, line + 22, dto.getPayTotalDeduction23()); // ^T23v
		}
		if (null != dto.getPayTotalDeduction24()) {
			setValueChk(odsBean, column, line + 23, dto.getPayTotalDeduction24()); // ^T24v
		}
		if (null != dto.getPayTotalDeduction25()) {
			setValueChk(odsBean, column, line + 24, dto.getPayTotalDeduction25()); // ^T25v
		}
		if (null != dto.getPayTotalDeductionTotal()) {
			setValueChk(odsBean, column, line + 25, dto.getPayTotalDeductionTotal()); // ^Tzv
		}
		if (null != dto.getPayTotalDeduction26()) {
			setValueChk(odsBean, column, line + 26, dto.getPayTotalDeduction26()); // ^T26v
		}
		if (null != dto.getPayTotalPaymentTotal()) {
			setValueChk(odsBean, column, line + 27, dto.getPayTotalPaymentTotal()); // ^xzv
		}
		if (null != dto.getPayTotalBank1PayAmount()) {
			setValueChk(odsBean, column, line + 28, dto.getPayTotalBank1PayAmount()); // ^s1Uzv
		}
		if (null != dto.getPayTotalBank2PayAmount()) {
			setValueChk(odsBean, column, line + 29, dto.getPayTotalBank2PayAmount()); // ^s2Uzv
		}
		if (null != dto.getPayTotalCashPayAmount()) {
			setValueChk(odsBean, column, line + 30, dto.getPayTotalCashPayAmount()); // xzv
		}
		if (null != dto.getPayTotalDeduction27()) {
			setValueChk(odsBean, column, line + 31, dto.getPayTotalDeduction27()); // ^T27v
		}
		
		/** ΑӍڏo **/
		// ږo
		line = 80;
		column = 0;
		setValueChk(odsBean, column + 0, line + 1, dto.getTitleAttendance01()); // ΑӍ01^Cg
		setValueChk(odsBean, column + 0, line + 2, dto.getTitleAttendance02()); // ΑӍ02^Cg
		setValueChk(odsBean, column + 0, line + 3, dto.getTitleAttendance03()); // ΑӍ03^Cg
		setValueChk(odsBean, column + 0, line + 4, dto.getTitleAttendance04()); // ΑӍ04^Cg
		setValueChk(odsBean, column + 0, line + 5, dto.getTitleAttendance05()); // ΑӍ05^Cg
		setValueChk(odsBean, column + 0, line + 6, dto.getTitleAttendance06()); // ΑӍ06^Cg
		setValueChk(odsBean, column + 0, line + 7, dto.getTitleAttendance07()); // ΑӍ07^Cg
		setValueChk(odsBean, column + 0, line + 8, dto.getTitleAttendance08()); // ΑӍ08^Cg
		setValueChk(odsBean, column + 0, line + 9, dto.getTitleAttendance09()); // ΑӍ09^Cg
		setValueChk(odsBean, column + 0, line + 10, dto.getTitleAttendance10()); // ΑӍ10^Cg
		
		// ΑӖ׏o
		line = 80;
		column = 3; // 1
		if (null != dto.getPayPayday01()) {
			setValueChk(odsBean, column, line + 0, dto.getPayPayday01()); // ^xNo01
		}
		if (null != dto.getAttendance01No01()) {
			setValueChk(odsBean, column, line + 1, dto.getAttendance01No01()); // ΑӍ01No01
		}
		if (null != dto.getAttendance02No01()) {
			setValueChk(odsBean, column, line + 2, dto.getAttendance02No01()); // ΑӍ02No01
		}
		if (null != dto.getAttendance03No01()) {
			setValueChk(odsBean, column, line + 3, dto.getAttendance03No01()); // ΑӍ03No01
		}
		if (null != dto.getAttendance04No01()) {
			setValueChk(odsBean, column, line + 4, dto.getAttendance04No01()); // ΑӍ04No01
		}
		if (null != dto.getAttendance05No01()) {
			setValueChk(odsBean, column, line + 5, dto.getAttendance05No01()); // ΑӍ05No01
		}
		if (null != dto.getAttendance06No01()) {
			setValueChk(odsBean, column, line + 6, dto.getAttendance06No01()); // ΑӍ06No01
		}
		if (null != dto.getAttendance07No01()) {
			setValueChk(odsBean, column, line + 7, dto.getAttendance07No01()); // ΑӍ07No01
		}
		if (null != dto.getAttendance08No01()) {
			setValueChk(odsBean, column, line + 8, dto.getAttendance08No01()); // ΑӍ08No01
		}
		if (null != dto.getAttendance09No01()) {
			setValueChk(odsBean, column, line + 9, dto.getAttendance09No01()); // ΑӍ09No01
		}
		if (null != dto.getAttendance10No01()) {
			setValueChk(odsBean, column, line + 10, dto.getAttendance10No01()); // ΑӍ00No01
		}
		if (null != dto.getAttendance11No01()) {
			setValueChk(odsBean, column, line + 11, dto.getAttendance11No01()); // ΑӍ01No01
		}
		if (null != dto.getAttendance12No01()) {
			setValueChk(odsBean, column, line + 12, dto.getAttendance12No01()); // ΑӍ02No01
		}
		if (null != dto.getAttendance13No01()) {
			setValueChk(odsBean, column, line + 13, dto.getAttendance13No01()); // ΑӍ03No01
		}
		if (null != dto.getAttendance14No01()) {
			setValueChk(odsBean, column, line + 14, dto.getAttendance14No01()); // ΑӍ04No01
		}
		
		line = 80;
		column = 6; // 2
		if (null != dto.getPayPayday02()) {
			setValueChk(odsBean, column, line + 0, dto.getPayPayday02()); // ^xNo02
		}
		if (null != dto.getAttendance01No02()) {
			setValueChk(odsBean, column, line + 1, dto.getAttendance01No02()); // ΑӍ01No02
		}
		if (null != dto.getAttendance02No02()) {
			setValueChk(odsBean, column, line + 2, dto.getAttendance02No02()); // ΑӍ02No02
		}
		if (null != dto.getAttendance03No02()) {
			setValueChk(odsBean, column, line + 3, dto.getAttendance03No02()); // ΑӍ03No02
		}
		if (null != dto.getAttendance04No02()) {
			setValueChk(odsBean, column, line + 4, dto.getAttendance04No02()); // ΑӍ04No02
		}
		if (null != dto.getAttendance05No02()) {
			setValueChk(odsBean, column, line + 5, dto.getAttendance05No02()); // ΑӍ05No02
		}
		if (null != dto.getAttendance06No02()) {
			setValueChk(odsBean, column, line + 6, dto.getAttendance06No02()); // ΑӍ06No02
		}
		if (null != dto.getAttendance07No02()) {
			setValueChk(odsBean, column, line + 7, dto.getAttendance07No02()); // ΑӍ07No02
		}
		if (null != dto.getAttendance08No02()) {
			setValueChk(odsBean, column, line + 8, dto.getAttendance08No02()); // ΑӍ08No02
		}
		if (null != dto.getAttendance09No02()) {
			setValueChk(odsBean, column, line + 9, dto.getAttendance09No02()); // ΑӍ09No02
		}
		if (null != dto.getAttendance10No02()) {
			setValueChk(odsBean, column, line + 10, dto.getAttendance10No02()); // ΑӍ00No02
		}
		if (null != dto.getAttendance11No02()) {
			setValueChk(odsBean, column, line + 11, dto.getAttendance11No02()); // ΑӍ01No02
		}
		if (null != dto.getAttendance12No02()) {
			setValueChk(odsBean, column, line + 12, dto.getAttendance12No02()); // ΑӍ02No02
		}
		if (null != dto.getAttendance13No02()) {
			setValueChk(odsBean, column, line + 13, dto.getAttendance13No02()); // ΑӍ03No02
		}
		if (null != dto.getAttendance14No02()) {
			setValueChk(odsBean, column, line + 14, dto.getAttendance14No02()); // ΑӍ04No02
		}
		
		line = 80;
		column = 9; // 3
		if (null != dto.getPayPayday03()) {
			setValueChk(odsBean, column, line + 0, dto.getPayPayday03()); // ^xNo03
		}
		if (null != dto.getAttendance01No03()) {
			setValueChk(odsBean, column, line + 1, dto.getAttendance01No03()); // ΑӍ01No03
		}
		if (null != dto.getAttendance02No03()) {
			setValueChk(odsBean, column, line + 2, dto.getAttendance02No03()); // ΑӍ02No03
		}
		if (null != dto.getAttendance03No03()) {
			setValueChk(odsBean, column, line + 3, dto.getAttendance03No03()); // ΑӍ03No03
		}
		if (null != dto.getAttendance04No03()) {
			setValueChk(odsBean, column, line + 4, dto.getAttendance04No03()); // ΑӍ04No03
		}
		if (null != dto.getAttendance05No03()) {
			setValueChk(odsBean, column, line + 5, dto.getAttendance05No03()); // ΑӍ05No03
		}
		if (null != dto.getAttendance06No03()) {
			setValueChk(odsBean, column, line + 6, dto.getAttendance06No03()); // ΑӍ06No03
		}
		if (null != dto.getAttendance07No03()) {
			setValueChk(odsBean, column, line + 7, dto.getAttendance07No03()); // ΑӍ07No03
		}
		if (null != dto.getAttendance08No03()) {
			setValueChk(odsBean, column, line + 8, dto.getAttendance08No03()); // ΑӍ08No03
		}
		if (null != dto.getAttendance09No03()) {
			setValueChk(odsBean, column, line + 9, dto.getAttendance09No03()); // ΑӍ09No03
		}
		if (null != dto.getAttendance10No03()) {
			setValueChk(odsBean, column, line + 10, dto.getAttendance10No03()); // ΑӍ00No03
		}
		if (null != dto.getAttendance11No03()) {
			setValueChk(odsBean, column, line + 11, dto.getAttendance11No03()); // ΑӍ01No03
		}
		if (null != dto.getAttendance12No03()) {
			setValueChk(odsBean, column, line + 12, dto.getAttendance12No03()); // ΑӍ02No03
		}
		if (null != dto.getAttendance13No03()) {
			setValueChk(odsBean, column, line + 13, dto.getAttendance13No03()); // ΑӍ03No03
		}
		if (null != dto.getAttendance14No03()) {
			setValueChk(odsBean, column, line + 14, dto.getAttendance14No03()); // ΑӍ04No03
		}
		
		line = 80;
		column = 12; // 4
		if (null != dto.getPayPayday04()) {
			setValueChk(odsBean, column, line + 0, dto.getPayPayday04()); // ^xNo04
		}
		if (null != dto.getAttendance01No04()) {
			setValueChk(odsBean, column, line + 1, dto.getAttendance01No04()); // ΑӍ01No04
		}
		if (null != dto.getAttendance02No04()) {
			setValueChk(odsBean, column, line + 2, dto.getAttendance02No04()); // ΑӍ02No04
		}
		if (null != dto.getAttendance03No04()) {
			setValueChk(odsBean, column, line + 3, dto.getAttendance03No04()); // ΑӍ03No04
		}
		if (null != dto.getAttendance04No04()) {
			setValueChk(odsBean, column, line + 4, dto.getAttendance04No04()); // ΑӍ04No04
		}
		if (null != dto.getAttendance05No04()) {
			setValueChk(odsBean, column, line + 5, dto.getAttendance05No04()); // ΑӍ05No04
		}
		if (null != dto.getAttendance06No04()) {
			setValueChk(odsBean, column, line + 6, dto.getAttendance06No04()); // ΑӍ06No04
		}
		if (null != dto.getAttendance07No04()) {
			setValueChk(odsBean, column, line + 7, dto.getAttendance07No04()); // ΑӍ07No04
		}
		if (null != dto.getAttendance08No04()) {
			setValueChk(odsBean, column, line + 8, dto.getAttendance08No04()); // ΑӍ08No04
		}
		if (null != dto.getAttendance09No04()) {
			setValueChk(odsBean, column, line + 9, dto.getAttendance09No04()); // ΑӍ09No04
		}
		if (null != dto.getAttendance10No04()) {
			setValueChk(odsBean, column, line + 10, dto.getAttendance10No04()); // ΑӍ00No04
		}
		if (null != dto.getAttendance11No04()) {
			setValueChk(odsBean, column, line + 11, dto.getAttendance11No04()); // ΑӍ01No04
		}
		if (null != dto.getAttendance12No04()) {
			setValueChk(odsBean, column, line + 12, dto.getAttendance12No04()); // ΑӍ02No04
		}
		if (null != dto.getAttendance13No04()) {
			setValueChk(odsBean, column, line + 13, dto.getAttendance13No04()); // ΑӍ03No04
		}
		if (null != dto.getAttendance14No04()) {
			setValueChk(odsBean, column, line + 14, dto.getAttendance14No04()); // ΑӍ04No04
		}
		
		line = 80;
		column = 15; // 5
		if (null != dto.getPayPayday05()) {
			setValueChk(odsBean, column, line + 0, dto.getPayPayday05()); // ^xNo05
		}
		if (null != dto.getAttendance01No05()) {
			setValueChk(odsBean, column, line + 1, dto.getAttendance01No05()); // ΑӍ01No05
		}
		if (null != dto.getAttendance02No05()) {
			setValueChk(odsBean, column, line + 2, dto.getAttendance02No05()); // ΑӍ02No05
		}
		if (null != dto.getAttendance03No05()) {
			setValueChk(odsBean, column, line + 3, dto.getAttendance03No05()); // ΑӍ03No05
		}
		if (null != dto.getAttendance04No05()) {
			setValueChk(odsBean, column, line + 4, dto.getAttendance04No05()); // ΑӍ04No05
		}
		if (null != dto.getAttendance05No05()) {
			setValueChk(odsBean, column, line + 5, dto.getAttendance05No05()); // ΑӍ05No05
		}
		if (null != dto.getAttendance06No05()) {
			setValueChk(odsBean, column, line + 6, dto.getAttendance06No05()); // ΑӍ06No05
		}
		if (null != dto.getAttendance07No05()) {
			setValueChk(odsBean, column, line + 7, dto.getAttendance07No05()); // ΑӍ07No05
		}
		if (null != dto.getAttendance08No05()) {
			setValueChk(odsBean, column, line + 8, dto.getAttendance08No05()); // ΑӍ08No05
		}
		if (null != dto.getAttendance09No05()) {
			setValueChk(odsBean, column, line + 9, dto.getAttendance09No05()); // ΑӍ09No05
		}
		if (null != dto.getAttendance10No05()) {
			setValueChk(odsBean, column, line + 10, dto.getAttendance10No05()); // ΑӍ00No05
		}
		if (null != dto.getAttendance11No05()) {
			setValueChk(odsBean, column, line + 11, dto.getAttendance11No05()); // ΑӍ01No05
		}
		if (null != dto.getAttendance12No05()) {
			setValueChk(odsBean, column, line + 12, dto.getAttendance12No05()); // ΑӍ02No05
		}
		if (null != dto.getAttendance13No05()) {
			setValueChk(odsBean, column, line + 13, dto.getAttendance13No05()); // ΑӍ03No05
		}
		if (null != dto.getAttendance14No05()) {
			setValueChk(odsBean, column, line + 14, dto.getAttendance14No05()); // ΑӍ04No05
		}
		
		line = 80;
		column = 18; // 6
		if (null != dto.getPayPayday06()) {
			setValueChk(odsBean, column, line + 0, dto.getPayPayday06()); // ^xNo06
		}
		if (null != dto.getAttendance01No06()) {
			setValueChk(odsBean, column, line + 1, dto.getAttendance01No06()); // ΑӍ01No06
		}
		if (null != dto.getAttendance02No06()) {
			setValueChk(odsBean, column, line + 2, dto.getAttendance02No06()); // ΑӍ02No06
		}
		if (null != dto.getAttendance03No06()) {
			setValueChk(odsBean, column, line + 3, dto.getAttendance03No06()); // ΑӍ03No06
		}
		if (null != dto.getAttendance04No06()) {
			setValueChk(odsBean, column, line + 4, dto.getAttendance04No06()); // ΑӍ04No06
		}
		if (null != dto.getAttendance05No06()) {
			setValueChk(odsBean, column, line + 5, dto.getAttendance05No06()); // ΑӍ05No06
		}
		if (null != dto.getAttendance06No06()) {
			setValueChk(odsBean, column, line + 6, dto.getAttendance06No06()); // ΑӍ06No06
		}
		if (null != dto.getAttendance07No06()) {
			setValueChk(odsBean, column, line + 7, dto.getAttendance07No06()); // ΑӍ07No06
		}
		if (null != dto.getAttendance08No06()) {
			setValueChk(odsBean, column, line + 8, dto.getAttendance08No06()); // ΑӍ08No06
		}
		if (null != dto.getAttendance09No06()) {
			setValueChk(odsBean, column, line + 9, dto.getAttendance09No06()); // ΑӍ09No06
		}
		if (null != dto.getAttendance10No06()) {
			setValueChk(odsBean, column, line + 10, dto.getAttendance10No06()); // ΑӍ00No06
		}
		if (null != dto.getAttendance11No06()) {
			setValueChk(odsBean, column, line + 11, dto.getAttendance11No06()); // ΑӍ01No06
		}
		if (null != dto.getAttendance12No06()) {
			setValueChk(odsBean, column, line + 12, dto.getAttendance12No06()); // ΑӍ02No06
		}
		if (null != dto.getAttendance13No06()) {
			setValueChk(odsBean, column, line + 13, dto.getAttendance13No06()); // ΑӍ03No06
		}
		if (null != dto.getAttendance14No06()) {
			setValueChk(odsBean, column, line + 14, dto.getAttendance14No06()); // ΑӍ04No06
		}
		
		line = 80;
		column = 21; // 7
		if (null != dto.getPayPayday07()) {
			setValueChk(odsBean, column, line + 0, dto.getPayPayday07()); // ^xNo07
		}
		if (null != dto.getAttendance01No07()) {
			setValueChk(odsBean, column, line + 1, dto.getAttendance01No07()); // ΑӍ01No07
		}
		if (null != dto.getAttendance02No07()) {
			setValueChk(odsBean, column, line + 2, dto.getAttendance02No07()); // ΑӍ02No07
		}
		if (null != dto.getAttendance03No07()) {
			setValueChk(odsBean, column, line + 3, dto.getAttendance03No07()); // ΑӍ03No07
		}
		if (null != dto.getAttendance04No07()) {
			setValueChk(odsBean, column, line + 4, dto.getAttendance04No07()); // ΑӍ04No07
		}
		if (null != dto.getAttendance05No07()) {
			setValueChk(odsBean, column, line + 5, dto.getAttendance05No07()); // ΑӍ05No07
		}
		if (null != dto.getAttendance06No07()) {
			setValueChk(odsBean, column, line + 6, dto.getAttendance06No07()); // ΑӍ06No07
		}
		if (null != dto.getAttendance07No07()) {
			setValueChk(odsBean, column, line + 7, dto.getAttendance07No07()); // ΑӍ07No07
		}
		if (null != dto.getAttendance08No07()) {
			setValueChk(odsBean, column, line + 8, dto.getAttendance08No07()); // ΑӍ08No07
		}
		if (null != dto.getAttendance09No07()) {
			setValueChk(odsBean, column, line + 9, dto.getAttendance09No07()); // ΑӍ09No07
		}
		if (null != dto.getAttendance10No07()) {
			setValueChk(odsBean, column, line + 10, dto.getAttendance10No07()); // ΑӍ00No07
		}
		if (null != dto.getAttendance11No07()) {
			setValueChk(odsBean, column, line + 11, dto.getAttendance11No07()); // ΑӍ01No07
		}
		if (null != dto.getAttendance12No07()) {
			setValueChk(odsBean, column, line + 12, dto.getAttendance12No07()); // ΑӍ02No07
		}
		if (null != dto.getAttendance13No07()) {
			setValueChk(odsBean, column, line + 13, dto.getAttendance13No07()); // ΑӍ03No07
		}
		if (null != dto.getAttendance14No07()) {
			setValueChk(odsBean, column, line + 14, dto.getAttendance14No07()); // ΑӍ04No07
		}
		
		line = 80;
		column = 24; // 8
		if (null != dto.getPayPayday08()) {
			setValueChk(odsBean, column, line + 0, dto.getPayPayday08()); // ^xNo08
		}
		if (null != dto.getAttendance01No08()) {
			setValueChk(odsBean, column, line + 1, dto.getAttendance01No08()); // ΑӍ01No08
		}
		if (null != dto.getAttendance02No08()) {
			setValueChk(odsBean, column, line + 2, dto.getAttendance02No08()); // ΑӍ02No08
		}
		if (null != dto.getAttendance03No08()) {
			setValueChk(odsBean, column, line + 3, dto.getAttendance03No08()); // ΑӍ03No08
		}
		if (null != dto.getAttendance04No08()) {
			setValueChk(odsBean, column, line + 4, dto.getAttendance04No08()); // ΑӍ04No08
		}
		if (null != dto.getAttendance05No08()) {
			setValueChk(odsBean, column, line + 5, dto.getAttendance05No08()); // ΑӍ05No08
		}
		if (null != dto.getAttendance06No08()) {
			setValueChk(odsBean, column, line + 6, dto.getAttendance06No08()); // ΑӍ06No08
		}
		if (null != dto.getAttendance07No08()) {
			setValueChk(odsBean, column, line + 7, dto.getAttendance07No08()); // ΑӍ07No08
		}
		if (null != dto.getAttendance08No08()) {
			setValueChk(odsBean, column, line + 8, dto.getAttendance08No08()); // ΑӍ08No08
		}
		if (null != dto.getAttendance09No08()) {
			setValueChk(odsBean, column, line + 9, dto.getAttendance09No08()); // ΑӍ09No08
		}
		if (null != dto.getAttendance10No08()) {
			setValueChk(odsBean, column, line + 10, dto.getAttendance10No08()); // ΑӍ00No08
		}
		if (null != dto.getAttendance11No08()) {
			setValueChk(odsBean, column, line + 11, dto.getAttendance11No08()); // ΑӍ01No08
		}
		if (null != dto.getAttendance12No08()) {
			setValueChk(odsBean, column, line + 12, dto.getAttendance12No08()); // ΑӍ02No08
		}
		if (null != dto.getAttendance13No08()) {
			setValueChk(odsBean, column, line + 13, dto.getAttendance13No08()); // ΑӍ03No08
		}
		if (null != dto.getAttendance14No08()) {
			setValueChk(odsBean, column, line + 14, dto.getAttendance14No08()); // ΑӍ04No08
		}
		
		line = 80;
		column = 27; // 9
		if (null != dto.getPayPayday09()) {
			setValueChk(odsBean, column, line + 0, dto.getPayPayday09()); // ^xNo09
		}
		if (null != dto.getAttendance01No09()) {
			setValueChk(odsBean, column, line + 1, dto.getAttendance01No09()); // ΑӍ01No09
		}
		if (null != dto.getAttendance02No09()) {
			setValueChk(odsBean, column, line + 2, dto.getAttendance02No09()); // ΑӍ02No09
		}
		if (null != dto.getAttendance03No09()) {
			setValueChk(odsBean, column, line + 3, dto.getAttendance03No09()); // ΑӍ03No09
		}
		if (null != dto.getAttendance04No09()) {
			setValueChk(odsBean, column, line + 4, dto.getAttendance04No09()); // ΑӍ04No09
		}
		if (null != dto.getAttendance05No09()) {
			setValueChk(odsBean, column, line + 5, dto.getAttendance05No09()); // ΑӍ05No09
		}
		if (null != dto.getAttendance06No09()) {
			setValueChk(odsBean, column, line + 6, dto.getAttendance06No09()); // ΑӍ06No09
		}
		if (null != dto.getAttendance07No09()) {
			setValueChk(odsBean, column, line + 7, dto.getAttendance07No09()); // ΑӍ07No09
		}
		if (null != dto.getAttendance08No09()) {
			setValueChk(odsBean, column, line + 8, dto.getAttendance08No09()); // ΑӍ08No09
		}
		if (null != dto.getAttendance09No09()) {
			setValueChk(odsBean, column, line + 9, dto.getAttendance09No09()); // ΑӍ09No09
		}
		if (null != dto.getAttendance10No09()) {
			setValueChk(odsBean, column, line + 10, dto.getAttendance10No09()); // ΑӍ00No09
		}
		if (null != dto.getAttendance11No09()) {
			setValueChk(odsBean, column, line + 11, dto.getAttendance11No09()); // ΑӍ01No09
		}
		if (null != dto.getAttendance12No09()) {
			setValueChk(odsBean, column, line + 12, dto.getAttendance12No09()); // ΑӍ02No09
		}
		if (null != dto.getAttendance13No09()) {
			setValueChk(odsBean, column, line + 13, dto.getAttendance13No09()); // ΑӍ03No09
		}
		if (null != dto.getAttendance14No09()) {
			setValueChk(odsBean, column, line + 14, dto.getAttendance14No09()); // ΑӍ04No09
		}
		
		line = 80;
		column = 30; //10
		if (null != dto.getPayPayday10()) {
			setValueChk(odsBean, column, line + 0, dto.getPayPayday10()); // ^xNo10
		}
		if (null != dto.getAttendance01No10()) {
			setValueChk(odsBean, column, line + 1, dto.getAttendance01No10()); // ΑӍ01No10
		}
		if (null != dto.getAttendance02No10()) {
			setValueChk(odsBean, column, line + 2, dto.getAttendance02No10()); // ΑӍ02No10
		}
		if (null != dto.getAttendance03No10()) {
			setValueChk(odsBean, column, line + 3, dto.getAttendance03No10()); // ΑӍ03No10
		}
		if (null != dto.getAttendance04No10()) {
			setValueChk(odsBean, column, line + 4, dto.getAttendance04No10()); // ΑӍ04No10
		}
		if (null != dto.getAttendance05No10()) {
			setValueChk(odsBean, column, line + 5, dto.getAttendance05No10()); // ΑӍ05No10
		}
		if (null != dto.getAttendance06No10()) {
			setValueChk(odsBean, column, line + 6, dto.getAttendance06No10()); // ΑӍ06No10
		}
		if (null != dto.getAttendance07No10()) {
			setValueChk(odsBean, column, line + 7, dto.getAttendance07No10()); // ΑӍ07No10
		}
		if (null != dto.getAttendance08No10()) {
			setValueChk(odsBean, column, line + 8, dto.getAttendance08No10()); // ΑӍ08No10
		}
		if (null != dto.getAttendance09No10()) {
			setValueChk(odsBean, column, line + 9, dto.getAttendance09No10()); // ΑӍ09No10
		}
		if (null != dto.getAttendance10No10()) {
			setValueChk(odsBean, column, line + 10, dto.getAttendance10No10()); // ΑӍ00No10
		}
		if (null != dto.getAttendance11No10()) {
			setValueChk(odsBean, column, line + 11, dto.getAttendance11No10()); // ΑӍ01No10
		}
		if (null != dto.getAttendance12No10()) {
			setValueChk(odsBean, column, line + 12, dto.getAttendance12No10()); // ΑӍ02No10
		}
		if (null != dto.getAttendance13No10()) {
			setValueChk(odsBean, column, line + 13, dto.getAttendance13No10()); // ΑӍ03No10
		}
		if (null != dto.getAttendance14No10()) {
			setValueChk(odsBean, column, line + 14, dto.getAttendance14No10()); // ΑӍ04No10
		}
		
		line = 80;
		column = 33; // 11
		if (null != dto.getPayPayday11()) {
			setValueChk(odsBean, column, line + 0, dto.getPayPayday11()); // ^xNo11
		}
		if (null != dto.getAttendance01No11()) {
			setValueChk(odsBean, column, line + 1, dto.getAttendance01No11()); // ΑӍ01No11
		}
		if (null != dto.getAttendance02No11()) {
			setValueChk(odsBean, column, line + 2, dto.getAttendance02No11()); // ΑӍ02No11
		}
		if (null != dto.getAttendance03No11()) {
			setValueChk(odsBean, column, line + 3, dto.getAttendance03No11()); // ΑӍ03No11
		}
		if (null != dto.getAttendance04No11()) {
			setValueChk(odsBean, column, line + 4, dto.getAttendance04No11()); // ΑӍ04No11
		}
		if (null != dto.getAttendance05No11()) {
			setValueChk(odsBean, column, line + 5, dto.getAttendance05No11()); // ΑӍ05No11
		}
		if (null != dto.getAttendance06No11()) {
			setValueChk(odsBean, column, line + 6, dto.getAttendance06No11()); // ΑӍ06No11
		}
		if (null != dto.getAttendance07No11()) {
			setValueChk(odsBean, column, line + 7, dto.getAttendance07No11()); // ΑӍ07No11
		}
		if (null != dto.getAttendance08No11()) {
			setValueChk(odsBean, column, line + 8, dto.getAttendance08No11()); // ΑӍ08No11
		}
		if (null != dto.getAttendance09No11()) {
			setValueChk(odsBean, column, line + 9, dto.getAttendance09No11()); // ΑӍ09No11
		}
		if (null != dto.getAttendance10No11()) {
			setValueChk(odsBean, column, line + 10, dto.getAttendance10No11()); // ΑӍ00No11
		}
		if (null != dto.getAttendance11No11()) {
			setValueChk(odsBean, column, line + 11, dto.getAttendance11No11()); // ΑӍ01No11
		}
		if (null != dto.getAttendance12No11()) {
			setValueChk(odsBean, column, line + 12, dto.getAttendance12No11()); // ΑӍ02No11
		}
		if (null != dto.getAttendance13No11()) {
			setValueChk(odsBean, column, line + 13, dto.getAttendance13No11()); // ΑӍ03No11
		}
		if (null != dto.getAttendance14No11()) {
			setValueChk(odsBean, column, line + 14, dto.getAttendance14No11()); // ΑӍ04No11
		}
		
		line = 80;
		column = 36; // 12
		if (null != dto.getPayPayday12()) {
			setValueChk(odsBean, column, line + 0, dto.getPayPayday12()); // ^xNo12
		}
		if (null != dto.getAttendance01No12()) {
			setValueChk(odsBean, column, line + 1, dto.getAttendance01No12()); // ΑӍ01No12
		}
		if (null != dto.getAttendance02No12()) {
			setValueChk(odsBean, column, line + 2, dto.getAttendance02No12()); // ΑӍ02No12
		}
		if (null != dto.getAttendance03No12()) {
			setValueChk(odsBean, column, line + 3, dto.getAttendance03No12()); // ΑӍ03No12
		}
		if (null != dto.getAttendance04No12()) {
			setValueChk(odsBean, column, line + 4, dto.getAttendance04No12()); // ΑӍ04No12
		}
		if (null != dto.getAttendance05No12()) {
			setValueChk(odsBean, column, line + 5, dto.getAttendance05No12()); // ΑӍ05No12
		}
		if (null != dto.getAttendance06No12()) {
			setValueChk(odsBean, column, line + 6, dto.getAttendance06No12()); // ΑӍ06No12
		}
		if (null != dto.getAttendance07No12()) {
			setValueChk(odsBean, column, line + 7, dto.getAttendance07No12()); // ΑӍ07No12
		}
		if (null != dto.getAttendance08No12()) {
			setValueChk(odsBean, column, line + 8, dto.getAttendance08No12()); // ΑӍ08No12
		}
		if (null != dto.getAttendance09No12()) {
			setValueChk(odsBean, column, line + 9, dto.getAttendance09No12()); // ΑӍ09No12
		}
		if (null != dto.getAttendance10No12()) {
			setValueChk(odsBean, column, line + 10, dto.getAttendance10No12()); // ΑӍ00No12
		}
		if (null != dto.getAttendance11No12()) {
			setValueChk(odsBean, column, line + 11, dto.getAttendance11No12()); // ΑӍ01No12
		}
		if (null != dto.getAttendance12No12()) {
			setValueChk(odsBean, column, line + 12, dto.getAttendance12No12()); // ΑӍ02No12
		}
		if (null != dto.getAttendance13No12()) {
			setValueChk(odsBean, column, line + 13, dto.getAttendance13No12()); // ΑӍ03No12
		}
		if (null != dto.getAttendance14No12()) {
			setValueChk(odsBean, column, line + 14, dto.getAttendance14No12()); // ΑӍ04No12
		}
		
		line = 80;
		column = 39; // Nԍv
		if (null != dto.getTotalAttendance01()) {
			setValueChk(odsBean, column, line + 1, dto.getTotalAttendance01()); // ΑӍ01v
		}
		if (null != dto.getTotalAttendance02()) {
			setValueChk(odsBean, column, line + 2, dto.getTotalAttendance02()); // ΑӍ02v
		}
		if (null != dto.getTotalAttendance03()) {
			setValueChk(odsBean, column, line + 3, dto.getTotalAttendance03()); // ΑӍ03v
		}
		if (null != dto.getTotalAttendance04()) {
			setValueChk(odsBean, column, line + 4, dto.getTotalAttendance04()); // ΑӍ04v
		}
		if (null != dto.getTotalAttendance05()) {
			setValueChk(odsBean, column, line + 5, dto.getTotalAttendance05()); // ΑӍ05v
		}
		if (null != dto.getTotalAttendance06()) {
			setValueChk(odsBean, column, line + 6, dto.getTotalAttendance06()); // ΑӍ06v
		}
		if (null != dto.getTotalAttendance07()) {
			setValueChk(odsBean, column, line + 7, dto.getTotalAttendance07()); // ΑӍ07v
		}
		if (null != dto.getTotalAttendance08()) {
			setValueChk(odsBean, column, line + 8, dto.getTotalAttendance08()); // ΑӍ08v
		}
		if (null != dto.getTotalAttendance09()) {
			setValueChk(odsBean, column, line + 9, dto.getTotalAttendance09()); // ΑӍ09v
		}
		if (null != dto.getTotalAttendance10()) {
			setValueChk(odsBean, column, line + 10, dto.getTotalAttendance10()); // ΑӍ00v
		}
		if (null != dto.getTotalAttendance11()) {
			setValueChk(odsBean, column, line + 11, dto.getTotalAttendance11()); // ΑӍ01v
		}
		if (null != dto.getTotalAttendance12()) {
			setValueChk(odsBean, column, line + 12, dto.getTotalAttendance12()); // ΑӍ02v
		}
		if (null != dto.getTotalAttendance13()) {
			setValueChk(odsBean, column, line + 13, dto.getTotalAttendance13()); // ΑӍ03v
		}
		if (null != dto.getTotalAttendance14()) {
			setValueChk(odsBean, column, line + 14, dto.getTotalAttendance14()); // ΑӍ04v
		}
		
		/** ܗ^ڏo **/
		// ږo
		line = 98;
		column = 0;
		setValueChk(odsBean, column + 0, line + 0, dto.getTitleAllowanceItem()); // xږ^Cg
		setValueChk(odsBean, column + 0, line + 1, dto.getTitleBonAllowance01()); // ܗ^x01^Cg
		setValueChk(odsBean, column + 0, line + 2, dto.getTitleBonAllowance02()); // ܗ^x02^Cg
		setValueChk(odsBean, column + 0, line + 3, dto.getTitleBonAllowance03()); // ܗ^x03^Cg
		setValueChk(odsBean, column + 0, line + 4, dto.getTitleBonAllowance04()); // ܗ^x04^Cg
		setValueChk(odsBean, column + 0, line + 5, dto.getTitleBonAllowance05()); // ܗ^x05^Cg
		setValueChk(odsBean, column + 0, line + 6, dto.getTitleBonAllowance06()); // ܗ^x06^Cg
		setValueChk(odsBean, column + 0, line + 7, dto.getTitleBonAllowance07()); // ܗ^x07^Cg
		setValueChk(odsBean, column + 0, line + 8, dto.getTitleBonAllowance08()); // ܗ^x08^Cg
		setValueChk(odsBean, column + 0, line + 9, dto.getTitleBonAllowance09()); // ܗ^x09^Cg
		setValueChk(odsBean, column + 0, line + 10, dto.getTitleBonAllowance10()); // ܗ^x10^Cg
		setValueChk(odsBean, column + 0, line + 11, dto.getTitleAllowanceTotal()); // xz^Cg		
		setValueChk(odsBean, column + 0, line + 12, "" + dto.getTitleDeductionItem() + ""); // Tڃ^Cg  
		setValueChk(odsBean, column + 0, line + 13, dto.getTitleBonDeduction01()); // ܗ^T01^Cg
		setValueChk(odsBean, column + 0, line + 14, dto.getTitleBonDeduction02()); // ܗ^T02^Cg
		setValueChk(odsBean, column + 0, line + 15, dto.getTitleBonDeduction03()); // ܗ^T03^Cg
		setValueChk(odsBean, column + 0, line + 16, dto.getTitleBonDeduction04()); // ܗ^T04^Cg
		setValueChk(odsBean, column + 0, line + 17, dto.getTitleBonDeduction05()); // ܗ^T05^Cg
		setValueChk(odsBean, column + 0, line + 18, dto.getTitleBonDeduction06()); // ܗ^T06^Cg
		setValueChk(odsBean, column + 0, line + 19, dto.getTitleBonDeduction07()); // ܗ^T07^Cg
		setValueChk(odsBean, column + 0, line + 20, dto.getTitleBonDeduction08()); // ܗ^T08^Cg
		setValueChk(odsBean, column + 0, line + 21, dto.getTitleBonDeduction09()); // ܗ^T09^Cg
		setValueChk(odsBean, column + 0, line + 22, dto.getTitleBonDeduction10()); // ܗ^T10^Cg
		setValueChk(odsBean, column + 0, line + 23, dto.getTitleBonDeduction11()); // ܗ^T11^Cg
		setValueChk(odsBean, column + 0, line + 24, dto.getTitleBonDeduction12()); // ܗ^T12^Cg
		setValueChk(odsBean, column + 0, line + 25, dto.getTitleBonDeduction14()); // ܗ^T14^Cg
		setValueChk(odsBean, column + 0, line + 26, dto.getTitleBonDeduction15()); // ܗ^T15^Cg
		setValueChk(odsBean, column + 0, line + 27, dto.getTitleBonDeduction16()); // ܗ^T16^Cg
		setValueChk(odsBean, column + 0, line + 28, dto.getTitleDeductionTotal()); // Tz^Cg
		setValueChk(odsBean, column + 0, line + 29, dto.getTitlePaymentTotal()); // xz^Cg
		setValueChk(odsBean, column + 0, line + 30, dto.getTitleBank1PayAmount()); // s1Uz
		setValueChk(odsBean, column + 0, line + 31, dto.getTitleBank2PayAmount()); // s2Uz
		setValueChk(odsBean, column + 0, line + 32, dto.getTitleCashPayAmount()); // xz
		setValueChk(odsBean, column + 0, line + 33, dto.getTitleBonDeduction17()); // ܗ^T17^Cg
		
		// ܗ^x׏o
		line = 97;
		column = 3; // 1
		if (null != dto.getBonPayday01()) {
			setValueChk(odsBean, column, line + 0, dto.getBonPayday01()); // ܗ^xNo01
		}
		if (null != dto.getBonAllowance01No01()) {
			setValueChk(odsBean, column, line + 1, dto.getBonAllowance01No01()); // ܗ^x01No01
		}
		if (null != dto.getBonAllowance02No01()) {
			setValueChk(odsBean, column, line + 2, dto.getBonAllowance02No01()); // ܗ^x02No01
		}
		if (null != dto.getBonAllowance03No01()) {
			setValueChk(odsBean, column, line + 3, dto.getBonAllowance03No01()); // ܗ^x03No01
		}
		if (null != dto.getBonAllowance04No01()) {
			setValueChk(odsBean, column, line + 4, dto.getBonAllowance04No01()); // ܗ^x04No01
		}
		if (null != dto.getBonAllowance05No01()) {
			setValueChk(odsBean, column, line + 5, dto.getBonAllowance05No01()); // ܗ^x05No01
		}
		if (null != dto.getBonAllowance06No01()) {
			setValueChk(odsBean, column, line + 6, dto.getBonAllowance06No01()); // ܗ^x06No01
		}
		if (null != dto.getBonAllowance07No01()) {
			setValueChk(odsBean, column, line + 7, dto.getBonAllowance07No01()); // ܗ^x07No01
		}
		if (null != dto.getBonAllowance08No01()) {
			setValueChk(odsBean, column, line + 8, dto.getBonAllowance08No01()); // ܗ^x08No01
		}
		if (null != dto.getBonAllowance09No01()) {
			setValueChk(odsBean, column, line + 9, dto.getBonAllowance09No01()); // ܗ^x09No01
		}
		if (null != dto.getBonAllowance10No01()) {
			setValueChk(odsBean, column, line + 10, dto.getBonAllowance10No01()); // ܗ^x10No01
		}
		if (null != dto.getBonAllowanceTotal01()) {
			setValueChk(odsBean, column, line + 11, dto.getBonAllowanceTotal01()); // ܗ^x1ڌv
		}
		
		line = 97;
		column = 6; // 2
		if (null != dto.getBonPayday02()) {
			setValueChk(odsBean, column, line + 0, dto.getBonPayday02()); // ܗ^xNo02
		}
		if (null != dto.getBonAllowance01No02()) {
			setValueChk(odsBean, column, line + 1, dto.getBonAllowance01No02()); // ܗ^x01No02
		}
		if (null != dto.getBonAllowance02No02()) {
			setValueChk(odsBean, column, line + 2, dto.getBonAllowance02No02()); // ܗ^x02No02
		}
		if (null != dto.getBonAllowance03No02()) {
			setValueChk(odsBean, column, line + 3, dto.getBonAllowance03No02()); // ܗ^x03No02
		}
		if (null != dto.getBonAllowance04No02()) {
			setValueChk(odsBean, column, line + 4, dto.getBonAllowance04No02()); // ܗ^x04No02
		}
		if (null != dto.getBonAllowance05No02()) {
			setValueChk(odsBean, column, line + 5, dto.getBonAllowance05No02()); // ܗ^x05No02
		}
		if (null != dto.getBonAllowance06No02()) {
			setValueChk(odsBean, column, line + 6, dto.getBonAllowance06No02()); // ܗ^x06No02
		}
		if (null != dto.getBonAllowance07No02()) {
			setValueChk(odsBean, column, line + 7, dto.getBonAllowance07No02()); // ܗ^x07No02
		}
		if (null != dto.getBonAllowance08No02()) {
			setValueChk(odsBean, column, line + 8, dto.getBonAllowance08No02()); // ܗ^x08No02
		}
		if (null != dto.getBonAllowance09No02()) {
			setValueChk(odsBean, column, line + 9, dto.getBonAllowance09No02()); // ܗ^x09No02
		}
		if (null != dto.getBonAllowance10No02()) {
			setValueChk(odsBean, column, line + 10, dto.getBonAllowance10No02()); // ܗ^x10No02
		}
		if (null != dto.getBonAllowanceTotal02()) {
			setValueChk(odsBean, column, line + 11, dto.getBonAllowanceTotal02()); // ܗ^x2ڌv
		}
		
		line = 97;
		column = 9; // 3
		if (null != dto.getBonPayday03()) {
			setValueChk(odsBean, column, line + 0, dto.getBonPayday03()); // ܗ^xNo03
		}
		if (null != dto.getBonAllowance01No03()) {
			setValueChk(odsBean, column, line + 1, dto.getBonAllowance01No03()); // ܗ^x01No03
		}
		if (null != dto.getBonAllowance02No03()) {
			setValueChk(odsBean, column, line + 2, dto.getBonAllowance02No03()); // ܗ^x02No03
		}
		if (null != dto.getBonAllowance03No03()) {
			setValueChk(odsBean, column, line + 3, dto.getBonAllowance03No03()); // ܗ^x03No03
		}
		if (null != dto.getBonAllowance04No03()) {
			setValueChk(odsBean, column, line + 4, dto.getBonAllowance04No03()); // ܗ^x04No03
		}
		if (null != dto.getBonAllowance05No03()) {
			setValueChk(odsBean, column, line + 5, dto.getBonAllowance05No03()); // ܗ^x05No03
		}
		if (null != dto.getBonAllowance06No03()) {
			setValueChk(odsBean, column, line + 6, dto.getBonAllowance06No03()); // ܗ^x06No03
		}
		if (null != dto.getBonAllowance07No03()) {
			setValueChk(odsBean, column, line + 7, dto.getBonAllowance07No03()); // ܗ^x07No03
		}
		if (null != dto.getBonAllowance08No03()) {
			setValueChk(odsBean, column, line + 8, dto.getBonAllowance08No03()); // ܗ^x08No03
		}
		if (null != dto.getBonAllowance09No03()) {
			setValueChk(odsBean, column, line + 9, dto.getBonAllowance09No03()); // ܗ^x09No03
		}
		if (null != dto.getBonAllowance10No03()) {
			setValueChk(odsBean, column, line + 10, dto.getBonAllowance10No03()); // ܗ^x10No03
		}
		if (null != dto.getBonAllowanceTotal03()) {
			setValueChk(odsBean, column, line + 11, dto.getBonAllowanceTotal03()); // ܗ^x3ڌv
		}
		
		line = 97;
		column = 12; // 4
		if (null != dto.getBonPayday04()) {
			setValueChk(odsBean, column, line + 0, dto.getBonPayday04()); // ܗ^xNo04
		}
		if (null != dto.getBonAllowance01No04()) {
			setValueChk(odsBean, column, line + 1, dto.getBonAllowance01No04()); // ܗ^x01No04
		}
		if (null != dto.getBonAllowance02No04()) {
			setValueChk(odsBean, column, line + 2, dto.getBonAllowance02No04()); // ܗ^x02No04
		}
		if (null != dto.getBonAllowance03No04()) {
			setValueChk(odsBean, column, line + 3, dto.getBonAllowance03No04()); // ܗ^x03No04
		}
		if (null != dto.getBonAllowance04No04()) {
			setValueChk(odsBean, column, line + 4, dto.getBonAllowance04No04()); // ܗ^x04No04
		}
		if (null != dto.getBonAllowance05No04()) {
			setValueChk(odsBean, column, line + 5, dto.getBonAllowance05No04()); // ܗ^x05No04
		}
		if (null != dto.getBonAllowance06No04()) {
			setValueChk(odsBean, column, line + 6, dto.getBonAllowance06No04()); // ܗ^x06No04
		}
		if (null != dto.getBonAllowance07No04()) {
			setValueChk(odsBean, column, line + 7, dto.getBonAllowance07No04()); // ܗ^x07No04
		}
		if (null != dto.getBonAllowance08No04()) {
			setValueChk(odsBean, column, line + 8, dto.getBonAllowance08No04()); // ܗ^x08No04
		}
		if (null != dto.getBonAllowance09No04()) {
			setValueChk(odsBean, column, line + 9, dto.getBonAllowance09No04()); // ܗ^x09No04
		}
		if (null != dto.getBonAllowance10No04()) {
			setValueChk(odsBean, column, line + 10, dto.getBonAllowance10No04()); // ܗ^x10No04
		}
		if (null != dto.getBonAllowanceTotal04()) {
			setValueChk(odsBean, column, line + 11, dto.getBonAllowanceTotal04()); // ܗ^x4ڌv
		}
		
		line = 97;
		column = 15; // 5
		if (null != dto.getBonPayday05()) {
			setValueChk(odsBean, column, line + 0, dto.getBonPayday05()); // ܗ^xNo05
		}
		if (null != dto.getBonAllowance01No05()) {
			setValueChk(odsBean, column, line + 1, dto.getBonAllowance01No05()); // ܗ^x01No05
		}
		if (null != dto.getBonAllowance02No05()) {
			setValueChk(odsBean, column, line + 2, dto.getBonAllowance02No05()); // ܗ^x02No05
		}
		if (null != dto.getBonAllowance03No05()) {
			setValueChk(odsBean, column, line + 3, dto.getBonAllowance03No05()); // ܗ^x03No05
		}
		if (null != dto.getBonAllowance04No05()) {
			setValueChk(odsBean, column, line + 4, dto.getBonAllowance04No05()); // ܗ^x04No05
		}
		if (null != dto.getBonAllowance05No05()) {
			setValueChk(odsBean, column, line + 5, dto.getBonAllowance05No05()); // ܗ^x05No05
		}
		if (null != dto.getBonAllowance06No05()) {
			setValueChk(odsBean, column, line + 6, dto.getBonAllowance06No05()); // ܗ^x06No05
		}
		if (null != dto.getBonAllowance07No05()) {
			setValueChk(odsBean, column, line + 7, dto.getBonAllowance07No05()); // ܗ^x07No05
		}
		if (null != dto.getBonAllowance08No05()) {
			setValueChk(odsBean, column, line + 8, dto.getBonAllowance08No05()); // ܗ^x08No05
		}
		if (null != dto.getBonAllowance09No05()) {
			setValueChk(odsBean, column, line + 9, dto.getBonAllowance09No05()); // ܗ^x09No05
		}
		if (null != dto.getBonAllowance10No05()) {
			setValueChk(odsBean, column, line + 10, dto.getBonAllowance10No05()); // ܗ^x10No05
		}
		if (null != dto.getBonAllowanceTotal05()) {
			setValueChk(odsBean, column, line + 11, dto.getBonAllowanceTotal05()); // ܗ^x5ڌv
		}
		
		line = 97;
		column = 18; // 6
		if (null != dto.getBonPayday06()) {
			setValueChk(odsBean, column, line + 0, dto.getBonPayday06()); // ܗ^xNo06
		}
		if (null != dto.getBonAllowance01No06()) {
			setValueChk(odsBean, column, line + 1, dto.getBonAllowance01No06()); // ܗ^x01No06
		}
		if (null != dto.getBonAllowance02No06()) {
			setValueChk(odsBean, column, line + 2, dto.getBonAllowance02No06()); // ܗ^x02No06
		}
		if (null != dto.getBonAllowance03No06()) {
			setValueChk(odsBean, column, line + 3, dto.getBonAllowance03No06()); // ܗ^x03No06
		}
		if (null != dto.getBonAllowance04No06()) {
			setValueChk(odsBean, column, line + 4, dto.getBonAllowance04No06()); // ܗ^x04No06
		}
		if (null != dto.getBonAllowance05No06()) {
			setValueChk(odsBean, column, line + 5, dto.getBonAllowance05No06()); // ܗ^x05No06
		}
		if (null != dto.getBonAllowance06No06()) {
			setValueChk(odsBean, column, line + 6, dto.getBonAllowance06No06()); // ܗ^x06No06
		}
		if (null != dto.getBonAllowance07No06()) {
			setValueChk(odsBean, column, line + 7, dto.getBonAllowance07No06()); // ܗ^x07No06
		}
		if (null != dto.getBonAllowance08No06()) {
			setValueChk(odsBean, column, line + 8, dto.getBonAllowance08No06()); // ܗ^x08No06
		}
		if (null != dto.getBonAllowance09No06()) {
			setValueChk(odsBean, column, line + 9, dto.getBonAllowance09No06()); // ܗ^x09No06
		}
		if (null != dto.getBonAllowance10No06()) {
			setValueChk(odsBean, column, line + 10, dto.getBonAllowance10No06()); // ܗ^x10No06
		}
		if (null != dto.getBonAllowanceTotal06()) {
			setValueChk(odsBean, column, line + 11, dto.getBonAllowanceTotal06()); // ܗ^x6ڌv
		}
		
		line = 97;
		column = 21; // Nԍv
		if (null != dto.getBonTotalAllowance01()) {
			setValueChk(odsBean, column, line + 1, dto.getBonTotalAllowance01()); // ܗ^x01v
		}
		if (null != dto.getBonTotalAllowance02()) {
			setValueChk(odsBean, column, line + 2, dto.getBonTotalAllowance02()); // ܗ^x02v
		}
		if (null != dto.getBonTotalAllowance03()) {
			setValueChk(odsBean, column, line + 3, dto.getBonTotalAllowance03()); // ܗ^x03v
		}
		if (null != dto.getBonTotalAllowance04()) {
			setValueChk(odsBean, column, line + 4, dto.getBonTotalAllowance04()); // ܗ^x04v
		}
		if (null != dto.getBonTotalAllowance05()) {
			setValueChk(odsBean, column, line + 5, dto.getBonTotalAllowance05()); // ܗ^x05v
		}
		if (null != dto.getBonTotalAllowance06()) {
			setValueChk(odsBean, column, line + 6, dto.getBonTotalAllowance06()); // ܗ^x06v
		}
		if (null != dto.getBonTotalAllowance07()) {
			setValueChk(odsBean, column, line + 7, dto.getBonTotalAllowance07()); // ܗ^x07v
		}
		if (null != dto.getBonTotalAllowance08()) {
			setValueChk(odsBean, column, line + 8, dto.getBonTotalAllowance08()); // ܗ^x08v
		}
		if (null != dto.getBonTotalAllowance09()) {
			setValueChk(odsBean, column, line + 9, dto.getBonTotalAllowance09()); // ܗ^x09v
		}
		if (null != dto.getBonTotalAllowance10()) {
			setValueChk(odsBean, column, line + 10, dto.getBonTotalAllowance10()); // ܗ^x10v
		}
		if (null != dto.getBonTotalAllowanceTotal()) {
			setValueChk(odsBean, column, line + 11, dto.getBonTotalAllowanceTotal()); // ܗ^xڍv
		}
		
		// ܗ^T׏o
		line = 110;
		column = 3; // 1
		if (null != dto.getBonDeduction01No01()) {
			setValueChk(odsBean, column, line + 1, dto.getBonDeduction01No01()); // ܗ^T01No01
		}
		if (null != dto.getBonDeduction02No01()) {
			setValueChk(odsBean, column, line + 2, dto.getBonDeduction02No01()); // ܗ^T02No01
		}
		if (null != dto.getBonDeduction03No01()) {
			setValueChk(odsBean, column, line + 3, dto.getBonDeduction03No01()); // ܗ^T03No01
		}
		if (null != dto.getBonDeduction04No01()) {
			setValueChk(odsBean, column, line + 4, dto.getBonDeduction04No01()); // ܗ^T04No01
		}
		if (null != dto.getBonDeduction05No01()) {
			setValueChk(odsBean, column, line + 5, dto.getBonDeduction05No01()); // ܗ^T05No01
		}
		if (null != dto.getBonDeduction06No01()) {
			setValueChk(odsBean, column, line + 6, dto.getBonDeduction06No01()); // ܗ^T06No01
		}
		if (null != dto.getBonDeduction07No01()) {
			setValueChk(odsBean, column, line + 7, dto.getBonDeduction07No01()); // ܗ^T07No01
		}
		if (null != dto.getBonDeduction08No01()) {
			setValueChk(odsBean, column, line + 8, dto.getBonDeduction08No01()); // ܗ^T08No01
		}
		if (null != dto.getBonDeduction09No01()) {
			setValueChk(odsBean, column, line + 9, dto.getBonDeduction09No01()); // ܗ^T09No01
		}
		if (null != dto.getBonDeduction10No01()) {
			setValueChk(odsBean, column, line + 10, dto.getBonDeduction10No01()); // ܗ^T10No01
		}
		if (null != dto.getBonDeduction11No01()) {
			setValueChk(odsBean, column, line + 11, dto.getBonDeduction11No01()); // ܗ^T11No01
		}
		if (null != dto.getBonDeduction12No01()) {
			setValueChk(odsBean, column, line + 12, dto.getBonDeduction12No01()); // ܗ^T12No01
		}
		if (null != dto.getBonDeduction14No01()) {
			setValueChk(odsBean, column, line + 13, dto.getBonDeduction14No01()); // ܗ^T14No01
		}
		if (null != dto.getBonDeduction15No01()) {
			setValueChk(odsBean, column, line + 14, dto.getBonDeduction15No01()); // ܗ^T15No01
		}
		if (null != dto.getBonDeduction16No01()) {
			setValueChk(odsBean, column, line + 15, dto.getBonDeduction16No01()); // ܗ^T16No01
		}
		if (null != dto.getBonDeduction17No01()) {
			setValueChk(odsBean, column, line + 16, dto.getBonDeduction17No01()); // ܗ^T17No01
		}
		if (null != dto.getBonDeductionTotal01()) {
			setValueChk(odsBean, column, line + 17, dto.getBonDeductionTotal01()); // ܗ^1ڍTڌv
		}
		if (null != dto.getBonPaymentTotal01()) {
			setValueChk(odsBean, column, line + 18, dto.getBonPaymentTotal01()); // ܗ^1ڍxzv
		}
		if (null != dto.getBonBank1PayAmount01()) {
			setValueChk(odsBean, column, line + 19, dto.getBonBank1PayAmount01()); // ܗ^1ڋs1Uzv
		}
		if (null != dto.getBonBank2PayAmount01()) {
			setValueChk(odsBean, column, line + 20, dto.getBonBank2PayAmount01()); // ܗ^1ڋs2Uzv
		}
		if (null != dto.getBonCashPayAmount01()) {
			setValueChk(odsBean, column, line + 21, dto.getBonCashPayAmount01()); // ܗ^1ڌxzv
		}
		
		line = 110;
		column = 6; // 2
		if (null != dto.getBonDeduction01No02()) {
			setValueChk(odsBean, column, line + 1, dto.getBonDeduction01No02()); // ܗ^T01No02
		}
		if (null != dto.getBonDeduction02No02()) {
			setValueChk(odsBean, column, line + 2, dto.getBonDeduction02No02()); // ܗ^T02No02
		}
		if (null != dto.getBonDeduction03No02()) {
			setValueChk(odsBean, column, line + 3, dto.getBonDeduction03No02()); // ܗ^T03No02
		}
		if (null != dto.getBonDeduction04No02()) {
			setValueChk(odsBean, column, line + 4, dto.getBonDeduction04No02()); // ܗ^T04No02
		}
		if (null != dto.getBonDeduction05No02()) {
			setValueChk(odsBean, column, line + 5, dto.getBonDeduction05No02()); // ܗ^T05No02
		}
		if (null != dto.getBonDeduction06No02()) {
			setValueChk(odsBean, column, line + 6, dto.getBonDeduction06No02()); // ܗ^T06No02
		}
		if (null != dto.getBonDeduction07No02()) {
			setValueChk(odsBean, column, line + 7, dto.getBonDeduction07No02()); // ܗ^T07No02
		}
		if (null != dto.getBonDeduction08No02()) {
			setValueChk(odsBean, column, line + 8, dto.getBonDeduction08No02()); // ܗ^T08No02
		}
		if (null != dto.getBonDeduction09No02()) {
			setValueChk(odsBean, column, line + 9, dto.getBonDeduction09No02()); // ܗ^T09No02
		}
		if (null != dto.getBonDeduction10No02()) {
			setValueChk(odsBean, column, line + 10, dto.getBonDeduction10No02()); // ܗ^T10No02
		}
		if (null != dto.getBonDeduction11No02()) {
			setValueChk(odsBean, column, line + 11, dto.getBonDeduction11No02()); // ܗ^T11No02
		}
		if (null != dto.getBonDeduction12No02()) {
			setValueChk(odsBean, column, line + 12, dto.getBonDeduction12No02()); // ܗ^T12No02
		}
		if (null != dto.getBonDeduction14No02()) {
			setValueChk(odsBean, column, line + 13, dto.getBonDeduction14No02()); // ܗ^T14No02
		}
		if (null != dto.getBonDeduction15No02()) {
			setValueChk(odsBean, column, line + 14, dto.getBonDeduction15No02()); // ܗ^T15No02
		}
		if (null != dto.getBonDeduction16No02()) {
			setValueChk(odsBean, column, line + 15, dto.getBonDeduction16No02()); // ܗ^T16No02
		}
		if (null != dto.getBonDeduction17No02()) {
			setValueChk(odsBean, column, line + 16, dto.getBonDeduction17No02()); // ܗ^T17No02
		}
		if (null != dto.getBonDeductionTotal02()) {
			setValueChk(odsBean, column, line + 17, dto.getBonDeductionTotal02()); // ܗ^2ڍTڌv
		}
		if (null != dto.getBonPaymentTotal02()) {
			setValueChk(odsBean, column, line + 18, dto.getBonPaymentTotal02()); // ܗ^2ڍxzv
		}
		if (null != dto.getBonBank1PayAmount02()) {
			setValueChk(odsBean, column, line + 19, dto.getBonBank1PayAmount02()); // ܗ^2ڋs1Uzv
		}
		if (null != dto.getBonBank2PayAmount02()) {
			setValueChk(odsBean, column, line + 20, dto.getBonBank2PayAmount02()); // ܗ^2ڋs2Uzv
		}
		if (null != dto.getBonCashPayAmount02()) {
			setValueChk(odsBean, column, line + 21, dto.getBonCashPayAmount02()); // ܗ^2ڌxzv
		}
		
		line = 110;
		column = 9; // 3
		if (null != dto.getBonDeduction01No03()) {
			setValueChk(odsBean, column, line + 1, dto.getBonDeduction01No03()); // ܗ^T01No03
		}
		if (null != dto.getBonDeduction02No03()) {
			setValueChk(odsBean, column, line + 2, dto.getBonDeduction02No03()); // ܗ^T02No03
		}
		if (null != dto.getBonDeduction03No03()) {
			setValueChk(odsBean, column, line + 3, dto.getBonDeduction03No03()); // ܗ^T03No03
		}
		if (null != dto.getBonDeduction04No03()) {
			setValueChk(odsBean, column, line + 4, dto.getBonDeduction04No03()); // ܗ^T04No03
		}
		if (null != dto.getBonDeduction05No03()) {
			setValueChk(odsBean, column, line + 5, dto.getBonDeduction05No03()); // ܗ^T05No03
		}
		if (null != dto.getBonDeduction06No03()) {
			setValueChk(odsBean, column, line + 6, dto.getBonDeduction06No03()); // ܗ^T06No03
		}
		if (null != dto.getBonDeduction07No03()) {
			setValueChk(odsBean, column, line + 7, dto.getBonDeduction07No03()); // ܗ^T07No03
		}
		if (null != dto.getBonDeduction08No03()) {
			setValueChk(odsBean, column, line + 8, dto.getBonDeduction08No03()); // ܗ^T08No03
		}
		if (null != dto.getBonDeduction09No03()) {
			setValueChk(odsBean, column, line + 9, dto.getBonDeduction09No03()); // ܗ^T09No03
		}
		if (null != dto.getBonDeduction10No03()) {
			setValueChk(odsBean, column, line + 10, dto.getBonDeduction10No03()); // ܗ^T10No03
		}
		if (null != dto.getBonDeduction11No03()) {
			setValueChk(odsBean, column, line + 11, dto.getBonDeduction11No03()); // ܗ^T11No03
		}
		if (null != dto.getBonDeduction12No03()) {
			setValueChk(odsBean, column, line + 12, dto.getBonDeduction12No03()); // ܗ^T12No03
		}
		if (null != dto.getBonDeduction14No03()) {
			setValueChk(odsBean, column, line + 13, dto.getBonDeduction14No03()); // ܗ^T14No03
		}
		if (null != dto.getBonDeduction15No03()) {
			setValueChk(odsBean, column, line + 14, dto.getBonDeduction15No03()); // ܗ^T15No03
		}
		if (null != dto.getBonDeduction16No03()) {
			setValueChk(odsBean, column, line + 15, dto.getBonDeduction16No03()); // ܗ^T16No03
		}
		if (null != dto.getBonDeduction17No03()) {
			setValueChk(odsBean, column, line + 16, dto.getBonDeduction17No03()); // ܗ^T17No03
		}
		if (null != dto.getBonDeductionTotal03()) {
			setValueChk(odsBean, column, line + 17, dto.getBonDeductionTotal03()); // ܗ^3ڍTڌv
		}
		if (null != dto.getBonPaymentTotal03()) {
			setValueChk(odsBean, column, line + 18, dto.getBonPaymentTotal03()); // ܗ^3ڍxzv
		}
		if (null != dto.getBonBank1PayAmount03()) {
			setValueChk(odsBean, column, line + 19, dto.getBonBank1PayAmount03()); // ܗ^3ڋs1Uzv
		}
		if (null != dto.getBonBank2PayAmount03()) {
			setValueChk(odsBean, column, line + 20, dto.getBonBank2PayAmount03()); // ܗ^3ڋs2Uzv
		}
		if (null != dto.getBonCashPayAmount03()) {
			setValueChk(odsBean, column, line + 21, dto.getBonCashPayAmount03()); // ܗ^3ڌxzv
		}
		
		line = 110;
		column = 12; // 4
		if (null != dto.getBonDeduction01No04()) {
			setValueChk(odsBean, column, line + 1, dto.getBonDeduction01No04()); // ܗ^T01No04
		}
		if (null != dto.getBonDeduction02No04()) {
			setValueChk(odsBean, column, line + 2, dto.getBonDeduction02No04()); // ܗ^T02No04
		}
		if (null != dto.getBonDeduction03No04()) {
			setValueChk(odsBean, column, line + 3, dto.getBonDeduction03No04()); // ܗ^T03No04
		}
		if (null != dto.getBonDeduction04No04()) {
			setValueChk(odsBean, column, line + 4, dto.getBonDeduction04No04()); // ܗ^T04No04
		}
		if (null != dto.getBonDeduction05No04()) {
			setValueChk(odsBean, column, line + 5, dto.getBonDeduction05No04()); // ܗ^T05No04
		}
		if (null != dto.getBonDeduction06No04()) {
			setValueChk(odsBean, column, line + 6, dto.getBonDeduction06No04()); // ܗ^T06No04
		}
		if (null != dto.getBonDeduction07No04()) {
			setValueChk(odsBean, column, line + 7, dto.getBonDeduction07No04()); // ܗ^T07No04
		}
		if (null != dto.getBonDeduction08No04()) {
			setValueChk(odsBean, column, line + 8, dto.getBonDeduction08No04()); // ܗ^T08No04
		}
		if (null != dto.getBonDeduction09No04()) {
			setValueChk(odsBean, column, line + 9, dto.getBonDeduction09No04()); // ܗ^T09No04
		}
		if (null != dto.getBonDeduction10No04()) {
			setValueChk(odsBean, column, line + 10, dto.getBonDeduction10No04()); // ܗ^T10No04
		}
		if (null != dto.getBonDeduction11No04()) {
			setValueChk(odsBean, column, line + 11, dto.getBonDeduction11No04()); // ܗ^T11No04
		}
		if (null != dto.getBonDeduction12No04()) {
			setValueChk(odsBean, column, line + 12, dto.getBonDeduction12No04()); // ܗ^T12No04
		}
		if (null != dto.getBonDeduction14No04()) {
			setValueChk(odsBean, column, line + 13, dto.getBonDeduction14No04()); // ܗ^T14No04
		}
		if (null != dto.getBonDeduction15No04()) {
			setValueChk(odsBean, column, line + 14, dto.getBonDeduction15No04()); // ܗ^T15No04
		}
		if (null != dto.getBonDeduction16No04()) {
			setValueChk(odsBean, column, line + 15, dto.getBonDeduction16No04()); // ܗ^T16No04
		}
		if (null != dto.getBonDeduction17No04()) {
			setValueChk(odsBean, column, line + 16, dto.getBonDeduction17No04()); // ܗ^T17No04
		}
		if (null != dto.getBonDeductionTotal04()) {
			setValueChk(odsBean, column, line + 17, dto.getBonDeductionTotal04()); // ܗ^4ڍTڌv
		}
		if (null != dto.getBonPaymentTotal04()) {
			setValueChk(odsBean, column, line + 18, dto.getBonPaymentTotal04()); // ܗ^4ڍxzv
		}
		if (null != dto.getBonBank1PayAmount04()) {
			setValueChk(odsBean, column, line + 19, dto.getBonBank1PayAmount04()); // ܗ^4ڋs1Uzv
		}
		if (null != dto.getBonBank2PayAmount04()) {
			setValueChk(odsBean, column, line + 20, dto.getBonBank2PayAmount04()); // ܗ^4ڋs2Uzv
		}
		if (null != dto.getBonCashPayAmount04()) {
			setValueChk(odsBean, column, line + 21, dto.getBonCashPayAmount04()); // ܗ^4ڌxzv
		}
		
		line = 110;
		column = 15; // 5
		if (null != dto.getBonDeduction01No05()) {
			setValueChk(odsBean, column, line + 1, dto.getBonDeduction01No05()); // ܗ^T01No05
		}
		if (null != dto.getBonDeduction02No05()) {
			setValueChk(odsBean, column, line + 2, dto.getBonDeduction02No05()); // ܗ^T02No05
		}
		if (null != dto.getBonDeduction03No05()) {
			setValueChk(odsBean, column, line + 3, dto.getBonDeduction03No05()); // ܗ^T03No05
		}
		if (null != dto.getBonDeduction04No05()) {
			setValueChk(odsBean, column, line + 4, dto.getBonDeduction04No05()); // ܗ^T04No05
		}
		if (null != dto.getBonDeduction05No05()) {
			setValueChk(odsBean, column, line + 5, dto.getBonDeduction05No05()); // ܗ^T05No05
		}
		if (null != dto.getBonDeduction06No05()) {
			setValueChk(odsBean, column, line + 6, dto.getBonDeduction06No05()); // ܗ^T06No05
		}
		if (null != dto.getBonDeduction07No05()) {
			setValueChk(odsBean, column, line + 7, dto.getBonDeduction07No05()); // ܗ^T07No05
		}
		if (null != dto.getBonDeduction08No05()) {
			setValueChk(odsBean, column, line + 8, dto.getBonDeduction08No05()); // ܗ^T08No05
		}
		if (null != dto.getBonDeduction09No05()) {
			setValueChk(odsBean, column, line + 9, dto.getBonDeduction09No05()); // ܗ^T09No05
		}
		if (null != dto.getBonDeduction10No05()) {
			setValueChk(odsBean, column, line + 10, dto.getBonDeduction10No05()); // ܗ^T10No05
		}
		if (null != dto.getBonDeduction11No05()) {
			setValueChk(odsBean, column, line + 11, dto.getBonDeduction11No05()); // ܗ^T11No05
		}
		if (null != dto.getBonDeduction12No05()) {
			setValueChk(odsBean, column, line + 12, dto.getBonDeduction12No05()); // ܗ^T12No05
		}
		if (null != dto.getBonDeduction14No05()) {
			setValueChk(odsBean, column, line + 13, dto.getBonDeduction14No05()); // ܗ^T14No05
		}
		if (null != dto.getBonDeduction15No05()) {
			setValueChk(odsBean, column, line + 14, dto.getBonDeduction15No05()); // ܗ^T15No05
		}
		if (null != dto.getBonDeduction16No05()) {
			setValueChk(odsBean, column, line + 15, dto.getBonDeduction16No05()); // ܗ^T16No05
		}
		if (null != dto.getBonDeduction17No05()) {
			setValueChk(odsBean, column, line + 16, dto.getBonDeduction17No05()); // ܗ^T17No05
		}
		if (null != dto.getBonDeductionTotal05()) {
			setValueChk(odsBean, column, line + 17, dto.getBonDeductionTotal05()); // ܗ^5ڍTڌv
		}
		if (null != dto.getBonPaymentTotal05()) {
			setValueChk(odsBean, column, line + 18, dto.getBonPaymentTotal05()); // ܗ^5ڍxzv
		}
		if (null != dto.getBonBank1PayAmount05()) {
			setValueChk(odsBean, column, line + 19, dto.getBonBank1PayAmount05()); // ܗ^5ڋs1Uzv
		}
		if (null != dto.getBonBank2PayAmount05()) {
			setValueChk(odsBean, column, line + 20, dto.getBonBank2PayAmount05()); // ܗ^5ڋs2Uzv
		}
		if (null != dto.getBonCashPayAmount05()) {
			setValueChk(odsBean, column, line + 21, dto.getBonCashPayAmount05()); // ܗ^5ڌxzv
		}
		
		line = 110;
		column = 18; // 6
		if (null != dto.getBonDeduction01No06()) {
			setValueChk(odsBean, column, line + 1, dto.getBonDeduction01No06()); // ܗ^T01No06
		}
		if (null != dto.getBonDeduction02No06()) {
			setValueChk(odsBean, column, line + 2, dto.getBonDeduction02No06()); // ܗ^T02No06
		}
		if (null != dto.getBonDeduction03No06()) {
			setValueChk(odsBean, column, line + 3, dto.getBonDeduction03No06()); // ܗ^T03No06
		}
		if (null != dto.getBonDeduction04No06()) {
			setValueChk(odsBean, column, line + 4, dto.getBonDeduction04No06()); // ܗ^T04No06
		}
		if (null != dto.getBonDeduction05No06()) {
			setValueChk(odsBean, column, line + 5, dto.getBonDeduction05No06()); // ܗ^T05No06
		}
		if (null != dto.getBonDeduction06No06()) {
			setValueChk(odsBean, column, line + 6, dto.getBonDeduction06No06()); // ܗ^T06No06
		}
		if (null != dto.getBonDeduction07No06()) {
			setValueChk(odsBean, column, line + 7, dto.getBonDeduction07No06()); // ܗ^T07No06
		}
		if (null != dto.getBonDeduction08No06()) {
			setValueChk(odsBean, column, line + 8, dto.getBonDeduction08No06()); // ܗ^T08No06
		}
		if (null != dto.getBonDeduction09No06()) {
			setValueChk(odsBean, column, line + 9, dto.getBonDeduction09No06()); // ܗ^T09No06
		}
		if (null != dto.getBonDeduction10No06()) {
			setValueChk(odsBean, column, line + 10, dto.getBonDeduction10No06()); // ܗ^T10No06
		}
		if (null != dto.getBonDeduction11No06()) {
			setValueChk(odsBean, column, line + 11, dto.getBonDeduction11No06()); // ܗ^T11No06
		}
		if (null != dto.getBonDeduction12No06()) {
			setValueChk(odsBean, column, line + 12, dto.getBonDeduction12No06()); // ܗ^T12No06
		}
		if (null != dto.getBonDeduction14No06()) {
			setValueChk(odsBean, column, line + 13, dto.getBonDeduction14No06()); // ܗ^T14No06
		}
		if (null != dto.getBonDeduction15No06()) {
			setValueChk(odsBean, column, line + 14, dto.getBonDeduction15No06()); // ܗ^T15No06
		}
		if (null != dto.getBonDeduction16No06()) {
			setValueChk(odsBean, column, line + 15, dto.getBonDeduction16No06()); // ܗ^T16No06
		}
		if (null != dto.getBonDeduction17No06()) {
			setValueChk(odsBean, column, line + 16, dto.getBonDeduction17No06()); // ܗ^T17No06
		}
		if (null != dto.getBonDeductionTotal06()) {
			setValueChk(odsBean, column, line + 17, dto.getBonDeductionTotal06()); // ܗ^6ڍTڌv
		}
		if (null != dto.getBonPaymentTotal06()) {
			setValueChk(odsBean, column, line + 18, dto.getBonPaymentTotal06()); // ܗ^6ڍxzv
		}
		if (null != dto.getBonBank1PayAmount06()) {
			setValueChk(odsBean, column, line + 19, dto.getBonBank1PayAmount06()); // ܗ^6ڋs1Uzv
		}
		if (null != dto.getBonBank2PayAmount06()) {
			setValueChk(odsBean, column, line + 20, dto.getBonBank2PayAmount06()); // ܗ^6ڋs2Uzv
		}
		if (null != dto.getBonCashPayAmount06()) {
			setValueChk(odsBean, column, line + 21, dto.getBonCashPayAmount06()); // ܗ^6ڌxzv
		}
		
		line = 110;
		column = 21; // Nԍv
		if (null != dto.getBonTotalDeduction01()) {
			setValueChk(odsBean, column, line + 1, dto.getBonTotalDeduction01()); // ܗ^T01NԌv
		}
		if (null != dto.getBonTotalDeduction02()) {
			setValueChk(odsBean, column, line + 2, dto.getBonTotalDeduction02()); // ܗ^T02NԌv
		}
		if (null != dto.getBonTotalDeduction03()) {
			setValueChk(odsBean, column, line + 3, dto.getBonTotalDeduction03()); // ܗ^T03NԌv
		}
		if (null != dto.getBonTotalDeduction04()) {
			setValueChk(odsBean, column, line + 4, dto.getBonTotalDeduction04()); // ܗ^T04NԌv
		}
		if (null != dto.getBonTotalDeduction05()) {
			setValueChk(odsBean, column, line + 5, dto.getBonTotalDeduction05()); // ܗ^T05NԌv
		}
		if (null != dto.getBonTotalDeduction06()) {
			setValueChk(odsBean, column, line + 6, dto.getBonTotalDeduction06()); // ܗ^T06NԌv
		}
		if (null != dto.getBonTotalDeduction07()) {
			setValueChk(odsBean, column, line + 7, dto.getBonTotalDeduction07()); // ܗ^T07NԌv
		}
		if (null != dto.getBonTotalDeduction08()) {
			setValueChk(odsBean, column, line + 8, dto.getBonTotalDeduction08()); // ܗ^T08NԌv
		}
		if (null != dto.getBonTotalDeduction09()) {
			setValueChk(odsBean, column, line + 9, dto.getBonTotalDeduction09()); // ܗ^T09NԌv
		}
		if (null != dto.getBonTotalDeduction10()) {
			setValueChk(odsBean, column, line + 10, dto.getBonTotalDeduction10()); // ܗ^T10NԌv
		}
		if (null != dto.getBonTotalDeduction11()) {
			setValueChk(odsBean, column, line + 11, dto.getBonTotalDeduction11()); // ܗ^T11NԌv
		}
		if (null != dto.getBonTotalDeduction12()) {
			setValueChk(odsBean, column, line + 12, dto.getBonTotalDeduction12()); // ܗ^T12NԌv
		}
		if (null != dto.getBonTotalDeduction14()) {
			setValueChk(odsBean, column, line + 13, dto.getBonTotalDeduction14()); // ܗ^T14NԌv
		}
		if (null != dto.getBonTotalDeduction15()) {
			setValueChk(odsBean, column, line + 14, dto.getBonTotalDeduction15()); // ܗ^T15NԌv
		}
		if (null != dto.getBonTotalDeduction16()) {
			setValueChk(odsBean, column, line + 15, dto.getBonTotalDeduction16()); // ܗ^T16NԌv
		}
		if (null != dto.getBonTotalDeduction17()) {
			setValueChk(odsBean, column, line + 16, dto.getBonTotalDeduction17()); // ܗ^T17NԌv
		}
		if (null != dto.getBonTotalDeductionTotal()) {
			setValueChk(odsBean, column, line + 17, dto.getBonTotalDeductionTotal()); // ܗ^Tڍv
		}
		if (null != dto.getBonTotalPaymentTotal()) {
			setValueChk(odsBean, column, line + 18, dto.getBonTotalPaymentTotal()); // ܗ^xzvv
		}
		if (null != dto.getBonTotalBank1PayAmount()) {
			setValueChk(odsBean, column, line + 19, dto.getBonTotalBank1PayAmount()); // ܗ^s1Uzvv
		}
		if (null != dto.getBonTotalBank2PayAmount()) {
			setValueChk(odsBean, column, line + 20, dto.getBonTotalBank2PayAmount()); // ܗ^s2Uzvv
		}
		if (null != dto.getBonTotalCashPayAmount()) {
			setValueChk(odsBean, column, line + 21, dto.getBonTotalCashPayAmount()); // ܗ^xzvv
		}
		
		// }{T\
		line = 126;
		column = 28;
		if (null != dto.getIncomeTaxType()) {
			setValueChk(odsBean, column + 0, line + 0, dto.getIncomeTaxType()); // ېŋ敪
		}
		if (null != dto.getAdjustmentType()) {
			setValueChk(odsBean, column + 0, line + 1, dto.getAdjustmentType()); // N敪
		}
		if (null != dto.getSelfWidowType()) {
			setValueChk(odsBean, column + 0, line + 2, dto.getSelfWidowType()); // {l敪PF{lǕw敪
		}
		if (null != dto.getSelfHandicapType()) {
			setValueChk(odsBean, column + 0, line + 3, dto.getSelfHandicapType()); // {l敪QF{lQ敪
		}
		if (null != dto.getSelfStudentType()) {
			setValueChk(odsBean, column + 0, line + 4, dto.getSelfStudentType()); // {l敪RF{lw敪
		}
		if (null != dto.getSpouseIntendType()) {
			setValueChk(odsBean, column + 0, line + 5, dto.getSpouseIntendType()); // zҋ敪
		}
		if (null != dto.getGeneralDependent()) {
			setValueChk(odsBean, column + 6, line + 0, dto.getGeneralDependent()); // ʕ}{e
		}
		if (null != dto.getSpecificDependent()) {
			setValueChk(odsBean, column + 6, line + 1, dto.getSpecificDependent()); // }{e
		}
		if (null != dto.getElderlyDependent()) {
			setValueChk(odsBean, column + 6, line + 2, dto.getElderlyDependent()); // Vl}{e
		}
		if (null != dto.getLiveWithEldRel()) {
			setValueChk(odsBean, column + 6, line + 3, dto.getLiveWithEldRel()); // Vle
		}
		if (null != dto.getGeneralHandicap()) {
			setValueChk(odsBean, column + 6, line + 5, dto.getGeneralHandicap()); // ʏQ
		}
		if (null != dto.getLiveWithHandiGe()) {
			setValueChk(odsBean, column + 12, line + 0, dto.getLiveWithHandiGe()); // 
		}
		if (null != dto.getLiveWithHandiSp()) {
			setValueChk(odsBean, column + 12, line + 1, dto.getLiveWithHandiSp()); // 
		}
		if (null != dto.getLiveWithHandiEl()) {
			setValueChk(odsBean, column + 12, line + 2, dto.getLiveWithHandiEl()); // Vl
		}
		if (null != dto.getLiveWithHandiEr()) {
			setValueChk(odsBean, column + 12, line + 3, dto.getLiveWithHandiEr()); // Ve
		}
		if (null != dto.getSpecificHandicap()) {
			setValueChk(odsBean, column + 12, line + 5, dto.getSpecificHandicap()); // ʏQ
		}
		
		// l
		if ((null != dto.getGender()) && (dto.getGender().equals("2"))) {
			setValueChk(odsBean, 13, 134, ""); // 
		} else {
			setValueChk(odsBean, 13, 134, "j"); // 
		}
		line = 135;
		column = 13;
		setValueChk(odsBean, column + 0, line + 0, dto.getBirthDate()); // N		
		setValueChk(odsBean, column + 0, line + 1, dto.getEntranceDate()); // Г		
		setValueChk(odsBean, column + 0, line + 2, dto.getRetirementDate()); // ގГ		
		
		line = 134;
		column = 21;
		setValueChk(odsBean, column + 0, line + 0, dto.getPostalCode()); // ZiX֔ԍj
		setValueChk(odsBean, column + 0, line + 1, dto.getAddress()); // Z
		setValueChk(odsBean, column + 0, line + 3, dto.getPhoneNumber()); // dbԍ		
		
		line = 134;
		column = 32;
		setValueChk(odsBean, column + 0, line + 0, dto.getHealthNo()); // Nیԍ
		setValueChk(odsBean, column + 6, line + 0, dto.getFundNo()); // ԍ
		setValueChk(odsBean, column + 0, line + 2, dto.getPensionNo()); // bNԍ
		setValueChk(odsBean, column + 6, line + 2, dto.getUnemployNo()); // ٗpیԍ
		
		// o͓eݒ
		String fileName = String.valueOf(vo.getHidAdjustYear()) + PayrollConst.FILE_NAME_SEPARATOR + dto.getKCode()
				+ PayrollConst.FILE_NAME_SEPARATOR + PayrollConst.FILE_PAYMENTLEDGER_ODS;
		
		request.setAttribute(MospConst.ATT_FILE_NAME, fileName);
		request.setAttribute(MospConst.ATT_FILE_OBJECT, odsBean.getSpreadSheet());
	}
	
}
