/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.payment.action;

import java.util.List;

import jp.mosp.common.common.BaseDto;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.payroll.base.PayrollAction;
import jp.mosp.payroll.dao.CmBankDao;
import jp.mosp.payroll.dao.CmBranchDao;
import jp.mosp.payroll.dto.CmBankDto;
import jp.mosp.payroll.dto.CmBranchDto;
import jp.mosp.payroll.payment.vo.CompanyBankBranchEditVo;

/**
 * sExX}X^̃eiXɕKvȋ@\񋟂B<br>
 * sExX}X^̈ꗗ\Ayѓo^EXV\B<br>
 */
public class CompanyBankBranchEditAction extends PayrollAction {
	
	// R}h
	private static final String	CMD_CM_BANK_BRANCH_SHOW			= "U5280";
	private static final String	CMD_CM_BANK_INSERT				= "U5281";
	private static final String	CMD_CM_BANK_UPDATE				= "U5282";
	private static final String	CMD_CM_BRANCH_INSERT			= "U5283";
	private static final String	CMD_CM_BRANCH_UPDATE			= "U5284";
	private static final String	CMD_CM_BANK_BRANCH_SELECT		= "U5285";
	private static final String	CMD_CM_BANK_BRANCH_RE_SEARCH	= "U5286";
	private static final String	CMD_CM_BANK_SEARCH				= "U5288";
	

	/**
	 * Action̏sB<br><br>
	 * ȉ̏sB
	 * <ul><li>
	 * {@link PayrollAction#PayrollAction()}
	 * </li></ul>
	 */
	public CompanyBankBranchEditAction() {
		super();
	}
	
	/* (non-Javadoc)
	 * @see jp.mosp.common.common.BaseAction#getSpecificVo()
	 */
	@Override
	protected BaseVo getSpecificVo() {
		return new CompanyBankBranchEditVo();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// PAYROLLmF
		confirmPayrollAuth();
		// VO擾yѐݒ
		prepareVo();
		CompanyBankBranchEditVo vo = (CompanyBankBranchEditVo)getVo();
		// DAO
		CmBankDao cmBankdao;
		CmBranchDao cmBranchdao;
		// DTO
		CmBankDto cmBankdto = null;
		CmBranchDto cmBranchdto = null;
		
		BaseDto[] aryDto = (BaseDto[])session.getAttribute(MospConst.ATT_DTO);
		if (aryDto != null) {
			cmBankdto = (CmBankDto)aryDto[0];
			cmBranchdto = (CmBranchDto)aryDto[1];
		}
		
		// R}h̏
		if (cmd.equals(CMD_CM_BANK_BRANCH_SHOW)) {
			// \e
			setInitItem(vo);
			// \
			vo.setMode(0);
			vo.setFormerKey(vo.KEY_BANK_CODE);
			vo.setIsAscending(true);
			vo.initListInfo();
		} else if (cmd.equals(CMD_CM_BANK_INSERT)) {
			// o^
			vo.setParams(request);
			cmBankdto = insert(vo);
			// \e
			setInitItem(vo);
			// 
			searchCompanyBankBranchEdit(vo);
			vo.setFormerKey(vo.KEY_BANK_CODE);
			vo.setIsAscending(true);
			vo.initListInfo();
		} else if (cmd.equals(CMD_CM_BANK_UPDATE)) {
			// XV
			vo.setParams(request);
			cmBankdto = update(vo, cmBankdto);
			// \e
			setInitItem(vo);
			// 
			searchCompanyBankBranchEdit(vo);
			vo.setFormerKey(vo.KEY_BANK_CODE);
			vo.setIsAscending(true);
			vo.initListInfo();
		} else if (cmd.equals(CMD_CM_BRANCH_INSERT)) {
			// o^
			vo.setParams2(request);
			cmBranchdto = insert2(vo);
			// \e
			setInitItem(vo);
			// 
			searchCompanyBankBranchEdit(vo);
			vo.setFormerKey(vo.KEY_BANK_CODE);
			vo.setIsAscending(true);
			vo.initListInfo();
		} else if (cmd.equals(CMD_CM_BRANCH_UPDATE)) {
			// XV
			vo.setParams2(request);
			cmBranchdto = update(vo, cmBranchdto);
			// \e
			setInitItem(vo);
			// 
			searchCompanyBankBranchEdit(vo);
			vo.setFormerKey(vo.KEY_BANK_CODE);
			vo.setIsAscending(true);
			vo.initListInfo();
		} else if (cmd.equals(CMD_CM_BANK_BRANCH_SELECT)) {
			// \()
			// DBRlNV̎擾yDTȌ
			getConnection();
			// s
			cmBankdao = new CmBankDao();
			cmBankdao.initDao(cfg, cmd, aspUser, user, conn);
			// sf[^̎擾
			cmBankdto = cmBankdao.findForKey(key1);
			// chkExistDTO̒l
			chkExist(cmBankdto);
			// VOɋsZbg
			vo.setFields(cmBankdto);
			// xXDaȍ
			cmBranchdao = new CmBranchDao();
			cmBranchdao.initDao(cfg, cmd, aspUser, user, conn);
			// xXf[^擾
			cmBranchdto = cmBranchdao.findForKey(key1, key2);
			// chkExistDTO̒l
			if (cmBranchdto != null) {
				chkExist(cmBranchdto);
				// VOɎxXZbg
				vo.setFields2(cmBranchdto);
				// ZbVDTOZbg
				aryDto = new BaseDto[2];
				aryDto[0] = cmBankdto;
				aryDto[1] = cmBranchdto;
				session.setAttribute(MospConst.ATT_DTO, aryDto);
				vo.setMode(1);
			} else {
				vo.setTxtBranchCode("");
				vo.setTxtBranchName("");
				vo.setTxtBranchKana("");
				// ZbVDTOZbg
				aryDto = new BaseDto[2];
				aryDto[0] = cmBankdto;
				aryDto[1] = null;
				session.setAttribute(MospConst.ATT_DTO, aryDto);
				vo.setMode(2);
			}
		} else if (cmd.equals(CMD_CM_BANK_BRANCH_RE_SEARCH)) {
			// Č
			vo.setParams(request);
			vo.setParams2(request);
			session.removeAttribute(MospConst.ATT_DTO);
			vo.setTxtBankCode("");
			vo.setTxtBankName("");
			vo.setTxtBankKana("");
			vo.setTxtBranchCode("");
			vo.setTxtBranchName("");
			vo.setTxtBranchKana("");
			vo.setMode(0);
			//
			searchCompanyBankBranchEdit(vo);
			vo.setFormerKey(vo.KEY_BANK_CODE);
			vo.setIsAscending(true);
			vo.initListInfo();
		} else if (cmd.equals(CMD_CM_BANK_SEARCH)) {
			// 
			vo.setParamsSearch(request);
			searchEmployeeList2(vo);
			vo.setFormerKey(vo.KEY_BANK_CODE);
			vo.setIsAscending(true);
			vo.initListInfo();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	/**
	 * ڏ
	 * @param vo
	 */
	private void setInitItem(CompanyBankBranchEditVo vo) {
		vo.setTxtBankCode("");
		vo.setTxtBankName("");
		vo.setTxtBankKana("");
		vo.setTxtBranchCode("");
		vo.setTxtBranchName("");
		vo.setTxtBranchKana("");
		
		vo.setTxtSearchBankCode("");
		vo.setTxtSearchBankKana("");
		vo.setTxtSearchBranchCode("");
		vo.setTxtSearchBranchKana("");
		
	}
	
	/**
	 * sExX}X^ꗗ擾B<br>
	 * <ol>
	 * <li>sExX}X^̑S擾B<br>
	 * <li>擾sExX}X^R[h̃XgVoɃZbgB<br>
	 * </ol>
	 * @param vo CompanyBankBranchEditVoCX^X
	 * @throws Exception Oꍇ
	 */
	private void searchCompanyBankBranchEdit(CompanyBankBranchEditVo vo) throws Exception {
		// DBRlNV̎擾
		getConnection();
		// Daȍ
		CmBankDao cmBankDao = new CmBankDao();
		CmBranchDao cmBranchDao = new CmBranchDao();
		// Dao
		cmBankDao.initDao(cfg, cmd, aspUser, user, conn);
		cmBranchDao.initDao(cfg, cmd, aspUser, user, conn);
		List<CmBranchDto> list2 = cmBranchDao.findForEmployeeList();
		// sXgݒ
		List<CmBankDto> list = cmBankDao.findForEmployeeList();
		vo.setFields2(list2);
		vo.setFields(list);
	}
	
	/**
	 * f[^}
	 * @param vo ΏVO
	 * @return f[^}ΏDTO
	 * @throws Exception Oꍇ
	 */
	public CmBankDto insert(CompanyBankBranchEditVo vo) throws Exception {
		// VÕ[hݒ		
		vo.setMode(0);
		// p[^̑ÓmF
		vo.validate();
		// RlNV̎擾yDAȌ
		getConnection();
		CmBankDao cmBankdao = new CmBankDao();
		cmBankdao.initDao(cfg, cmd, aspUser, user, conn);
		// ݃`FbN
		chkDuplicate(cmBankdao.findForKey(vo.getTxtBankCode()), vo);
		// DTO
		CmBankDto dto = new CmBankDto();
		vo.setDtoFields(dto);
		// f[^}
		cmBankdao.insert(dto);
		// DTOĎ擾
		dto = cmBankdao.findForKey(dto.getBankCode());
		// R~bg
		commit();
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_INSERT, ""));
		return dto;
	}
	
	/**
	 * f[^XV
	 * @param vo ΏVO
	 * @param dto ΏDTO
	 * @return f[^}ΏDTO
	 * @throws Exception Oꍇ
	 */
	public CmBankDto update(CompanyBankBranchEditVo vo, CmBankDto dto) throws Exception {
		// VÕ[hݒ
		vo.setMode(1);
		// p[^̑ÓmF
		vo.validate();
		// RlNV̎擾yDAȌ
		getConnection();
		CmBankDao dao = new CmBankDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// rmF
		chkExclusive(dto, dao.findForUpdate(vo.getTxtBankCode()), vo);
		// DTȌ
		vo.setDtoFields(dto);
		// f[^̍XV
		dao.update(dto, true);
		// DTO̍Ď擾
		CmBankDto retDto = dao.findForKey(dto.getBankCode());
		// R~bg
		commit();
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_UPDATE, ""));
		vo.setMode(0);
		return retDto;
	}
	
	/**
	 * f[^}
	 * @param vo ΏVO
	 * @return f[^}ΏDTO
	 * @throws Exception Oꍇ
	 */
	public CmBranchDto insert2(CompanyBankBranchEditVo vo) throws Exception {
		// VÕ[hݒ		
		vo.setMode(0);
		// p[^̑ÓmF
		vo.validate2();
		// RlNV̎擾yDAȌ
		getConnection();
		CmBankDao cmBankDao = new CmBankDao();
		CmBranchDto dto = new CmBranchDto();
		CmBranchDao dao = new CmBranchDao();
		cmBankDao.initDao(cfg, cmd, aspUser, user, conn);
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// s}X^ɑ݂ȂsR[h̏ꍇ͎xXo^Ȃ
		CmBankDto retDto = cmBankDao.findForKey(vo.getTxtBankCode());
		String bank;
		if (retDto == null) {
			bank = "";
		} else {
			bank = retDto.getBankCode();
		}
		String chk = vo.getTxtBankCode();
		// ݃`FbN
		chkDuplicate(dao.findForKey(vo.getTxtBankCode(), vo.getTxtBranchCode()), vo);
		if (chk.length() != bank.length()) {
			vo.setMessage("so^̏ꍇAxXo^͏o܂B");
		} else if (chk.length() == bank.length()) {
			// DTO
			vo.setDtoFields(dto);
			// f[^}
			dao.insert(dto);
			// DTOĎ擾
			dto = dao.findForKey(dto.getBankCode(), dto.getBranchCode());
			// R~bg
			commit();
			// bZ[Wݒ
			vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_INSERT, ""));
		}
		return dto;
	}
	
	/**
	 * f[^XV
	 * @param vo ΏVO
	 * @param dto ΏDTO
	 * @return f[^}ΏDTO
	 * @throws Exception Oꍇ
	 */
	public CmBranchDto update(CompanyBankBranchEditVo vo, CmBranchDto dto) throws Exception {
		// VÕ[hݒ
		vo.setMode(1);
		// p[^̑ÓmF
		vo.validate2();
		// RlNV̎擾yDAȌ
		getConnection();
		CmBranchDao dao = new CmBranchDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// rmF
		chkExclusive(dto, dao.findForUpdate(vo.getTxtBankCode(), vo.getTxtBranchCode()), vo);
		// DTȌ
		vo.setDtoFields(dto);
		// f[^̍XV
		dao.update(dto, true);
		// DTO̍Ď擾
		CmBranchDto retDto = dao.findForKey(dto.getBankCode(), dto.getBranchCode());
		// R~bg
		commit();
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_UPDATE, ""));
		vo.setMode(0);
		return retDto;
	}
	
	/**
	 * xXXg
	 * @param vo AdjustmentCalcVoCX^X
	 * @throws Exception Oꍇ
	 */
	private void searchEmployeeList2(CompanyBankBranchEditVo vo) throws Exception {
		// DBRlNV̎擾
		getConnection();
		// 
		CmBankDao cmBankDao = new CmBankDao();
		CmBranchDao cmBranchDao = new CmBranchDao();
		cmBankDao.initDao(cfg, cmd, aspUser, user, conn);
		cmBranchDao.initDao(cfg, cmd, aspUser, user, conn);
		List<CmBranchDto> list = cmBranchDao.findForCondition(vo.getEscTxtSearchBankCode(), vo
			.getEscTxtSearchBankKana(), vo.getEscTxtSearchBranchCode(), vo.getEscTxtSearchBranchKana());
		// tB[hɐݒ
		vo.setFields2(list);
		// sݒ
		List<CmBankDto> list2 = cmBankDao.findForCondition(vo.getEscTxtSearchBankCode(), vo.getEscTxtSearchBankKana(),
				vo.getEscTxtSearchBranchCode(), vo.getEscTxtSearchBranchKana());
		vo.setFields(list2);
		
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.getEscAryBankCode().length == 0 || vo.getEscAryBranchCode().length == 0) {
			vo.addErrMessage(MospUtility.getMessage(msg, MospConst.MSG_NO_DATA, ""));
			return;
		}
	}
	
}
