/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.dto;

import jp.mosp.common.common.BaseDto;

/**
 * @author koike
 *
 */
public class CmPaymentMeansDto extends BaseDto {
	
	private static final long	serialVersionUID	= 3322927888185971287L;
	
	// tB[h
	private String				kCode;										// ЈR[h
	private int					meansSequence;								// x@A
	private String				allowanceType;								// x敪
	private String				coBankCode;								// ЋsR[h
	private String				paidBankCode;								// UsR[h
	private String				paidBranchCode;							// UsxXR[h
	private String				accountType;								// a敪
	private String				accountNo;									// ԍ
	private String				holderName;								// `
	private String				holderKana;								// `ض
	private String				paymentMeans;								// x@
	private String				amountType;								// z敪
	private int					fixedAmount;								// Œz
	private int					deleteFlag;								// 폜tO
																			
	
	/**
	 * RXgN^
	 */
	public CmPaymentMeansDto() {
		super();
	}
	
	// ANZT\bh
	public String getKCode() {
		return kCode;
	} // ЈR[h
	
	public int getMeansSequence() {
		return meansSequence;
	} // x@A
	
	public String getAllowanceType() {
		return allowanceType;
	} // x敪
	
	public String getCoBankCode() {
		return coBankCode;
	} // ЋsR[h
	
	public String getPaidBankCode() {
		return paidBankCode;
	} // UsR[h
	
	public String getPaidBranchCode() {
		return paidBranchCode;
	} // UsxXR[h
	
	public String getAccountType() {
		return accountType;
	} // a敪
	
	public String getAccountNo() {
		return accountNo;
	} // ԍ
	
	public String getHolderName() {
		return holderName;
	} // `
	
	public String getHolderKana() {
		return holderKana;
	} // `ض
	
	public String getPaymentMeans() {
		return paymentMeans;
	} // x@
	
	public String getAmountType() {
		return amountType;
	} // z敪
	
	public int getFixedAmount() {
		return fixedAmount;
	} // Œz
	
	public int getDeleteFlag() {
		return deleteFlag;
	} // 폜tO
	
	public void setKCode(String kCode) {
		this.kCode = kCode;
	} // ЈR[h
	
	public void setMeansSequence(int meansSequence) {
		this.meansSequence = meansSequence;
	} // x@A
	
	public void setAllowanceType(String allowanceType) {
		this.allowanceType = allowanceType;
	} // x敪
	
	public void setCoBankCode(String coBankCode) {
		this.coBankCode = coBankCode;
	} // ЋsR[h
	
	public void setPaidBankCode(String paidBankCode) {
		this.paidBankCode = paidBankCode;
	} // UsR[h
	
	public void setPaidBranchCode(String paidBranchCode) {
		this.paidBranchCode = paidBranchCode;
	} // UsxXR[h
	
	public void setAccountType(String accountType) {
		this.accountType = accountType;
	} // a敪
	
	public void setAccountNo(String accountNo) {
		this.accountNo = accountNo;
	} // ԍ
	
	public void setHolderName(String holderName) {
		this.holderName = holderName;
	} // `
	
	public void setHolderKana(String holderKana) {
		this.holderKana = holderKana;
	} // `ض
	
	public void setPaymentMeans(String paymentMeans) {
		this.paymentMeans = paymentMeans;
	} // x@
	
	public void setAmountType(String amountType) {
		this.amountType = amountType;
	} // z敪
	
	public void setFixedAmount(int fixedAmount) {
		this.fixedAmount = fixedAmount;
	} // Œz
	
	public void setDeleteFlag(int deleteFlag) {
		this.deleteFlag = deleteFlag;
	} // 폜tO
	
}
