/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.common.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dto.MosPConfDto;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.legal.LegalConst;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.dto.AdjustmentDto;
import jp.mosp.payroll.dto.CdAdjustmentDto;

/**
 * @author 
 *
 */
public class AdjustmentCalcVo extends MosPVo {
	
	private static final long	serialVersionUID		= 3281945937471826907L;
	
	// URLACSS
	private static final String	RETURN_URL				= "/jsp/payroll/common/adjustmentCalc.jsp";
	private static final String	EXTRA_JS				= "/pub/payroll/common/js/adjustmentCalc.js";
	private static final String	EXTRA_CSS				= "/pub/payroll/common/css/adjustmentCalc.css";
	
	/**
	 * ʃTu^Cg
	 */
	public final String			SUB_TITLE				= PayrollConst.TTL_ADJUSTMENT_CALC;
	
	// p[^
	public static final String	PRM_TXT_K_CODE			= "txtKCode";
	public static final String	PRM_TXT_K_NAME			= "txtKName";
	public static final String	PRM_TXT_K_KANA			= "txtKKana";
	public static final String	PRM_PLT_RETIREMENT		= "pltRetirement";
	public static final String	PRM_PLT_POSITION		= "pltPosition";
	public static final String	PRM_PLT_ADJUSTMENT_TYPE	= "pltAdjustmentType";
	public static final String	PRM_PLT_MIDWAY_TYPE		= "pltMidwayType";
	public static final String	PRM_PLT_ADJUST_STATUS	= "pltAdjustStatus";
	public static final String	PRM_HID_ADJUST_YEAR		= "hidAdjustYear";
	
	// tB[hyѐ
	/**
	 * ЈR[h
	 */
	public static final String	NAM_K_CODE				= PayrollConst.NAM_M_KIHON_KCODE;
	public static final String	NAM_K_KANA				= PayrollConst.NAM_K_KANA;
	public static final String	NAM_ADJUST_YEAR			= PayrollConst.NAM_ADJUST_YEAR;
	public static final int		LEN_K_CODE				= PayrollConst.LEN_K_CODE;
	public static final int		LEN_K_NAME				= PayrollConst.LEN_K_NAME;
	
	// tB[h
	private int					hidAdjustYear;
	
	private String[]			aryAdjustStatus;
	private String[]			aryKCode;
	private String[]			aryKName;
	private String[]			aryKKana;
	private String[]			aryEntranceDate;
	private String[]			aryRetirementDate;
	private String[]			aryAdjustmentType;
	private String[]			aryTaxGap;
	
	private String				txtKCode;
	private String				txtKName;
	private String				txtKKana;
	private String				pltRetirement;
	private String				pltPosition;
	private String				pltAdjustmentType;
	private String				pltMidwayType;
	private String				pltAdjustStatus;
	
	// v_EXg
	public String[][]			aryPltRetirement;
	public String[][]			aryPltPosition;
	public String[][]			aryPltAdjustmentType;
	public String[][]			aryPltMidwayType;
	public String[][]			aryPltAdjustStatus;
	
	// \[gL[
	public final String			KEY_ADJUST_STATUS		= "KeyAdjustStatus";
	public final String			KEY_K_CODE				= "keyKCode";
	public final String			KEY_K_NAME				= "keyKName";
	public final String			KEY_ENTRANCE			= "keyEntrance";
	public final String			KEY_RETIREMENT			= "keyRetirement";
	public final String			KEY_ADJUSTMENT_TYPE		= "keyAdjustmentType";
	public final String			KEY_TAX_GAP				= "keyTaxGap";
	
	// ̎擾pz
	public String[][]			aryEra;
	
	/**
	 * ݒe[u
	 */
	public List<MosPConfDto>	listConf;
	

	/**
	 * RXgN^
	 * @throws MospException 
	 */
	public AdjustmentCalcVo() {
		super();
		setRetUrl(RETURN_URL);
		setExtraJs(EXTRA_JS);
		setExtraCss(EXTRA_CSS);
		hidAdjustYear = 0;
		txtKCode = "";
		txtKName = "";
		txtKKana = "";
		pltRetirement = "";
		pltPosition = "";
		pltAdjustmentType = "";
		pltMidwayType = "";
		pltAdjustStatus = "";
		aryAdjustStatus = new String[0];
		aryKCode = new String[0];
		aryKName = new String[0];
		aryKKana = new String[0];
		aryEntranceDate = new String[0];
		aryRetirementDate = new String[0];
		aryAdjustmentType = new String[0];
		aryTaxGap = new String[0];
		setFormerKey(KEY_K_CODE);
	}
	
	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	@Override
	public void setParams(HttpServletRequest request) {
		hidAdjustYear = getIntParam(request.getParameter(PRM_HID_ADJUST_YEAR));
		txtKCode = request.getParameter(PRM_TXT_K_CODE);
		txtKName = request.getParameter(PRM_TXT_K_NAME);
		txtKKana = request.getParameter(PRM_TXT_K_KANA);
		pltRetirement = request.getParameter(PRM_PLT_RETIREMENT);
		pltPosition = request.getParameter(PRM_PLT_POSITION);
		pltAdjustmentType = request.getParameter(PRM_PLT_ADJUSTMENT_TYPE);
		pltMidwayType = request.getParameter(PRM_PLT_MIDWAY_TYPE);
		pltAdjustStatus = request.getParameter(PRM_PLT_ADJUST_STATUS);
	}
	
	/**
	 * tB[h
	 * @throws MospException 
	 */
	public void initFields() throws MospException {
		// z̏
		count = 0;
		aryAdjustStatus = new String[count];
		aryKCode = new String[count];
		aryKName = new String[count];
		aryKKana = new String[count];
		aryEntranceDate = new String[count];
		aryRetirementDate = new String[count];
		aryAdjustmentType = new String[count];
		aryTaxGap = new String[count];
		// ꗗ񏉊
		initListInfo();
	}
	
	/**
	 * tB[hݒ
	 * @param list ЈXg
	 * @throws MospException 
	 */
	@Override
	public void setFields(List list) throws MospException {
		// Xg̐ݒ
		this.list = list;
		// f[^̎擾
		count = list.size();
		// z̏
		aryAdjustStatus = new String[count];
		aryKCode = new String[count];
		aryKName = new String[count];
		aryKKana = new String[count];
		aryEntranceDate = new String[count];
		aryRetirementDate = new String[count];
		aryAdjustmentType = new String[count];
		aryTaxGap = new String[count];
		// f[^̐ݒ
		int i = 0;
		Iterator it = list.iterator();
		while (it.hasNext()) {
			AdjustmentDto dto = (AdjustmentDto)it.next();
			aryKCode[i] = escapeHTML(dto.getKCode());
			aryKName[i] = escapeHTML(dto.getKName());
			aryKKana[i] = escapeHTML(dto.getKKana());
//			aryEntranceDate  [i] = escapeHTML(getDateString(listConf, aryEra, dto.getEntranceDate  ()));
//			aryRetirementDate[i] = escapeHTML(getDateString(listConf, aryEra, dto.getRetirementDate()));
			aryEntranceDate[i] = escapeHTML(getDateString(listConf, aryEra, DateUtil.convIntegerDateToDate(dto
				.getEntranceDate())));
			aryRetirementDate[i] = escapeHTML(getDateString(listConf, aryEra, DateUtil.convIntegerDateToDate(dto
				.getRetirementDate())));
			aryTaxGap[i] = insertComma(String.valueOf(dto.getTaxGap()));
			aryAdjustStatus[i] = PayrollConst.ADJU_STATUS_NON_NAME;
			for (String[] aryPltAdjustStatu : aryPltAdjustStatus) {
				if (aryPltAdjustStatu[0].equals(dto.getAdjustStatus())) {
					aryAdjustStatus[i] = escapeHTML(aryPltAdjustStatu[1]);
					break;
				}
			}
			aryAdjustmentType[i] = "";
			for (String[] element : LegalConst.ADJUSTMENT_ARRAY) {
				if (element[0].equals(dto.getAdjustmentType())) {
					aryAdjustmentType[i] = escapeHTML(element[1]);
					break;
				}
			}
			i++;
		}
	}
	
	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto        ݒΏDTO
	 * @param kCode      ݒЈR[h
	 * @param adjustYear ݒ蒲N
	 */
	public void setDtoFields(CdAdjustmentDto dto, String kCode, int adjustYear) {
		dto.setKCode(kCode); // ЈR[h
		dto.setAdjustYear(adjustYear); // N
		dto.setGeneralLifeIns(0); // ʂ̐ی
		dto.setPrivatePension(0); // lNی
		dto.setLifeInsDeduction(0); // یTz
		dto.setEarthquakeIns(0); // nkی
		dto.setLongTermDamageIns(0); // Qی
		dto.setDamageInsDeduction(0); // QیTz
		dto.setSocialInsDeduction(0); // ЉیTz
		dto.setMutualAidDeduction(0); // K͊Ƌϓ|Tz
		dto.setSpouseSumIncome(0); // z҂̖{N̍vžϊz
		dto.setSpouseSpDeduction(0); // zғʍTz
		dto.setHouseLoanDeduction(0); // ZؓʍTz
		dto.setAllowanceAdjustment(0); // xz
		dto.setTaxFreeAdjustment(0); // ېŒz
		dto.setSocInsAdjustment(0); // Љیz
		dto.setTaxIncAdjustment(0); // Œz
		dto.setWithholdSlipNotes(""); // 򒥎[Ev
		dto.setPaymentAllowance(0); // ^A蓖z
		dto.setPaymentIncomeTax(0); // ^A蓖Ŋz
		dto.setBonusAllowance(0); // ܗ^z
		dto.setBonusIncomeTax(0); // ܗ^Ŋz
		dto.setMidwayAdjustIncome(0); // rAz
		dto.setMidwayAdjustTax(0); // rAŊz
		dto.setAfterDeductIncome(0); // ^T̋^̋z
		dto.setPayInsDeduction(0); // Љی^̍T
		dto.setDependentsDeduction(0); // zҍTzA}{TzAbTzyяQғ̍Tz̍vz
		dto.setCalcTaxedIncome(0); // ېŋ^z
		dto.setCalcIncomeTax(0); // ZoNŊz
		dto.setAdjustedIncomeTax(0); // NNŊz
		dto.setDeductedIncomeTax(0); // N藦TzŊz
		dto.setFinalIncomeTax(0); // NŊz
		dto.setDeadRetirement(String.valueOf(PayrollConst.CHECKBOX_OFF));
		dto.setSelfDisaster(String.valueOf(PayrollConst.CHECKBOX_OFF));
		dto.setForeigner(String.valueOf(PayrollConst.CHECKBOX_OFF));
	}
	
	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		return sb.toString();
	}
	
	/**
	 * J}}
	 * @param strTarget
	 * @return
	 */
	public String insertComma(String strTarget) {
		if (strTarget == null || strTarget.equals("")) {
			return "";
		}
		return strTarget.replaceAll("(?m)(?<=\\d)(?=(?:\\d{3})+$)", ",");
	}
	
	// ANZT\bh
	public String[] getEscAryAdjustStatus() {
		return aryAdjustStatus.clone();
	}
	
	public String[] getEscAryKCode() {
		return aryKCode.clone();
	}
	
	public String[] getEscAryKName() {
		return aryKName.clone();
	}
	
	public String[] getEscAryKKana() {
		return aryKKana.clone();
	}
	
	public String[] getEscAryEntranceDate() {
		return aryEntranceDate.clone();
	}
	
	public String[] getEscAryRetirementDate() {
		return aryRetirementDate.clone();
	}
	
	public String[] getEscAryAdjustmentType() {
		return aryAdjustmentType.clone();
	}
	
	public String[] getEscAryTaxGap() {
		return aryTaxGap.clone();
	}
	
	public int getHidAdjustYear() {
		return hidAdjustYear;
	}
	
	public String getTxtKCode() {
		return txtKCode;
	}
	
	public String getTxtKName() {
		return txtKName;
	}
	
	public String getTxtKKana() {
		return txtKKana;
	}
	
	public String getPltRetirement() {
		return pltRetirement;
	}
	
	public String getPltPosition() {
		return pltPosition;
	}
	
	public String getPltAdjustmentType() {
		return pltAdjustmentType;
	}
	
	public String getPltMidwayType() {
		return pltMidwayType;
	}
	
	public String getPltAdjustStatus() {
		return pltAdjustStatus;
	}
	
	public String getEscTxtKCode() {
		return escapeHTML(txtKCode);
	}
	
	public String getEscTxtKName() {
		return escapeHTML(txtKName);
	}
	
	public String getEscTxtKKana() {
		return escapeHTML(txtKKana);
	}
	
	public void setHidAdjustYear(int hidAdjustYear) {
		this.hidAdjustYear = hidAdjustYear;
	}
	
	public void setPltRetirement(String pltRetirement) {
		this.pltRetirement = pltRetirement;
	}
	
	/**
	 * @param pltAdjustmentType
	 */
	public void setPltAdjustmentType(String pltAdjustmentType) {
		this.pltAdjustmentType = pltAdjustmentType;
	}
	
}
