/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.bonus.action;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.FileUploadUtility;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.common.ValidateUtility;
import jp.mosp.common.dao.MosPConfDao;
import jp.mosp.common.dto.MosPConfDto;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.kintai.common.dao.MKaisyaDao;
import jp.mosp.kintai.common.dto.MKaisyaDto;
import jp.mosp.legal.LegalConst;
import jp.mosp.payroll.base.Bonus;
import jp.mosp.payroll.base.Employee;
import jp.mosp.payroll.base.Payment;
import jp.mosp.payroll.base.PayrollAction;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.bonus.BonusConst;
import jp.mosp.payroll.bonus.dao.PdBonAllowanceDao;
import jp.mosp.payroll.bonus.dao.PdBonDeductionDao;
import jp.mosp.payroll.bonus.dao.PdBonSumDao;
import jp.mosp.payroll.bonus.dao.PhBounsDao;
import jp.mosp.payroll.bonus.dao.PiBonusDao;
import jp.mosp.payroll.bonus.dao.PmExtraDao;
import jp.mosp.payroll.bonus.dto.PhBasisDto;
import jp.mosp.payroll.bonus.dto.PhBounsDto;
import jp.mosp.payroll.bonus.dto.PmDetailBsDto;
import jp.mosp.payroll.bonus.dto.PmExtraDto;
import jp.mosp.payroll.bonus.dto.PsDetailDto;
import jp.mosp.payroll.bonus.vo.BonusCalcVo;
import jp.mosp.payroll.dao.CmCompanyDao;
import jp.mosp.payroll.dao.CmPaymentMeansDao;
import jp.mosp.payroll.dao.PdPayAllowanceDao;
import jp.mosp.payroll.dao.PdPayBreakdownDao;
import jp.mosp.payroll.dao.PdPayDeductionDao;
import jp.mosp.payroll.dao.PdPaySumDao;
import jp.mosp.payroll.dao.PdPayTimeDao;
import jp.mosp.payroll.dao.PhPaymentDao;
import jp.mosp.payroll.dao.PmDetailPaDao;
import jp.mosp.payroll.dao.PmDetailPbDao;
import jp.mosp.payroll.dao.PmDetailPdDao;
import jp.mosp.payroll.dao.PmDetailPsDao;
import jp.mosp.payroll.dao.PmDetailPtDao;
import jp.mosp.payroll.dao.PtCurrentDao;
import jp.mosp.payroll.dto.CmPaymentMeansDto;
import jp.mosp.payroll.dto.DetailTimeDto;
import jp.mosp.payroll.dto.PhPaymentDto;
import jp.mosp.payroll.dto.PtCurrentDto;

import org.apache.commons.csv.CSVParser;

/**
 * @author koike
 *
 */
public class BonusCalcAction extends PayrollAction {
	
	// tB[h
	// vZsCX^X(ܗ^)
	
	/**
	 * Ώۏܗ^f[^
	 */
	protected PhBounsDto							phBounsDto;
	
	// R}h
	private static final String						CMD_BONUS_CALC_SHOW		= "P2001";
	private static final String						CMD_BONUS_CALC_UPLOAD	= "P2002";
	private static final String						CMD_BONUS_CALC_DELETE	= "P2003";
	private static final String						CMD_BONUS_CALC_TAX		= "P2004";
	/**
	 * m菈
	 */
	private static final String						CMD_BONUS_CALC_TOTAL	= "P2005";
	/**
	 * ܗ^ev[go
	 */
	private static final String						CMD_BONUS_TEMPLATE_OUT	= "P2006";
	
	/**
	 * 
	 */
	public String[][]								aryBonusHeaderItem;
	
	private String[]								aryCsvData;
	private String[]								aryHeaderData;
	private String[]								aryRegistCsvData;
	private String[]								aryRegistHeaderData;
	private String[]								aryHeaderNo;
	private int										csvRegistDataCount		= 0;
	private int										csvDataCount			= 0;
	
	private boolean									isAddRegistData			= true;
	
	/**
	 * 
	 */
	protected PhBasisDto							phBasisDto;
	
	/** p֌Wz΁ApŒ` **/
	// vZp
	public int										sumAllowance			= 0;
	/**
	 * 
	 */
	public int										sumDeduction			= 0;
	/**
	 * 
	 */
	public int										sumDatail				= 0;
	
	/**
	 * s1Uz
	 */
	protected int									bank1Amount				= 0;
	/**
	 * s2Uz
	 */
	protected int									bank2Amount				= 0;
	/**
	 * xz
	 */
	protected int									cashAmount				= 0;
	/**
	 * NJn
	 */
	protected Date									startDateOfYear;
	/**
	 * NŏI
	 */
	protected Date									lastDateOfYear;
	/**
	 * 
	 */
	protected String								kCode;
	/**
	 * 
	 */
	protected Date									targetMonth;
	// אݒ(ܗ^)
	/**
	 * 
	 */
	protected Map<String, Map<String, PsDetailDto>>	mapBonusDetailAll;
	/**
	 * ỎېőΏۊz擾pN
	 */
	Date											befTargetMonth;
	

	/* (non-Javadoc)
	 * @see jp.mosp.common.common.BaseAction#getSpecificVo()
	 */
	@Override
	protected BaseVo getSpecificVo() {
		return new BonusCalcVo();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO擾yѐݒ
		prepareVo();
		// DBRlNV擾
		getConnection();
		// PAYROLLmF
		confirmPayrollAuth();
		// VO擾
		BonusCalcVo vo = (BonusCalcVo)getVo();
		
		// R}h̏
		if (cmd.equals(CMD_BONUS_CALC_SHOW)) {
			// Nv_Eݒ(vZN)
			setYearMonth(vo, getCalcCurrent(), true);
			// Xg擾
			vo.aryPltStationAll = getStationArrayAll();
			
			//DAO
			CmCompanyDao dao = new CmCompanyDao();
			dao.initDao(cfg, cmd, aspUser, user, conn);
			
			if (dao.findAll() == null) {
				addErrMessage(getMessage("WP5001", ""));
				vo.setMode(1);
			} else {
				vo.setMode(0);
			}
			
		} else if (cmd.equals(CMD_BONUS_CALC_UPLOAD)) {
			// t@Cݒ
			vo.setUploadFile(multipartFieldList);
			// Ώ۔N擾
			setTargetMonth(vo);
			// ܗ^Abv[h
			upload(vo);
		} else if (cmd.equals(CMD_BONUS_CALC_TAX)) {
			// N̐ݒ
			vo.setYearParams(request);
			// Ώ۔NAܗ^xݒ
			setTargetMonth(vo);
			// @TvZ
			calcLegalDeduction(vo);
			
		} else if (cmd.equals(CMD_BONUS_CALC_TOTAL)) {
			// N̐ݒ
			vo.setYearParams(request);
			// Ώ۔NAܗ^xݒ
			setTargetMonth(vo);
			// @TvZvۊmF
			if (vo.needCalcLegalDeduction()) {
				// @TvZ
				calcLegalDeduction(vo);
			}
			// m菈
			calcTotal(vo);
		} else if (cmd.equals(CMD_BONUS_CALC_DELETE)) {
			// NGXgݒ
			vo.setYearParams(request);
			// Ώ۔N擾
			setTargetMonth(vo);
			// 폜(vZN)
			delete(vo);
		} else if (cmd.equals(CMD_BONUS_TEMPLATE_OUT)) {
			bonusTemplateOut();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	/**
	 * Nݒ
	 * @param vo          ݒΏVO
	 * @param calcCurrent vZ
	 */
	private void setYearMonth(BonusCalcVo vo, Date calcCurrent, boolean isSetPulldown) {
		// v_E擾
		vo.aryPltYear = getYearArrayLong(MospUtility.getYear(calcCurrent));
		vo.aryPltMonth = getMonthArray();
		vo.aryPltDay = getDayArray();
		if (isSetPulldown) {
			// Nݒ
			vo.setPltYear(String.valueOf(MospUtility.getYear(calcCurrent)));
			vo.setPltMonth(String.valueOf(MospUtility.getMonth(calcCurrent)));
			vo.setPltDay(String.valueOf(MospUtility.getDay(calcCurrent)));
			vo.setPltDetailYear(String.valueOf(MospUtility.getYear(calcCurrent)));
			vo.setPltDetailMonth(String.valueOf(MospUtility.getMonth(calcCurrent)));
			vo.setPltDetailDay(String.valueOf(MospUtility.getDay(calcCurrent)));
		}
	}
	
	/**
	 * Abv[h
	 * @param vo
	 */
	private void upload(BonusCalcVo vo) throws Exception {
		// DBRlNV擾
		getConnection();
		// ^wb_[ڎ擾
		aryBonusHeaderItem = getBonusUploadHeadItem();
		// N̊mF
		chkRegsitDate(vo);
		// t@C^Cv`FbN
		if (vo.getFilUploadFile().getName().matches(".*" + ".csv" + ".*")) {
			// csvp[Xt@C擾
			CSVParser csvp = FileUploadUtility.parseCSVData(vo.getFilUploadFile());
			String[] lineHead;
			lineHead = getCSVHeadData(csvp);
			String[] lineData;
			boolean isInsertData = true;
			// wb_쐬
			createUploadHeader(vo, lineHead);
			// f[^쐬
			while (isInsertData) {
				lineData = getCSVData(csvp, csvDataCount);
				if (lineData != null) {
					// f[^쐬
					if (createUploadData(vo, lineData)) {
						// Ј݊mF
						if (chkEmploymentData(vo) == false) {
							csvDataCount++;
							// f[^sɃG[ꍇ͂̍so^Ȃ
							continue;
						}
						// vIG[mF(f[^)
						chkErrorData(vo);
						// Abv[h\G[mF
						chkUploadErrorData(vo);
						// PI_BONUSo^
						uploadData(vo, lineHead, lineData);
					}
					csvDataCount++;
				} else {
					isInsertData = false;
				}
			}
			if (csvRegistDataCount == 0) {
				// f[^G[
				String errMessage = MospUtility.getMessage(msg, BonusConst.MSG_NO_CSV_DATA, "");
				addErrMessage(errMessage);
				throw new MospException(MospConst.EX_PARAMS_INVALID);
			}
			// bZ[Wݒ
			vo.setMessage(MospUtility.getMessage(msg, BonusConst.MSG_CSV_UPLOAD, String.valueOf(csvRegistDataCount)));
		} else {
			// t@C^CvG[
			String errMessage = MospUtility.getMessage(msg, BonusConst.MSG_INVALID_FILE_TYPE, "");
			addErrMessage(errMessage);
			throw new MospException(MospConst.EX_PARAMS_INVALID);
		}
	}
	
	/**
	 * CSVf[^쐬B
	 * @param csvTarget 쐬CSVParser
	 * @param idx       쐬Ώۍs(Oɂ̂ݗp)
	 * @return f[^z
	 * @throws MospException f[^`s
	 */
	@Override
	protected String[] getCSVData(CSVParser csvTarget, int idx) throws MospException {
		String[] line;
		try {
			line = csvTarget.getLine();
			if (line == null) {
				return line;
			}
		} catch (IOException e) {
			// `G[
			String errMessage = MospUtility.getMessage(msg, "WC0017", String.valueOf(idx + 1));
			addErrMessage(errMessage);
			throw new MospException(MospConst.EX_PARAMS_INVALID);
		}
		return line;
	}
	
	/**
	 * Ώ۔Nݒ
	 * @param vo          ΏVO
	 * @param targetMonth ݒN
	 * @throws Exception
	 */
	public void setTargetMonth(BonusCalcVo vo) throws Exception {
		// vZN
		vo.setCalcDate();
		// ܗ^x
		vo.setPayday();
	}
	
	/**
	 * o^ÓmF
	 * @param vo
	 * @throws Exception 
	 */
	protected void chkRegsitDate(BonusCalcVo vo) throws Exception {
		// x̑ÓmF
		vo.checkTargetDate();
		// vZNmF
//		checkCalcCurrentAfter(vo.getCalcDate());
	}
	
	/**
	 * vIG[mF(f[^)
	 * @param vo
	 * @throws MospException
	 */
	protected void chkErrorData(BonusCalcVo vo) throws MospException {
		// ЈR[hwb_擾`FbN
		if (vo.getIdxKCode() == 99) {
			// L[̎擾G[
			String errMessage = MospUtility.getMessage(msg, BonusConst.MSG_NO_UPLOAD_KEY, "ЈR[h" + "("
					+ BonusConst.UP_K_CODE + ")");
			addErrMessage(errMessage);
			throw new MospException(MospConst.EX_PARAMS_INVALID);
		}
		// wb_ƒl̐ك`FbN
		if (aryHeaderData.length != aryCsvData.length) {
			String errMessage = MospUtility.getMessage(msg, BonusConst.MSG_INVALID_CSV_COUNT, String
				.valueOf(csvDataCount + 1));
			addErrMessage(errMessage);
			throw new MospException(MospConst.EX_PARAMS_INVALID);
		}
	}
	
	/**
	 * Abv[h\f[^擾
	 * @param vo
	 * @throws Exception 
	 */
	protected void chkUploadErrorData(BonusCalcVo vo) throws Exception {
		// G[mFȌԂi[
		ArrayList<String> listHeadItem = new ArrayList<String>();
		ArrayList<String> listDataItem = new ArrayList<String>();
		for (int i = 0; i < aryCsvData.length; i++) {
			// f[^ÓmF
			isAddRegistData = validate(aryCsvData[i], aryHeaderData[i], i, csvDataCount, vo);
			if (isAddRegistData) {
				// אݒmF
				if (!aryHeaderData[i].equals(BonusConst.UP_K_CODE)) {
					isAddRegistData = chkNoSettingDetail(i);
				}
				if (isAddRegistData) {
					//f[^̂ݎ擾
					listHeadItem.add(aryHeaderNo[i]);
					listDataItem.add(aryCsvData[i]);
				}
			}
			// 
			isAddRegistData = true;
		}
		// o^zݒ
		aryRegistHeaderData = new String[listHeadItem.size()];
		aryRegistCsvData = new String[listDataItem.size()];
		
		for (int i = 0; i < listHeadItem.size(); i++) {
			
			String headerData = listHeadItem.get(i);
			String csvData = listDataItem.get(i);
			aryRegistHeaderData[i] = headerData;
			aryRegistCsvData[i] = csvData;
		}
	}
	
	/**
	 * אݒ肪ȂڊmF
	 * @param vo PayCalculateVoCX^X
	 * @throws Exception
	 */
	private boolean chkNoSettingDetail(int idx) throws Exception {
		// vZ
		boolean isRegist = true;
		// IꂽЈ̌ٗp敪Eʂ׍ڂ̃}bv擾
		Map<String, PsDetailDto> mapDetail = getMapBonusDetail();
		if (mapDetail == null) {
			// ݒ肪؂ĂȂꍇ̓G[
//			String errMessage = MospUtility.getMessage(msg, BonusConst.MSG_NO_DETAIL_DATA, this.phBounsDto.getEmploymentType());
//			addErrMessage(errMessage);
			isRegist = false;
			return isRegist;
		}
		PsDetailDto psDetailDto = mapDetail.get(aryHeaderData[idx]);
		// ݒ肪Ȃz
		if (psDetailDto == null) {
			if (!aryCsvData[idx].equals("0")) {
				// ݒ肪̂ɂO~łȂꍇ̓G[
				String errMessage = MospUtility.getMessage(msg, BonusConst.MSG_NOT_UP_EMP_TYPE, aryHeaderData[idx]
						+ BonusConst.KEY_SEPARATOR + String.valueOf(csvDataCount + 1));
				addErrMessage(errMessage);
				isRegist = false;
				
			}
		}
		return isRegist;
	}
	
	/**
	 * Abv[hf[^XV
	 * @param vo
	 * @throws Exception
	 */
	protected void uploadData(BonusCalcVo vo, String[] lineHead, String[] lineData) throws Exception {
		PmDetailBsDto allowanceDto;
		PmDetailBsDto deductionDto;
		PmDetailBsDto sumDto;
		Employee employee;
		sumAllowance = 0; // xz
		sumDeduction = 0; // Tz
		sumDatail = 0; // xz
		bank1Amount = 0; // s1Uz
		bank2Amount = 0; // s2Uz
		cashAmount = 0; // xz
		
		employee = getEmployee(lineData[0]);
		if (null == employee) {
			return;
		}
		
		List<PmDetailBsDto> listAllowance = new ArrayList<PmDetailBsDto>();
		List<PmDetailBsDto> listDeduction = new ArrayList<PmDetailBsDto>();
		List<PmDetailBsDto> listSum = new ArrayList<PmDetailBsDto>();
		
		for (int i = 1; i < lineData.length; i++) {
			if (!lineData[i].equals("")) {
				if (lineHead[i].startsWith("BA")) {
					allowanceDto = new PmDetailBsDto();
					allowanceDto.setKCode(lineData[0]);
					allowanceDto.setCalcDate(vo.getPayday());
					allowanceDto.setDetailCode(lineHead[i]);
					allowanceDto.setAmount(Integer.valueOf(lineData[i]));
					listAllowance.add(allowanceDto);
					sumAllowance += Integer.valueOf(lineData[i]);
				} else if (lineHead[i].startsWith("BD")) {
					deductionDto = new PmDetailBsDto();
					deductionDto.setKCode(lineData[0]);
					deductionDto.setCalcDate(vo.getPayday());
					deductionDto.setDetailCode(lineHead[i]);
					deductionDto.setAmount(Integer.valueOf(lineData[i]));
					listDeduction.add(deductionDto);
					sumDeduction += Integer.valueOf(lineData[i]);
				}
				
			}
		}
		// xe[u̍쐬
		sumDatail = sumAllowance - sumDeduction;
		calcDivideAccounts(employee); // esւ̐UzyьxzvZ
		
		// xz
		sumDto = new PmDetailBsDto();
		sumDto.setKCode(lineData[0]);
		sumDto.setCalcDate(vo.getPayday());
		sumDto.setDetailCode("BS001");
		sumDto.setAmount(sumAllowance);
		listSum.add(sumDto);
		// Tz
		sumDto = new PmDetailBsDto();
		sumDto.setKCode(lineData[0]);
		sumDto.setCalcDate(vo.getPayday());
		sumDto.setDetailCode("BS002");
		sumDto.setAmount(sumDeduction);
		listSum.add(sumDto);
		// xz
		sumDto = new PmDetailBsDto();
		sumDto.setKCode(lineData[0]);
		sumDto.setCalcDate(vo.getPayday());
		sumDto.setDetailCode("BS003");
		sumDto.setAmount(sumDatail);
		listSum.add(sumDto);
		
		// s1Uz
		sumDto = new PmDetailBsDto();
		sumDto.setKCode(lineData[0]);
		sumDto.setCalcDate(vo.getPayday());
		sumDto.setDetailCode("BS011");
		sumDto.setAmount(bank1Amount);
		listSum.add(sumDto);
		// s2Uz
		sumDto = new PmDetailBsDto();
		sumDto.setKCode(lineData[0]);
		sumDto.setCalcDate(vo.getPayday());
		sumDto.setDetailCode("BS012");
		sumDto.setAmount(bank2Amount);
		listSum.add(sumDto);
		// xz
		sumDto = new PmDetailBsDto();
		sumDto.setKCode(lineData[0]);
		sumDto.setCalcDate(vo.getPayday());
		sumDto.setDetailCode("BS013");
		sumDto.setAmount(cashAmount);
		listSum.add(sumDto);
		
		PhBounsDto phBounsDto = new PhBounsDto();
		phBounsDto.setKCode(lineData[0]);
		phBounsDto.setCalcMonth(vo.getPayday());
		phBounsDto.setPayDate(MospUtility.getDate("1970/01/01"));
		phBounsDto.setSlipCode("B***");
		phBounsDto.setAllowanceTotal(sumAllowance);
		phBounsDto.setDeductionTotal(sumDeduction);
		phBounsDto.setPaymentTotal(sumDatail);
		
		// DAO̕⑫
		PdBonAllowanceDao pdBonAllowanceDao = new PdBonAllowanceDao(cfg, cmd, aspUser, user, conn);
		pdBonAllowanceDao.initDao(cfg, cmd, aspUser, user, conn);
		
		PdBonDeductionDao pdBonDeductionDao = new PdBonDeductionDao(cfg, cmd, aspUser, user, conn);
		pdBonDeductionDao.initDao(cfg, cmd, aspUser, user, conn);
		
		PdBonSumDao pdBonSumDao = new PdBonSumDao(cfg, cmd, aspUser, user, conn);
		pdBonSumDao.initDao(cfg, cmd, aspUser, user, conn);
		
		PhBounsDao phBounsDao = new PhBounsDao(cfg, cmd, aspUser, user, conn);
		phBounsDao.initDao(cfg, cmd, aspUser, user, conn);
		
		// f[^̍폜
		pdBonAllowanceDao.delete(lineData[0], vo.getPayday());
		pdBonDeductionDao.delete(lineData[0], vo.getPayday());
		pdBonSumDao.delete(lineData[0], vo.getPayday());
		phBounsDao.deleteForCalcdate(lineData[0], vo.getPayday());
		
		// o^
		phBounsDao.insert(phBounsDto, true);
		pdBonAllowanceDao.insert(listAllowance);
		pdBonDeductionDao.insert(listDeduction);
		pdBonSumDao.insert(listSum);
		
		// R~bg
		commit();
		
		csvRegistDataCount++;
	}
	
	/**
	 * Abv[hpz쐬iwb_j
	 * @param vo PayCalculateVoCX^X
	 * @param line 
	 * @return 
	 * @throws Exception
	 */
	private boolean createUploadHeader(BonusCalcVo vo, String[] line) throws Exception {
		aryHeaderNo = new String[line.length];
		aryHeaderData = new String[line.length];
		aryHeaderData = line;
		// ЈR[h݃`FbNp
		vo.setIdxKCode(99);
		// wb_[g`FbN
		for (int i = 0; i < aryHeaderData.length; i++) {
			if (vo.checkHeadData(aryHeaderData[i], aryBonusHeaderItem)) {
				aryHeaderNo[i] = vo.getHeadNo(aryHeaderData[i], aryBonusHeaderItem, i);
			} else {
				// wb_sG[
				String errMessage = MospUtility.getMessage(msg, BonusConst.MSG_INVALID_CSV_HEAD, aryHeaderData[i]);
				addErrMessage(errMessage);
				throw new MospException(MospConst.EX_PARAMS_INVALID);
			}
		}
		// wb_dmF
		chkDeplicateHeader();
		return true;
	}
	
	/**
	 * wb_[dmF
	 * @throws MospException
	 */
	protected void chkDeplicateHeader() throws MospException {
		for (int i = 0; i < aryHeaderNo.length; i++) {
			for (int j = i + 1; j < aryHeaderNo.length; j++) {
				if (aryHeaderNo[i].equals(aryHeaderNo[j])) {
					// wb_dG[
					String errMessage = MospUtility.getMessage(msg, BonusConst.MSG_INVALID_HEAD, aryHeaderData[i]);
					addErrMessage(errMessage);
					throw new MospException(MospConst.EX_PARAMS_INVALID);
				}
			}
		}
	}
	
	/**
	 * Abv[hpz쐬if[^j
	 * @param vo PayCalculateVoCX^X
	 * @throws Exception
	 */
	private boolean createUploadData(BonusCalcVo vo, String[] line) throws Exception {
		// f[^s擾
		aryCsvData = new String[line.length];
		aryCsvData = line;
		for (int i = 0; i < aryCsvData.length; i++) {
			// L[f[^擾
			vo.setKeyData(aryCsvData[i], i);
		}
		return true;
	}
	
	/**
	 * Ј݊mF
	 * @param vo
	 * @throws Exception
	 */
	public boolean chkEmploymentData(BonusCalcVo vo) throws Exception {
		boolean isRegist = true;
		// ЈR[hݒ
		if (vo.getKCode() == null) {
			// L[̎擾G[
			String errMessage = MospUtility.getMessage(msg, BonusConst.MSG_NO_UPLOAD_KEY, "ЈR[h" + "("
					+ BonusConst.UP_K_CODE + ")");
			addErrMessage(errMessage);
			isRegist = false;
		}
		// ЈR[h݃`FbN(l)
		Employee employee = getUpdateBasisHistory(vo.getKCode(), getEndDate(vo.getCalcDate()));
		if (employee == null) {
			// o^ЈR[hG[
			String errMessage = MospUtility.getMessage(msg, BonusConst.MSG_NO_UPLOAD_HUMAN, String
				.valueOf(csvDataCount + 1));
			addErrMessage(errMessage);
			isRegist = false;
			return isRegist;
		}
		// ސEĂЈ̏ꍇG[
//		if (phBasisDto.getRetirementDate() != null && getTimeRemainder(
//				phBasisDto.getRetirementDate(), getStartDate(vo.getCalcDate())) < 0) {
//			String errMessage = MospUtility.getMessage(msg, BonusConst.MSG_UP_RETIRED, String.valueOf(csvDataCount + 1));
//			addErrMessage(errMessage);
//			isRegist = false;
//		}
		return isRegist;
	}
	
	/**
	 * csvf[^̑ÓmF
	 * @throws MospException
	 */
	public boolean validate(String value, String aryHeaderName, int idx, int csvRowCount, BonusCalcVo vo)
			throws MospException {
		// ݒ
		int rowCount = csvRowCount;
		rowCount += 1;
		// G[̐ݒ
		String errReplace = aryHeaderName + "," + String.valueOf(rowCount);
		if (idx != vo.getIdxKCode()) {
			// l̑Ó`FbN
			checkCsvNumeric(value, errReplace);
			checkCsvLength(value, BonusCalcVo.LEN_AMOUNT, aryHeaderName, rowCount);
		}
		return isAddRegistData;
	}
	
	/**
	 * ^CvmF(lFdouble)
	 * @param value mFΏە
	 * @param name  mFΏۖ
	 * @param id    mFΏۃtB[hID
	 * @throws MospException
	 */
	protected void checkCsvNumeric(String value, String name) throws MospException {
		if (!ValidateUtility.chkNumeric(value)) {
			String errMsg = MospUtility.getMessage(msg, "WC0022", name);
			addErrMessage(errMsg);
			isAddRegistData = false;
		}
	}
	
	/**
	 * 񒷊mF(ő啶)
	 * @param value     mFΏە
	 * @param maxLength ő啶
	 * @param name      mFΏۖ
	 * @param id        mFΏۃtB[hID
	 * @throws MospException
	 */
	protected void checkCsvLength(String value, int maxLength, String name, int idx) throws MospException {
		String regex = ".{0," + String.valueOf(maxLength) + "}";
		if (!ValidateUtility.chkRegex(regex, value)) {
			String errMsg = MospUtility.getMessage(msg, "WC0021", name + MospConst.DATA_SEPARATOR
					+ String.valueOf(maxLength) + MospConst.DATA_SEPARATOR + idx);
			addErrMessage(errMsg);
			isAddRegistData = false;
		}
	}
	
	/**
	 * wb_ڐݒ
	 */
	protected String[][] getBonusUploadHeadItem() {
		ArrayList<String> listItem = new ArrayList<String>();
		listItem.add(BonusConst.UP_K_CODE);
		listItem.add(BonusConst.UP_BONUS_ALLOWANCE_01);
		listItem.add(BonusConst.UP_BONUS_ALLOWANCE_02);
		listItem.add(BonusConst.UP_BONUS_ALLOWANCE_03);
		listItem.add(BonusConst.UP_BONUS_ALLOWANCE_04);
		listItem.add(BonusConst.UP_BONUS_ALLOWANCE_05);
		listItem.add(BonusConst.UP_BONUS_ALLOWANCE_06);
		listItem.add(BonusConst.UP_BONUS_ALLOWANCE_07);
		listItem.add(BonusConst.UP_BONUS_ALLOWANCE_08);
		listItem.add(BonusConst.UP_BONUS_ALLOWANCE_09);
		listItem.add(BonusConst.UP_BONUS_ALLOWANCE_10);
		listItem.add(BonusConst.UP_BONUS_ALLOWANCE_11);
		listItem.add(BonusConst.UP_BONUS_ALLOWANCE_12);
		listItem.add(BonusConst.UP_BONUS_ALLOWANCE_13);
		listItem.add(BonusConst.UP_BONUS_ALLOWANCE_14);
		listItem.add(BonusConst.UP_BONUS_ALLOWANCE_15);
		listItem.add(BonusConst.UP_BONUS_ALLOWANCE_16);
		listItem.add(BonusConst.UP_BONUS_ALLOWANCE_17);
		listItem.add(BonusConst.UP_BONUS_ALLOWANCE_18);
		listItem.add(BonusConst.UP_BONUS_ALLOWANCE_19);
		listItem.add(BonusConst.UP_BONUS_ALLOWANCE_20);
		listItem.add(BonusConst.UP_BONUS_DEDUCTION_01);
		listItem.add(BonusConst.UP_BONUS_DEDUCTION_02);
		listItem.add(BonusConst.UP_BONUS_DEDUCTION_03);
		listItem.add(BonusConst.UP_BONUS_DEDUCTION_04);
		listItem.add(BonusConst.UP_BONUS_DEDUCTION_05);
		listItem.add(BonusConst.UP_BONUS_DEDUCTION_06);
		listItem.add(BonusConst.UP_BONUS_DEDUCTION_07);
		listItem.add(BonusConst.UP_BONUS_DEDUCTION_08);
		listItem.add(BonusConst.UP_BONUS_DEDUCTION_09);
		listItem.add(BonusConst.UP_BONUS_DEDUCTION_10);
		listItem.add(BonusConst.UP_BONUS_DEDUCTION_11);
		listItem.add(BonusConst.UP_BONUS_DEDUCTION_12);
		listItem.add(BonusConst.UP_BONUS_DEDUCTION_13);
		listItem.add(BonusConst.UP_BONUS_DEDUCTION_14);
		listItem.add(BonusConst.UP_BONUS_DEDUCTION_15);
		listItem.add(BonusConst.UP_BONUS_DEDUCTION_16);
		listItem.add(BonusConst.UP_BONUS_DEDUCTION_17);
		listItem.add(BonusConst.UP_BONUS_DEDUCTION_18);
		listItem.add(BonusConst.UP_BONUS_DEDUCTION_19);
		listItem.add(BonusConst.UP_BONUS_DEDUCTION_20);
		String[][] aryItem = new String[listItem.size()][2];
		for (int i = 0; i < listItem.size(); i++) {
			aryItem[i][0] = String.valueOf(i);
			aryItem[i][1] = listItem.get(i);
		}
		return aryItem;
	}
	
	/**
	 * @TvZ(ܗ^f[^XV)
	 * @param vo ΏVO
	 * @throws Exception
	 */
	private void calcLegalDeduction(BonusCalcVo vo) throws Exception {
		// DAO
		PhBounsDao phBounsDao = new PhBounsDao(cfg, cmd, aspUser, user, conn);
		phBounsDao.initDao(cfg, cmd, aspUser, user, conn);
		// vZΏۏܗ^f[^擾(xŌ)
		List<PhBounsDto> listBonus = phBounsDao.findForCalcday(vo.getPayday());
		// @TvZ(ܗ^f[^)
		for (int i = 0; i < listBonus.size(); i++) {
			// vZΏېݒ
			phBounsDto = listBonus.get(i);
			// ЈR[hݒ
			kCode = phBounsDto.getKCode();
			// xݒ
			targetMonth = vo.getPayday();
			// Ј擾
			Employee employee = getEmployee(kCode);
			// ܗ^`[擾
			Bonus bonus = getBonus(kCode, targetMonth);
			// ߂̋^`[擾(ŌvZŗp)
			Payment payment = getLastPayment(kCode, targetMonth);
			// ЉیvZ
			calcSocialInsurance(employee, bonus);
			// ŌvZ
			calcIncomeTax(employee, payment, bonus);
			// Wv
			bonus.calcAllowance();
			bonus.calcDeduction();
			bonus.calcPaymentTotal();
			// sU
			calcDivideAccounts(employee, bonus);
			// XV
			registBonus(bonus);
			// R~bg
			commit();
		}
	}
	
	/**
	 * Ő^`[擾B<br>
	 * @param kCode     ЈR[h
	 * @param datumDate 
	 * @return Ő^`[
	 * @throws NoSuchFieldException tB[hȂꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws SQLException SQLOꍇ
	 */
	private Payment getLastPayment(String kCode, Date datumDate) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		// O擾
		Date lastMonth = addMonth(datumDate, -1);
		// O^擾
		List<PhPaymentDto> list = new PhPaymentDao(cfg, cmd, aspUser, user, conn).find(kCode, DateUtil
			.getFirstDateOfMonth(lastMonth), DateUtil.getLastDateOfMonth(lastMonth));
		if (list.size() == 0) {
			return null;
		}
		PhPaymentDto header = list.get(0);
		return new Payment(header, new PmDetailPtDao(cfg, cmd, aspUser, user, conn).findForSlip(header.getSlipCode()),
				new PmDetailPaDao(cfg, cmd, aspUser, user, conn).findForSlip(header.getSlipCode()), new PmDetailPdDao(
						cfg, cmd, aspUser, user, conn).findForSlip(header.getSlipCode()), new PmDetailPbDao(cfg, cmd,
						aspUser, user, conn).findForSlip(header.getSlipCode()), new PmDetailPsDao(cfg, cmd, aspUser,
						user, conn).findForSlip(header.getSlipCode()), new PdPayTimeDao(cfg, cmd, aspUser, user, conn)
					.find(kCode, header.getCalcMonth()), new PdPayAllowanceDao(cfg, cmd, aspUser, user, conn).find(
						kCode, header.getCalcMonth()), new PdPayDeductionDao(cfg, cmd, aspUser, user, conn).find(kCode,
						header.getCalcMonth()), new PdPayBreakdownDao(cfg, cmd, aspUser, user, conn).find(kCode, header
					.getCalcMonth()), new PdPaySumDao(cfg, cmd, aspUser, user, conn).find(kCode, header.getCalcMonth()));
	}
	
	/**
	 * ܗ^`[̓o^sB
	 * @param bonus o^Ώۏܗ^`[
	 * @throws NoSuchFieldException tB[hȂꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws SQLException SQLOꍇ
	 * @throws MospException ܗ^wb_[o^O
	 */
	private void registBonus(Bonus bonus) throws SQLException, NoSuchFieldException, IllegalAccessException,
			MospException {
		// DAO
		PhBounsDao phBonusDao = new PhBounsDao(cfg, cmd, aspUser, user, conn);
		PdBonAllowanceDao pdBonAllowanceDao = new PdBonAllowanceDao(cfg, cmd, aspUser, user, conn);
		PdBonDeductionDao pdBonDeductionDao = new PdBonDeductionDao(cfg, cmd, aspUser, user, conn);
		PdBonSumDao pdBonSumDao = new PdBonSumDao(cfg, cmd, aspUser, user, conn);
		// ܗ^׍폜
		pdBonAllowanceDao.delete(bonus.getKCode(), bonus.getCalcMonth());
		pdBonDeductionDao.delete(bonus.getKCode(), bonus.getCalcMonth());
		pdBonSumDao.delete(bonus.getKCode(), bonus.getCalcMonth());
		// ܗ^דo^
		pdBonAllowanceDao.insert(bonus.getAllowanceList());
		pdBonDeductionDao.insert(bonus.getDeductionList());
		pdBonSumDao.insert(bonus.getSumList());
		// ܗ^wb_[o^
		if (phBonusDao.findForKey(bonus.getKCode(), bonus.getCalcMonth()) == null) {
			phBonusDao.insert(bonus.getHeader(), true);
		} else {
			phBonusDao.update(bonus.getHeader(), true);
		}
	}
	
	/**
	 * mvZ(ܗ^f[^XV)
	 * @param vo ΏVO
	 * @throws Exception 
	 */
	public void calcTotal(BonusCalcVo vo) throws Exception {
		PhBounsDto dto;
		// t̑ÓmF
		if (vo.checkTargetDate()) {
			// DAO
			PhBounsDao phBounsDao = new PhBounsDao(cfg, cmd, aspUser, user, conn);
			phBounsDao.initDao(cfg, cmd, aspUser, user, conn);
			// xŏܗ^wb_[e[u(PH_BONUS)
			List<PhBounsDto> listPhBonus = phBounsDao.findForCalcday(vo.getPayday());
			if (listPhBonus.size() != 0) {
				// xɌvZݒ
				for (Iterator<PhBounsDto> it = listPhBonus.iterator(); it.hasNext();) {
					dto = it.next();
					dto.setCalcMonth(vo.getPayday());
					dto.setPayDate(vo.getPayday());
					phBounsDao.deleteForCalcdate(dto.getKCode(), vo.getPayday());
					phBounsDao.insert(dto, true);
					commit();
				}
				vo.setMessage(MospUtility.getMessage(msg, BonusConst.MSG_APPLY, ""));
			} else {
				// wb_dG[
				String errMessage = MospUtility.getMessage(msg, "WP2002", "");
				addErrMessage(errMessage);
				throw new MospException(MospConst.EX_PARAMS_INVALID);
				
			}
		}
	}
	
	/**
	 * x̃f[^폜
	 * @param vo ΏVO
	 * @throws Exception
	 */
	public void delete(BonusCalcVo vo) throws Exception {
		// t̑ÓmF
		if (vo.checkTargetDate()) {
			// DAO
			PhBounsDao phBounsDao = new PhBounsDao(cfg, cmd, aspUser, user, conn);
			phBounsDao.initDao(cfg, cmd, aspUser, user, conn);
			// xŏܗ^wb_[e[u(PH_BONUS)
			List<PhBounsDto> listPhBonus = phBounsDao.findForCalcday(vo.getPayday());
			if (listPhBonus.size() != 0) {
				// vZŃf[^폜
				phBounsDao.deleteForCalcdateAll(vo.getPayday());
				// R~bg
				commit();
				// bZ[Wݒ
				vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_DELETE, ""));
				// xivZNjŏܗ^׎xe[u(PD_BON_ALLOWANCE)폜
				deleteAllowamce(vo.getPayday());
				// xivZNjŏܗ^׍Te[u(PD_BON_DEDUCTION)폜
				deleteDeduction(vo.getPayday());
				// xivZNjŏܗ^׍ve[u(PD_BON_SUM)폜
				deleteSum(vo.getPayday());
				// xivZNjŒԃe[u(PI_BONUS)폜
				deletePiBonus(vo.getPayday());
			} else {
				PiBonusDao piBonusDao = new PiBonusDao(cfg, cmd, aspUser, user, conn);
				piBonusDao.initDao(cfg, cmd, aspUser, user, conn);
				// xŏܗ^wb_[e[u(PH_BONUS)
				List<DetailTimeDto> listPiBonus = piBonusDao.find(vo.getPayday());
				if (listPiBonus.size() != 0) {
					vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_DELETE, ""));
					piBonusDao.delete(vo.getPayday());
					// R~bg
					commit();
				} else {
					// Ώۃf[^݂Ȃ
					String errMessage = MospUtility.getMessage(msg, "IC0011", "");
					addErrMessage(errMessage);
					throw new MospException(MospConst.EX_PARAMS_INVALID);
				}
				
			}
		}
	}
	
	/**
	 * l{擾(G[Ȃ)
	 * @param kCode 擾ΏێЈR[h
	 * @param date  Ώ۔N
	 * @return l{(Employee)
	 * @throws Exception 
	 * @throws MospException
	 */
	protected Employee getUpdateBasisHistory(String kCode, Date date) throws Exception {
		Employee employee = getEmployee(kCode);
		return employee;
	}
	
	/**---- eBonusActionŎiʉj :: Base ----**/
	
	/**
	 * ƏR[h擾(M_KAISYA)
	 * @return ƏR[h
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	protected String[][] getStationArrayAll() throws SQLException, NoSuchFieldException, IllegalAccessException {
		// DAȌ
		MKaisyaDao dao = new MKaisyaDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ̎擾
		List<MKaisyaDto> listStation = dao.findAll();
		// z̍쐬
		String[][] aryStation = new String[listStation.size()][2];
		for (int i = 0; i < listStation.size(); i++) {
			aryStation[i][0] = listStation.get(i).getId();
			aryStation[i][1] = listStation.get(i).getKaiMei();
		}
		return aryStation;
	}
	
	/**
	 * vZ擾
	 * @return vZ
	 * @throws Exception
	 */
	@Override
	protected Date getCalcCurrent() throws Exception {
		// DAO
		PtCurrentDao dao = new PtCurrentDao(cfg, cmd, aspUser, user, conn);
		dao.initDao(cfg, cmd, aspUser, user, conn);
		PtCurrentDto dto = dao.findForKey(PayrollConst.OFFICE_ALL, PayrollConst.CALC_BONUS, getCurrent(
				PayrollConst.OFFICE_ALL, PayrollConst.CALC_PAYMENT));
		if (dto != null) {
			return dto.getCalcDate();
		}
		return new Date();
	}
	
	/**
	 * Nv_E擾(OBonusConstŎw)
	 * @param year N
	 * @return Nv_Epz
	 */
	protected String[][] getYearArrayLong(int year) {
		return getYearArray(year, BonusConst.TIME_YEAR_FORMER, BonusConst.TIME_YEAR_FURTHER);
	}
	
	/**
	 * Nv_E擾
	 * @param year N
	 * @return Nv_Epz
	 */
	protected String[][] getYearArray(int year, int former, int further) {
		String[][] aryYear = new String[former + further + 1][2];
		int i = 0;
		int index = 0;
		for (i = year - former; i < year; i++) {
			aryYear[index][0] = String.valueOf(i);
			aryYear[index][1] = String.valueOf(i);
			index++;
		}
		aryYear[index][0] = String.valueOf(year);
		aryYear[index][1] = String.valueOf(year);
		index++;
		for (i = year + 1; i <= year + further; i++) {
			aryYear[index][0] = String.valueOf(i);
			aryYear[index][1] = String.valueOf(i);
			index++;
		}
		return aryYear;
	}
	
	/**
	 * vZmF(vZNȍ~)
	 * @param date Ώ۔N
	 * @throws Exception 
	 */
	protected void checkCalcCurrentAfter(Date date) throws Exception {
		if (getCalcCurrent().compareTo(date) > 0) {
			String errMessage = MospUtility.getMessage(msg, BonusConst.MSG_NOT_CURRENT, "");
			addErrMessage(errMessage);
			throw new MospException(BonusConst.EX_NOT_CURRENT, errMessage);
		}

		/*** bi ***/
		else {
			String errMessage = MospUtility.getMessage(msg, "WU1120", "");
			addErrMessage(errMessage);
			throw new MospException(BonusConst.EX_NOT_CURRENT, errMessage);
		}
	}
	
	/**
	 * NJn擾
	 * @param year N
	 * @return NŏI
	 */
	protected Date getStartDateOfYear(int year) {
		Calendar cal = Calendar.getInstance();
		cal.set(Calendar.YEAR, year);
		cal.set(Calendar.MONTH, 0);
		cal.set(Calendar.DAY_OF_MONTH, 1);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		return cal.getTime();
	}
	
	/**
	 * NŏI擾
	 * @param year N
	 * @return NŏI
	 */
	protected Date getLastDateOfYear(int year) {
		Calendar cal = Calendar.getInstance();
		cal.set(Calendar.YEAR, year + 1);
		cal.set(Calendar.MONTH, 0);
		cal.set(Calendar.DAY_OF_MONTH, 1);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		cal.add(Calendar.DAY_OF_MONTH, -1);
		return cal.getTime();
	}
	
	/**
	 * 
	 * @param date   t
	 * @param amount 
	 * @return t
	 */
	protected Date addMonth(Date date, int amount) {
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		cal.add(Calendar.MONTH, amount);
		return cal.getTime();
	}
	
	/**
	 * یvZΏۊmF
	 * @param nursingInsType@ی敪
	 * @return@vZΏۊmFtO
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public boolean chkCalcNursingInsType(String nursingInsType) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		boolean isCalc = false;
		// یvZ(ی敪uΏ()v̏ꍇ)
		if (nursingInsType.equals(LegalConst.NURSING_INS_AUTO)) {
			// NŌvZΏۂf
			isCalc = chkCalcNusingInsAuto();
		}
		// یvZ(ی敪uΏہv̏ꍇ)
		if (nursingInsType.equals(LegalConst.NURSING_INS_MANUAL)) {
			isCalc = true;
		}
		return isCalc;
	}
	
	/**
	 * یvZΏۊmF(敪FvZΏ())
	 * @return vZΏۊmFtO
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public boolean chkCalcNusingInsAuto() throws SQLException, IllegalAccessException, NoSuchFieldException {
		// vZΏۊmFtO
		boolean isCalc = false;
		// DAO
		PmExtraDao pmExtraDao = new PmExtraDao();
		pmExtraDao.initDao(cfg, cmd, aspUser, user, conn);
		// N擾
		int age = 0;
		// Ώ۔NŏI+1擾
		Date targetDate = addDay(getEndDate(targetMonth), 1);
		// Ǘ擾
		PmExtraDto pmExtraDto = pmExtraDao.findForKey(kCode);
		// Ǘf[^݂ȂЈ͑ΏۊO
		if (pmExtraDto == null) {
			isCalc = false;
			return isCalc;
		}
		// aݒ肳ĂȂЈ͑ΏۊO
		if (pmExtraDto.getBirthDate() == null) {
			isCalc = false;
			return isCalc;
		}
		// N擾(Ώ۔NŏI+1Ŕf)
		age = getAge(pmExtraDto.getBirthDate(), targetDate);
		// 40Έȏ65Ζ͌vZΏ
		if (age >= 40) {
			isCalc = true;
		}
		if (age >= 65) {
			isCalc = false;
		}
		return isCalc;
		
	}
	
	/**
	 * 
	 * @param date   t
	 * @param amount 
	 * @return t
	 */
	protected Date addDay(Date date, int amount) {
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		cal.add(Calendar.DAY_OF_MONTH, amount);
		return cal.getTime();
	}
	
	/**
	 * N擾
	 * @param birthDay
	 * @param targetDay
	 * @return N
	 */
	protected int getAge(Date birthDay, Date targetDay) {
		// 擾
		int age = 0;
		// N擾
		age = MospUtility.getYear(targetDay) - MospUtility.getYear(birthDay);
		// Ώ۔NaNȂ0
		if (age < 0) {
			age = 0;
			return age;
		}
		// Ώیaȍ~
		if (MospUtility.getMonth(targetDay) - MospUtility.getMonth(birthDay) > 0) {
			return age;
		} else if (MospUtility.getMonth(targetDay) - MospUtility.getMonth(birthDay) == 0) {
			
			// Ώۓaȍ~
			if (MospUtility.getDay(targetDay) - MospUtility.getDay(birthDay) > 0) {
				return age;
			} else if (MospUtility.getDay(targetDay) - MospUtility.getDay(birthDay) == 0) {
				// Ώۓa
				return age;
			} else {
				// ΏۓaȑO
				return age - 1;
			}
		} else {
			// ΏیaȑO
			return age - 1;
		}
	}
	
	/**
	 * WvI擾
	 * @param targetMonth Ώی
	 * @return WvI
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 */
	@Override
	protected Date getEndDate(Date targetMonth) throws SQLException, IllegalAccessException, NoSuchFieldException {
		// J_[擾
		Calendar cal = Calendar.getInstance();
		cal.setTime(targetMonth);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		// ߓ擾
		String[][] close = getConfArray(BonusConst.CONF_ID_CLOSE);
		int minusMonth = Integer.parseInt(close[0][0]);
		int closeDay = Integer.parseInt(close[0][1]);
		// WvIvZ
		cal.roll(Calendar.MONTH, minusMonth * -1);
		if (closeDay != 0) {
			cal.roll(Calendar.MONTH, 1);
			cal.set(Calendar.DAY_OF_MONTH, closeDay);
		} else {
			cal.roll(Calendar.DAY_OF_MONTH, -1);
		}
		return cal.getTime();
	}
	
	/**
	 * ݒ胊Xg擾(UM_CONF)
	 * @param confId ݒ敪
	 * @return ݒ胊Xg
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 */
	@Override
	protected String[][] getConfArray(String confId) throws SQLException, IllegalAccessException, NoSuchFieldException {
		// DAO̐錾
		MosPConfDao dao = new MosPConfDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// f[^̎擾
		List<MosPConfDto> list = dao.findForCondition(confId);
		// f[^̐`
		String[][] array = new String[list.size()][2];
		for (int i = 0; i < list.size(); i++) {
			MosPConfDto dto = list.get(i);
			array[i][0] = dto.getConfCode();
			array[i][1] = dto.getConfValue();
		}
		return array;
	}
	
	/**
	 * אݒ擾B(ܗ^)<br>
	 * @return אݒ
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	protected Map<String, PsDetailDto> getMapBonusDetail() throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		// אݒ擾
//		if (mapBonusDetailAll == null) {
//			PsDetailDao PsDetailDao = new PsDetailDao();
//			PsDetailDao.initDao(cfg, cmd, aspUser, user, conn);
//			mapBonusDetailAll = PsDetailDao.findBonusAsMap();
//		}
		// אݒL[
//		String key = phBounsDto.getEmploymentType() + BonusConst.KEY_SEPARATOR;
//		// L[+EʃR[hŖאݒ擾
//		Map<String, PsDetailDto> mapDetail =
//			mapBonusDetailAll.get(key + phBounsDto.getPositionCode());
//		// L[+EʃR[hŖאݒ肪Ȃꍇ
//		if (mapDetail == null) {
//			// L[+ݒȂŖאݒ擾
//			mapDetail = mapBonusDetailAll.get(key + BonusConst.SETTING_NONE);
//		}
//	return mapDetail;
		return null;
	}
	
	/**
	 * sU
	 * @param total         xz
	 * @param allowanceType x敪(1F^A2Fܗ^)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	protected void divideAmongAccounts(int total, String allowanceType) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		// 
		bank1Amount = 0;
		bank2Amount = 0;
		cashAmount = 0;
		// DAO
		CmPaymentMeansDao dao = new CmPaymentMeansDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// x@擾(x@Aԏ)
		List<CmPaymentMeansDto> list;
		list = dao.findForEmployeeAllowance(kCode, allowanceType);
		// x񖈂̏
		int currentAmount = total;
		for (CmPaymentMeansDto dto : list) {
			// Uz擾
			int amount = getdividedAmount(dto, total, currentAmount);
			// Uzݒ
			if (dto.getPaymentMeans().equals(BonusConst.PAYMENT_MEANS_ACCOUNT)) {
				// Ȕꍇ
				if (dto.getMeansSequence() == BonusConst.PAYMENT_MEANS_SEQ_1
						|| dto.getMeansSequence() == BonusConst.PAYMENT_MEANS_SEQ_3) {
					bank1Amount += amount;
				} else {
					bank2Amount += amount;
				}
			} else {
				// UȊO()̏ꍇ
				cashAmount += amount;
			}
			// czvZ
			currentAmount -= amount;
		}
		// czɐݒ
		cashAmount += currentAmount;
	}
	
	/**
	 * Uxz擾
	 * @param dto           x@DTO
	 * @param totalAmount   Uz
	 * @param currentAmount Uz(cz)
	 */
	private int getdividedAmount(CmPaymentMeansDto dto, int totalAmount, int currentAmount) {
		// x񂪐ݒ肳ĂȂꍇ
		if (dto == null) {
			return 0;
		}
		// Sz̏ꍇ
		if (dto.getAmountType().equals(BonusConst.AMOUNT_TYPE_ALL)) {
			return currentAmount;
		}
		// cz̏ꍇ
		if (dto.getAmountType().equals(BonusConst.AMOUNT_TYPE_REST)) {
			return currentAmount;
		}
		// Uxz
		int dividingAmount = 0;
		// z敪̏
		if (dto.getAmountType().equals(BonusConst.AMOUNT_TYPE_AMOUNT)) {
			// z̏ꍇ
			dividingAmount = dto.getFixedAmount();
		} else if (dto.getAmountType().equals(BonusConst.AMOUNT_TYPE_RATIO)) {
			// 藦̏ꍇ
			// Uz * U / 100
			dividingAmount = (int)round(dto.getFixedAmount() / 100 * totalAmount, 0, BigDecimal.ROUND_HALF_UP);
		}
		// Uzȏ̏ꍇ
		if (dividingAmount > currentAmount) {
			dividingAmount = currentAmount;
		}
		return dividingAmount;
	}
	
	/**
	 * xivZNjŏܗ^׎xe[u(PD_BON_ALLOWANCE)폜
	 * @param getPayday     xt
	 */
	private void deleteAllowamce(Date getPayday) throws Exception {
		// DAO
		PdBonAllowanceDao pdBonAllowanceDao = new PdBonAllowanceDao(cfg, cmd, aspUser, user, conn);
		pdBonAllowanceDao.initDao(cfg, cmd, aspUser, user, conn);
		pdBonAllowanceDao.delete(getPayday);
		// R~bg
		commit();
	}
	
	/**
	* xivZNjŏܗ^׍Te[u(PD_BON_DEDUCTION)폜
	 * @param getPayday     xt
	 */
	private void deleteDeduction(Date getPayday) throws Exception {
		PdBonSumDao pdBonSumDao = new PdBonSumDao(cfg, cmd, aspUser, user, conn);
		pdBonSumDao.initDao(cfg, cmd, aspUser, user, conn);
		pdBonSumDao.delete(getPayday);
		// R~bg
		commit();
	}
	
	/**
	* xivZNjŏܗ^׍ve[u(PD_BON_SUM)폜
	 * @param getPayday     xt
	 */
	private void deleteSum(Date getPayday) throws Exception {
		PdBonDeductionDao pdBonDeductionDao = new PdBonDeductionDao(cfg, cmd, aspUser, user, conn);
		pdBonDeductionDao.initDao(cfg, cmd, aspUser, user, conn);
		pdBonDeductionDao.delete(getPayday);
		// R~bg
		commit();
	}
	
	/**
	* xivZNjŏܗ^ԃe[u(PID_BONUS)폜
	 * @param getPayday     xt
	 */
	private void deletePiBonus(Date getPayday) throws Exception {
		PiBonusDao piBonusDao = new PiBonusDao(cfg, cmd, aspUser, user, conn);
		piBonusDao.initDao(cfg, cmd, aspUser, user, conn);
		piBonusDao.delete(getPayday);
		// R~bg
		commit();
	}
	
	/**
	 * esւ̐UzyьxzvZB
	 * @param employee Ј
	 */
	private void calcDivideAccounts(Employee employee) {
		// x@擾(x@Aԏ)
		List<CmPaymentMeansDto> list = employee.getPaymentMeans();
		if (sumDatail < 0) {
			cashAmount = sumDatail;
			return;
		}
		// xz擾
		int total = sumDatail;
		// x񖈂̏
		int currentAmount = total;
		for (CmPaymentMeansDto dto : list) {
			if (dto.getAllowanceType().equals(PayrollConst.ALLOWANCE_TYPE_BONUS)) {
				// Uz擾
				int amount = getdividedAmount(dto, total, currentAmount);
				// Uzݒ
				if (dto.getPaymentMeans().equals(PayrollConst.PAYMENT_MEANS_ACCOUNT)) {
					// Ȕꍇ
					if (dto.getMeansSequence() == PayrollConst.PAYMENT_MEANS_SEQ_3) {
						bank1Amount += amount;
					} else {
						bank2Amount += amount;
					}
				} else {
					// UȊO()̏ꍇ
					cashAmount += amount;
				}
				// czvZ
				currentAmount -= amount;
			}
		}
		// czɐݒ
		cashAmount += currentAmount;
	}
	
	/**
	 * ܗ^_E[hpev[gt@Co͂B
	 * @throws Exception 
	 */
	private void bonusTemplateOut() throws Exception {
		//t@C̐ݒ
		Date sysDate = getSystemDate();
		SimpleDateFormat sdf1 = new SimpleDateFormat("yyyyMMdd");
		StringBuffer fileName = new StringBuffer();
		fileName.append(PayrollConst.NAM_FILE_BONUS);
		fileName.append(CommonConst.FILE_NAME_SEPARATOR);
		fileName.append(sdf1.format(sysDate));
		fileName.append(CommonConst.FILE_NAME_SEPARATOR);
		fileName.append("template");
		fileName.append(CommonConst.FILE_COMMON_CSV);
		
		request.setAttribute(MospConst.ATT_FILE_NAME, fileName.toString());
		request.setAttribute(MospConst.ATT_FILE_OBJECT, makeHumanData());
		// V[PX𔭍sȂB
		setNeedProcSeq(false);
		
	}
	
	/**
	 * ܗ^ev[g쐬
	 * @return ܗ^ev[g񕶎
	 * @throws Exception 
	 */
	protected StringBuffer makeHumanData() throws Exception {
		String[][] listKcodeName;
		// [쐬
		StringBuffer sb = new StringBuffer();
		// wb_[ݒ
		sb.append(appendHeader());
		// f[^ǋL
		
		listKcodeName = getBasisArrayForApproval();
		for (String[] element : listKcodeName) {
			//ސE҂͏O
			if (false == part().human().isRetiredEmployee(element[0])) {
				sb.append(element[0]);
				//x
				for (int j = 0; j < 20; j++) {
					sb.append(CommonConst.STR_CSV_SEPARATOR);
					sb.append("0");
				}
				
				//T
				for (int k = 0; k < 20; k++) {
					sb.append(CommonConst.STR_CSV_SEPARATOR);
					sb.append("0");
				}
				sb.append(CommonConst.STR_CSV_NEW_LINE);
			}
		}
		return sb;
	}
	
	/**
	 * wb_[ݒ
	 * @param listSelected		ΏۑI}X^
	 * @param sb				Ώۃf[^
	 * @return
	 * <p>
	 * ev[g̃wb_[
	 * <p>
	 */
	private StringBuffer appendHeader() {
		StringBuffer sbH = new StringBuffer();
		// wb_[ݒ
		sbH.append(BonusConst.UP_K_CODE);
		sbH.append(CommonConst.STR_CSV_SEPARATOR);
		sbH.append(BonusConst.UP_BONUS_ALLOWANCE_01);
		sbH.append(CommonConst.STR_CSV_SEPARATOR);
		sbH.append(BonusConst.UP_BONUS_ALLOWANCE_02);
		sbH.append(CommonConst.STR_CSV_SEPARATOR);
		sbH.append(BonusConst.UP_BONUS_ALLOWANCE_03);
		sbH.append(CommonConst.STR_CSV_SEPARATOR);
		sbH.append(BonusConst.UP_BONUS_ALLOWANCE_04);
		sbH.append(CommonConst.STR_CSV_SEPARATOR);
		sbH.append(BonusConst.UP_BONUS_ALLOWANCE_05);
		sbH.append(CommonConst.STR_CSV_SEPARATOR);
		sbH.append(BonusConst.UP_BONUS_ALLOWANCE_06);
		sbH.append(CommonConst.STR_CSV_SEPARATOR);
		sbH.append(BonusConst.UP_BONUS_ALLOWANCE_07);
		sbH.append(CommonConst.STR_CSV_SEPARATOR);
		sbH.append(BonusConst.UP_BONUS_ALLOWANCE_08);
		sbH.append(CommonConst.STR_CSV_SEPARATOR);
		sbH.append(BonusConst.UP_BONUS_ALLOWANCE_09);
		sbH.append(CommonConst.STR_CSV_SEPARATOR);
		sbH.append(BonusConst.UP_BONUS_ALLOWANCE_10);
		sbH.append(CommonConst.STR_CSV_SEPARATOR);
		sbH.append(BonusConst.UP_BONUS_ALLOWANCE_11);
		sbH.append(CommonConst.STR_CSV_SEPARATOR);
		sbH.append(BonusConst.UP_BONUS_ALLOWANCE_12);
		sbH.append(CommonConst.STR_CSV_SEPARATOR);
		sbH.append(BonusConst.UP_BONUS_ALLOWANCE_13);
		sbH.append(CommonConst.STR_CSV_SEPARATOR);
		sbH.append(BonusConst.UP_BONUS_ALLOWANCE_14);
		sbH.append(CommonConst.STR_CSV_SEPARATOR);
		sbH.append(BonusConst.UP_BONUS_ALLOWANCE_15);
		sbH.append(CommonConst.STR_CSV_SEPARATOR);
		sbH.append(BonusConst.UP_BONUS_ALLOWANCE_16);
		sbH.append(CommonConst.STR_CSV_SEPARATOR);
		sbH.append(BonusConst.UP_BONUS_ALLOWANCE_17);
		sbH.append(CommonConst.STR_CSV_SEPARATOR);
		sbH.append(BonusConst.UP_BONUS_ALLOWANCE_18);
		sbH.append(CommonConst.STR_CSV_SEPARATOR);
		sbH.append(BonusConst.UP_BONUS_ALLOWANCE_19);
		sbH.append(CommonConst.STR_CSV_SEPARATOR);
		sbH.append(BonusConst.UP_BONUS_ALLOWANCE_20);
		sbH.append(CommonConst.STR_CSV_SEPARATOR);
		sbH.append(BonusConst.UP_BONUS_DEDUCTION_01);
		sbH.append(CommonConst.STR_CSV_SEPARATOR);
		sbH.append(BonusConst.UP_BONUS_DEDUCTION_02);
		sbH.append(CommonConst.STR_CSV_SEPARATOR);
		sbH.append(BonusConst.UP_BONUS_DEDUCTION_03);
		sbH.append(CommonConst.STR_CSV_SEPARATOR);
		sbH.append(BonusConst.UP_BONUS_DEDUCTION_04);
		sbH.append(CommonConst.STR_CSV_SEPARATOR);
		sbH.append(BonusConst.UP_BONUS_DEDUCTION_05);
		sbH.append(CommonConst.STR_CSV_SEPARATOR);
		sbH.append(BonusConst.UP_BONUS_DEDUCTION_06);
		sbH.append(CommonConst.STR_CSV_SEPARATOR);
		sbH.append(BonusConst.UP_BONUS_DEDUCTION_07);
		sbH.append(CommonConst.STR_CSV_SEPARATOR);
		sbH.append(BonusConst.UP_BONUS_DEDUCTION_08);
		sbH.append(CommonConst.STR_CSV_SEPARATOR);
		sbH.append(BonusConst.UP_BONUS_DEDUCTION_09);
		sbH.append(CommonConst.STR_CSV_SEPARATOR);
		sbH.append(BonusConst.UP_BONUS_DEDUCTION_10);
		sbH.append(CommonConst.STR_CSV_SEPARATOR);
		sbH.append(BonusConst.UP_BONUS_DEDUCTION_11);
		sbH.append(CommonConst.STR_CSV_SEPARATOR);
		sbH.append(BonusConst.UP_BONUS_DEDUCTION_12);
		sbH.append(CommonConst.STR_CSV_SEPARATOR);
		sbH.append(BonusConst.UP_BONUS_DEDUCTION_13);
		sbH.append(CommonConst.STR_CSV_SEPARATOR);
		sbH.append(BonusConst.UP_BONUS_DEDUCTION_14);
		sbH.append(CommonConst.STR_CSV_SEPARATOR);
		sbH.append(BonusConst.UP_BONUS_DEDUCTION_15);
		sbH.append(CommonConst.STR_CSV_SEPARATOR);
		sbH.append(BonusConst.UP_BONUS_DEDUCTION_16);
		sbH.append(CommonConst.STR_CSV_SEPARATOR);
		sbH.append(BonusConst.UP_BONUS_DEDUCTION_17);
		sbH.append(CommonConst.STR_CSV_SEPARATOR);
		sbH.append(BonusConst.UP_BONUS_DEDUCTION_18);
		sbH.append(CommonConst.STR_CSV_SEPARATOR);
		sbH.append(BonusConst.UP_BONUS_DEDUCTION_19);
		sbH.append(CommonConst.STR_CSV_SEPARATOR);
		sbH.append(BonusConst.UP_BONUS_DEDUCTION_20);
		sbH.append(CommonConst.STR_CSV_NEW_LINE);
		
		return sbH;
	}
	
	/**
	 * ЈR[h擾(M_KIHON)
	 * @return ЈR[hXg
	 * @throws Exception 
	 */
	protected String[][] getBasisArrayForApproval() throws Exception {
		return part().human().getBasisArrayAll();
	}
	
}
