/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.base;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.mosp.common.bean.OdsBean;
import jp.mosp.common.common.BaseAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.common.ValidateUtility;
import jp.mosp.common.dto.MosPConfDto;
import jp.mosp.kintai.common.action.KintaiCommonAction;
import jp.mosp.kintai.common.dao.MKihonDao;
import jp.mosp.kintai.common.dto.MKihonDto;
import jp.mosp.kintai.human.dao.MKojinDao;
import jp.mosp.kintai.human.dto.MKojinDto;
import jp.mosp.legal.LegalConst;
import jp.mosp.legal.LegalUtility;
import jp.mosp.payroll.bonus.dao.PdBonAllowanceDao;
import jp.mosp.payroll.bonus.dao.PdBonDeductionDao;
import jp.mosp.payroll.bonus.dao.PdBonSumDao;
import jp.mosp.payroll.bonus.dao.PhBounsDao;
import jp.mosp.payroll.bonus.dao.PmDetailBaDao;
import jp.mosp.payroll.bonus.dao.PmDetailBdDao;
import jp.mosp.payroll.bonus.dao.PmDetailBsDao;
import jp.mosp.payroll.bonus.dto.PhBounsDto;
import jp.mosp.payroll.common.part.PayrollPartStore;
import jp.mosp.payroll.dao.CdSocInsuranceDao;
import jp.mosp.payroll.dao.CmBankDao;
import jp.mosp.payroll.dao.CmBranchDao;
import jp.mosp.payroll.dao.CmCoBankDao;
import jp.mosp.payroll.dao.CmCommutationDao;
import jp.mosp.payroll.dao.CmCompanyDao;
import jp.mosp.payroll.dao.CmIncomeTaxDao;
import jp.mosp.payroll.dao.CmPaymentMeansDao;
import jp.mosp.payroll.dao.CmResidenceTaxDao;
import jp.mosp.payroll.dao.CmSocInsuranceDao;
import jp.mosp.payroll.dao.CmUnitAmountDao;
import jp.mosp.payroll.dao.KdSubstituteHolidayDao;
import jp.mosp.payroll.dao.MKihonPayrollDao;
import jp.mosp.payroll.dao.PdPayAllowanceDao;
import jp.mosp.payroll.dao.PdPayBreakdownDao;
import jp.mosp.payroll.dao.PdPayDeductionDao;
import jp.mosp.payroll.dao.PdPaySumDao;
import jp.mosp.payroll.dao.PdPayTimeDao;
import jp.mosp.payroll.dao.PhPaymentDao;
import jp.mosp.payroll.dao.PiPaymentDao;
import jp.mosp.payroll.dao.PmDetailPaDao;
import jp.mosp.payroll.dao.PmDetailPbDao;
import jp.mosp.payroll.dao.PmDetailPdDao;
import jp.mosp.payroll.dao.PmDetailPsDao;
import jp.mosp.payroll.dao.PmDetailPtDao;
import jp.mosp.payroll.dao.PtCurrentDao;
import jp.mosp.payroll.dto.CdSocInsuranceDto;
import jp.mosp.payroll.dto.CmBankDto;
import jp.mosp.payroll.dto.CmBranchDto;
import jp.mosp.payroll.dto.CmCoBankDto;
import jp.mosp.payroll.dto.CmCommutationDto;
import jp.mosp.payroll.dto.CmCompanyDto;
import jp.mosp.payroll.dto.CmPaymentMeansDto;
import jp.mosp.payroll.dto.CmSocInsuranceDto;
import jp.mosp.payroll.dto.CmUnitAmountDto;
import jp.mosp.payroll.dto.DetailTimeDto;
import jp.mosp.payroll.dto.PhPaymentDto;
import jp.mosp.payroll.dto.PtCurrentDto;
import jp.mosp.payroll.payment.vo.EndCalcVo;

import org.jopendocument.dom.spreadsheet.Sheet;

/**
 * ^VXeActionŗp鋤ʋ@\񋟂B<br><br>
 * ^VXe̊eActiońANXgĎB
 */
public abstract class PayrollAction extends KintaiCommonAction {
	
	/**
	 * ^VXeŗpAction̋ʏsB<br><br>
	 * ȉ̏sB
	 * <ul><li>
	 * {@link BaseAction#BaseAction()}
	 * </li></ul>
	 */
	protected PayrollAction() {
		super();
		setCheckAuth(false);
	}
	
	/**
	 * PayrollPartStoreCX^X擾
	 * @return	PayrollPartStoreCX^X
	 * @throws SQLException   SQLOꍇ
	 * @throws ClassNotFoundException  NXȂꍇ
	 * @throws MospException  MosPOꍇ
	 */
	@Override
	protected PayrollPartStore part() throws MospException, ClassNotFoundException, SQLException {
		return (PayrollPartStore)getBaseStore(PayrollPartStore.class);
	}
	
	/**
	 * ЈCX^X擾B<br><br>
	 * kCodeL[ƂĐl擾A{@link Employee}Ɋi[B
	 * @param kCode ЈR[h
	 * @return Ј
	 * @throws Exception Oꍇ
	 */
	protected Employee getEmployee(String kCode) throws Exception {
		MKihonDao mKihonDao = new MKihonDao();
		mKihonDao.initDao(cfg, cmd, aspUser, user, conn);
		MKihonDto mKihonDto = mKihonDao.findForKey(kCode);
		if (mKihonDto == null) {
			return null;
		}
		CmSocInsuranceDao cmSocInsuranceDao = new CmSocInsuranceDao();
		CmIncomeTaxDao cmIncomeTaxDao = new CmIncomeTaxDao();
		CmResidenceTaxDao cmResidenceTaxDao = new CmResidenceTaxDao();
		CmCommutationDao cmCommutationDao = new CmCommutationDao();
		CmUnitAmountDao cmUnitAmountDao = new CmUnitAmountDao();
		CmPaymentMeansDao cmPaymentMeansDao = new CmPaymentMeansDao();
		MKojinDao mKojinDao = new MKojinDao();
		cmSocInsuranceDao.initDao(cfg, cmd, aspUser, user, conn);
		cmIncomeTaxDao.initDao(cfg, cmd, aspUser, user, conn);
		cmResidenceTaxDao.initDao(cfg, cmd, aspUser, user, conn);
		cmCommutationDao.initDao(cfg, cmd, aspUser, user, conn);
		cmUnitAmountDao.initDao(cfg, cmd, aspUser, user, conn);
		cmPaymentMeansDao.initDao(cfg, cmd, aspUser, user, conn);
		mKojinDao.initDao(cfg, cmd, aspUser, user, conn);
		Employee employee = new Employee(mKihonDto, cmSocInsuranceDao.findForKey(kCode, getDefaultDate()),
				cmIncomeTaxDao.findForEmployee(kCode), cmResidenceTaxDao.findForKey(kCode, getDefaultDate()),
				cmCommutationDao.findForEmployee(kCode), cmUnitAmountDao.findForEmployee(kCode), cmPaymentMeansDao
					.findForEmployee(kCode));
		MKojinDto kojinDto = mKojinDao.findForKey(kCode);
		employee.setSectionName(getCodeName(employee.getSectionCode(), getSectionArrayAll()));
		employee.setMKojinDto(kojinDto);
		
		return employee;
	}
	
	/**
	 * ^`[CX^X擾B<br><br>
	 * kCodeAcalcDateL[Ƃċ^擾A{@link Payment}Ɋi[B
	 * @param kCode     ЈR[h
	 * @param calcMonth vZN
	 * @return ^`[
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws SQLException SQLOꍇ
	 */
	protected Payment getPayment(String kCode, Date calcMonth) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		PhPaymentDto header = new PhPaymentDao(cfg, cmd, aspUser, user, conn).findForKey(kCode, calcMonth);
		if (header == null) {
			return null;
		}
		return new Payment(header, new PmDetailPtDao(cfg, cmd, aspUser, user, conn).findForSlip(header.getSlipCode()),
				new PmDetailPaDao(cfg, cmd, aspUser, user, conn).findForSlip(header.getSlipCode()), new PmDetailPdDao(
						cfg, cmd, aspUser, user, conn).findForSlip(header.getSlipCode()), new PmDetailPbDao(cfg, cmd,
						aspUser, user, conn).findForSlip(header.getSlipCode()), new PmDetailPsDao(cfg, cmd, aspUser,
						user, conn).findForSlip(header.getSlipCode()), new PdPayTimeDao(cfg, cmd, aspUser, user, conn)
					.find(kCode, calcMonth), new PdPayAllowanceDao(cfg, cmd, aspUser, user, conn)
					.find(kCode, calcMonth), new PdPayDeductionDao(cfg, cmd, aspUser, user, conn)
					.find(kCode, calcMonth), new PdPayBreakdownDao(cfg, cmd, aspUser, user, conn)
					.find(kCode, calcMonth), new PdPaySumDao(cfg, cmd, aspUser, user, conn).find(kCode, calcMonth));
	}
	
	/**
	 * VK^`[CX^X擾B
	 * @param kCode 
	 * @param slipCode 
	 * @param calcMonth `[R[h
	 * @return VK^`[
	 * @throws NoSuchFieldException tB[hȂꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws SQLException SQLOꍇ
	 */
	private Payment getPayment(String kCode, Date calcMonth, String slipCode) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		PhPaymentDto header = new PhPaymentDto();
		header.setKCode(kCode);
		header.setCalcMonth(calcMonth);
		header.setSlipCode(slipCode);
		return new Payment(header, new PmDetailPtDao(cfg, cmd, aspUser, user, conn).findForSlip(slipCode),
				new PmDetailPaDao(cfg, cmd, aspUser, user, conn).findForSlip(slipCode), new PmDetailPdDao(cfg, cmd,
						aspUser, user, conn).findForSlip(slipCode), new PmDetailPbDao(cfg, cmd, aspUser, user, conn)
					.findForSlip(header.getSlipCode()), new PmDetailPsDao(cfg, cmd, aspUser, user, conn)
					.findForSlip(slipCode));
	}
	
	/**
	 * ܗ^`[CX^X擾Aݒ肷B<br><br>
	 * kCodeAcalcDateL[Ƃċ^擾A{@link Bonus}Ɋi[B
	 * @param kCode    ЈR[h
	 * @param payDate  x
	 * @return ܗ^`[
	 * @throws NoSuchFieldException tB[hȂꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws SQLException SQLOꍇ
	 */
	protected Bonus getBonus(String kCode, Date payDate) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		PhBounsDto header = new PhBounsDao(cfg, cmd, aspUser, user, conn).findForKey(kCode, payDate);
		if (header == null) {
			return null;
		} else {
			return new Bonus(header,
					new PmDetailBaDao(cfg, cmd, aspUser, user, conn).findForSlip(header.getSlipCode()),
					new PmDetailBdDao(cfg, cmd, aspUser, user, conn).findForSlip(header.getSlipCode()),
					new PmDetailBsDao(cfg, cmd, aspUser, user, conn).findForSlip(header.getSlipCode()),
					new PdBonAllowanceDao(cfg, cmd, aspUser, user, conn).find(kCode, payDate), new PdBonDeductionDao(
							cfg, cmd, aspUser, user, conn).find(kCode, payDate), new PdBonSumDao(cfg, cmd, aspUser,
							user, conn).find(kCode, payDate));
		}
	}
	
	/**
	 * vZN擾B<br>
	 * @param officeCode ƏR[h
	 * @param calcType   vZ敪
	 * @return vZN(vZłȂnull)
	 * @throws NoSuchFieldException tB[hȂꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws SQLException SQLOꍇ
	 */
	protected Date getCurrent(String officeCode, byte calcType) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		// DAO
		PtCurrentDao dao = new PtCurrentDao(cfg, cmd, aspUser, user, conn);
		// vZ擾
		List<PtCurrentDto> list = dao.findForState(officeCode, calcType, PayrollConst.CURRENT_START);
		// vZmF
		if (list == null || list.size() == 0) {
			return null;
		}
		return list.get(0).getCalcDate();
	}
	
	/**
	 * vZNǂmFB
	 * @param date       mFΏ۔N
	 * @param officeCode ƏR[h
	 * @param calcType   vZ敪
	 * @return vZNmF(true:vZNAfalseFvZNłȂ)
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws SQLException SQLOꍇ
	 */
	protected boolean isCurrent(Date date, String officeCode, byte calcType) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		Date current = getCurrent(officeCode, calcType);
		if (current == null) {
			return false;
		}
		if (date.compareTo(current) != 0) {
			return false;
		}
		return true;
	}
	
	/**
	 * vZΏێ҂擾B
	 * @param date ΏۊOƂȂސE
	 * @return vZΏێҎЈR[h
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws SQLException SQLOꍇ
	 */
	protected String[] getTargetEmployee(Date date) throws SQLException, IllegalAccessException, NoSuchFieldException {
		// t
		int intDate = MospUtility.getYear(date) * 10000 + MospUtility.getMonth(date) * 100 + MospUtility.getDay(date);
		// DAȌ
		MKihonPayrollDao dao = new MKihonPayrollDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ̎擾
		List<MKihonDto> listKihon = dao.find(intDate);
		// z̍쐬
		String[] aryKihon = new String[listKihon.size()];
		for (int i = 0; i < listKihon.size(); i++) {
			aryKihon[i] = listKihon.get(i).getKCode();
		}
		return aryKihon;
	}
	
	/**
	 * ^̌vZsB<br>
	 * @param kCode       vZΏێЈR[h
	 * @param targetMonth vZΏ۔N
	 * @throws Exception Oꍇ
	 */
	protected void calcPayment(String kCode, Date targetMonth) throws Exception {
		// DAO
		agreement = part().laborAgreement().getUserLaborAgreement(kCode, targetMonth);
		PiPaymentDao piPaymentDao = new PiPaymentDao(cfg, cmd, aspUser, user, conn);
		PhPaymentDao phPaymentDao = new PhPaymentDao(cfg, cmd, aspUser, user, conn);
		PdPayTimeDao pdPayTimeDao = new PdPayTimeDao(cfg, cmd, aspUser, user, conn);
		PdPayAllowanceDao pdPayAllowanceDao = new PdPayAllowanceDao(cfg, cmd, aspUser, user, conn);
		PdPayDeductionDao pdPayDeductionDao = new PdPayDeductionDao(cfg, cmd, aspUser, user, conn);
		PdPayBreakdownDao pdPayBreakdownDao = new PdPayBreakdownDao(cfg, cmd, aspUser, user, conn);
		PdPaySumDao pdPaySumDao = new PdPaySumDao(cfg, cmd, aspUser, user, conn);
		CdSocInsuranceDao cdSocInsuranceDao = new CdSocInsuranceDao();
		cdSocInsuranceDao.initDao(cfg, cmd, aspUser, user, conn);
		KdSubstituteHolidayDao kdSubstituteHolidayDao = new KdSubstituteHolidayDao();
		kdSubstituteHolidayDao.initDao(cfg, cmd, aspUser, user, conn);
		// ^׍폜
		pdPayTimeDao.delete(kCode, targetMonth);
		pdPayAllowanceDao.delete(kCode, targetMonth);
		pdPayDeductionDao.delete(kCode, targetMonth);
		pdPayBreakdownDao.delete(kCode, targetMonth);
		pdPaySumDao.delete(kCode, targetMonth);
		// Љی̎ZbEς̎擾XV
		updateInsurance(cdSocInsuranceDao, kCode, targetMonth);
		// l擾
		Employee employee = getEmployee(kCode);
		// ^`[VK쐬
		Payment payment = getPayment(kCode, targetMonth, employee.getSlipCode());
		// ΑӏyуAbv[h擾
		List<DetailTimeDto> listPiPayment = piPaymentDao.find(kCode, targetMonth);
		// p[^Map쐬
		Map<String, String> mapParams = new HashMap<String, String>();
		// p[^ǉ(ΑӏyуAbv[h)
		addParams(mapParams, listPiPayment);
		// p[^ǉ(P)
		addParams(mapParams, employee.getUnitAmount());
		// גlvZ
		payment.calcDetails(mapParams, kCode, targetMonth, agreement, kdSubstituteHolidayDao);
		// ^
		adjustPayment(employee, payment, mapParams);
		// ʋΎ蓖vZ
		calcCommutation(employee, payment, mapParams);
		// @TvZ
		calcLegalDeduction(employee, payment);
		// vvZ
		calcTotal(employee, payment);
		// wb_[ݒ
		payment.setPayDate(getPayDate(listPiPayment));
		// ^דo^
		pdPayTimeDao.insert(payment.getTimeList());
		pdPayAllowanceDao.insert(payment.getAllowanceList());
		pdPayDeductionDao.insert(payment.getDeductionList());
		pdPayBreakdownDao.insert(payment.getBreakdownList());
		pdPaySumDao.insert(payment.getSumList());
		// ^wb_[o^
		if (phPaymentDao.findForKey(kCode, targetMonth) == null) {
			phPaymentDao.insert(payment.getHeader(), false);
		} else {
			phPaymentDao.update(payment.getHeader(), false);
		}
	}
	
	/**
	 * p[^ǉB
	 * @param mapParams ǉp[^Map
	 * @param listParams p[^Xg
	 */
	private void addParams(Map<String, String> mapParams, List<?> listParams) {
		for (Object obj : listParams) {
			if (obj instanceof DetailTimeDto) {
				DetailTimeDto param = (DetailTimeDto)obj;
				mapParams.put(param.getDetailCode(), String.valueOf(param.getAmount()));
				continue;
			}
			if (obj instanceof CmUnitAmountDto) {
				CmUnitAmountDto param = (CmUnitAmountDto)obj;
				mapParams.put(param.getUnitType(), String.valueOf(param.getUnitAmount()));
				continue;
			}
		}
	}
	
	/**
	 * p[^擾B
	 * @param mapParams ǉp[^Map
	 * @param detailCode
	 * @return 
	 */
	private float getParam(Map<String, String> mapParams, String detailCode) {
		String value = mapParams.get(detailCode);
		if (value == null || !ValidateUtility.chkNumeric(value)) {
			return 0F;
		}
		return Float.parseFloat(value);
	}
	
	/**
	 * ^𒲐B
	 * @param employee Ј
	 * @param payment ^`[
	 * @param mapParams p[^
	 */
	private void adjustPayment(Employee employee, Payment payment, Map<String, String> mapParams) {
		// {(^敪)
		int base = payment.getAllowanceAmount(PayrollConst.DTL_BASE);
		if (employee.getPaymentType() == PayrollConst.PAYMENT_DAY) {
			base = base * (int)getParam(mapParams, PayrollConst.DTL_SNISSU);
		} else if (employee.getPaymentType() == PayrollConst.PAYMENT_HOUR) {
			base = (int)MospUtility.round(base * getParam(mapParams, PayrollConst.DTL_KINMUJI) / 60, 0,
					BigDecimal.ROUND_CEILING);
		}
		payment.setAllowanceAmount(PayrollConst.DTL_BASE, base);
	}
	
	/**
	 * ʋΎ蓖vZB
	 * @param employee  Ј
	 * @param payment   ^`[
	 * @param mapParams p[^Map
	 */
	private void calcCommutation(Employee employee, Payment payment, Map<String, String> mapParams) {
		// ϐ錾
		int commuteAmount = 0; // xʋΎ蓖
		int monthlyAmount = 0; // ʋΎ蓖
		int monthlyTaxed = 0; // ېŒʋΔ
		// ^擾
		for (CmCommutationDto cmCommutationDto : employee.getCommutation()) {
			// ϐ錾
			int amount = 0; // ʓʋΎ蓖
			int taxed = 0; // ʓېŒʋΔ
			// ʋΎ蓖擾
			if (cmCommutationDto.getPaymentInterval().equals("1")) {
				// xԊuF
				amount = cmCommutationDto.getCommuteAmount();
				taxed = cmCommutationDto.getCommuteTaxed();
				// ʋΎ蓖yѓېŒʋΔZ
				monthlyAmount += amount;
				monthlyTaxed += taxed;
				// xʋΎ蓖Z
				commuteAmount += amount;
			} else if (cmCommutationDto.getPaymentInterval().equals("5")) {
				// xԊuF(ʋΔ~oΓ(xo܂))
				amount = cmCommutationDto.getCommuteAmount() * (int)getParam(mapParams, PayrollConst.DTL_SNISSU);
				taxed = cmCommutationDto.getCommuteTaxed() * (int)getParam(mapParams, PayrollConst.DTL_SNISSU);
				// ʋΎ蓖yѓېŒʋΔZ
				monthlyAmount += amount;
				monthlyTaxed += taxed;
				// xʋΎ蓖Z
				commuteAmount += amount;
			} else {
				// xԊuF2A3A6
				int interval; // xԊu
				int payStartMonth; // xJn
				int currentMonth; // vZΏی
				// xԊu擾
				if (cmCommutationDto.getPaymentInterval().equals("2")) {
					interval = 2;
				} else if (cmCommutationDto.getPaymentInterval().equals("3")) {
					interval = 3;
				} else {
					interval = 6;
				}
				// xJn擾
				payStartMonth = MospUtility.getMonth(cmCommutationDto.getPayStartMonth());
				// vZΏی擾
				currentMonth = MospUtility.getMonth(payment.getCalcMonth());
				// ʓʋΎ蓖ݒ
				amount = (int)MospUtility.round(cmCommutationDto.getCommuteAmount() / (double)interval, 0,
						BigDecimal.ROUND_FLOOR);
				// ʓېŒʋΔݒ
				taxed = (int)MospUtility.round(cmCommutationDto.getCommuteTaxed() / (double)interval, 0,
						BigDecimal.ROUND_FLOOR);
				// ʋΎ蓖xf
				if (isAllowMonth(interval, payStartMonth, currentMonth)) {
					// ʋΎ蓖AېŒʋΔĐݒ
					amount += cmCommutationDto.getCommuteAmount() - amount * interval;
					taxed += cmCommutationDto.getCommuteTaxed() - taxed * interval;
				}
				// ʋΎ蓖yѓېŒʋΔZ
				monthlyAmount += amount;
				monthlyTaxed += taxed;
				// xʋΎ蓖Z
				if (cmCommutationDto.getLumpMonthlyType().equals("1")) {
					// ꊇ敪Fꊇ
					if (isAllowMonth(interval, payStartMonth, currentMonth)) {
						// x̏ꍇ
						commuteAmount += cmCommutationDto.getCommuteAmount();
					}
				} else {
					// ꊇ敪F
					commuteAmount += amount;
				}
			}
			// ʗpp҂̌xz߂ɂېŒʋΔ
			if (cmCommutationDto.getCommuteType().equals(PayrollConst.COMMUTE_TYPE_CAR)) {
				float distance = cmCommutationDto.getCommuteDistance();
				// ېŒʋΔ擾
				monthlyTaxed += LegalUtility.getTaxationForCarCommute(amount - taxed, distance);
			}
		}
		// ʋΎ蓖̌xz߂ɂېŒʋΔ
		monthlyTaxed += LegalUtility.getTaxationForCommutation(monthlyAmount - monthlyTaxed);
		// ^ݒ
		payment.setCommutation(commuteAmount);
		payment.setCommuteTax(monthlyTaxed);
	}
	
	/**
	 * x𔻒肷B
	 * @param paymetInterval xԊu
	 * @param payStartMonth  xJn
	 * @param currentMonth   Ώی
	 * @return x茋(trueFxAfalseFxłȂ)
	 */
	private boolean isAllowMonth(int paymetInterval, int payStartMonth, int currentMonth) {
		int allowMonth = payStartMonth;
		do {
			allowMonth += paymetInterval;
			if (12 < allowMonth) {
				allowMonth -= 12;
			}
			if (currentMonth == allowMonth) {
				return true;
			}
		} while (payStartMonth != allowMonth);
		return false;
	}
	
	/**
	 * @TvZB
	 * @param employee Ј
	 * @param payment  ^`[
	 * @throws Exception Oꍇ
	 */
	private void calcLegalDeduction(Employee employee, Payment payment) throws Exception {
		// ЉیvZ
		calcSocialInsurance(employee, payment);
		// ŌvZ
		calcIncomeTax(employee, payment);
		// ZŐݒ
		setResidenceTax(employee, payment);
	}
	
	/**
	 * ЉیvZB
	 * @param employee Ј
	 * @param payment  ^`[
	 * @throws Exception Oꍇ 
	 */
	protected void calcSocialInsurance(Employee employee, Payment payment) throws Exception {
		// ЉیlS擾
		float ratioHealthPremium = 0; // Nی 
		float ratioNursingPremium = 0; // ی
		float ratioPensionPremium = 0; // N
		float ratioFundPremium = 0; // N
		float ratioUnemployPremium = 0; // ٗpی
		String fundParticipation = LegalConst.FUND_PARTICIPATION_OFF; // N敪
		// ЉیlS擾
		// vƏΉ ---------------------------------------------------------------------
		CmCompanyDao cmCompanyDao = new CmCompanyDao();
		cmCompanyDao.initDao(cfg, cmd, aspUser, user, conn);
		CmCompanyDto cmCompanyDto = cmCompanyDao.findAll();
		if (cmCompanyDto != null) {
			ratioHealthPremium = cmCompanyDto.getHealthPremiumRate(); // Nی  
			ratioNursingPremium = cmCompanyDto.getNursingPremiumRate(); // ی
			ratioPensionPremium = cmCompanyDto.getPensionPremiumRate(); // N
			ratioFundPremium = cmCompanyDto.getFundPremiumRate(); // N
			ratioUnemployPremium = cmCompanyDto.getUnemployPremiumRate(); // ٗpی
			fundParticipation = cmCompanyDto.getFundParticipation(); // N敪
		}
		// vƏΉ ---------------------------------------------------------------------
		int health = 0; // Nی
		int nursing = 0; // ی
		int pension = 0; // N
		int fund = 0; // N
		int unemploy = 0; // ٗpی
		// NیvZ
		health = LegalUtility.calcPremium(employee.getHealthPayment(), ratioHealthPremium, BigDecimal.ROUND_HALF_UP);
		// یvZΏۊmF
		if (needNursingInsurance(employee, payment)) {
			// یvZ
			nursing = LegalUtility.calcPremium(employee.getHealthPayment(), ratioNursingPremium,
					BigDecimal.ROUND_HALF_UP);
		}
		// NvZ
		pension = LegalUtility.calcPremium(employee.getPensionPayment(), ratioPensionPremium,
				BigDecimal.ROUND_HALF_DOWN);
		// NvZ(N敪uv̏ꍇ)
		if (fundParticipation.equals(LegalConst.FUND_PARTICIPATION_ON)) {
			fund = LegalUtility.calcPremium(employee.getPensionPayment(), ratioFundPremium, BigDecimal.ROUND_HALF_UP);
		}
		// ٗpیvZΏۊzvZ
		payment.calcUnemployInsuration();
		// ٗpیvZ(ٗpی敪uvZv̏ꍇ)
		if (employee.getCalcUnemployType().equals(LegalConst.CALC_UNEMPLOY)) {
			unemploy = LegalUtility.calcPremium(payment.getInsureUnemploy(), ratioUnemployPremium / 1000,
					BigDecimal.ROUND_HALF_DOWN);
		}
		// Љیݒ
		payment.setHealthInsurance(health);
		payment.setNursingInsurance(nursing);
		payment.setPensionInsurance(pension);
		payment.setPensionFund(fund);
		payment.setEmployeeInsurance(unemploy);
		payment.calcSocInsTotal();
	}
	
	/**
	 * یvZvۂ𔻒fB
	 * @param employee Ј
	 * @param payment  ^`[
	 * @return یvZv
	 * @throws Exception Oꍇ
	 */
	private boolean needNursingInsurance(Employee employee, Payment payment) throws Exception {
		// یvZ(ی敪uΏہv̏ꍇ)
		if (employee.getNursingInsType().equals(LegalConst.NURSING_INS_MANUAL)) {
			return true;
		}
		// NŌvZΏۂf(ی敪uΏ()v̏ꍇ)
		if (employee.getNursingInsType().equals(LegalConst.NURSING_INS_AUTO)) {
			// vZNŏI+1擾
			Date toDate = PayrollUtility.addDay(getEndDate(payment.getCalcMonth()), 1);
			// N擾(Ώ۔NŏI+1Ŕf)
			int age = employee.getAge(toDate);
			// 40Έȏ65Ζ͌vZΏ
			if (age >= 40 && age < 65) {
				return true;
			}
		}
		return false;
	}
	
	/**
	 * ܗ^̉یvZvۂ𔻒fB
	 * @param employee Ј
	 * @param bonus    ܗ^`[
	 * @return یvZv
	 * @throws Exception Oꍇ
	 */
	private boolean needNursingInsurance(Employee employee, Bonus bonus) throws Exception {
		// یvZ(ی敪uΏہv̏ꍇ)
		if (employee.getNursingInsType().equals(LegalConst.NURSING_INS_MANUAL)) {
			return true;
		}
		// NŌvZΏۂf(ی敪uΏ()v̏ꍇ)
		if (employee.getNursingInsType().equals(LegalConst.NURSING_INS_AUTO)) {
			// 40(ܗ^vZŏI)ȏ65Ζ(ܗ^vZ)͌vZΏ
			if (employee.getAge(getEndDate(bonus.getCalcMonth())) >= 40
					&& employee.getAge(getStartDate(bonus.getCalcMonth())) < 65) {
				return true;
			}
		}
		return false;
	}
	
	/**
	 * łvZB
	 * @param employee Ј
	 * @param payment  ^`[
	 */
	protected void calcIncomeTax(Employee employee, Payment payment) {
		// }{̐擾
		byte dependent = employee.getDependent();
		// ېŋ敪擾
		String incomeTaxType = employee.getIncomeTaxType();
		// ېőΏۊzvZ
		payment.calcTaxation();
		// ЉیvvZ
		payment.calcSocInsTotal();
		// ЉیT̋^̋z擾
		int afterDeduction = payment.getAfterDeduction();
		// ŊzvZyѐݒ
		int incomeTax = LegalUtility.calcIncomeTax(incomeTaxType, afterDeduction, dependent);
		// }{̐ݒ
		payment.setDependent(dependent);
		// Őݒ
		payment.setIncomeTax(incomeTax);
	}
	
	/**
	 * Złݒ肷B
	 * @param employee Ј
	 * @param payment  ^`[
	 */
	private void setResidenceTax(Employee employee, Payment payment) {
		int residenceTax = 0;
		switch (MospUtility.getMonth(payment.getCalcMonth())) {
			case 6:
				residenceTax = employee.getJuneAmount();
				break;
			case 7:
				residenceTax = employee.getJulyAmount();
				break;
			case 8:
				residenceTax = employee.getAugustAmount();
				break;
			case 9:
				residenceTax = employee.getSeptemberAmount();
				break;
			case 10:
				residenceTax = employee.getOctoberAmount();
				break;
			case 11:
				residenceTax = employee.getNovemberAmount();
				break;
			case 12:
				residenceTax = employee.getDecemberAmount();
				break;
			case 1:
				residenceTax = employee.getJanuaryAmount();
				break;
			case 2:
				residenceTax = employee.getFebruaryAmount();
				break;
			case 3:
				residenceTax = employee.getMarchAmount();
				break;
			case 4:
				residenceTax = employee.getAprilAmount();
				break;
			case 5:
				residenceTax = employee.getMayAmount();
				break;
			default:
				residenceTax = 0;
		}
		payment.setResidenceTax(residenceTax);
	}
	
	/**
	 * vvZB
	 * @param employee Ј
	 * @param payment  ^`[
	 */
	protected void calcTotal(Employee employee, Payment payment) {
		payment.calcUnemployInsuration();
		payment.calcSocInsTotal();
		payment.calcTaxation();
		payment.setIncomeTax(payment.getDeductionAmount(PayrollConst.DTL_INCOME_TAX));
		payment.calcAllowance();
		payment.calcDeduction();
		payment.calcPaymentTotal();
		calcDivideAccounts(employee, payment);
	}
	
	/**
	 * esւ̐UzyьxzvZB
	 * @param employee Ј
	 * @param payment  ^`[
	 */
	private void calcDivideAccounts(Employee employee, Payment payment) {
		// ϐ錾
		int bank1Amount = 0;
		int bank2Amount = 0;
		int cashAmount = 0;
		// x@擾(x@Aԏ)
		List<CmPaymentMeansDto> list = employee.getPaymentMeans();
		// xz擾
		int total = payment.getPaymentTotal();
		// x񖈂̏
		int currentAmount = total;
		for (CmPaymentMeansDto dto : list) {
			// Uz擾
			int amount = getdividedAmount(dto, total, currentAmount);
			// Uzݒ
			if (dto.getPaymentMeans().equals(PayrollConst.PAYMENT_MEANS_ACCOUNT)) {
				// Ȕꍇ
				if (dto.getMeansSequence() == PayrollConst.PAYMENT_MEANS_SEQ_1
						|| dto.getMeansSequence() == PayrollConst.PAYMENT_MEANS_SEQ_3) {
					bank1Amount += amount;
				} else {
					bank2Amount += amount;
				}
			} else {
				// UȊO()̏ꍇ
				cashAmount += amount;
			}
			// czvZ
			currentAmount -= amount;
		}
		// czɐݒ
		cashAmount += currentAmount;
		// ^ݒ
		payment.setBank1PayAmount(bank1Amount);
		payment.setBank2PayAmount(bank2Amount);
		payment.setCashPayAmount(cashAmount);
	}
	
	/**
	 * Uxz擾
	 * @param dto           x@DTO
	 * @param totalAmount   Uz
	 * @param currentAmount Uz(cz)
	 * @return 
	 */
	private int getdividedAmount(CmPaymentMeansDto dto, int totalAmount, int currentAmount) {
		// x񂪐ݒ肳ĂȂꍇ
		if (dto == null) {
			return 0;
		}
		// Sz̏ꍇ
		if (dto.getAmountType().equals(PayrollConst.AMOUNT_TYPE_ALL)) {
			return currentAmount;
		}
		// cz̏ꍇ
		if (dto.getAmountType().equals(PayrollConst.AMOUNT_TYPE_REST)) {
			return currentAmount;
		}
		// Uxz
		int dividingAmount = 0;
		// z敪̏
		if (dto.getAmountType().equals(PayrollConst.AMOUNT_TYPE_AMOUNT)) {
			// z̏ꍇ
			dividingAmount = dto.getFixedAmount();
		} else if (dto.getAmountType().equals(PayrollConst.AMOUNT_TYPE_RATIO)) {
			// 藦̏ꍇ
			// Uz * U / 100
			dividingAmount = (int)MospUtility.round(dto.getFixedAmount() / 100 * totalAmount, 0,
					BigDecimal.ROUND_HALF_UP);
		}
		// Uzȏ̏ꍇ
		if (dividingAmount > currentAmount) {
			dividingAmount = currentAmount;
		}
		return dividingAmount;
	}
	
	/**
	 * גl擾B<br>
	 * @param list       ׏
	 * @param detailCode ׃R[h
	 * @return גl
	 */
	private float getTimeAmount(List<DetailTimeDto> list, String detailCode) {
		for (DetailTimeDto dto : list) {
			if (dto.getDetailCode().equals(detailCode)) {
				return dto.getAmount();
			}
		}
		return 0F;
	}
	
	/**
	 * ^x擾B<br>
	 * @param list ׏
	 * @return ^x
	 */
	private Date getPayDate(List<DetailTimeDto> list) {
		int year = (int)getTimeAmount(list, PayrollConst.DTL_SNEN);
		int month = (int)getTimeAmount(list, PayrollConst.DTL_STUKI);
		int day = (int)getTimeAmount(list, PayrollConst.DTL_SHI);
		return getDate(year, month, day);
	}
	
	/**
	 * ܗ^̎ЉیvZB
	 * @param employee Ј
	 * @param bonus    ܗ^`[
	 * @throws Exception Oꍇ 
	 */
	protected void calcSocialInsurance(Employee employee, Bonus bonus) throws Exception {
		// ЉیlS擾
		float ratioHealth = 0; // Nی
		float ratioNursing = 0; // ی
		float ratioPension = 0; // N
		float ratioFund = 0; // N
		float ratioUnemploy = 0; // ٗpی
		String fundParticipation = LegalConst.FUND_PARTICIPATION_OFF; // N敪
		
		// ЉیlS擾
		CmCompanyDao cmCompanyDao = new CmCompanyDao();
		cmCompanyDao.initDao(cfg, cmd, aspUser, user, conn);
		CmCompanyDto cmCompanyDto = cmCompanyDao.findAll();
		if (cmCompanyDto != null) {
			ratioHealth = cmCompanyDto.getHealthPremiumRate(); // Nی  
			ratioNursing = cmCompanyDto.getNursingPremiumRate(); // ی
			ratioPension = cmCompanyDto.getPensionPremiumRate(); // N
			ratioFund = cmCompanyDto.getFundPremiumRate(); // N
			ratioUnemploy = cmCompanyDto.getUnemployPremiumRate(); // ٗpی
			fundParticipation = cmCompanyDto.getFundParticipation(); // N敪
		}
		
		int basisHealth = 0; // NیvZz
		int basisNursing = 0; // یvZz
		int basisPension = 0; // NvZz
		int basisFund = 0; // NvZz
		int basisUnemploy = 0; // ٗpیvZz
		int health = 0; // Nی
		int nursing = 0; // ی
		int pension = 0; // N
		int fund = 0; // N
		int unemploy = 0; // ٗpی
		
		// xz擾(1000~؂̂)
		int bonusAllowance = (int)round(bonus.getAllowanceTotal(), -3, BigDecimal.ROUND_HALF_DOWN);
		// Nx݌vxz(̎x܂܂Ȃ)
		int yearlyTotalBonus = (int)round(getYearlyTotalBonus(employee, bonus), -3, BigDecimal.ROUND_HALF_DOWN);
		// Ώیxz擾(̎x܂)
		int monthlyTotalBonus = (int)round(getMonthlyTotalBonus(employee, bonus), -3, BigDecimal.ROUND_HALF_DOWN);
		
		// NیvZz擾
		basisHealth = LegalUtility.getBasisHealthPayment(yearlyTotalBonus, bonusAllowance);
		// یvZz擾
		basisNursing = LegalUtility.getBasisNursingPayment(yearlyTotalBonus, bonusAllowance);
		// NvZz擾
		basisPension = LegalUtility.getBasisPensionPayment(monthlyTotalBonus);
		// NvZz擾
		basisFund = LegalUtility.getBasisFundPayment(monthlyTotalBonus);
		// ٗpیvZz擾
		basisUnemploy = LegalUtility.getBasisUnemployPayment(bonusAllowance);
		
		// ܗ^NیvZvۊmF
		if (employee.getBonusHealthType().equals(LegalConst.BONUS_HEALTH_CALC)) {
			// ܗ^NیvZ
			health = LegalUtility.calcPremium(basisHealth, ratioHealth, BigDecimal.ROUND_HALF_UP);
			// یvZvۊmF
			if (needNursingInsurance(employee, bonus)) {
				// یvZ
				nursing = LegalUtility.calcPremium(basisNursing, ratioNursing, BigDecimal.ROUND_HALF_UP);
			}
		}
		// Nܗ^敪mF
		if (employee.getBonusPensionType().equals(LegalConst.BONUS_PENSION_CALC)) {
			// NvZ
			pension = LegalUtility.calcPremium(basisPension, ratioPension, BigDecimal.ROUND_HALF_UP);
			// N敪mF
			if (fundParticipation.equals(LegalConst.FUND_PARTICIPATION_ON)) {
				// NvZ
				fund = LegalUtility.calcPremium(basisFund, ratioFund, BigDecimal.ROUND_HALF_UP);
			}
		}
		// ٗpی敪mF
		if (employee.getCalcUnemployType().equals(LegalConst.CALC_UNEMPLOY)) {
			// ٗpیvZ
			unemploy = LegalUtility.calcPremium(basisUnemploy, ratioUnemploy, BigDecimal.ROUND_HALF_DOWN);
		}
		
		// ̏ܗ^`[Xg擾
		List<Bonus> list = getMonthlyBonusList(employee.getKCode(), bonus.getCalcMonth());
		// ܗ^xmF
		if (list.size() > 1) {
			// YxXg珜
			list.remove(list.size() - 1);
			// xϕی
			for (Bonus formerBonus : list) {
				// xόN
				pension -= formerBonus.getDeductionAmount(PayrollConst.DTL_BONUS_PENSION_INS);
				// xόN
				fund -= formerBonus.getDeductionAmount(PayrollConst.DTL_BONUS_PENSION_FUND);
			}
		}
		
		// Љیݒ
		bonus.setHealthInsurance(health);
		bonus.setNursingInsurance(nursing);
		bonus.setPensionInsurance(pension);
		bonus.setPensionFund(fund);
		bonus.setEmployeeInsurance(unemploy);
		bonus.calcSocInsTotal();
	}
	
	/**
	 * Nx݌vܗ^zvZB<br>
	 * ƂȂܗ^̎x܂ޔNxɂAxȌܗ^xzWvB<br>
	 * ƂȂܗ^͏WvɉȂB<br>
	 * Nx4/1`3/31B<br>
	 * NیWܗ^zZo̍ۂɗpB
	 * @param employee Ј
	 * @param bonus    ܗ^`[(vZ擾ɗp)
	 * @return Nx݌vܗ^z
	 * @throws Exception sO
	 */
	protected long getYearlyTotalBonus(Employee employee, Bonus bonus) throws Exception {
		// NxJn錾
		final int FISCAL_START_MONTH = 4;
		// v
		long total = 0L;
		// Nx擾
		int fiscalYear = getFiscalYear(FISCAL_START_MONTH, bonus.getCalcMonth());
		// x1O擾(ƂȂܗ^͏WvɉȂ)
		Date endDate = new Date(bonus.getCalcMonth().getTime());
		endDate = MospUtility.addDay(endDate, -1);
		// DAO
		PhBounsDao phBonusDao = new PhBounsDao(cfg, cmd, aspUser, user, conn);
		// Ώۏܗ^wb_[Xg擾
		List<PhBounsDto> headerList = phBonusDao.findForConditionDate(employee.getKCode(), getFiscalStartDate(
				fiscalYear, FISCAL_START_MONTH), endDate);
		for (PhBounsDto header : headerList) {
			// Z
			total += header.getAllowanceTotal();
		}
		return total;
	}
	
	/**
	 * Ώۓt܂܂Nx擾B<br>
	 * @param startMonth NxJn
	 * @param date       Ώۓt
	 * @return Nx
	 */
	private int getFiscalYear(int startMonth, Date date) {
		int fiscalYear = MospUtility.getYear(date);
		if (MospUtility.getMonth(date) < startMonth) {
			--fiscalYear;
		}
		return fiscalYear;
	}
	
	/**
	 * ݌vܗ^zvZB<br>
	 * ƂȂܗ^̎x܂ތɂAxȑȌܗ^xzWvB<br>
	 * ƂȂܗ^WvɉB<br>
	 * NیWܗ^zZo̍ۂɗpB
	 * @param employee Ј
	 * @param bonus    ܗ^`[(vZ擾ɗp)
	 * @return Nx݌vܗ^z
	 * @throws Exception sO
	 */
	protected long getMonthlyTotalBonus(Employee employee, Bonus bonus) throws Exception {
		long total = 0L;
		// Ώۏܗ^擾
		List<Bonus> list = getMonthlyBonusList(employee.getKCode(), bonus.getCalcMonth());
		for (Bonus totaledBonus : list) {
			// Z
			total += totaledBonus.getAllowanceTotal();
		}
		return total;
	}
	
	/**
	 * ̏ܗ^`[Xg擾B<br>
	 * Ώێx܂ތɂAΏێxȑȌܗ^Xg擾B<br>
	 * Ώێx̏ܗ^XgɉB<br>
	 * @param kCode   ΏێЈR[h
	 * @param payDate Ώێx
	 * @return ̏ܗ^`[Xg
	 * @throws Exception sO
	 */
	protected List<Bonus> getMonthlyBonusList(String kCode, Date payDate) throws Exception {
		// Xg
		ArrayList<Bonus> list = new ArrayList<Bonus>();
		// DAO
		PhBounsDao phBonusDao = new PhBounsDao(cfg, cmd, aspUser, user, conn);
		// ܗ^wb_[Xg擾
		List<PhBounsDto> headerList = phBonusDao.findForConditionDate(kCode, getStartDate(payDate), payDate);
		// ܗ^`[擾
		for (PhBounsDto dto : headerList) {
			list.add(getBonus(dto.getKCode(), dto.getCalcMonth()));
		}
		return list;
	}
	
	/**
	 * ܗ^̏łvZB
	 * @param employee Ј
	 * @param payment  ^`[(ŗ擾ɗp)
	 * @param bonus    ܗ^`[
	 */
	protected void calcIncomeTax(Employee employee, Payment payment, Bonus bonus) {
		// ېőΏۊzvZ
		bonus.calcTaxation();
		// ЉیvvZ
		bonus.calcSocInsTotal();
		// ЉیT̏ܗ^̋z擾
		int afterDeduction = bonus.getAfterDeduction();
		// ŌvZ
		int incomeTax = 0;
		// }{̐擾
		byte dependent = employee.getDependent();
		// ېŋ敪擾
		String incomeTaxType = employee.getIncomeTaxType();
		// O^mF
		if (payment != null && payment.getAfterDeduction() > 0) {
			// ŊzvZ(O^L)
			incomeTax = LegalUtility.calcBonusIncomeTax(incomeTaxType, payment.getAfterDeduction(), afterDeduction,
					dependent);
		} else {
			// ŊzvZ(O^)
			incomeTax = calcBonusIncomeTax(incomeTaxType, afterDeduction, dependent);
		}
		// Őݒ
		bonus.setIncomeTax(incomeTax);
		// }{̐ݒ
		bonus.setDependent(dependent);
	}
	
	/**
	 * (ܗ^)̐ŗ擾AłZoB<br><br>
	 * uŐ^ꍇv̎Zo@ɑB
	 * @param incomeTaxType ېŋ敪
	 * @param dependent     }{e
	 * @param bonusTaxation ЉیT̋z(ܗ^)
	 * @return (ܗ^)
	 */
	private int calcBonusIncomeTax(String incomeTaxType, int bonusTaxation, int dependent) {
		// w
		int division = 6;
		// ܗ^Љیz~61
		int dividedAmount = (int)round(bonusTaxation / (double)division, 0, BigDecimal.ROUND_FLOOR);
		// ŌvZ
		int incomeTax = LegalUtility.calcIncomeTax(incomeTaxType, dividedAmount, dependent);
		incomeTax = incomeTax * division;
		return incomeTax;
	}
	
	/**
	 * esւ̐UzyьxzvZB
	 * @param employee Ј
	 * @param bonus    ܗ^`[
	 */
	protected void calcDivideAccounts(Employee employee, Bonus bonus) {
		// ϐ錾
		int bank1Amount = 0;
		int bank2Amount = 0;
		int cashAmount = 0;
		// x@擾(x@Aԏ)
		List<CmPaymentMeansDto> list = employee.getPaymentMeans();
		// xz擾
		int total = bonus.getPaymentTotal();
		// x񖈂̏
		int currentAmount = total;
		for (CmPaymentMeansDto dto : list) {
			// Uz擾
			int amount = getdividedAmount(dto, total, currentAmount);
			// Uzݒ
			if (dto.getPaymentMeans().equals(PayrollConst.PAYMENT_MEANS_ACCOUNT)) {
				// Ȕꍇ
				if (dto.getMeansSequence() == PayrollConst.PAYMENT_MEANS_SEQ_1
						|| dto.getMeansSequence() == PayrollConst.PAYMENT_MEANS_SEQ_3) {
					bank1Amount += amount;
				} else {
					bank2Amount += amount;
				}
			} else {
				// UȊO()̏ꍇ
				cashAmount += amount;
			}
			// czvZ
			currentAmount -= amount;
		}
		// czɐݒ
		cashAmount += currentAmount;
		// ^ݒ
		bonus.setBank1PayAmount(bank1Amount);
		bonus.setBank2PayAmount(bank2Amount);
		bonus.setCashPayAmount(cashAmount);
	}
	
	/**
	 * ۂߏ(ľܓ)
	 * @param value Ώےl
	 * @param scale Ώۈʒu(_ȉF0Ő)
	 * @param mode  @
	 * @return ۂߏ̒l
	 */
	protected double round(double value, int scale, int mode) {
		BigDecimal bd;
		if (scale >= 0) {
			bd = new BigDecimal(value);
			return bd.setScale(scale, mode).doubleValue();
		}
		int minusScale = scale * -1;
		double dividing = 1;
		for (int i = 0; i < minusScale; i++) {
			dividing *= 10;
		}
		bd = new BigDecimal(value / dividing);
		return bd.setScale(0, mode).doubleValue() * dividing;
	}
	
	/**
	 * Nv_EACe擾B<br>
	 * @param startYear JnN
	 * @param endYear   IN
	 * @return Nv_EACe
	 */
	protected String[][] getYearArray(int startYear, int endYear) {
		int start = startYear;
		int end = endYear;
		if (startYear > endYear) {
			start = endYear;
			end = startYear;
		}
		String[][] aryYear = new String[end - start + 1][2];
		int i = 0;
		int index = 0;
		for (i = start; i <= end; i++) {
			aryYear[index][0] = String.valueOf(i);
			aryYear[index][1] = String.valueOf(i);
			index++;
		}
		return aryYear;
	}
	
	/**
	 * v_EACe擾B<br>
	 * @return v_EACe
	 */
	protected String[][] getMonthArray() {
		String[][] aryMonth = new String[12][2];
		for (int i = 0; i < 12; i++) {
			aryMonth[i][0] = String.valueOf(i + 1);
			aryMonth[i][1] = String.valueOf(i + 1);
		}
		return aryMonth;
	}
	
	/**
	 * v_EACe擾B<br>
	 * @return v_EACe
	 */
	protected String[][] getDayArray() {
		String[][] aryDay = new String[31][2];
		for (int i = 0; i < 31; i++) {
			aryDay[i][0] = String.valueOf(i + 1);
			aryDay[i][1] = String.valueOf(i + 1);
		}
		return aryDay;
	}
	
	/**
	 * t擾B<br>
	 * @param year  N
	 * @param month 
	 * @param day   
	 * @return t
	 */
	public Date getDate(int year, int month, int day) {
		Calendar cal = Calendar.getInstance();
		cal.set(Calendar.YEAR, year);
		cal.set(Calendar.MONTH, month - 1);
		cal.set(Calendar.DAY_OF_MONTH, day);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		return cal.getTime();
	}
	
	/**
	 * R[ĥ擾B
	 * @param code  擾ΏۃR[h
	 * @param array 擾z
	 * @return R[h
	 */
	protected String getCodeName(String code, String[][] array) {
		String codeName = code;
		if (array == null) {
			return codeName;
		}
		for (String[] element : array) {
			if (code.equals(element[0])) {
				codeName = element[1];
				break;
			}
		}
		return codeName;
	}
	
	/**
	 * sf[^JavaScriptt@CϊB<br>
	 * @param path     o̓t@CpX
	 * @param isCreate t@Co͉ۃtO
	 * @throws Exception Oꍇ
	 */
	public void convFinanceData(String path, boolean isCreate) throws Exception {
		// t@C擾
		File file = new File(path);
		// t@C݂Ȃꍇ܂isCreatetruȅꍇ
		if (!file.exists() | isCreate) {
			FileOutputStream fos = new FileOutputStream(path, false);
			OutputStreamWriter osw = new OutputStreamWriter(fos, "Windows-31J");
			StringBuffer sb = new StringBuffer();
			// s񖼐ݒ
			setJSArray(sb);
			osw.write(sb.toString());
			osw.close();
			fos.close();
		}
	}
	
	/**
	 * sAxXzݒ
	 * @param sb
	 * @throws Exception Oꍇ
	 */
	public void setJSArray(StringBuffer sb) throws Exception {
		// DAȌ
		CmBankDao dao = new CmBankDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ̎擾
		List<CmBankDto> listBank = dao.findAll();
		// s
		String[] aryJsBankCode = new String[listBank.size()];
		String[] aryJsBankName = new String[listBank.size()];
		for (int i = 0; i < listBank.size(); i++) {
			CmBankDto cmBankDto = listBank.get(i);
			aryJsBankCode[i] = cmBankDto.getBankCode();
			aryJsBankName[i] = cmBankDto.getBankName();
		}
		// DAȌ
		CmBranchDao cmBranchDao = new CmBranchDao();
		cmBranchDao.initDao(cfg, cmd, aspUser, user, conn);
		// ̎擾
		List<CmBranchDto> listBranch = cmBranchDao.findAll();
		// z̍쐬
		// xX
		String[] aryJsBraBankCode = new String[listBranch.size()];
		String[] aryJsBranchCode = new String[listBranch.size()];
		String[] aryJsBranchName = new String[listBranch.size()];
		for (int i = 0; i < listBranch.size(); i++) {
			aryJsBraBankCode[i] = listBranch.get(i).getBankCode();
			aryJsBranchCode[i] = listBranch.get(i).getBranchCode();
			aryJsBranchName[i] = listBranch.get(i).getBranchName();
		}
		// sAxXzݒ
		setJSBankName(sb, aryJsBankCode, aryJsBankName, aryJsBraBankCode, aryJsBranchCode, aryJsBranchName);
	}
	
	/**
	 * JS֏nsݒ
	 * @param sb
	 * @param aryJsBankCode
	 * @param aryJsBankName
	 * @param aryJsBraBankCode
	 * @param aryJsBranchCode
	 * @param aryJsBranchName
	 */
	private void setJSBankName(StringBuffer sb, String[] aryJsBankCode, String[] aryJsBankName,
			String[] aryJsBraBankCode, String[] aryJsBranchCode, String[] aryJsBranchName) {
		// sR[h
		if (aryJsBankCode.length == 0) {
			sb.append("aryJsBankCode = new Array();");
			sb.append(MospConst.LINE_SEPARATOR);
		} else {
			sb.append("aryJsBankCode = new Array(");
			// ݒȂzJS
			for (int i = 0; i < aryJsBankCode.length; i++) {
				if (i == aryJsBankCode.length - 1) {
					sb.append("\"" + aryJsBankCode[i] + "\"" + ");");
				} else {
					sb.append("\"" + aryJsBankCode[i] + "\"" + ", ");
				}
			}
			sb.append(MospConst.LINE_SEPARATOR);
		}
		// s
		if (aryJsBankName.length == 0) {
			sb.append("aryJsBankName = new Array();");
			sb.append(MospConst.LINE_SEPARATOR);
		} else {
			sb.append("aryJsBankName = new Array(");
			// ݒȂzJS
			for (int i = 0; i < aryJsBankName.length; i++) {
				if (i == aryJsBankName.length - 1) {
					sb.append("\"" + aryJsBankName[i] + "\"" + ");");
				} else {
					sb.append("\"" + aryJsBankName[i] + "\"" + ", ");
				}
			}
			sb.append(MospConst.LINE_SEPARATOR);
			
		}
		
		// xXsR[h
		if (aryJsBraBankCode.length == 0) {
			sb.append("aryJsBraBankCode = new Array();");
			sb.append(MospConst.LINE_SEPARATOR);
		} else {
			sb.append("aryJsBraBankCode = new Array(");
			// ݒȂzJS
			for (int i = 0; i < aryJsBraBankCode.length; i++) {
				if (i == aryJsBraBankCode.length - 1) {
					sb.append("\"" + aryJsBraBankCode[i] + "\"" + ");");
				} else {
					sb.append("\"" + aryJsBraBankCode[i] + "\"" + ", ");
				}
			}
			sb.append(MospConst.LINE_SEPARATOR);
		}
		
		// xXR[h
		if (aryJsBranchCode.length == 0) {
			sb.append("aryJsBranchCode = new Array();");
			sb.append(MospConst.LINE_SEPARATOR);
		} else {
			sb.append("aryJsBranchCode = new Array(");
			// ݒȂzJS
			for (int i = 0; i < aryJsBranchCode.length; i++) {
				if (i == aryJsBranchCode.length - 1) {
					sb.append("\"" + aryJsBranchCode[i] + "\"" + ");");
				} else {
					sb.append("\"" + aryJsBranchCode[i] + "\"" + ", ");
				}
			}
			sb.append(MospConst.LINE_SEPARATOR);
		}
		
		// xX
		if (aryJsBranchName.length == 0) {
			sb.append("aryJsBranchName = new Array();");
			sb.append(MospConst.LINE_SEPARATOR);
		} else {
			sb.append("aryJsBranchName = new Array(");
			// ݒȂzJS
			for (int i = 0; i < aryJsBranchName.length; i++) {
				if (i == aryJsBranchName.length - 1) {
					sb.append("\"" + aryJsBranchName[i] + "\"" + ");");
				} else {
					sb.append("\"" + aryJsBranchName[i] + "\"" + ", ");
				}
			}
		}
		sb.append(MospConst.LINE_SEPARATOR);
	}
	
	/**
	 * Ћs擾
	 * @return ݒ胊Xg
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws SQLException SQLOꍇ
	 */
	protected String[][] getCoBankArray() throws SQLException, IllegalAccessException, NoSuchFieldException {
		// DAO̐錾
		CmCoBankDao cmCoBankDao = new CmCoBankDao();
		cmCoBankDao.initDao(cfg, cmd, aspUser, user, conn);
		// f[^̎擾
		List<CmCoBankDto> list = cmCoBankDao.findAvailable();
		// f[^̐`
		String[][] array = new String[list.size()][2];
		for (int i = 0; i < list.size(); i++) {
			CmCoBankDto dto = list.get(i);
			array[i][0] = dto.getCoBankCode();
			array[i][1] = dto.getCoBankCode();
		}
		return array;
	}
	
	/**
	 * ftHgt擾B
	 * @return ftHgt
	 */
	private Date getDefaultDate() {
		return getDate(1901, 1, 1);
	}
	
	/**
	 * vZ擾
	 * @return vZ
	 * @throws Exception Oꍇ
	 */
	protected Date getCalcCurrent() throws Exception {
		EndCalcVo vo = (EndCalcVo)getVo();
		// Ώ۔N擾
		Date targetMonth = vo.getCalcDate();
		// DAO
		PtCurrentDao dao = new PtCurrentDao(cfg, cmd, aspUser, user, conn);
		//dao.initDao(cfg, cmd, aspUser, user, conn);
		PtCurrentDto dto = dao.findForKey(PayrollConst.OFFICE_ALL, PayrollConst.CALC_PAYMENT, targetMonth);
		if (dto != null) {
			return dto.getCalcDate();
		}
		return new Date();
	}
	
	/**
	 * N̏擾B
	 * @param year Ώ۔N
	 * @return N̏
	 */
	protected Date getFirstDateOfTheYear(int year) {
		return getDate(year, 1, 1);
	}
	
	/**
	 * N̍ŏI擾B
	 * @param year Ώ۔N
	 * @return N̍ŏI
	 */
	protected Date getLastDateOfTheYear(int year) {
		return getDate(year, 12, 31);
	}
	
	/**
	 * J}}
	 * @param strTarget
	 * @return
	 */
	public String insertComma(String strTarget) {
		if (strTarget == null || strTarget.equals("")) {
			return "";
		}
		return strTarget.replaceAll("(?m)(?<=\\d)(?=(?:\\d{3})+$)", ",");
	}
	
	/**
	 * aNԂ
	 * @param targetMonth
	 * @param vo
	 * @return
	 * @throws Exception  Oꍇ
	 */
	public String jpnYMD(Date targetMonth, PayrollVo vo) throws Exception {
		String jpnYmd = "";
		//aݒ擾
		List<MosPConfDto> listConf = getConfList(PayrollConst.CONF_ID_JP_IMP_CAL);
		String[][] aryEra = getCodeArray(PayrollConst.TID_JAPANESE);
		
		// \pN擾
		String[] strDate = vo.getJpImperialCal(listConf, targetMonth);
		strDate[0] = getCodeName(strDate[0], aryEra);
		jpnYmd = strDate[0] + strDate[1] + PayrollConst.NAM_YEAR + strDate[2] + PayrollConst.NAM_MONTH + strDate[3]
				+ PayrollConst.NAM_DAY;
		return jpnYmd;
	}
	
	/**
	 * aNԂ
	 * @param targetMonth
	 * @param vo
	 * @return
	 * @throws Exception Oꍇ
	 */
	public String jpnYM(Date targetMonth, PayrollVo vo) throws Exception {
		String jpnYm = "";
		//aݒ擾
		List<MosPConfDto> listConf = getConfList(PayrollConst.CONF_ID_JP_IMP_CAL);
		String[][] aryEra = getCodeArray(PayrollConst.TID_JAPANESE);
		
		// \pN擾
		String[] strDate = vo.getJpImperialCal(listConf, targetMonth);
		strDate[0] = getCodeName(strDate[0], aryEra);
		jpnYm = strDate[0] + strDate[1] + PayrollConst.NAM_YEAR + strDate[2] + PayrollConst.NAM_MONTH;
		return jpnYm;
	}
	
	/**
	 * ZbςɂЉی̍XV
	 * @param cdSocInsuranceDao			
	 * @param kCode			ΏێЈ
	 * @param targetMonth	ΏیvZN
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws SQLException SQLOꍇ
	 * @throws MospException  MosPOꍇ
	 */
	// Љی̎ZbEς̎擾XV
	public void updateInsurance(CdSocInsuranceDao cdSocInsuranceDao, String kCode, Date targetMonth)
			throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		int tmpSum = 0;
		CdSocInsuranceDto cdSocInsuranceDto = cdSocInsuranceDao.findForKey(kCode, targetMonth);
		if (null != cdSocInsuranceDto) {
			if ((String.valueOf(cdSocInsuranceDto.getCalcResult()).equals(PayrollConst.CODE_SANTEI_SYORI_WAIT)) || // 1:ZK
					(String.valueOf(cdSocInsuranceDto.getCalcResult()).equals(PayrollConst.CODE_GEPPENN_SYORI_WAIT))) { // 2:ϓK
				//l}X^ЉیZborς̌eɂύX
				CmSocInsuranceDao cmSocInsuranceDao = new CmSocInsuranceDao();
				cmSocInsuranceDao.initDao(cfg, cmd, aspUser, user, conn);
				CmSocInsuranceDto cmSocInsuranceDto = cmSocInsuranceDao.findForEmployee(kCode); //l}X^Љی擾
				if (null != cmSocInsuranceDto) {
					tmpSum = cdSocInsuranceDto.getHealthDecPremium(); // NیWVz̎擾
					if (tmpSum > 1000) {
						tmpSum = tmpSum / 1000;
					}
					cmSocInsuranceDto.setHealthPayment(tmpSum); // NیWVz̐ݒ  
					
					tmpSum = cdSocInsuranceDto.getPensionDecPremium(); // NیWVz̎擾
					if (tmpSum > 1000) {
						tmpSum = tmpSum / 1000;
					}
					cmSocInsuranceDto.setPensionPayment(tmpSum); // NیWVz̐ݒ  
					if ((String.valueOf(cdSocInsuranceDto.getCalcResult()).equals(PayrollConst.CODE_SANTEI_SYORI_WAIT))) { // 1:ZK҂̏ꍇ 
						cdSocInsuranceDto.setCalcResult(Integer.valueOf(PayrollConst.CODE_SANTEI_SYORI_COMP)); // ZKϐݒ
					} else {
						cdSocInsuranceDto.setCalcResult(Integer.valueOf(PayrollConst.CODE_GEPPENN_SYORI_COMP)); // ϓKϐݒ
					}
					cmSocInsuranceDao.update(cmSocInsuranceDto); // l}X^ЉیXV
					cdSocInsuranceDao.update(cdSocInsuranceDto); // ЉیvZf[^XV
					commit();
				}
			}
		}
	}
	
	/**
	 * VXet擾
	 * @return VXet
	 */
	protected Date getSystemDate() {
		Calendar cal = Calendar.getInstance();
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		return cal.getTime();
	}
	
	/**
	 * zɂďo͂l̂ύXB
	 * @param col ԍ
	 * @param row sԍ
	 * @param amount ݒl
	 * @param ods ods[IuWFNg
	 */
	protected void setOdsAmount(int col, int row, String amount, OdsBean ods) {
		if (amount.equals("")) {
			ods.setValue(col, row, amount);
		} else {
			ods.setValue(col, row, new Integer(amount));
		}
	}
	
	/**
	 * zɂďo͂l̂ύXB
	 * @param col ԍ
	 * @param row sԍ
	 * @param amount ݒl
	 * @param sheet sheet[IuWFNg
	 */
	protected void setSheetAmount(int col, int row, String amount, Sheet sheet) {
		if (amount.equals("")) {
			sheet.getCellAt(col, row).setValue(amount);
		} else {
			sheet.getCellAt(col, row).setValue(new Integer(amount));
		}
	}
}
