/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.mospcommon.system.dto;

import java.util.Date;

import jp.mosp.common.common.BaseDto;

/**
 * CM_AGREEMENT_WORK_ON(xo}X^)DTONXB
 */
public class CmAgreementWorkOnDto extends BaseDto {
	
	/**
	 * 
	 */
	private static final long	serialVersionUID	= 9135621150824298187L;
	// tB[h
	private int					workonid			= 0;
	private String				workoncode			= "";
	private String				worktypename		= "";
	private String				cause				= "";
	private String				standardweekholiday	= "";
	private String				officialholiday		= "";
	private String				japaneseholidayflag	= "";
	private String				holidaymasterflag	= "";
	private int					standardholidayrate	= 0;
	private int					officialholidayrate	= 0;
	private int					numberofworkon		= 0;
	private int					starttime			= 0;
	private int					endtime				= 0;
	private Date				startdate			= null;
	private int					deleteflag			= 0;
	

	/**
	 * RXgN^B
	 */
	public CmAgreementWorkOnDto() {
		super();
	}
	
	// ANZT\bh
	/**
	 * @return workonid 	xoIDB
	 */
	public int getWorkOnId() {
		return workonid;
	}
	
	/**
	 * @return workoncode 	xoR[hB
	 */
	public String getWorkOnCode() {
		return workoncode;
	}
	
	/**
	 * @return worktypename 	Ɩ̎ށB
	 */
	public String getWorkTypeName() {
		return worktypename;
	}
	
	/**
	 * @return cause 	̓IRB
	 */
	public String getCause() {
		return cause;
	}
	
	/**
	 * @return standardweekholiday 	xB
	 */
	public String getStandardWeekHoliday() {
		return standardweekholiday;
	}
	
	/**
	 * @return officialholiday 	@xB
	 */
	public String getOfficialHoliday() {
		return officialholiday;
	}
	
	/**
	 * @return japaneseholidayflag 	̏jtOB
	 */
	public String getJapaneseHolidayFlag() {
		return japaneseholidayflag;
	}
	
	/**
	 * @return holidaymasterflag 	jՓ}X^tOB
	 */
	public String getHolidayMasterFlag() {
		return holidaymasterflag;
	}
	
	/**
	 * @return standardholidayrate 	xB
	 */
	public int getStandardHolidayRate() {
		return standardholidayrate;
	}
	
	/**
	 * @return officialholidayrate 	@xB
	 */
	public int getOfficialHolidayRate() {
		return officialholidayrate;
	}
	
	/**
	 * @return numberofworkon 	xoB
	 */
	public int getNumberOfWorkOn() {
		return numberofworkon;
	}
	
	/**
	 * @return starttime 	JnB
	 */
	public int getStartTime() {
		return starttime;
	}
	
	/**
	 * @return endtime 	IB
	 */
	public int getEndTime() {
		return endtime;
	}
	
	/**
	 * @return startdate 	JnNB
	 */
	public Date getStartDate() {
		return (Date)startdate.clone();
	}
	
	/**
	 * @return deleteflag 	폜tOB
	 */
	public int getDeleteFlag() {
		return deleteflag;
	}
	
	/**
	 * @param workonid 	ZbgxoIDB
	 */
	public void setWorkOnId(int workonid) {
		this.workonid = workonid;
	}
	
	/**
	 * @param workoncode 	ZbgxoR[hB
	 */
	public void setWorkOnCode(String workoncode) {
		this.workoncode = workoncode;
	}
	
	/**
	 * @param worktypename 	ZbgƖ̎ށB
	 */
	public void setWorkTypeName(String worktypename) {
		this.worktypename = worktypename;
	}
	
	/**
	 * @param cause 	Zbg̓IRB
	 */
	public void setCause(String cause) {
		this.cause = cause;
	}
	
	/**
	 * @param standardweekholiday 	Zbg鏊xB
	 */
	public void setStandardWeekHoliday(String standardweekholiday) {
		this.standardweekholiday = standardweekholiday;
	}
	
	/**
	 * @param officialholiday 	Zbg@xB
	 */
	public void setOfficialHoliday(String officialholiday) {
		this.officialholiday = officialholiday;
	}
	
	/**
	 * @param japaneseholidayflag 	Zbg鍑̏jtOB
	 */
	public void setJapaneseHolidayFlag(String japaneseholidayflag) {
		this.japaneseholidayflag = japaneseholidayflag;
	}
	
	/**
	 * @param holidaymasterflag 	ZbgjՓ}X^tOB
	 */
	public void setHolidayMasterFlag(String holidaymasterflag) {
		this.holidaymasterflag = holidaymasterflag;
	}
	
	/**
	 * @param standardholidayrate 	Zbg鏊xB
	 */
	public void setStandardHolidayRate(int standardholidayrate) {
		this.standardholidayrate = standardholidayrate;
	}
	
	/**
	 * @param officialholidayrate 	Zbg@xB
	 */
	public void setOfficialHolidayRate(int officialholidayrate) {
		this.officialholidayrate = officialholidayrate;
	}
	
	/**
	 * @param numberofworkon 	ZbgxoB
	 */
	public void setNumberOfWorkOn(int numberofworkon) {
		this.numberofworkon = numberofworkon;
	}
	
	/**
	 * @param starttime 	ZbgJnB
	 */
	public void setStartTime(int starttime) {
		this.starttime = starttime;
	}
	
	/**
	 * @param endtime 	ZbgIB
	 */
	public void setEndTime(int endtime) {
		this.endtime = endtime;
	}
	
	/**
	 * @param startdate 	ZbgJnNB
	 */
	public void setStartDate(Date startdate) {
		this.startdate = (Date)startdate.clone();
	}
	
	/**
	 * @param deleteflag 	Zbg폜tOB
	 */
	public void setDeleteFlag(int deleteflag) {
		this.deleteflag = deleteflag;
	}
	
}
