/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * 
 */
package jp.mosp.mospcommon.system;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Properties;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.CmUserDto;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.mospcommon.system.dao.CmAgreementOverTimeDao;
import jp.mosp.mospcommon.system.dao.CmAgreementWorkOnDao;
import jp.mosp.mospcommon.system.dao.CmLaborAgreementDao;
import jp.mosp.mospcommon.system.dao.CmLimitStandardDao;
import jp.mosp.mospcommon.system.dto.CmAgreementOverTimeDto;
import jp.mosp.mospcommon.system.dto.CmAgreementWorkOnDto;
import jp.mosp.mospcommon.system.dto.CmLaborAgreementDto;
import jp.mosp.mospcommon.system.dto.CmLimitStandardDto;

/**
 * JgǗNX
 * @author yoshida
 *
 */
public class LaborAgreementManager {
	
	/**
	 * ^O[vR[h(SALARY_GRP_CD)
	 */
	public static final String		SALARY_GRP_CD	= "SALARY_GRP_CD";
	/**
	 * ЈR[h(K_CODE)
	 */
	public static final String		K_CODE			= "K_CODE";
	
	/**
	 * MosPAvP[Vݒ(/WEB-INF/mosp.properties)B
	 */
	private Properties				cfg;
	
	/**
	 * NGXgꂽCommandB
	 */
	private String					cmd;
	
	/**
	 * OCASP[U[B
	 */
	private CmAspUserDto			aspUser;
	
	/**
	 * OC[U[B
	 */
	private CmUserDto				user;
	
	/**
	 * DBRlNVB
	 */
	private Connection				conn;
	
	private CmAgreementOverTimeDao	overTimeDao;
	private CmAgreementWorkOnDao	workOnDao;
	private CmLaborAgreementDao		agreementDao;
	private CmLimitStandardDao		standardDao;
	

	/**
	 * RXgN^B
	 * @param cfg 		MosPAvP[VݒB
	 * @param cmd 		NGXgꂽCommandB
	 * @param aspUser 	OCASP[U[B
	 * @param user 		OC[U[B
	 * @param conn 		DBRlNVB
	 */
	public LaborAgreementManager(Properties cfg, String cmd, CmAspUserDto aspUser, CmUserDto user, Connection conn) {
		super();
		this.cfg = cfg;
		this.cmd = cmd;
		this.aspUser = aspUser;
		this.user = user;
		this.conn = conn;
	}
	
	/**
	 * Jg擾B
	 * @param targetCode 	ΏۃR[h
	 * @param targetDate 	Ώ۔N
	 * @return Jg
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public AgreementBaseInfo getAgreementInfo(String targetCode, Date targetDate) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		// cfgɓĂl^AW擾B
		if (StringUtil.isNotNull(cfg.getProperty(""))) {
			return getGroupAgreementInfo(targetCode, targetDate);
		} else {
			return getKCodeAgreementInfo(targetCode, targetDate);
		}
	}
	
	/**
	 * ЈR[hɂJg擾B
	 * @param kCode			ЈR[h
	 * @param targetDate	Ώ۔N
	 * @return	Jg
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public AgreementBaseInfo getKCodeAgreementInfo(String kCode, Date targetDate) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		return getAgreementInfo(getKCodeAgreementInfo(kCode), targetDate);
	}
	
	/**
	 * ^O[vR[hɂJg擾B
	 * @param salarygrpcd			^O[vR[h
	 * @param targetDate	Ώ۔N
	 * @return	Jg
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public AgreementBaseInfo getGroupAgreementInfo(String salarygrpcd, Date targetDate) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		return getAgreementInfo(getGroupAgreementInfo(salarygrpcd), targetDate);
	}
	
	/**
	 * ЈR[hɂJg}X^擾B
	 * @param kCode ЈR[h
	 * @return Jg}X^
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public CmLaborAgreementDto getKCodeAgreementInfo(String kCode) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		return getAgreementDao().findForAgreeType(kCode, K_CODE);
	}
	
	/**
	 * ^O[vR[hɂJg}X^擾B
	 * @param salarygrpcd ^O[vR[h
	 * @return Jg}X^
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public CmLaborAgreementDto getGroupAgreementInfo(String salarygrpcd) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		return getAgreementDao().findForAgreeType(salarygrpcd, SALARY_GRP_CD);
	}
	
	/**
	 * ԊOR[hɂ鎞ԊO}X^擾B
	 * @param overTimeCode ԊOR[h
	 * @param targetDate  Ώ۔N
	 * @return ԊO}X^
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public CmAgreementOverTimeDto getOverTimeAgreementInfo(String overTimeCode, Date targetDate) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		return getOverTimeDao().findForAgreement(overTimeCode, targetDate);
	}
	
	/**
	 * xoR[hɂxo}X^擾B
	 * @param workOnCode xoR[h
	 * @param targetDate  Ώ۔N
	 * @return xo}X^
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public CmAgreementWorkOnDto getWorkOnAgreementInfo(String workOnCode, Date targetDate) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		return getWorkOnDao().findForAgreement(workOnCode, targetDate);
	}
	
	/**
	 * xR[hɂx}X^擾B
	 * @param limitCode xR[h
	 * @return x}X^
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public CmLimitStandardDto getLimitStandardInfo(String limitCode) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		return getStandardDao().findForLimitCode(limitCode);
	}
	
	/**
	 * }X^̏JgɃZbgB
	 * @param dto Jg}X^
	 * @param targetDate Ώ۔N
	 * @return Jg
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	private AgreementBaseInfo getAgreementInfo(CmLaborAgreementDto dto, Date targetDate) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		AgreementInfo info = null;
		if (dto != null) {
			info = new AgreementInfo();
			// Jg}X^ݒ
			setAgreementInfo(info, dto);
			// ԊO}X^擾
			CmAgreementOverTimeDto overTimeDto = getOverTimeAgreementInfo(dto.getOverTimeCode(), targetDate);
			// x}X^擾
			setOverTimeInfo(info, overTimeDto);
			setStandardInfo(info, getLimitStandardInfo(info.getLimitCode()));
			// xo}X^擾
			setWorkOnInfo(info, getWorkOnAgreementInfo(dto.getWorkOnCode(), targetDate));
		}
		return info;
	}
	
	/**
	 * Jg}X^ݒ
	 * @param info Jg
	 * @param dto Jg}X^
	 */
	private void setAgreementInfo(AgreementInfo info, CmLaborAgreementDto dto) {
		if (dto != null) {
			info.setAgreementDto(dto);
			info.setAgreeCode(dto.getAgreeCode());
			if (SALARY_GRP_CD.equals(dto.getAgreeType())) {
				info.setSalaryGrpCd(dto.getAgreeCode());
			} else {
				info.setKCode(dto.getAgreeCode());
			}
			info.setOverTimeCode(dto.getOverTimeCode());
			info.setWorkOnCode(dto.getWorkOnCode());
		}
	}
	
	/**
	 * ԊO}X^ݒ
	 * @param info Jg
	 * @param dto ԊO}X^
	 */
	private void setOverTimeInfo(AgreementInfo info, CmAgreementOverTimeDto dto) {
		if (dto != null) {
			info.setOverTimeDto(dto);
			info.setOverWorkTypeName(dto.getWorkTypeName());
			info.setOverCause(dto.getCause());
			info.setOverAgreeType(dto.getAgreeType());
			info.setLimitCode(dto.getLimitCode());
			info.setOverTimeRate(dto.getOverTimeRate());
			info.setCautionMonth(dto.getCautionMonth());
			info.setMonthlyOverTimeRate(dto.getMonthlyOverTimeRate());
			info.setSubAcquireRate(dto.getSubAcquireRate());
			info.setSubAcquireHolidayRate(dto.getSubAcquireHolidayRate());
			info.setSubQuitRate(dto.getSubQuitRate());
			info.setOverStartDate(dto.getStartDate());
		}
	}
	
	/**
	 * xo}X^ݒ
	 * @param info Jg
	 * @param dto xo}X^
	 */
	private void setWorkOnInfo(AgreementInfo info, CmAgreementWorkOnDto dto) {
		if (dto != null) {
			info.setWorkOnDto(dto);
			info.setWorkOnWorkTypeName(dto.getWorkTypeName());
			info.setWorkOnCause(dto.getCause());
			info.setStandardWeekHoliday(dto.getStandardWeekHoliday());
			info.setOfficialHoliday(dto.getOfficialHoliday());
			info.setJapaneseHolidayFlag(dto.getJapaneseHolidayFlag());
			info.setHolidayMasterFlag(dto.getHolidayMasterFlag());
			info.setStandardHolidayRate(dto.getStandardHolidayRate());
			info.setOfficialHolidayRate(dto.getOfficialHolidayRate());
			info.setNumberOfWorkOn(dto.getNumberOfWorkOn());
			info.setWorkOnStartTime(dto.getStartTime());
			info.setWorkOnEndTime(dto.getEndTime());
			info.setWorkOnStartDate(dto.getStartDate());
		}
	}
	
	/**
	 * x}X^ݒ
	 * @param info Jg
	 * @param dto x}X^
	 */
	private void setStandardInfo(AgreementInfo info, CmLimitStandardDto dto) {
		if (dto != null) {
			info.setStandardDto(dto);
			info.setLimitName(dto.getLimitName());
			info.setTermType(dto.getTermType());
			info.setPrescribedTime(dto.getPrescribedTime());
			info.setCautionDay(dto.getCautionDay());
			info.setCautionTerm(dto.getCautionTerm());
			info.setCautionYear(dto.getCautionYear());
			info.setLimitDay(dto.getLimitDay());
			info.setLimitTerm(dto.getLimitTerm());
			info.setLimitYear(dto.getLimitYear());
			info.setRateTerm(dto.getRateTerm());
			info.setRateYear(dto.getRateYear());
		}
	}
	
	/**
	 * Jg}X^DAO擾B
	 * @return CmLaborAgreementDaoCX^XB
	 */
	public CmLaborAgreementDao getAgreementDao() {
		if (agreementDao == null) {
			agreementDao = new CmLaborAgreementDao();
			agreementDao.initDao(cfg, cmd, aspUser, user, conn);
		}
		return agreementDao;
	}
	
	/**
	 * ԊO}X^DAO擾B
	 * @return CmAgreementOverTimeDaoCX^XB
	 */
	public CmAgreementOverTimeDao getOverTimeDao() {
		if (overTimeDao == null) {
			overTimeDao = new CmAgreementOverTimeDao();
			overTimeDao.initDao(cfg, cmd, aspUser, user, conn);
		}
		return overTimeDao;
	}
	
	/**
	 * xo}X^DAO擾B
	 * @return CmAgreementWorkOnDaoCX^XB
	 */
	public CmAgreementWorkOnDao getWorkOnDao() {
		if (workOnDao == null) {
			workOnDao = new CmAgreementWorkOnDao();
			workOnDao.initDao(cfg, cmd, aspUser, user, conn);
		}
		return workOnDao;
	}
	
	/**
	 * x}X^DAO擾B
	 * @return CmLimitStandardDaoCX^XB
	 */
	public CmLimitStandardDao getStandardDao() {
		if (standardDao == null) {
			standardDao = new CmLimitStandardDao();
			standardDao.initDao(cfg, cmd, aspUser, user, conn);
		}
		return standardDao;
	}
	
	/**
	 * xR[h擾
	 * @return xR[hXg
	 * @throws SQLException SQLOꍇ
	 * @throws NoSuchFieldException w肳ꂽÕtB[hNXɂ͂Ȃꍇ
	 * @throws IllegalAccessException {ƂȂ郁\bhOX[ꍇ
	 * @throws MospException  MosPOꍇ
	 */
	public String[][] getLimitStandardArray() throws SQLException, NoSuchFieldException, IllegalAccessException,
			MospException {
		// ̎擾
		List<CmLimitStandardDto> list = getStandardDao().findAvailable();
		// z̍쐬
		String[][] aryLimitStandard = new String[list.size()][2];
		for (int i = 0; i < aryLimitStandard.length; i++) {
			aryLimitStandard[i][0] = list.get(i).getLimitCode();
			aryLimitStandard[i][1] = list.get(i).getLimitName();
		}
		return aryLimitStandard;
	}
	
	/**
	 * ԊOR[h擾
	 * @param targetDate Ώ۔N
	 * @return ԊOR[h
	 * @throws NoSuchFieldException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws SQLException tB[hȂꍇ
	 */
	public String[][] getOverTimeArray(Date targetDate) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		// ̎擾
		List<String> list = getOverTimeDao().findForOverTimeCode(targetDate);
		// z̍쐬
		String[][] aryOverTime = new String[list.size()][2];
		for (int i = 0; i < aryOverTime.length; i++) {
			aryOverTime[i][0] = list.get(i);
			StringBuffer sb = new StringBuffer();
			sb.append(list.get(i));
			sb.append(CommonConst.NAM_COMMON_HALF_KANA_SPACE);
			sb.append(StringUtil.surroundRoundBracket(getOverTimeAgreementInfo(list.get(i), targetDate)
				.getWorkTypeName()));
			aryOverTime[i][1] = sb.toString();
		}
		return aryOverTime;
	}
	
	/**
	 * xoR[h擾
	 * @param targetDate Ώ۔N
	 * @return xoR[h擾
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 */
	public String[][] getWorkOnArray(Date targetDate) throws SQLException, IllegalAccessException, NoSuchFieldException {
		// ̎擾
		List<String> list = getWorkOnDao().findForWorkOnCode(targetDate);
		// z̍쐬
		String[][] aryWorkOn = new String[list.size()][2];
		for (int i = 0; i < aryWorkOn.length; i++) {
			aryWorkOn[i][0] = list.get(i);
			StringBuffer sb = new StringBuffer();
			sb.append(list.get(i));
			sb.append(CommonConst.NAM_COMMON_HALF_KANA_SPACE);
			sb.append(StringUtil
				.surroundRoundBracket(getWorkOnAgreementInfo(list.get(i), targetDate).getWorkTypeName()));
			aryWorkOn[i][1] = sb.toString();
		}
		return aryWorkOn;
	}
	
}
