/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.workflow.vo;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.TimeUtil;
import jp.mosp.kintai.common.vo.MosPWorkFlowVo;
import jp.mosp.kintai.workflow.dto.CtOvertimeRequestDto;

/**
 * @author yoshida
 *
 */
public class OverTimeApprovalCardVo extends MosPWorkFlowVo {
	
	private static final long	serialVersionUID	= 7521192658753437599L;
	
	// 萔
	/**
	 * 0
	 */
	public static final int		MODE_SELECT			= 0;
	/**
	 * 1
	 */
	public static final int		MODE_APPROVED		= 1;
	/**
	 * 2
	 */
	public static final int		MODE_VIEW			= 2;
	
	// tB[h
	private String				lblWorkDate;
	private String				lblOverTime;
	private String				lblReason;
	private String				lblReqestDate;
	private String				lblApprovalStatus;
	
	private String				lblOverTimeMonthly;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_K_CODE;
	/**
	 * 
	 */
	public String				NAM_K_NAME;
	/**
	 * 
	 */
	public String				NAM_SECTION;
	/**
	 * 
	 */
	public String				NAM_WORK_DATE;
	/**
	 * 
	 */
	public String				NAM_OVER_TIME;
	/**
	 * 
	 */
	public String				NAM_OVER_TIME_MONTHLY;
	/**
	 * 
	 */
	public String				NAM_REQUEST_DATE;
	/**
	 * 
	 */
	public String				NAM_REASON;
	/**
	 * 
	 */
	public String				NAM_STATUS;
	/**
	 * 
	 */
	public String				NAM_COMMENT;
	
	// [h(0FFE߂A1FύXs)
	private int					mode;
	private boolean				isCaution;
	private boolean				isWarning;
	

	/**
	 * RXgN^
	 */
	public OverTimeApprovalCardVo() {
		super();
		setViewPath(getClassName());
		mode = MODE_SELECT;
	}
	
	@Override
	public void setSubTitle() {
		subTitle = CommonConst.NAM_OVER_TIME_REQUEST + CommonConst.NAM_APPROVED;
		aryMenu = new String[][]{ { CMD_MENU_MAMAGE, CommonConst.NAM_TO_MENU }, MosPMenuConst.getMenuManagerApproval(), };
	}
	
	@Override
	protected void setFieldsName() {
		super.setFieldsName();
		NAM_K_CODE = CommonConst.NAM_K_CODE;
		NAM_K_NAME = CommonConst.NAM_K_NAME;
		NAM_SECTION = CommonConst.NAM_STATION;
		NAM_WORK_DATE = CommonConst.NAM_WORKING + CommonConst.NAM_DAY;
		NAM_OVER_TIME = CommonConst.NAM_APPLICATION + CommonConst.NAM_COMMON_TIME;
		NAM_OVER_TIME_MONTHLY = CommonConst.NAM_WORKING + CommonConst.NAM_MONTH + CommonConst.NAM_OVERTIME
				+ CommonConst.NAM_COMMON_SUM;
		NAM_REQUEST_DATE = CommonConst.NAM_APPLICATION + CommonConst.NAM_DAY;
		NAM_REASON = CommonConst.NAM_REASON;
		NAM_STATUS = CommonConst.NAM_APPROVAL_STATE;
		NAM_COMMENT = CommonConst.NAM_COMMENT;
		LEN_COMMENT = 50;
	}
	
	/**
	 * tB[hݒ
	 * @param dto ݒΏDTO
	 */
	public void setFields(CtOvertimeRequestDto dto) {
		setHidVoucher(String.valueOf(dto.getVoucher()));
		lblWorkDate = DateUtil.convDateToFormatDateJP(dto.getWorkDate());
		lblOverTime = TimeUtil.convIntegerTimeToJPHours(dto.getOverTime());
		lblReason = dto.getReason();
		lblReqestDate = DateUtil.convDateToFormatDateJP(dto.getInsertDate());
	}
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException MosPOꍇ
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// 񒷊mF
		checkLength(getTxtComment(), LEN_COMMENT, NAM_COMMENT, PRM_TXT_COMMENT);
		// ÓmFI
		endValidation();
	}
	
	@Override
	public String getDirectJs(Class<?> cls, Object obj) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls, obj));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		// x
		sb.append("var CAUTION = ");
		sb.append(isCaution);
		sb.append(";");
		// 
		sb.append("var WARNING = ");
		sb.append(isWarning);
		sb.append(";");
		return sb.toString();
	}
	
	// ANZT\bh
	/**
	 * @return lblWorkDate
	 */
	public String getEscLblWorkDate() {
		return escapeHTML(lblWorkDate);
	}
	
	/**
	 * @return lblOverTime
	 */
	public String getEscLblOverTime() {
		return escapeHTML(lblOverTime);
	}
	
	/**
	 * @return lblReason
	 */
	public String getEscLblReason() {
		return escapeHTML(lblReason);
	}
	
	/**
	 * @return lblApprovalStatus
	 */
	public String getEscLblApprovalStatus() {
		return escapeHTML(lblApprovalStatus);
	}
	
	/**
	 * @return lblReqestDate
	 */
	public String getEscLblReqestDate() {
		return escapeHTML(lblReqestDate);
	}
	
	/**
	 * @return lblWorkDate
	 */
	public String getLblWorkDate() {
		return lblWorkDate;
	}
	
	/**
	 * @return lblOverTime
	 */
	public String getLblOverTime() {
		return lblOverTime;
	}
	
	/**
	 * @return lblReason
	 */
	public String getLblReason() {
		return lblReason;
	}
	
	/**
	 * @return lblReqestDate
	 */
	public String getLblReqestDate() {
		return lblReqestDate;
	}
	
	/**
	 * @return lblApprovalStatus
	 */
	public String getLblApprovalStatus() {
		return lblApprovalStatus;
	}
	
	/**
	 * @return lblOverTimeMonthly
	 */
	public String getLblOverTimeMonthly() {
		return lblOverTimeMonthly;
	}
	
	/**
	 * @return mode
	 */
	public int getMode() {
		return mode;
	}
	
	/**
	 * @return isCaution
	 */
	public boolean isCaution() {
		return isCaution;
	}
	
	/**
	 * @return isWarning
	 */
	public boolean isWarning() {
		return isWarning;
	}
	
	/**
	 * @param lblWorkDate Zbg lblWorkDate
	 */
	public void setLblWorkDate(String lblWorkDate) {
		this.lblWorkDate = lblWorkDate;
	}
	
	/**
	 * @param lblOverTime Zbg lblOverTime
	 */
	public void setLblOverTime(String lblOverTime) {
		this.lblOverTime = lblOverTime;
	}
	
	/**
	 * @param lblReason Zbg lblReason
	 */
	public void setLblReason(String lblReason) {
		this.lblReason = lblReason;
	}
	
	/**
	 * @param lblReqestDate Zbg lblReqestDate
	 */
	public void setLblReqestDate(String lblReqestDate) {
		this.lblReqestDate = lblReqestDate;
	}
	
	/**
	 * @param lblApprovalStatus Zbg lblApprovalStatus
	 */
	public void setLblApprovalStatus(String lblApprovalStatus) {
		this.lblApprovalStatus = lblApprovalStatus;
	}
	
	/**
	 * @param lblOverTimeMonthly Zbg lblOverTimeMonthly
	 */
	public void setLblOverTimeMonthly(String lblOverTimeMonthly) {
		this.lblOverTimeMonthly = lblOverTimeMonthly;
	}
	
	/**
	 * @param mode Zbg mode
	 */
	public void setMode(int mode) {
		this.mode = mode;
	}
	
	/**
	 * @param isCaution Zbg isCaution
	 */
	public void setCaution(boolean isCaution) {
		this.isCaution = isCaution;
	}
	
	/**
	 * @param isWarning Zbg isWarning
	 */
	public void setWarning(boolean isWarning) {
		this.isWarning = isWarning;
	}
	
}
