/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.workflow.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.kintai.workflow.dto.HolidayRequestDto;

/**
 * @author yoshida
 *
 */
public class HolidayRequestListVo extends MosPVo {
	
	private static final long	serialVersionUID	= 8736704157467772971L;
	
	// p[^
	/**
	 * pltYear
	 */
	public static final String	PRM_PLT_YEAR		= "pltYear";
	/**
	 * pltMonth
	 */
	public static final String	PRM_PLT_MONTH		= "pltMonth";
	
	// tB[h
	private String[][]			aryHoliday;
	private String				pltYear;
	private String				pltMonth;
	
	// Lxc
	private String				lblTotalRemainDays;
	private String				lblTotalRemainHour;
	// ԊOxc
	private String				lblSubstituteRemain;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_SECTION;
	/**
	 * 
	 */
	public String				NAM_K_NAME;
	/**
	 * 
	 */
	public String				NAM_MONTH;
	/**
	 * 
	 */
	public String				NAM_HOLIDAY_DATE;
	/**
	 * 
	 */
	public String				NAM_REASON;
	/**
	 * 
	 */
	public String				NAM_STATUS;
	/**
	 * 
	 */
	public String				NAM_APPROVER;
	/**
	 * 
	 */
	public String				NAM_COMMENT;
	
	// v_EXg
	/**
	 * 
	 */
	public String[][]			aryPltYear;
	/**
	 * 
	 */
	public String[][]			aryPltMonth;
	
	// \[gL[
	/**
	 * 
	 */
	public final String			KEY_HOLIDAY_DATE	= "keyHolidayDate";
	/**
	 * 
	 */
	public final String			KEY_REASON			= "keyReason";
	/**
	 * 
	 */
	public final String			KEY_STATUS			= "keyStatus";
	/**
	 * 
	 */
	public final String			KEY_APPROVER		= "keyApprover";
	
	private boolean				useSubstitute;
	private boolean				useHourHoliday;
	

	/**
	 * RXgN^
	 */
	public HolidayRequestListVo() {
		super();
		setViewPath(getClassName());
		aryHoliday = new String[0][0];
		pltYear = "";
		pltMonth = "";
		lblTotalRemainDays = "";
		lblTotalRemainHour = "";
		lblSubstituteRemain = "";
		setFormerKey(KEY_HOLIDAY_DATE);
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.NAM_HOLIDAY_REQUEST;
		createAryMenu(CMD_MENU_INPUT, MosPMenuConst.getMenuApplication());
	}
	
	@Override
	protected void setFieldsName() {
		NAM_SECTION = CommonConst.NAM_STATION;
		NAM_K_NAME = CommonConst.NAM_K_NAME;
		NAM_MONTH = CommonConst.NAM_YEAR + CommonConst.NAM_MONTH;
		NAM_HOLIDAY_DATE = CommonConst.NAM_VACATION_LEAVE + CommonConst.NAM_DAY;
		NAM_REASON = CommonConst.NAM_VACATION_LEAVE + CommonConst.NAM_REASON;
		NAM_STATUS = CommonConst.NAM_APPROVAL_STATE;
		NAM_APPROVER = CommonConst.NAM_APPROVER;
		NAM_COMMENT = CommonConst.NAM_CAUSE;
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		pltYear = request.getParameter(PRM_PLT_YEAR);
		pltMonth = request.getParameter(PRM_PLT_MONTH);
	}
	
	@Override
	public void setFields(List<?> listRequest) {
		// Xg̐ݒ
		list = listRequest;
		// f[^̎擾
		count = listRequest.size();
		// z̏
		aryHoliday = new String[count][7];
		// f[^̐ݒ
		int i = 0;
		Iterator<?> it = listRequest.iterator();
		while (it.hasNext()) {
			HolidayRequestDto dto = (HolidayRequestDto)it.next();
			// `[ԍ
			aryHoliday[i][0] = escapeHTML(String.valueOf(dto.getVoucher()));
			// xɓ
			aryHoliday[i][1] = escapeHTML(DateUtil.convDateToFormatDateJP(dto.getHolidayDate()));
			// xɗR
			aryHoliday[i][2] = escapeHTML(dto.getReason());
			// F
			aryHoliday[i][3] = escapeHTML(dto.getApprovalStatus());
			// F
			aryHoliday[i][4] = escapeHTML(dto.getApproverName());
			// R
			aryHoliday[i][5] = escapeHTML(dto.getCauseComment());
			i++;
		}
	}
	
	@Override
	public String getDirectJs(Class<?> cls, Object obj) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls, obj));
		// ԒPʔNx
		sb.append("var HOUR_HOLIDAY = ");
		sb.append(useHourHoliday);
		sb.append(";");
		// x@\
		sb.append("var SUBSTITUTE = ");
		sb.append(useSubstitute);
		sb.append(";");
		return sb.toString();
	}
	
	// ANZT\bh
	/**
	 * @return aryHoliday
	 */
	public String[][] getEscAryHoliday() {
		return aryHoliday.clone();
	}
	
	/**
	* @return pltYear
	*/
	public String getEscPltYear() {
		return escapeHTML(pltYear);
	}
	
	/**
	 * @return pltMonth
	 */
	public String getEscPltMonth() {
		return escapeHTML(pltMonth);
	}
	
	/**
	 * @return pltYear
	 */
	public String getPltYear() {
		return pltYear;
	}
	
	/**
	 * @return pltMonth
	 */
	public String getPltMonth() {
		return pltMonth;
	}
	
	/**
	 * @param pltYear Zbg pltYear
	 */
	public void setPltYear(String pltYear) {
		this.pltYear = pltYear;
	}
	
	/**
	 * @param pltMonth Zbg pltMonth
	 */
	public void setPltMonth(String pltMonth) {
		this.pltMonth = pltMonth;
	}
	
	/**
	 * @return lblTotalRemainDays
	 */
	public String getLblTotalRemainDays() {
		return lblTotalRemainDays;
	}
	
	/**
	 * @return lblTotalRemainHour
	 */
	public String getLblTotalRemainHour() {
		return lblTotalRemainHour;
	}
	
	/**
	 * @return lblSubstituteRemain
	 */
	public String getLblSubstituteRemain() {
		return lblSubstituteRemain;
	}
	
	/**
	 * @param lblTotalRemainDays Zbg lblTotalRemainDays
	 */
	public void setLblTotalRemainDays(String lblTotalRemainDays) {
		this.lblTotalRemainDays = lblTotalRemainDays;
	}
	
	/**
	 * @param lblTotalRemainHour Zbg lblTotalRemainHour
	 */
	public void setLblTotalRemainHour(String lblTotalRemainHour) {
		this.lblTotalRemainHour = lblTotalRemainHour;
	}
	
	/**
	 * @param lblSubstituteRemain Zbg lblSubstituteRemain
	 */
	public void setLblSubstituteRemain(String lblSubstituteRemain) {
		this.lblSubstituteRemain = lblSubstituteRemain;
	}
	
	/**
	 * @return useSubstitute
	 */
	public boolean isUseSubstitute() {
		return useSubstitute;
	}
	
	/**
	 * @return useHourHoliday
	 */
	public boolean isUseHourHoliday() {
		return useHourHoliday;
	}
	
	/**
	 * @param useSubstitute Zbg useSubstitute
	 */
	public void setUseSubstitute(boolean useSubstitute) {
		this.useSubstitute = useSubstitute;
	}
	
	/**
	 * @param useHourHoliday Zbg useHourHoliday
	 */
	public void setUseHourHoliday(boolean useHourHoliday) {
		this.useHourHoliday = useHourHoliday;
	}
	
}
