/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.workflow.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.kintai.workflow.dto.AmUnitDto;

/**
 * @author yoshida
 *
 */
public class ApprovalUnitListVo extends MosPVo {
	
	private static final long	serialVersionUID	= 4781254088593017966L;
	
	// 萔
	/**
	 * 
	 */
	public static final int		SEARCH_OFF			= 0;
	/**
	 * 
	 */
	public static final int		SEARCH_ON			= 1;
	
	// p[^
	/**
	 * 
	 */
	public static final String	PRM_TXT_K_CODE		= "txtKCode";
	/**
	 * 
	 */
	public static final String	PRM_TXT_K_NAME		= "txtKName";
	/**
	 * 
	 */
	public static final String	PRM_TXT_UNIT_CODE	= "txtUnitCode";
	/**
	 * 
	 */
	public String[][]			aryPltUser;
	
	// tB[h
	private String[][]			aryUnit;
	
	private String				txtKCode;
	private String				txtKName;
	private String				txtUnitCode;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_K_CODE;
	/**
	 * 
	 */
	public String				NAM_K_NAME;
	/**
	 * 
	 */
	public String				NAM_UNIT_CODE;
	/**
	 * 
	 */
	public String				NAM_MAIN;
	/**
	 * 
	 */
	public String				NAM_AGENT;
	/**
	 * 
	 */
	public String				NAM_START_DATE;
	/**
	 * 
	 */
	public int					LEN_CODE;
	/**
	 * 
	 */
	public int					LEN_NAME;
	
	// \[gL[
	/**
	 * 
	 */
	public final String			KEY_UNIT_CODE		= "keyUnitCode";
	/**
	 * 
	 */
	public final String			KEY_MAIN			= "keyMain";
	/**
	 * 
	 */
	public final String			KEY_AGENT			= "keyAgent";
	/**
	 * 
	 */
	public final String			KEY_START_DATE		= "keyStartDate";
	
	// [h(0FȂA1F)
	private int					searchmode;
	

	/**
	 * RXgN^
	 */
	public ApprovalUnitListVo() {
		super();
		setViewPath(getClassName());
		txtKCode = "";
		txtKName = "";
		txtUnitCode = "";
		aryUnit = new String[0][0];
		setFormerKey(KEY_UNIT_CODE);
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_APPROVAL_UNIT;
		createAryMenu(CMD_MENU_SYSTEM2, MosPMenuConst.getMenuApproval());
	}
	
	@Override
	protected void setFieldsName() {
		NAM_K_CODE = CommonConst.NAM_K_CODE;
		NAM_K_NAME = CommonConst.NAM_K_NAME;
		NAM_UNIT_CODE = CommonConst.NAM_COMMON_CODE;
		NAM_MAIN = CommonConst.NAM_APPROVED + CommonConst.NAM_PERSON;
		NAM_AGENT = CommonConst.NAM_AGENT;
		NAM_START_DATE = CommonConst.NAM_START_DATE;
		LEN_CODE = CommonConst.LEN_K_CODE;
		LEN_NAME = CommonConst.LEN_K_NAME;
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		txtKCode = request.getParameter(PRM_TXT_K_CODE);
		txtKName = request.getParameter(PRM_TXT_K_NAME);
		txtUnitCode = request.getParameter(PRM_TXT_UNIT_CODE);
	}
	
	@Override
	public void setFields(List<?> listUnit) {
		// Xg̐ݒ
		list = listUnit;
		// f[^̎擾
		count = listUnit.size();
		// z̏
		aryUnit = new String[count][5];
		// f[^̐ݒ
		int i = 0;
		Iterator<?> it = listUnit.iterator();
		while (it.hasNext()) {
			AmUnitDto dto = (AmUnitDto)it.next();
			aryUnit[i][0] = escapeHTML(dto.getUnitCode());
			aryUnit[i][1] = escapeHTML(getCodeName(dto.getMain(), aryPltUser));
			aryUnit[i][2] = escapeHTML(getCodeName(dto.getAgent(), aryPltUser));
			aryUnit[i][3] = escapeHTML(DateUtil.convDateToFormatDateJP(dto.getStartDate()));
			aryUnit[i][4] = escapeHTML(DateUtil.convDateFormattedByHyphen(dto.getStartDate()));
			i++;
		}
	}
	
	/**
	 * @return aryUnit
	 */
	public String[][] getAryUnit() {
		return aryUnit.clone();
	}
	
	/**
	 * @return txtKCode
	 */
	public String getTxtKCode() {
		return txtKCode;
	}
	
	/**
	 * @return txtKName
	 */
	public String getTxtKName() {
		return txtKName;
	}
	
	/**
	 * @return txtUnitCode
	 */
	public String getTxtUnitCode() {
		return txtUnitCode;
	}
	
	/**
	 * @return searchmode
	 */
	public int getSearchmode() {
		return searchmode;
	}
	
	/**
	 * @param aryUnit Zbg aryUnit
	 */
	public void setAryUnit(String[][] aryUnit) {
		this.aryUnit = aryUnit.clone();
	}
	
	/**
	 * @param txtKCode Zbg txtKCode
	 */
	public void setTxtKCode(String txtKCode) {
		this.txtKCode = txtKCode;
	}
	
	/**
	 * @param txtKName Zbg txtKName
	 */
	public void setTxtKName(String txtKName) {
		this.txtKName = txtKName;
	}
	
	/**
	 * @param txtUnitCode Zbg txtUnitCode
	 */
	public void setTxtUnitCode(String txtUnitCode) {
		this.txtUnitCode = txtUnitCode;
	}
	
	/**
	 * @param searchmode Zbg searchmode
	 */
	public void setSearchmode(int searchmode) {
		this.searchmode = searchmode;
	}
	
}
