/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.workflow.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.kintai.workflow.dto.AmUnitDto;

/**
 * @author yoshida
 *
 */
public class ApprovalUnitCardVo extends MosPVo {
	
	private static final long	serialVersionUID	= 7639736442031032151L;
	
	// 萔
	/**
	 * 
	 */
	public static final int		MODE_INSERT			= 0;
	/**
	 * 
	 */
	public static final int		MODE_UPDATE			= 1;
	/**
	 * 
	 */
	public static final int		MODE_IMPOSSIBLE		= 2;
	
	// p[^
	/**
	 * 
	 */
	public static final String	PRM_TXT_UNIT_CODE	= "txtUnitCode";
	/**
	 * 
	 */
	public static final String	PRM_PLT_MAIN		= "pltMain";
	/**
	 * 
	 */
	public static final String	PRM_PLT_AGENT		= "pltAgent";
	/**
	 * 
	 */
	public static final String	PRM_PLT_START_YEAR	= "pltStartYear";
	/**
	 * 
	 */
	public static final String	PRM_PLT_START_MONTH	= "pltStartMonth";
	/*						
	 *  	2008/11/04	m.yoshida	C
	 */
	/**
	 * 
	 */
	public static final String	PRM_PLT_START_DAY	= "pltStartDay";
	/**
	 * 
	 */
	public static final String	PRM_PLT_DELETE		= "pltDelete";
	
	// tB[h
	private String				txtUnitCode;
	private String				pltMain;
	private String				pltAgent;
	private String				pltStartYear;
	private String				pltStartMonth;
	/*						
	 *  	2008/11/04	m.yoshida	C
	 */
	private String				pltStartDay;
	private String				pltDelete;
	
	// v_EXg
	/**
	 * 
	 */
	public String[][]			aryPltManager;
	/**
	 * 
	 */
	public String[][]			aryPltYear;
	/**
	 * 
	 */
	public String[][]			aryPltMonth;
	/**
	 * 
	 */
	public String[][]			aryPltDay;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_UNIT_CODE;
	/**
	 * 
	 */
	public String				NAM_MAIN;
	/**
	 * 
	 */
	public String				NAM_AGENT;
	/**
	 * 
	 */
	public String				NAM_START_DATE;
	/**
	 * 
	 */
	public String				NAM_DELETE;
	/**
	 * 
	 */
	public int					LEN_CODE;
	/**
	 * 
	 */
	public String				REG_DELETE;
	
	// [h
	private int					mode;
	

	/**
	 * RXgN^
	 */
	public ApprovalUnitCardVo() {
		super();
		mode = MODE_INSERT;
		setViewPath(getClassName());
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_APPROVAL_UNIT;
		createAryMenu(CMD_MENU_SYSTEM2, MosPMenuConst.getMenuApproval());
	}
	
	@Override
	protected void setFieldsName() {
		NAM_UNIT_CODE = CommonConst.NAM_APPROVAL_UNIT + CommonConst.NAM_COMMON_CODE;
		NAM_MAIN = CommonConst.NAM_APPROVED + CommonConst.NAM_PERSON;
		NAM_AGENT = CommonConst.NAM_AGENT;
		NAM_START_DATE = CommonConst.NAM_START_DATE;
		NAM_DELETE = CommonConst.NAM_DELETE_FLAG;
		LEN_CODE = 10;
		REG_DELETE = CommonConst.REG_DELETE;
	}
	
	/**
	 * lݒ
	 */
	public void setDefaultValues() {
		setTxtUnitCode("");
		setPltMain("");
		setPltAgent("");
		setPltStartYear("");
		setPltStartMonth("");
		/*						
		 *  	2008/11/04	m.yoshida	C
		 */
		setPltStartDay("");
		setPltDelete(String.valueOf(MospConst.DELETE_FLAG_OFF));
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		txtUnitCode = request.getParameter(PRM_TXT_UNIT_CODE);
		pltMain = request.getParameter(PRM_PLT_MAIN);
		pltAgent = request.getParameter(PRM_PLT_AGENT);
		pltStartYear = request.getParameter(PRM_PLT_START_YEAR);
		pltStartMonth = request.getParameter(PRM_PLT_START_MONTH);
		/*						
		 *  	2008/11/04	m.yoshida	C
		 */
		pltStartDay = request.getParameter(PRM_PLT_START_DAY);
		pltDelete = request.getParameter(PRM_PLT_DELETE);
	}
	
	/**
	 * tB[hݒ
	 * @param dto ΏDTO
	 */
	public void setFields(AmUnitDto dto) {
		txtUnitCode = dto.getUnitCode();
		pltMain = dto.getMain();
		pltAgent = dto.getAgent();
		pltStartYear = String.valueOf(MospUtility.getYear(dto.getStartDate()));
		pltStartMonth = String.valueOf(MospUtility.getMonth(dto.getStartDate()));
		/*						
		 *  	2008/11/04	m.yoshida	C
		 */
		pltStartDay = String.valueOf(MospUtility.getDay(dto.getStartDate()));
		pltDelete = String.valueOf(dto.getDeleteFlag());
	}
	
	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFields(AmUnitDto dto) {
		dto.setUnitCode(txtUnitCode);
		dto.setMain(pltMain);
		dto.setAgent(pltAgent);
		/*						
		 *  	2008/11/04	m.yoshida	C
		 */
		dto.setStartDate(DateUtil.getDate(pltStartYear, pltStartMonth, pltStartDay));
		dto.setDeleteFlag(Integer.parseInt(pltDelete));
	}
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException	MosPOꍇ
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(txtUnitCode, NAM_UNIT_CODE, PRM_TXT_UNIT_CODE);
		// 񒷊mF
		checkLength(txtUnitCode, LEN_CODE, NAM_UNIT_CODE, PRM_TXT_UNIT_CODE);
		// dmF
		checkCompare(pltMain, pltAgent, 1, NAM_AGENT, PRM_PLT_MAIN, PRM_PLT_AGENT);
		// tmF
		/*						
		 *  	2008/11/04	m.yoshida	C
		 */
		checkDate(getIntParam(pltStartYear), getIntParam(pltStartMonth), getIntParam(pltStartDay), NAM_START_DATE,
				PRM_PLT_START_YEAR);
		// ÓmFI
		endValidation();
	}
	
	@Override
	public String getDirectJs(Class<?> cls, Object obj) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls, obj));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}
	
	// ANZT\bh
	/**
	 * @return txtUnitCode
	 */
	public String getEscTxtUnitCode() {
		return escapeHTML(txtUnitCode);
	}
	
	/**
	 * @return pltStartDay
	 */
	public String getEscPltStartDay() {
		return escapeHTML(pltStartDay);
	}
	
	/**
	 * @return txtUnitCode
	 */
	public String getTxtUnitCode() {
		return txtUnitCode;
	}
	
	/**
	 * @return pltMain
	 */
	public String getPltMain() {
		return pltMain;
	}
	
	/**
	 * @return pltAgent
	 */
	public String getPltAgent() {
		return pltAgent;
	}
	
	/**
	 * @return pltStartYear
	 */
	public String getPltStartYear() {
		return pltStartYear;
	}
	
	/**
	 * @return pltStartMonth
	 */
	public String getPltStartMonth() {
		return pltStartMonth;
	}
	
	/**
	 * @return pltStartDay
	 */
	public String getPltStartDay() {
		return pltStartDay;
	}
	
	/**
	 * @return pltDelete
	 */
	public String getPltDelete() {
		return pltDelete;
	}
	
	/**
	 * @return mode
	 */
	public int getMode() {
		return mode;
	}
	
	/**
	 * @param txtUnitCode Zbg txtUnitCode
	 */
	public void setTxtUnitCode(String txtUnitCode) {
		this.txtUnitCode = txtUnitCode;
	}
	
	/**
	 * @param pltMain Zbg pltMain
	 */
	public void setPltMain(String pltMain) {
		this.pltMain = pltMain;
	}
	
	/**
	 * @param pltAgent Zbg pltAgent
	 */
	public void setPltAgent(String pltAgent) {
		this.pltAgent = pltAgent;
	}
	
	/**
	 * @param pltStartYear Zbg pltStartYear
	 */
	public void setPltStartYear(String pltStartYear) {
		this.pltStartYear = pltStartYear;
	}
	
	/**
	 * @param pltStartMonth Zbg pltStartMonth
	 */
	public void setPltStartMonth(String pltStartMonth) {
		this.pltStartMonth = pltStartMonth;
	}
	
	/**
	 * @param pltStartDay Zbg pltStartDay
	 */
	public void setPltStartDay(String pltStartDay) {
		this.pltStartDay = pltStartDay;
	}
	
	/**
	 * @param pltDelete Zbg pltDelete
	 */
	public void setPltDelete(String pltDelete) {
		this.pltDelete = pltDelete;
	}
	
	/**
	 * @param mode Zbg mode
	 */
	public void setMode(int mode) {
		this.mode = mode;
	}
	
}
