/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.workflow.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospException;
import jp.mosp.common.utils.TimeUtil;
import jp.mosp.kintai.common.part.KintaiCommonPart;
import jp.mosp.kintai.kintai.dto.MSyukkinboDto;

/**
 * @author yoshida
 *
 */
public class ApprovalCardVo extends MosPVo {
	
	private static final long	serialVersionUID	= -2426894958983879071L;
	
	// 萔
	/**
	 * 0
	 */
	public static final int		MODE_VIEW			= 0;
	/**
	 * 1
	 */
	public static final int		MODE_APPROVAL		= 1;
	
	// p[^
	/**
	 * txtComment
	 */
	public static final String	PRM_TXT_COMMENT		= "txtComment";
	/**
	 * pltYear
	 */
	public static final String	PRM_PLT_YEAR		= "pltYear";
	/**
	 * pltMonth
	 */
	public static final String	PRM_PLT_MONTH		= "pltMonth";
	
	// tB[h
	private String				hidKCode;
	private String				hidDate;
	private String				pltYear;
	private String				pltMonth;
	
	private String				lblDate;
	private String				lblStartQuitTime;
	private String				lblWorkType;
	private String				lblWorkOnHoliday;
	private String				lblLateTime;
	private String				lblLateReason;
	private String				lblLateCertificate;
	private String				lblLateComment;
	private String				lblWorkTime;
	private String				lblBreakTime;
	private String				lblActualTime;
	private String				lblLeaveEarlyTime;
	private String				lblLeaveEarlyReason;
	private String				lblLeaveEarlyCertificate;
	private String				lblLeaveEarlyComment;
	private String				lblOverTime;
	private String				lblWorkOnHolidayTime;
	private String				lblLateNightTime;
	private String				lblSyokuji;
	private String				lblCyoku1;
	private String				lblCyoku2;
	private String				lblCyoku3;
	private String				lblHoka1;
	private String				lblHoka2;
	private String				lblHoka3;
	private String				lblHoka4;
	private String				lblHoka5;
	private String				lblStatus;
	private String				txtComment;
	private String				lblHalfHoliday;
	private String				lblOverTimeRequest;
	private String[]			aryLblHolidayRequest;
	
	// ҏW[h(0F\A1FF)
	private int					mode;
	
	private boolean				isCaution;
	private boolean				isWarning;
	
	// 蓖
	private String[][]			aryAllowance;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_START_TIME;
	/**
	 * 
	 */
	public String				NAM_WORKING_TYPE;
	/**
	 * 
	 */
	public String				NAM_WORK_ON_HOLIDAY;
	/**
	 * 
	 */
	public String				NAM_LATE_TIME;
	/**
	 * 
	 */
	public String				NAM_LATE_REASON;
	/**
	 * 
	 */
	public String				NAM_LATE_CERTIFICATE;
	/**
	 * 
	 */
	public String				NAM_LATE_COMMENT;
	/**
	 * 
	 */
	public String				NAM_QUIT_TIME;
	/**
	 * 
	 */
	public String				NAM_WORKING_TIME;
	/**
	 * 
	 */
	public String				NAM_INTERVAL_TIME;
	/**
	 * 
	 */
	public String				NAM_ACTUAL_WORK_TIME;
	/**
	 * 
	 */
	public String				NAM_LEAVE_EARLY_REASON;
	/**
	 * 
	 */
	public String				NAM_LEAVE_EARLY_TIME;
	/**
	 * 
	 */
	public String				NAM_LEAVE_EARLY_CERTIFICATE;
	/**
	 * 
	 */
	public String				NAM_LEAVE_EARLY_COMMENT;
	/**
	 * 
	 */
	public String				NAM_OVER_TIME;
	/**
	 * 
	 */
	public String				NAM_WORK_ON_HOLIDAY_TIME;
	/**
	 * 
	 */
	public String				NAM_LATE_NIGHT;
	/**
	 * 
	 */
	public String				NAM_ALLOWANCE;
	/**
	 * 
	 */
	public String				NAM_STATUS;
	/**
	 * 
	 */
	public String				NAM_COMMENT;
	/**
	 * 
	 */
	public int					LEN_COMMENT;
	/**
	 * 
	 */
	public String				NAM_HALF_HOLIDAY;
	/**
	 * 
	 */
	public String				NAM_OVER_TIME_REQUEST;
	/**
	 * 
	 */
	public String				NAM_HOLIDAY_REQUEST;
	

	/**
	 * RXgN^
	 */
	public ApprovalCardVo() {
		super();
		setViewPath(getClassName());
		mode = MODE_VIEW;
		aryAllowance = new String[0][0];
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.NAM_CHECK_APPROVAL;
		createAryMenu(CMD_MENU_MAMAGE, "K2122", CommonConst.TTL_APPROVAL_LIST);
	}
	
	@Override
	protected void setFieldsName() {
		NAM_START_TIME = CommonConst.NAM_START_TIME + CommonConst.NAM_TIME;
		NAM_WORKING_TYPE = CommonConst.NAM_WORKING_TYPE;
		NAM_WORK_ON_HOLIDAY = CommonConst.NAM_WORK_ON_HOLIDAY + CommonConst.NAM_COMMON_TYPE;
		NAM_LATE_TIME = CommonConst.NAM_ARRIVE_LATE + CommonConst.NAM_COMMON_TIME;
		NAM_LATE_REASON = CommonConst.NAM_ARRIVE_LATE + CommonConst.NAM_REASON;
		NAM_LATE_CERTIFICATE = CommonConst.NAM_CERTIFICATE;
		NAM_LATE_COMMENT = CommonConst.NAM_COMMENT;
		NAM_QUIT_TIME = CommonConst.NAM_QUIT_TIME + CommonConst.NAM_TIME;
		NAM_WORKING_TIME = CommonConst.NAM_WORKING + CommonConst.NAM_COMMON_TIME;
		NAM_INTERVAL_TIME = CommonConst.NAM_INTERVAL_TIME + CommonConst.NAM_COMMON_TIME;
		NAM_ACTUAL_WORK_TIME = CommonConst.NAM_ACTUAL_WORK_TIME + CommonConst.NAM_COMMON_TIME;
		NAM_LEAVE_EARLY_REASON = CommonConst.NAM_LEAVE_EARLY + CommonConst.NAM_REASON;
		NAM_LEAVE_EARLY_TIME = CommonConst.NAM_LEAVE_EARLY + CommonConst.NAM_COMMON_TIME;
		NAM_LEAVE_EARLY_CERTIFICATE = CommonConst.NAM_CERTIFICATE;
		NAM_LEAVE_EARLY_COMMENT = CommonConst.NAM_COMMENT;
		NAM_OVER_TIME = CommonConst.NAM_OVERTIME + CommonConst.NAM_COMMON_TIME;
		NAM_WORK_ON_HOLIDAY_TIME = CommonConst.NAM_WORK_ON_HOLIDAY + CommonConst.NAM_COMMON_TIME;
		NAM_LATE_NIGHT = CommonConst.NAM_LATE_NIGHT + CommonConst.NAM_COMMON_TIME;
		NAM_ALLOWANCE = CommonConst.NAM_ALLOWANCE;
		NAM_STATUS = CommonConst.NAM_APPROVAL_STATE;
		NAM_COMMENT = CommonConst.NAM_APPROVED + CommonConst.NAM_COMMENT;
		LEN_COMMENT = CommonConst.LEN_COMMENT;
		NAM_HALF_HOLIDAY = CommonConst.NAM_VACATION_LEAVE_HALF + CommonConst.NAM_COMMON_TYPE;
		NAM_OVER_TIME_REQUEST = CommonConst.NAM_OVER_TIME_REQUEST;
		NAM_HOLIDAY_REQUEST = CommonConst.NAM_HOLIDAY_REQUEST;
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		pltYear = request.getParameter(PRM_PLT_YEAR);
		pltMonth = request.getParameter(PRM_PLT_MONTH);
		txtComment = request.getParameter(PRM_TXT_COMMENT);
	}
	
	/**
	 * tB[hݒ
	 */
	public void setDefaultValues() {
		hidKCode = "";
		hidDate = "";
		lblDate = "";
		lblStartQuitTime = "";
		lblWorkType = "";
		lblWorkOnHoliday = "";
		lblLateTime = "";
		lblLateReason = "";
		lblLateCertificate = "";
		lblLateComment = "";
		lblWorkTime = "";
		lblBreakTime = "";
		lblLeaveEarlyReason = "";
		lblLeaveEarlyTime = "";
		lblLeaveEarlyCertificate = "";
		lblLeaveEarlyComment = "";
		lblOverTime = "";
		lblWorkOnHolidayTime = "";
		lblLateNightTime = "";
		lblSyokuji = "";
		lblCyoku1 = "";
		lblCyoku2 = "";
		lblCyoku3 = "";
		lblHoka1 = "";
		lblHoka2 = "";
		lblHoka3 = "";
		lblHoka4 = "";
		lblHoka5 = "";
		lblActualTime = "";
		lblStatus = "";
		txtComment = "";
	}
	
	/**
	 * tB[hݒ
	 * @param dto	ΏDTO
	 */
	public void setFields(MSyukkinboDto dto) {
		lblStartQuitTime = "";
		int startTime = KintaiCommonPart.getWorkStartTime(dto);
		int quitTime = KintaiCommonPart.getWorkQuitTime(dto);
		if (quitTime - startTime != 0) {
			StringBuffer sb = new StringBuffer();
			sb.append(TimeUtil.convIntegerTimeToStringTime(startTime));
			sb.append(CommonConst.STR_TERM);
			sb.append(TimeUtil.convIntegerTimeToStringTime(quitTime));
			lblStartQuitTime = sb.toString();
		}
		lblWorkType = dto.getKinmu();
		lblWorkOnHoliday = dto.getKyusyuKb();
		lblLateTime = "";
		if (dto.getTiJikan() > 0) {
			lblLateTime = TimeUtil.convIntegerTimeToJPHours(dto.getTiJikan());
		}
		lblLateReason = dto.getTiRiyuu();
		lblLateCertificate = dto.getTiSyoumei();
		lblLateComment = dto.getTiComent();
		lblWorkTime = "";
		if (dto.getKinmuJi() > 0) {
			lblWorkTime = TimeUtil.convIntegerTimeToJPHours(dto.getKinmuJi());
		}
		lblBreakTime = "";
		if (dto.getKyukeiJi() > 0) {
			lblBreakTime = TimeUtil.convIntegerTimeToJPHours(dto.getKyukeiJi());
		}
		lblLeaveEarlyTime = "";
		if (dto.getSoJikan() > 0) {
			lblLeaveEarlyTime = TimeUtil.convIntegerTimeToJPHours(dto.getSoJikan());
		}
		lblLeaveEarlyReason = dto.getSoRiyuu();
		lblLeaveEarlyCertificate = dto.getSoSyoumei();
		lblLeaveEarlyComment = dto.getSoComent();
		lblOverTime = "";
		if (dto.getZaJikan() > 0) {
			lblOverTime = TimeUtil.convIntegerTimeToJPHours(dto.getZaJikan());
		}
		lblWorkOnHolidayTime = "";
		if (dto.getKsJikan() > 0) {
			lblWorkOnHolidayTime = TimeUtil.convIntegerTimeToJPHours(dto.getKsJikan());
		}
		lblLateNightTime = "";
		if (dto.getSnJikan() > 0) {
			lblLateNightTime = TimeUtil.convIntegerTimeToJPHours(dto.getSnJikan());
		}
		lblSyokuji = "";
		if (dto.getSyokuji() > 0) {
			lblSyokuji = String.valueOf(dto.getSyokuji());
		}
		lblCyoku1 = "";
		if (dto.getCyoku1() > 0) {
			lblCyoku1 = String.valueOf(dto.getCyoku1());
		}
		lblCyoku2 = "";
		if (dto.getCyoku2() > 0) {
			lblCyoku2 = String.valueOf(dto.getCyoku2());
		}
		lblCyoku3 = "";
		if (dto.getCyoku3() > 0) {
			lblCyoku3 = String.valueOf(dto.getCyoku3());
		}
		lblHoka1 = "";
		if (dto.getHoka1() > 0) {
			lblHoka1 = String.valueOf(dto.getHoka1());
		}
		lblHoka2 = "";
		if (dto.getHoka2() > 0) {
			lblHoka2 = String.valueOf(dto.getHoka2());
		}
		lblHoka3 = "";
		if (dto.getHoka3() > 0) {
			lblHoka3 = String.valueOf(dto.getHoka3());
		}
		lblHoka4 = "";
		if (dto.getHoka4() > 0) {
			lblHoka4 = String.valueOf(dto.getHoka4());
		}
		lblHoka5 = "";
		if (dto.getHoka5() > 0) {
			lblHoka5 = String.valueOf(dto.getHoka5());
		}
		// Ԃ̃Zbg
		int actual = 0;
		if (dto.getKinmuJi() != 0) {
			//  = Ζ - xeԁicƋxeԊ܂ށj
			actual = dto.getKinmuJi() - dto.getKyukeiJi();
		}
		lblActualTime = "";
		if (actual > 0) {
			lblActualTime = TimeUtil.convIntegerTimeToJPHours(actual);
		}
		lblHalfHoliday = "";
		// x敪
		if (KintaiCommonPart.isStartHalfHoliday(dto)) {
			lblHalfHoliday = CommonConst.NAM_SHORT_START_ATTENDANCE;
			lblHalfHoliday += CommonConst.NAM_VACATION_LEAVE_HALF;
		}
		if (KintaiCommonPart.isQuitHalfHoliday(dto)) {
			lblHalfHoliday += CommonConst.NAM_SHORT_QUIT_ATTENDANCE;
			lblHalfHoliday += CommonConst.NAM_VACATION_LEAVE_HALF;
		}
		txtComment = dto.getSnComent();
	}
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException	MosPOꍇ
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(txtComment, NAM_COMMENT, PRM_TXT_COMMENT);
		// mF	
		checkLength(txtComment, LEN_COMMENT, NAM_COMMENT, PRM_TXT_COMMENT);
		// ÓmFI
		endValidation();
	}
	
	@Override
	public String getDirectJs(Class<?> cls, Object obj) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls, obj));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		sb.append("var CAUTION = ");
		sb.append(isCaution);
		sb.append(";");
		sb.append("var WARNING = ");
		sb.append(isWarning);
		sb.append(";");
		return sb.toString();
	}
	
	/**
	 * @return hidKCode
	 */
	public String getHidKCode() {
		return hidKCode;
	}
	
	/**
	 * @return hidDate
	 */
	public String getHidDate() {
		return hidDate;
	}
	
	/**
	 * @return pltYear
	 */
	public String getPltYear() {
		return pltYear;
	}
	
	/**
	 * @return pltMonth
	 */
	public String getPltMonth() {
		return pltMonth;
	}
	
	/**
	 * @return lblDate
	 */
	public String getLblDate() {
		return lblDate;
	}
	
	/**
	 * @return lblStartQuitTime
	 */
	public String getLblStartQuitTime() {
		return lblStartQuitTime;
	}
	
	/**
	 * @return lblWorkType
	 */
	public String getLblWorkType() {
		return lblWorkType;
	}
	
	/**
	 * @return lblWorkOnHoliday
	 */
	public String getLblWorkOnHoliday() {
		return lblWorkOnHoliday;
	}
	
	/**
	 * @return lblLateTime
	 */
	public String getLblLateTime() {
		return lblLateTime;
	}
	
	/**
	 * @return lblLateReason
	 */
	public String getLblLateReason() {
		return lblLateReason;
	}
	
	/**
	 * @return lblLateCertificate
	 */
	public String getLblLateCertificate() {
		return lblLateCertificate;
	}
	
	/**
	 * @return lblLateComment
	 */
	public String getLblLateComment() {
		return lblLateComment;
	}
	
	/**
	 * @return lblWorkTime
	 */
	public String getLblWorkTime() {
		return lblWorkTime;
	}
	
	/**
	 * @return lblBreakTime
	 */
	public String getLblBreakTime() {
		return lblBreakTime;
	}
	
	/**
	 * @return lblActualTime
	 */
	public String getLblActualTime() {
		return lblActualTime;
	}
	
	/**
	 * @return lblLeaveEarlyTime
	 */
	public String getLblLeaveEarlyTime() {
		return lblLeaveEarlyTime;
	}
	
	/**
	 * @return lblLeaveEarlyReason
	 */
	public String getLblLeaveEarlyReason() {
		return lblLeaveEarlyReason;
	}
	
	/**
	 * @return lblLeaveEarlyCertificate
	 */
	public String getLblLeaveEarlyCertificate() {
		return lblLeaveEarlyCertificate;
	}
	
	/**
	 * @return lblLeaveEarlyComment
	 */
	public String getLblLeaveEarlyComment() {
		return lblLeaveEarlyComment;
	}
	
	/**
	 * @return lblOverTime
	 */
	public String getLblOverTime() {
		return lblOverTime;
	}
	
	/**
	 * @return lblWorkOnHolidayTime
	 */
	public String getLblWorkOnHolidayTime() {
		return lblWorkOnHolidayTime;
	}
	
	/**
	 * @return lblLateNightTime
	 */
	public String getLblLateNightTime() {
		return lblLateNightTime;
	}
	
	/**
	 * @return lblSyokuji
	 */
	public String getLblSyokuji() {
		return lblSyokuji;
	}
	
	/**
	 * @return lblCyoku1
	 */
	public String getLblCyoku1() {
		return lblCyoku1;
	}
	
	/**
	 * @return lblCyoku2
	 */
	public String getLblCyoku2() {
		return lblCyoku2;
	}
	
	/**
	 * @return lblCyoku3
	 */
	public String getLblCyoku3() {
		return lblCyoku3;
	}
	
	/**
	 * @return lblHoka1
	 */
	public String getLblHoka1() {
		return lblHoka1;
	}
	
	/**
	 * @return lblHoka2
	 */
	public String getLblHoka2() {
		return lblHoka2;
	}
	
	/**
	 * @return lblHoka3
	 */
	public String getLblHoka3() {
		return lblHoka3;
	}
	
	/**
	 * @return lblHoka4
	 */
	public String getLblHoka4() {
		return lblHoka4;
	}
	
	/**
	 * @return lblHoka5
	 */
	public String getLblHoka5() {
		return lblHoka5;
	}
	
	/**
	 * @return lblStatus
	 */
	public String getLblStatus() {
		return lblStatus;
	}
	
	/**
	 * @return txtComment
	 */
	public String getTxtComment() {
		return txtComment;
	}
	
	/**
	 * @return lblHalfHoliday
	 */
	public String getLblHalfHoliday() {
		return lblHalfHoliday;
	}
	
	/**
	 * @return lblOverTimeRequest
	 */
	public String getLblOverTimeRequest() {
		return lblOverTimeRequest;
	}
	
	/**
	 * @return aryLblHolidayRequest
	 */
	public String[] getAryLblHolidayRequest() {
		return aryLblHolidayRequest.clone();
	}
	
	/**
	 * @return mode
	 */
	public int getMode() {
		return mode;
	}
	
	/**
	 * @return isCaution
	 */
	public boolean isCaution() {
		return isCaution;
	}
	
	/**
	 * @return isWarning
	 */
	public boolean isWarning() {
		return isWarning;
	}
	
	/**
	 * @return aryAllowance
	 */
	public String[][] getAryAllowance() {
		return aryAllowance.clone();
	}
	
	/**
	 * @param hidKCode Zbg hidKCode
	 */
	public void setHidKCode(String hidKCode) {
		this.hidKCode = hidKCode;
	}
	
	/**
	 * @param hidDate Zbg hidDate
	 */
	public void setHidDate(String hidDate) {
		this.hidDate = hidDate;
	}
	
	/**
	 * @param pltYear Zbg pltYear
	 */
	public void setPltYear(String pltYear) {
		this.pltYear = pltYear;
	}
	
	/**
	 * @param pltMonth Zbg pltMonth
	 */
	public void setPltMonth(String pltMonth) {
		this.pltMonth = pltMonth;
	}
	
	/**
	 * @param lblDate Zbg lblDate
	 */
	public void setLblDate(String lblDate) {
		this.lblDate = lblDate;
	}
	
	/**
	 * @param lblStartQuitTime Zbg lblStartQuitTime
	 */
	public void setLblStartQuitTime(String lblStartQuitTime) {
		this.lblStartQuitTime = lblStartQuitTime;
	}
	
	/**
	 * @param lblWorkType Zbg lblWorkType
	 */
	public void setLblWorkType(String lblWorkType) {
		this.lblWorkType = lblWorkType;
	}
	
	/**
	 * @param lblWorkOnHoliday Zbg lblWorkOnHoliday
	 */
	public void setLblWorkOnHoliday(String lblWorkOnHoliday) {
		this.lblWorkOnHoliday = lblWorkOnHoliday;
	}
	
	/**
	 * @param lblLateTime Zbg lblLateTime
	 */
	public void setLblLateTime(String lblLateTime) {
		this.lblLateTime = lblLateTime;
	}
	
	/**
	 * @param lblLateReason Zbg lblLateReason
	 */
	public void setLblLateReason(String lblLateReason) {
		this.lblLateReason = lblLateReason;
	}
	
	/**
	 * @param lblLateCertificate Zbg lblLateCertificate
	 */
	public void setLblLateCertificate(String lblLateCertificate) {
		this.lblLateCertificate = lblLateCertificate;
	}
	
	/**
	 * @param lblLateComment Zbg lblLateComment
	 */
	public void setLblLateComment(String lblLateComment) {
		this.lblLateComment = lblLateComment;
	}
	
	/**
	 * @param lblWorkTime Zbg lblWorkTime
	 */
	public void setLblWorkTime(String lblWorkTime) {
		this.lblWorkTime = lblWorkTime;
	}
	
	/**
	 * @param lblBreakTime Zbg lblBreakTime
	 */
	public void setLblBreakTime(String lblBreakTime) {
		this.lblBreakTime = lblBreakTime;
	}
	
	/**
	 * @param lblActualTime Zbg lblActualTime
	 */
	public void setLblActualTime(String lblActualTime) {
		this.lblActualTime = lblActualTime;
	}
	
	/**
	 * @param lblLeaveEarlyTime Zbg lblLeaveEarlyTime
	 */
	public void setLblLeaveEarlyTime(String lblLeaveEarlyTime) {
		this.lblLeaveEarlyTime = lblLeaveEarlyTime;
	}
	
	/**
	 * @param lblLeaveEarlyReason Zbg lblLeaveEarlyReason
	 */
	public void setLblLeaveEarlyReason(String lblLeaveEarlyReason) {
		this.lblLeaveEarlyReason = lblLeaveEarlyReason;
	}
	
	/**
	 * @param lblLeaveEarlyCertificate Zbg lblLeaveEarlyCertificate
	 */
	public void setLblLeaveEarlyCertificate(String lblLeaveEarlyCertificate) {
		this.lblLeaveEarlyCertificate = lblLeaveEarlyCertificate;
	}
	
	/**
	 * @param lblLeaveEarlyComment Zbg lblLeaveEarlyComment
	 */
	public void setLblLeaveEarlyComment(String lblLeaveEarlyComment) {
		this.lblLeaveEarlyComment = lblLeaveEarlyComment;
	}
	
	/**
	 * @param lblOverTime Zbg lblOverTime
	 */
	public void setLblOverTime(String lblOverTime) {
		this.lblOverTime = lblOverTime;
	}
	
	/**
	 * @param lblWorkOnHolidayTime Zbg lblWorkOnHolidayTime
	 */
	public void setLblWorkOnHolidayTime(String lblWorkOnHolidayTime) {
		this.lblWorkOnHolidayTime = lblWorkOnHolidayTime;
	}
	
	/**
	 * @param lblLateNightTime Zbg lblLateNightTime
	 */
	public void setLblLateNightTime(String lblLateNightTime) {
		this.lblLateNightTime = lblLateNightTime;
	}
	
	/**
	 * @param lblSyokuji Zbg lblSyokuji
	 */
	public void setLblSyokuji(String lblSyokuji) {
		this.lblSyokuji = lblSyokuji;
	}
	
	/**
	 * @param lblCyoku1 Zbg lblCyoku1
	 */
	public void setLblCyoku1(String lblCyoku1) {
		this.lblCyoku1 = lblCyoku1;
	}
	
	/**
	 * @param lblCyoku2 Zbg lblCyoku2
	 */
	public void setLblCyoku2(String lblCyoku2) {
		this.lblCyoku2 = lblCyoku2;
	}
	
	/**
	 * @param lblCyoku3 Zbg lblCyoku3
	 */
	public void setLblCyoku3(String lblCyoku3) {
		this.lblCyoku3 = lblCyoku3;
	}
	
	/**
	 * @param lblHoka1 Zbg lblHoka1
	 */
	public void setLblHoka1(String lblHoka1) {
		this.lblHoka1 = lblHoka1;
	}
	
	/**
	 * @param lblHoka2 Zbg lblHoka2
	 */
	public void setLblHoka2(String lblHoka2) {
		this.lblHoka2 = lblHoka2;
	}
	
	/**
	 * @param lblHoka3 Zbg lblHoka3
	 */
	public void setLblHoka3(String lblHoka3) {
		this.lblHoka3 = lblHoka3;
	}
	
	/**
	 * @param lblHoka4 Zbg lblHoka4
	 */
	public void setLblHoka4(String lblHoka4) {
		this.lblHoka4 = lblHoka4;
	}
	
	/**
	 * @param lblHoka5 Zbg lblHoka5
	 */
	public void setLblHoka5(String lblHoka5) {
		this.lblHoka5 = lblHoka5;
	}
	
	/**
	 * @param lblStatus Zbg lblStatus
	 */
	public void setLblStatus(String lblStatus) {
		this.lblStatus = lblStatus;
	}
	
	/**
	 * @param txtComment Zbg txtComment
	 */
	public void setTxtComment(String txtComment) {
		this.txtComment = txtComment;
	}
	
	/**
	 * @param lblHalfHoliday Zbg lblHalfHoliday
	 */
	public void setLblHalfHoliday(String lblHalfHoliday) {
		this.lblHalfHoliday = lblHalfHoliday;
	}
	
	/**
	 * @param lblOverTimeRequest Zbg lblOverTimeRequest
	 */
	public void setLblOverTimeRequest(String lblOverTimeRequest) {
		this.lblOverTimeRequest = lblOverTimeRequest;
	}
	
	/**
	 * @param aryLblHolidayRequest Zbg aryLblHolidayRequest
	 */
	public void setAryLblHolidayRequest(String[] aryLblHolidayRequest) {
		this.aryLblHolidayRequest = aryLblHolidayRequest.clone();
	}
	
	/**
	 * @param mode Zbg mode
	 */
	public void setMode(int mode) {
		this.mode = mode;
	}
	
	/**
	 * @param isCaution Zbg isCaution
	 */
	public void setCaution(boolean isCaution) {
		this.isCaution = isCaution;
	}
	
	/**
	 * @param isWarning Zbg isWarning
	 */
	public void setWarning(boolean isWarning) {
		this.isWarning = isWarning;
	}
	
	/**
	 * @param aryAllowance Zbg aryAllowance
	 */
	public void setAryAllowance(String[][] aryAllowance) {
		this.aryAllowance = aryAllowance.clone();
	}
	
}
