/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.workflow.dto;

import java.util.Date;

import jp.mosp.common.common.BaseDto;

/**
 * AM_UNIT(Fjbg}X^)DTONXB
 */
public class AmUnitDto extends BaseDto {
	
	private static final long	serialVersionUID	= 79335992285203353L;
	
	// tB[h
	private String				unitcode			= "";					//jbgR[h
	private Date				startdate			= null;				//Jn
	private String				main				= "";					//F
	private String				agent				= "";					//㗝
	private int					deleteflag			= 0;					//폜tO
																			
	
	/**
	 * RXgN^
	 */
	public AmUnitDto() {
		super();
	}
	
	// ANZT\bh
	/**
	 * @return unitcode 	jbgR[hB
	 */
	public String getUnitCode() {
		return unitcode;
	}
	
	/**
	 * @return startdate 	JnB
	 */
	public Date getStartDate() {
		return (Date)startdate.clone();
	}
	
	/**
	 * @return main 	FҁB
	 */
	public String getMain() {
		return main;
	}
	
	/**
	 * @return agent 	㗝B
	 */
	public String getAgent() {
		return agent;
	}
	
	/**
	 * @return deleteflag 	폜tOB
	 */
	public int getDeleteFlag() {
		return deleteflag;
	}
	
	/**
	 * @param unitcode 	Zbg郆jbgR[hB
	 */
	public void setUnitCode(String unitcode) {
		this.unitcode = unitcode;
	}
	
	/**
	 * @param startdate 	Zbg錠JnB
	 */
	public void setStartDate(Date startdate) {
		this.startdate = (Date)startdate.clone();
	}
	
	/**
	 * @param main 	Zbg鏳FҁB
	 */
	public void setMain(String main) {
		this.main = main;
	}
	
	/**
	 * @param agent 	Zbg㗝B
	 */
	public void setAgent(String agent) {
		this.agent = agent;
	}
	
	/**
	 * @param deleteflag 	Zbg폜tOB
	 */
	public void setDeleteFlag(int deleteflag) {
		this.deleteflag = deleteflag;
	}
	
}
