/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.workflow.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dao.MosPDao;
import jp.mosp.kintai.common.dao.MKihonDao;
import jp.mosp.kintai.workflow.dto.AmUnitDto;

/**
 * AM_UNIT(Fjbg}X^)DAONX B
 */
public class AmUnitDao extends BaseDao {
	
	// e[uyуL[
	/**
	 * AM_UNIT(Fjbg}X^)B
	 */
	public static final String	TABLE			= "AM_UNIT";
	
	/**
	 * KEY_1 = UNITCODE(jbgR[h)B
	 */
	public static final String	KEY_1			= "UNITCODE";
	/**
	 * KEY_2 = STARTDATE(Jn)B
	 */
	public static final String	KEY_2			= "STARTDATE";
	
	// 
	/**
	 * UNITCODE(jbgR[h)B
	 */
	public static final String	COL_UNITCODE	= "UNITCODE";
	/**
	 * STARTDATE(Jn)B
	 */
	public static final String	COL_STARTDATE	= "STARTDATE";
	/**
	 * MAIN(F)B
	 */
	public static final String	COL_MAIN		= "MAIN";
	/**
	 * AGENT(㗝)B
	 */
	public static final String	COL_AGENT		= "AGENT";
	/**
	 * DELETEFLAG(폜tO)B
	 */
	public static final String	COL_DELETEFLAG	= "DELETEFLAG";
	
	/**
	 * TMP_UNIT
	 */
	public static final String	TMP_UNIT_TABLE	= "TMP_UNIT";	//z̃e[u
																
	
	/**
	 * RXgN^
	 */
	public AmUnitDao() {
		super();
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException SQLOꍇ
	 */
	private List<AmUnitDto> mappingAll() throws SQLException {
		List<AmUnitDto> all = new ArrayList<AmUnitDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return AmUnitDto am_unitR[h
	 * @throws SQLException SQLOꍇ
	 */
	private AmUnitDto mapping() throws SQLException {
		AmUnitDto dto = new AmUnitDto();
		dto.setUnitCode(rs.getString(COL_UNITCODE)); //jbgR[h
		dto.setStartDate(rs.getDate(COL_STARTDATE)); //Jn
		dto.setMain(rs.getString(COL_MAIN)); //F
		dto.setAgent(rs.getString(COL_AGENT)); //㗝
		dto.setDeleteFlag(rs.getInt(COL_DELETEFLAG)); //폜tO
		return dto;
	}
	
	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public List<AmUnitDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List<AmUnitDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾
	 * @param unitcode jbgR[h(L[)
	 * @param startdate Jn(L[)
	 * @return AmUnitDto (DTO)
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public AmUnitDto findForKey(String unitcode, String startdate) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, unitcode);
			setParam(index++, java.sql.Date.valueOf(startdate));
			executeQuery();
			AmUnitDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾B
	 * @param unitcode jbgR[h
	 * @param startdate Jn
	 * @return (DTO)
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public AmUnitDto findForKey(String unitcode, Date startdate) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, unitcode);
			setParam(index++, startdate);
			executeQuery();
			AmUnitDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾
	 * @param unitcode jbgR[h(L[)
	 * @param startdate Jn(L[)
	 * @return AmUnitDto (DTO)
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public AmUnitDto findForUpdate(String unitcode, String startdate) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, unitcode);
			setParam(index++, java.sql.Date.valueOf(startdate));
			executeQuery();
			AmUnitDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾B
	 * @param unitcode jbgR[h
	 * @param startdate Jn
	 * @return (DTO)
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public AmUnitDto findForUpdate(String unitcode, Date startdate) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, unitcode);
			setParam(index++, startdate);
			executeQuery();
			AmUnitDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param unitcode jbgR[h
	 * @param startdate Jn
	 * @return List (DTOList)
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public List<AmUnitDto> findForCondition(String unitcode, String startdate) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_UNITCODE);
		sb.append(" LIKE ? AND ");
		sb.append(COL_STARTDATE);
		sb.append(" LIKE ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, unitcode);
			setParam(index++, startdate + "%");
			executeQuery();
			List<AmUnitDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param unitCode jbgR[h
	 * @param kCode ЈR[h
	 * @param kName Ј
	 * @return List (DTOList)
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public List<AmUnitDto> findForCondition(String unitCode, String kCode, String kName) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_DELETEFLAG);
		sb.append(" = " + CommonConst.DEFAULT_FLAG_OFF);
		sb.append(" AND ");
		sb.append(COL_UNITCODE);
		sb.append(" LIKE ? ");
		if (!kCode.equals("")) {
			sb.append(" AND ");
			sb.append(" ( ");
			sb.append(COL_MAIN + " IN (" + MKihonDao.getSearchKCodeSubQuery() + ") ");
			sb.append(" OR ");
			sb.append(COL_AGENT + " IN (" + MKihonDao.getSearchKCodeSubQuery() + ") ");
			sb.append(" ) ");
		}
		if (!kName.equals("")) {
			sb.append(" AND ");
			sb.append(" ( ");
			sb.append(COL_MAIN + " IN (" + MKihonDao.getSearchKNameSubQuery() + ") ");
			sb.append(" OR ");
			sb.append(COL_AGENT + " IN (" + MKihonDao.getSearchKNameSubQuery() + ") ");
			sb.append(" ) ");
		}
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, unitCode + "%");
			if (!kCode.equals("")) {
				setParam(index++, kCode + "%");
				setParam(index++, kCode + "%");
			}
			if (!kName.equals("")) {
				setParam(index++, "%" + kName + "%");
				setParam(index++, "%" + kName + "%");
			}
			executeQuery();
			List<AmUnitDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * I\jbgR[hꗗ擾
	 * @param startDate  Jn
	 * @return list (DTOList)
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public List<AmUnitDto> findForSelectableUnitArray(String startDate) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_DELETEFLAG);
		sb.append(" = " + CommonConst.DEFAULT_FLAG_OFF);
		sb.append(" AND ");
		sb.append(COL_STARTDATE + " = (" + getSearchUnitCodeSubQueryDescLimit() + " ) ");
		sb.append(" OR ");
		sb.append(COL_STARTDATE);
		sb.append(" > ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, java.sql.Date.valueOf(startDate));
			setParam(index++, java.sql.Date.valueOf(startDate));
			executeQuery();
			List<AmUnitDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * wJnɂ郆jbgR[hꗗ擾
	 * @param startDate  Jn
	 * @return List (DTOList)
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public List<AmUnitDto> findForCurrentUnitArray(String startDate) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_DELETEFLAG);
		sb.append(" = " + CommonConst.DEFAULT_FLAG_OFF);
		sb.append(" AND ");
		sb.append(COL_STARTDATE + " = (" + getSearchUnitCodeSubQueryDescLimit() + " ) ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, java.sql.Date.valueOf(startDate));
			executeQuery();
			List<AmUnitDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param kCode			ЈR[h
	 * @param startDate		Jn
	 * @return	list		(DTOList)
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public List<AmUnitDto> findForUnitArray(String kCode, String startDate) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_DELETEFLAG);
		sb.append(" = " + CommonConst.DEFAULT_FLAG_OFF);
		sb.append(" AND ");
		sb.append(" ( ");
		sb.append(COL_MAIN + " IN (" + MKihonDao.getSearchKCodeEqualSubQuery() + ") ");
		sb.append(" OR ");
		sb.append(COL_AGENT + " IN (" + MKihonDao.getSearchKCodeEqualSubQuery() + ") ");
		sb.append(" ) ");
		sb.append(" AND ");
		sb.append(COL_STARTDATE + " = (" + getSearchUnitCodeSubQueryDescLimit() + " ) ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, kCode);
			setParam(index++, kCode);
			setParam(index++, startDate);
			executeQuery();
			List<AmUnitDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * wJnɂ郆jbgR[h擾
	 * @param unitcode jbgR[h
	 * @param startDate  Jn
	 * @return DTO (DTO)
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public AmUnitDto findForCurrentUnit(String unitcode, String startDate) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_DELETEFLAG);
		sb.append(" = " + CommonConst.DEFAULT_FLAG_OFF);
		sb.append(" AND ");
		sb.append(COL_UNITCODE);
		sb.append(" = ? ");
		sb.append(" AND ");
		sb.append(COL_STARTDATE + " = (" + getSearchUnitCodeSubQueryDescLimit() + " ) ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, unitcode);
			setParam(index++, startDate);
			executeQuery();
			AmUnitDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * wJnɂ郆jbgR[h擾
	 * @param unitcode jbgR[h
	 * @param kCode ЈR[h
	 * @param startDate  Jn
	 * @return DTO (DTO)
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public AmUnitDto findForCurrentUnit(String unitcode, String kCode, String startDate) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_DELETEFLAG);
		sb.append(" = " + CommonConst.DEFAULT_FLAG_OFF);
		sb.append(" AND ");
		sb.append(COL_UNITCODE);
		sb.append(" = ? ");
		sb.append(" AND ");
		sb.append(" ( ");
		sb.append(COL_MAIN + " IN (" + MKihonDao.getSearchKCodeEqualSubQuery() + ") ");
		sb.append(" OR ");
		sb.append(COL_AGENT + " IN (" + MKihonDao.getSearchKCodeEqualSubQuery() + ") ");
		sb.append(" ) ");
		sb.append(" AND ");
		sb.append(COL_STARTDATE + " = (" + getSearchUnitCodeSubQueryDescLimit() + " ) ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, unitcode);
			setParam(index++, kCode);
			setParam(index++, kCode);
			setParam(index++, java.sql.Date.valueOf(startDate));
			executeQuery();
			AmUnitDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int insert(AmUnitDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int update(AmUnitDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getUnitCode());
			setParam(index++, dto.getStartDate());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int delete(AmUnitDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getUnitCode());
			setParam(index++, dto.getStartDate());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @param isInsert  }tO(trueF}AfalseFXV)
	 * @throws SQLException SQLOꍇ
	 */
	private void setParams(AmUnitDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getUnitCode()); //jbgR[h
		setParam(index++, dto.getStartDate()); //Jn
		setParam(index++, dto.getMain()); //F
		setParam(index++, dto.getAgent()); //㗝
		setParam(index++, dto.getDeleteFlag()); //폜tO
		setCommonParams(isInsert);
	}
	
	/**
	 * ЈR[hpTuNG[
	 * @return		sb	TuNG
	 */
	public static String getSearchKCodeSubQuery() {
		StringBuffer sb = new StringBuffer();
		sb.append(" SELECT ");
		sb.append(COL_UNITCODE);
		sb.append(" FROM ");
		sb.append(TABLE);
		sb.append(" WHERE ");
		sb.append(COL_DELETEFLAG);
		sb.append(" = " + CommonConst.DEFAULT_FLAG_OFF);
		sb.append(" AND ");
		sb.append(" ( ");
		sb.append(COL_MAIN + " IN (" + MKihonDao.getSearchKCodeSubQuery() + ") ");
		sb.append(" OR ");
		sb.append(COL_AGENT + " IN (" + MKihonDao.getSearchKCodeSubQuery() + ") ");
		sb.append(" ) ");
		return sb.toString();
	}
	
	/**
	 * ЈpTuNG[
	 * @return		sb	TuNG
	 */
	public static String getSearchKNameSubQuery() {
		StringBuffer sb = new StringBuffer();
		sb.append(" SELECT ");
		sb.append(COL_UNITCODE);
		sb.append(" FROM ");
		sb.append(TABLE);
		sb.append(" WHERE ");
		sb.append(COL_DELETEFLAG);
		sb.append(" = " + CommonConst.DEFAULT_FLAG_OFF);
		sb.append(" AND ");
		sb.append(" ( ");
		sb.append(COL_MAIN + " IN (" + MKihonDao.getSearchKNameSubQuery() + ") ");
		sb.append(" OR ");
		sb.append(COL_AGENT + " IN (" + MKihonDao.getSearchKNameSubQuery() + ") ");
		sb.append(" ) ");
		return sb.toString();
	}
	
	/**
	 * LЈR[hpTuNG[
	 * @return		sb	TuNG
	 */
	public static String getSearchKCodeSubQueryByStartDate() {
		StringBuffer sb = new StringBuffer();
		sb.append(" SELECT ");
		sb.append(COL_UNITCODE);
		sb.append(" FROM ");
		sb.append(TABLE);
		sb.append(" WHERE ");
		sb.append(COL_DELETEFLAG);
		sb.append(" = " + CommonConst.DEFAULT_FLAG_OFF);
		sb.append(" AND ");
		sb.append(" ( ");
		sb.append(COL_MAIN + " IN (" + MKihonDao.getSearchKCodeEqualSubQuery() + ") ");
		sb.append(" OR ");
		sb.append(COL_AGENT + " IN (" + MKihonDao.getSearchKCodeEqualSubQuery() + ") ");
		sb.append(" ) ");
		sb.append(" AND ");
		sb.append(COL_STARTDATE + " = (" + getSearchUnitCodeSubQueryDescLimit() + " ) ");
		return sb.toString();
	}
	
	/**
	 * LjbgR[hpTuNG[
	 * @return		sb	TuNG
	 */
	public static String getSearchSubQueryByStartDate() {
		StringBuffer sb = new StringBuffer();
		sb.append(" SELECT ");
		sb.append(COL_UNITCODE);
		sb.append(" FROM ");
		sb.append(TABLE);
		sb.append(" WHERE ");
		sb.append(COL_DELETEFLAG);
		sb.append(" = " + CommonConst.DEFAULT_FLAG_OFF);
		sb.append(" AND ");
		sb.append(COL_STARTDATE + " = (" + getSearchUnitCodeSubQueryDescLimit() + " ) ");
		return sb.toString();
	}
	
	/**
	 * wJnLR[hpTuNG[
	 * @return	sb
	 */
	public static String getSearchUnitCodeSubQueryDescLimit() {
		StringBuffer sb = new StringBuffer();
		sb.append(" SELECT ");
		sb.append(TMP_UNIT_TABLE + "." + COL_STARTDATE);
		sb.append(" FROM ");
		sb.append(TABLE);
		sb.append(" AS ");
		sb.append(TMP_UNIT_TABLE);
		sb.append(" WHERE ");
		sb.append(TABLE + "." + COL_UNITCODE);
		sb.append(" = ");
		sb.append(TMP_UNIT_TABLE + "." + COL_UNITCODE);
		sb.append(" AND ");
		sb.append(COL_DELETEFLAG);
		sb.append(" = " + CommonConst.DEFAULT_FLAG_OFF);
		sb.append(" AND ");
		sb.append(COL_STARTDATE);
		sb.append(" <= ? ");
		sb.append("ORDER BY ");
		sb.append(COL_STARTDATE);
		sb.append(MosPDao.getDESCLimit1());
		return sb.toString();
	}
	
}
