/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.workflow.action;

import java.io.Serializable;
import java.util.Comparator;

import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.kintai.common.action.MosPWorkflowAction;
import jp.mosp.kintai.workflow.dto.AttendanceRouteDto;
import jp.mosp.kintai.workflow.vo.AttendanceRouteListVo;

/**
 * @author yoshida
 *
 */
public class AttendanceRouteListAction extends MosPWorkflowAction {
	
	// R}h
	private static final String	CMD_ROUTE_LIST_SHOW			= "S2830";
	private static final String	CMD_ROUTE_LIST_SEARCH		= "S2831";
	private static final String	CMD_ROUTE_LIST_RE_SEARCH	= "S2832";
	private static final String	CMD_ROUTE_LIST_SORT			= "S2833";
	

	/**
	 * RXgN^
	 */
	public AttendanceRouteListAction() {
		super();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾
		prepareVo();
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_ROUTE_LIST_SHOW)) {
			show();
		} else if (cmd.equals(CMD_ROUTE_LIST_SEARCH)) {
			// 
			search();
		} else if (cmd.equals(CMD_ROUTE_LIST_RE_SEARCH)) {
			// Č
			research();
		} else if (cmd.equals(CMD_ROUTE_LIST_SORT)) {
			// \[g
			sortList(key1);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new AttendanceRouteListVo();
	}
	
	@Override
	protected void init() throws Exception {
		// DBRlNV擾
		getConnection();
		// SYSTEMmF
		confirmSystemAuth();
		AttendanceRouteListVo vo = (AttendanceRouteListVo)getVo();
		// jbg擾
		vo.aryPltUnit = getCurrentUnitArray();
		// R[h
		vo.aryPltSection = StringUtil.addArrayFirstRowSpace(getSectionArrayAll());
		// ЈR[h
		vo.aryPltUser = part().human().getBasisArrayAll();
		// ƏR[h
		vo.aryPltOffice = StringUtil.addArrayFirstRowSpace(getOfficeArrayAll());
	}
	
	@Override
	protected void show() throws Exception {
		AttendanceRouteListVo vo = (AttendanceRouteListVo)getVo();
		// lɃZbg
		vo.setSearchmode(AttendanceRouteListVo.SEARCH_OFF);
	}
	
	@Override
	protected void search() throws Exception {
		AttendanceRouteListVo vo = (AttendanceRouteListVo)getVo();
		vo.setParams(request);
		searchRouteList();
		vo.setFormerKey(vo.KEY_SECTION);
		vo.setIsAscending(true);
		vo.initListInfo();
		sortList();
	}
	
	@Override
	protected void research() throws Exception {
		AttendanceRouteListVo vo = (AttendanceRouteListVo)getVo();
		if (vo.getSearchmode() == AttendanceRouteListVo.SEARCH_ON) {
			removeSessionDto();
			searchRouteList();
			vo.setPageButton();
			sortList();
		}
	}
	
	/**
	 * [gXg
	 * @throws Exception 	Oꍇ
	 */
	private void searchRouteList() throws Exception {
		AttendanceRouteListVo vo = (AttendanceRouteListVo)getVo();
		// 
		vo.setFields(atRouteDao().findForCondition(vo.getPltSection(), vo.getTxtKCode(), vo.getTxtKName(),
				vo.getTxtRouteCode(), vo.getPltOffice()));
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.getAryAttendanceRoute().length == 0) {
			addErrMessage(getMessage(MospConst.MSG_NO_DATA, ""));
		}
		vo.setSearchmode(AttendanceRouteListVo.SEARCH_ON);
	}
	
	@Override
	protected Comparator<Object> getComparator(String key) throws MospException {
		AttendanceRouteListVo vo = (AttendanceRouteListVo)getVo();
		Comparator<Object> comp = null;
		if (key.equals(vo.KEY_SECTION)) {
			comp = new CompSection();
		} else if (key.equals(vo.KEY_K_CODE)) {
			comp = new CompKCode();
		} else if (key.equals(vo.KEY_OFFICE)) {
			comp = new CompOffice();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}
	

	/**
	 * R[hɂrNX
	 */
	protected static class CompSection implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -6704496605982974674L;
		

		public int compare(Object obj1, Object obj2) {
			AttendanceRouteDto dto1 = (AttendanceRouteDto)obj1;
			AttendanceRouteDto dto2 = (AttendanceRouteDto)obj2;
			return dto1.getSCode().compareTo(dto2.getSCode());
		}
	}
	
	/**
	 * ЈR[hɂrNX
	 */
	protected static class CompKCode implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -8076999764807189761L;
		

		public int compare(Object obj1, Object obj2) {
			AttendanceRouteDto dto1 = (AttendanceRouteDto)obj1;
			AttendanceRouteDto dto2 = (AttendanceRouteDto)obj2;
			return dto1.getKCode().compareTo(dto2.getKCode());
		}
	}
	
	/**
	 * ƏR[hɂrNX
	 */
	protected static class CompOffice implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -6507035343563191493L;
		

		public int compare(Object obj1, Object obj2) {
			AttendanceRouteDto dto1 = (AttendanceRouteDto)obj1;
			AttendanceRouteDto dto2 = (AttendanceRouteDto)obj2;
			return dto1.getJCode().compareTo(dto2.getJCode());
		}
	}
	
}
