/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.system.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospException;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.kintai.common.dto.MYakusyokuDto;

/**
 * @author yoshida
 *
 */
public class YakusyokuMasterCardVo extends MosPVo {
	
	private static final long	serialVersionUID	= -4752290351658511718L;
	
	// 萔
	/**
	 * 
	 */
	public static final int		MODE_INSERT			= 0;
	/**
	 * 
	 */
	public static final int		MODE_UPDATE			= 1;
	/**
	 * 
	 */
	public static final int		MODE_SYSTEM			= 2;
	
	// p[^
	/**
	 * 
	 */
	public static final String	PRM_TXT_YCODE		= "txtYCode";
	/**
	 * 
	 */
	public static final String	PRM_TXT_YNAME		= "txtYName";
	/**
	 * 
	 */
	public static final String	PRM_PLT_TOKYU		= "pltTokyu";
	/**
	 * 
	 */
	public static final String	PRM_HID_TKEKKIN		= "hidTKekkin";
	/**
	 * 
	 */
	public static final String	PRM_PLT_KEKKIN		= "pltKekkin";
	/**
	 * 
	 */
	public static final String	PRM_HID_SKEKKIN		= "hidSKekkin";
	/**
	 * 
	 */
	public static final String	PRM_PLT_TIJI		= "pltTiJi";
	/**
	 * 
	 */
	public static final String	PRM_PLT_ZAJI		= "pltZaJi";
	/**
	 * 
	 */
	public static final String	PRM_PLT_KSJI		= "pltKsJi";
	/**
	 * 
	 */
	public static final String	PRM_PLT_SNJI		= "pltSnJi";
	/**
	 * 
	 */
	public static final String	PRM_PLT_KAIKIN		= "pltKaikin";
	/**
	 * 
	 */
	public static final String	PRM_PLT_SYOKUJI		= "pltSyokuji";
	/**
	 * 
	 */
	public static final String	PRM_PLT_CYOKU1		= "pltCyoku1";
	/**
	 * 
	 */
	public static final String	PRM_PLT_CYOKU2		= "pltCyoku2";
	/**
	 * 
	 */
	public static final String	PRM_PLT_CYOKU3		= "pltCyoku3";
	/**
	 * 
	 */
	public static final String	PRM_PLT_HOKA1		= "pltHoka1";
	/**
	 * 
	 */
	public static final String	PRM_PLT_HOKA2		= "pltHoka2";
	/**
	 * 
	 */
	public static final String	PRM_PLT_HOKA3		= "pltHoka3";
	/**
	 * 
	 */
	public static final String	PRM_PLT_HOKA4		= "pltHoka4";
	/**
	 * 
	 */
	public static final String	PRM_PLT_HOKA5		= "pltHoka5";
	/**
	 * 
	 */
	public static final String	PRM_HID_TKEKKINTAN	= "hidTKekkinTan";
	/**
	 * 
	 */
	public static final String	PRM_HID_KEKKINTAN	= "hidKekkinTan";
	/**
	 * 
	 */
	public static final String	PRM_HID_SKEKKINTAN	= "hidSKekkinTan";
	/**
	 * 
	 */
	public static final String	PRM_HID_TIJITAN		= "hidTiJiTan";
	/**
	 * 
	 */
	public static final String	PRM_HID_ZAJITAN		= "hidZaJiTan";
	/**
	 * 
	 */
	public static final String	PRM_HID_KSJITAN		= "hidKsJiTan";
	/**
	 * 
	 */
	public static final String	PRM_HID_SNJITAN		= "hidSnJiTan";
	/**
	 * 
	 */
	public static final String	PRM_TXT_KAIKINTAN	= "txtKaikinTan";
	/**
	 * 
	 */
	public static final String	PRM_TXT_SYOKUJITAN	= "txtSyokuJiTan";
	/**
	 * 
	 */
	public static final String	PRM_TXT_CYOKU1TAN	= "txtCyoku1Tan";
	/**
	 * 
	 */
	public static final String	PRM_TXT_CYOKU2TAN	= "txtCyoku2Tan";
	/**
	 * 
	 */
	public static final String	PRM_TXT_CYOKU3TAN	= "txtCyoku3Tan";
	/**
	 * 
	 */
	public static final String	PRM_TXT_HOKA1TAN	= "txtHoka1Tan";
	/**
	 * 
	 */
	public static final String	PRM_TXT_HOKA2TAN	= "txtHoka2Tan";
	/**
	 * 
	 */
	public static final String	PRM_TXT_HOKA3TAN	= "txtHoka3Tan";
	/**
	 * 
	 */
	public static final String	PRM_TXT_HOKA4TAN	= "txtHoka4Tan";
	/**
	 * 
	 */
	public static final String	PRM_TXT_HOKA5TAN	= "txtHoka5Tan";
	
	// tB[h
	private String				txtYCode;
	private String				txtYName;
	private String				pltTokyu;
	private String				hidTKekkin;
	private String				pltKekkin;
	private String				hidSKekkin;
	private String				pltTiJi;
	private String				pltZaJi;
	private String				pltKsJi;
	private String				pltSnJi;
	private String				pltKaikin;
	private String				pltSyokuji;
	private String				pltCyoku1;
	private String				pltCyoku2;
	private String				pltCyoku3;
	private String				pltHoka1;
	private String				pltHoka2;
	private String				pltHoka3;
	private String				pltHoka4;
	private String				pltHoka5;
	private String				hidTKekkinTan;
	private String				hidKekkinTan;
	private String				hidSKekkinTan;
	private String				hidTiJiTan;
	private String				hidZaJiTan;
	private String				hidKsJiTan;
	private String				hidSnJiTan;
	private String				txtKaikinTan;
	private String				txtSyokuJiTan;
	private String				txtCyoku1Tan;
	private String				txtCyoku2Tan;
	private String				txtCyoku3Tan;
	private String				txtHoka1Tan;
	private String				txtHoka2Tan;
	private String				txtHoka3Tan;
	private String				txtHoka4Tan;
	private String				txtHoka5Tan;
	
	// v_EXg
	/**
	 * 
	 */
	public String[][]			aryPltTokyu;
	/**
	 * E蓖敪v_EXgiL{^Pj
	 */
	public String[][]			aryPltExistence1;
	/**
	 * E蓖敪v_EXgiL{ŒPj
	 */
	public String[][]			aryPltExistence2;
	/**
	 * E蓖敪v_EXgiL{^P{ŒPj
	 */
	public String[][]			aryPltExistence3;
	
	// 蓖̃Xg
	private String[][]			aryAllowance;
	
	// [h(0FVKo^A1FXVA2F폜)
	private int					mode;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_YCODE;
	/**
	 * 
	 */
	public String				NAM_YNAME;
	/**
	 * 
	 */
	public String				NAM_TOKYU;
	/**
	 * 
	 */
	public int					LEN_YCODE;
	/**
	 * 
	 */
	public int					LEN_YNAME;
	/**
	 * 
	 */
	public int					LEN_KAIKINTAN;
	/**
	 * 
	 */
	public int					LEN_SYOKUJITAN;
	/**
	 * 
	 */
	public int					LEN_CYOKU1TAN;
	/**
	 * 
	 */
	public int					LEN_CYOKU2TAN;
	/**
	 * 
	 */
	public int					LEN_CYOKU3TAN;
	/**
	 * 
	 */
	public int					LEN_HOKA1TAN;
	/**
	 * 
	 */
	public int					LEN_HOKA2TAN;
	/**
	 * 
	 */
	public int					LEN_HOKA3TAN;
	/**
	 * 
	 */
	public int					LEN_HOKA4TAN;
	/**
	 * 
	 */
	public int					LEN_HOKA5TAN;
	

	/**
	 * RXgN^
	 */
	public YakusyokuMasterCardVo() {
		super();
		mode = MODE_INSERT;
		setViewPath(getClassName());
		aryAllowance = new String[0][0];
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_POSITION_MASTER;
		aryMenu = new String[][]{ { CMD_MENU_SYSTEM2, CommonConst.NAM_TO_MENU } };
	}
	
	@Override
	protected void setFieldsName() {
		NAM_YCODE = CommonConst.NAM_POSITION1 + CommonConst.NAM_COMMON_CODE;
		NAM_YNAME = CommonConst.NAM_POSITION1 + CommonConst.NAM_COMMON_MEISYO;
		NAM_TOKYU = CommonConst.NAM_GRADE;
		LEN_YCODE = 5;
		LEN_YNAME = 20;
		LEN_KAIKINTAN = 5;
		LEN_SYOKUJITAN = 5;
		LEN_CYOKU1TAN = 5;
		LEN_CYOKU2TAN = 5;
		LEN_CYOKU3TAN = 5;
		LEN_HOKA1TAN = 5;
		LEN_HOKA2TAN = 5;
		LEN_HOKA3TAN = 5;
		LEN_HOKA4TAN = 5;
		LEN_HOKA5TAN = 5;
		
	}
	
	/**
	 * lݒ
	 */
	public void setDefaultValues() {
		setTxtYCode("");
		setTxtYName("");
		setPltTokyu("");
		setHidTKekkin("0");
		setPltKekkin("0");
		setHidSKekkin("0");
		setPltTiJi("0");
		setPltZaJi("0");
		setPltKsJi("0");
		setPltSnJi("0");
		setPltKaikin("0");
		setPltSyokuji("0");
		setPltCyoku1("0");
		setPltCyoku2("0");
		setPltCyoku3("0");
		setPltHoka1("0");
		setPltHoka2("0");
		setPltHoka3("0");
		setPltHoka4("0");
		setPltHoka5("0");
		setHidTKekkinTan("0");
		setHidKekkinTan("0");
		setHidSKekkinTan("0");
		setHidTiJiTan("0");
		setHidZaJiTan("0");
		setHidKsJiTan("0");
		setHidSnJiTan("0");
		setTxtKaikinTan("0");
		setTxtSyokuJiTan("0");
		setTxtCyoku1Tan("0");
		setTxtCyoku2Tan("0");
		setTxtCyoku3Tan("0");
		setTxtHoka1Tan("0");
		setTxtHoka2Tan("0");
		setTxtHoka3Tan("0");
		setTxtHoka4Tan("0");
		setTxtHoka5Tan("0");
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		txtYCode = request.getParameter(PRM_TXT_YCODE);
		txtYName = request.getParameter(PRM_TXT_YNAME);
		pltTokyu = request.getParameter(PRM_PLT_TOKYU);
		hidTKekkin = request.getParameter(PRM_HID_TKEKKIN);
		pltKekkin = request.getParameter(PRM_PLT_KEKKIN);
		hidSKekkin = request.getParameter(PRM_HID_SKEKKIN);
		pltTiJi = request.getParameter(PRM_PLT_TIJI);
		pltZaJi = request.getParameter(PRM_PLT_ZAJI);
		pltKsJi = request.getParameter(PRM_PLT_KSJI);
		pltSnJi = request.getParameter(PRM_PLT_SNJI);
		pltKaikin = request.getParameter(PRM_PLT_KAIKIN);
		pltSyokuji = request.getParameter(PRM_PLT_SYOKUJI);
		pltCyoku1 = request.getParameter(PRM_PLT_CYOKU1);
		pltCyoku2 = request.getParameter(PRM_PLT_CYOKU2);
		pltCyoku3 = request.getParameter(PRM_PLT_CYOKU3);
		pltHoka1 = request.getParameter(PRM_PLT_HOKA1);
		pltHoka2 = request.getParameter(PRM_PLT_HOKA2);
		pltHoka3 = request.getParameter(PRM_PLT_HOKA3);
		pltHoka4 = request.getParameter(PRM_PLT_HOKA4);
		pltHoka5 = request.getParameter(PRM_PLT_HOKA5);
		hidTKekkinTan = request.getParameter(PRM_HID_TKEKKINTAN);
		hidKekkinTan = request.getParameter(PRM_HID_KEKKINTAN);
		hidSKekkinTan = request.getParameter(PRM_HID_SKEKKINTAN);
		hidTiJiTan = request.getParameter(PRM_HID_TIJITAN);
		hidZaJiTan = request.getParameter(PRM_HID_ZAJITAN);
		hidKsJiTan = request.getParameter(PRM_HID_KSJITAN);
		hidSnJiTan = request.getParameter(PRM_HID_SNJITAN);
		txtKaikinTan = StringUtil.convNullToInitialValue(request.getParameter(PRM_TXT_KAIKINTAN),
				CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		txtSyokuJiTan = StringUtil.convNullToInitialValue(request.getParameter(PRM_TXT_SYOKUJITAN),
				CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		txtCyoku1Tan = StringUtil.convNullToInitialValue(request.getParameter(PRM_TXT_CYOKU1TAN),
				CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		txtCyoku2Tan = StringUtil.convNullToInitialValue(request.getParameter(PRM_TXT_CYOKU2TAN),
				CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		txtCyoku3Tan = StringUtil.convNullToInitialValue(request.getParameter(PRM_TXT_CYOKU3TAN),
				CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		txtHoka1Tan = StringUtil.convNullToInitialValue(request.getParameter(PRM_TXT_HOKA1TAN),
				CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		txtHoka2Tan = StringUtil.convNullToInitialValue(request.getParameter(PRM_TXT_HOKA2TAN),
				CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		txtHoka3Tan = StringUtil.convNullToInitialValue(request.getParameter(PRM_TXT_HOKA3TAN),
				CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		txtHoka4Tan = StringUtil.convNullToInitialValue(request.getParameter(PRM_TXT_HOKA4TAN),
				CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		txtHoka5Tan = StringUtil.convNullToInitialValue(request.getParameter(PRM_TXT_HOKA5TAN),
				CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
	}
	
	/**
	 * tB[hݒ
	 * @param dto ΏDTO
	 */
	public void setFields(MYakusyokuDto dto) {
		txtYCode = dto.getYcode();
		txtYName = dto.getYname();
		pltTokyu = dto.getTokyu();
		hidTKekkin = dto.getTkekkin();
		pltKekkin = dto.getKekkin();
		hidSKekkin = dto.getSkekkin();
		pltTiJi = dto.getTiji();
		pltZaJi = dto.getZaji();
		pltKsJi = dto.getKsji();
		pltSnJi = dto.getSnji();
		pltKaikin = dto.getKaikin();
		pltSyokuji = dto.getSyokuji();
		pltCyoku1 = dto.getCyoku1();
		pltCyoku2 = dto.getCyoku2();
		pltCyoku3 = dto.getCyoku3();
		pltHoka1 = dto.getHoka1();
		pltHoka2 = dto.getHoka2();
		pltHoka3 = dto.getHoka3();
		pltHoka4 = dto.getHoka4();
		pltHoka5 = dto.getHoka5();
		hidTKekkinTan = String.valueOf(dto.getTkekkintan());
		hidKekkinTan = String.valueOf(dto.getKekkintan());
		hidSKekkinTan = String.valueOf(dto.getSkekkintan());
		hidTiJiTan = String.valueOf(dto.getTijitan());
		hidZaJiTan = String.valueOf(dto.getZajitan());
		hidKsJiTan = String.valueOf(dto.getKsjitan());
		hidSnJiTan = String.valueOf(dto.getSnjitan());
		txtKaikinTan = String.valueOf(dto.getKaikintan());
		txtSyokuJiTan = String.valueOf(dto.getSyokujitan());
		txtCyoku1Tan = String.valueOf(dto.getCyoku1tan());
		txtCyoku2Tan = String.valueOf(dto.getCyoku2tan());
		txtCyoku3Tan = String.valueOf(dto.getCyoku3tan());
		txtHoka1Tan = String.valueOf(dto.getHoka1tan());
		txtHoka2Tan = String.valueOf(dto.getHoka2tan());
		txtHoka3Tan = String.valueOf(dto.getHoka3tan());
		txtHoka4Tan = String.valueOf(dto.getHoka4tan());
		txtHoka5Tan = String.valueOf(dto.getHoka5tan());
	}
	
	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFields(MYakusyokuDto dto) {
		dto.setYcode(txtYCode);
		dto.setYname(txtYName);
		dto.setTokyu(pltTokyu);
		/*						
		 *  	2008/10/23	m.yoshida	VerΉ
		 */
		/*		
		dto.setTKekkin		(hidTKekkin);
		dto.setKekkin		(pltKekkin);
		dto.setSKekkin		(hidSKekkin);
		dto.setTiJi			(pltTiJi);
		dto.setZaJi			(pltZaJi);
		dto.setKsJi			(pltKsJi);
		dto.setSnJi			(pltSnJi);
		 */
		dto.setKaikin(pltKaikin);
		/*						
		 *  	2008/10/23	m.yoshida	VerΉ
		 */
		/*
		dto.setSyokuji		(pltSyokuji);
		dto.setCyoku1		(pltCyoku1);
		dto.setCyoku2		(pltCyoku2);
		dto.setCyoku3		(pltCyoku3);
		dto.setHoka1		(pltHoka1);
		dto.setHoka2		(pltHoka2);
		dto.setHoka3		(pltHoka3);
		dto.setHoka4		(pltHoka4);
		dto.setHoka5		(pltHoka5);
		dto.setTKekkinTan	(getIntParam(hidTKekkinTan));
		dto.setKekkinTan	(getIntParam(hidKekkinTan));
		dto.setSKekkinTan	(getIntParam(hidSKekkinTan));
		dto.setTiJiTan		(getIntParam(hidTiJiTan));
		dto.setZaJiTan		(getIntParam(hidZaJiTan));
		dto.setKsJiTan		(getIntParam(hidKsJiTan));
		dto.setSnJiTan		(getIntParam(hidSnJiTan));
		dto.setKaikinTan	(getIntParam(txtKaikinTan));
		dto.setSyokuJiTan	(getIntParam(txtSyokuJiTan));
		dto.setCyoku1Tan	(getIntParam(txtCyoku1Tan));
		dto.setCyoku2Tan	(getIntParam(txtCyoku2Tan));
		dto.setCyoku3Tan	(getIntParam(txtCyoku3Tan));
		dto.setHoka1Tan		(getIntParam(txtHoka1Tan));
		dto.setHoka2Tan		(getIntParam(txtHoka2Tan));
		dto.setHoka3Tan		(getIntParam(txtHoka3Tan));
		dto.setHoka4Tan		(getIntParam(txtHoka4Tan));
		dto.setHoka5Tan		(getIntParam(txtHoka5Tan));
		 */
	}
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException 	MosPOꍇ
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(txtYCode, NAM_YCODE, PRM_TXT_YCODE);
		checkRequired(txtYName, NAM_YNAME, PRM_TXT_YNAME);
		// ^CvmF
		checkCode(txtYCode, NAM_YCODE, PRM_TXT_YCODE);
		/*						
		 *  	2008/10/23	m.yoshida	VerΉ
		 */
		/*
		checkNumber(txtKaikinTan	, aryAllowance[ 7][1]	, PRM_TXT_KAIKINTAN	);
		checkNumber(txtSyokuJiTan	, aryAllowance[ 8][1]	, PRM_TXT_SYOKUJITAN);
		checkNumber(txtCyoku1Tan	, aryAllowance[ 9][1]	, PRM_TXT_CYOKU1TAN	);
		checkNumber(txtCyoku2Tan	, aryAllowance[10][1]	, PRM_TXT_CYOKU2TAN	);
		checkNumber(txtCyoku3Tan	, aryAllowance[11][1]	, PRM_TXT_CYOKU3TAN	);
		checkNumber(txtHoka1Tan		, aryAllowance[12][1]	, PRM_TXT_HOKA1TAN	);
		checkNumber(txtHoka2Tan		, aryAllowance[13][1]	, PRM_TXT_HOKA2TAN	);
		checkNumber(txtHoka3Tan		, aryAllowance[14][1]	, PRM_TXT_HOKA3TAN	);
		checkNumber(txtHoka4Tan		, aryAllowance[15][1]	, PRM_TXT_HOKA4TAN	);
		checkNumber(txtHoka5Tan		, aryAllowance[16][1]	, PRM_TXT_HOKA5TAN	);
		 */
		// 񒷊mF		
		checkLength(txtYCode, LEN_YCODE, NAM_YCODE, PRM_TXT_YCODE);
		checkLength(txtYName, LEN_YNAME, NAM_YNAME, PRM_TXT_YNAME);
		/*						
		 *  	2008/10/23	m.yoshida	VerΉ
		 */
		/*		
		checkLength(txtKaikinTan	, LEN_KAIKINTAN	, aryAllowance[ 7][1]	, PRM_TXT_KAIKINTAN	);
		checkLength(txtSyokuJiTan	, LEN_SYOKUJITAN, aryAllowance[ 8][1]	, PRM_TXT_SYOKUJITAN);
		 */
		/*		
		checkLength(txtCyoku1Tan	, LEN_CYOKU1TAN	, aryAllowance[ 9][1]	, PRM_TXT_CYOKU1TAN	);
		checkLength(txtCyoku2Tan	, LEN_CYOKU2TAN	, aryAllowance[10][1]	, PRM_TXT_CYOKU2TAN	);
		checkLength(txtCyoku3Tan	, LEN_CYOKU3TAN	, aryAllowance[11][1]	, PRM_TXT_CYOKU3TAN	);
		checkLength(txtHoka1Tan		, LEN_HOKA1TAN	, aryAllowance[12][1]	, PRM_TXT_HOKA1TAN	);
		checkLength(txtHoka2Tan		, LEN_HOKA2TAN	, aryAllowance[13][1]	, PRM_TXT_HOKA2TAN	);
		checkLength(txtHoka3Tan		, LEN_HOKA3TAN	, aryAllowance[14][1]	, PRM_TXT_HOKA3TAN	);
		checkLength(txtHoka4Tan		, LEN_HOKA4TAN	, aryAllowance[15][1]	, PRM_TXT_HOKA4TAN	);
		checkLength(txtHoka5Tan		, LEN_HOKA5TAN	, aryAllowance[16][1]	, PRM_TXT_HOKA5TAN	);
		 */
		// ÓmFI
		endValidation();
	}
	
	@Override
	public String getDirectJs(Class<?> cls, Object obj) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls, obj));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		sb.append(getSettingJs("ARY_ALLOWANCE", aryAllowance));
		return sb.toString();
	}
	
	/**
	 * @return txtYCode
	 */
	public String getTxtYCode() {
		return txtYCode;
	}
	
	/**
	 * @return txtYName
	 */
	public String getTxtYName() {
		return txtYName;
	}
	
	/**
	 * @return pltTokyu
	 */
	public String getPltTokyu() {
		return pltTokyu;
	}
	
	/**
	 * @return hidTKekkin
	 */
	public String getHidTKekkin() {
		return hidTKekkin;
	}
	
	/**
	 * @return pltKekkin
	 */
	public String getPltKekkin() {
		return pltKekkin;
	}
	
	/**
	 * @return hidSKekkin
	 */
	public String getHidSKekkin() {
		return hidSKekkin;
	}
	
	/**
	 * @return pltTiJi
	 */
	public String getPltTiJi() {
		return pltTiJi;
	}
	
	/**
	 * @return pltZaJi
	 */
	public String getPltZaJi() {
		return pltZaJi;
	}
	
	/**
	 * @return pltKsJi
	 */
	public String getPltKsJi() {
		return pltKsJi;
	}
	
	/**
	 * @return pltSnJi
	 */
	public String getPltSnJi() {
		return pltSnJi;
	}
	
	/**
	 * @return pltKaikin
	 */
	public String getPltKaikin() {
		return pltKaikin;
	}
	
	/**
	 * @return pltSyokuji
	 */
	public String getPltSyokuji() {
		return pltSyokuji;
	}
	
	/**
	 * @return pltCyoku1
	 */
	public String getPltCyoku1() {
		return pltCyoku1;
	}
	
	/**
	 * @return pltCyoku2
	 */
	public String getPltCyoku2() {
		return pltCyoku2;
	}
	
	/**
	 * @return pltCyoku3
	 */
	public String getPltCyoku3() {
		return pltCyoku3;
	}
	
	/**
	 * @return pltHoka1
	 */
	public String getPltHoka1() {
		return pltHoka1;
	}
	
	/**
	 * @return pltHoka2
	 */
	public String getPltHoka2() {
		return pltHoka2;
	}
	
	/**
	 * @return pltHoka3
	 */
	public String getPltHoka3() {
		return pltHoka3;
	}
	
	/**
	 * @return pltHoka4
	 */
	public String getPltHoka4() {
		return pltHoka4;
	}
	
	/**
	 * @return pltHoka5
	 */
	public String getPltHoka5() {
		return pltHoka5;
	}
	
	/**
	 * @return hidTKekkinTan
	 */
	public String getHidTKekkinTan() {
		return hidTKekkinTan;
	}
	
	/**
	 * @return hidKekkinTan
	 */
	public String getHidKekkinTan() {
		return hidKekkinTan;
	}
	
	/**
	 * @return hidSKekkinTan
	 */
	public String getHidSKekkinTan() {
		return hidSKekkinTan;
	}
	
	/**
	 * @return hidTiJiTan
	 */
	public String getHidTiJiTan() {
		return hidTiJiTan;
	}
	
	/**
	 * @return hidZaJiTan
	 */
	public String getHidZaJiTan() {
		return hidZaJiTan;
	}
	
	/**
	 * @return hidKsJiTan
	 */
	public String getHidKsJiTan() {
		return hidKsJiTan;
	}
	
	/**
	 * @return hidSnJiTan
	 */
	public String getHidSnJiTan() {
		return hidSnJiTan;
	}
	
	/**
	 * @return txtKaikinTan
	 */
	public String getTxtKaikinTan() {
		return txtKaikinTan;
	}
	
	/**
	 * @return txtSyokuJiTan
	 */
	public String getTxtSyokuJiTan() {
		return txtSyokuJiTan;
	}
	
	/**
	 * @return txtCyoku1Tan
	 */
	public String getTxtCyoku1Tan() {
		return txtCyoku1Tan;
	}
	
	/**
	 * @return txtCyoku2Tan
	 */
	public String getTxtCyoku2Tan() {
		return txtCyoku2Tan;
	}
	
	/**
	 * @return txtCyoku3Tan
	 */
	public String getTxtCyoku3Tan() {
		return txtCyoku3Tan;
	}
	
	/**
	 * @return txtHoka1Tan
	 */
	public String getTxtHoka1Tan() {
		return txtHoka1Tan;
	}
	
	/**
	 * @return txtHoka2Tan
	 */
	public String getTxtHoka2Tan() {
		return txtHoka2Tan;
	}
	
	/**
	 * @return txtHoka3Tan
	 */
	public String getTxtHoka3Tan() {
		return txtHoka3Tan;
	}
	
	/**
	 * @return txtHoka4Tan
	 */
	public String getTxtHoka4Tan() {
		return txtHoka4Tan;
	}
	
	/**
	 * @return txtHoka5Tan
	 */
	public String getTxtHoka5Tan() {
		return txtHoka5Tan;
	}
	
	/**
	 * @return aryAllowance
	 */
	public String[][] getAryAllowance() {
		return aryAllowance.clone();
	}
	
	/**
	 * @return mode
	 */
	public int getMode() {
		return mode;
	}
	
	/**
	 * @param txtYCode Zbg txtYCode
	 */
	public void setTxtYCode(String txtYCode) {
		this.txtYCode = txtYCode;
	}
	
	/**
	 * @param txtYName Zbg txtYName
	 */
	public void setTxtYName(String txtYName) {
		this.txtYName = txtYName;
	}
	
	/**
	 * @param pltTokyu Zbg pltTokyu
	 */
	public void setPltTokyu(String pltTokyu) {
		this.pltTokyu = pltTokyu;
	}
	
	/**
	 * @param hidTKekkin Zbg hidTKekkin
	 */
	public void setHidTKekkin(String hidTKekkin) {
		this.hidTKekkin = hidTKekkin;
	}
	
	/**
	 * @param pltKekkin Zbg pltKekkin
	 */
	public void setPltKekkin(String pltKekkin) {
		this.pltKekkin = pltKekkin;
	}
	
	/**
	 * @param hidSKekkin Zbg hidSKekkin
	 */
	public void setHidSKekkin(String hidSKekkin) {
		this.hidSKekkin = hidSKekkin;
	}
	
	/**
	 * @param pltTiJi Zbg pltTiJi
	 */
	public void setPltTiJi(String pltTiJi) {
		this.pltTiJi = pltTiJi;
	}
	
	/**
	 * @param pltZaJi Zbg pltZaJi
	 */
	public void setPltZaJi(String pltZaJi) {
		this.pltZaJi = pltZaJi;
	}
	
	/**
	 * @param pltKsJi Zbg pltKsJi
	 */
	public void setPltKsJi(String pltKsJi) {
		this.pltKsJi = pltKsJi;
	}
	
	/**
	 * @param pltSnJi Zbg pltSnJi
	 */
	public void setPltSnJi(String pltSnJi) {
		this.pltSnJi = pltSnJi;
	}
	
	/**
	 * @param pltKaikin Zbg pltKaikin
	 */
	public void setPltKaikin(String pltKaikin) {
		this.pltKaikin = pltKaikin;
	}
	
	/**
	 * @param pltSyokuji Zbg pltSyokuji
	 */
	public void setPltSyokuji(String pltSyokuji) {
		this.pltSyokuji = pltSyokuji;
	}
	
	/**
	 * @param pltCyoku1 Zbg pltCyoku1
	 */
	public void setPltCyoku1(String pltCyoku1) {
		this.pltCyoku1 = pltCyoku1;
	}
	
	/**
	 * @param pltCyoku2 Zbg pltCyoku2
	 */
	public void setPltCyoku2(String pltCyoku2) {
		this.pltCyoku2 = pltCyoku2;
	}
	
	/**
	 * @param pltCyoku3 Zbg pltCyoku3
	 */
	public void setPltCyoku3(String pltCyoku3) {
		this.pltCyoku3 = pltCyoku3;
	}
	
	/**
	 * @param pltHoka1 Zbg pltHoka1
	 */
	public void setPltHoka1(String pltHoka1) {
		this.pltHoka1 = pltHoka1;
	}
	
	/**
	 * @param pltHoka2 Zbg pltHoka2
	 */
	public void setPltHoka2(String pltHoka2) {
		this.pltHoka2 = pltHoka2;
	}
	
	/**
	 * @param pltHoka3 Zbg pltHoka3
	 */
	public void setPltHoka3(String pltHoka3) {
		this.pltHoka3 = pltHoka3;
	}
	
	/**
	 * @param pltHoka4 Zbg pltHoka4
	 */
	public void setPltHoka4(String pltHoka4) {
		this.pltHoka4 = pltHoka4;
	}
	
	/**
	 * @param pltHoka5 Zbg pltHoka5
	 */
	public void setPltHoka5(String pltHoka5) {
		this.pltHoka5 = pltHoka5;
	}
	
	/**
	 * @param hidTKekkinTan Zbg hidTKekkinTan
	 */
	public void setHidTKekkinTan(String hidTKekkinTan) {
		this.hidTKekkinTan = hidTKekkinTan;
	}
	
	/**
	 * @param hidKekkinTan Zbg hidKekkinTan
	 */
	public void setHidKekkinTan(String hidKekkinTan) {
		this.hidKekkinTan = hidKekkinTan;
	}
	
	/**
	 * @param hidSKekkinTan Zbg hidSKekkinTan
	 */
	public void setHidSKekkinTan(String hidSKekkinTan) {
		this.hidSKekkinTan = hidSKekkinTan;
	}
	
	/**
	 * @param hidTiJiTan Zbg hidTiJiTan
	 */
	public void setHidTiJiTan(String hidTiJiTan) {
		this.hidTiJiTan = hidTiJiTan;
	}
	
	/**
	 * @param hidZaJiTan Zbg hidZaJiTan
	 */
	public void setHidZaJiTan(String hidZaJiTan) {
		this.hidZaJiTan = hidZaJiTan;
	}
	
	/**
	 * @param hidKsJiTan Zbg hidKsJiTan
	 */
	public void setHidKsJiTan(String hidKsJiTan) {
		this.hidKsJiTan = hidKsJiTan;
	}
	
	/**
	 * @param hidSnJiTan Zbg hidSnJiTan
	 */
	public void setHidSnJiTan(String hidSnJiTan) {
		this.hidSnJiTan = hidSnJiTan;
	}
	
	/**
	 * @param txtKaikinTan Zbg txtKaikinTan
	 */
	public void setTxtKaikinTan(String txtKaikinTan) {
		this.txtKaikinTan = txtKaikinTan;
	}
	
	/**
	 * @param txtSyokuJiTan Zbg txtSyokuJiTan
	 */
	public void setTxtSyokuJiTan(String txtSyokuJiTan) {
		this.txtSyokuJiTan = txtSyokuJiTan;
	}
	
	/**
	 * @param txtCyoku1Tan Zbg txtCyoku1Tan
	 */
	public void setTxtCyoku1Tan(String txtCyoku1Tan) {
		this.txtCyoku1Tan = txtCyoku1Tan;
	}
	
	/**
	 * @param txtCyoku2Tan Zbg txtCyoku2Tan
	 */
	public void setTxtCyoku2Tan(String txtCyoku2Tan) {
		this.txtCyoku2Tan = txtCyoku2Tan;
	}
	
	/**
	 * @param txtCyoku3Tan Zbg txtCyoku3Tan
	 */
	public void setTxtCyoku3Tan(String txtCyoku3Tan) {
		this.txtCyoku3Tan = txtCyoku3Tan;
	}
	
	/**
	 * @param txtHoka1Tan Zbg txtHoka1Tan
	 */
	public void setTxtHoka1Tan(String txtHoka1Tan) {
		this.txtHoka1Tan = txtHoka1Tan;
	}
	
	/**
	 * @param txtHoka2Tan Zbg txtHoka2Tan
	 */
	public void setTxtHoka2Tan(String txtHoka2Tan) {
		this.txtHoka2Tan = txtHoka2Tan;
	}
	
	/**
	 * @param txtHoka3Tan Zbg txtHoka3Tan
	 */
	public void setTxtHoka3Tan(String txtHoka3Tan) {
		this.txtHoka3Tan = txtHoka3Tan;
	}
	
	/**
	 * @param txtHoka4Tan Zbg txtHoka4Tan
	 */
	public void setTxtHoka4Tan(String txtHoka4Tan) {
		this.txtHoka4Tan = txtHoka4Tan;
	}
	
	/**
	 * @param txtHoka5Tan Zbg txtHoka5Tan
	 */
	public void setTxtHoka5Tan(String txtHoka5Tan) {
		this.txtHoka5Tan = txtHoka5Tan;
	}
	
	/**
	 * @param aryAllowance Zbg aryAllowance
	 */
	public void setAryAllowance(String[][] aryAllowance) {
		this.aryAllowance = aryAllowance.clone();
	}
	
	/**
	 * @param mode Zbg mode
	 */
	public void setMode(int mode) {
		this.mode = mode;
	}
	
}
