/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.system.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospException;
import jp.mosp.common.utils.StringUtil;

/**
 * @author yoshida
 *
 */
/**
 * @author yoshida
 *
 */
public class WorkSystemCardVo extends MosPVo {
	
	private static final long	serialVersionUID				= -1673487543297482841L;
	
	// p[^
	/**
	 * pltCalcMonth
	 */
	public static final String	PRM_PLT_CALCULATION_MONTH		= "pltCalcMonth";
	/**
	 * txtCalcDays
	 */
	public static final String	PRM_TXT_CALCULATION_DAYS		= "txtCalcDays";
	/**
	 * pltProvidedMonth
	 */
	public static final String	PRM_PLT_PROVIDED_MONTH			= "pltProvidedMonth";
	/**
	 * txtProvidedDays
	 */
	public static final String	PRM_TXT_PROVIDED_DAYS			= "txtProvidedDays";
	/**
	 * txtInputUnit
	 */
	public static final String	PRM_TXT_INPUT_UNIT_TIMES		= "txtInputUnit";
	/**
	 * pltAutoCalc
	 */
	public static final String	PRM_PLT_AUTOMATIC_CALCULATION	= "pltAutoCalc";
	/**
	 * pltCalcProcess
	 */
	public static final String	PRM_PLT_CALCULATION_PROCESS		= "pltCalcProcess";
	/**
	 * txtAllHolidayHour
	 */
	public static final String	PRM_TXT_ALL_HOLIDAY_HOUR		= "txtAllHolidayHour";
	/**
	 * txtAllHolidayMin
	 */
	public static final String	PRM_TXT_ALL_HOLIDAY_MIN			= "txtAllHolidayMin";
	/**
	 * txtHalfHolidayHour
	 */
	public static final String	PRM_TXT_HALF_HOLIDAY_HOUR		= "txtHalfHolidayHour";
	/**
	 * txtHalfHolidayMin
	 */
	public static final String	PRM_TXT_HALF_HOLIDAY_MIN		= "txtHalfHolidayMin";
	/**
	 * txtLateNightStartHour
	 */
	public static final String	PRM_TXT_LATE_NIGHT_START_HOUR	= "txtLateNightStartHour";
	/**
	 * txtLateNightStartMin
	 */
	public static final String	PRM_TXT_LATE_NIGHT_START_MIN	= "txtLateNightStartMin";
	/**
	 * txtLateNightTimeHour
	 */
	public static final String	PRM_TXT_LATE_NIGHT_TIME_HOUR	= "txtLateNightTimeHour";
	/**
	 * txtLateNightTimeMin
	 */
	public static final String	PRM_TXT_LATE_NIGHT_TIME_MIN		= "txtLateNightTimeMin";
	/**
	 * txtPasswordTerm
	 */
	public static final String	PRM_TXT_PASSWORD_TERM			= "txtPasswordTerm";
	/**
	 * txtBeforeOverTimeHour
	 */
	public static final String	PRM_TXT_BEFORE_OVER_TIME_HOUR	= "txtBeforeOverTimeHour";
	/**
	 * txtBeforeOverTimeMin
	 */
	public static final String	PRM_TXT_BEFORE_OVER_TIME_MIN	= "txtBeforeOverTimeMin";
	/**
	 * txtOverTimeUnitHour
	 */
	public static final String	PRM_TXT_OVER_TIME_UNIT_HOUR		= "txtOverTimeUnitHour";
	/**
	 * txtOverTimeUnitMin
	 */
	public static final String	PRM_TXT_OVER_TIME_UNIT_MIN		= "txtOverTimeUnitMin";
	/**
	 * txtOverTimeIntervalHour
	 */
	public static final String	PRM_TXT_OVER_TIME_INTERVAL_HOUR	= "txtOverTimeIntervalHour";
	/**
	 * txtOverTimeIntervalMin
	 */
	public static final String	PRM_TXT_OVER_TIME_INTERVAL_MIN	= "txtOverTimeIntervalMin";
	/**
	 * pltRoundNumber
	 */
	public static final String	PRM_PLT_ROUND_NUMBER			= "pltRoundNumber";
	/**
	 * pltOverTime60Hour
	 */
	public static final String	PRM_PLT_OVER_TIME_60_HOUR		= "pltOverTime60Hour";
	/**
	 * pltSubstituteHoliday
	 */
	public static final String	PRM_PLT_SUBSTITUTE_HOLIDAY		= "pltSubstituteHoliday";
	/**
	 * pltSubstituteAmendment
	 */
	public static final String	PRM_PLT_SUBSTITUTE_AMENDMENT	= "pltSubstituteAmendment";
	/**
	 * pltSubstitutePeriod
	 */
	public static final String	PRM_PLT_SUBSTITUTE_PERIOD		= "pltSubstitutePeriod";
	/**
	 * pltSubstitutePriority
	 */
	public static final String	PRM_PLT_SUBSTITUTE_PRIORITY		= "pltSubstitutePriority";
	/**
	 * pltHourHolidayFunction
	 */
	public static final String	PRM_PLT_HOUR_HOLIDAY_FUNCTION	= "pltHourHolidayFunction";
	/**
	 * pltHourHolidayUnit
	 */
	public static final String	PRM_PLT_HOUR_HOLIDAY_UNIT		= "pltHourHolidayUnit";
	
	// tB[h
	private String				pltCalcMonth;
	private String				txtCalcDays;
	private String				pltProvidedMonth;
	private String				txtProvidedDays;
	private String				txtInputUnit;
	private String				pltAutoCalc;
	private String				pltCalcProcess;
	private String				txtAllHolidayHour;
	private String				txtAllHolidayMin;
	private String				txtHalfHolidayHour;
	private String				txtHalfHolidayMin;
	private String				txtLateNightStartHour;
	private String				txtLateNightStartMin;
	private String				txtLateNightTimeHour;
	private String				txtLateNightTimeMin;
	private String				txtPasswordTerm;
	private String				txtBeforeOverTimeHour;
	private String				txtBeforeOverTimeMin;
	private String				txtOverTimeUnitHour;
	private String				txtOverTimeUnitMin;
	private String				txtOverTimeIntervalHour;
	private String				txtOverTimeIntervalMin;
	private String				pltRoundNumber;
	private String				pltOverTime60Hour;
	private String				pltSubstituteHoliday;
	private String				pltSubstituteAmendment;
	private String				pltSubstitutePeriod;
	private String				pltSubstitutePriority;
	private String				pltHourHolidayFunction;
	private String				pltHourHolidayUnit;
	
	// v_EXg
	/**
	 * vZs
	 */
	public String[][]			aryPltProcess;
	/**
	 * WvΏی
	 */
	public String[][]			aryPltCalcMonth;
	/**
	 * xΏی
	 */
	public String[][]			aryPltProvidedMonth;
	/**
	 * ۂߏ
	 */
	public String[][]			aryPltRoundNumber;
	/**
	 * Pʎ
	 */
	public String[][]			aryPltHourUnit;
	/**
	 * xL
	 */
	public String[][]			aryPltSubHolidayPeriod;
	/**
	 * xD揇
	 */
	public String[][]			aryPltSubHolidayPriority;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_CALCULATION;
	/**
	 * 
	 */
	public String				NAM_PROVIDED;
	/**
	 * 
	 */
	public String				NAM_INPUT_UNIT_TIMES;
	/**
	 * 
	 */
	public String				NAM_AUTOMATIC_CALCULATION;
	/**
	 * 
	 */
	public String				NAM_VACATION_LEAVE;
	/**
	 * 
	 */
	public String				NAM_HOLIDAY_HOURS_ALL;
	/**
	 * 
	 */
	public String				NAM_HOLIDAY_HOURS_ALL_HOUR;
	/**
	 * 
	 */
	public String				NAM_HOLIDAY_HOURS_ALL_MIN;
	/**
	 * 
	 */
	public String				NAM_HOLIDAY_HOURS_HALF;
	/**
	 * 
	 */
	public String				NAM_HOLIDAY_HOURS_HALF_HOUR;
	/**
	 * 
	 */
	public String				NAM_HOLIDAY_HOURS_HALF_MIN;
	/**
	 * 
	 */
	public String				NAM_LATE_NIGHT_START;
	/**
	 * 
	 */
	public String				NAM_LATE_NIGHT_START_HOUR;
	/**
	 * 
	 */
	public String				NAM_LATE_NIGHT_START_MIN;
	/**
	 * 
	 */
	public String				NAM_LATE_NIGHT_HOURS;
	/**
	 * 
	 */
	public String				NAM_LATE_NIGHT_HOURS_HOUR;
	/**
	 * 
	 */
	public String				NAM_LATE_NIGHT_HOURS_MIN;
	/**
	 * 
	 */
	public String				NAM_PASSWORD_TERM;
	/**
	 * 
	 */
	public String				NAM_BEFORE_OVER_TIME;
	/**
	 * 
	 */
	public String				NAM_BEFORE_OVER_TIME_HOUR;
	/**
	 * 
	 */
	public String				NAM_BEFORE_OVER_TIME_MIN;
	/**
	 * 
	 */
	public String				NAM_OVER_TIME_UNIT;
	/**
	 * 
	 */
	public String				NAM_OVER_TIME_UNIT_HOUR;
	/**
	 * 
	 */
	public String				NAM_OVER_TIME_UNIT_MIN;
	/**
	 * 
	 */
	public String				NAM_OVER_TIME_INTERVAL;
	/**
	 * 
	 */
	public String				NAM_OVER_TIME_INTERVAL_HOUR;
	/**
	 * 
	 */
	public String				NAM_OVER_TIME_INTERVAL_MIN;
	/**
	 * 
	 */
	public String				NAM_ROUND_NUMBER;
	/**
	 * 
	 */
	public String				NAM_OVER_TIME_60_HOUR;
	/**
	 * 
	 */
	public String				NAM_SUBSTITUTE_HOLIDAY;
	/**
	 * 
	 */
	public String				NAM_SUBSTITUTE_AMENDMENT;
	/**
	 * 
	 */
	public String				NAM_SUBSTITUTE_PERIOD;
	/**
	 * 
	 */
	public String				NAM_SUBSTITUTE_PRIORITY;
	/**
	 * 
	 */
	public String				NAM_HOUR_PAID_HOLIDAY_FUNCTION;
	/**
	 * 
	 */
	public String				NAM_HOUR_PAID_HOLIDAY_UNIT;
	/**
	 * 
	 */
	public int					LEN_DAYS;
	/**
	 * 
	 */
	public int					LEN_TIME;
	/**
	 * 
	 */
	public String				REG_AUTOMATIC_CALCULATION;
	

	/**
	 * 
	 */
	public WorkSystemCardVo() {
		super();
		setViewPath(getClassName());
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_WORK_SYSTEM_DEFINE;
		createAryMenu(CMD_MENU_SYSTEM2);
	}
	
	@Override
	protected void setFieldsName() {
		NAM_CALCULATION = CommonConst.NAM_CONFIRM_ATTENDANCE + CommonConst.NAM_PERIOD_DATE;
		NAM_PROVIDED = CommonConst.NAM_CONFIRM_PAYMENT + CommonConst.NAM_PROVIDED_DATE;
		NAM_INPUT_UNIT_TIMES = CommonConst.NAM_COMMON_INPUT + CommonConst.NAM_UNIT;
		NAM_AUTOMATIC_CALCULATION = CommonConst.NAM_AUTOMATIC_CALCULATION;
		NAM_VACATION_LEAVE = CommonConst.NAM_VACATION_LEAVE + CommonConst.NAM_COMMON_TIME;
		NAM_HOLIDAY_HOURS_ALL = CommonConst.NAM_VACATION_LEAVE_ALL;
		NAM_HOLIDAY_HOURS_ALL_HOUR = NAM_HOLIDAY_HOURS_ALL + CommonConst.MSG_HOUR;
		NAM_HOLIDAY_HOURS_ALL_MIN = NAM_HOLIDAY_HOURS_ALL + CommonConst.MSG_MINUTES;
		NAM_HOLIDAY_HOURS_HALF = CommonConst.NAM_VACATION_LEAVE_HALF;
		NAM_HOLIDAY_HOURS_HALF_HOUR = NAM_HOLIDAY_HOURS_HALF + CommonConst.MSG_HOUR;
		NAM_HOLIDAY_HOURS_HALF_MIN = NAM_HOLIDAY_HOURS_HALF + CommonConst.MSG_MINUTES;
		NAM_LATE_NIGHT_START = CommonConst.NAM_LATE_NIGHT + CommonConst.NAM_START + CommonConst.NAM_TIME;
		NAM_LATE_NIGHT_START_HOUR = NAM_LATE_NIGHT_START + CommonConst.MSG_HOUR;
		NAM_LATE_NIGHT_START_MIN = NAM_LATE_NIGHT_START + CommonConst.MSG_MINUTES;
		NAM_LATE_NIGHT_HOURS = CommonConst.NAM_LATE_NIGHT + CommonConst.NAM_COMMON_TIME;
		NAM_LATE_NIGHT_HOURS_HOUR = NAM_LATE_NIGHT_HOURS + CommonConst.MSG_HOUR;
		NAM_LATE_NIGHT_HOURS_MIN = NAM_LATE_NIGHT_HOURS + CommonConst.MSG_MINUTES;
		NAM_PASSWORD_TERM = CommonConst.NAM_PASSWORD + CommonConst.NAM_PASSWORD_TERM;
		NAM_BEFORE_OVER_TIME = CommonConst.NAM_OVERTIME + CommonConst.NAM_BEFORE_START + CommonConst.NAM_INTERVAL_TIME
				+ CommonConst.NAM_COMMON_TIME;
		NAM_BEFORE_OVER_TIME_HOUR = NAM_BEFORE_OVER_TIME + CommonConst.MSG_HOUR;
		NAM_BEFORE_OVER_TIME_MIN = NAM_BEFORE_OVER_TIME + CommonConst.MSG_MINUTES;
		NAM_OVER_TIME_UNIT = CommonConst.NAM_OVER_TIME_UNIT_TIME;
		NAM_OVER_TIME_UNIT_HOUR = NAM_OVER_TIME_UNIT + CommonConst.MSG_HOUR;
		NAM_OVER_TIME_UNIT_MIN = NAM_OVER_TIME_UNIT + CommonConst.MSG_MINUTES;
		NAM_OVER_TIME_INTERVAL = CommonConst.NAM_OVER_TIME_INTERVAL + CommonConst.NAM_COMMON_TIME;
		NAM_OVER_TIME_INTERVAL_HOUR = NAM_OVER_TIME_INTERVAL + CommonConst.MSG_HOUR;
		NAM_OVER_TIME_INTERVAL_MIN = NAM_OVER_TIME_INTERVAL + CommonConst.MSG_MINUTES;
		NAM_ROUND_NUMBER = CommonConst.NAM_ROUND_NUMBER_PROCESS;
		NAM_OVER_TIME_60_HOUR = CommonConst.NAM_OVER_TIME_60_HOUR_FUNCTION;
		NAM_SUBSTITUTE_HOLIDAY = CommonConst.NAM_SUBSTITUTE_HOLIDAY_FUNCTION;
		NAM_SUBSTITUTE_AMENDMENT = "xC";
		NAM_SUBSTITUTE_PERIOD = "xL";
		NAM_SUBSTITUTE_PRIORITY = "xD揇";
		NAM_HOUR_PAID_HOLIDAY_FUNCTION = CommonConst.NAM_HOUR_PAID_HOLIDAY_FUNCTION;
		NAM_HOUR_PAID_HOLIDAY_UNIT = CommonConst.NAM_HOUR_PAID_HOLIDAY_UNIT;
		LEN_DAYS = 2;
		LEN_TIME = 2;
		REG_AUTOMATIC_CALCULATION = CommonConst.REG_DELETE;
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		pltCalcMonth = request.getParameter(PRM_PLT_CALCULATION_MONTH);
		txtCalcDays = request.getParameter(PRM_TXT_CALCULATION_DAYS);
		pltProvidedMonth = request.getParameter(PRM_PLT_PROVIDED_MONTH);
		txtProvidedDays = request.getParameter(PRM_TXT_PROVIDED_DAYS);
		txtInputUnit = request.getParameter(PRM_TXT_INPUT_UNIT_TIMES);
		pltAutoCalc = request.getParameter(PRM_PLT_AUTOMATIC_CALCULATION);
		pltCalcProcess = "";
		if (StringUtil.isFlagOff(pltAutoCalc)) {
			pltCalcProcess = request.getParameter(PRM_PLT_CALCULATION_PROCESS);
		}
		txtAllHolidayHour = request.getParameter(PRM_TXT_ALL_HOLIDAY_HOUR);
		txtAllHolidayMin = request.getParameter(PRM_TXT_ALL_HOLIDAY_MIN);
		txtHalfHolidayHour = request.getParameter(PRM_TXT_HALF_HOLIDAY_HOUR);
		txtHalfHolidayMin = request.getParameter(PRM_TXT_HALF_HOLIDAY_MIN);
		txtLateNightStartHour = request.getParameter(PRM_TXT_LATE_NIGHT_START_HOUR);
		txtLateNightStartMin = request.getParameter(PRM_TXT_LATE_NIGHT_START_MIN);
		txtLateNightTimeHour = request.getParameter(PRM_TXT_LATE_NIGHT_TIME_HOUR);
		txtLateNightTimeMin = request.getParameter(PRM_TXT_LATE_NIGHT_TIME_MIN);
		txtPasswordTerm = request.getParameter(PRM_TXT_PASSWORD_TERM);
		txtBeforeOverTimeHour = request.getParameter(PRM_TXT_BEFORE_OVER_TIME_HOUR);
		txtBeforeOverTimeMin = request.getParameter(PRM_TXT_BEFORE_OVER_TIME_MIN);
		txtOverTimeUnitHour = request.getParameter(PRM_TXT_OVER_TIME_UNIT_HOUR);
		txtOverTimeUnitMin = request.getParameter(PRM_TXT_OVER_TIME_UNIT_MIN);
		txtOverTimeIntervalHour = request.getParameter(PRM_TXT_OVER_TIME_INTERVAL_HOUR);
		txtOverTimeIntervalMin = request.getParameter(PRM_TXT_OVER_TIME_INTERVAL_MIN);
		pltRoundNumber = request.getParameter(PRM_PLT_ROUND_NUMBER);
		pltOverTime60Hour = request.getParameter(PRM_PLT_OVER_TIME_60_HOUR);
		pltSubstituteHoliday = CommonConst.NAM_COMMON_FLAG_ON;
		if (StringUtil.isFlagOff(pltOverTime60Hour)) {
			pltSubstituteHoliday = request.getParameter(PRM_PLT_SUBSTITUTE_HOLIDAY);
		}
		pltSubstituteAmendment = CommonConst.NAM_COMMON_FLAG_ON;
		/*
				if (StringUtil.isFlagOff(pltSubstituteHoliday)) {
					pltSubstituteAmendment = request.getParameter(PRM_PLT_SUBSTITUTE_AMENDMENT);
				}
		*/
		pltSubstitutePeriod = "";
		if (StringUtil.isFlagOff(pltSubstituteHoliday)) {
			pltSubstitutePeriod = request.getParameter(PRM_PLT_SUBSTITUTE_PERIOD);
		}
		pltSubstitutePriority = "";
		if (StringUtil.isFlagOff(pltSubstituteHoliday)) {
			pltSubstitutePriority = request.getParameter(PRM_PLT_SUBSTITUTE_PRIORITY);
		}
		pltHourHolidayFunction = request.getParameter(PRM_PLT_HOUR_HOLIDAY_FUNCTION);
		pltHourHolidayUnit = "";
		if (StringUtil.isFlagOff(pltHourHolidayFunction)) {
			pltHourHolidayUnit = request.getParameter(PRM_PLT_HOUR_HOLIDAY_UNIT);
		}
	}
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException MosPOꍇ
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(txtCalcDays, NAM_CALCULATION, PRM_TXT_CALCULATION_DAYS);
		checkRequired(txtProvidedDays, NAM_PROVIDED, PRM_TXT_PROVIDED_DAYS);
		checkRequired(txtInputUnit, NAM_INPUT_UNIT_TIMES, PRM_TXT_INPUT_UNIT_TIMES);
		checkRequired(txtAllHolidayHour, NAM_HOLIDAY_HOURS_ALL_HOUR, PRM_TXT_ALL_HOLIDAY_HOUR);
		checkRequired(txtAllHolidayMin, NAM_HOLIDAY_HOURS_ALL_MIN, PRM_TXT_ALL_HOLIDAY_MIN);
		checkRequired(txtHalfHolidayHour, NAM_HOLIDAY_HOURS_HALF_HOUR, PRM_TXT_HALF_HOLIDAY_HOUR);
		checkRequired(txtHalfHolidayMin, NAM_HOLIDAY_HOURS_HALF_MIN, PRM_TXT_HALF_HOLIDAY_MIN);
		checkRequired(txtLateNightStartHour, NAM_LATE_NIGHT_START_HOUR, PRM_TXT_LATE_NIGHT_START_HOUR);
		checkRequired(txtLateNightStartMin, NAM_LATE_NIGHT_START_MIN, PRM_TXT_LATE_NIGHT_START_MIN);
		checkRequired(txtLateNightTimeHour, NAM_LATE_NIGHT_HOURS_HOUR, PRM_TXT_LATE_NIGHT_TIME_HOUR);
		checkRequired(txtLateNightTimeMin, NAM_LATE_NIGHT_HOURS_MIN, PRM_TXT_LATE_NIGHT_TIME_MIN);
		checkRequired(txtPasswordTerm, NAM_PASSWORD_TERM, PRM_TXT_PASSWORD_TERM);
		checkRequired(txtBeforeOverTimeHour, NAM_BEFORE_OVER_TIME_HOUR, PRM_TXT_BEFORE_OVER_TIME_HOUR);
		checkRequired(txtBeforeOverTimeMin, NAM_BEFORE_OVER_TIME_MIN, PRM_TXT_BEFORE_OVER_TIME_MIN);
		checkRequired(txtOverTimeUnitHour, NAM_OVER_TIME_UNIT_HOUR, PRM_TXT_OVER_TIME_UNIT_HOUR);
		checkRequired(txtOverTimeUnitHour, NAM_OVER_TIME_UNIT_MIN, PRM_TXT_OVER_TIME_UNIT_MIN);
		checkRequired(txtOverTimeIntervalHour, NAM_OVER_TIME_INTERVAL_HOUR, PRM_TXT_OVER_TIME_INTERVAL_HOUR);
		checkRequired(txtOverTimeIntervalMin, NAM_OVER_TIME_INTERVAL_MIN, PRM_TXT_OVER_TIME_INTERVAL_MIN);
		// ^CvmF
		checkNumber(txtCalcDays, NAM_CALCULATION, PRM_TXT_CALCULATION_DAYS);
		checkNumber(txtProvidedDays, NAM_PROVIDED, PRM_TXT_PROVIDED_DAYS);
		checkNumber(txtInputUnit, NAM_INPUT_UNIT_TIMES, PRM_TXT_INPUT_UNIT_TIMES);
		checkNumber(txtAllHolidayHour, NAM_HOLIDAY_HOURS_ALL_HOUR, PRM_TXT_ALL_HOLIDAY_HOUR);
		checkNumber(txtAllHolidayMin, NAM_HOLIDAY_HOURS_ALL_MIN, PRM_TXT_ALL_HOLIDAY_MIN);
		checkNumber(txtHalfHolidayHour, NAM_HOLIDAY_HOURS_HALF_HOUR, PRM_TXT_HALF_HOLIDAY_HOUR);
		checkNumber(txtHalfHolidayMin, NAM_HOLIDAY_HOURS_HALF_MIN, PRM_TXT_HALF_HOLIDAY_MIN);
		checkNumber(txtLateNightStartHour, NAM_LATE_NIGHT_START_HOUR, PRM_TXT_LATE_NIGHT_START_HOUR);
		checkNumber(txtLateNightStartMin, NAM_LATE_NIGHT_START_MIN, PRM_TXT_LATE_NIGHT_START_MIN);
		checkNumber(txtLateNightTimeHour, NAM_LATE_NIGHT_HOURS_HOUR, PRM_TXT_LATE_NIGHT_TIME_HOUR);
		checkNumber(txtLateNightTimeMin, NAM_LATE_NIGHT_HOURS_MIN, PRM_TXT_LATE_NIGHT_TIME_MIN);
		checkNumber(txtPasswordTerm, NAM_PASSWORD_TERM, PRM_TXT_PASSWORD_TERM);
		checkNumber(txtBeforeOverTimeHour, NAM_BEFORE_OVER_TIME_HOUR, PRM_TXT_BEFORE_OVER_TIME_HOUR);
		checkNumber(txtBeforeOverTimeMin, NAM_BEFORE_OVER_TIME_MIN, PRM_TXT_BEFORE_OVER_TIME_MIN);
		checkNumber(txtOverTimeUnitHour, NAM_OVER_TIME_UNIT_HOUR, PRM_TXT_OVER_TIME_UNIT_HOUR);
		checkNumber(txtOverTimeUnitMin, NAM_OVER_TIME_UNIT_MIN, PRM_TXT_OVER_TIME_UNIT_MIN);
		checkNumber(txtOverTimeIntervalHour, NAM_OVER_TIME_INTERVAL_HOUR, PRM_TXT_OVER_TIME_INTERVAL_HOUR);
		checkNumber(txtOverTimeIntervalMin, NAM_OVER_TIME_INTERVAL_MIN, PRM_TXT_OVER_TIME_INTERVAL_MIN);
		// 񒷊mF
		checkLength(txtCalcDays, LEN_DAYS, NAM_CALCULATION, PRM_TXT_CALCULATION_DAYS);
		checkLength(txtProvidedDays, LEN_DAYS, NAM_PROVIDED, PRM_TXT_PROVIDED_DAYS);
		checkLength(txtInputUnit, LEN_TIME, NAM_INPUT_UNIT_TIMES, PRM_TXT_INPUT_UNIT_TIMES);
		checkLength(txtAllHolidayHour, LEN_TIME, NAM_HOLIDAY_HOURS_ALL_HOUR, PRM_TXT_ALL_HOLIDAY_HOUR);
		checkLength(txtAllHolidayMin, LEN_TIME, NAM_HOLIDAY_HOURS_ALL_MIN, PRM_TXT_ALL_HOLIDAY_MIN);
		checkLength(txtHalfHolidayHour, LEN_TIME, NAM_HOLIDAY_HOURS_HALF_HOUR, PRM_TXT_HALF_HOLIDAY_HOUR);
		checkLength(txtHalfHolidayMin, LEN_TIME, NAM_HOLIDAY_HOURS_HALF_MIN, PRM_TXT_HALF_HOLIDAY_MIN);
		checkLength(txtLateNightStartHour, LEN_TIME, NAM_LATE_NIGHT_START_HOUR, PRM_TXT_LATE_NIGHT_START_HOUR);
		checkLength(txtLateNightStartMin, LEN_TIME, NAM_LATE_NIGHT_START_MIN, PRM_TXT_LATE_NIGHT_START_MIN);
		checkLength(txtLateNightTimeHour, LEN_TIME, NAM_LATE_NIGHT_HOURS_HOUR, PRM_TXT_LATE_NIGHT_TIME_HOUR);
		checkLength(txtLateNightTimeMin, LEN_TIME, NAM_LATE_NIGHT_HOURS_MIN, PRM_TXT_LATE_NIGHT_TIME_MIN);
		checkLength(txtPasswordTerm, LEN_DAYS, NAM_PASSWORD_TERM, PRM_TXT_PASSWORD_TERM);
		// ÓmFI
		endValidation();
	}
	
	// ANZT\bh
	/**
	 * @return txtCalcDays
	 */
	public String getEscTxtCalcDays() {
		return escapeHTML(txtCalcDays);
	}
	
	/**
	 * @return txtProvidedDays
	 */
	public String getEscTxtProvidedDays() {
		return escapeHTML(txtProvidedDays);
	}
	
	/**
	 * @return txtInputUnit
	 */
	public String getEscTxtInputUnit() {
		return escapeHTML(txtInputUnit);
	}
	
	/**
	 * @return txtAllHolidayHour
	 */
	public String getEscTxtAllHolidayHour() {
		return escapeHTML(txtAllHolidayHour);
	}
	
	/**
	 * @return txtAllHolidayMin
	 */
	public String getEscTxtAllHolidayMin() {
		return escapeHTML(txtAllHolidayMin);
	}
	
	/**
	 * @return txtHalfHolidayHour
	 */
	public String getEscTxtHalfHolidayHour() {
		return escapeHTML(txtHalfHolidayHour);
	}
	
	/**
	 * @return txtHalfHolidayMin
	 */
	public String getEscTxtHalfHolidayMin() {
		return escapeHTML(txtHalfHolidayMin);
	}
	
	/**
	 * @return txtLateNightStartHour
	 */
	public String getEscTxtLateNightStartHour() {
		return escapeHTML(txtLateNightStartHour);
	}
	
	/**
	 * @return txtLateNightStartMin
	 */
	public String getEscTxtLateNightStartMin() {
		return escapeHTML(txtLateNightStartMin);
	}
	
	/**
	 * @return txtLateNightTimeHour
	 */
	public String getEscTxtLateNightTimeHour() {
		return escapeHTML(txtLateNightTimeHour);
	}
	
	/**
	 * @return txtLateNightTimeMin
	 */
	public String getEscTxtLateNightTimeMin() {
		return escapeHTML(txtLateNightTimeMin);
	}
	
	/**
	 * @return txtPasswordTerm
	 */
	public String getEscTxtPasswordTerm() {
		return escapeHTML(txtPasswordTerm);
	}
	
	/**
	 * @return txtBeforeOverTimeHour
	 */
	public String getEscTxtBeforeOverTimeHour() {
		return escapeHTML(txtBeforeOverTimeHour);
	}
	
	/**
	 * @return txtBeforeOverTimeMin
	 */
	public String getEscTxtBeforeOverTimeMin() {
		return escapeHTML(txtBeforeOverTimeMin);
	}
	
	/**
	 * @return txtOverTimeUnitHour
	 */
	public String getEscTxtOverTimeUnitHour() {
		return escapeHTML(txtOverTimeUnitHour);
	}
	
	/**
	 * @return txtOverTimeUnitMin
	 */
	public String getEscTxtOverTimeUnitMin() {
		return escapeHTML(txtOverTimeUnitMin);
	}
	
	/**
	 * @return txtOverTimeIntervalHour
	 */
	public String getEscTxtOverTimeIntervalHour() {
		return escapeHTML(txtOverTimeIntervalHour);
	}
	
	/**
	 * @return txtOverTimeIntervalMin
	 */
	public String getEscTxtOverTimeIntervalMin() {
		return escapeHTML(txtOverTimeIntervalMin);
	}
	
	/**
	 * @return pltCalcMonth
	 */
	public String getPltCalcMonth() {
		return pltCalcMonth;
	}
	
	/**
	 * @return txtCalcDays
	 */
	public String getTxtCalcDays() {
		return txtCalcDays;
	}
	
	/**
	 * @return pltProvidedMonth
	 */
	public String getPltProvidedMonth() {
		return pltProvidedMonth;
	}
	
	/**
	 * @return txtProvidedDays
	 */
	public String getTxtProvidedDays() {
		return txtProvidedDays;
	}
	
	/**
	 * @return txtInputUnit
	 */
	public String getTxtInputUnit() {
		return txtInputUnit;
	}
	
	/**
	 * @return pltAutoCalc
	 */
	public String getPltAutoCalc() {
		return pltAutoCalc;
	}
	
	/**
	 * @return pltCalcProcess
	 */
	public String getPltCalcProcess() {
		return pltCalcProcess;
	}
	
	/**
	 * @return txtAllHolidayHour
	 */
	public String getTxtAllHolidayHour() {
		return txtAllHolidayHour;
	}
	
	/**
	 * @return txtAllHolidayMin
	 */
	public String getTxtAllHolidayMin() {
		return txtAllHolidayMin;
	}
	
	/**
	 * @return txtHalfHolidayHour
	 */
	public String getTxtHalfHolidayHour() {
		return txtHalfHolidayHour;
	}
	
	/**
	 * @return txtHalfHolidayMin
	 */
	public String getTxtHalfHolidayMin() {
		return txtHalfHolidayMin;
	}
	
	/**
	 * @return txtLateNightStartHour
	 */
	public String getTxtLateNightStartHour() {
		return txtLateNightStartHour;
	}
	
	/**
	 * @return txtLateNightStartMin
	 */
	public String getTxtLateNightStartMin() {
		return txtLateNightStartMin;
	}
	
	/**
	 * @return txtLateNightTimeHour
	 */
	public String getTxtLateNightTimeHour() {
		return txtLateNightTimeHour;
	}
	
	/**
	 * @return txtLateNightTimeMin
	 */
	public String getTxtLateNightTimeMin() {
		return txtLateNightTimeMin;
	}
	
	/**
	 * @return txtPasswordTerm
	 */
	public String getTxtPasswordTerm() {
		return txtPasswordTerm;
	}
	
	/**
	 * @return txtBeforeOverTimeHour
	 */
	public String getTxtBeforeOverTimeHour() {
		return txtBeforeOverTimeHour;
	}
	
	/**
	 * @return txtBeforeOverTimeMin
	 */
	public String getTxtBeforeOverTimeMin() {
		return txtBeforeOverTimeMin;
	}
	
	/**
	 * @return txtOverTimeUnitHour
	 */
	public String getTxtOverTimeUnitHour() {
		return txtOverTimeUnitHour;
	}
	
	/**
	 * @return txtOverTimeUnitMin
	 */
	public String getTxtOverTimeUnitMin() {
		return txtOverTimeUnitMin;
	}
	
	/**
	 * @return txtOverTimeIntervalHour
	 */
	public String getTxtOverTimeIntervalHour() {
		return txtOverTimeIntervalHour;
	}
	
	/**
	 * @return txtOverTimeIntervalMin
	 */
	public String getTxtOverTimeIntervalMin() {
		return txtOverTimeIntervalMin;
	}
	
	/**
	 * @return pltRoundNumber
	 */
	public String getPltRoundNumber() {
		return pltRoundNumber;
	}
	
	/**
	 * @return pltOverTime60Hour
	 */
	public String getPltOverTime60Hour() {
		return pltOverTime60Hour;
	}
	
	/**
	 * @return pltSubstituteHoliday
	 */
	public String getPltSubstituteHoliday() {
		return pltSubstituteHoliday;
	}
	
	/**
	 * @return pltSubstituteAmendment
	 */
	public String getPltSubstituteAmendment() {
		return pltSubstituteAmendment;
	}
	
	/**
	 * @return pltHourHolidayFunction
	 */
	public String getPltHourHolidayFunction() {
		return pltHourHolidayFunction;
	}
	
	/**
	 * @return pltHourHolidayUnit
	 */
	public String getPltHourHolidayUnit() {
		return pltHourHolidayUnit;
	}
	
	/**
	 * @param pltCalcMonth Zbg pltCalcMonth
	 */
	public void setPltCalcMonth(String pltCalcMonth) {
		this.pltCalcMonth = pltCalcMonth;
	}
	
	/**
	 * @param txtCalcDays Zbg txtCalcDays
	 */
	public void setTxtCalcDays(String txtCalcDays) {
		this.txtCalcDays = txtCalcDays;
	}
	
	/**
	 * @param pltProvidedMonth Zbg pltProvidedMonth
	 */
	public void setPltProvidedMonth(String pltProvidedMonth) {
		this.pltProvidedMonth = pltProvidedMonth;
	}
	
	/**
	 * @param txtProvidedDays Zbg txtProvidedDays
	 */
	public void setTxtProvidedDays(String txtProvidedDays) {
		this.txtProvidedDays = txtProvidedDays;
	}
	
	/**
	 * @param txtInputUnit Zbg txtInputUnit
	 */
	public void setTxtInputUnit(String txtInputUnit) {
		this.txtInputUnit = txtInputUnit;
	}
	
	/**
	 * @param pltAutoCalc Zbg pltAutoCalc
	 */
	public void setPltAutoCalc(String pltAutoCalc) {
		this.pltAutoCalc = pltAutoCalc;
	}
	
	/**
	 * @param pltCalcProcess Zbg pltProcess
	 */
	public void setPltCalcProcess(String pltCalcProcess) {
		this.pltCalcProcess = pltCalcProcess;
	}
	
	/**
	 * @param txtAllHolidayHour Zbg txtAllHolidayHour
	 */
	public void setTxtAllHolidayHour(String txtAllHolidayHour) {
		this.txtAllHolidayHour = txtAllHolidayHour;
	}
	
	/**
	 * @param txtAllHolidayMin Zbg txtAllHolidayMin
	 */
	public void setTxtAllHolidayMin(String txtAllHolidayMin) {
		this.txtAllHolidayMin = txtAllHolidayMin;
	}
	
	/**
	 * @param txtHalfHolidayHour Zbg txtHalfHolidayHour
	 */
	public void setTxtHalfHolidayHour(String txtHalfHolidayHour) {
		this.txtHalfHolidayHour = txtHalfHolidayHour;
	}
	
	/**
	 * @param txtHalfHolidayMin Zbg txtHalfHolidayMin
	 */
	public void setTxtHalfHolidayMin(String txtHalfHolidayMin) {
		this.txtHalfHolidayMin = txtHalfHolidayMin;
	}
	
	/**
	 * @param txtLateNightStartHour Zbg txtLateNightStartHour
	 */
	public void setTxtLateNightStartHour(String txtLateNightStartHour) {
		this.txtLateNightStartHour = txtLateNightStartHour;
	}
	
	/**
	 * @param txtLateNightStartMin Zbg txtLateNightStartMin
	 */
	public void setTxtLateNightStartMin(String txtLateNightStartMin) {
		this.txtLateNightStartMin = txtLateNightStartMin;
	}
	
	/**
	 * @param txtLateNightTimeHour Zbg txtLateNightTimeHour
	 */
	public void setTxtLateNightTimeHour(String txtLateNightTimeHour) {
		this.txtLateNightTimeHour = txtLateNightTimeHour;
	}
	
	/**
	 * @param txtLateNightTimeMin Zbg txtLateNightTimeMin
	 */
	public void setTxtLateNightTimeMin(String txtLateNightTimeMin) {
		this.txtLateNightTimeMin = txtLateNightTimeMin;
	}
	
	/**
	 * @param txtPasswordTerm Zbg txtPasswordTerm
	 */
	public void setTxtPasswordTerm(String txtPasswordTerm) {
		this.txtPasswordTerm = txtPasswordTerm;
	}
	
	/**
	 * @param txtBeforeOverTimeHour Zbg txtBeforeOverTimeHour
	 */
	public void setTxtBeforeOverTimeHour(String txtBeforeOverTimeHour) {
		this.txtBeforeOverTimeHour = txtBeforeOverTimeHour;
	}
	
	/**
	 * @param txtBeforeOverTimeMin Zbg txtBeforeOverTimeMin
	 */
	public void setTxtBeforeOverTimeMin(String txtBeforeOverTimeMin) {
		this.txtBeforeOverTimeMin = txtBeforeOverTimeMin;
	}
	
	/**
	 * @param txtOverTimeUnitHour Zbg txtOverTimeUnitHour
	 */
	public void setTxtOverTimeUnitHour(String txtOverTimeUnitHour) {
		this.txtOverTimeUnitHour = txtOverTimeUnitHour;
	}
	
	/**
	 * @param txtOverTimeUnitMin Zbg txtOverTimeUnitMin
	 */
	public void setTxtOverTimeUnitMin(String txtOverTimeUnitMin) {
		this.txtOverTimeUnitMin = txtOverTimeUnitMin;
	}
	
	/**
	 * @param txtOverTimeIntervalHour Zbg txtOverTimeIntervalHour
	 */
	public void setTxtOverTimeIntervalHour(String txtOverTimeIntervalHour) {
		this.txtOverTimeIntervalHour = txtOverTimeIntervalHour;
	}
	
	/**
	 * @param txtOverTimeIntervalMin Zbg txtOverTimeIntervalMin
	 */
	public void setTxtOverTimeIntervalMin(String txtOverTimeIntervalMin) {
		this.txtOverTimeIntervalMin = txtOverTimeIntervalMin;
	}
	
	/**
	 * @param pltRoundNumber Zbg pltRoundNumber
	 */
	public void setPltRoundNumber(String pltRoundNumber) {
		this.pltRoundNumber = pltRoundNumber;
	}
	
	/**
	 * @param pltOverTime60Hour Zbg pltOverTime60Hour
	 */
	public void setPltOverTime60Hour(String pltOverTime60Hour) {
		this.pltOverTime60Hour = pltOverTime60Hour;
	}
	
	/**
	 * @param pltSubstituteHoliday Zbg pltSubstituteHoliday
	 */
	public void setPltSubstituteHoliday(String pltSubstituteHoliday) {
		this.pltSubstituteHoliday = pltSubstituteHoliday;
	}
	
	/**
	 * @param pltSubstituteAmendment Zbg pltSubstituteAmendment
	 */
	public void setPltSubstituteAmendment(String pltSubstituteAmendment) {
		this.pltSubstituteAmendment = pltSubstituteAmendment;
	}
	
	/**
	 * @param pltHourHolidayFunction Zbg pltHourHolidayFunction
	 */
	public void setPltHourHolidayFunction(String pltHourHolidayFunction) {
		this.pltHourHolidayFunction = pltHourHolidayFunction;
	}
	
	/**
	 * @param pltHourHolidayUnit Zbg pltHourHolidayUnit
	 */
	public void setPltHourHolidayUnit(String pltHourHolidayUnit) {
		this.pltHourHolidayUnit = pltHourHolidayUnit;
	}
	
	/**
	 * @param pltSubstitutePeriod Zbg pltSubstitutePeriod
	 */
	public void setPltSubstitutePeriod(String pltSubstitutePeriod) {
		this.pltSubstitutePeriod = pltSubstitutePeriod;
	}
	
	/**
	 * @return pltSubstitutePeriod
	 */
	public String getPltSubstitutePeriod() {
		return pltSubstitutePeriod;
	}
	
	/**
	 * @param pltSubstitutePriority Zbg pltSubstitutePriority
	 */
	public void setPltSubstitutePriority(String pltSubstitutePriority) {
		this.pltSubstitutePriority = pltSubstitutePriority;
	}
	
	/**
	 * @return pltSubstitutePriority
	 */
	public String getPltSubstitutePriority() {
		return pltSubstitutePriority;
	}
	
}
