/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.system.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dto.MCodeDto;
import jp.mosp.common.utils.StringUtil;

/**
 * @author yoshida
 *
 */
public class LeaveReasonCardVo extends MosPVo {
	
	private static final long	serialVersionUID		= 7587659669223985261L;
	
	// p[^
	/**
	 * txtLeaveReason
	 */
	public static final String	PRM_TXT_LEAVE_REASON	= "txtLeaveReason";
	
	// tB[h
	private String[]			aryLeaveReason;
	private String[]			aryTxtLeaveReason;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_LEAVE_REASON;
	/**
	 * 
	 */
	public int					LEN_REASON;
	

	/**
	 * RXgN^
	 */
	public LeaveReasonCardVo() {
		super();
		setViewPath(getClassName());
		aryLeaveReason = new String[0];
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_LEAVE_REASON;
		createAryMenu(CMD_MENU_SYSTEM2, MosPMenuConst.getMenuReasonMaster());
	}
	
	@Override
	protected void setFieldsName() {
		NAM_LEAVE_REASON = CommonConst.NAM_VACATION_LEAVE + CommonConst.NAM_REASON;
		LEN_REASON = 15;
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		aryTxtLeaveReason = request.getParameterValues(PRM_TXT_LEAVE_REASON);
	}
	
	/**
	 * tB[hݒ
	 * @param listLeave		xɗRXg
	 */
	public void setFieldsLeaveReason(List<?> listLeave) {
		// z̏
		aryLeaveReason = StringUtil.getBlankArrayOneDimension(10);
		// f[^̐ݒ
		int i = 0;
		Iterator<?> it = listLeave.iterator();
		while (it.hasNext()) {
			MCodeDto dto = (MCodeDto)it.next();
			aryLeaveReason[i] = escapeHTML(dto.getTName());
			i++;
		}
	}
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException MosPOꍇ
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		int i = 0;
		for (String reason : aryTxtLeaveReason) {
			// 񒷊mF
			checkLength(reason, LEN_REASON, NAM_LEAVE_REASON, PRM_TXT_LEAVE_REASON + i);
		}
		// ÓmFI
		endValidation();
	}
	
	// ANZT\bh
	/**
	 * @return aryLeaveReason
	 */
	public String[] getAryLeaveReason() {
		return aryLeaveReason.clone();
	}
	
	/**
	 * @return aryTxtLeaveReason
	 */
	public String[] getAryTxtLeaveReason() {
		return aryTxtLeaveReason.clone();
	}
	
	/**
	 * @param aryLeaveReason Zbg aryLeaveReason
	 */
	public void setAryLeaveReason(String[] aryLeaveReason) {
		this.aryLeaveReason = aryLeaveReason.clone();
	}
	
	/**
	 * @param aryTxtLeaveReason Zbg aryTxtLeaveReason
	 */
	public void setAryTxtLeaveReason(String[] aryTxtLeaveReason) {
		this.aryTxtLeaveReason = aryTxtLeaveReason.clone();
	}
	
}
