/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.system.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.dto.MCodeDto;

/**
 * @author yoshida
 *
 */
public class CodeMasterListVo extends MosPVo {
	
	private static final long	serialVersionUID	= -6348454372992171132L;
	
	// 萔
	/**
	 * 
	 */
	public static final int		SEARCH_OFF			= 0;
	/**
	 * 
	 */
	public static final int		SEARCH_ON			= 1;
	
	// p[^
	/**
	 * 
	 */
	public static final String	PRM_PLT_T_ID		= "pltTId";
	/**
	 * 
	 */
	public static final String	PRM_TXT_T_CODE		= "txtTCode";
	/**
	 * 
	 */
	public static final String	PRM_TXT_T_NAME		= "txtTName";
	/**
	 * 
	 */
	public static final String	PRM_TXT_T_CHANGE	= "txtTChange";
	
	// tB[h
	private String[]			aryTId;
	private String[]			aryTCode;
	private String[]			aryTName;
	private String[]			aryTChange;
	private String				pltTId;
	private String				txtTCode;
	private String				txtTName;
	private String				txtTChange;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_CODE_ID;
	/**
	 * 
	 */
	public String				NAM_CODE;
	/**
	 * 
	 */
	public String				NAM_NAME;
	/**
	 * 
	 */
	public String				NAM_CHANGE;									//ϊ
	/**
	 * 
	 */
	public int					LEN_CODE_ID;
	/**
	 * 
	 */
	public int					LEN_CODE;
	/**
	 * 
	 */
	public int					LEN_NAME;
	/**
	 * 
	 */
	public int					LEN_CHANGE;
	
	// \[gL[
	/**
	 * 
	 */
	public final String			KEY_T_ID			= "keyTId";
	/**
	 * 
	 */
	public final String			KEY_T_CODE			= "keyTCode";
	/**
	 * 
	 */
	public final String			KEY_T_NAME			= "keyTName";
	
	// v_EXg
	/**
	 * 
	 */
	public String[][]			aryPltTId;
	
	// [h(0FȂA1F)
	private int					searchmode;
	

	/**
	 * 
	 */
	public CodeMasterListVo() {
		super();
		setViewPath(getClassName());
		pltTId = "";
		txtTCode = "";
		txtTName = "";
		txtTChange = "";
		aryTId = new String[0];
		aryTCode = new String[0];
		aryTName = new String[0];
		aryTChange = new String[0];
		setFormerKey(KEY_T_ID);
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_CODE_MASTER;
		aryMenu = new String[][]{ { CMD_MENU_SYSTEM2, CommonConst.NAM_TO_MENU } };
	}
	
	@Override
	protected void setFieldsName() {
		NAM_CODE_ID = CommonConst.NAM_TABLE;
		NAM_CODE = CommonConst.NAM_COMMON_CODE;
		NAM_NAME = CommonConst.NAM_COMMON_MEISYO;
		NAM_CHANGE = CommonConst.NAM_CONVERSION; // ϊ
		LEN_CODE_ID = 50;
		LEN_CODE = 9;
		LEN_NAME = 25;
		LEN_CHANGE = 25;
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		pltTId = request.getParameter(PRM_PLT_T_ID);
		txtTCode = request.getParameter(PRM_TXT_T_CODE);
		txtTName = request.getParameter(PRM_TXT_T_NAME);
		txtTChange = request.getParameter(PRM_TXT_T_CHANGE);
	}
	
	@Override
	public void setFields(List<?> listCode) {
		// Xg̐ݒ
		list = listCode;
		// f[^̎擾
		count = listCode.size();
		// z̏
		aryTId = new String[count];
		aryTCode = new String[count];
		aryTName = new String[count];
		aryTChange = new String[count];
		// f[^̐ݒ
		int i = 0;
		Iterator<?> it = listCode.iterator();
		while (it.hasNext()) {
			MCodeDto dto = (MCodeDto)it.next();
			aryTId[i] = escapeHTML(dto.getTId());
			aryTCode[i] = escapeHTML(dto.getTCode());
			aryTName[i] = escapeHTML(dto.getTName());
			aryTChange[i] = escapeHTML(dto.getTChange());
			i++;
		}
	}
	
	/**
	 * @return aryTId
	 */
	public String[] getAryTId() {
		return aryTId.clone();
	}
	
	/**
	 * @return aryTCode
	 */
	public String[] getAryTCode() {
		return aryTCode.clone();
	}
	
	/**
	 * @return aryTName
	 */
	public String[] getAryTName() {
		return aryTName.clone();
	}
	
	/**
	 * @return aryTChange
	 */
	public String[] getAryTChange() {
		return aryTChange.clone();
	}
	
	/**
	 * @return pltTId
	 */
	public String getPltTId() {
		return pltTId;
	}
	
	/**
	 * @return txtTCode
	 */
	public String getTxtTCode() {
		return txtTCode;
	}
	
	/**
	 * @return txtTName
	 */
	public String getTxtTName() {
		return txtTName;
	}
	
	/**
	 * @return txtTChange
	 */
	public String getTxtTChange() {
		return txtTChange;
	}
	
	/**
	 * @return searchmode
	 */
	public int getSearchmode() {
		return searchmode;
	}
	
	/**
	 * @param aryTId Zbg aryTId
	 */
	public void setAryTId(String[] aryTId) {
		this.aryTId = aryTId.clone();
	}
	
	/**
	 * @param aryTCode Zbg aryTCode
	 */
	public void setAryTCode(String[] aryTCode) {
		this.aryTCode = aryTCode.clone();
	}
	
	/**
	 * @param aryTName Zbg aryTName
	 */
	public void setAryTName(String[] aryTName) {
		this.aryTName = aryTName.clone();
	}
	
	/**
	 * @param aryTChange Zbg aryTChange
	 */
	public void setAryTChange(String[] aryTChange) {
		this.aryTChange = aryTChange.clone();
	}
	
	/**
	 * @param pltTId Zbg pltTId
	 */
	public void setPltTId(String pltTId) {
		this.pltTId = pltTId;
	}
	
	/**
	 * @param txtTCode Zbg txtTCode
	 */
	public void setTxtTCode(String txtTCode) {
		this.txtTCode = txtTCode;
	}
	
	/**
	 * @param txtTName Zbg txtTName
	 */
	public void setTxtTName(String txtTName) {
		this.txtTName = txtTName;
	}
	
	/**
	 * @param txtTChange Zbg txtTChange
	 */
	public void setTxtTChange(String txtTChange) {
		this.txtTChange = txtTChange;
	}
	
	/**
	 * @param searchmode Zbg searchmode
	 */
	public void setSearchmode(int searchmode) {
		this.searchmode = searchmode;
	}
	
}
