/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.system.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dto.MCodeDto;

/**
 * @author yoshida
 *
 */
public class CodeMasterCardVo extends MosPVo {
	
	private static final long	serialVersionUID	= 7743759495787416910L;
	
	// 萔
	/**
	 * 
	 */
	public static final int		MODE_INSERT			= 0;
	/**
	 * 
	 */
	public static final int		MODE_UPDATE			= 1;
	/**
	 * 
	 */
	public static final int		MODE_SYSTEM			= 2;
	
	// p[^
	/**
	 * 
	 */
	public static final String	PRM_PLT_T_ID		= "pltTId";
	/**
	 * 
	 */
	public static final String	PRM_TXT_T_CODE		= "txtTCode";
	/**
	 * 
	 */
	public static final String	PRM_TXT_T_NAME		= "txtTName";
	/**
	 * 
	 */
	public static final String	PRM_TXT_T_CHANGE	= "txtTChange";
	
	// tB[h
	private String				pltTId;
	private String				txtTCode;
	private String				txtTName;
	private String				txtTChange;
	
	// v_EXg
	/**
	 * 
	 */
	public String[][]			aryPltTId;
	
	// [h(0FVKo^A1FXVA2F폜)
	private int					mode;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_CODE_ID;
	/**
	 * 
	 */
	public String				NAM_CODE;
	/**
	 * 
	 */
	public String				NAM_NAME;
	/**
	 * 
	 */
	public String				NAM_CHANGE;								//ϊ
	/**
	 * 
	 */
	public int					LEN_CODE;
	/**
	 * 
	 */
	public int					LEN_NAME;
	/**
	 * 
	 */
	public int					LEN_CHANGE;
	

	/**
	 * RXgN^
	 */
	public CodeMasterCardVo() {
		super();
		mode = MODE_INSERT;
		setViewPath(getClassName());
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_CODE_MASTER;
		aryMenu = new String[][]{ { CMD_MENU_SYSTEM2, CommonConst.NAM_TO_MENU } };
	}
	
	@Override
	protected void setFieldsName() {
		NAM_CODE_ID = CommonConst.NAM_TABLE;
		NAM_CODE = CommonConst.NAM_COMMON_CODE;
		NAM_NAME = CommonConst.NAM_COMMON_MEISYO;
		NAM_CHANGE = CommonConst.NAM_CONVERSION; //ϊ
		LEN_CODE = 9;
		LEN_NAME = 25;
		LEN_CHANGE = 25;
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		pltTId = request.getParameter(PRM_PLT_T_ID);
		txtTCode = request.getParameter(PRM_TXT_T_CODE);
		txtTName = request.getParameter(PRM_TXT_T_NAME);
		txtTChange = request.getParameter(PRM_TXT_T_CHANGE);
	}
	
	/**
	 * tB[hݒ
	 * @param dto [U[Xg
	 */
	public void setFields(MCodeDto dto) {
		// f[^̐ݒ
		pltTId = dto.getTId();
		txtTCode = dto.getTCode();
		txtTName = dto.getTName();
		txtTChange = dto.getTChange();
	}
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException MosPOꍇ
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(pltTId, NAM_CODE_ID, PRM_PLT_T_ID);
		checkRequired(txtTCode, NAM_CODE, PRM_TXT_T_CODE);
		// 񒷊mF
		checkLength(txtTCode, LEN_CODE, NAM_CODE, PRM_TXT_T_CODE);
		checkLength(txtTName, LEN_NAME, NAM_NAME, PRM_TXT_T_NAME);
		checkLength(txtTChange, LEN_CHANGE, NAM_CHANGE, PRM_TXT_T_CHANGE);
		// ÓmFI
		endValidation();
	}
	
	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFields(MCodeDto dto) {
		dto.setTId(pltTId);
		dto.setTCode(txtTCode);
		dto.setTName(txtTName);
		dto.setTChange(txtTChange);
	}
	
	@Override
	public String getDirectJs(Class<?> cls, Object obj) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls, obj));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}
	
	/**
	 * @return pltTId
	 */
	public String getPltTId() {
		return pltTId;
	}
	
	/**
	 * @return txtTCode
	 */
	public String getTxtTCode() {
		return txtTCode;
	}
	
	/**
	 * @return txtTName
	 */
	public String getTxtTName() {
		return txtTName;
	}
	
	/**
	 * @return txtTChange
	 */
	public String getTxtTChange() {
		return txtTChange;
	}
	
	/**
	 * @return mode
	 */
	public int getMode() {
		return mode;
	}
	
	/**
	 * @param pltTId Zbg pltTId
	 */
	public void setPltTId(String pltTId) {
		this.pltTId = pltTId;
	}
	
	/**
	 * @param txtTCode Zbg txtTCode
	 */
	public void setTxtTCode(String txtTCode) {
		this.txtTCode = txtTCode;
	}
	
	/**
	 * @param txtTName Zbg txtTName
	 */
	public void setTxtTName(String txtTName) {
		this.txtTName = txtTName;
	}
	
	/**
	 * @param txtTChange Zbg txtTChange
	 */
	public void setTxtTChange(String txtTChange) {
		this.txtTChange = txtTChange;
	}
	
	/**
	 * @param mode Zbg mode
	 */
	public void setMode(int mode) {
		this.mode = mode;
	}
	
}
