/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.system.action;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.kintai.common.action.KintaiCommonAction;
import jp.mosp.kintai.common.dao.MYakusyokuDao;
import jp.mosp.kintai.common.dto.MYakusyokuDto;
import jp.mosp.kintai.system.vo.YakusyokuMasterCardVo;

/**
 * @author yoshida
 *
 */
public class YakusyokuMasterCardAction extends KintaiCommonAction {
	
	// R}h
	private static final String	CMD_YAKUSYOKU_MASTER_CARD_SHOW		= "S2205";	// \(ǉ)
	private static final String	CMD_YAKUSYOKU_MASTER_CARD_SELECT	= "S2206";	// \(I)
	private static final String	CMD_YAKUSYOKU_MASTER_CARD_INSERT	= "S2207";	// o^
	private static final String	CMD_YAKUSYOKU_MASTER_CARD_UPDATE	= "S2208";	// XV
	private static final String	CMD_YAKUSYOKU_MASTER_CARD_DELETE	= "S2209";	// 폜
																				
	
	/**
	 * RXgN^
	 */
	public YakusyokuMasterCardAction() {
		super();
	}
	
	public void action() throws Exception {
		// VO̎擾yѐݒ
		prepareVo();
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_YAKUSYOKU_MASTER_CARD_SHOW)) {
			// \
			show();
		} else if (cmd.equals(CMD_YAKUSYOKU_MASTER_CARD_SELECT)) {
			// \(L[ŏ)
			select();
		} else if (cmd.equals(CMD_YAKUSYOKU_MASTER_CARD_INSERT)) {
			// VKo^
			insert();
		} else if (cmd.equals(CMD_YAKUSYOKU_MASTER_CARD_UPDATE)) {
			// XV
			update();
		} else if (cmd.equals(CMD_YAKUSYOKU_MASTER_CARD_DELETE)) {
			// 폜
			delete();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new YakusyokuMasterCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		// DBRlNV擾
		getConnection();
		// SYSTEMmF
		confirmSystemAuth();
		YakusyokuMasterCardVo vo = (YakusyokuMasterCardVo)getVo();
		// 敪v_EXg쐬
		vo.aryPltTokyu = getMosPCodeArray(CommonConst.TID_GRADE);
		// E蓖敪v_EXgiL{^Pj쐬
		vo.aryPltExistence1 = VariousUtil.getPositionAllowanceType1();
		// E蓖敪v_EXgiL{ŒPj쐬
		vo.aryPltExistence2 = VariousUtil.getPositionAllowanceType2();
		// E蓖敪v_EXgiL{^P{ŒPj쐬
		vo.aryPltExistence3 = VariousUtil.getPositionAllowanceType3();
		// 蓖̃Xg쐬
		vo.setAryAllowance(getMosPCodeArray(CommonConst.TID_ALLOWANCE_NAME));
	}
	
	@Override
	protected void show() {
		YakusyokuMasterCardVo vo = (YakusyokuMasterCardVo)getVo();
		vo.setDefaultValues();
		vo.setMode(YakusyokuMasterCardVo.MODE_INSERT);
	}
	
	@Override
	protected void select() throws Exception {
		YakusyokuMasterCardVo vo = (YakusyokuMasterCardVo)getVo();
		// f[^̎擾
		MYakusyokuDto dto = part().position().getPositionInfo(key1, key2);
		chkExist(dto);
		// VOɏZbg
		vo.setFields(dto);
		setMode();
		// ZbVDTOZbg
		setSessionDto(dto);
	}
	
	@Override
	protected void insert() throws Exception {
		YakusyokuMasterCardVo vo = (YakusyokuMasterCardVo)getVo();
		vo.setParams(request);
		// p[^̑ÓmF
		vo.validate();
		// DAȌ
		MYakusyokuDao dao = part().position().getMYakusyokuDao();
		// DTȌ
		MYakusyokuDto dto = new MYakusyokuDto();
		vo.setDtoFields(dto);
		// ݃`FbN
		chkDuplicate(dao.findForKey(dto.getYcode(), dto.getTokyu()));
		// f[^̑}
		dao.insert(dto);
		// DTO̍Ď擾
		MYakusyokuDto retDto = dao.findForKey(dto.getYcode(), dto.getTokyu());
		chkInsert(retDto);
		// ݂̑mF
		if (!chkExistDto(dao.findForKey(dto.getYcode(), CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE))) {
			MYakusyokuDto nonGradeDto = dto;
			nonGradeDto.setTokyu(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
			// f[^̑}		
			dao.insert(nonGradeDto);
			// DTO̍Ď擾
			nonGradeDto = dao.findForKey(nonGradeDto.getYcode(), nonGradeDto.getTokyu());
			chkInsert(nonGradeDto);
		}
		// R~bg
		commit();
		// [hݒ
		setMode();
		// bZ[Wݒ
		vo.setMessage(getMessage(MospConst.MSG_INSERT, ""));
		// ZbVDTOZbg
		setSessionDto(retDto);
	}
	
	@Override
	protected void update() throws Exception {
		// DTO̎擾
		MYakusyokuDto dto = (MYakusyokuDto)getSessionDto();
		YakusyokuMasterCardVo vo = (YakusyokuMasterCardVo)getVo();
		vo.setParams(request);
		// 敪擾
		vo.setPltTokyu(dto.getTokyu());
		// p[^̑ÓmF
		vo.validate();
		// DAȌ
		MYakusyokuDao dao = part().position().getMYakusyokuDao();
		// DTȌ
		vo.setDtoFields(dto);
		// rmF
		chkExclusive(dto, dao.findForUpdate(dto.getYcode(), dto.getTokyu()));
		// f[^̍XV
		dao.update(dto);
		// DTO̍Ď擾
		MYakusyokuDto retDto = dao.findForKey(dto.getYcode(), dto.getTokyu());
		chkUpdate(retDto);
		// R~bg
		commit();
		// [hݒ
		setMode();
		// bZ[Wݒ
		vo.setMessage(getMessage(MospConst.MSG_UPDATE, ""));
		// ZbVDTOZbg
		setSessionDto(retDto);
	}
	
	/**
	 * f[^폜
	 * @throws Exception 	Oꍇ
	 */
	private void delete() throws Exception {
		// DTO̎擾
		MYakusyokuDto dto = (MYakusyokuDto)getSessionDto();
		YakusyokuMasterCardVo vo = (YakusyokuMasterCardVo)getVo();
		// f[^̍XV
		part().position().getMYakusyokuDao().delete(dto);
		// R~bg
		commit();
		// bZ[Wݒ
		vo.setMessage(getMessage(MospConst.MSG_DELETE, ""));
	}
	
	/**
	 * [hݒ
	 * @throws Exception 	Oꍇ
	 */
	private void setMode() throws Exception {
		YakusyokuMasterCardVo vo = (YakusyokuMasterCardVo)getVo();
		// [hݒ
		if (hasSystemAuth()) {
			vo.setMode(YakusyokuMasterCardVo.MODE_SYSTEM);
		} else {
			vo.setMode(YakusyokuMasterCardVo.MODE_UPDATE);
		}
	}
	
}
