/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.system.action;

import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.kintai.common.action.KintaiCommonAction;
import jp.mosp.kintai.common.dao.CmWorkTypeDao;
import jp.mosp.kintai.common.dto.CmWorkTypeDto;
import jp.mosp.kintai.system.vo.WorkTypeMasterCardVo;

/**
 * @author yoshida
 *
 */
public class WorkTypeMasterCardAction extends KintaiCommonAction {
	
	// R}h
	private static final String	CMD_WORKTYPE_MASTER_CARD_SHOW	= "S2605";	// \(ǉ)
	private static final String	CMD_WORKTYPE_MASTER_CARD_SELECT	= "S2606";	// \(I)
	private static final String	CMD_WORKTYPE_MASTER_CARD_INSERT	= "S2607";	// o^
	private static final String	CMD_WORKTYPE_MASTER_CARD_UPDATE	= "S2608";	// XV
																			
	// tB[h
	private CmWorkTypeDto		dto;
	

	/**
	 * RXgN^
	 */
	public WorkTypeMasterCardAction() {
		super();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾yѐݒ
		prepareVo();
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_WORKTYPE_MASTER_CARD_SHOW)) {
			// \iVKo^j
			show();
		} else if (cmd.equals(CMD_WORKTYPE_MASTER_CARD_SELECT)) {
			// \(L[ŏ)
			select();
		} else if (cmd.equals(CMD_WORKTYPE_MASTER_CARD_INSERT)) {
			// VKo^
			insert();
		} else if (cmd.equals(CMD_WORKTYPE_MASTER_CARD_UPDATE)) {
			// XV
			update();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new WorkTypeMasterCardVo();
	}
	
	/**
	 * Action
	 * @throws Exception 	Oꍇ
	 */
	@Override
	protected void init() throws Exception {
		// DBRlNV擾
		getConnection();
		// SYSTEMmF
		confirmSystemAuth();
		WorkTypeMasterCardVo vo = (WorkTypeMasterCardVo)getVo();
		vo.setParams(request);
	}
	
	@Override
	protected void show() {
		WorkTypeMasterCardVo vo = (WorkTypeMasterCardVo)getVo();
		vo.setDefaultValues();
		vo.setMode(WorkTypeMasterCardVo.MODE_INSERT);
	}
	
	@Override
	protected void select() throws Exception {
		WorkTypeMasterCardVo vo = (WorkTypeMasterCardVo)getVo();
		// \(L[ŏ)
		// f[^̎擾
		dto = part().worktype().getCmWorkTypeDao().findForKey(key1);
		chkExist(dto);
		// VOɏZbg
		vo.setFields(dto);
		vo.setMode(WorkTypeMasterCardVo.MODE_UPDATE);
		// ZbVDTOZbg
		setSessionDto(dto);
	}
	
	@Override
	protected void insert() throws Exception {
		WorkTypeMasterCardVo vo = (WorkTypeMasterCardVo)getVo();
		vo.setPltDelete(String.valueOf(MospConst.DELETE_FLAG_OFF));
		// p[^̑ÓmF
		vo.validate();
		// DTȌ
		dto = new CmWorkTypeDto();
		vo.setDtoFields(dto);
		// DAȌ
		CmWorkTypeDao dao = part().worktype().getCmWorkTypeDao();
		// ݃`FbN
		chkDuplicate(dao.findForKey(dto.getShiftCode()));
		// f[^̑}
		dao.insert(dto);
		// DTO̍Ď擾
		CmWorkTypeDto retDto = dao.findForKey(dto.getShiftCode());
		chkInsert(retDto);
		// R~bg
		commit();
		// [hݒ
		vo.setMode(WorkTypeMasterCardVo.MODE_UPDATE);
		// bZ[Wݒ
		vo.setMessage(getMessage(MospConst.MSG_INSERT, ""));
		// ZbVDTOZbg
		setSessionDto(retDto);
	}
	
	@Override
	protected void update() throws Exception {
		// DTO̎擾
		dto = (CmWorkTypeDto)getSessionDto();
		WorkTypeMasterCardVo vo = (WorkTypeMasterCardVo)getVo();
		// R[h敪擾
		vo.setTxtShiftCode(dto.getShiftCode());
		// p[^̑ÓmF
		vo.validate();
		// DTȌ
		vo.setDtoFields(dto);
		// DAȌ
		CmWorkTypeDao dao = part().worktype().getCmWorkTypeDao();
		// rmF
		chkExclusive(dto, dao.findForUpdate(dto.getShiftCode()));
		// f[^̍XV
		dao.update(dto);
		// DTO̍Ď擾
		CmWorkTypeDto retDto = dao.findForKey(dto.getShiftCode());
		chkUpdate(retDto);
		// R~bg
		commit();
		// [hݒ
		vo.setMode(WorkTypeMasterCardVo.MODE_UPDATE);
		// bZ[Wݒ
		vo.setMessage(getMessage(MospConst.MSG_UPDATE, ""));
		// ZbVDTOZbg
		setSessionDto(retDto);
	}
	
}
