/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * 
 */
package jp.mosp.kintai.system.action;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.utils.TimeUtil;
import jp.mosp.kintai.common.action.MosPCodeAction;
import jp.mosp.kintai.system.vo.WorkSystemCardVo;

/**
 * @author yoshida
 *
 */
public class WorkSystemCardAction extends MosPCodeAction {
	
	private static final String	CMD_CARD_SHOW	= "S2030";
	private static final String	CMD_CARD_UPDATE	= "S2038";
	

	/**
	 * RXgN^
	 */
	public WorkSystemCardAction() {
		super();
	}
	
	public void action() throws Exception {
		// VO̎擾
		prepareVo(false);
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_CARD_SHOW)) {
			// \
			show();
		} else if (cmd.equals(CMD_CARD_UPDATE)) {
			// ڍXV
			update();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new WorkSystemCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		// SYSTEMmF
		confirmSystemAuth();
		WorkSystemCardVo vo = (WorkSystemCardVo)getVo();
		// v_E̐ݒ
		vo.aryPltProcess = getProcessArray();
		vo.aryPltCalcMonth = getCalcMonthArray();
		vo.aryPltProvidedMonth = getProvidedMonthArray();
		vo.aryPltHourUnit = StringUtil.getCountArray(1, 2, 1);
		vo.aryPltRoundNumber = getRoundNumberArray();
		vo.aryPltSubHolidayPeriod = getSubHolidayPeriodArray();
		vo.aryPltSubHolidayPriority = getSubHolidayPriorityArray();
	}
	
	@Override
	protected void show() throws Exception {
		WorkSystemCardVo vo = (WorkSystemCardVo)getVo();
		// ΑӒ
		vo.setPltCalcMonth(findTchange(CommonConst.TID_CALCULATION, CommonConst.TCD_MONTH));
		// ΑӒ
		vo.setTxtCalcDays(findTchange(CommonConst.TID_CALCULATION, CommonConst.TCD_DAYS));
		// ^x
		vo.setPltProvidedMonth(findTchange(CommonConst.TID_PROVIDED_DATE, CommonConst.TCD_MONTH));
		// ^x
		vo.setTxtProvidedDays(findTchange(CommonConst.TID_PROVIDED_DATE, CommonConst.TCD_DAYS));
		// ͒P
		vo.setTxtInputUnit(String.valueOf(part().kintai().getInputUnitTimes()));
		// vZ
		vo.setPltAutoCalc(findTchange(CommonConst.TID_WORK_SYSTEM, CommonConst.TCD_AUTOMATIC_CALCULATION));
		// vZ
		vo.setPltCalcProcess(findTchange(CommonConst.TID_WORK_SYSTEM, CommonConst.TCD_CALCULATION_PROCESS));
		// SxAx
		String holidayHours = findTchange(CommonConst.TID_WORK_SYSTEM, CommonConst.TCD_HOLIDAY_HOURS);
		vo.setTxtAllHolidayHour(holidayHours.substring(0, 2));
		vo.setTxtAllHolidayMin(holidayHours.substring(3, 5));
		vo.setTxtHalfHolidayHour(holidayHours.substring(6, 8));
		vo.setTxtHalfHolidayMin(holidayHours.substring(9, 11));
		// [JnA[鎞
		String lateNightHours = findTchange(CommonConst.TID_WORK_SYSTEM, CommonConst.TCD_LATE_NIGHT);
		vo.setTxtLateNightStartHour(lateNightHours.substring(0, 2));
		vo.setTxtLateNightStartMin(lateNightHours.substring(3, 5));
		vo.setTxtLateNightTimeHour(lateNightHours.substring(6, 8));
		vo.setTxtLateNightTimeMin(lateNightHours.substring(9, 11));
		// pX[hL
		vo.setTxtPasswordTerm(String.valueOf(getPasswordTerm()));
		// cƊJnOxe
		int beforeOverTimeInterval = part().kintai().getBeforeOverTimeInterval();
		vo.setTxtBeforeOverTimeHour(TimeUtil.convIntegerTimeToStringHour(beforeOverTimeInterval));
		vo.setTxtBeforeOverTimeMin(TimeUtil.convIntegerTimeToStringMinutes(beforeOverTimeInterval));
		// cƋxexPʎ
		int overTimeUnit = part().kintai().getOverTimeUnitTime();
		vo.setTxtOverTimeUnitHour(TimeUtil.convIntegerTimeToStringHour(overTimeUnit));
		vo.setTxtOverTimeUnitMin(TimeUtil.convIntegerTimeToStringMinutes(overTimeUnit));
		// cƋxe
		int overTimeInterval = part().kintai().getOverTimeInterval();
		vo.setTxtOverTimeIntervalHour(TimeUtil.convIntegerTimeToStringHour(overTimeInterval));
		vo.setTxtOverTimeIntervalMin(TimeUtil.convIntegerTimeToStringMinutes(overTimeInterval));
		// ۂߏ
		vo.setPltRoundNumber(findTchange(CommonConst.TID_WORK_SYSTEM, CommonConst.TCD_ROUND_NUMBER));
		// 60ԎԊO@\
		vo.setPltOverTime60Hour(findTchange(CommonConst.TID_WORK_SYSTEM, CommonConst.TCD_OVER_TIME_60_HOUR));
		// 60ԎԊOɂ֋xɋ@\
		vo.setPltSubstituteHoliday(findTchange(CommonConst.TID_WORK_SYSTEM, CommonConst.TCD_SUBSTITUTE_HOLIDAY));
		// 60ԎԊOɂx̗L
		vo.setPltSubstitutePeriod(findTchange(CommonConst.TID_WORK_SYSTEM, CommonConst.TCD_SUBSTITUTE_PERIOD));
		// x̏D揇
		vo.setPltSubstitutePriority(findTchange(CommonConst.TID_WORK_SYSTEM, CommonConst.TCD_SUBSTITUTE_PRIORITY));
		// xC
		//vo.setPltSubstituteAmendment(findTchange(CommonConst.TID_WORK_SYSTEM, CommonConst.TCD_SUBSTITUTE_AMENDMENT));
		vo.setPltSubstituteAmendment(CommonConst.NAM_COMMON_FLAG_ON);
		// ԒPʔNx@\
		vo.setPltHourHolidayFunction(findTchange(CommonConst.TID_PAID_HOLIDAY,
				CommonConst.TCD_HOUR_PAID_HOLIDAY_FUNCTION));
		// Pʎ
		vo.setPltHourHolidayUnit(findTchange(CommonConst.TID_PAID_HOLIDAY, CommonConst.TCD_HOUR_PAID_HOLIDAY_UNIT));
	}
	
	@Override
	protected void update() throws Exception {
		WorkSystemCardVo vo = (WorkSystemCardVo)getVo();
		// ړ͒l擾
		vo.setParams(request);
		// p[^̑ÓmF
		vo.validate();
		// ΑӒ
		regist(CommonConst.TID_CALCULATION, CommonConst.TCD_MONTH, CommonConst.TNM_MONTH_MINUS, vo.getPltCalcMonth());
		// ΑӒ
		regist(CommonConst.TID_CALCULATION, CommonConst.TCD_DAYS, CommonConst.TNM_PERIOD_DATE, vo.getTxtCalcDays());
		// ^x
		regist(CommonConst.TID_PROVIDED_DATE, CommonConst.TCD_MONTH, CommonConst.TNM_MONTH_PLUS, vo
			.getPltProvidedMonth());
		// ^x
		regist(CommonConst.TID_PROVIDED_DATE, CommonConst.TCD_DAYS, CommonConst.TNM_PROVIDED_DATE, vo
			.getTxtProvidedDays());
		// ͒P
		regist(CommonConst.TID_INPUT_UNIT_TIMES, CommonConst.TCD_MINUTES, CommonConst.TNM_AMOUNT_UNIT, vo
			.getTxtInputUnit());
		// vZ
		regist(CommonConst.TID_WORK_SYSTEM, CommonConst.TCD_AUTOMATIC_CALCULATION, CommonConst.TNM_AMOUNT_UNIT, vo
			.getPltAutoCalc());
		// vZ
		regist(CommonConst.TID_WORK_SYSTEM, CommonConst.TCD_CALCULATION_PROCESS, "", vo.getPltCalcProcess());
		// SxAx	
		regist(CommonConst.TID_WORK_SYSTEM, CommonConst.TCD_HOLIDAY_HOURS, CommonConst.TNM_AMOUNT_UNIT,
				convStringToTimeCode(vo.getTxtAllHolidayHour(), vo.getTxtAllHolidayMin(), vo.getTxtHalfHolidayHour(),
						vo.getTxtHalfHolidayMin()));
		// [JnA[鎞
		regist(CommonConst.TID_WORK_SYSTEM, CommonConst.TCD_LATE_NIGHT, CommonConst.TNM_AMOUNT_UNIT,
				convStringToTimeCode(vo.getTxtLateNightStartHour(), vo.getTxtLateNightStartMin(), vo
					.getTxtLateNightTimeHour(), vo.getTxtLateNightTimeMin()));
		// pX[hL
		regist(CommonConst.TID_PASSWORD_TERM, "", "", vo.getTxtPasswordTerm());
		// cƊJnOxe
		regist(CommonConst.TID_OVER_TIME_INTERVAL, CommonConst.TCD_BEFORE_OVER_TIME_INTERVAL_TIME, "", String
			.valueOf(TimeUtil.convStringTimeToIntegerTime(vo.getTxtBeforeOverTimeHour(), vo.getTxtBeforeOverTimeMin())));
		// cƋxexPʎ
		regist(CommonConst.TID_OVER_TIME_INTERVAL, CommonConst.TCD_OVER_TIME_UNIT_TIME, "", String.valueOf(TimeUtil
			.convStringTimeToIntegerTime(vo.getTxtOverTimeUnitHour(), vo.getTxtOverTimeUnitMin())));
		// cƋxe
		regist(CommonConst.TID_OVER_TIME_INTERVAL, CommonConst.TCD_OVER_TIME_INTERVAL_TIME, "", String.valueOf(TimeUtil
			.convStringTimeToIntegerTime(vo.getTxtOverTimeIntervalHour(), vo.getTxtOverTimeIntervalMin())));
		// ۂߏ
		regist(CommonConst.TID_WORK_SYSTEM, CommonConst.TCD_ROUND_NUMBER, "", vo.getPltRoundNumber());
		// 60ԎԊO@\
		regist(CommonConst.TID_WORK_SYSTEM, CommonConst.TCD_OVER_TIME_60_HOUR, "", vo.getPltOverTime60Hour());
		// 60ԎԊOɂ֋xɋ@\
		regist(CommonConst.TID_WORK_SYSTEM, CommonConst.TCD_SUBSTITUTE_HOLIDAY, "", vo.getPltSubstituteHoliday());
		// x̗L
		regist(CommonConst.TID_WORK_SYSTEM, CommonConst.TCD_SUBSTITUTE_PERIOD, "", vo.getPltSubstitutePeriod());
		// x̏D揇
		regist(CommonConst.TID_WORK_SYSTEM, CommonConst.TCD_SUBSTITUTE_PRIORITY, "", vo.getPltSubstitutePriority());
		// xC
		regist(CommonConst.TID_WORK_SYSTEM, CommonConst.TCD_SUBSTITUTE_AMENDMENT, "", vo.getPltSubstituteAmendment());
		// ԒPʔNx@\
		regist(CommonConst.TID_PAID_HOLIDAY, CommonConst.TCD_HOUR_PAID_HOLIDAY_FUNCTION, "", vo
			.getPltHourHolidayFunction());
		// Pʎ
		regist(CommonConst.TID_PAID_HOLIDAY, CommonConst.TCD_HOUR_PAID_HOLIDAY_UNIT, "", vo.getPltHourHolidayUnit());
		// R~bg
		commit();
		// bZ[Wݒ
		setMessage(getMessage(MospConst.MSG_UPDATE, ""));
		// \
		show();
	}
	
	/**
	 * @return ΑӒΏیz
	 */
	private String[][] getCalcMonthArray() {
		return new String[][]{ { CommonConst.NUM_CUT_OFF_MONTH_THIS, CommonConst.NAM_CUT_OFF_MONTH_THIS },
			{ CommonConst.NUM_CUT_OFF_MONTH_FORMER, CommonConst.NAM_CUT_OFF_MONTH_FORMER } };
	}
	
	/**
	 * @return ^xΏیz
	 */
	private String[][] getProvidedMonthArray() {
		return new String[][]{ { CommonConst.NUM_PROVIDED_MONTH_THIS, CommonConst.NAM_PROVIDED_MONTH_THIS },
			{ CommonConst.NUM_PROVIDED_MONTH_FUTURE, CommonConst.NAM_PROVIDED_MONTH_FUTURE } };
	}
	
	/**
	 * @return vZz
	 */
	private String[][] getProcessArray() {
		return StringUtil.getFlagArray(CommonConst.NAM_ATTENDANCE_INPUT, CommonConst.NAM_ATTENDANCE_COMPILE);
	}
	
	/**
	 * @return ۂߏz
	 */
	private String[][] getRoundNumberArray() {
		return StringUtil.getFlagArray(CommonConst.NAM_ATTENDANCE_INPUT, CommonConst.NAM_ATTENDANCE_COMPILE);
	}
	
	private String[][] getSubHolidayPeriodArray() {
		return StringUtil.getFlagArray("1", "2");
	}
	
	private String[][] getSubHolidayPriorityArray() {
		return StringUtil.getFlagArray("D", "xD");
	}
	
}
