/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.system.action;

import java.io.Serializable;
import java.util.Comparator;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPAction;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dto.MCodeDto;
import jp.mosp.kintai.system.vo.HolidayMasterListVo;

/**
 * @author yoshida
 *
 */
public class HolidayMasterListAction extends MosPAction {
	
	// R}h
	private static final String	CMD_HOLIDAY_MASTER_LIST_SHOW		= "S2710";	// \
	private static final String	CMD_HOLIDAY_MASTER_LIST_SELECT		= "S2711";	// 
	private static final String	CMD_HOLIDAY_MASTER_LIST_RE_SEARCH	= "S2712";	// Č
	private static final String	CMD_HOLIDAY_MASTER_LIST_SORT		= "S2713";	// \[g
																				
	
	/**
	 * RXgN^
	 */
	public HolidayMasterListAction() {
		super();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾
		prepareVo();
		// 
		init();
		// R}h̏		
		if (cmd.equals(CMD_HOLIDAY_MASTER_LIST_SHOW)) {
			show();
		} else if (cmd.equals(CMD_HOLIDAY_MASTER_LIST_SELECT)) {
			// 
			search();
		} else if (cmd.equals(CMD_HOLIDAY_MASTER_LIST_RE_SEARCH)) {
			// Č
			research();
		} else if (cmd.equals(CMD_HOLIDAY_MASTER_LIST_SORT)) {
			// \[g
			sortList(key1);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new HolidayMasterListVo();
	}
	
	@Override
	protected void init() throws Exception {
		// DBRlNV擾
		getConnection();
		// SYSTEMmF
		confirmSystemAuth();
	}
	
	@Override
	protected void show() throws Exception {
		HolidayMasterListVo vo = (HolidayMasterListVo)getVo();
		// lɃZbg
		vo.setSearchmode(HolidayMasterListVo.SEARCH_OFF);
	}
	
	@Override
	protected void search() throws Exception {
		HolidayMasterListVo vo = (HolidayMasterListVo)getVo();
		vo.setParams(request);
		searchHolidayList();
		vo.setIsAscending(true);
		vo.initListInfo();
		// ɃZbg
		vo.setSearchmode(HolidayMasterListVo.SEARCH_ON);
	}
	
	@Override
	protected void research() throws Exception {
		HolidayMasterListVo vo = (HolidayMasterListVo)getVo();
		if (vo.getSearchmode() == HolidayMasterListVo.SEARCH_ON) {
			removeSessionDto();
			searchHolidayList();
			vo.setPageButton();
			sortList();
		}
	}
	
	/**
	 * xXg
	 * @throws Exception 	Oꍇ
	 */
	private void searchHolidayList() throws Exception {
		HolidayMasterListVo vo = (HolidayMasterListVo)getVo();
		// 
		vo.setFields(part().mospcode().getMCodeDao().findForHoliday(CommonConst.NAM_HOLIDAY, vo.getTxtHDate(),
				vo.getTxtHName()));
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.getAryHDate().length == 0) {
			addErrMessage(getMessage(MospConst.MSG_NO_DATA, ""));
		}
	}
	
	@Override
	protected Comparator<Object> getComparator(String key) throws MospException {
		HolidayMasterListVo vo = (HolidayMasterListVo)getVo();
		Comparator<Object> comp = null;
		if (key.equals(vo.KEY_H_CODE)) {
			comp = new CompHCode();
		} else if (key.equals(vo.KEY_H_NAME)) {
			comp = new CompHName();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}
	

	/**
	 * R[hɂrNX
	 */
	protected static class CompHCode implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -5324184931004173732L;
		

		public int compare(Object obj1, Object obj2) {
			MCodeDto dto1 = (MCodeDto)obj1;
			MCodeDto dto2 = (MCodeDto)obj2;
			return dto1.getTCode().compareTo(dto2.getTCode());
		}
	}
	
	/**
	 * R[ĥɂrNX
	 */
	protected static class CompHName implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -3122154963469415094L;
		

		public int compare(Object obj1, Object obj2) {
			MCodeDto dto1 = (MCodeDto)obj1;
			MCodeDto dto2 = (MCodeDto)obj2;
			return dto1.getTName().compareTo(dto2.getTName());
		}
	}
	
}
