/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.system.action;

import jp.mosp.common.MosPAction;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dao.CmCodeDao;
import jp.mosp.common.dto.CmCodeDto;
import jp.mosp.kintai.system.vo.CmCodeCardVo;

/**
 * @author yoshida
 *
 */
public class CmCodeCardAction extends MosPAction {
	
	// R}h
	private static final String	CMD_CODE_CARD_SHOW		= "S2005";	// \(ǉ)
	private static final String	CMD_CODE_CARD_SELECT	= "S2006";	// \(I)
	private static final String	CMD_CODE_CARD_INSERT	= "S2007";	// o^
	private static final String	CMD_CODE_CARD_UPDATE	= "S2008";	// XV
																	
	
	/**
	 * RXgN^
	 */
	public CmCodeCardAction() {
		super();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾yѐݒ
		prepareVo(false);
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_CODE_CARD_SHOW)) {
			// \(VK)
			show();
		} else if (cmd.equals(CMD_CODE_CARD_SELECT)) {
			// \(L[ŏ)
			select();
		} else if (cmd.equals(CMD_CODE_CARD_INSERT)) {
			// VKo^
			insert();
		} else if (cmd.equals(CMD_CODE_CARD_UPDATE)) {
			// XV
			update();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new CmCodeCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		// DBRlNV擾
		getConnection();
		// SYSTEMmF
		confirmSystemAuth();
		CmCodeCardVo vo = (CmCodeCardVo)getVo();
		// R[h敪v_EXg쐬
		vo.aryPltTId = getCodeArray();
	}
	
	@Override
	protected void show() {
		CmCodeCardVo vo = (CmCodeCardVo)getVo();
		vo.setPltTId("");
		vo.setTxtTCode("");
		vo.setTxtTName("");
		vo.setTxtViewIndex("");
		vo.setPltDelete("");
		vo.setMode(CmCodeCardVo.MODE_INSERT);
	}
	
	@Override
	protected void select() throws Exception {
		CmCodeCardVo vo = (CmCodeCardVo)getVo();
		// f[^̎擾
		CmCodeDto dto = part().cmcode().getCmCodeDao().findForKey(key1, key2);
		chkExist(dto);
		// VOɏZbg
		vo.setFields(dto);
		vo.setMode(CmCodeCardVo.MODE_UPDATE);
		// ZbVDTOZbg
		setSessionDto(dto);
	}
	
	@Override
	protected void insert() throws Exception {
		CmCodeCardVo vo = (CmCodeCardVo)getVo();
		vo.setParams(request);
		vo.setPltDelete(String.valueOf(MospConst.DELETE_FLAG_OFF));
		// p[^̑ÓmF
		vo.validate(true);
		// DTȌ
		CmCodeDto dto = new CmCodeDto();
		vo.setDtoFields(dto);
		// DAȌ
		CmCodeDao dao = part().cmcode().getCmCodeDao();
		// ݃`FbN
		chkDuplicate(dao.findForKey(dto.getTId(), dto.getTCode()));
		// f[^̑}
		dao.insert(dto);
		// DTO̍Ď擾
		CmCodeDto retDto = dao.findForKey(dto.getTId(), dto.getTCode());
		// R~bg
		commit();
		// [hݒ
		vo.setMode(CmCodeCardVo.MODE_UPDATE);
		// bZ[Wݒ
		setMessage(getMessage(MospConst.MSG_INSERT, ""));
		// ZbVDTOZbg
		setSessionDto(retDto);
	}
	
	@Override
	protected void update() throws Exception {
		// DTO̎擾
		CmCodeDto dto = (CmCodeDto)getSessionDto();
		CmCodeCardVo vo = (CmCodeCardVo)getVo();
		vo.setParams(request);
		// R[h敪擾
		vo.setPltTId(dto.getTId());
		// p[^̑ÓmF
		vo.validate(false);
		// DTȌ
		vo.setDtoFields(dto);
		// DAȌ
		CmCodeDao dao = part().cmcode().getCmCodeDao();
		// rmF
		chkExclusive(dto, dao.findForUpdate(dto.getTId(), dto.getTCode()));
		// f[^̍XV
		dao.update(dto);
		// DTO̍Ď擾
		CmCodeDto retDto = dao.findForKey(dto.getTId(), dto.getTCode());
		chkUpdate(retDto);
		// R~bg
		commit();
		// [hݒ
		vo.setMode(CmCodeCardVo.MODE_UPDATE);
		// bZ[Wݒ
		setMessage(getMessage(MospConst.MSG_UPDATE, ""));
		// ZbVDTOZbg
		setSessionDto(retDto);
	}
	
}
