/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.schedule.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;

/**
 * @author yoshida
 *
 */
public class ScheduleEditCardVo extends MosPScheduleVo {
	
	private static final long	serialVersionUID	= 1989126275272023178L;
	
	// p[^
	/**
	 * pltWorkType
	 */
	public static final String	PRM_PLT_WORK_TYPE	= "pltWorkType";
	/**
	 * ckbDeleteFlag
	 */
	public static final String	PRM_CKB_DELETE_FLAG	= "ckbDeleteFlag";
	
	// tB[h
	private String[]			arySelectWorktype;
	
	private String[][]			arySchedule;
	
	// v_EXg
	/**
	 * 
	 */
	public String[][]			aryPltYear;
	/**
	 * 
	 */
	public String[][]			aryPltMonth;
	/**
	 * 
	 */
	public String[][]			aryPltWorkType;
	

	/**
	 * RXgN^
	 */
	public ScheduleEditCardVo() {
		super();
		setViewPath(getClassName());
		arySelectWorktype = new String[0];
		arySchedule = new String[0][0];
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_SCHEDULE_EDIT;
		aryMenu = new String[][]{ { CMD_MENU_INPUT, CommonConst.NAM_TO_MENU }, MosPMenuConst.getMenuSchedule() };
	}
	
	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	@Override
	public void setParams(HttpServletRequest request) {
		super.setParams(request);
		arySelectWorktype = request.getParameterValues(PRM_PLT_WORK_TYPE);
	}
	
	/**
	 * tB[hݒ
	 * @param arySchedule \ꗗz
	 */
	public void setFields(String[][] arySchedule) {
		this.arySchedule = escapeArray(arySchedule.clone());
	}
	
	// ANZT\bh
	/**
	 * @return arySchedule
	 */
	public String[][] getEscArySchedule() {
		return arySchedule.clone();
	}
	
	/**
	 * @return arySelectWorktype
	 */
	public String[] getArySelectWorktype() {
		return arySelectWorktype.clone();
	}
	
}
