/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.schedule.vo;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;

/**
 * @author yoshida
 *
 */
public class ScheduleConfirmListVo extends MosPScheduleVo {
	
	private static final long	serialVersionUID	= -3930861402120064453L;
	
	// tB[h
	private String				workTimes;
	private String				breakTimes;
	
	private String				presence;
	private String				paidHoliday;
	private String				particularHoliday;
	private String				absence;
	private String				sick;
	private String				compensationLeave;
	private String				transfer;
	private String				other;
	
	private String[][]			arySchedule;
	private String[]			aryLabel;
	
	// v_EXg
	/**
	 * 
	 */
	public String[][]			aryPltYear;
	/**
	 * 
	 */
	public String[][]			aryPltMonth;
	

	/**
	 * RXgN^
	 */
	public ScheduleConfirmListVo() {
		super();
		setViewPath(getClassName());
		arySchedule = new String[0][0];
		aryLabel = new String[0];
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_SCHEDULE_CONFIRM;
		aryMenu = new String[][]{ { CMD_MENU_INPUT, CommonConst.NAM_TO_MENU }, MosPMenuConst.getMenuSchedule() };
	}
	
	/**
	 * tB[hݒ
	 * @param arySchedule \ꗗz
	 * @param aryCompile Wvf[^z
	 * @param aryLabel Wvxz
	 */
	public void setFields(String[][] arySchedule, String[] aryCompile, String[] aryLabel) {
		this.arySchedule = escapeArray(arySchedule.clone());
		this.aryLabel = escapeArray(aryLabel.clone());
		workTimes = aryCompile[0];
		breakTimes = aryCompile[1];
		presence = aryCompile[2];
		paidHoliday = aryCompile[3];
		particularHoliday = aryCompile[4];
		absence = aryCompile[5];
		sick = aryCompile[6];
		compensationLeave = aryCompile[7];
		transfer = aryCompile[8];
		other = aryCompile[9];
	}
	
	/**
	 * @return workTimes
	 */
	public String getWorkTimes() {
		return workTimes;
	}
	
	/**
	 * @return breakTimes
	 */
	public String getBreakTimes() {
		return breakTimes;
	}
	
	/**
	 * @return presence
	 */
	public String getPresence() {
		return presence;
	}
	
	/**
	 * @return paidHoliday
	 */
	public String getPaidHoliday() {
		return paidHoliday;
	}
	
	/**
	 * @return particularHoliday
	 */
	public String getParticularHoliday() {
		return particularHoliday;
	}
	
	/**
	 * @return absence
	 */
	public String getAbsence() {
		return absence;
	}
	
	/**
	 * @return sick
	 */
	public String getSick() {
		return sick;
	}
	
	/**
	 * @return compensationLeave
	 */
	public String getCompensationLeave() {
		return compensationLeave;
	}
	
	/**
	 * @return transfer
	 */
	public String getTransfer() {
		return transfer;
	}
	
	/**
	 * @return other
	 */
	public String getOther() {
		return other;
	}
	
	/**
	 * @return arySchedule
	 */
	public String[][] getArySchedule() {
		return arySchedule.clone();
	}
	
	/**
	 * @return aryLabel
	 */
	public String[] getAryLabel() {
		return aryLabel.clone();
	}
	
	/**
	 * @param workTimes Zbg workTimes
	 */
	public void setWorkTimes(String workTimes) {
		this.workTimes = workTimes;
	}
	
	/**
	 * @param breakTimes Zbg breakTimes
	 */
	public void setBreakTimes(String breakTimes) {
		this.breakTimes = breakTimes;
	}
	
	/**
	 * @param presence Zbg presence
	 */
	public void setPresence(String presence) {
		this.presence = presence;
	}
	
	/**
	 * @param paidHoliday Zbg paidHoliday
	 */
	public void setPaidHoliday(String paidHoliday) {
		this.paidHoliday = paidHoliday;
	}
	
	/**
	 * @param particularHoliday Zbg particularHoliday
	 */
	public void setParticularHoliday(String particularHoliday) {
		this.particularHoliday = particularHoliday;
	}
	
	/**
	 * @param absence Zbg absence
	 */
	public void setAbsence(String absence) {
		this.absence = absence;
	}
	
	/**
	 * @param sick Zbg sick
	 */
	public void setSick(String sick) {
		this.sick = sick;
	}
	
	/**
	 * @param compensationLeave Zbg compensationLeave
	 */
	public void setCompensationLeave(String compensationLeave) {
		this.compensationLeave = compensationLeave;
	}
	
	/**
	 * @param transfer Zbg transfer
	 */
	public void setTransfer(String transfer) {
		this.transfer = transfer;
	}
	
	/**
	 * @param other Zbg other
	 */
	public void setOther(String other) {
		this.other = other;
	}
	
	/**
	 * @param arySchedule Zbg arySchedule
	 */
	public void setArySchedule(String[][] arySchedule) {
		this.arySchedule = arySchedule.clone();
	}
	
	/**
	 * @param aryLabel Zbg aryLabel
	 */
	public void setAryLabel(String[] aryLabel) {
		this.aryLabel = aryLabel.clone();
	}
	
}
