/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * 
 */
package jp.mosp.kintai.payroll.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.utils.DateUtil;

/**
 * @author nakamura
 *
 */
public class WorkCompileExportCardVo extends MosPVo {
	
	private static final long	serialVersionUID	= 8449447211917228425L;
	
	// p[^
	/**
	 * 
	 */
	public static final String	PRM_PLT_SECTION		= "pltSection";
	/**
	 * ЈR[h
	 */
	public static final String	PRM_TXT_K_CODE		= "txtKCode";
	/**
	 * JnN
	 */
	public static final String	PRM_PLT_START_YEAR	= "pltStartYear";
	/**
	 * Jn
	 */
	public static final String	PRM_PLT_START_MONTH	= "pltStartMonth";
	/**
	 * IN
	 */
	public static final String	PRM_PLT_END_YEAR	= "pltEndYear";
	/**
	 * I
	 */
	public static final String	PRM_PLT_END_MONTH	= "pltEndMonth";
	/**
	 * ΑӃe[u
	 */
	public static final String	PRM_PLT_WORK_TABLE	= "pltWorkTable";
	
	// tB[h
	private String				pltSection;
	private String				txtKCode;
	private String				pltStartYear;
	private String				pltStartMonth;
	private String				pltEndYear;
	private String				pltEndMonth;
	private String				pltWorkTable;
	
	// v_EXg
	/**
	 * (z)
	 */
	public String[][]			aryPltSection;
	/**
	 * JnN(z)
	 */
	public String[][]			aryPltYear;
	/**
	 * Jn(z)
	 */
	public String[][]			aryPltMonth;
	/**
	 * ΑӃe[u(z)
	 */
	public String[][]			aryPltWorkTable;
	/**
	 * JnN(z)LxɃe[uI
	 */
	public String[][]			aryOldYear;
	/**
	 * JnN(z)VLxɃe[uI
	 */
	public String[][]			aryNewYear;
	/**
	 * Jn(z)LxɃe[uI
	 */
	public String[][]			aryOldMonth;
	/**
	 * Jn(z)VLxɃe[uI
	 */
	public String[][]			aryNewMonth;
	
	// tB[hyѐ	
	/**
	 * ЈR[h
	 */
	public String				NAM_K_CODE;
	/**
	 * 
	 */
	public String				NAM_SECTION;
	/**
	 * JnN
	 */
	public String				NAM_START_DATE;
	/**
	 * IN
	 */
	public String				NAM_END_DATE;
	/**
	 * ΑӃe[u
	 */
	public String				NAM_WORK_TABLE;
	/**
	 * ЈR[h(ڒ)
	 */
	public int					LEN_K_CODE;
	

	/**
	 * RXgN^[
	 */
	public WorkCompileExportCardVo() {
		super();
		setViewPath(getClassName());
		aryPltYear = new String[0][0];
		aryPltMonth = new String[0][0];
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = "ΑӏWvGNX|[g";
		createAryMenu(CMD_MENU_PAYROLL, MosPMenuConst.getMenuAttendanceCalculate());
	}
	
	@Override
	protected void setFieldsName() {
		NAM_K_CODE = CommonConst.NAM_K_CODE;
		NAM_SECTION = CommonConst.NAM_STATION;
		NAM_START_DATE = CommonConst.NAM_START + CommonConst.NAM_YEAR + CommonConst.NAM_MONTH;
		NAM_END_DATE = CommonConst.NAM_END + CommonConst.NAM_YEAR + CommonConst.NAM_MONTH;
		NAM_WORK_TABLE = CommonConst.NAM_COMMON_OUTPUT + CommonConst.NAM_COMMON_TARGET;
		LEN_K_CODE = CommonConst.LEN_K_CODE;
	}
	
	/**
	 * lݒ
	 */
	public void setDefaultValues() {
		pltSection = "";
		txtKCode = "";
		pltStartYear = String.valueOf(MospUtility.getYear(DateUtil.getNowDate()));
		pltStartMonth = String.valueOf(MospUtility.getMonth(DateUtil.getNowDate()));
		pltEndYear = String.valueOf(MospUtility.getYear(DateUtil.getNowDate()));
		pltEndMonth = String.valueOf(MospUtility.getMonth(DateUtil.getNowDate()));
		if (DateUtil.getNowDate().compareTo(DateUtil.getDate(2010, 3, 31)) > 0) {
			pltWorkTable = "1";
		} else {
			pltWorkTable = "0";
		}
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		pltSection = request.getParameter(PRM_PLT_SECTION);
		txtKCode = request.getParameter(PRM_TXT_K_CODE);
		pltStartYear = request.getParameter(PRM_PLT_START_YEAR);
		pltStartMonth = request.getParameter(PRM_PLT_START_MONTH);
		pltEndYear = request.getParameter(PRM_PLT_END_YEAR);
		pltEndMonth = request.getParameter(PRM_PLT_END_MONTH);
		pltWorkTable = request.getParameter(PRM_PLT_WORK_TABLE);
	}
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException	MosPOꍇ
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// 񒷊mF
		checkLength(txtKCode, LEN_K_CODE, NAM_K_CODE, PRM_TXT_K_CODE);
		// ÓmFI
		endValidation();
	}
	
	/**
	 * JavaScript(ݒz)擾
	 * @param name       ϐ
	 * @param arySetting ݒz
	 * @return JavaScript(ݒz)
	 */
	public static String getArrayJs(String name, String[][] arySetting) {
		StringBuffer sb = new StringBuffer();
		sb.append("var ");
		sb.append(escapeHTML(name));
		sb.append(" = new Array(");
		sb.append(arySetting.length);
		sb.append(");");
		for (int i = 0; i < arySetting.length; i++) {
			sb.append(name);
			sb.append("[");
			sb.append(i);
			sb.append("] = new Array(");
			sb.append(2);
			sb.append(");");
			
			sb.append(name);
			sb.append("[");
			sb.append(i);
			sb.append("][");
			sb.append(0);
			sb.append("] = \"");
			sb.append(escapeHTML(arySetting[i][0]));
			sb.append("\";");
			
			sb.append(name);
			sb.append("[");
			sb.append(i);
			sb.append("][");
			sb.append(1);
			sb.append("] = \"");
			sb.append(escapeHTML(arySetting[i][1]));
			sb.append("\";");
		}
		return sb.toString();
	}
	
	@Override
	public String getDirectJs(Class<?> cls, Object obj) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls, obj));
		sb.append(getArrayJs("ARY_OLD_YEAR", aryOldYear));
		sb.append(getArrayJs("ARY_NEW_YEAR", aryNewYear));
		sb.append(getArrayJs("ARY_OLD_MONTH", aryOldMonth));
		sb.append(getArrayJs("ARY_NEW_MONTH", aryNewMonth));
		sb.append(getArrayJs("ARY_PLT_MONTH", aryPltMonth));
		return sb.toString();
	}
	
	// ANZT\bh	
	/**
	 * @return		ЈR[h(HTMLGXP[v)
	 */
	public String getEscTxtKCode() {
		return escapeHTML(txtKCode);
	}
	
	/**
	 * @return		
	 */
	public String getPltSection() {
		return pltSection;
	}
	
	/**
	 * @return		ЈR[h
	 */
	public String getTxtKCode() {
		return txtKCode;
	}
	
	/**
	 * @return		JnN
	 */
	public String getPltStartYear() {
		return pltStartYear;
	}
	
	/**
	 * @return		Jn
	 */
	public String getPltStartMonth() {
		return pltStartMonth;
	}
	
	/**
	 * @return		IN
	 */
	public String getPltEndYear() {
		return pltEndYear;
	}
	
	/**
	 * @return		I
	 */
	public String getPltEndMonth() {
		return pltEndMonth;
	}
	
	/**
	 * @return		LxɃe[u
	 */
	public String getPltWorkTable() {
		return pltWorkTable;
	}
	
	/**
	 * @param pltSection		
	 */
	public void setPltSection(String pltSection) {
		this.pltSection = pltSection;
	}
	
	/**
	 * @param txtKCode			ЈR[h
	 */
	public void setTxtKCode(String txtKCode) {
		this.txtKCode = txtKCode;
	}
	
	/**
	 * @param pltStartYear		JnN
	 */
	public void setPltStartYear(String pltStartYear) {
		this.pltStartYear = pltStartYear;
	}
	
	/**
	 * @param pltStartMonth		Jn
	 */
	public void setPltStartMonth(String pltStartMonth) {
		this.pltStartMonth = pltStartMonth;
	}
	
	/**
	 * @param pltEndYear		IN
	 */
	public void setPltEndYear(String pltEndYear) {
		this.pltEndYear = pltEndYear;
	}
	
	/**
	 * @param pltEndMonth		I
	 */
	public void setPltEndMonth(String pltEndMonth) {
		this.pltEndMonth = pltEndMonth;
	}
	
	/**
	 * @param pltWorkTable	LxɃe[u
	 */
	public void setPltWorkTable(String pltWorkTable) {
		this.pltWorkTable = pltWorkTable;
	}
}
