/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.payroll.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospException;
import jp.mosp.common.utils.StringUtil;

/**
 * @author yoshida
 *
 */
public class CompileAmendmentCardVo extends MosPVo {
	
	private static final long	serialVersionUID					= 604403997889114402L;
	
	// 萔
	/**
	 * 
	 */
	public static final int		MODE_EDIT							= 1;
	/**
	 * 
	 */
	public static final int		MODE_IMPOSSIBLE						= 2;
	
	// p[^
	/**
	 * hidKCode
	 */
	public static final String	PRM_HID_K_CODE						= "hidKCode";
	/**
	 * hidYear
	 */
	public static final String	PRM_HID_YEAR						= "hidYear";
	/**
	 * hidMonth
	 */
	public static final String	PRM_HID_MONTH						= "hidMonth";
	/**
	 * hidYear
	 */
	public static final String	PRM_HID_YEAR_MONTH					= "hidYearMonth";
	/**
	 * txtPresence
	 */
	public static final String	PRM_TXT_PRESENCE					= "txtPresence";
	/**
	 * txtPresenceNumber
	 */
	public static final String	PRM_TXT_PRESENCE_NUMBER				= "txtPresenceNumber";
	/**
	 * txtWorkHour
	 */
	public static final String	PRM_TXT_WORK_HOUR					= "txtWorkHour";
	/**
	 * txtWorkMin
	 */
	public static final String	PRM_TXT_WORK_MIN					= "txtWorkMin";
	/**
	 * txtBreakHour
	 */
	public static final String	PRM_TXT_BREAK_HOUR					= "txtBreakHour";
	/**
	 * txtBreakMin
	 */
	public static final String	PRM_TXT_BREAK_MIN					= "txtBreakMin";
	/**
	 * txtLeaveAndLate
	 */
	public static final String	PRM_TXT_LEAVE_AND_LATE				= "txtLeaveAndLate";
	/**
	 * txtLeaveAndLateHour
	 */
	public static final String	PRM_TXT_LEAVE_AND_LATE_HOUR			= "txtLeaveAndLateHour";
	/**
	 * txtLeaveAndLateMin
	 */
	public static final String	PRM_TXT_LEAVE_AND_LATE_MIN			= "txtLeaveAndLateMin";
	/**
	 * txtOverHour
	 */
	public static final String	PRM_TXT_OVER_HOUR					= "txtOverHour";
	/**
	 * txtOverMin
	 */
	public static final String	PRM_TXT_OVER_MIN					= "txtOverMin";
	/**
	 * txtWorkOnHolidayHour
	 */
	public static final String	PRM_TXT_WORK_ON_HOLIDAY_HOUR		= "txtWorkOnHolidayHour";
	/**
	 * txtWorkOnHolidayMin
	 */
	public static final String	PRM_TXT_WORK_ON_HOLIDAY_MIN			= "txtWorkOnHolidayMin";
	/**
	 * txtLateNightHour
	 */
	public static final String	PRM_TXT_LATE_NIGHT_HOUR				= "txtLateNightHour";
	/**
	 * txtLateNightMin
	 */
	public static final String	PRM_TXT_LATE_NIGHT_MIN				= "txtLateNightMin";
	/**
	 * pltPerfectAttendance
	 */
	public static final String	PRM_PLT_PERFECT_ATTENDANCE			= "pltPerfectAttendance";
	/**
	 * txtSyokuji
	 */
	public static final String	PRM_TXT_SYOKUJI						= "txtSyokuji";
	/**
	 * txtCyoku1
	 */
	public static final String	PRM_TXT_CYOKU1						= "txtCyoku1";
	/**
	 * txtCyoku2
	 */
	public static final String	PRM_TXT_CYOKU2						= "txtCyoku2";
	/**
	 * txtCyoku3
	 */
	public static final String	PRM_TXT_CYOKU3						= "txtCyoku3";
	/**
	 * txtHoka1
	 */
	public static final String	PRM_TXT_HOKA1						= "txtHoka1";
	/**
	 * txtHoka2
	 */
	public static final String	PRM_TXT_HOKA2						= "txtHoka2";
	/**
	 * txtHoka3
	 */
	public static final String	PRM_TXT_HOKA3						= "txtHoka3";
	/**
	 * txtHoka4
	 */
	public static final String	PRM_TXT_HOKA4						= "txtHoka4";
	/**
	 * txtHoka5
	 */
	public static final String	PRM_TXT_HOKA5						= "txtHoka5";
	/**
	 * txtHourHoliday
	 */
	public static final String	PRM_TXT_HOUR_HOLIDAY				= "txtHourHoliday";
	/**
	 * txtWarimashi
	 */
	public static final String	PRM_TXT_WARIMASHI_1_HOUR			= "txtWarimashi1Hour";
	/**
	 * txtWarimashi
	 */
	public static final String	PRM_TXT_WARIMASHI_1_MIN				= "txtWarimashi1Min";
	// ԊO
	/**
	 * txtWeekdayOverHour
	 */
	public static final String	PRM_TXT_WEEKDAY_OVER_HOUR			= "txtWeekdayOverHour";
	/**
	 * txtWeekdayOverMin
	 */
	public static final String	PRM_TXT_WEEKDAY_OVER_MIN			= "txtWeekdayOverMin";
	// xԊO
	/**
	 * txtWeekHolidayOverHour
	 */
	public static final String	PRM_TXT_WEEK_HOLIDAY_OVER_HOUR		= "txtWeekHolidayOverHour";
	/**
	 * txtWeekHolidayOverMin
	 */
	public static final String	PRM_TXT_WEEK_HOLIDAY_OVER_MIN		= "txtWeekHolidayOverMin";
	// 60ԒߕԊO
	/**
	 * txtMonthlyOverHour
	 */
	public static final String	PRM_TXT_MONTHLY_OVER_HOUR			= "txtMonthlyOverHour";
	/**
	 * txtMonthlyOverMin
	 */
	public static final String	PRM_TXT_MONTHLY_OVER_MIN			= "txtMonthlyOverMin";
	// 60ԒߏxԊO
	/**
	 * txtMonthlyWeekHolidayHour
	 */
	public static final String	PRM_TXT_MONTHLY_WEEK_HOLIDAY_HOUR	= "txtMonthlyWeekHolidayHour";
	/**
	 * txtMonthlyWeekHolidayMin
	 */
	public static final String	PRM_TXT_MONTHLY_WEEK_HOLIDAY_MIN	= "txtMonthlyWeekHolidayMin";
	// ԊOԑ֋xɎ擾
	/**
	 * txtSubstituteHoliday
	 */
	public static final String	PRM_TXT_SUBSTITUTE_HOLIDAY			= "txtSubstituteHoliday";
	
	/**
	 * txtHolidayReason
	 */
	public static final String	PRM_TXT_HOLIDAY_REASON				= "txtHolidayReason";
	/**
	 * txtPaidHoliday
	 */
	public static final String	PRM_TXT_PAID_HOLIDAY				= "txtHolidayReason0";
	/**
	 * txtParticularHoliday
	 */
	public static final String	PRM_TXT_PARTICULAR_HOLIDAY			= "txtHolidayReason1";
	/**
	 * txtAbsence
	 */
	public static final String	PRM_TXT_ABSENCE						= "txtHolidayReason2";
	/**
	 * txtMedical
	 */
	public static final String	PRM_TXT_MEDICAL						= "txtHolidayReason3";
	/**
	 * txtCompensationDay
	 */
	public static final String	PRM_TXT_COMPENSATION_DAY			= "txtHolidayReason4";
	/**
	 * txtTransfer
	 */
	public static final String	PRM_TXT_TRANSFER					= "txtHolidayReason5";
	// xɗR6
	/**
	 * txtHolidayReason6
	 */
	public static final String	PRM_TXT_HOLIDAY_REASON_6			= "txtHolidayReason6";
	// xɗR7
	/**
	 * txtHolidayReason7
	 */
	public static final String	PRM_TXT_HOLIDAY_REASON_7			= "txtHolidayReason7";
	// xɗR8
	/**
	 * txtHolidayReason8
	 */
	public static final String	PRM_TXT_HOLIDAY_REASON_8			= "txtHolidayReason8";
	// xɗR9
	/**
	 * txtHolidayReason9
	 */
	public static final String	PRM_TXT_HOLIDAY_REASON_9			= "txtHolidayReason9";
	/**
	 * txtOther
	 */
	public static final String	PRM_TXT_OTHER						= "txtOther";
	
	// tB[h
	private String				hidKCode;
	private String				hidYear;
	private String				hidMonth;
	private String				hidYearMonth;
	private String				lblSelectDate;
	
	private String				txtPresence;
	private String				txtPresenceNumber;
	private String				txtWorkHour;
	private String				txtWorkMin;
	private String				txtBreakHour;
	private String				txtBreakMin;
	
	private String				txtLeaveAndLate;
	private String				txtLeaveAndLateHour;
	private String				txtLeaveAndLateMin;
	private String				txtOverHour;
	private String				txtOverMin;
	private String				txtWorkOnHolidayHour;
	private String				txtWorkOnHolidayMin;
	private String				txtLateNightHour;
	private String				txtLateNightMin;
	private String				pltPerfectAttendance;
	private String				txtSyokuji;
	private String				txtCyoku1;
	private String				txtCyoku2;
	private String				txtCyoku3;
	private String				txtHoka1;
	private String				txtHoka2;
	private String				txtHoka3;
	private String				txtHoka4;
	private String				txtHoka5;
	private String				txtHourHoliday;
	private String				txtWarimashi1Hour;
	private String				txtWarimashi1Min;
	
	private String				txtPaidHoliday;
	private String				txtParticularHoliday;
	private String				txtAbsence;
	private String				txtMedical;
	private String				txtCompensationDay;
	private String				txtTransfer;
	// xɗR6
	private String				txtHolidayReason6;
	// xɗR7
	private String				txtHolidayReason7;
	// xɗR8
	private String				txtHolidayReason8;
	// xɗR9
	private String				txtHolidayReason9;
	private String				txtOther;
	// ԊO
	private String				txtWeekdayOverHour;
	private String				txtWeekdayOverMin;
	// xԊO
	private String				txtWeekHolidayOverHour;
	private String				txtWeekHolidayOverMin;
	// 60ԒߕԊO
	private String				txtMonthlyOverHour;
	private String				txtMonthlyOverMin;
	// 60ԒߏxԊO
	private String				txtMonthlyWeekHolidayHour;
	private String				txtMonthlyWeekHolidayMin;
	// ԊOԑ֋xɎ擾
	private String				txtSubstituteHoliday;
	
	private String				lblAmendment;
	private String[]			aryTxtHolidayReason;
	
	// [h(1FXVA2F\)
	private int					mode;
	
	private boolean				afterReform;
	private boolean				useSubstitute;
	private boolean				useHourHoliday;
	private boolean				useOver60Hour;
	private boolean				isCaution;
	private boolean				isWarning;
	
	private int					hourPaidHoliday;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_K_CODE;
	/**
	 * 
	 */
	public String				NAM_K_NAME;
	/**
	 * 
	 */
	public String				NAM_SECTION;
	/**
	 * 
	 */
	public String				NAM_CALCULATE_TARGET;
	/**
	 * 
	 */
	public String				NAM_PRESENCE;
	/**
	 * 
	 */
	public String				NAM_PRESENCE_NUMBER;
	/**
	 * 
	 */
	public String				NAM_WORK_TIME;
	/**
	 * 
	 */
	public String				NAM_BREAK_TIME;
	// xɗR
	/**
	 * 
	 */
	public String				NAM_PAID_HOLIDAY;
	/**
	 * 
	 */
	public String				NAM_PARTICULAR_HOLIDAY;
	/**
	 * 
	 */
	public String				NAM_ABSENCE;
	/**
	 * 
	 */
	public String				NAM_MEDICAL;
	/**
	 * 
	 */
	public String				NAM_COMPENSATION_DAY;
	/**
	 * 
	 */
	public String				NAM_TRANSFER;
	/**
	 * xɗR6
	 */
	public String				NAM_HOLIDAY_REASON_6;
	/**
	 * xɗR7
	 */
	public String				NAM_HOLIDAY_REASON_7;
	/**
	 * xɗR8
	 */
	public String				NAM_HOLIDAY_REASON_8;
	/**
	 * xɗR9
	 */
	public String				NAM_HOLIDAY_REASON_9;
	/**
	 * 
	 */
	public String				NAM_OTHER;
	/**
	 * 
	 */
	public String				NAM_LEAVE_AND_LATE;
	/**
	 * 
	 */
	public String				NAM_LEAVE_AND_LATE_TIME;
	/**
	 * 
	 */
	public String				NAM_OVER_TIME;
	/**
	 * 
	 */
	public String				NAM_WORK_ON_HOLIDAY_TIME;
	/**
	 * 
	 */
	public String				NAM_LATE_NIGHT_TIME;
	/**
	 * 
	 */
	public String				NAM_PERFECT_ATTENDANCE;
	/**
	 * 
	 */
	public String				NAM_HOUR_HOLIDAY;
	/**
	 * @c
	 */
	public String				NAM_WARIMASHI_1;
	/**
	 * ԊO
	 */
	public String				NAM_WEEKDAY_OVER;
	/**
	 * ԊO()
	 */
	public String				NAM_WEEKDAY_OVER_HOUR;
	/**
	 * ԊO()
	 */
	public String				NAM_WEEKDAY_OVER_MIN;
	/**
	 * xԊO
	 */
	public String				NAM_WEEK_HOLIDAY_OVER;
	/**
	 * xԊO()
	 */
	public String				NAM_WEEK_HOLIDAY_OVER_HOUR;
	/**
	 * xԊO()
	 */
	public String				NAM_WEEK_HOLIDAY_OVER_MIN;
	/**
	 * 60ԒߕԊO
	 */
	public String				NAM_MONTHLY_OVER;
	/**
	 * 60ԒߕԊO()
	 */
	public String				NAM_MONTHLY_OVER_HOUR;
	/**
	 * 60ԒߕԊO()
	 */
	public String				NAM_MONTHLY_OVER_MIN;
	/**
	 * 60ԒߏxԊO
	 */
	public String				NAM_MONTHLY_WEEK_HOLIDAY;
	/**
	 * 60ԒߏxԊO()
	 */
	public String				NAM_MONTHLY_WEEK_HOLIDAY_HOUR;
	/**
	 * 60ԒߏxԊO()
	 */
	public String				NAM_MONTHLY_WEEK_HOLIDAY_MIN;
	/**
	 * ԊOԑ֋xɎ擾
	 */
	public String				NAM_SUBSTITUTE_HOLIDAY;
	/**
	 * ΑӏWvC
	 */
	public String				NAM_AMENDMENT;
	/**
	 * 
	 */
	public int					LEN_TIME;
	/**
	 * 
	 */
	public int					LEN_WORK_HOUR;
	/**
	 * 
	 */
	public int					LEN_NUMBER;
	/**
	 * 
	 */
	public int					LEN_DOUBLE_DAYS;
	
	/**
	 * 蓖
	 */
	public String[][]			aryAllowance;
	/**
	 * xɗR
	 */
	public String[][]			aryHolidayReason;
	/**
	 * xɗR
	 */
	private String[][]			aryHolidayReasonTerm;
	/**
	 * FΎ蓖L
	 */
	public String[][]			aryPerfectAttendanceFlag;
	

	/**
	 * RXgN^
	 */
	public CompileAmendmentCardVo() {
		super();
		setViewPath(getClassName());
		mode = MODE_EDIT;
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_ATT_CALCULATE_AMENDMENT;
		createAryMenu(CMD_MENU_PAYROLL, MosPMenuConst.getMenuAttendanceCalculate());
	}
	
	@Override
	protected void setFieldsName() {
		NAM_K_CODE = CommonConst.NAM_K_CODE;
		NAM_K_NAME = CommonConst.NAM_K_NAME;
		NAM_SECTION = CommonConst.NAM_STATION;
		NAM_CALCULATE_TARGET = CommonConst.NAM_TARGET_MONTH;
		NAM_PRESENCE = CommonConst.NAM_PRESENCE + CommonConst.NAM_NUMBER_OF_DAYS;
		NAM_PRESENCE_NUMBER = CommonConst.NAM_PRESENCE + CommonConst.NAM_NUMBER_OF_TIMES;
		NAM_WORK_TIME = CommonConst.TOTAL_WORK;
		NAM_BREAK_TIME = CommonConst.NAM_INTERVAL_TIME + CommonConst.NAM_COMMON_TIME;
		NAM_OTHER = CommonConst.NAM_OTHER_SHORT + CommonConst.NAM_VACATION_LEAVE + CommonConst.NAM_NUMBER_OF_DAYS;
		NAM_LEAVE_AND_LATE = CommonConst.NAM_LATE_AND_LEAVE_EARLY + CommonConst.NAM_NUMBER_OF_TIMES;
		NAM_LEAVE_AND_LATE_TIME = CommonConst.NAM_LATE_AND_LEAVE_EARLY + CommonConst.NAM_COMMON_TIME;
		NAM_OVER_TIME = CommonConst.NAM_OVERTIME + CommonConst.NAM_COMMON_TIME;
		NAM_WORK_ON_HOLIDAY_TIME = CommonConst.NAM_WORK_ON_HOLIDAY + CommonConst.NAM_COMMON_TIME;
		NAM_LATE_NIGHT_TIME = CommonConst.NAM_LATE_NIGHT + CommonConst.NAM_COMMON_TIME;
		NAM_PERFECT_ATTENDANCE = CommonConst.NAM_PERFECT_ATTENDANCE + CommonConst.NAM_ALLOWANCE;
		LEN_TIME = CommonConst.LEN_TIME_HOUR;
		LEN_WORK_HOUR = CommonConst.LEN_TIME_INT;
		LEN_NUMBER = 2;
		LEN_DOUBLE_DAYS = 4;
		NAM_HOUR_HOLIDAY = CommonConst.NAM_HOUR_HOLIDAY;
		NAM_WARIMASHI_1 = "@c";
		NAM_WEEKDAY_OVER = "ԊO";
		NAM_WEEKDAY_OVER_HOUR = NAM_WEEKDAY_OVER + CommonConst.MSG_HOUR;
		NAM_WEEKDAY_OVER_MIN = NAM_WEEKDAY_OVER + CommonConst.MSG_MINUTES;
		NAM_WEEK_HOLIDAY_OVER = "xԊO";
		NAM_WEEK_HOLIDAY_OVER_HOUR = NAM_WEEK_HOLIDAY_OVER + CommonConst.MSG_HOUR;
		NAM_WEEK_HOLIDAY_OVER_MIN = NAM_WEEK_HOLIDAY_OVER + CommonConst.MSG_MINUTES;
		NAM_MONTHLY_OVER = "ԊO" + StringUtil.surroundRoundBracket(CommonConst.NAM_MONTHLY_OVER_TIME_60_HOUR);
		NAM_MONTHLY_OVER_HOUR = NAM_MONTHLY_OVER + CommonConst.MSG_HOUR;
		NAM_MONTHLY_OVER_MIN = NAM_MONTHLY_OVER + CommonConst.MSG_MINUTES;
		NAM_MONTHLY_WEEK_HOLIDAY = "xԊO"
				+ StringUtil.surroundRoundBracket(CommonConst.NAM_MONTHLY_OVER_TIME_60_HOUR);
		NAM_MONTHLY_WEEK_HOLIDAY_HOUR = NAM_MONTHLY_WEEK_HOLIDAY + CommonConst.MSG_HOUR;
		NAM_MONTHLY_WEEK_HOLIDAY_MIN = NAM_MONTHLY_WEEK_HOLIDAY + CommonConst.MSG_MINUTES;
		NAM_SUBSTITUTE_HOLIDAY = CommonConst.NAM_SUB_HOLIDAY + "擾";
		NAM_AMENDMENT = "ΑӏWvC";
	}
	
	/**
	 * lݒ
	 */
	public void setDefaultValues() {
		setTxtPresence("0");
		setTxtPresenceNumber("0");
		setTxtWorkHour("0");
		setTxtWorkMin("0");
		setTxtBreakHour("0");
		setTxtBreakMin("0");
		setTxtPaidHoliday("0");
		setTxtParticularHoliday("0");
		setTxtAbsence("0");
		setTxtMedical("0");
		setTxtOther("0");
		setTxtLeaveAndLate("0");
		setTxtLeaveAndLateHour("0");
		setTxtLeaveAndLateMin("0");
		setTxtOverHour("0");
		setTxtOverMin("0");
		setTxtWorkOnHolidayHour("0");
		setTxtWorkOnHolidayMin("0");
		setTxtLateNightHour("0");
		setTxtLateNightMin("0");
		setPltPerfectAttendance("0");
		setTxtSyokuji("0");
		setTxtCyoku1("0");
		setTxtCyoku2("0");
		setTxtCyoku3("0");
		setTxtHoka1("0");
		setTxtHoka2("0");
		setTxtHoka3("0");
		setTxtHoka4("0");
		setTxtHoka5("0");
		setTxtHourHoliday("0");
		setTxtWarimashi1Hour("0");
		setTxtWarimashi1Min("0");
		// xɗR6
		setTxtHolidayReason6("0");
		// xɗR7
		setTxtHolidayReason7("0");
		// xɗR8
		setTxtHolidayReason8("0");
		// xɗR9
		setTxtHolidayReason9("0");
		// ԊO
		setTxtWeekdayOverHour("0");
		setTxtWeekdayOverMin("0");
		// xԊO
		setTxtWeekHolidayOverHour("0");
		setTxtWeekHolidayOverMin("0");
		// 60ԒߕԊO
		setTxtMonthlyOverHour("0");
		setTxtMonthlyOverMin("0");
		// 60ԒߏxԊO
		setTxtMonthlyWeekHolidayHour("0");
		setTxtMonthlyWeekHolidayMin("0");
		// ԊOԑ֋xɎ擾
		setTxtSubstituteHoliday("0");
		setLblAmendment("");
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		hidKCode = request.getParameter(PRM_HID_K_CODE);
		hidYear = request.getParameter(PRM_HID_YEAR);
		hidMonth = request.getParameter(PRM_HID_MONTH);
		hidYearMonth = request.getParameter(PRM_HID_YEAR_MONTH);
		txtPresence = request.getParameter(PRM_TXT_PRESENCE);
		txtPresenceNumber = request.getParameter(PRM_TXT_PRESENCE_NUMBER);
		txtWorkHour = request.getParameter(PRM_TXT_WORK_HOUR);
		txtWorkMin = request.getParameter(PRM_TXT_WORK_MIN);
		txtBreakHour = request.getParameter(PRM_TXT_BREAK_HOUR);
		txtBreakMin = request.getParameter(PRM_TXT_BREAK_MIN);
		txtLeaveAndLate = request.getParameter(PRM_TXT_LEAVE_AND_LATE);
		txtLeaveAndLateHour = request.getParameter(PRM_TXT_LEAVE_AND_LATE_HOUR);
		txtLeaveAndLateMin = request.getParameter(PRM_TXT_LEAVE_AND_LATE_MIN);
		txtOverHour = request.getParameter(PRM_TXT_OVER_HOUR);
		txtOverMin = request.getParameter(PRM_TXT_OVER_MIN);
		txtWorkOnHolidayHour = request.getParameter(PRM_TXT_WORK_ON_HOLIDAY_HOUR);
		txtWorkOnHolidayMin = request.getParameter(PRM_TXT_WORK_ON_HOLIDAY_MIN);
		txtLateNightHour = request.getParameter(PRM_TXT_LATE_NIGHT_HOUR);
		txtLateNightMin = request.getParameter(PRM_TXT_LATE_NIGHT_MIN);
		pltPerfectAttendance = request.getParameter(PRM_PLT_PERFECT_ATTENDANCE);
		txtSyokuji = request.getParameter(PRM_TXT_SYOKUJI);
		txtCyoku1 = request.getParameter(PRM_TXT_CYOKU1);
		txtCyoku2 = request.getParameter(PRM_TXT_CYOKU2);
		txtCyoku3 = request.getParameter(PRM_TXT_CYOKU3);
		txtHoka1 = request.getParameter(PRM_TXT_HOKA1);
		txtHoka2 = request.getParameter(PRM_TXT_HOKA2);
		txtHoka3 = request.getParameter(PRM_TXT_HOKA3);
		txtHoka4 = request.getParameter(PRM_TXT_HOKA4);
		txtHoka5 = request.getParameter(PRM_TXT_HOKA5);
		txtHourHoliday = request.getParameter(PRM_TXT_HOUR_HOLIDAY);
		txtWarimashi1Hour = request.getParameter(PRM_TXT_WARIMASHI_1_HOUR);
		txtWarimashi1Min = request.getParameter(PRM_TXT_WARIMASHI_1_MIN);
		// ԊO
		txtWeekdayOverHour = request.getParameter(PRM_TXT_WEEKDAY_OVER_HOUR);
		txtWeekdayOverMin = request.getParameter(PRM_TXT_WEEKDAY_OVER_MIN);
		// xԊO
		txtWeekHolidayOverHour = request.getParameter(PRM_TXT_WEEK_HOLIDAY_OVER_HOUR);
		txtWeekHolidayOverMin = request.getParameter(PRM_TXT_WEEK_HOLIDAY_OVER_MIN);
		// 60ԒߕԊO
		txtMonthlyOverHour = request.getParameter(PRM_TXT_MONTHLY_OVER_HOUR);
		txtMonthlyOverMin = request.getParameter(PRM_TXT_MONTHLY_OVER_MIN);
		// 60ԒߏxԊO
		txtMonthlyWeekHolidayHour = request.getParameter(PRM_TXT_MONTHLY_WEEK_HOLIDAY_HOUR);
		txtMonthlyWeekHolidayMin = request.getParameter(PRM_TXT_MONTHLY_WEEK_HOLIDAY_MIN);
		// ԊOԑ֋xɎ擾
		txtSubstituteHoliday = request.getParameter(PRM_TXT_SUBSTITUTE_HOLIDAY);
		// xɗR
		txtPaidHoliday = request.getParameter(PRM_TXT_PAID_HOLIDAY);
		txtParticularHoliday = request.getParameter(PRM_TXT_PARTICULAR_HOLIDAY);
		txtAbsence = request.getParameter(PRM_TXT_ABSENCE);
		txtMedical = request.getParameter(PRM_TXT_MEDICAL);
		txtCompensationDay = request.getParameter(PRM_TXT_COMPENSATION_DAY);
		txtTransfer = request.getParameter(PRM_TXT_TRANSFER);
		// xɗR6
		txtHolidayReason6 = request.getParameter(PRM_TXT_HOLIDAY_REASON_6);
		// xɗR7
		txtHolidayReason7 = request.getParameter(PRM_TXT_HOLIDAY_REASON_7);
		// xɗR8
		txtHolidayReason8 = request.getParameter(PRM_TXT_HOLIDAY_REASON_8);
		// xɗR9
		txtHolidayReason9 = request.getParameter(PRM_TXT_HOLIDAY_REASON_9);
		txtOther = request.getParameter(PRM_TXT_OTHER);
	}
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException  	MosPOꍇ
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(txtPresence, NAM_PRESENCE, PRM_TXT_PRESENCE);
		checkRequired(txtPresenceNumber, NAM_PRESENCE_NUMBER, PRM_TXT_PRESENCE_NUMBER);
		checkRequired(txtWorkHour, NAM_WORK_TIME, PRM_TXT_WORK_HOUR);
		checkRequired(txtWorkMin, NAM_WORK_TIME, PRM_TXT_WORK_MIN);
		checkRequired(txtBreakHour, NAM_BREAK_TIME, PRM_TXT_BREAK_HOUR);
		checkRequired(txtBreakMin, NAM_BREAK_TIME, PRM_TXT_BREAK_MIN);
		checkRequired(txtPaidHoliday, NAM_PAID_HOLIDAY, PRM_TXT_PAID_HOLIDAY);
		checkRequired(txtParticularHoliday, NAM_PARTICULAR_HOLIDAY, PRM_TXT_PARTICULAR_HOLIDAY);
		checkRequired(txtAbsence, NAM_ABSENCE, PRM_TXT_ABSENCE);
		checkRequired(txtMedical, NAM_MEDICAL, PRM_TXT_MEDICAL);
		checkRequired(txtCompensationDay, NAM_COMPENSATION_DAY, PRM_TXT_COMPENSATION_DAY);
		checkRequired(txtTransfer, NAM_TRANSFER, PRM_TXT_TRANSFER);
		checkRequired(txtOther, NAM_OTHER, PRM_TXT_OTHER);
		checkRequired(txtLeaveAndLate, NAM_LEAVE_AND_LATE, PRM_TXT_LEAVE_AND_LATE);
		checkRequired(txtLeaveAndLateHour, NAM_LEAVE_AND_LATE_TIME, PRM_TXT_LEAVE_AND_LATE_HOUR);
		checkRequired(txtLeaveAndLateMin, NAM_LEAVE_AND_LATE_TIME, PRM_TXT_LEAVE_AND_LATE_MIN);
		checkRequired(txtOverHour, NAM_OVER_TIME, PRM_TXT_OVER_HOUR);
		checkRequired(txtOverMin, NAM_OVER_TIME, PRM_TXT_OVER_MIN);
		checkRequired(txtWorkOnHolidayHour, NAM_WORK_ON_HOLIDAY_TIME, PRM_TXT_WORK_ON_HOLIDAY_HOUR);
		checkRequired(txtWorkOnHolidayMin, NAM_WORK_ON_HOLIDAY_TIME, PRM_TXT_WORK_ON_HOLIDAY_MIN);
		checkRequired(txtLateNightHour, NAM_LATE_NIGHT_TIME, PRM_TXT_LATE_NIGHT_HOUR);
		checkRequired(txtLateNightMin, NAM_LATE_NIGHT_TIME, PRM_TXT_LATE_NIGHT_MIN);
		checkRequired(txtSyokuji, aryAllowance[8][1], PRM_TXT_SYOKUJI);
		checkRequired(txtCyoku1, aryAllowance[9][1], PRM_TXT_CYOKU1);
		checkRequired(txtCyoku2, aryAllowance[10][1], PRM_TXT_CYOKU2);
		checkRequired(txtCyoku3, aryAllowance[11][1], PRM_TXT_CYOKU3);
		checkRequired(txtHoka1, aryAllowance[12][1], PRM_TXT_HOKA1);
		checkRequired(txtHoka2, aryAllowance[13][1], PRM_TXT_HOKA2);
		checkRequired(txtHoka3, aryAllowance[14][1], PRM_TXT_HOKA3);
		checkRequired(txtHoka4, aryAllowance[15][1], PRM_TXT_HOKA4);
		checkRequired(txtHoka5, aryAllowance[16][1], PRM_TXT_HOKA5);
		checkRequired(txtHourHoliday, NAM_HOUR_HOLIDAY, PRM_TXT_HOUR_HOLIDAY);
		checkRequired(txtWarimashi1Hour, NAM_WARIMASHI_1, PRM_TXT_WARIMASHI_1_HOUR);
		checkRequired(txtWarimashi1Min, NAM_WARIMASHI_1, PRM_TXT_WARIMASHI_1_MIN);
		// ԊO
		checkRequired(txtWeekdayOverHour, NAM_WEEKDAY_OVER_HOUR, PRM_TXT_WEEKDAY_OVER_HOUR);
		checkRequired(txtWeekdayOverMin, NAM_WEEKDAY_OVER_MIN, PRM_TXT_WEEKDAY_OVER_MIN);
		// xԊO
		checkRequired(txtWeekHolidayOverHour, NAM_WEEK_HOLIDAY_OVER_HOUR, PRM_TXT_WEEK_HOLIDAY_OVER_HOUR);
		checkRequired(txtWeekHolidayOverMin, NAM_WEEK_HOLIDAY_OVER_MIN, PRM_TXT_WEEK_HOLIDAY_OVER_MIN);
		// 60ԒߕԊO
		checkRequired(txtMonthlyOverHour, NAM_MONTHLY_OVER_HOUR, PRM_TXT_MONTHLY_OVER_HOUR);
		checkRequired(txtMonthlyOverMin, NAM_MONTHLY_OVER_MIN, PRM_TXT_MONTHLY_OVER_MIN);
		// 60ԒߏxԊO
		checkRequired(txtMonthlyWeekHolidayHour, NAM_MONTHLY_WEEK_HOLIDAY_HOUR, PRM_TXT_MONTHLY_WEEK_HOLIDAY_HOUR);
		checkRequired(txtMonthlyWeekHolidayMin, NAM_MONTHLY_WEEK_HOLIDAY_MIN, PRM_TXT_MONTHLY_WEEK_HOLIDAY_MIN);
		// ԊOԑ֋xɎ擾
		checkRequired(txtSubstituteHoliday, NAM_SUBSTITUTE_HOLIDAY, PRM_TXT_SUBSTITUTE_HOLIDAY);
		// 񒷊mF
		checkLength(txtPresence, LEN_DOUBLE_DAYS, NAM_PRESENCE, PRM_TXT_PRESENCE);
		checkLength(txtPresenceNumber, LEN_DOUBLE_DAYS, NAM_PRESENCE_NUMBER, PRM_TXT_PRESENCE_NUMBER);
		checkLength(txtWorkHour, LEN_WORK_HOUR, NAM_WORK_TIME, PRM_TXT_WORK_HOUR);
		checkLength(txtWorkMin, LEN_TIME, NAM_WORK_TIME, PRM_TXT_WORK_MIN);
		checkLength(txtBreakHour, LEN_TIME, NAM_BREAK_TIME, PRM_TXT_BREAK_HOUR);
		checkLength(txtBreakMin, LEN_TIME, NAM_BREAK_TIME, PRM_TXT_BREAK_MIN);
		checkLength(txtOther, LEN_DOUBLE_DAYS, NAM_OTHER, PRM_TXT_OTHER);
		checkLength(txtLeaveAndLate, LEN_NUMBER, NAM_LEAVE_AND_LATE, PRM_TXT_LEAVE_AND_LATE);
		checkLength(txtLeaveAndLateHour, LEN_NUMBER, NAM_LEAVE_AND_LATE_TIME, PRM_TXT_LEAVE_AND_LATE_HOUR);
		checkLength(txtLeaveAndLateMin, LEN_NUMBER, NAM_LEAVE_AND_LATE_TIME, PRM_TXT_LEAVE_AND_LATE_MIN);
		checkLength(txtOverHour, LEN_TIME, NAM_OVER_TIME, PRM_TXT_OVER_HOUR);
		checkLength(txtOverMin, LEN_TIME, NAM_OVER_TIME, PRM_TXT_OVER_MIN);
		checkLength(txtWorkOnHolidayHour, LEN_TIME, NAM_WORK_ON_HOLIDAY_TIME, PRM_TXT_WORK_ON_HOLIDAY_HOUR);
		checkLength(txtWorkOnHolidayMin, LEN_TIME, NAM_WORK_ON_HOLIDAY_TIME, PRM_TXT_WORK_ON_HOLIDAY_MIN);
		checkLength(txtLateNightHour, LEN_TIME, NAM_LATE_NIGHT_TIME, PRM_TXT_LATE_NIGHT_HOUR);
		checkLength(txtLateNightMin, LEN_TIME, NAM_LATE_NIGHT_TIME, PRM_TXT_LATE_NIGHT_MIN);
		checkLength(txtSyokuji, LEN_NUMBER, aryAllowance[8][1], PRM_TXT_SYOKUJI);
		checkLength(txtCyoku1, LEN_NUMBER, aryAllowance[9][1], PRM_TXT_CYOKU1);
		checkLength(txtCyoku2, LEN_NUMBER, aryAllowance[10][1], PRM_TXT_CYOKU2);
		checkLength(txtCyoku3, LEN_NUMBER, aryAllowance[11][1], PRM_TXT_CYOKU3);
		checkLength(txtHoka1, LEN_NUMBER, aryAllowance[12][1], PRM_TXT_HOKA1);
		checkLength(txtHoka2, LEN_NUMBER, aryAllowance[13][1], PRM_TXT_HOKA2);
		checkLength(txtHoka3, LEN_NUMBER, aryAllowance[14][1], PRM_TXT_HOKA3);
		checkLength(txtHoka4, LEN_NUMBER, aryAllowance[15][1], PRM_TXT_HOKA4);
		checkLength(txtHoka5, LEN_NUMBER, aryAllowance[16][1], PRM_TXT_HOKA5);
		checkLength(txtHourHoliday, LEN_NUMBER, NAM_HOUR_HOLIDAY, PRM_TXT_HOUR_HOLIDAY);
		checkLength(txtWarimashi1Hour, LEN_NUMBER, NAM_WARIMASHI_1, PRM_TXT_WARIMASHI_1_HOUR);
		checkLength(txtWarimashi1Min, LEN_NUMBER, NAM_WARIMASHI_1, PRM_TXT_WARIMASHI_1_MIN);
		// ԊO
		checkLength(txtWeekdayOverHour, LEN_TIME, NAM_WEEKDAY_OVER_HOUR, PRM_TXT_WEEKDAY_OVER_HOUR);
		checkLength(txtWeekdayOverMin, LEN_TIME, NAM_WEEKDAY_OVER_MIN, PRM_TXT_WEEKDAY_OVER_MIN);
		// xԊO
		checkLength(txtWeekHolidayOverHour, LEN_TIME, NAM_WEEK_HOLIDAY_OVER_HOUR, PRM_TXT_WEEK_HOLIDAY_OVER_HOUR);
		checkLength(txtWeekHolidayOverMin, LEN_TIME, NAM_WEEK_HOLIDAY_OVER_MIN, PRM_TXT_WEEK_HOLIDAY_OVER_MIN);
		// 60ԒߕԊO
		checkLength(txtMonthlyOverHour, LEN_TIME, NAM_MONTHLY_OVER_HOUR, PRM_TXT_MONTHLY_OVER_HOUR);
		checkLength(txtMonthlyOverMin, LEN_TIME, NAM_MONTHLY_OVER_MIN, PRM_TXT_MONTHLY_OVER_MIN);
		// 60ԒߏxԊO
		checkLength(txtMonthlyWeekHolidayHour, LEN_TIME, NAM_MONTHLY_WEEK_HOLIDAY_HOUR,
				PRM_TXT_MONTHLY_WEEK_HOLIDAY_HOUR);
		checkLength(txtMonthlyWeekHolidayMin, LEN_TIME, NAM_MONTHLY_WEEK_HOLIDAY_MIN, PRM_TXT_MONTHLY_WEEK_HOLIDAY_MIN);
		// ԊOԑ֋xɎ擾
		checkLength(txtSubstituteHoliday, LEN_DOUBLE_DAYS, NAM_SUBSTITUTE_HOLIDAY, PRM_TXT_SUBSTITUTE_HOLIDAY);
		// ^CvmF
		checkNumeric(txtPresence, NAM_PRESENCE, PRM_TXT_PRESENCE);
		checkNumber(txtPresenceNumber, NAM_PRESENCE_NUMBER, PRM_TXT_PRESENCE_NUMBER);
		checkNumber(txtWorkHour, NAM_WORK_TIME, PRM_TXT_WORK_HOUR);
		checkNumber(txtWorkMin, NAM_WORK_TIME, PRM_TXT_WORK_MIN);
		checkNumber(txtBreakHour, NAM_BREAK_TIME, PRM_TXT_BREAK_HOUR);
		checkNumber(txtBreakMin, NAM_BREAK_TIME, PRM_TXT_BREAK_MIN);
		checkNumeric(txtPaidHoliday, NAM_PAID_HOLIDAY, PRM_TXT_PAID_HOLIDAY);
		checkNumeric(txtParticularHoliday, NAM_PARTICULAR_HOLIDAY, PRM_TXT_PARTICULAR_HOLIDAY);
		checkNumeric(txtAbsence, NAM_ABSENCE, PRM_TXT_ABSENCE);
		checkNumeric(txtMedical, NAM_MEDICAL, PRM_TXT_MEDICAL);
		checkNumeric(txtCompensationDay, NAM_COMPENSATION_DAY, PRM_TXT_COMPENSATION_DAY);
		checkNumeric(txtTransfer, NAM_TRANSFER, PRM_TXT_TRANSFER);
		checkNumeric(txtOther, NAM_OTHER, PRM_TXT_OTHER);
		checkNumber(txtLeaveAndLate, NAM_LEAVE_AND_LATE, PRM_TXT_LEAVE_AND_LATE);
		checkNumber(txtLeaveAndLateHour, NAM_LEAVE_AND_LATE_TIME, PRM_TXT_LEAVE_AND_LATE_HOUR);
		checkNumber(txtLeaveAndLateMin, NAM_LEAVE_AND_LATE_TIME, PRM_TXT_LEAVE_AND_LATE_MIN);
		checkNumber(txtOverHour, NAM_OVER_TIME, PRM_TXT_OVER_HOUR);
		checkNumber(txtOverMin, NAM_OVER_TIME, PRM_TXT_OVER_MIN);
		checkNumber(txtWorkOnHolidayHour, NAM_WORK_ON_HOLIDAY_TIME, PRM_TXT_WORK_ON_HOLIDAY_HOUR);
		checkNumber(txtWorkOnHolidayMin, NAM_WORK_ON_HOLIDAY_TIME, PRM_TXT_WORK_ON_HOLIDAY_MIN);
		checkNumber(txtLateNightHour, NAM_LATE_NIGHT_TIME, PRM_TXT_LATE_NIGHT_HOUR);
		checkNumber(txtLateNightMin, NAM_LATE_NIGHT_TIME, PRM_TXT_LATE_NIGHT_MIN);
		checkNumber(txtSyokuji, aryAllowance[8][1], PRM_TXT_SYOKUJI);
		checkNumber(txtCyoku1, aryAllowance[9][1], PRM_TXT_CYOKU1);
		checkNumber(txtCyoku2, aryAllowance[10][1], PRM_TXT_CYOKU2);
		checkNumber(txtCyoku3, aryAllowance[11][1], PRM_TXT_CYOKU3);
		checkNumber(txtHoka1, aryAllowance[12][1], PRM_TXT_HOKA1);
		checkNumber(txtHoka2, aryAllowance[13][1], PRM_TXT_HOKA2);
		checkNumber(txtHoka3, aryAllowance[14][1], PRM_TXT_HOKA3);
		checkNumber(txtHoka4, aryAllowance[15][1], PRM_TXT_HOKA4);
		checkNumber(txtHoka5, aryAllowance[16][1], PRM_TXT_HOKA5);
		checkNumber(txtHourHoliday, NAM_HOUR_HOLIDAY, PRM_TXT_HOUR_HOLIDAY);
		checkNumber(txtWarimashi1Hour, NAM_WARIMASHI_1, PRM_TXT_WARIMASHI_1_HOUR);
		checkNumber(txtWarimashi1Min, NAM_WARIMASHI_1, PRM_TXT_WARIMASHI_1_MIN);
		// ԊO
		checkNumber(txtWeekdayOverHour, NAM_WEEKDAY_OVER_HOUR, PRM_TXT_WEEKDAY_OVER_HOUR);
		checkNumber(txtWeekdayOverMin, NAM_WEEKDAY_OVER_MIN, PRM_TXT_WEEKDAY_OVER_MIN);
		// xԊO
		checkNumber(txtWeekHolidayOverHour, NAM_WEEK_HOLIDAY_OVER_HOUR, PRM_TXT_WEEK_HOLIDAY_OVER_HOUR);
		checkNumber(txtWeekHolidayOverMin, NAM_WEEK_HOLIDAY_OVER_MIN, PRM_TXT_WEEK_HOLIDAY_OVER_MIN);
		// 60ԒߕԊO
		checkNumber(txtMonthlyOverHour, NAM_MONTHLY_OVER_HOUR, PRM_TXT_MONTHLY_OVER_HOUR);
		checkNumber(txtMonthlyOverMin, NAM_MONTHLY_OVER_MIN, PRM_TXT_MONTHLY_OVER_MIN);
		// 60ԒߏxԊO
		checkNumber(txtMonthlyWeekHolidayHour, NAM_MONTHLY_WEEK_HOLIDAY_HOUR, PRM_TXT_MONTHLY_WEEK_HOLIDAY_HOUR);
		checkNumber(txtMonthlyWeekHolidayMin, NAM_MONTHLY_WEEK_HOLIDAY_MIN, PRM_TXT_MONTHLY_WEEK_HOLIDAY_MIN);
		// ԊOԑ֋xɎ擾
		checkNumeric(txtSubstituteHoliday, NAM_SUBSTITUTE_HOLIDAY, PRM_TXT_SUBSTITUTE_HOLIDAY);
		// xɗR6
		if (StringUtil.isNotNull(NAM_HOLIDAY_REASON_6)) {
			checkRequired(txtHolidayReason6, NAM_HOLIDAY_REASON_6, PRM_TXT_HOLIDAY_REASON_6);
			checkLength(txtHolidayReason6, LEN_DOUBLE_DAYS, NAM_HOLIDAY_REASON_6, PRM_TXT_HOLIDAY_REASON_6);
			checkNumeric(txtHolidayReason6, NAM_HOLIDAY_REASON_6, PRM_TXT_HOLIDAY_REASON_6);
		}
		// xɗR7
		if (StringUtil.isNotNull(NAM_HOLIDAY_REASON_7)) {
			checkRequired(txtHolidayReason7, NAM_HOLIDAY_REASON_7, PRM_TXT_HOLIDAY_REASON_7);
			checkLength(txtHolidayReason7, LEN_DOUBLE_DAYS, NAM_HOLIDAY_REASON_7, PRM_TXT_HOLIDAY_REASON_7);
			checkNumeric(txtHolidayReason7, NAM_HOLIDAY_REASON_7, PRM_TXT_HOLIDAY_REASON_7);
		}
		// xɗR8
		if (StringUtil.isNotNull(NAM_HOLIDAY_REASON_8)) {
			checkRequired(txtHolidayReason8, NAM_HOLIDAY_REASON_8, PRM_TXT_HOLIDAY_REASON_8);
			checkLength(txtHolidayReason8, LEN_DOUBLE_DAYS, NAM_HOLIDAY_REASON_8, PRM_TXT_HOLIDAY_REASON_8);
			checkNumeric(txtHolidayReason8, NAM_HOLIDAY_REASON_8, PRM_TXT_HOLIDAY_REASON_8);
		}
		// xɗR9
		if (StringUtil.isNotNull(NAM_HOLIDAY_REASON_9)) {
			checkRequired(txtHolidayReason9, NAM_HOLIDAY_REASON_9, PRM_TXT_HOLIDAY_REASON_9);
			checkLength(txtHolidayReason9, LEN_DOUBLE_DAYS, NAM_HOLIDAY_REASON_9, PRM_TXT_HOLIDAY_REASON_9);
			checkNumeric(txtHolidayReason9, NAM_HOLIDAY_REASON_9, PRM_TXT_HOLIDAY_REASON_9);
		}
		// ÓmFI
		endValidation();
	}
	
	@Override
	public String getDirectJs(Class<?> cls, Object obj) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls, obj));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		sb.append(getSettingJs("ARY_ALLOWANCE", aryAllowance));
		sb.append(getSettingJs("ARY_HOLIDAY_REASON", aryHolidayReason));
		// J@
		sb.append("var AFTER_REFORM = ");
		sb.append(afterReform);
		sb.append(";");
		// x@\
		sb.append("var SUBSTITUTE = ");
		sb.append(useSubstitute);
		sb.append(";");
		// ԒPʔNx
		sb.append("var HOUR_HOLIDAY = ");
		sb.append(useHourHoliday);
		sb.append(";");
		// 60
		sb.append("var OVER_60_HOUR = ");
		sb.append(useOver60Hour);
		sb.append(";");
		// x
		sb.append("var CAUTION = ");
		sb.append(isCaution);
		sb.append(";");
		// 
		sb.append("var WARNING = ");
		sb.append(isWarning);
		sb.append(";");
		// ԒPʔNx`FbN
		sb.append("var HOUR_PAID_HOLIDAY = ");
		sb.append(hourPaidHoliday);
		sb.append(";");
		return sb.toString();
	}
	
	// ANZT\bh
	/**
	 * @return hidKCode
	 */
	public String getHidKCode() {
		return hidKCode;
	}
	
	/**
	 * @return hidYear
	 */
	public String getHidYear() {
		return hidYear;
	}
	
	/**
	 * @return hidMonth
	 */
	public String getHidMonth() {
		return hidMonth;
	}
	
	/**
	 * @return lblSelectDate
	 */
	public String getLblSelectDate() {
		return lblSelectDate;
	}
	
	/**
	 * @return txtPresence
	 */
	public String getTxtPresence() {
		return txtPresence;
	}
	
	/**
	 * @return txtPresenceNumber
	 */
	public String getTxtPresenceNumber() {
		return txtPresenceNumber;
	}
	
	/**
	 * @return txtWorkHour
	 */
	public String getTxtWorkHour() {
		return txtWorkHour;
	}
	
	/**
	 * @return txtWorkMin
	 */
	public String getTxtWorkMin() {
		return txtWorkMin;
	}
	
	/**
	 * @return txtBreakHour
	 */
	public String getTxtBreakHour() {
		return txtBreakHour;
	}
	
	/**
	 * @return txtBreakMin
	 */
	public String getTxtBreakMin() {
		return txtBreakMin;
	}
	
	/**
	 * @return txtPaidHoliday
	 */
	public String getTxtPaidHoliday() {
		return txtPaidHoliday;
	}
	
	/**
	 * @return txtParticularHoliday
	 */
	public String getTxtParticularHoliday() {
		return txtParticularHoliday;
	}
	
	/**
	 * @return txtAbsence
	 */
	public String getTxtAbsence() {
		return txtAbsence;
	}
	
	/**
	 * @return txtMedical
	 */
	public String getTxtMedical() {
		return txtMedical;
	}
	
	/**
	 * @return txtCompensationDay
	 */
	public String getTxtCompensationDay() {
		return txtCompensationDay;
	}
	
	/**
	 * @return txtTransfer
	 */
	public String getTxtTransfer() {
		return txtTransfer;
	}
	
	/**
	 * @return txtOther
	 */
	public String getTxtOther() {
		return txtOther;
	}
	
	/**
	 * @return txtLeaveAndLate
	 */
	public String getTxtLeaveAndLate() {
		return txtLeaveAndLate;
	}
	
	/**
	 * @return txtOverHour
	 */
	public String getTxtOverHour() {
		return txtOverHour;
	}
	
	/**
	 * @return txtOverMin
	 */
	public String getTxtOverMin() {
		return txtOverMin;
	}
	
	/**
	 * @return txtWorkOnHolidayHour
	 */
	public String getTxtWorkOnHolidayHour() {
		return txtWorkOnHolidayHour;
	}
	
	/**
	 * @return txtWorkOnHolidayMin
	 */
	public String getTxtWorkOnHolidayMin() {
		return txtWorkOnHolidayMin;
	}
	
	/**
	 * @return txtLateNightHour
	 */
	public String getTxtLateNightHour() {
		return txtLateNightHour;
	}
	
	/**
	 * @return txtLateNightMin
	 */
	public String getTxtLateNightMin() {
		return txtLateNightMin;
	}
	
	/**
	 * @return pltPerfectAttendance
	 */
	public String getPltPerfectAttendance() {
		return pltPerfectAttendance;
	}
	
	/**
	 * @return txtSyokuji
	 */
	public String getTxtSyokuji() {
		return txtSyokuji;
	}
	
	/**
	 * @return txtCyoku1
	 */
	public String getTxtCyoku1() {
		return txtCyoku1;
	}
	
	/**
	 * @return txtCyoku2
	 */
	public String getTxtCyoku2() {
		return txtCyoku2;
	}
	
	/**
	 * @return txtCyoku3
	 */
	public String getTxtCyoku3() {
		return txtCyoku3;
	}
	
	/**
	 * @return txtHoka1
	 */
	public String getTxtHoka1() {
		return txtHoka1;
	}
	
	/**
	 * @return txtHoka2
	 */
	public String getTxtHoka2() {
		return txtHoka2;
	}
	
	/**
	 * @return txtHoka3
	 */
	public String getTxtHoka3() {
		return txtHoka3;
	}
	
	/**
	 * @return txtHoka4
	 */
	public String getTxtHoka4() {
		return txtHoka4;
	}
	
	/**
	 * @return txtHoka5
	 */
	public String getTxtHoka5() {
		return txtHoka5;
	}
	
	/**
	 * @return txtHourHoliday
	 */
	public String getTxtHourHoliday() {
		return txtHourHoliday;
	}
	
	/**
	 * @return txtHolidayReason6
	 */
	public String getTxtHolidayReason6() {
		return txtHolidayReason6;
	}
	
	/**
	 * @return txtHolidayReason7
	 */
	public String getTxtHolidayReason7() {
		return txtHolidayReason7;
	}
	
	/**
	 * @return txtHolidayReason8
	 */
	public String getTxtHolidayReason8() {
		return txtHolidayReason8;
	}
	
	/**
	 * @return txtHolidayReason9
	 */
	public String getTxtHolidayReason9() {
		return txtHolidayReason9;
	}
	
	/**
	 * @return txtWeekdayOverHour
	 */
	public String getTxtWeekdayOverHour() {
		return txtWeekdayOverHour;
	}
	
	/**
	 * @return txtWeekdayOverMin
	 */
	public String getTxtWeekdayOverMin() {
		return txtWeekdayOverMin;
	}
	
	/**
	 * @return txtWeekHolidayOverHour
	 */
	public String getTxtWeekHolidayOverHour() {
		return txtWeekHolidayOverHour;
	}
	
	/**
	 * @return txtWeekHolidayOverMin
	 */
	public String getTxtWeekHolidayOverMin() {
		return txtWeekHolidayOverMin;
	}
	
	/**
	 * @return txtMonthlyOverHour
	 */
	public String getTxtMonthlyOverHour() {
		return txtMonthlyOverHour;
	}
	
	/**
	 * @return txtMonthlyOverMin
	 */
	public String getTxtMonthlyOverMin() {
		return txtMonthlyOverMin;
	}
	
	/**
	 * @return txtMonthlyWeekHolidayHour
	 */
	public String getTxtMonthlyWeekHolidayHour() {
		return txtMonthlyWeekHolidayHour;
	}
	
	/**
	 * @return txtMonthlyWeekHolidayMin
	 */
	public String getTxtMonthlyWeekHolidayMin() {
		return txtMonthlyWeekHolidayMin;
	}
	
	/**
	 * @return txtSubstituteHoliday
	 */
	public String getTxtSubstituteHoliday() {
		return txtSubstituteHoliday;
	}
	
	/**
	 * @return mode
	 */
	public int getMode() {
		return mode;
	}
	
	/**
	 * @param hidKCode Zbg hidKCode
	 */
	public void setHidKCode(String hidKCode) {
		this.hidKCode = hidKCode;
	}
	
	/**
	 * @param hidYear Zbg hidYear
	 */
	public void setHidYear(String hidYear) {
		this.hidYear = hidYear;
	}
	
	/**
	 * @param hidMonth Zbg hidMonth
	 */
	public void setHidMonth(String hidMonth) {
		this.hidMonth = hidMonth;
	}
	
	/**
	 * @param lblSelectDate Zbg lblSelectDate
	 */
	public void setLblSelectDate(String lblSelectDate) {
		this.lblSelectDate = lblSelectDate;
	}
	
	/**
	 * @param txtPresence Zbg txtPresence
	 */
	public void setTxtPresence(String txtPresence) {
		this.txtPresence = txtPresence;
	}
	
	/**
	 * @param txtPresenceNumber Zbg txtPresenceNumber
	 */
	public void setTxtPresenceNumber(String txtPresenceNumber) {
		this.txtPresenceNumber = txtPresenceNumber;
	}
	
	/**
	 * @param txtWorkHour Zbg txtWorkHour
	 */
	public void setTxtWorkHour(String txtWorkHour) {
		this.txtWorkHour = txtWorkHour;
	}
	
	/**
	 * @param txtWorkMin Zbg txtWorkMin
	 */
	public void setTxtWorkMin(String txtWorkMin) {
		this.txtWorkMin = txtWorkMin;
	}
	
	/**
	 * @param txtBreakHour Zbg txtBreakHour
	 */
	public void setTxtBreakHour(String txtBreakHour) {
		this.txtBreakHour = txtBreakHour;
	}
	
	/**
	 * @param txtBreakMin Zbg txtBreakMin
	 */
	public void setTxtBreakMin(String txtBreakMin) {
		this.txtBreakMin = txtBreakMin;
	}
	
	/**
	 * @param txtPaidHoliday Zbg txtPaidHoliday
	 */
	public void setTxtPaidHoliday(String txtPaidHoliday) {
		this.txtPaidHoliday = txtPaidHoliday;
	}
	
	/**
	 * @param txtParticularHoliday Zbg txtParticularHoliday
	 */
	public void setTxtParticularHoliday(String txtParticularHoliday) {
		this.txtParticularHoliday = txtParticularHoliday;
	}
	
	/**
	 * @param txtAbsence Zbg txtAbsence
	 */
	public void setTxtAbsence(String txtAbsence) {
		this.txtAbsence = txtAbsence;
	}
	
	/**
	 * @param txtMedical Zbg txtMedical
	 */
	public void setTxtMedical(String txtMedical) {
		this.txtMedical = txtMedical;
	}
	
	/**
	 * @param txtCompensationDay Zbg txtCompensationDay
	 */
	public void setTxtCompensationDay(String txtCompensationDay) {
		this.txtCompensationDay = txtCompensationDay;
	}
	
	/**
	 * @param txtTransfer Zbg txtTransfer
	 */
	public void setTxtTransfer(String txtTransfer) {
		this.txtTransfer = txtTransfer;
	}
	
	/**
	 * @param txtOther Zbg txtOther
	 */
	public void setTxtOther(String txtOther) {
		this.txtOther = txtOther;
	}
	
	/**
	 * @param txtLeaveAndLate Zbg txtLeaveAndLate
	 */
	public void setTxtLeaveAndLate(String txtLeaveAndLate) {
		this.txtLeaveAndLate = txtLeaveAndLate;
	}
	
	/**
	 * @param txtOverHour Zbg txtOverHour
	 */
	public void setTxtOverHour(String txtOverHour) {
		this.txtOverHour = txtOverHour;
	}
	
	/**
	 * @param txtOverMin Zbg txtOverMin
	 */
	public void setTxtOverMin(String txtOverMin) {
		this.txtOverMin = txtOverMin;
	}
	
	/**
	 * @param txtWorkOnHolidayHour Zbg txtWorkOnHolidayHour
	 */
	public void setTxtWorkOnHolidayHour(String txtWorkOnHolidayHour) {
		this.txtWorkOnHolidayHour = txtWorkOnHolidayHour;
	}
	
	/**
	 * @param txtWorkOnHolidayMin Zbg txtWorkOnHolidayMin
	 */
	public void setTxtWorkOnHolidayMin(String txtWorkOnHolidayMin) {
		this.txtWorkOnHolidayMin = txtWorkOnHolidayMin;
	}
	
	/**
	 * @param txtLateNightHour Zbg txtLateNightHour
	 */
	public void setTxtLateNightHour(String txtLateNightHour) {
		this.txtLateNightHour = txtLateNightHour;
	}
	
	/**
	 * @param txtLateNightMin Zbg txtLateNightMin
	 */
	public void setTxtLateNightMin(String txtLateNightMin) {
		this.txtLateNightMin = txtLateNightMin;
	}
	
	/**
	 * @param pltPerfectAttendance Zbg pltPerfectAttendance
	 */
	public void setPltPerfectAttendance(String pltPerfectAttendance) {
		this.pltPerfectAttendance = pltPerfectAttendance;
	}
	
	/**
	 * @param txtSyokuji Zbg txtSyokuji
	 */
	public void setTxtSyokuji(String txtSyokuji) {
		this.txtSyokuji = txtSyokuji;
	}
	
	/**
	 * @param txtCyoku1 Zbg txtCyoku1
	 */
	public void setTxtCyoku1(String txtCyoku1) {
		this.txtCyoku1 = txtCyoku1;
	}
	
	/**
	 * @param txtCyoku2 Zbg txtCyoku2
	 */
	public void setTxtCyoku2(String txtCyoku2) {
		this.txtCyoku2 = txtCyoku2;
	}
	
	/**
	 * @param txtCyoku3 Zbg txtCyoku3
	 */
	public void setTxtCyoku3(String txtCyoku3) {
		this.txtCyoku3 = txtCyoku3;
	}
	
	/**
	 * @param txtHoka1 Zbg txtHoka1
	 */
	public void setTxtHoka1(String txtHoka1) {
		this.txtHoka1 = txtHoka1;
	}
	
	/**
	 * @param txtHoka2 Zbg txtHoka2
	 */
	public void setTxtHoka2(String txtHoka2) {
		this.txtHoka2 = txtHoka2;
	}
	
	/**
	 * @param txtHoka3 Zbg txtHoka3
	 */
	public void setTxtHoka3(String txtHoka3) {
		this.txtHoka3 = txtHoka3;
	}
	
	/**
	 * @param txtHoka4 Zbg txtHoka4
	 */
	public void setTxtHoka4(String txtHoka4) {
		this.txtHoka4 = txtHoka4;
	}
	
	/**
	 * @param txtHoka5 Zbg txtHoka5
	 */
	public void setTxtHoka5(String txtHoka5) {
		this.txtHoka5 = txtHoka5;
	}
	
	/**
	 * @param txtHourHoliday Zbg txtHourHoliday
	 */
	public void setTxtHourHoliday(String txtHourHoliday) {
		this.txtHourHoliday = txtHourHoliday;
	}
	
	/**
	 * @param txtHolidayReason6 Zbg txtHolidayReason6
	 */
	public void setTxtHolidayReason6(String txtHolidayReason6) {
		this.txtHolidayReason6 = txtHolidayReason6;
	}
	
	/**
	 * @param txtHolidayReason7 Zbg txtHolidayReason7
	 */
	public void setTxtHolidayReason7(String txtHolidayReason7) {
		this.txtHolidayReason7 = txtHolidayReason7;
	}
	
	/**
	 * @param txtHolidayReason8 Zbg txtHolidayReason8
	 */
	public void setTxtHolidayReason8(String txtHolidayReason8) {
		this.txtHolidayReason8 = txtHolidayReason8;
	}
	
	/**
	 * @param txtHolidayReason9 Zbg txtHolidayReason9
	 */
	public void setTxtHolidayReason9(String txtHolidayReason9) {
		this.txtHolidayReason9 = txtHolidayReason9;
	}
	
	/**
	 * @param txtWeekdayOverHour Zbg txtWeekdayOverHour
	 */
	public void setTxtWeekdayOverHour(String txtWeekdayOverHour) {
		this.txtWeekdayOverHour = txtWeekdayOverHour;
	}
	
	/**
	 * @param txtWeekdayOverMin Zbg txtWeekdayOverMin
	 */
	public void setTxtWeekdayOverMin(String txtWeekdayOverMin) {
		this.txtWeekdayOverMin = txtWeekdayOverMin;
	}
	
	/**
	 * @param txtWeekHolidayOverHour Zbg txtWeekHolidayOverHour
	 */
	public void setTxtWeekHolidayOverHour(String txtWeekHolidayOverHour) {
		this.txtWeekHolidayOverHour = txtWeekHolidayOverHour;
	}
	
	/**
	 * @param txtWeekHolidayOverMin Zbg txtWeekHolidayOverMin
	 */
	public void setTxtWeekHolidayOverMin(String txtWeekHolidayOverMin) {
		this.txtWeekHolidayOverMin = txtWeekHolidayOverMin;
	}
	
	/**
	 * @param txtMonthlyOverHour Zbg txtMonthlyOverHour
	 */
	public void setTxtMonthlyOverHour(String txtMonthlyOverHour) {
		this.txtMonthlyOverHour = txtMonthlyOverHour;
	}
	
	/**
	 * @param txtMonthlyOverMin Zbg txtMonthlyOverMin
	 */
	public void setTxtMonthlyOverMin(String txtMonthlyOverMin) {
		this.txtMonthlyOverMin = txtMonthlyOverMin;
	}
	
	/**
	 * @param txtMonthlyWeekHolidayHour Zbg txtMonthlyWeekHolidayHour
	 */
	public void setTxtMonthlyWeekHolidayHour(String txtMonthlyWeekHolidayHour) {
		this.txtMonthlyWeekHolidayHour = txtMonthlyWeekHolidayHour;
	}
	
	/**
	 * @param txtMonthlyWeekHolidayMin Zbg txtMonthlyWeekHolidayMin
	 */
	public void setTxtMonthlyWeekHolidayMin(String txtMonthlyWeekHolidayMin) {
		this.txtMonthlyWeekHolidayMin = txtMonthlyWeekHolidayMin;
	}
	
	/**
	 * @param txtSubstituteHoliday Zbg txtSubstituteHoliday
	 */
	public void setTxtSubstituteHoliday(String txtSubstituteHoliday) {
		this.txtSubstituteHoliday = txtSubstituteHoliday;
	}
	
	/**
	 * @param mode Zbg mode
	 */
	public void setMode(int mode) {
		this.mode = mode;
	}
	
	/**
	 * @param aryHolidayReasonTerm Zbg aryHolidayReasonTerm
	 */
	public void setAryHolidayReasonTerm(String[][] aryHolidayReasonTerm) {
		this.aryHolidayReasonTerm = aryHolidayReasonTerm.clone();
	}
	
	/**
	 * @return aryHolidayReasonTerm
	 */
	public String[][] getAryHolidayReasonTerm() {
		return aryHolidayReasonTerm.clone();
	}
	
	/**
	 * @return txtWarimashi1Hour
	 */
	public String getTxtWarimashi1Hour() {
		return txtWarimashi1Hour;
	}
	
	/**
	 * @return txtWarimashi1Min
	 */
	public String getTxtWarimashi1Min() {
		return txtWarimashi1Min;
	}
	
	/**
	 * @param txtWarimashi1Hour Zbg txtWarimashi1Hour
	 */
	public void setTxtWarimashi1Hour(String txtWarimashi1Hour) {
		this.txtWarimashi1Hour = txtWarimashi1Hour;
	}
	
	/**
	 * @param txtWarimashi1Min Zbg txtWarimashi1Min
	 */
	public void setTxtWarimashi1Min(String txtWarimashi1Min) {
		this.txtWarimashi1Min = txtWarimashi1Min;
	}
	
	/**
	 * @return aryTxtHolidayReason
	 */
	public String[] getAryTxtHolidayReason() {
		return aryTxtHolidayReason.clone();
	}
	
	/**
	 * @param aryTxtHolidayReason Zbg aryTxtHolidayReason
	 */
	public void setAryTxtHolidayReason(String[] aryTxtHolidayReason) {
		this.aryTxtHolidayReason = aryTxtHolidayReason.clone();
	}
	
	/**
	 * @return txtLeaveAndLateHour
	 */
	public String getTxtLeaveAndLateHour() {
		return txtLeaveAndLateHour;
	}
	
	/**
	 * @return txtLeaveAndLateMin
	 */
	public String getTxtLeaveAndLateMin() {
		return txtLeaveAndLateMin;
	}
	
	/**
	 * @param txtLeaveAndLateHour Zbg txtLeaveAndLateHour
	 */
	public void setTxtLeaveAndLateHour(String txtLeaveAndLateHour) {
		this.txtLeaveAndLateHour = txtLeaveAndLateHour;
	}
	
	/**
	 * @param txtLeaveAndLateMin Zbg txtLeaveAndLateMin
	 */
	public void setTxtLeaveAndLateMin(String txtLeaveAndLateMin) {
		this.txtLeaveAndLateMin = txtLeaveAndLateMin;
	}
	
	/**
	 * @return useSubstitute
	 */
	public boolean isUseSubstitute() {
		return useSubstitute;
	}
	
	/**
	 * @return useHourHoliday
	 */
	public boolean isUseHourHoliday() {
		return useHourHoliday;
	}
	
	/**
	 * @return useOver60Hour
	 */
	public boolean isUseOver60Hour() {
		return useOver60Hour;
	}
	
	/**
	 * @param useSubstitute Zbg useSubstitute
	 */
	public void setUseSubstitute(boolean useSubstitute) {
		this.useSubstitute = useSubstitute;
	}
	
	/**
	 * @param useHourHoliday Zbg useHourHoliday
	 */
	public void setUseHourHoliday(boolean useHourHoliday) {
		this.useHourHoliday = useHourHoliday;
	}
	
	/**
	 * @param useOver60Hour Zbg useOver60Hour
	 */
	public void setUseOver60Hour(boolean useOver60Hour) {
		this.useOver60Hour = useOver60Hour;
	}
	
	/**
	 * @param afterReform Zbg afterReform
	 */
	public void setAfterReform(boolean afterReform) {
		this.afterReform = afterReform;
	}
	
	/**
	 * @return afterReform
	 */
	public boolean isAfterReform() {
		return afterReform;
	}
	
	/**
	 * @return isCaution
	 */
	public boolean isCaution() {
		return isCaution;
	}
	
	/**
	 * @return isWarning
	 */
	public boolean isWarning() {
		return isWarning;
	}
	
	/**
	 * @param isCaution Zbg isCaution
	 */
	public void setCaution(boolean isCaution) {
		this.isCaution = isCaution;
	}
	
	/**
	 * @param isWarning Zbg isWarning
	 */
	public void setWarning(boolean isWarning) {
		this.isWarning = isWarning;
	}
	
	/**
	 * @param lblAmendment Zbg lblAmendment
	 */
	public void setLblAmendment(String lblAmendment) {
		this.lblAmendment = lblAmendment;
	}
	
	/**
	 * @return lblAmendment
	 */
	public String getLblAmendment() {
		return lblAmendment;
	}
	
	/**
	 * @param hidYearMonth Zbg hidYearMonth
	 */
	public void setHidYearMonth(String hidYearMonth) {
		this.hidYearMonth = hidYearMonth;
	}
	
	/**
	 * @return hidYearMonth
	 */
	public String getHidYearMonth() {
		return hidYearMonth;
	}
	
	/**
	 * @return hourPaidHoliday
	 */
	public int getHourPaidHoliday() {
		return hourPaidHoliday;
	}
	
	/**
	 * @param hourPaidHoliday Zbg hourPaidHoliday
	 */
	public void setHourPaidHoliday(int hourPaidHoliday) {
		this.hourPaidHoliday = hourPaidHoliday;
	}
	
}
