/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.payroll.vo;

import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;

/**
 * @author yoshida
 *
 */
public class AttendanceCalculateMenuVo extends MosPVo {
	
	private static final long	serialVersionUID	= 1473050564230241352L;
	
	// tB[h
	private String[]			aryCmd;
	private String[]			aryName;
	

	/**
	 * RXgN^
	 */
	public AttendanceCalculateMenuVo() {
		super();
		setViewPath(getClassName());
		aryCmd = new String[0];
		aryName = new String[0];
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_ATT_CALCULATE_MENU;
		createAryMenu(CMD_MENU_PAYROLL);
	}
	
	@Override
	public void setFields(List<?> menuList) {
		aryCmd = (String[])menuList.get(0);
		aryName = (String[])menuList.get(1);
		for (int i = 0; i < aryCmd.length; i++) {
			aryCmd[i] = escapeHTML(aryCmd[i]);
			aryName[i] = escapeHTML(aryName[i]);
		}
	}
	
	// ANZT\bh
	/**
	 * @return aryCmd
	 */
	public String[] getEscAryCmd() {
		return aryCmd.clone();
	}
	
	/**
	 * @return aryName
	 */
	public String[] getEscAryName() {
		return aryName.clone();
	}
	
}
