/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.payroll.vo;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.MosPVo;
import jp.mosp.kintai.payroll.dto.MKintaiKeisanDto;

/**
 * @author yoshida
 *
 */
public class AttendanceCalculateEndCardVo extends MosPVo {
	
	private static final long	serialVersionUID	= 1473050564230241352L;
	
	// 萔
	/**
	 * 
	 */
	public static final int		MODE_UPDATE			= 0;
	/**
	 * 
	 */
	public static final int		MODE_IMPOSSIBLE		= 1;
	
	// tB[h
	private String				lblKTnen;
	private String				lblKTtuki;
	
	// [h(0FXVA1Fs)
	private int					mode;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_KT_YYMM_NAME;
	/**
	 * 
	 */
	public int					LEN_NEN;
	/**
	 * 
	 */
	public int					LEN_TUKI;
	

	/**
	 * RXgN^
	 */
	public AttendanceCalculateEndCardVo() {
		super();
		setViewPath(getClassName());
		mode = MODE_UPDATE;
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_ATT_CALCULATE_END;
		createAryMenu(CMD_MENU_PAYROLL, MosPMenuConst.getMenuAttendanceCalculate());
	}
	
	@Override
	protected void setFieldsName() {
		NAM_KT_YYMM_NAME = CommonConst.NAM_CONFIRM_ATTENDANCE + CommonConst.NAM_CALCULATE_TARGET + CommonConst.NAM_YEAR
				+ CommonConst.NAM_MONTH;
		LEN_NEN = CommonConst.LEN_YEAR;
		LEN_TUKI = CommonConst.LEN_MONTH_DAY;
	}
	
	/**
	 * lݒ
	 */
	public void setDefaultValues() {
		setLblKTnen("");
		setLblKTtuki("");
	}
	
	/**
	 * tB[hݒ
	 * @param dto [U[Xg
	 */
	public void setFields(MKintaiKeisanDto dto) {
		lblKTnen = String.valueOf(dto.getKTNen());
		lblKTtuki = String.valueOf(dto.getKTTuki());
	}
	
	@Override
	public String getDirectJs(Class<?> cls, Object obj) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls, obj));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}
	
	// ANZT\bh
	/**
	 * @return lblKTnen
	 */
	public String getEscLblKTnen() {
		return escapeHTML(lblKTnen);
	}
	
	/**
	 * @return lblKTtuki
	 */
	public String getEscLblKTtuki() {
		return escapeHTML(lblKTtuki);
	}
	
	/**
	 * @return lblKTnen
	 */
	public String getLblKTnen() {
		return lblKTnen;
	}
	
	/**
	 * @return lblKTtuki
	 */
	public String getLblKTtuki() {
		return lblKTtuki;
	}
	
	/**
	 * @return mode
	 */
	public int getMode() {
		return mode;
	}
	
	/**
	 * @param lblKTnen Zbg lblKTnen
	 */
	public void setLblKTnen(String lblKTnen) {
		this.lblKTnen = lblKTnen;
	}
	
	/**
	 * @param lblKTtuki Zbg lblKTtuki
	 */
	public void setLblKTtuki(String lblKTtuki) {
		this.lblKTtuki = lblKTtuki;
	}
	
	/**
	 * @param mode Zbg mode
	 */
	public void setMode(int mode) {
		this.mode = mode;
	}
	
}
