/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.payroll.dto;

import java.util.Date;

import jp.mosp.common.common.BaseDto;

/**
 * KD_PAID_HOLIDAY(LxǗe[u)DTONXB
 */
public class KdPaidHolidayDto extends BaseDto {
	
	/**
	 * 
	 */
	private static final long	serialVersionUID	= -4290289471384261474L;
	// tB[h
	private long				paidid				= 0;
	private String				kcode				= "";
	private String				processtype			= "";
	private Date				processdate			= null;
	private double				lastremaindays		= 0;
	private int					lastremainhour		= 0;
	private double				remaindays			= 0;
	private int					remainhour			= 0;
	private int					possible			= 0;
	private int					deleteflag			= 0;
	

	/**
	 * RXgN^B
	 */
	public KdPaidHolidayDto() {
		super();
	}
	
	// ANZT\bh
	/**
	 * @return paidid 	LxIDB
	 */
	public long getPaidId() {
		return paidid;
	}
	
	/**
	 * @return kcode 	ЈR[hB
	 */
	public String getKCode() {
		return kcode;
	}
	
	/**
	 * @return processtype 	R[hB
	 */
	public String getProcessType() {
		return processtype;
	}
	
	/**
	 * @return processdate 	xB
	 */
	public Date getProcessDate() {
		return (Date)processdate.clone();
	}
	
	/**
	 * @return lastremaindays 	ONxcB
	 */
	public double getLastRemainDays() {
		return lastremaindays;
	}
	
	/**
	 * @return lastremainhour 	ONxcԁB
	 */
	public int getLastRemainHour() {
		return lastremainhour;
	}
	
	/**
	 * @return remaindays 	NxcB
	 */
	public double getRemainDays() {
		return remaindays;
	}
	
	/**
	 * @return remainhour 	NxcԁB
	 */
	public int getRemainHour() {
		return remainhour;
	}
	
	/**
	 * @return possible 	ԒPʎ擾\B
	 */
	public int getPossible() {
		return possible;
	}
	
	/**
	 * @return deleteflag 	폜tOB
	 */
	public int getDeleteFlag() {
		return deleteflag;
	}
	
	/**
	 * @param paidid 	ZbgLxIDB
	 */
	public void setPaidId(long paidid) {
		this.paidid = paidid;
	}
	
	/**
	 * @param kcode 	ZbgЈR[hB
	 */
	public void setKCode(String kcode) {
		this.kcode = kcode;
	}
	
	/**
	 * @param processtype 	Zbg鏈R[hB
	 */
	public void setProcessType(String processtype) {
		this.processtype = processtype;
	}
	
	/**
	 * @param processdate 	ZbgxB
	 */
	public void setProcessDate(Date processdate) {
		this.processdate = (Date)processdate.clone();
	}
	
	/**
	 * @param lastremaindays 	ZbgONxcB
	 */
	public void setLastRemainDays(double lastremaindays) {
		this.lastremaindays = lastremaindays;
	}
	
	/**
	 * @param lastremainhour 	ZbgONxcԁB
	 */
	public void setLastRemainHour(int lastremainhour) {
		this.lastremainhour = lastremainhour;
	}
	
	/**
	 * @param remaindays 	Zbg鍡NxcB
	 */
	public void setRemainDays(double remaindays) {
		this.remaindays = remaindays;
	}
	
	/**
	 * @param remainhour 	Zbg鍡NxcԁB
	 */
	public void setRemainHour(int remainhour) {
		this.remainhour = remainhour;
	}
	
	/**
	 * @param possible 	Zbg鎞ԒPʎ擾\B
	 */
	public void setPossible(int possible) {
		this.possible = possible;
	}
	
	/**
	 * @param deleteflag 	Zbg폜tOB
	 */
	public void setDeleteFlag(int deleteflag) {
		this.deleteflag = deleteflag;
	}
	
}
