/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.payroll.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospException;
import jp.mosp.kintai.payroll.dto.MKintaiKinmuDto;

/**
 * M_KINTAIKINMU(ΑӋΖʏWv)DAONX B
 */
public class MKintaiKinmuDao extends BaseDao {
	
	// e[uyуL[
	/**
	 * M_KINTAIKINMU(ΑӋΖʏWv)B
	 */
	public static final String	TABLE		= "M_KINTAIKINMU";
	
	/**
	 * KEY_1 = KCODE(ЈR[h)B
	 */
	public static final String	KEY_1		= "KCODE";
	/**
	 * KEY_2 = SIKYUYM(xN)B
	 */
	public static final String	KEY_2		= "SIKYUYM";
	/**
	 * KEY_3 = KINMU(Ζ`)B
	 */
	public static final String	KEY_3		= "KINMU";
	
	// 
	/**
	 * KCODE(ЈR[h)B
	 */
	public static final String	COL_KCODE	= "KCODE";
	/**
	 * SIKYUYM(xN)B
	 */
	public static final String	COL_SIKYUYM	= "SIKYUYM";
	/**
	 * KINMU(Ζ`)B
	 */
	public static final String	COL_KINMU	= "KINMU";
	/**
	 * SNISSU(oΓ)B
	 */
	public static final String	COL_SNISSU	= "SNISSU";
	/**
	 * ZAJIKAN(ʎcƎ)B
	 */
	public static final String	COL_ZAJIKAN	= "ZAJIKAN";
	/**
	 * SZJIKAN([cƎ)B
	 */
	public static final String	COL_SZJIKAN	= "SZJIKAN";
	/**
	 * HSJIKAN(@xoΎ)B
	 */
	public static final String	COL_HSJIKAN	= "HSJIKAN";
	/**
	 * TSJIKAN(ʏoΎ)B
	 */
	public static final String	COL_TSJIKAN	= "TSJIKAN";
	/**
	 * SYOKUJI(H蓖x)B
	 */
	public static final String	COL_SYOKUJI	= "SYOKUJI";
	/**
	 * CYOKU1(1蓖x)B
	 */
	public static final String	COL_CYOKU1	= "CYOKU1";
	/**
	 * CYOKU2(2蓖x)B
	 */
	public static final String	COL_CYOKU2	= "CYOKU2";
	/**
	 * CYOKU3(3蓖x)B
	 */
	public static final String	COL_CYOKU3	= "CYOKU3";
	/**
	 * HOKA1(̑x1)B
	 */
	public static final String	COL_HOKA1	= "HOKA1";
	/**
	 * HOKA2(̑x2)B
	 */
	public static final String	COL_HOKA2	= "HOKA2";
	/**
	 * HOKA3(̑x3)B
	 */
	public static final String	COL_HOKA3	= "HOKA3";
	/**
	 * HOKA4(̑x4)B
	 */
	public static final String	COL_HOKA4	= "HOKA4";
	/**
	 * HOKA5(̑x5)B
	 */
	public static final String	COL_HOKA5	= "HOKA5";
	

	/**
	 * RXgN^
	 */
	public MKintaiKinmuDao() {
		super();
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException SQLOꍇ
	 */
	private List<MKintaiKinmuDto> mappingAll() throws SQLException {
		List<MKintaiKinmuDto> all = new ArrayList<MKintaiKinmuDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return m_kintaikinmuDto m_kintaikinmuR[h
	 * @throws SQLException SQLOꍇ
	 */
	private MKintaiKinmuDto mapping() throws SQLException {
		MKintaiKinmuDto dto = new MKintaiKinmuDto();
		dto.setKCode(rs.getString(COL_KCODE)); //ЈR[h
		dto.setSikyuYM(rs.getString(COL_SIKYUYM)); //xN
		dto.setKinmu(rs.getString(COL_KINMU)); //Ζ`
		dto.setSNissu(rs.getDouble(COL_SNISSU)); //oΓ
		dto.setZaJikan(rs.getInt(COL_ZAJIKAN)); //ʎcƎ
		dto.setSZJikan(rs.getInt(COL_SZJIKAN)); //[cƎ
		dto.setHSJikan(rs.getInt(COL_HSJIKAN)); //@xoΎ
		dto.setTSJikan(rs.getInt(COL_TSJIKAN)); //ʏoΎ
		dto.setSyokuji(rs.getInt(COL_SYOKUJI)); //H蓖x
		dto.setCyoku1(rs.getInt(COL_CYOKU1)); //1蓖x
		dto.setCyoku2(rs.getInt(COL_CYOKU2)); //2蓖x
		dto.setCyoku3(rs.getInt(COL_CYOKU3)); //3蓖x
		dto.setHoka1(rs.getInt(COL_HOKA1)); //̑x1
		dto.setHoka2(rs.getInt(COL_HOKA2)); //̑x2
		dto.setHoka3(rs.getInt(COL_HOKA3)); //̑x3
		dto.setHoka4(rs.getInt(COL_HOKA4)); //̑x4
		dto.setHoka5(rs.getInt(COL_HOKA5)); //̑x5
		return dto;
	}
	
	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public List<?> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾
	 * @param kcode ЈR[h(L[)
	 * @param sikyuym xN(L[)
	 * @param kinmu Ζ`(L[)
	 * @return m_kintaikinmuDto (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public MKintaiKinmuDto findForKey(String kcode, String sikyuym, String kinmu) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, kcode);
			setParam(index++, sikyuym);
			setParam(index++, kinmu);
			executeQuery();
			MKintaiKinmuDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾
	 * @param kcode ЈR[h(L[)
	 * @param sikyuym xN(L[)
	 * @param kinmu Ζ`(L[)
	 * @return m_kintaikinmuDto (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public MKintaiKinmuDto findForUpdate(String kcode, String sikyuym, String kinmu) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, kcode);
			setParam(index++, sikyuym);
			setParam(index++, kinmu);
			executeQuery();
			MKintaiKinmuDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾
	 * @param kcode ЈR[h(L[)
	 * @param sikyuym xN(L[)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public void findForUpdate(String kcode, String sikyuym) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_KCODE);
			sb.append(" = ? AND ");
			sb.append(COL_SIKYUYM);
			sb.append(" = ? ");
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getForUpdate());
			setParam(index++, kcode);
			setParam(index++, sikyuym);
			executeQuery();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾
	 * @param sikyuym xN(L[)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public void findForUpdate(String sikyuym) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_SIKYUYM);
			sb.append(" = ? ");
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getForUpdate());
			setParam(index++, sikyuym);
			executeQuery();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param kcode ЈR[h
	 * @param sikyuym xN
	 * @param kinmu Ζ`
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public List<?> findForCondition(String kcode, String sikyuym, String kinmu) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_KCODE);
		sb.append(" = ? AND ");
		sb.append(COL_SIKYUYM);
		sb.append(" = ? AND ");
		sb.append(COL_KINMU);
		sb.append(" = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, kcode);
			setParam(index++, sikyuym + "%");
			setParam(index++, "%" + kinmu + "%");
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param kcode ЈR[h
	 * @param sikyuym xN
	 * @return list (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public List<?> findForCondition(String kcode, String sikyuym) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_KCODE);
		sb.append(" = ? AND ");
		sb.append(COL_SIKYUYM);
		sb.append(" = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, kcode);
			setParam(index++, sikyuym);
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param sikyuym xN
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public List<?> findForCondition(String sikyuym) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_SIKYUYM);
		sb.append(" = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, sikyuym);
			executeQuery();
			List<?> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException  	MosPOꍇ
	 */
	public int insert(MKintaiKinmuDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}
	 * @param aryDto	}ΏDTO
	 * @return int }()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException  	MosPOꍇ
	 */
	public int insert(MKintaiKinmuDto[] aryDto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass(), aryDto.length, aryDto.length));
			for (MKintaiKinmuDto dto : aryDto) {
				setParams(dto, true);
			}
			executeUpdate();
			chkInsert(aryDto.length);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException  	MosPOꍇ
	 */
	public int update(MKintaiKinmuDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getKCode());
			setParam(index++, dto.getSikyuYM());
			setParam(index++, dto.getKinmu());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException  	MosPOꍇ
	 */
	public int delete(MKintaiKinmuDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getKCode());
			setParam(index++, dto.getSikyuYM());
			setParam(index++, dto.getKinmu());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜
	 * @param aryKcode XVΏKcode
	 * @param sikyuYM 폜Ώ۔N
	 * @return int 폜()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException  	MosPOꍇ
	 */
	public int delete(String[] aryKcode, String sikyuYM) throws SQLException, IllegalAccessException,
			NoSuchFieldException, MospException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("DELETE FROM ");
			sb.append(TABLE);
			sb.append(" WHERE (");
			int i = 0;
			while (i != aryKcode.length) {
				sb.append(COL_KCODE);
				sb.append(" = ? OR ");
				i++;
			}
			sb.delete(sb.length() - 4, sb.length());
			sb.append(") AND ");
			sb.append(COL_SIKYUYM);
			sb.append(" = ?");
			prepareStatement(sb.toString());
			for (String kCode : aryKcode) {
				setParam(index++, kCode);
			}
			setParam(index++, sikyuYM);
			executeUpdate();
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜
	 * @param sikyuYM	XVΏ۔N
	 * @return int 폜()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException  	MosPOꍇ
	 */
	public int delete(String sikyuYM) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("DELETE FROM ");
			sb.append(TABLE);
			sb.append(" ");
			sb.append("WHERE ");
			sb.append(COL_SIKYUYM);
			sb.append(" = ? ");
			prepareStatement(sb.toString());
			setParam(index++, sikyuYM);
			executeUpdate();
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜
	 * @param kCode XVЈR[h
	 * @param sikyuYM	XVΏ۔N
	 * @return int 폜()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException  	MosPOꍇ
	 */
	public int delete(String kCode, String sikyuYM) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("DELETE FROM ");
			sb.append(TABLE);
			sb.append(" ");
			sb.append("WHERE ");
			sb.append(COL_KCODE);
			sb.append(" = ? AND ");
			sb.append(COL_SIKYUYM);
			sb.append(" = ? ");
			prepareStatement(sb.toString());
			setParam(index++, kCode);
			setParam(index++, sikyuYM);
			executeUpdate();
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @param isInsert  }tO(trueF}AfalseFXV)
	 * @throws SQLException SQLOꍇ
	 */
	private void setParams(MKintaiKinmuDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getKCode()); //ЈR[h
		setParam(index++, dto.getSikyuYM()); //xN
		setParam(index++, dto.getKinmu()); //Ζ`
		setParam(index++, dto.getSNissu()); //oΓ
		setParam(index++, dto.getZaJikan()); //ʎcƎ
		setParam(index++, dto.getSZJikan()); //[cƎ
		setParam(index++, dto.getHSJikan()); //@xoΎ
		setParam(index++, dto.getTSJikan()); //ʏoΎ
		setParam(index++, dto.getSyokuji()); //H蓖x
		setParam(index++, dto.getCyoku1()); //1蓖x
		setParam(index++, dto.getCyoku2()); //2蓖x
		setParam(index++, dto.getCyoku3()); //3蓖x
		setParam(index++, dto.getHoka1()); //̑x1
		setParam(index++, dto.getHoka2()); //̑x2
		setParam(index++, dto.getHoka3()); //̑x3
		setParam(index++, dto.getHoka4()); //̑x4
		setParam(index++, dto.getHoka5()); //̑x5
		setCommonParams(isInsert);
	}
	
	/**
	 * e[ubN
	 * @param 	sikyuYM	XVΏ۔N
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public void tableLock(String sikyuYM) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			if (conn.getMetaData().getDatabaseProductName().equals("MySQL")) {
				// DBMySQL̏ꍇ͍sbN
				findForUpdate(sikyuYM);
			} else {
				// DBPostgreSQL̏ꍇ̓e[ubN
				StringBuffer sb = new StringBuffer();
				sb.append("LOCK TABLE ");
				sb.append(TABLE);
				prepareStatement(sb.toString());
				executeUpdate();
			}
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * e[ubN
	 * @param	kCode	ЈR[h
	 * @param 	sikyuYM	XVΏ۔N
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public void tableLock(String kCode, String sikyuYM) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			if (conn.getMetaData().getDatabaseProductName().equals("MySQL")) {
				// DBMySQL̏ꍇ͍sbN
				findForUpdate(kCode, sikyuYM);
			} else {
				// DBPostgreSQL̏ꍇ̓e[ubN
				StringBuffer sb = new StringBuffer();
				sb.append("LOCK TABLE ");
				sb.append(TABLE);
				prepareStatement(sb.toString());
				executeUpdate();
			}
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * e[ubN
	 * @param	aryKCode	ЈR[h
	 * @param 	sikyuYM		XVΏ۔N
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public void tableLock(String[] aryKCode, String sikyuYM) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			if (conn.getMetaData().getDatabaseProductName().equals("MySQL")) {
				// DBMySQL̏ꍇ͍sbN
				for (String element : aryKCode) {
					findForUpdate(element, sikyuYM);
				}
			} else {
				// DBPostgreSQL̏ꍇ̓e[ubN
				StringBuffer sb = new StringBuffer();
				sb.append("LOCK TABLE ");
				sb.append(TABLE);
				prepareStatement(sb.toString());
				executeUpdate();
			}
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
}
