/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.payroll.dao;

import java.sql.SQLException;

import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospConst;
import jp.mosp.kintai.common.dao.MKihonDao;
import jp.mosp.kintai.payroll.dto.CompileAmendmentDto;

/**
 * @author yoshida
 *
 */
public class CompileAmendmentDao extends BaseDao {
	
	// e[uyуL[
	/**
	 * 
	 */
	public static final String	HUMAN_TABLE		= MKihonDao.TABLE;
	/**
	 * 
	 */
	public static final String	OLD_TABLE		= MKintaiDao.TABLE;
	/**
	 * 
	 */
	public static final String	NEW_TABLE		= KdWorkDao.TABLE;
	
	// 
	/**
	 * 
	 */
	public static final String	COL_KCODE		= HUMAN_TABLE + "." + MKihonDao.COL_KCODE;
	/**
	 * 
	 */
	public static final String	COL_KNAME		= HUMAN_TABLE + "." + MKihonDao.COL_SIMEI;
	/**
	 * 
	 */
	public static final String	COL_SCODE		= HUMAN_TABLE + "." + MKihonDao.COL_SCODE;
	
	/**
	 * 
	 */
	public static final int		NUM_KCODE		= 1;
	/**
	 * 
	 */
	public static final int		NUM_KNAME		= 2;
	/**
	 * 
	 */
	public static final int		NUM_SCODE		= 3;
	/**
	 * 
	 */
	public static final int		NUM_S_NISSU		= 4;
	/**
	 * 
	 */
	public static final int		NUM_YUKYU		= 5;
	/**
	 * 
	 */
	public static final int		NUM_TOKUKYU		= 6;
	/**
	 * 
	 */
	public static final int		NUM_KEKKIN		= 7;
	/**
	 * 
	 */
	public static final int		NUM_KINMUJI		= 8;
	/**
	 * 
	 */
	public static final int		NUM_KYUKEIJI	= 9;
	/**
	 * 
	 */
	public static final int		NUM_TISOJIKAN	= 10;
	/**
	 * 
	 */
	public static final int		NUM_ZAJIKAN		= 11;
	/**
	 * 
	 */
	public static final int		NUM_KSJIKAN		= 12;
	/**
	 * 
	 */
	public static final int		NUM_SNJIKAN		= 13;
	

	/**
	 * RXgN^
	 */
	public CompileAmendmentDao() {
		super();
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return m_kintaiDto m_kintaiR[h
	 * @throws SQLException SQLOꍇ
	 */
	private CompileAmendmentDto mapping() throws SQLException {
		CompileAmendmentDto dto = new CompileAmendmentDto();
		dto.setKCode(rs.getString(NUM_KCODE));
		dto.setKName(rs.getString(NUM_KNAME));
		dto.setSCode(rs.getString(NUM_SCODE));
		dto.setSNissu(rs.getDouble(NUM_S_NISSU));
		dto.setYukyu(rs.getDouble(NUM_YUKYU));
		dto.setTokuKyu(rs.getDouble(NUM_TOKUKYU));
		dto.setKekkin(rs.getDouble(NUM_KEKKIN));
		dto.setKinmuJi(rs.getInt(NUM_KINMUJI));
		dto.setKyukeiJi(rs.getInt(NUM_KYUKEIJI));
		dto.setTisoJi(rs.getInt(NUM_TISOJIKAN));
		dto.setZaJikan(rs.getInt(NUM_ZAJIKAN));
		dto.setKsJikan(rs.getInt(NUM_KSJIKAN));
		dto.setSnJikan(rs.getInt(NUM_SNJIKAN));
		return dto;
	}
	
	/**
	 * ɂf[^擾
	 * @param kCode IЈR[h
	 * @param sikyuym IN
	 * @param sCode R[h
	 * @return DTO 
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public CompileAmendmentDto findForCondition(String kCode, String sikyuym, String sCode) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" SELECT ");
		sb.append(COL_KCODE + MospConst.DATA_SEPARATOR);
		sb.append(COL_KNAME + MospConst.DATA_SEPARATOR);
		sb.append(COL_SCODE + MospConst.DATA_SEPARATOR);
		sb.append(MKintaiDao.COL_SNISSU + MospConst.DATA_SEPARATOR);
		sb.append(OLD_TABLE + "." + MKintaiDao.COL_YUKYU + MospConst.DATA_SEPARATOR);
		sb.append(MKintaiDao.COL_TOKUKYU + MospConst.DATA_SEPARATOR);
		sb.append(MKintaiDao.COL_KEKKIN + MospConst.DATA_SEPARATOR);
		sb.append(MKintaiDao.COL_KINMUJI + MospConst.DATA_SEPARATOR);
		sb.append(MKintaiDao.COL_KYUKEIJI + MospConst.DATA_SEPARATOR);
		sb.append(MKintaiDao.COL_TIJIKAN + MospConst.DATA_SEPARATOR);
		sb.append(MKintaiDao.COL_ZAJIKAN + MospConst.DATA_SEPARATOR);
		sb.append(MKintaiDao.COL_KSJIKAN + MospConst.DATA_SEPARATOR);
		sb.append(MKintaiDao.COL_SNJIKAN);
		sb.append(" FROM ");
		sb.append(HUMAN_TABLE);
		sb.append(" LEFT JOIN ");
		sb.append(OLD_TABLE);
		sb.append(" ON ");
		sb.append(COL_KCODE);
		sb.append(" = ");
		sb.append(OLD_TABLE + "." + MKintaiDao.COL_KCODE);
		sb.append(" WHERE ");
		sb.append(OLD_TABLE + "." + MKintaiDao.COL_SIKYUYM);
		sb.append(" = ? ");
		sb.append(" AND ");
		sb.append(COL_SCODE);
		sb.append(" = ? ");
		sb.append(" AND ");
		sb.append(COL_KCODE);
		sb.append(" = ? ");
		try {
			prepareStatement(sb.toString());
			setParam(index++, sikyuym);
			if (!sCode.equals("")) {
				setParam(index++, sCode);
			}
			if (!kCode.equals("")) {
				setParam(index++, kCode);
			}
			executeQuery();
			CompileAmendmentDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param kCode IЈR[h
	 * @param sikyuym IN
	 * @param sCode R[h
	 * @return DTO 
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public CompileAmendmentDto findForNewTable(String kCode, String sikyuym, String sCode) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" SELECT ");
		sb.append(COL_KCODE + MospConst.DATA_SEPARATOR);
		sb.append(COL_KNAME + MospConst.DATA_SEPARATOR);
		sb.append(COL_SCODE + MospConst.DATA_SEPARATOR);
		sb.append(KdWorkDao.COL_S_NISSU + MospConst.DATA_SEPARATOR);
		sb.append(NEW_TABLE + "." + KdWorkDao.COL_YUKYU + MospConst.DATA_SEPARATOR);
		sb.append(KdWorkDao.COL_TOKUKYU + MospConst.DATA_SEPARATOR);
		sb.append(KdWorkDao.COL_KEKKIN + MospConst.DATA_SEPARATOR);
		sb.append(KdWorkDao.COL_KINMU_JI + MospConst.DATA_SEPARATOR);
		sb.append(KdWorkDao.COL_KYUKEI_JI + MospConst.DATA_SEPARATOR);
		sb.append(KdWorkDao.COL_TI_SO_JIKAN + MospConst.DATA_SEPARATOR);
		sb.append(KdWorkDao.COL_ZA_JIKAN + MospConst.DATA_SEPARATOR);
		sb.append(KdWorkDao.COL_KS_JIKAN + MospConst.DATA_SEPARATOR);
		sb.append(KdWorkDao.COL_SN_JIKAN);
		sb.append(" FROM ");
		sb.append(HUMAN_TABLE);
		sb.append(" LEFT JOIN ");
		sb.append(NEW_TABLE);
		sb.append(" ON ");
		sb.append(COL_KCODE);
		sb.append(" = ");
		sb.append(NEW_TABLE + "." + KdWorkDao.COL_K_CODE);
		sb.append(" WHERE ");
		sb.append(NEW_TABLE + "." + KdWorkDao.COL_SIKYU_YM);
		sb.append(" = ? ");
		sb.append(" AND ");
		sb.append(COL_SCODE);
		sb.append(" = ? ");
		sb.append(" AND ");
		sb.append(COL_KCODE);
		sb.append(" = ? ");
		try {
			prepareStatement(sb.toString());
			setParam(index++, sikyuym);
			setParam(index++, sCode);
			setParam(index++, kCode);
			executeQuery();
			CompileAmendmentDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
}
